/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.stream.network.core;

import com.dingtalk.open.app.stream.network.api.ClientConnectionListener;
import com.dingtalk.open.app.stream.network.api.Context;
import com.dingtalk.open.app.stream.network.api.EndPointConnection;
import com.dingtalk.open.app.stream.network.api.Session;
import com.dingtalk.open.app.stream.network.api.logger.InternalLogger;
import com.dingtalk.open.app.stream.network.api.logger.InternalLoggerFactory;
import com.dingtalk.open.app.stream.network.core.BackoffPolicy;
import com.dingtalk.open.app.stream.network.core.Connector;
import com.dingtalk.open.app.stream.network.core.EndPointConnectionFactory;
import com.dingtalk.open.app.stream.network.core.ExponentialBackoffPolicy;
import com.dingtalk.open.app.stream.network.core.SessionPool;
import com.dingtalk.open.app.stream.protocol.CommandType;
import com.dingtalk.open.app.stream.protocol.ProtocolRequestFacade;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import shade.io.netty.util.concurrent.DefaultThreadFactory;

public class DefaultSessionPool
implements SessionPool {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(DefaultSessionPool.class);
    private static final int MAX_RETRY_COUNT = 3;
    private static final int INTERVAL = 5000;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    private final AtomicBoolean status = new AtomicBoolean(true);
    private final int maxConnections;
    private final long connectionTimeout;
    private final long connectionTTL;
    private final EndPointConnectionFactory factory;
    private final ClientConnectionListener appListener;
    private final Long keepAliveIdle;

    public DefaultSessionPool(EndPointConnectionFactory factory, int maxConnections, long ttl, long connectionTimeout, long keepAliveIdle, ClientConnectionListener appListener) {
        this.factory = factory;
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new DefaultThreadFactory("connection-pool"));
        this.appListener = appListener;
        this.maxConnections = maxConnections;
        this.connectionTimeout = connectionTimeout;
        this.connectionTTL = ttl;
        this.keepAliveIdle = keepAliveIdle;
    }

    public void start() {
        this.scheduledExecutorService.scheduleAtFixedRate(new ConnectionTask(), 0L, 5000L, TimeUnit.MILLISECONDS);
    }

    private int available() {
        if (!this.status.get()) {
            return 0;
        }
        int available = 0;
        for (Map.Entry<String, Session> entry : this.sessions.entrySet()) {
            if (!entry.getValue().isActive() || entry.getValue().isGoAway()) continue;
            ++available;
        }
        return available;
    }

    private void closeSession(String connectionId) {
        if (connectionId == null) {
            return;
        }
        Session session = this.sessions.remove(connectionId);
        if (session != null && session.isActive()) {
            session.close();
        }
    }

    private void evict() {
        for (Map.Entry<String, Session> entry : this.sessions.entrySet()) {
            Session session = this.sessions.get(entry.getKey());
            if (!session.isExpired() && session.isActive()) continue;
            this.closeSession(session.getId());
        }
    }

    @Override
    public void shutdown() {
        if (this.status.compareAndSet(true, false)) {
            this.scheduledExecutorService.execute(() -> {
                for (String sessionId : this.sessions.keySet()) {
                    try {
                        this.closeSession(sessionId);
                    }
                    catch (Exception e) {
                        LOGGER.error("[DingTalk] close session failed, connectionId={}", sessionId, e);
                    }
                }
            });
            this.scheduledExecutorService.execute(this.scheduledExecutorService::shutdown);
        }
    }

    private boolean isActive() {
        return this.status.get();
    }

    private static class RetryRunner<T> {
        private final BackoffPolicy policy;
        private final AtomicInteger count;

        public RetryRunner(int max, BackoffPolicy policy) {
            this.policy = policy;
            this.count = new AtomicInteger(max);
        }

        public T run(Callable<T> callable) throws Exception {
            while (this.count.get() > 0) {
                this.count.decrementAndGet();
                try {
                    return callable.call();
                }
                catch (Exception e) {
                    LOGGER.error("[DingTalk] retrievable executor execute failed", e, new Object[0]);
                    if (this.count.get() <= 0) {
                        throw e;
                    }
                    try {
                        Thread.sleep(this.policy.next());
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            return null;
        }
    }

    private class ConnectionTask
    implements Runnable {
        private ConnectionTask() {
        }

        @Override
        public void run() {
            try {
                if (!DefaultSessionPool.this.isActive()) {
                    return;
                }
                DefaultSessionPool.this.evict();
                if (DefaultSessionPool.this.available() < DefaultSessionPool.this.maxConnections) {
                    Session session;
                    EndPointConnection connection = DefaultSessionPool.this.factory.openConnection();
                    Session previous = (Session)DefaultSessionPool.this.sessions.get(connection.getConnectionId());
                    if (previous != null) {
                        if (!previous.isExpired()) {
                            return;
                        }
                        DefaultSessionPool.this.closeSession(previous.getId());
                    }
                    if ((session = new RetryRunner<Session>(3, new ExponentialBackoffPolicy()).run(() -> Connector.connect(connection, new TransportConnectionListener(), DefaultSessionPool.this.connectionTimeout, DefaultSessionPool.this.connectionTTL, DefaultSessionPool.this.keepAliveIdle))) == null) {
                        return;
                    }
                    LOGGER.info("[DingTalk] connection is established, connectionId={}", session.getId());
                    previous = DefaultSessionPool.this.sessions.put(connection.getConnectionId(), session);
                    if (previous != null) {
                        previous.close();
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.error("[DingTalk] establish connection failed", e);
            }
        }
    }

    private class TransportConnectionListener
    implements ClientConnectionListener {
        private TransportConnectionListener() {
        }

        @Override
        public void receive(Context context) {
            this.onRequest(context.connectionId(), context.getRequest());
            DefaultSessionPool.this.appListener.receive(context);
        }

        @Override
        public void onDisConnection(String connectionId) {
            DefaultSessionPool.this.closeSession(connectionId);
            DefaultSessionPool.this.appListener.onDisConnection(connectionId);
        }

        private void onRequest(String connectionId, ProtocolRequestFacade request) {
            if (request == null || request.getType() == null || request.getTopic() == null) {
                return;
            }
            if (request.getType() == CommandType.SYSTEM && "disconnect".equals(request.getTopic())) {
                Session session = (Session)DefaultSessionPool.this.sessions.get(connectionId);
                if (session == null) {
                    return;
                }
                session.goAway();
                DefaultSessionPool.this.scheduledExecutorService.execute(new ConnectionTask());
            }
        }
    }
}

