/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.stream.network.ws;

import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import shade.io.netty.channel.Channel;
import shade.io.netty.channel.ChannelDuplexHandler;
import shade.io.netty.channel.ChannelHandlerContext;
import shade.io.netty.channel.ChannelPromise;
import shade.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import shade.io.netty.util.HashedWheelTimer;
import shade.io.netty.util.Timeout;

public class ProtocolConnectHandler
extends ChannelDuplexHandler {
    private static final HashedWheelTimer TIMER = new HashedWheelTimer();
    private Timeout timeout;
    private final CompletableFuture<Channel> future;
    private final Long connectTimeout;

    public ProtocolConnectHandler(CompletableFuture<Channel> future, Long connectTimeout) {
        this.connectTimeout = connectTimeout;
        this.future = future;
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE && this.timeout != null && !this.timeout.isExpired()) {
            this.timeout.cancel();
            this.future.complete(ctx.channel());
            ctx.pipeline().remove(ProtocolConnectHandler.class);
        }
        super.userEventTriggered(ctx, evt);
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.timeout = TIMER.newTimeout(t -> this.future.completeExceptionally(new TimeoutException("connect timeout")), this.connectTimeout, TimeUnit.MILLISECONDS);
        super.connect(ctx, remoteAddress, localAddress, promise);
    }
}

