/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.bonus.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.bonus.entity.OaBonusAuditEntity;
import com.bringspring.bonus.model.oabonusaudit.OaBonusAuditCrForm;
import com.bringspring.bonus.model.oabonusaudit.OaBonusAuditInfoVO;
import com.bringspring.bonus.model.oabonusaudit.OaBonusAuditUpForm;
import com.bringspring.bonus.service.OaBonusAuditService;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5956\u91d1\u5ba1\u6838\u6d41\u7a0b\u8868\uff08\u6279\u91cf\uff09"}, value="bonus")
@RequestMapping(value={"/api/bonus/OaBonusAudit"})
public class OaBonusAuditController {
    private static final Logger log = LoggerFactory.getLogger(OaBonusAuditController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private OaBonusAuditService oaBonusAuditService;

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaBonusAuditCrForm oaBonusAuditCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "694881901143477445";
        if (StrUtil.isNotBlank((CharSequence)oaBonusAuditCrForm.getFlowId())) {
            flowEngineId = oaBonusAuditCrForm.getFlowId();
        }
        String mainId = RandomUtil.uuId();
        oaBonusAuditCrForm.setId(mainId);
        this.oaBonusAuditService.insertInfo(oaBonusAuditCrForm);
        FlowUtil.saveOrSubmit((String)oaBonusAuditCrForm.getTaskId(), (String)flowEngineId, (String)oaBonusAuditCrForm.getTemplateId(), (String)mainId, (Object)((Object)oaBonusAuditCrForm), (Integer)oaBonusAuditCrForm.getStatus(), (String)oaBonusAuditCrForm.getBonusTitle());
        if (oaBonusAuditCrForm.getStatus() == 0) {
            return ActionResult.success((String)"\u6682\u5b58\u6210\u529f");
        }
        return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f");
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaBonusAuditUpForm oaBonusAuditUpForm) throws DataException {
        String flowEngineId = "694881901143477445";
        OaBonusAuditEntity entity = this.oaBonusAuditService.getInfo(id);
        if (entity != null) {
            this.oaBonusAuditService.editInfo(oaBonusAuditUpForm);
            try {
                FlowUtil.saveOrSubmit((String)oaBonusAuditUpForm.getTaskId(), (String)flowEngineId, (String)oaBonusAuditUpForm.getTemplateId(), (String)id, (Object)((Object)oaBonusAuditUpForm), (Integer)oaBonusAuditUpForm.getStatus(), (String)oaBonusAuditUpForm.getBonusTitle());
            }
            catch (WorkFlowException e) {
                throw new RuntimeException(e);
            }
            if (oaBonusAuditUpForm.getStatus() == 0) {
                return ActionResult.success((String)"\u6682\u5b58\u6210\u529f");
            }
            return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/init"})
    public ActionResult<OaBonusAuditInfoVO> init(@RequestBody @Valid OaBonusAuditCrForm oaBonusAuditCrForm) {
        OaBonusAuditInfoVO vo = this.oaBonusAuditService.initInfo(oaBonusAuditCrForm);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaBonusAuditInfoVO> info(@PathVariable(value="id") String id) {
        OaBonusAuditInfoVO vo = this.oaBonusAuditService.queryInfo(id);
        return ActionResult.success((Object)vo);
    }
}

