/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.bonus.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.bonus.entity.SaleBonusAuditEntity;
import com.bringspring.bonus.entity.SaleBonusSummaryEntity;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditCrForm;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditInfoVO;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditListVO;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditPagination;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditPaginationExportModel;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditSummaryDTO;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditUpForm;
import com.bringspring.bonus.service.SaleBonusAuditItemService;
import com.bringspring.bonus.service.SaleBonusAuditService;
import com.bringspring.bonus.service.SaleBonusSummaryService;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5956\u91d1\u5ba1\u6838\u4e1a\u52a1\u8868"}, value="bonus")
@RequestMapping(value={"/api/bonus/SaleBonusAudit"})
public class SaleBonusAuditController {
    private static final Logger log = LoggerFactory.getLogger(SaleBonusAuditController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SaleBonusAuditService saleBonusAuditService;
    @Autowired
    private SaleBonusAuditItemService saleBonusAuditItemService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private SaleBonusSummaryService saleBonusSummaryService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody SaleBonusAuditPagination saleBonusAuditPagination) throws IOException {
        List<SaleBonusAuditEntity> list = this.saleBonusAuditService.getList(saleBonusAuditPagination);
        List<SaleBonusAuditListVO> listVO = this.appendListVo(list, false);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)saleBonusAuditPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private List<SaleBonusAuditListVO> appendListVo(List<SaleBonusAuditEntity> list, boolean isExport) {
        List listVO = JsonUtil.getJsonToList(list, SaleBonusAuditListVO.class);
        for (SaleBonusAuditListVO vo : listVO) {
            SaleBonusSummaryEntity summary;
            vo.setContractTypeName(this.baseDataUtil.getDictName(vo.getContractType(), "contractType"));
            vo.setProductTypeName(this.crmProductCategoryService.getNameByIds(vo.getProductType()));
            if (StringUtils.isNotEmpty((String)vo.getCompanyId())) {
                vo.setCompanyName(this.organizeService.getInfo(vo.getCompanyId()).getShortName());
            }
            if (StringUtils.isNotEmpty((String)vo.getSalerCompanyId())) {
                vo.setSalerCompanyName(this.organizeService.getInfo(vo.getSalerCompanyId()).getShortName());
            }
            if (isExport) continue;
            if (StringUtils.isNotEmpty((String)vo.getFlowId())) {
                FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getFlowId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
                if (flowTaskEntity != null) {
                    vo.setFlowState(flowTaskEntity.getStatus());
                    vo.setFlowStateName(FlowTaskStatusEnum.getMessageByCode((Integer)flowTaskEntity.getStatus()));
                } else {
                    vo.setFlowState(-9);
                }
            } else {
                vo.setFlowState(0);
                vo.setFlowStateName(FlowTaskStatusEnum.getMessageByCode((Integer)vo.getFlowState()));
            }
            if (null == (summary = (SaleBonusSummaryEntity)this.saleBonusSummaryService.getById((Serializable)((Object)vo.getSummaryId())))) continue;
            vo.setLatestBonusId(summary.getLatestBonusId());
        }
        return listVO;
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(SaleBonusAuditPaginationExportModel saleBonusAuditPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)saleBonusAuditPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        SaleBonusAuditPagination saleBonusAuditPagination = (SaleBonusAuditPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)saleBonusAuditPaginationExportModel), SaleBonusAuditPagination.class));
        List<SaleBonusAuditEntity> list = this.saleBonusAuditService.getTypeList(saleBonusAuditPagination, saleBonusAuditPaginationExportModel.getDataType());
        List<SaleBonusAuditListVO> listVO = this.appendListVo(list, true);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)saleBonusAuditPaginationExportModel.getSelectKey()) ? saleBonusAuditPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block138: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "salerName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e", (Object)"salerName"));
                        continue block138;
                    }
                    case "departmentTreeName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u90e8\u95e8", (Object)"departmentTreeName"));
                        continue block138;
                    }
                    case "contractNo": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractNo"));
                        continue block138;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block138;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u5bf9\u8c61", (Object)"agentName"));
                        continue block138;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerName"));
                        continue block138;
                    }
                    case "contractAmount": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u91d1\u989d\uff08\u5143\uff09", (Object)"contractAmount"));
                        continue block138;
                    }
                    case "signDate": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u65e5\u671f", (Object)"signDate"));
                        continue block138;
                    }
                    case "contractTypeName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7c7b\u578b", (Object)"contractTypeName"));
                        continue block138;
                    }
                    case "projectNo": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u53f7", (Object)"projectNo"));
                        continue block138;
                    }
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName"));
                        continue block138;
                    }
                    case "projectAmount": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u91d1\u989d\uff08\u5143\uff09", (Object)"projectAmount"));
                        continue block138;
                    }
                    case "projectStartDate": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u5b9e\u65bd\u65e5\u671f", (Object)"projectStartDate"));
                        continue block138;
                    }
                    case "projectAcceptanceTime": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u9a8c\u6536\u65e5\u671f", (Object)"projectAcceptanceTime"));
                        continue block138;
                    }
                    case "contractReturnAmount": {
                        entitys.add(new ExcelExportEntity("\u7d2f\u8ba1\u5408\u540c\u56de\u6b3e\u91d1\u989d\uff08\u5143\uff09", (Object)"contractReturnAmount"));
                        continue block138;
                    }
                    case "contractReturnRatio": {
                        entitys.add(new ExcelExportEntity("\u7d2f\u8ba1\u5408\u540c\u56de\u6b3e\u6bd4\u4f8b\uff08%\uff09", (Object)"contractReturnRatio"));
                        continue block138;
                    }
                    case "contractReturnAmountAdd": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5408\u540c\u56de\u6b3e\u91d1\u989d\uff08\u5143\uff09", (Object)"contractReturnAmount"));
                        continue block138;
                    }
                    case "contractReturnRatioAdd": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5408\u540c\u56de\u6b3e\u6bd4\u4f8b\uff08%\uff09", (Object)"contractReturnRatio"));
                        continue block138;
                    }
                    case "projectReturnAmount": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u56de\u6b3e\u91d1\u989d\uff08\u5143\uff09", (Object)"projectReturnAmount"));
                        continue block138;
                    }
                    case "projectReturnRatio": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u56de\u6b3e\u6bd4\u4f8b\uff08%\uff09", (Object)"projectReturnRatio"));
                        continue block138;
                    }
                    case "latestReturnDate": {
                        entitys.add(new ExcelExportEntity("\u6700\u65b0\u56de\u6b3e\u65e5\u671f", (Object)"latestReturnDate"));
                        continue block138;
                    }
                    case "accountDate": {
                        entitys.add(new ExcelExportEntity("\u6838\u7b97\u65e5\u671f", (Object)"accountDate"));
                        continue block138;
                    }
                    case "payableAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5e94\u53d1\u7ee9\u6548\u603b\u8ba1\uff08\u5143\uff09", (Object)"payableAmount"));
                        continue block138;
                    }
                    case "payableBusinessAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5e94\u53d1\u4e1a\u52a1\u7ee9\u6548\uff08\u5143\uff09", (Object)"payableBusinessAmount"));
                        continue block138;
                    }
                    case "payableImplAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5e94\u53d1\u5b9e\u65bd\u7ee9\u6548\uff08\u5143\uff09", (Object)"payableImplAmount"));
                        continue block138;
                    }
                    case "payableDevAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5e94\u53d1\u7814\u53d1\u7ee9\u6548\uff08\u5143\uff09", (Object)"payableDevAmount"));
                        continue block138;
                    }
                    case "payableAfterSalesAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5e94\u53d1\u552e\u540e\u7ee9\u6548\uff08\u5143\uff09", (Object)"payableAfterSalesAmount"));
                        continue block138;
                    }
                    case "payablePreSalesAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5e94\u53d1\u552e\u524d\u7ee9\u6548\uff08\u5143\uff09", (Object)"payablePreSalesAmount"));
                        continue block138;
                    }
                    case "adjustAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u8c03\u63a7\u91d1\u989d\u603b\u8ba1\uff08\u5143\uff09", (Object)"adjustAmount"));
                        continue block138;
                    }
                    case "adjustBusinessAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u4e1a\u52a1\u8c03\u63a7\u91d1\u989d\uff08\u5143\uff09", (Object)"adjustBusinessAmount"));
                        continue block138;
                    }
                    case "adjustImplAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5b9e\u65bd\u8c03\u63a7\u91d1\u989d\uff08\u5143\uff09", (Object)"adjustImplAmount"));
                        continue block138;
                    }
                    case "adjustDevAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u7814\u53d1\u8c03\u63a7\u91d1\u989d\uff08\u5143\uff09", (Object)"adjustDevAmount"));
                        continue block138;
                    }
                    case "adjustAfterSalesAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u552e\u540e\u8c03\u63a7\u91d1\u989d\uff08\u5143\uff09", (Object)"adjustAfterSalesAmount"));
                        continue block138;
                    }
                    case "adjustPreSalesAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u552e\u524d\u8c03\u63a7\u91d1\u989d\uff08\u5143\uff09", (Object)"adjustPreSalesAmount"));
                        continue block138;
                    }
                    case "actualAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5b9e\u53d1\u7ee9\u6548\u603b\u8ba1\uff08\u5143\uff09", (Object)"actualAmount"));
                        continue block138;
                    }
                    case "actualRegionAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5b9e\u53d1\u533a\u57df\u7ee9\u6548\uff08\u5143\uff09", (Object)"actualRegionAmount"));
                        continue block138;
                    }
                    case "actualBusinessAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5b9e\u53d1\u4e1a\u52a1\u7ee9\u6548\uff08\u5143\uff09", (Object)"actualBusinessAmount"));
                        continue block138;
                    }
                    case "actualImplAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5b9e\u53d1\u5b9e\u65bd\u7ee9\u6548\uff08\u5143\uff09", (Object)"actualImplAmount"));
                        continue block138;
                    }
                    case "actualDevAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5b9e\u53d1\u7814\u53d1\u7ee9\u6548\uff08\u5143\uff09", (Object)"actualDevAmount"));
                        continue block138;
                    }
                    case "actualAfterSalesAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5b9e\u53d1\u552e\u540e\u7ee9\u6548\uff08\u5143\uff09", (Object)"actualAfterSalesAmount"));
                        continue block138;
                    }
                    case "actualPreSalesAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5b9e\u53d1\u552e\u524d\u7ee9\u6548\uff08\u5143\uff09", (Object)"actualPreSalesAmount"));
                        continue block138;
                    }
                    case "paidAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5df2\u53d1\u7ee9\u6548\u603b\u8ba1\uff08\u5143\uff09", (Object)"paidAmount"));
                        continue block138;
                    }
                    case "paidBusinessAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5df2\u53d1\u4e1a\u52a1\u7ee9\u6548\uff08\u5143\uff09", (Object)"paidBusinessAmount"));
                        continue block138;
                    }
                    case "paidImplAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5df2\u53d1\u5b9e\u65bd\u7ee9\u6548\uff08\u5143\uff09", (Object)"paidImplAmount"));
                        continue block138;
                    }
                    case "paidDevAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5df2\u53d1\u7814\u53d1\u7ee9\u6548\uff08\u5143\uff09", (Object)"paidDevAmount"));
                        continue block138;
                    }
                    case "paidAfterSalesAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5df2\u53d1\u552e\u540e\u7ee9\u6548\uff08\u5143\uff09", (Object)"paidAfterSalesAmount"));
                        continue block138;
                    }
                    case "paidPreSalesAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5df2\u53d1\u552e\u524d\u7ee9\u6548\uff08\u5143\uff09", (Object)"paidPreSalesAmount"));
                        continue block138;
                    }
                    case "pendingAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5f85\u53d1\u7ee9\u6548\u603b\u8ba1\uff08\u5143\uff09", (Object)"pendingAmount"));
                        continue block138;
                    }
                    case "pendingBusinessAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5f85\u53d1\u4e1a\u52a1\u7ee9\u6548\uff08\u5143\uff09", (Object)"pendingBusinessAmount"));
                        continue block138;
                    }
                    case "pendingImplAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5f85\u53d1\u5b9e\u65bd\u7ee9\u6548\uff08\u5143\uff09", (Object)"pendingImplAmount"));
                        continue block138;
                    }
                    case "pendingDevAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5f85\u53d1\u7814\u53d1\u7ee9\u6548\uff08\u5143\uff09", (Object)"pendingDevAmount"));
                        continue block138;
                    }
                    case "pendingAfterSalesAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5f85\u53d1\u552e\u540e\u7ee9\u6548\uff08\u5143\uff09", (Object)"pendingAfterSalesAmount"));
                        continue block138;
                    }
                    case "pendingPreSalesAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u671f\u5f85\u53d1\u552e\u524d\u7ee9\u6548\uff08\u5143\uff09", (Object)"pendingPreSalesAmount"));
                        continue block138;
                    }
                    case "statusName": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"statusName"));
                        continue block138;
                    }
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block138;
                    }
                    case "salerCompanyName": {
                        entitys.add(new ExcelExportEntity("\u8425\u9500\u5e73\u53f0", (Object)"salerCompanyName"));
                        continue block138;
                    }
                    case "validContractAmount": {
                        entitys.add(new ExcelExportEntity("\u6709\u6548\u5408\u540c\u91d1\u989d\uff08\u5143\uff09", (Object)"validContractAmount"));
                        continue block138;
                    }
                    case "contractProfit": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u6bdb\u5229\uff08\u5143\uff09", (Object)"contractProfit"));
                        continue block138;
                    }
                    case "contractProfitRate": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u6bdb\u5229\u7387\uff08%\uff09", (Object)"contractProfitRate"));
                        continue block138;
                    }
                    case "thirdAmount": {
                        entitys.add(new ExcelExportEntity("\u7b2c\u4e09\u65b9\u91d1\u989d\uff08\u5143\uff09", (Object)"thirdAmount"));
                        continue block138;
                    }
                    case "totalRegionAmount": {
                        entitys.add(new ExcelExportEntity("\u533a\u57df\u7ee9\u6548\uff08\u5143\uff09", (Object)"totalRegionAmount"));
                        continue block138;
                    }
                    case "totalBusinessAmount": {
                        entitys.add(new ExcelExportEntity("\u4e1a\u52a1\u7ee9\u6548\uff08\u5143\uff09", (Object)"totalBusinessAmount"));
                        continue block138;
                    }
                    case "productTypeName": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5927\u7c7b", (Object)"productTypeName"));
                        continue block138;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<SaleBonusAuditInfoVO> info(@PathVariable(value="id") String id) {
        SaleBonusAuditInfoVO vo = this.saleBonusAuditService.queryInfo(id);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid SaleBonusAuditUpForm saleBonusAuditUpForm) throws DataException {
        return ActionResult.success((String)"\u6682\u5b58\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) throws DataException {
        SaleBonusAuditEntity entity = this.saleBonusAuditService.getInfo(id);
        if (entity != null) {
            this.saleBonusAuditItemService.removeByBonusId(id);
            this.saleBonusAuditService.delete(entity);
            this.saleBonusSummaryService.summaryAfterDel(entity);
        }
        return ActionResult.success((String)"\u53d6\u6d88\u6210\u529f");
    }

    @PostMapping(value={"/accountBonus"})
    public ActionResult accountBonus(@RequestBody SaleBonusAuditCrForm bonusAuditCrForm) {
        this.saleBonusAuditService.accountBonus(bonusAuditCrForm);
        return ActionResult.success((String)"\u6838\u7b97\u6210\u529f");
    }

    @PostMapping(value={"/countData"})
    public ActionResult countData(@RequestBody SaleBonusAuditPagination saleBonusAuditPagination) throws IOException {
        SaleBonusAuditSummaryDTO summary = this.saleBonusAuditService.countData(saleBonusAuditPagination);
        return ActionResult.success((Object)summary);
    }
}

