/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.bonus.controller;

import com.bringspring.bonus.entity.SaleBonusAuditItemEntity;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditSummaryDTO;
import com.bringspring.bonus.model.salebonusaudititem.SaleBonusAuditItemModel;
import com.bringspring.bonus.model.salebonusaudititem.SaleBonusAuditItemPagination;
import com.bringspring.bonus.service.SaleBonusAuditItemService;
import com.bringspring.bonus.service.SaleBonusSummaryService;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.model.rkcontract.RkContractListVO;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectListVO;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5956\u91d1\u6c47\u603b\u8868"}, value="bonus")
@RequestMapping(value={"/api/bonus/SaleBonusAuditItem"})
public class SaleBonusAuditItemController {
    private static final Logger log = LoggerFactory.getLogger(SaleBonusAuditItemController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SaleContractCustomerService saleContractCustomerService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private SaleBonusSummaryService saleBonusSummaryService;
    @Autowired
    private SaleBonusAuditItemService saleBonusAuditItemService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody SaleBonusAuditItemPagination saleBonusAuditItemPagination) throws IOException {
        List<SaleBonusAuditItemEntity> list = this.saleBonusAuditItemService.getList(saleBonusAuditItemPagination);
        List<SaleBonusAuditItemModel> listVO = this.appendListVo(list, false);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)saleBonusAuditItemPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private List<SaleBonusAuditItemModel> appendListVo(List<SaleBonusAuditItemEntity> list, boolean isExport) {
        List listVO = JsonUtil.getJsonToList(list, SaleBonusAuditItemModel.class);
        for (SaleBonusAuditItemModel vo : listVO) {
            vo.setBonusTypeName(this.baseDataUtil.getDictName(vo.getBonusType(), "bonusType"));
            vo.setContractTypeName(this.baseDataUtil.getDictName(vo.getContractType(), "contractType"));
            if (!StringUtils.isNotEmpty((String)vo.getCompanyId())) continue;
            vo.setCompanyName(this.organizeService.getInfo(vo.getCompanyId()).getShortName());
        }
        return listVO;
    }

    @PostMapping(value={"/getNotAccountContractList"})
    public ActionResult getNotAccountContractList(@RequestBody SaleBonusAuditItemPagination saleBonusAuditItemPagination) throws IOException {
        List<RkContractEntity> list = this.saleBonusAuditItemService.getNotAccountContractList(saleBonusAuditItemPagination);
        List listVO = JsonUtil.getJsonToList(list, RkContractListVO.class);
        for (RkContractListVO vo : listVO) {
            vo.setContractTypeName(this.baseDataUtil.getDictName(vo.getContractType(), "contractType"));
            if (StringUtils.isNotEmpty((String)vo.getCompanyId())) {
                vo.setCompanyName(this.organizeService.getInfo(vo.getCompanyId()).getShortName());
            }
            if (!StringUtils.isNotEmpty((String)vo.getCustomerIds())) continue;
            vo.setCustomerNames(this.saleContractCustomerService.getCustomerNamesByContractId(vo.getId()));
            vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)saleBonusAuditItemPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getNotAccountList"})
    public ActionResult getNotAccountList(@RequestBody SaleBonusAuditItemPagination saleBonusAuditItemPagination) throws IOException {
        List<RkContractProjectEntity> list = this.saleBonusAuditItemService.getNotAccountList(saleBonusAuditItemPagination);
        List listVO = JsonUtil.getJsonToList(list, RkContractProjectListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)saleBonusAuditItemPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/countData"})
    public ActionResult countData(@RequestBody SaleBonusAuditItemPagination saleBonusAuditItemPagination) throws IOException {
        SaleBonusAuditSummaryDTO summary = this.saleBonusAuditItemService.countData(saleBonusAuditItemPagination);
        return ActionResult.success((Object)summary);
    }

    @PostMapping(value={"/getSummaryList"})
    public ActionResult getSummaryList(@RequestBody SaleBonusAuditItemPagination saleBonusAuditItemPagination) throws IOException {
        List<SaleBonusAuditItemModel> listVO = this.saleBonusAuditItemService.getSummaryList(saleBonusAuditItemPagination);
        for (SaleBonusAuditItemModel vo : listVO) {
            vo.setBonusTypeName(this.baseDataUtil.getDictName(vo.getBonusType(), "bonusType"));
            vo.setContractTypeName(this.baseDataUtil.getDictName(vo.getContractType(), "contractType"));
            if (!StringUtils.isNotEmpty((String)vo.getCompanyId())) continue;
            vo.setCompanyName(this.organizeService.getInfo(vo.getCompanyId()).getShortName());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)saleBonusAuditItemPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/countSummaryData"})
    public ActionResult countSummaryData(@RequestBody SaleBonusAuditItemPagination saleBonusAuditItemPagination) throws IOException {
        SaleBonusAuditSummaryDTO summary = this.saleBonusAuditItemService.countSummaryData(saleBonusAuditItemPagination);
        return ActionResult.success((Object)summary);
    }
}

