/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.bonus.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.bonus.entity.SaleBonusBatchEntity;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditSummaryDTO;
import com.bringspring.bonus.model.salebonusaudititem.SaleBonusAuditItemModel;
import com.bringspring.bonus.model.salebonusaudititem.SaleBonusAuditItemPagination;
import com.bringspring.bonus.model.salebonusbatch.SaleBonusBatchCrForm;
import com.bringspring.bonus.model.salebonusbatch.SaleBonusBatchInfoVO;
import com.bringspring.bonus.model.salebonusbatch.SaleBonusBatchListVO;
import com.bringspring.bonus.model.salebonusbatch.SaleBonusBatchPagination;
import com.bringspring.bonus.model.salebonusbatch.SaleBonusBatchPaginationExportModel;
import com.bringspring.bonus.model.salebonusbatch.SaleBonusBatchUpForm;
import com.bringspring.bonus.service.SaleBonusAuditItemService;
import com.bringspring.bonus.service.SaleBonusAuditService;
import com.bringspring.bonus.service.SaleBonusBatchService;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5956\u91d1\u53d1\u653e\u6279\u6b21\u5ba1\u6838"}, value="bonus")
@RequestMapping(value={"/api/bonus/SaleBonusBatch"})
public class SaleBonusBatchController {
    private static final Logger log = LoggerFactory.getLogger(SaleBonusBatchController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SaleBonusBatchService saleBonusBatchService;
    @Autowired
    private SaleBonusAuditService saleBonusAuditService;
    @Autowired
    private SaleBonusAuditItemService saleBonusAuditItemService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody SaleBonusBatchPagination saleBonusBatchPagination) throws IOException {
        List<SaleBonusBatchEntity> list = this.saleBonusBatchService.getList(saleBonusBatchPagination);
        List<SaleBonusBatchListVO> listVO = this.appendListVo(list, false);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)saleBonusBatchPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private List<SaleBonusBatchListVO> appendListVo(List<SaleBonusBatchEntity> list, boolean isExport) {
        List listVO = JsonUtil.getJsonToList(list, SaleBonusBatchListVO.class);
        for (SaleBonusBatchListVO vo : listVO) {
            vo.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
            vo.setBonusAuditCount(this.saleBonusBatchService.countAuditNum(vo.getId()));
            if (isExport) continue;
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                vo.setFlowStateName(FlowTaskStatusEnum.getMessageByCode((Integer)flowTaskEntity.getStatus()));
                continue;
            }
            vo.setFlowState(null);
        }
        return listVO;
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid SaleBonusBatchCrForm saleBonusBatchCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "698060852829446853";
        if (StrUtil.isNotBlank((CharSequence)saleBonusBatchCrForm.getFlowId())) {
            flowEngineId = saleBonusBatchCrForm.getFlowId();
        }
        String mainId = RandomUtil.uuId();
        saleBonusBatchCrForm.setId(mainId);
        this.saleBonusBatchService.insertInfo(saleBonusBatchCrForm);
        FlowUtil.saveOrSubmit((String)saleBonusBatchCrForm.getTaskId(), (String)flowEngineId, (String)saleBonusBatchCrForm.getTemplateId(), (String)mainId, (Object)((Object)saleBonusBatchCrForm), (Integer)saleBonusBatchCrForm.getStatus(), (String)saleBonusBatchCrForm.getBatchTitle());
        if (saleBonusBatchCrForm.getStatus() == 0) {
            return ActionResult.success((String)"\u6682\u5b58\u6210\u529f");
        }
        return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<SaleBonusBatchInfoVO> info(@PathVariable(value="id") String id) {
        SaleBonusBatchInfoVO vo = this.saleBonusBatchService.queryInfo(id);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<SaleBonusBatchInfoVO> detailInfo(@PathVariable(value="id") String id) {
        SaleBonusBatchEntity entity = this.saleBonusBatchService.getInfo(id);
        SaleBonusBatchInfoVO vo = (SaleBonusBatchInfoVO)JsonUtil.getJsonToBean((Object)entity, SaleBonusBatchInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid SaleBonusBatchUpForm saleBonusBatchUpForm) throws DataException {
        String flowEngineId = "698060852829446853";
        SaleBonusBatchEntity entity = this.saleBonusBatchService.getInfo(id);
        if (entity != null) {
            this.saleBonusBatchService.editInfo(saleBonusBatchUpForm);
            try {
                FlowUtil.saveOrSubmit((String)saleBonusBatchUpForm.getTaskId(), (String)flowEngineId, (String)saleBonusBatchUpForm.getTemplateId(), (String)id, (Object)((Object)saleBonusBatchUpForm), (Integer)saleBonusBatchUpForm.getStatus(), (String)saleBonusBatchUpForm.getBatchTitle());
            }
            catch (WorkFlowException e) {
                throw new RuntimeException(e);
            }
            if (saleBonusBatchUpForm.getStatus() == 0) {
                return ActionResult.success((String)"\u6682\u5b58\u6210\u529f");
            }
            return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        SaleBonusBatchEntity entity = this.saleBonusBatchService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.saleBonusBatchService.releaseBonus(id);
            this.saleBonusBatchService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/countData"})
    public ActionResult countData(@RequestBody SaleBonusBatchPagination saleBonusBatchPagination) throws IOException {
        SaleBonusAuditSummaryDTO summary = this.saleBonusBatchService.countData(saleBonusBatchPagination);
        return ActionResult.success((Object)summary);
    }

    @PostMapping(value={"/summaryByUser"})
    public ActionResult summaryByUser(@RequestBody SaleBonusAuditItemPagination saleBonusAuditItemPagination) throws IOException {
        List<SaleBonusAuditItemModel> summaryList = this.saleBonusAuditItemService.summaryGroupByUser(saleBonusAuditItemPagination);
        SaleBonusBatchInfoVO vo = new SaleBonusBatchInfoVO();
        vo.setBonusSummaryList(summaryList);
        SaleBonusAuditItemModel model = this.saleBonusAuditItemService.summaryData(saleBonusAuditItemPagination);
        BeanUtils.copyProperties((Object)model, (Object)vo);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(SaleBonusBatchPaginationExportModel saleBonusBatchPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)saleBonusBatchPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        SaleBonusBatchPagination saleBonusBatchPagination = (SaleBonusBatchPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)saleBonusBatchPaginationExportModel), SaleBonusBatchPagination.class));
        List<SaleBonusBatchEntity> list = this.saleBonusBatchService.getTypeList(saleBonusBatchPagination, saleBonusBatchPaginationExportModel.getDataType());
        List<SaleBonusBatchListVO> listVO = this.appendListVo(list, true);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)saleBonusBatchPaginationExportModel.getSelectKey()) ? saleBonusBatchPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block30: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "batchTitle": {
                        entitys.add(new ExcelExportEntity("\u7ee9\u6548\u6279\u6b21", (Object)"batchTitle"));
                        continue block30;
                    }
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block30;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u6279\u6b21\u63cf\u8ff0", (Object)"description"));
                        continue block30;
                    }
                    case "bonusAuditCount": {
                        entitys.add(new ExcelExportEntity("\u7ee9\u6548\u5ba1\u6838\u6570\u91cf", (Object)"bonusAuditCount"));
                        continue block30;
                    }
                    case "actualAmount": {
                        entitys.add(new ExcelExportEntity("\u5e94\u53d1\u7ee9\u6548\uff08\u5143\uff09", (Object)"actualAmount"));
                        continue block30;
                    }
                    case "paidAmount": {
                        entitys.add(new ExcelExportEntity("\u5df2\u53d1\u7ee9\u6548\uff08\u5143\uff09", (Object)"paidAmount"));
                        continue block30;
                    }
                    case "pendingAmount": {
                        entitys.add(new ExcelExportEntity("\u5f85\u53d1\u7ee9\u6548\uff08\u5143\uff09", (Object)"pendingAmount"));
                        continue block30;
                    }
                    case "creatorUserName": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u4eba", (Object)"creatorUserName"));
                        continue block30;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block30;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

