/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.bonus.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.bonus.entity.OaBonusAuditEntity;
import com.bringspring.bonus.entity.SaleBonusAuditEntity;
import com.bringspring.bonus.entity.SaleBonusAuditItemEntity;
import com.bringspring.bonus.mapper.OaBonusAuditMapper;
import com.bringspring.bonus.model.oabonusaudit.OaBonusAuditCrForm;
import com.bringspring.bonus.model.oabonusaudit.OaBonusAuditInfoVO;
import com.bringspring.bonus.model.oabonusaudit.OaBonusAuditUpForm;
import com.bringspring.bonus.model.salebonusaudit.ReturnAmountDTO;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditCrForm;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditInfoVO;
import com.bringspring.bonus.model.salebonusaudititem.SaleBonusAuditItemModel;
import com.bringspring.bonus.service.OaBonusAuditService;
import com.bringspring.bonus.service.SaleBonusAuditItemService;
import com.bringspring.bonus.service.SaleBonusAuditService;
import com.bringspring.bonus.service.SaleBonusSummaryService;
import com.bringspring.bonus.util.BonusAuditStatusEnum;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.annotation.FlowCallBackMethod;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="oaSaleBonusAuditServiceImpl")
public class OaBonusAuditServiceImpl
extends ServiceImpl<OaBonusAuditMapper, OaBonusAuditEntity>
implements OaBonusAuditService {
    @Autowired
    private SaleBonusAuditService saleBonusAuditService;
    @Autowired
    private SaleBonusAuditItemService saleBonusAuditItemService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private SaleBonusSummaryService saleBonusSummaryService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;

    @Override
    public void insertInfo(OaBonusAuditCrForm oaBonusAuditCrForm) {
        OaBonusAuditEntity entity = (OaBonusAuditEntity)JsonUtil.getJsonToBean((Object)((Object)oaBonusAuditCrForm), OaBonusAuditEntity.class);
        this.save(entity);
        List<SaleBonusAuditCrForm> bonusCrList = oaBonusAuditCrForm.getBonusList();
        List<SaleBonusAuditItemEntity> bonusUserList = null;
        ArrayList<String> bonusIds = new ArrayList<String>();
        for (SaleBonusAuditCrForm bonusCr : bonusCrList) {
            bonusCr.setFlowId(entity.getId());
            this.saleBonusAuditItemService.removeByBonusId(bonusCr.getId());
            bonusUserList = bonusCr.getBonusAuditItemList();
            if (CollectionUtil.isNotEmpty(bonusUserList)) {
                for (SaleBonusAuditItemEntity bonusUser : bonusUserList) {
                    if (StrUtil.isEmpty((CharSequence)bonusUser.getId())) {
                        bonusUser.setId(RandomUtil.uuId());
                    }
                    bonusUser.setBonusId(bonusCr.getId());
                }
                this.saleBonusAuditItemService.saveBatch(bonusUserList);
            }
            SaleBonusAuditEntity bonus = (SaleBonusAuditEntity)JsonUtil.getJsonToBean((Object)bonusCr, SaleBonusAuditEntity.class);
            this.saleBonusAuditService.updateById(bonus);
            bonusIds.add(bonus.getId());
        }
        this.saleBonusSummaryService.updateSummaryData(bonusIds);
        List<RkAttachmentEntity> attachmentList = oaBonusAuditCrForm.getAttachmentList();
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            attachmentList.stream().forEach(attach -> {
                attach.setId(RandomUtil.uuId());
                attach.setObjId(entity.getId());
                attach.setFileType(AttachmentTypeEnum.BONUS_AUDIT_TYPE.getType());
            });
            this.rkAttachmentService.saveBatch(attachmentList);
        }
    }

    @Override
    public void editInfo(OaBonusAuditUpForm oaBonusAuditUpForm) {
        OaBonusAuditEntity entity = (OaBonusAuditEntity)JsonUtil.getJsonToBean((Object)((Object)oaBonusAuditUpForm), OaBonusAuditEntity.class);
        this.updateById(entity);
        List<SaleBonusAuditCrForm> bonusCrList = oaBonusAuditUpForm.getBonusList();
        List<SaleBonusAuditItemEntity> bonusUserList = null;
        ArrayList<String> bonusIds = new ArrayList<String>();
        for (SaleBonusAuditCrForm bonusCr : bonusCrList) {
            bonusCr.setFlowId(entity.getId());
            this.saleBonusAuditItemService.removeByBonusId(bonusCr.getId());
            bonusUserList = bonusCr.getBonusAuditItemList();
            if (CollectionUtil.isNotEmpty(bonusUserList)) {
                for (SaleBonusAuditItemEntity bonusUser : bonusUserList) {
                    if (StrUtil.isEmpty((CharSequence)bonusUser.getId())) {
                        bonusUser.setId(RandomUtil.uuId());
                    }
                    bonusUser.setBonusId(bonusCr.getId());
                }
                this.saleBonusAuditItemService.saveBatch(bonusUserList);
            }
            SaleBonusAuditEntity bonus = (SaleBonusAuditEntity)JsonUtil.getJsonToBean((Object)bonusCr, SaleBonusAuditEntity.class);
            this.saleBonusAuditService.updateById(bonus);
            bonusIds.add(bonus.getId());
        }
        this.saleBonusSummaryService.updateSummaryData(bonusIds);
        this.rkAttachmentService.deleteByObjId(oaBonusAuditUpForm.getId());
        List<RkAttachmentEntity> attachmentList = oaBonusAuditUpForm.getAttachmentList();
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            attachmentList.stream().forEach(attach -> {
                attach.setId(RandomUtil.uuId());
                attach.setObjId(entity.getId());
                attach.setFileType(AttachmentTypeEnum.BONUS_AUDIT_TYPE.getType());
            });
            this.rkAttachmentService.saveBatch(attachmentList);
        }
    }

    @Override
    public OaBonusAuditInfoVO initInfo(OaBonusAuditCrForm oaBonusAuditCrForm) {
        List<SaleBonusAuditEntity> bonusList;
        OaBonusAuditInfoVO vo = new OaBonusAuditInfoVO();
        if (CollectionUtil.isNotEmpty(oaBonusAuditCrForm.getBonusId()) && CollectionUtil.isNotEmpty(bonusList = this.saleBonusAuditService.queryListByIds(oaBonusAuditCrForm.getBonusId()))) {
            this.fillBonusListVO(vo, bonusList);
        }
        vo.setAttachmentList(new ArrayList<RkAttachmentEntity>());
        return vo;
    }

    @Override
    public OaBonusAuditInfoVO queryInfo(String id) {
        OaBonusAuditEntity entity = this.getInfo(id);
        OaBonusAuditInfoVO vo = (OaBonusAuditInfoVO)JsonUtil.getJsonToBean((Object)entity, OaBonusAuditInfoVO.class);
        List<SaleBonusAuditEntity> bonusList = this.saleBonusAuditService.queryListByFlowId(entity.getId());
        if (CollectionUtil.isNotEmpty(bonusList)) {
            this.fillBonusListVO(vo, bonusList);
        }
        List<RkAttachmentEntity> attachmentList = this.rkAttachmentService.getListByObjId(id);
        vo.setAttachmentList(attachmentList);
        return vo;
    }

    private void fillBonusListVO(OaBonusAuditInfoVO vo, List<SaleBonusAuditEntity> bonusList) {
        List bonusVOList = JsonUtil.getJsonToList(bonusList, SaleBonusAuditInfoVO.class);
        for (SaleBonusAuditInfoVO bonus : bonusVOList) {
            bonus.setContractTypeName(this.baseDataUtil.getDictName(bonus.getContractType(), "contractType"));
            bonus.setProductTypeName(this.crmProductCategoryService.getNameByIds(bonus.getProductType()));
            List<SaleBonusAuditItemEntity> auditItemEntities = this.saleBonusAuditItemService.queryByBonusId(bonus.getId());
            List bonusItemList = JsonUtil.getJsonToList(auditItemEntities, SaleBonusAuditItemModel.class);
            for (SaleBonusAuditItemModel bonusItem : bonusItemList) {
                bonusItem.setBonusTypeName(this.baseDataUtil.getDictName(bonusItem.getBonusType(), "bonusType"));
            }
            bonus.setBonusAuditItemList(bonusItemList);
            if (!StringUtils.isNotEmpty((String)bonus.getReturnAmountJson())) continue;
            List returnAmountList = JSONArray.parseArray((String)bonus.getReturnAmountJson(), ReturnAmountDTO.class);
            for (ReturnAmountDTO returnAmount : returnAmountList) {
                returnAmount.setPaymentTypeName(this.baseDataUtil.getDictName(returnAmount.getPaymentType(), "paymentType"));
            }
            bonus.setReturnAmountList(returnAmountList);
        }
        vo.setBonusList(bonusVOList);
    }

    @Override
    @FlowCallBackMethod(fullName="\u5956\u91d1\u5ba1\u6838\u6d41\u7a0b\u56de\u8c03")
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) throws DataException {
        OaBonusAuditEntity entity = this.getInfo(id);
        if (null != entity) {
            List<SaleBonusAuditEntity> bonusList;
            if ("7".equals(enableMark)) {
                throw new DataException("\u65e0\u6cd5\u5220\u9664\u5956\u91d1\u6838\u7b97");
            }
            entity.setFlowStatus(enableMark);
            if (ObjectUtil.equal((Object)enableMark, (Object)4)) {
                OaBonusAuditUpForm upForm = (OaBonusAuditUpForm)((Object)JsonUtil.getJsonToBean((Object)model.getFormData(), OaBonusAuditUpForm.class));
                this.editInfo(upForm);
            }
            if (CollectionUtil.isNotEmpty(bonusList = this.saleBonusAuditService.queryListByFlowId(id))) {
                for (SaleBonusAuditEntity bonus : bonusList) {
                    bonus.setStatus(BonusAuditStatusEnum.AUDIT.getEnCode());
                    if (ObjectUtil.equal((Object)enableMark, (Object)2)) {
                        bonus.setStatus(BonusAuditStatusEnum.PASS.getEnCode());
                    } else if (ObjectUtil.equal((Object)enableMark, (Object)3) || ObjectUtil.equal((Object)enableMark, (Object)6)) {
                        bonus.setStatus(BonusAuditStatusEnum.UNCOMMIT.getEnCode());
                    } else if (ObjectUtil.equal((Object)enableMark, (Object)5) && "0".equals(model.getRejectAgreeStep())) {
                        bonus.setStatus(BonusAuditStatusEnum.UNCOMMIT.getEnCode());
                    }
                    UpdateWrapper itemWrapper = new UpdateWrapper();
                    itemWrapper.lambda().set(SaleBonusAuditItemEntity::getAuditStatus, (Object)bonus.getStatus());
                    itemWrapper.lambda().eq(SaleBonusAuditItemEntity::getBonusId, (Object)bonus.getId());
                    this.saleBonusAuditItemService.update((Wrapper)itemWrapper);
                }
                this.saleBonusAuditService.updateBatchById(bonusList);
            }
        }
        return true;
    }

    @Override
    public OaBonusAuditEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OaBonusAuditEntity::getId, (Object)id);
        return (OaBonusAuditEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OaBonusAuditEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OaBonusAuditEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(OaBonusAuditEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

