/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.bonus.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.bonus.entity.SaleBonusAuditItemEntity;
import com.bringspring.bonus.mapper.SaleBonusAuditItemMapper;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditSummaryDTO;
import com.bringspring.bonus.model.salebonusaudititem.SaleBonusAuditItemModel;
import com.bringspring.bonus.model.salebonusaudititem.SaleBonusAuditItemPagination;
import com.bringspring.bonus.service.SaleBonusAuditItemService;
import com.bringspring.bonus.util.BonusAuditStatusEnum;
import com.bringspring.bonus.util.BonusBatchStatusEnum;
import com.bringspring.common.util.ConvertUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.model.rkcontract.RkContractListVO;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectListVO;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.utils.ContractEnableMarkEnum;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.utils.CustomizeSortWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleBonusAuditItemServiceImpl
extends ServiceImpl<SaleBonusAuditItemMapper, SaleBonusAuditItemEntity>
implements SaleBonusAuditItemService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private SaleBonusAuditItemMapper saleBonusAuditItemMapper;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkContractService rkContractService;

    @Override
    public List<SaleBonusAuditItemModel> summaryGroupByUserAndType(SaleBonusAuditItemPagination pagination) {
        return this.saleBonusAuditItemMapper.summaryGroupByUserAndType(pagination);
    }

    @Override
    public List<SaleBonusAuditItemModel> summaryGroupByUser(SaleBonusAuditItemPagination pagination) {
        return this.saleBonusAuditItemMapper.summaryGroupByUser(pagination);
    }

    @Override
    public List<SaleBonusAuditItemEntity> queryByBonusId(String bonusId) {
        return this.saleBonusAuditItemMapper.queryByBonusId(bonusId);
    }

    @Override
    public List<SaleBonusAuditItemEntity> queryByBatchId(String batchId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleBonusAuditItemEntity::getBonusBatchId, (Object)batchId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void removeByBonusId(String bonusId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleBonusAuditItemEntity::getBonusId, (Object)bonusId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public List<SaleBonusAuditItemEntity> getList(SaleBonusAuditItemPagination saleBonusAuditItemPagination) {
        QueryWrapper<SaleBonusAuditItemEntity> queryWrapper = this.appendWrapper(saleBonusAuditItemPagination);
        Page page = new Page(saleBonusAuditItemPagination.getCurrentPage(), saleBonusAuditItemPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return saleBonusAuditItemPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<SaleBonusAuditItemEntity> appendWrapper(SaleBonusAuditItemPagination saleBonusAuditItemPagination) {
        Long sec;
        Long fir;
        List<String> date;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean permission = true;
        if (0 == saleBonusAuditItemPagination.getIsAuth()) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object obj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, saleBonusAuditItemPagination.getMenuId(), "sale_bonus_audit_item"));
            if (ObjectUtil.isEmpty((Object)obj)) {
                queryWrapper.lambda().eq(SaleBonusAuditItemEntity::getUserId, (Object)this.userProvider.get().getUserId());
            } else {
                queryWrapper = (QueryWrapper)obj;
            }
        }
        if (StringUtils.isNotEmpty((String)saleBonusAuditItemPagination.getBonusId())) {
            queryWrapper.lambda().eq(SaleBonusAuditItemEntity::getBonusId, (Object)saleBonusAuditItemPagination.getBonusId());
        }
        if (StringUtils.isNotEmpty((String)saleBonusAuditItemPagination.getBonusType())) {
            queryWrapper.lambda().eq(SaleBonusAuditItemEntity::getBonusType, (Object)saleBonusAuditItemPagination.getBonusType());
        }
        if (StringUtils.isNotEmpty((String)saleBonusAuditItemPagination.getBonusBatchId())) {
            queryWrapper.lambda().eq(SaleBonusAuditItemEntity::getBonusBatchId, (Object)saleBonusAuditItemPagination.getBonusBatchId());
        }
        if (StringUtils.isNotEmpty((String)saleBonusAuditItemPagination.getUserId())) {
            queryWrapper.lambda().eq(SaleBonusAuditItemEntity::getUserId, (Object)saleBonusAuditItemPagination.getUserId());
        }
        if (CollectionUtil.isNotEmpty(saleBonusAuditItemPagination.getSignDate())) {
            date = saleBonusAuditItemPagination.getSignDate();
            fir = Long.valueOf(date.get(0));
            sec = Long.valueOf(date.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(SaleBonusAuditItemEntity::getSignDate, (Object)new Date(fir))).le(SaleBonusAuditItemEntity::getSignDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (CollectionUtil.isNotEmpty(saleBonusAuditItemPagination.getAccountDate())) {
            date = saleBonusAuditItemPagination.getAccountDate();
            fir = Long.valueOf(date.get(0));
            sec = Long.valueOf(date.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(SaleBonusAuditItemEntity::getAccountDate, (Object)new Date(fir))).le(SaleBonusAuditItemEntity::getAccountDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)saleBonusAuditItemPagination.getDepartment())) {
            queryWrapper.lambda().apply("FIND_IN_SET('" + saleBonusAuditItemPagination.getDepartment() + "',department_tree)", new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)saleBonusAuditItemPagination.getCustomerId())) {
            queryWrapper.lambda().eq(SaleBonusAuditItemEntity::getCustomerId, (Object)saleBonusAuditItemPagination.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)saleBonusAuditItemPagination.getContractName()))) {
            queryWrapper.lambda().like(SaleBonusAuditItemEntity::getContractName, (Object)StringUtils.trim((String)saleBonusAuditItemPagination.getContractName()));
        }
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)saleBonusAuditItemPagination.getContractNo()))) {
            queryWrapper.lambda().like(SaleBonusAuditItemEntity::getContractNo, (Object)StringUtils.trim((String)saleBonusAuditItemPagination.getContractNo()));
        }
        if (StringUtils.isNotEmpty((String)saleBonusAuditItemPagination.getCompanyId())) {
            queryWrapper.lambda().eq(SaleBonusAuditItemEntity::getCompanyId, (Object)saleBonusAuditItemPagination.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(saleBonusAuditItemPagination.getCompanyIdList())) {
            queryWrapper.lambda().in(SaleBonusAuditItemEntity::getCompanyId, saleBonusAuditItemPagination.getCompanyIdList());
        }
        if (BonusAuditStatusEnum.AUDIT.getEnCode().equals(saleBonusAuditItemPagination.getStatus())) {
            queryWrapper.and(s -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)s.lambda().eq(SaleBonusAuditItemEntity::getAuditStatus, (Object)BonusAuditStatusEnum.UNCOMMIT.getEnCode())).or()).eq(SaleBonusAuditItemEntity::getAuditStatus, (Object)BonusBatchStatusEnum.AUDIT.getEnCode());
            });
        } else if (BonusAuditStatusEnum.PASS.getEnCode().equals(saleBonusAuditItemPagination.getStatus())) {
            queryWrapper.lambda().eq(SaleBonusAuditItemEntity::getAuditStatus, (Object)BonusAuditStatusEnum.PASS.getEnCode());
            queryWrapper.lambda().ne(SaleBonusAuditItemEntity::getBatchStatus, (Object)BonusBatchStatusEnum.GRANT.getEnCode());
        } else if (BonusBatchStatusEnum.GRANT.getEnCode().equals(saleBonusAuditItemPagination.getStatus())) {
            queryWrapper.lambda().eq(SaleBonusAuditItemEntity::getBatchStatus, (Object)BonusBatchStatusEnum.GRANT.getEnCode());
        }
        if (saleBonusAuditItemPagination.getIsSort().booleanValue()) {
            if (StringUtils.isEmpty((String)saleBonusAuditItemPagination.getSidx())) {
                queryWrapper.lambda().orderByDesc(SaleBonusAuditItemEntity::getId);
            } else {
                try {
                    QueryWrapper customSortWrapper = CustomizeSortWrapper.appendWrapper(saleBonusAuditItemPagination, new SaleBonusAuditItemModel(), queryWrapper);
                    if (ObjectUtil.isNull((Object)customSortWrapper)) {
                        String sidx = saleBonusAuditItemPagination.getSidx();
                        SaleBonusAuditItemEntity saleBonusAuditEntity = new SaleBonusAuditItemEntity();
                        Field declaredField = saleBonusAuditEntity.getClass().getDeclaredField(sidx);
                        declaredField.setAccessible(true);
                        String value = declaredField.getAnnotation(TableField.class).value();
                        queryWrapper = "asc".equals(saleBonusAuditItemPagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
                    } else {
                        queryWrapper = customSortWrapper;
                    }
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
        }
        return queryWrapper;
    }

    @Override
    public SaleBonusAuditItemModel summaryData(SaleBonusAuditItemPagination saleBonusAuditItemPagination) {
        return this.saleBonusAuditItemMapper.summaryData(saleBonusAuditItemPagination);
    }

    @Override
    public void fillBatchId(String batchId, String bonusId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().set(SaleBonusAuditItemEntity::getBonusBatchId, (Object)batchId);
        updateWrapper.lambda().eq(SaleBonusAuditItemEntity::getBonusId, (Object)bonusId);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public List<RkContractEntity> getNotAccountContractList(SaleBonusAuditItemPagination saleBonusAuditItemPagination) {
        QueryWrapper<RkContractEntity> queryWrapper = this.appendContractWrapper(saleBonusAuditItemPagination);
        if (null == queryWrapper) {
            return new ArrayList<RkContractEntity>();
        }
        Page page = new Page(saleBonusAuditItemPagination.getCurrentPage(), saleBonusAuditItemPagination.getPageSize());
        IPage userIPage = this.rkContractService.page((IPage)page, (Wrapper)queryWrapper);
        return saleBonusAuditItemPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<RkContractEntity> appendContractWrapper(SaleBonusAuditItemPagination saleBonusAuditItemPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean permission = true;
        if (0 == saleBonusAuditItemPagination.getIsAuth()) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object obj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, saleBonusAuditItemPagination.getMenuId(), "rk_contract"));
            if (ObjectUtil.isEmpty((Object)obj)) {
                queryWrapper.lambda().eq(RkContractEntity::getSalerId, (Object)this.userProvider.get().getUserId());
            } else {
                queryWrapper = (QueryWrapper)obj;
            }
        }
        queryWrapper.lambda().ne(RkContractEntity::getEnableMark, (Object)ContractEnableMarkEnum.ENABLE_VOIDED.getEnableMark());
        queryWrapper.apply(" (not_account_bonus is null or not_account_bonus != '1')", new Object[0]);
        queryWrapper.apply(" (bonus_summary_id is null or bonus_summary_id = '')", new Object[0]);
        if (CollectionUtil.isNotEmpty(saleBonusAuditItemPagination.getSignDate())) {
            List<String> date = saleBonusAuditItemPagination.getSignDate();
            Long fir = Long.valueOf(date.get(0));
            Long sec = Long.valueOf(date.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(RkContractEntity::getSignDate, (Object)new Date(fir))).le(RkContractEntity::getSignDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)saleBonusAuditItemPagination.getCustomerId())) {
            queryWrapper.lambda().eq(RkContractEntity::getCustomerId, (Object)saleBonusAuditItemPagination.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)saleBonusAuditItemPagination.getContractName()))) {
            queryWrapper.lambda().like(RkContractEntity::getContractName, (Object)StringUtils.trim((String)saleBonusAuditItemPagination.getContractName()));
        }
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)saleBonusAuditItemPagination.getContractNo()))) {
            queryWrapper.lambda().like(RkContractEntity::getContractCode, (Object)StringUtils.trim((String)saleBonusAuditItemPagination.getContractNo()));
        }
        if (StringUtils.isNotEmpty((String)saleBonusAuditItemPagination.getCompanyId())) {
            queryWrapper.lambda().eq(RkContractEntity::getCompanyId, (Object)saleBonusAuditItemPagination.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(saleBonusAuditItemPagination.getCompanyIdList())) {
            queryWrapper.lambda().in(RkContractEntity::getCompanyId, saleBonusAuditItemPagination.getCompanyIdList());
        }
        if (saleBonusAuditItemPagination.getIsSort().booleanValue()) {
            if (StringUtils.isEmpty((String)saleBonusAuditItemPagination.getSidx())) {
                queryWrapper.lambda().orderByDesc(RkContractEntity::getId);
            } else {
                try {
                    QueryWrapper customSortWrapper = CustomizeSortWrapper.appendWrapper(saleBonusAuditItemPagination, new RkContractListVO(), queryWrapper);
                    if (ObjectUtil.isNull((Object)customSortWrapper)) {
                        String sidx = saleBonusAuditItemPagination.getSidx();
                        RkContractEntity entity = new RkContractEntity();
                        Field declaredField = entity.getClass().getDeclaredField(sidx);
                        declaredField.setAccessible(true);
                        String value = declaredField.getAnnotation(TableField.class).value();
                        queryWrapper = "asc".equals(saleBonusAuditItemPagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
                    } else {
                        queryWrapper = customSortWrapper;
                    }
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
        }
        return queryWrapper;
    }

    @Override
    public List<RkContractProjectEntity> getNotAccountList(SaleBonusAuditItemPagination saleBonusAuditItemPagination) {
        QueryWrapper<RkContractProjectEntity> queryWrapper = this.appendProjectWrapper(saleBonusAuditItemPagination);
        if (null == queryWrapper) {
            return new ArrayList<RkContractProjectEntity>();
        }
        Page page = new Page(saleBonusAuditItemPagination.getCurrentPage(), saleBonusAuditItemPagination.getPageSize());
        IPage userIPage = this.rkContractProjectService.page((IPage)page, (Wrapper)queryWrapper);
        return saleBonusAuditItemPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<RkContractProjectEntity> appendProjectWrapper(SaleBonusAuditItemPagination saleBonusAuditItemPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean permission = true;
        if (0 == saleBonusAuditItemPagination.getIsAuth()) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object obj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, saleBonusAuditItemPagination.getMenuId(), "rk_contract_project"));
            if (ObjectUtil.isEmpty((Object)obj)) {
                queryWrapper.lambda().eq(RkContractProjectEntity::getSalerId, (Object)this.userProvider.get().getUserId());
            } else {
                queryWrapper = (QueryWrapper)obj;
            }
        }
        queryWrapper.apply(" (not_account_bonus is null or not_account_bonus != '1')", new Object[0]);
        queryWrapper.apply(" (bonus_summary_id is null or bonus_summary_id = '')", new Object[0]);
        if (StringUtils.isNotEmpty((String)saleBonusAuditItemPagination.getSalerId())) {
            queryWrapper.lambda().eq(RkContractProjectEntity::getSalerId, (Object)saleBonusAuditItemPagination.getSalerId());
        }
        if (StringUtils.isNotEmpty((String)saleBonusAuditItemPagination.getCustomerId())) {
            queryWrapper.lambda().eq(RkContractProjectEntity::getCustomerId, (Object)saleBonusAuditItemPagination.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)saleBonusAuditItemPagination.getContractNo())) || StringUtils.isNotEmpty((String)StringUtils.trim((String)saleBonusAuditItemPagination.getContractName()))) {
            List contractList;
            QueryWrapper contractQueryWrapper = new QueryWrapper();
            if (StringUtils.isNotEmpty((String)StringUtils.trim((String)saleBonusAuditItemPagination.getContractNo()))) {
                contractQueryWrapper.lambda().like(RkContractEntity::getContractCode, (Object)StringUtils.trim((String)saleBonusAuditItemPagination.getContractNo()));
            }
            if (StringUtils.isNotEmpty((String)StringUtils.trim((String)saleBonusAuditItemPagination.getContractName()))) {
                contractQueryWrapper.lambda().like(RkContractEntity::getContractName, (Object)StringUtils.trim((String)saleBonusAuditItemPagination.getContractName()));
            }
            if (CollectionUtil.isNotEmpty((Collection)(contractList = this.rkContractService.list((Wrapper)contractQueryWrapper)))) {
                List ids = contractList.stream().map(RkContractEntity::getId).collect(Collectors.toList());
                queryWrapper.lambda().in(RkContractProjectEntity::getContractId, ids);
            } else {
                return null;
            }
        }
        if (StringUtils.isNotEmpty((String)saleBonusAuditItemPagination.getCompanyId())) {
            queryWrapper.lambda().eq(RkContractProjectEntity::getCompanyId, (Object)saleBonusAuditItemPagination.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(saleBonusAuditItemPagination.getCompanyIdList())) {
            queryWrapper.lambda().in(RkContractProjectEntity::getCompanyId, saleBonusAuditItemPagination.getCompanyIdList());
        }
        if (saleBonusAuditItemPagination.getIsSort().booleanValue()) {
            if (StringUtils.isEmpty((String)saleBonusAuditItemPagination.getSidx())) {
                queryWrapper.lambda().orderByDesc(RkContractProjectEntity::getId);
            } else {
                try {
                    QueryWrapper customSortWrapper = CustomizeSortWrapper.appendWrapper(saleBonusAuditItemPagination, new RkContractProjectListVO(), queryWrapper);
                    if (ObjectUtil.isNull((Object)customSortWrapper)) {
                        String sidx = saleBonusAuditItemPagination.getSidx();
                        RkContractProjectEntity rkContractProjectEntity = new RkContractProjectEntity();
                        Field declaredField = rkContractProjectEntity.getClass().getDeclaredField(sidx);
                        declaredField.setAccessible(true);
                        String value = declaredField.getAnnotation(TableField.class).value();
                        queryWrapper = "asc".equals(saleBonusAuditItemPagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
                    } else {
                        queryWrapper = customSortWrapper;
                    }
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
        }
        return queryWrapper;
    }

    @Override
    public SaleBonusAuditSummaryDTO countData(SaleBonusAuditItemPagination saleBonusAuditItemPagination) {
        saleBonusAuditItemPagination.setIsSort(false);
        QueryWrapper<SaleBonusAuditItemEntity> queryWrapper = this.appendWrapper(saleBonusAuditItemPagination);
        queryWrapper.select(new String[]{"sum(payable_amount) payableAmount,sum(actual_amount) actualAmount,sum(paid_amount) paidAmount,sum(pending_amount) pendingAmount,sum(case when audit_status = 'uncommit' or audit_status = 'audit' then 1 else 0 end) auditNum,sum(case when audit_status = 'pass' then 1 else 0 end) passNum,sum(case when batch_status = 'grant' then 1 else 0 end) grantNum"});
        Map summaryMap = this.getMap((Wrapper)queryWrapper);
        SaleBonusAuditSummaryDTO summary = (SaleBonusAuditSummaryDTO)JsonUtil.getJsonToBean((Object)summaryMap, SaleBonusAuditSummaryDTO.class);
        if (null == summary) {
            summary = new SaleBonusAuditSummaryDTO();
            summary.setPayableAmount(BigDecimal.ZERO);
            summary.setActualAmount(BigDecimal.ZERO);
            summary.setPaidAmount(BigDecimal.ZERO);
            summary.setPendingAmount(BigDecimal.ZERO);
        }
        saleBonusAuditItemPagination.setStatus(null);
        queryWrapper = this.appendWrapper(saleBonusAuditItemPagination);
        queryWrapper.select(new String[]{"sum(case when audit_status = 'uncommit' or audit_status = 'audit' then 1 else 0 end) auditNum,sum(case when audit_status = 'pass' and batch_status != 'grant' then 1 else 0 end) passNum,sum(case when batch_status = 'grant' then 1 else 0 end) grantNum"});
        summaryMap = this.getMap((Wrapper)queryWrapper);
        HashMap<String, Object> statusCount = new HashMap<String, Object>();
        if (null != summaryMap) {
            statusCount.put("audit", ConvertUtil.toInt(summaryMap.get("auditNum"), (Integer)0));
            statusCount.put("pass", ConvertUtil.toInt(summaryMap.get("passNum"), (Integer)0));
            statusCount.put("grant", ConvertUtil.toInt(summaryMap.get("grantNum"), (Integer)0));
        } else {
            statusCount.put("audit", 0);
            statusCount.put("pass", 0);
            statusCount.put("grant", 0);
        }
        statusCount.put("all", ConvertUtil.toInt(statusCount.get("audit")) + ConvertUtil.toInt(statusCount.get("pass")) + ConvertUtil.toInt(statusCount.get("grant")));
        summary.setStatusCount(statusCount);
        QueryWrapper<RkContractEntity> contractWrapper = this.appendContractWrapper(saleBonusAuditItemPagination);
        contractWrapper.select(new String[]{"count(1) notAccountContract"});
        summaryMap = this.rkContractService.getMap((Wrapper)contractWrapper);
        if (null != summaryMap) {
            statusCount.put("notAccountContract", ConvertUtil.toInt(summaryMap.get("notAccountContract"), (Integer)0));
        } else {
            statusCount.put("notAccountContract", 0);
        }
        return summary;
    }

    @Override
    public List<SaleBonusAuditItemModel> getSummaryList(SaleBonusAuditItemPagination saleBonusAuditItemPagination) {
        saleBonusAuditItemPagination.setIsSort(false);
        QueryWrapper<SaleBonusAuditItemEntity> queryWrapper = this.appendWrapper(saleBonusAuditItemPagination);
        PageHelper.startPage((int)((int)saleBonusAuditItemPagination.getCurrentPage()), (int)((int)saleBonusAuditItemPagination.getPageSize()));
        List<SaleBonusAuditItemModel> summaryList = this.saleBonusAuditItemMapper.getSummaryList(queryWrapper);
        PageInfo pageInfo = new PageInfo(summaryList);
        return saleBonusAuditItemPagination.setData(pageInfo.getList(), pageInfo.getTotal());
    }

    @Override
    public SaleBonusAuditSummaryDTO countSummaryData(SaleBonusAuditItemPagination saleBonusAuditItemPagination) {
        saleBonusAuditItemPagination.setIsSort(false);
        QueryWrapper<SaleBonusAuditItemEntity> queryWrapper = this.appendWrapper(saleBonusAuditItemPagination);
        SaleBonusAuditItemModel summary = this.saleBonusAuditItemMapper.countSummaryData(queryWrapper);
        SaleBonusAuditSummaryDTO dto = (SaleBonusAuditSummaryDTO)JsonUtil.getJsonToBean((Object)summary, SaleBonusAuditSummaryDTO.class);
        if (null == dto) {
            dto = new SaleBonusAuditSummaryDTO();
            dto.setPayableAmount(BigDecimal.ZERO);
            dto.setActualAmount(BigDecimal.ZERO);
            dto.setPaidAmount(BigDecimal.ZERO);
            dto.setPendingAmount(BigDecimal.ZERO);
            dto.setTotalRegionAmount(BigDecimal.ZERO);
            dto.setTotalBusinessAmount(BigDecimal.ZERO);
        }
        return dto;
    }
}

