/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.bonus.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.bonus.entity.SaleBonusAuditEntity;
import com.bringspring.bonus.entity.SaleBonusAuditItemEntity;
import com.bringspring.bonus.entity.SaleBonusSummaryEntity;
import com.bringspring.bonus.mapper.SaleBonusAuditMapper;
import com.bringspring.bonus.model.salebonusaudit.ProjectDTO;
import com.bringspring.bonus.model.salebonusaudit.ReturnAmountDTO;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditCrForm;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditInfoVO;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditListVO;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditPagination;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditSummaryDTO;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditUpForm;
import com.bringspring.bonus.model.salebonusaudit.SaleCountBonusDTO;
import com.bringspring.bonus.model.salebonusaudit.UserDepartmentDTO;
import com.bringspring.bonus.model.salebonusaudititem.SaleBonusAuditItemModel;
import com.bringspring.bonus.model.salebonusaudititem.SaleBonusAuditItemPagination;
import com.bringspring.bonus.service.SaleBonusAuditItemService;
import com.bringspring.bonus.service.SaleBonusAuditService;
import com.bringspring.bonus.service.SaleBonusSummaryService;
import com.bringspring.bonus.util.BonusAccountUtil;
import com.bringspring.bonus.util.BonusAuditStatusEnum;
import com.bringspring.bonus.util.BonusBatchStatusEnum;
import com.bringspring.bonus.util.CommissionCalculator;
import com.bringspring.bonus.util.SaleBonusTypeEnum;
import com.bringspring.common.util.ConvertUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.CompanyIdEnum;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractCollectionRecordService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.crm.config.OpportunityPushConfig;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.CustomizeSortWrapper;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class SaleBonusAuditServiceImpl
extends ServiceImpl<SaleBonusAuditMapper, SaleBonusAuditEntity>
implements SaleBonusAuditService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private SaleBonusAuditMapper saleBonusAuditMapper;
    @Autowired
    private OpportunityPushConfig opportunityPushConfig;
    @Autowired
    private SaleBonusSummaryService saleBonusSummaryService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private SaleBonusAuditItemService saleBonusAuditItemService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private RkContractReturnPlanService rkContractReturnPlanService;
    @Autowired
    private RkContractCollectionRecordService rkContractCollectionRecordService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractProjectService rkContractProjectService;

    @Override
    public List<SaleBonusAuditEntity> getList(SaleBonusAuditPagination saleBonusAuditPagination) {
        QueryWrapper<SaleBonusAuditEntity> queryWrapper = this.appendWrapper(saleBonusAuditPagination);
        Page page = new Page(saleBonusAuditPagination.getCurrentPage(), saleBonusAuditPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return saleBonusAuditPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<SaleBonusAuditEntity> appendWrapper(SaleBonusAuditPagination saleBonusAuditPagination) {
        List<String> date;
        Long sec;
        Long fir;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean permission = true;
        if (0 == saleBonusAuditPagination.getIsAuth()) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object obj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, saleBonusAuditPagination.getMenuId(), "sale_bonus_audit"));
            if (ObjectUtil.isEmpty((Object)obj)) {
                queryWrapper.lambda().eq(SaleBonusAuditEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId());
            } else {
                queryWrapper = (QueryWrapper)obj;
            }
        }
        if (CollectionUtil.isNotEmpty(saleBonusAuditPagination.getLatestReturnDate())) {
            List<String> latestReturnDate = saleBonusAuditPagination.getLatestReturnDate();
            fir = Long.valueOf(latestReturnDate.get(0));
            sec = Long.valueOf(latestReturnDate.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(SaleBonusAuditEntity::getLatestReturnDate, (Object)new Date(fir))).le(SaleBonusAuditEntity::getLatestReturnDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (CollectionUtil.isNotEmpty(saleBonusAuditPagination.getSignDate())) {
            date = saleBonusAuditPagination.getSignDate();
            fir = Long.valueOf(date.get(0));
            sec = Long.valueOf(date.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(SaleBonusAuditEntity::getSignDate, (Object)new Date(fir))).le(SaleBonusAuditEntity::getSignDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (CollectionUtil.isNotEmpty(saleBonusAuditPagination.getProjectAcceptanceTime())) {
            date = saleBonusAuditPagination.getProjectAcceptanceTime();
            fir = Long.valueOf(date.get(0));
            sec = Long.valueOf(date.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(SaleBonusAuditEntity::getProjectAcceptanceTime, (Object)new Date(fir))).le(SaleBonusAuditEntity::getProjectAcceptanceTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (CollectionUtil.isNotEmpty(saleBonusAuditPagination.getAccountDate())) {
            date = saleBonusAuditPagination.getAccountDate();
            fir = Long.valueOf(date.get(0));
            sec = Long.valueOf(date.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(SaleBonusAuditEntity::getAccountDate, (Object)new Date(fir))).le(SaleBonusAuditEntity::getAccountDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)saleBonusAuditPagination.getDepartment())) {
            queryWrapper.lambda().apply("FIND_IN_SET('" + saleBonusAuditPagination.getDepartment() + "',department_tree)", new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)saleBonusAuditPagination.getCustomerId())) {
            queryWrapper.lambda().eq(SaleBonusAuditEntity::getCustomerId, (Object)saleBonusAuditPagination.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)saleBonusAuditPagination.getContractType())) {
            queryWrapper.lambda().eq(SaleBonusAuditEntity::getContractType, (Object)saleBonusAuditPagination.getContractType());
        }
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)saleBonusAuditPagination.getContractName()))) {
            queryWrapper.lambda().like(SaleBonusAuditEntity::getContractName, (Object)StringUtils.trim((String)saleBonusAuditPagination.getContractName()));
        }
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)saleBonusAuditPagination.getContractNo()))) {
            queryWrapper.lambda().like(SaleBonusAuditEntity::getContractNo, (Object)StringUtils.trim((String)saleBonusAuditPagination.getContractNo()));
        }
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)saleBonusAuditPagination.getProjectName()))) {
            queryWrapper.lambda().like(SaleBonusAuditEntity::getProjectName, (Object)StringUtils.trim((String)saleBonusAuditPagination.getProjectName()));
        }
        if (StringUtils.isNotEmpty((String)saleBonusAuditPagination.getSalerId())) {
            queryWrapper.lambda().eq(SaleBonusAuditEntity::getSalerId, (Object)saleBonusAuditPagination.getSalerId());
        }
        if (StringUtils.isNotEmpty((String)saleBonusAuditPagination.getCompanyId())) {
            queryWrapper.lambda().eq(SaleBonusAuditEntity::getCompanyId, (Object)saleBonusAuditPagination.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(saleBonusAuditPagination.getSalerCompanyIdList())) {
            queryWrapper.lambda().in(SaleBonusAuditEntity::getSalerCompanyId, saleBonusAuditPagination.getSalerCompanyIdList());
        }
        if (CollectionUtil.isNotEmpty(saleBonusAuditPagination.getCompanyIdList())) {
            queryWrapper.lambda().in(SaleBonusAuditEntity::getCompanyId, saleBonusAuditPagination.getCompanyIdList());
        }
        if (StringUtils.isNotEmpty((String)saleBonusAuditPagination.getStatus()) && !"all".equals(saleBonusAuditPagination.getStatus())) {
            queryWrapper.lambda().eq(SaleBonusAuditEntity::getStatus, (Object)saleBonusAuditPagination.getStatus());
        }
        if ("1".equals(saleBonusAuditPagination.getEmptyBatch())) {
            queryWrapper.lambda().and(s -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)s.eq(SaleBonusAuditEntity::getBonusBatchId, (Object)"")).or()).isNull(SaleBonusAuditEntity::getBonusBatchId);
            });
            queryWrapper.lambda().eq(SaleBonusAuditEntity::getStatus, (Object)BonusAuditStatusEnum.PASS.getEnCode());
        }
        if (saleBonusAuditPagination.getIsSort().booleanValue()) {
            if (StringUtils.isEmpty((String)saleBonusAuditPagination.getSidx())) {
                queryWrapper.lambda().orderByDesc(SaleBonusAuditEntity::getId);
            } else {
                try {
                    QueryWrapper customSortWrapper = CustomizeSortWrapper.appendWrapper(saleBonusAuditPagination, new SaleBonusAuditListVO(), queryWrapper);
                    if (ObjectUtil.isNull((Object)customSortWrapper)) {
                        String sidx = saleBonusAuditPagination.getSidx();
                        SaleBonusAuditEntity saleBonusAuditEntity = new SaleBonusAuditEntity();
                        Field declaredField = saleBonusAuditEntity.getClass().getDeclaredField(sidx);
                        declaredField.setAccessible(true);
                        String value = declaredField.getAnnotation(TableField.class).value();
                        queryWrapper = "asc".equals(saleBonusAuditPagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
                    } else {
                        queryWrapper = customSortWrapper;
                    }
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
        }
        return queryWrapper;
    }

    @Override
    public List<SaleBonusAuditEntity> getTypeList(SaleBonusAuditPagination saleBonusAuditPagination, String dataType) {
        QueryWrapper<SaleBonusAuditEntity> saleBonusAuditQueryWrapper = this.appendWrapper(saleBonusAuditPagination);
        if ("0".equals(dataType)) {
            Page page = new Page(saleBonusAuditPagination.getCurrentPage(), saleBonusAuditPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)saleBonusAuditQueryWrapper);
            return saleBonusAuditPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)saleBonusAuditQueryWrapper);
    }

    @Override
    public SaleBonusAuditEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleBonusAuditEntity::getId, (Object)id);
        return (SaleBonusAuditEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(SaleBonusAuditEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, SaleBonusAuditEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(SaleBonusAuditEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void accountBonus(SaleBonusAuditCrForm bonusAuditCrForm) {
        bonusAuditCrForm.setCompanyId(this.userProvider.get().getOrganizeId());
        List<SaleCountBonusDTO> contractList = this.saleBonusAuditMapper.getAccountContract(bonusAuditCrForm);
        boolean onlyCurrent = false;
        boolean isProject = false;
        boolean isProjectInfo = false;
        if (CompanyIdEnum.SHIHAN.getId().equals(bonusAuditCrForm.getCompanyId())) {
            onlyCurrent = true;
            isProjectInfo = true;
        } else if (!CompanyIdEnum.MiJIAN.getId().equals(bonusAuditCrForm.getCompanyId()) && CompanyIdEnum.JINCHUANG.getId().equals(bonusAuditCrForm.getCompanyId())) {
            isProject = true;
        }
        if (CollectionUtil.isNotEmpty(contractList)) {
            List<ProjectDTO> projectList = null;
            Map<String, List<ProjectDTO>> contractProjectMap = null;
            if (CompanyIdEnum.SHIHAN.getId().equals(bonusAuditCrForm.getCompanyId())) {
                projectList = this.saleBonusAuditMapper.getAccountProject(bonusAuditCrForm);
            }
            if (CollectionUtil.isNotEmpty(projectList)) {
                contractProjectMap = projectList.stream().collect(Collectors.groupingBy(ProjectDTO::getContractId));
            }
            List<ProjectDTO> projectDTOS = null;
            Object returnPlans = null;
            List<ReturnAmountDTO> returnAmountDTOS = null;
            for (SaleCountBonusDTO contract : contractList) {
                contract.setValidContractAmount(MathUtils.substract(contract.getContractAmount(), contract.getThirdAmount()));
                if (StringUtils.isNotEmpty((String)contract.getSalerCompanyId()) && !ObjectUtil.equals((Object)contract.getCompanyId(), (Object)contract.getSalerCompanyId())) {
                    contract.setIsZy("1");
                }
                if (CompanyIdEnum.SHIHAN.getId().equals(bonusAuditCrForm.getCompanyId())) {
                    returnAmountDTOS = this.rkContractCollectionRecordService.getListForBonus(contract.getContractId());
                    contract.setReturnAmountList(returnAmountDTOS);
                }
                if (null == contractProjectMap) continue;
                projectDTOS = contractProjectMap.get(contract.getContractId());
                contract.setProjectList(projectDTOS);
            }
            this.countBySubsidiaryMethod(bonusAuditCrForm, contractList);
            List resultList = null;
            resultList = onlyCurrent ? contractList.stream().filter(s -> s.getCurrentAmount() != null && s.getCurrentAmount().compareTo(s.getAccountAmount()) != 0).collect(Collectors.toList()) : contractList.stream().filter(s -> ConvertUtil.toBigDecimal((Object)s.getPayableAmount(), (BigDecimal)BigDecimal.ZERO).compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(resultList)) {
                List<String> contractIdList = resultList.stream().map(SaleCountBonusDTO::getContractId).collect(Collectors.toList());
                List<SaleBonusSummaryEntity> summaryList = this.saleBonusSummaryService.queryListByContractIds(contractIdList);
                Map<String, SaleBonusSummaryEntity> summaryContractMap = summaryList.stream().filter(v -> StringUtils.isEmpty((String)v.getProjectId())).collect(Collectors.toMap(SaleBonusSummaryEntity::getContractId, v -> v));
                SaleBonusSummaryEntity summary = null;
                ArrayList<SaleBonusAuditEntity> finalAuditList = new ArrayList<SaleBonusAuditEntity>();
                SaleBonusAuditEntity bonusAuditEntity = null;
                ArrayList<SaleBonusAuditItemEntity> finalAuditItemList = new ArrayList<SaleBonusAuditItemEntity>();
                List<SaleBonusAuditItemEntity> auditItemList = null;
                SaleBonusAuditItemPagination pagination = new SaleBonusAuditItemPagination();
                List<SaleBonusAuditItemModel> auditItemSummaryList = null;
                SaleBonusAuditItemModel auditItemSummary = null;
                ArrayList<SaleBonusSummaryEntity> finalSummaryCrList = new ArrayList<SaleBonusSummaryEntity>();
                Object summaryEntity = null;
                ArrayList<SaleBonusSummaryEntity> finalSummaryUpdList = new ArrayList<SaleBonusSummaryEntity>();
                Date nowDate = DateUtil.getNowDate();
                boolean addSummary = false;
                UpdateWrapper projectWrapper = null;
                UpdateWrapper contractWrapper = null;
                StringBuilder formulaBuilder = null;
                for (SaleCountBonusDTO result : resultList) {
                    bonusAuditEntity = new SaleBonusAuditEntity();
                    BeanUtil.copyProperties((Object)result, (Object)bonusAuditEntity, (String[])new String[0]);
                    bonusAuditEntity.setId(RandomUtil.uuId());
                    bonusAuditEntity.setOriginalSalerName(this.baseDataUtil.userSelectValue(result.getOriginalSalerId()));
                    bonusAuditEntity.setSalerName(this.baseDataUtil.userSelectValue(result.getSalerId()));
                    bonusAuditEntity.setSalerHigherUpName(this.baseDataUtil.userSelectValue(result.getSalerHigherUp()));
                    bonusAuditEntity.setDepartmentManagerName(this.baseDataUtil.userSelectValue(result.getDepartmentManager()));
                    bonusAuditEntity.setAccountDate(nowDate);
                    if (StringUtils.isNotEmpty((String)bonusAuditEntity.getDepartmentTree()) && bonusAuditEntity.getDepartmentTree().contains("[")) {
                        bonusAuditEntity.setDepartmentTree(String.join((CharSequence)",", JsonUtil.getJsonToList((String)bonusAuditEntity.getDepartmentTree(), String.class)));
                    }
                    bonusAuditEntity.setIsChangeAmount("0");
                    summary = summaryContractMap.get(result.getContractId());
                    if (null == summary) {
                        summary = new SaleBonusSummaryEntity();
                        addSummary = true;
                    } else if (null != bonusAuditEntity.getTotalAmount() && ConvertUtil.toBigDecimal((Object)summary.getTotalAmount(), (BigDecimal)BigDecimal.ZERO).compareTo(bonusAuditEntity.getTotalAmount()) != 0) {
                        bonusAuditEntity.setIsChangeAmount("1");
                    }
                    bonusAuditEntity.setPreBonusId(summary.getLatestBonusId());
                    if (onlyCurrent) {
                        bonusAuditEntity.setPayableAmount(MathUtils.substract(bonusAuditEntity.getCurrentAmount(), summary.getPayableAmount()));
                        bonusAuditEntity.setPayableRegionAmount(MathUtils.substract(bonusAuditEntity.getCurrentRegionAmount(), summary.getPayableRegionAmount()));
                        bonusAuditEntity.setPayableImplAmount(MathUtils.substract(bonusAuditEntity.getCurrentImplAmount(), summary.getPayableImplAmount()));
                        bonusAuditEntity.setPayableBusinessAmount(MathUtils.substract(bonusAuditEntity.getCurrentBusinessAmount(), summary.getPayableBusinessAmount()));
                        bonusAuditEntity.setPayablePreSalesAmount(MathUtils.substract(bonusAuditEntity.getCurrentPreSalesAmount(), summary.getPayablePreSalesAmount()));
                        bonusAuditEntity.setPayableDevAmount(MathUtils.substract(bonusAuditEntity.getCurrentDevAmount(), summary.getPayableDevAmount()));
                        bonusAuditEntity.setPayableAfterSalesAmount(MathUtils.substract(bonusAuditEntity.getCurrentAfterSalesAmount(), summary.getPayableAfterSalesAmount()));
                        if (StringUtils.isNotEmpty((String)bonusAuditEntity.getCalcProcess())) {
                            formulaBuilder = new StringBuilder(bonusAuditEntity.getCalcProcess());
                            formulaBuilder.append(String.format("\u672c\u671f\u5e94\u53d1\u63d0\u6210 = \u7d2f\u8ba1\u5e94\u53d1\u63d0\u6210 - \u5f80\u671f\u5e94\u53d1\u63d0\u6210 = %.2f - %.2f = %.2f\u5143", ConvertUtil.toBigDecimal((Object)bonusAuditEntity.getCurrentAmount(), (BigDecimal)BigDecimal.ZERO), ConvertUtil.toBigDecimal((Object)summary.getPayableAmount(), (BigDecimal)BigDecimal.ZERO), bonusAuditEntity.getPayableAmount()));
                            bonusAuditEntity.setCalcProcess(formulaBuilder.toString());
                        }
                    }
                    bonusAuditEntity.setActualAmount(bonusAuditEntity.getPayableAmount());
                    bonusAuditEntity.setActualRegionAmount(bonusAuditEntity.getPayableRegionAmount());
                    bonusAuditEntity.setActualImplAmount(bonusAuditEntity.getPayableImplAmount());
                    bonusAuditEntity.setActualBusinessAmount(bonusAuditEntity.getPayableBusinessAmount());
                    bonusAuditEntity.setActualPreSalesAmount(bonusAuditEntity.getPayablePreSalesAmount());
                    bonusAuditEntity.setActualDevAmount(bonusAuditEntity.getPayableDevAmount());
                    bonusAuditEntity.setActualAfterSalesAmount(bonusAuditEntity.getPayableAfterSalesAmount());
                    bonusAuditEntity.setPendingAmount(bonusAuditEntity.getActualAmount());
                    bonusAuditEntity.setPendingRegionAmount(bonusAuditEntity.getActualRegionAmount());
                    bonusAuditEntity.setPendingImplAmount(bonusAuditEntity.getActualImplAmount());
                    bonusAuditEntity.setPendingBusinessAmount(bonusAuditEntity.getActualBusinessAmount());
                    bonusAuditEntity.setPendingPreSalesAmount(bonusAuditEntity.getActualPreSalesAmount());
                    bonusAuditEntity.setPendingDevAmount(bonusAuditEntity.getActualDevAmount());
                    bonusAuditEntity.setPendingAfterSalesAmount(bonusAuditEntity.getActualAfterSalesAmount());
                    bonusAuditEntity.setStatus(BonusAuditStatusEnum.UNCOMMIT.getEnCode());
                    String summaryId = summary.getId();
                    BeanUtil.copyProperties((Object)bonusAuditEntity, (Object)summary, (String[])new String[0]);
                    summary.setId(summaryId);
                    if (!isProject && isProjectInfo && CollectionUtil.isNotEmpty(result.getProjectList())) {
                        bonusAuditEntity.setProjectId(result.getProjectList().get(0).getProjectId());
                        bonusAuditEntity.setProjectNo(result.getProjectList().get(0).getProjectNo());
                        bonusAuditEntity.setProjectName(result.getProjectList().get(0).getProjectName());
                        bonusAuditEntity.setProjectIncomeType(result.getProjectList().get(0).getProjectIncomeType());
                        bonusAuditEntity.setProjectTaxRate(result.getProjectList().get(0).getProjectTaxRate());
                        bonusAuditEntity.setProjectAmount(result.getProjectList().get(0).getProjectAmount());
                        bonusAuditEntity.setProjectStartDate(result.getProjectList().get(0).getProjectStartDate());
                        bonusAuditEntity.setProjectAcceptanceTime(result.getProjectList().get(0).getProjectAcceptanceTime());
                        bonusAuditEntity.setProjectReturnAmount(result.getProjectList().get(0).getProjectReturnAmount());
                        bonusAuditEntity.setProjectReturnRatio(result.getProjectList().get(0).getProjectReturnRatio());
                        bonusAuditEntity.setProjectState(result.getProjectList().get(0).getProjectState());
                        bonusAuditEntity.setProductId(result.getProjectList().get(0).getProductId());
                    }
                    if (CollectionUtil.isNotEmpty(auditItemList = result.getUserList())) {
                        if (onlyCurrent) {
                            pagination.setContractId(bonusAuditEntity.getContractId());
                            auditItemSummaryList = this.saleBonusAuditItemService.summaryGroupByUserAndType(pagination);
                        }
                        BigDecimal payableAmount = BigDecimal.ZERO;
                        for (SaleBonusAuditItemEntity auditItem : auditItemList) {
                            payableAmount = auditItem.getPayableAmount();
                            BeanUtils.copyProperties((Object)bonusAuditEntity, (Object)auditItem);
                            auditItem.setId(RandomUtil.uuId());
                            auditItem.setBonusId(bonusAuditEntity.getId());
                            auditItem.setPayableAmount(payableAmount);
                            UserDepartmentDTO userDepartmentDTO = this.getUserDepartment(auditItem.getUserId());
                            BeanUtil.copyProperties((Object)userDepartmentDTO, (Object)auditItem, (String[])new String[0]);
                            if (onlyCurrent && null != (auditItemSummary = (SaleBonusAuditItemModel)auditItemSummaryList.stream().filter(s -> s.getUserId().equals(auditItem.getUserId()) && s.getBonusType().equals(auditItem.getBonusType())).findFirst().orElse(null))) {
                                auditItem.setPayableAmount(MathUtils.substract(auditItem.getPayableAmount(), auditItemSummary.getPayableAmount()));
                            }
                            auditItem.setActualAmount(auditItem.getPayableAmount());
                            auditItem.setPendingAmount(auditItem.getActualAmount());
                            auditItem.setCompanyId(bonusAuditEntity.getCompanyId());
                            auditItem.setAuditStatus(bonusAuditEntity.getStatus());
                            auditItem.setBatchStatus(BonusBatchStatusEnum.UNCOMMIT.getEnCode());
                        }
                        finalAuditItemList.addAll(auditItemList);
                    }
                    summary.setPayableAmount(bonusAuditEntity.getCurrentAmount());
                    summary.setPayableRegionAmount(bonusAuditEntity.getCurrentRegionAmount());
                    summary.setPayableImplAmount(bonusAuditEntity.getCurrentImplAmount());
                    summary.setPayableBusinessAmount(bonusAuditEntity.getCurrentBusinessAmount());
                    summary.setPayablePreSalesAmount(bonusAuditEntity.getCurrentPreSalesAmount());
                    summary.setPayableDevAmount(bonusAuditEntity.getCurrentDevAmount());
                    summary.setPayableAfterSalesAmount(bonusAuditEntity.getCurrentAfterSalesAmount());
                    summary.setActualAmount(MathUtils.add(summary.getPayableAmount(), summary.getAdjustAmount()));
                    summary.setActualRegionAmount(MathUtils.add(summary.getPayableRegionAmount(), summary.getAdjustRegionAmount()));
                    summary.setActualImplAmount(MathUtils.add(summary.getPayableImplAmount(), summary.getAdjustImplAmount()));
                    summary.setActualBusinessAmount(MathUtils.add(summary.getPayableBusinessAmount(), summary.getAdjustBusinessAmount()));
                    summary.setActualPreSalesAmount(MathUtils.add(summary.getPayablePreSalesAmount(), summary.getAdjustPreSalesAmount()));
                    summary.setActualDevAmount(MathUtils.add(summary.getPayableDevAmount(), summary.getAdjustDevAmount()));
                    summary.setActualAfterSalesAmount(MathUtils.add(summary.getPayableAfterSalesAmount(), summary.getAdjustAfterSalesAmount()));
                    summary.setPendingAmount(MathUtils.substract(summary.getActualAmount(), summary.getPaidAmount()));
                    summary.setPendingRegionAmount(MathUtils.substract(summary.getActualRegionAmount(), summary.getPaidRegionAmount()));
                    summary.setPendingImplAmount(MathUtils.substract(summary.getActualImplAmount(), summary.getPaidImplAmount()));
                    summary.setPendingBusinessAmount(MathUtils.substract(summary.getActualBusinessAmount(), summary.getPaidBusinessAmount()));
                    summary.setPendingPreSalesAmount(MathUtils.substract(summary.getActualPreSalesAmount(), summary.getPaidPreSalesAmount()));
                    summary.setPendingDevAmount(MathUtils.substract(summary.getActualDevAmount(), summary.getPaidDevAmount()));
                    summary.setPendingAfterSalesAmount(MathUtils.substract(summary.getActualAfterSalesAmount(), summary.getPaidAfterSalesAmount()));
                    summary.setAccountAgain("0");
                    summary.setLatestBonusId(bonusAuditEntity.getId());
                    if (addSummary) {
                        summary.setId(RandomUtil.uuId());
                        finalSummaryCrList.add(summary);
                    } else {
                        finalSummaryUpdList.add(summary);
                    }
                    bonusAuditEntity.setSummaryId(summary.getId());
                    if (StringUtils.isNotEmpty((String)summary.getProjectId())) {
                        projectWrapper = new UpdateWrapper();
                        projectWrapper.lambda().set(RkContractProjectEntity::getBonusSummaryId, (Object)summary.getId());
                        projectWrapper.lambda().eq(RkContractProjectEntity::getId, (Object)summary.getProjectId());
                        this.rkContractProjectService.update((Wrapper)projectWrapper);
                    } else {
                        contractWrapper = new UpdateWrapper();
                        contractWrapper.lambda().set(RkContractEntity::getBonusSummaryId, (Object)summary.getId());
                        contractWrapper.lambda().eq(RkContractEntity::getId, (Object)summary.getContractId());
                        this.rkContractService.update((Wrapper)contractWrapper);
                    }
                    if (CollectionUtil.isNotEmpty(result.getReturnAmountList())) {
                        bonusAuditEntity.setReturnAmountJson(JSONArray.toJSONString(result.getReturnAmountList()));
                    }
                    finalAuditList.add(bonusAuditEntity);
                }
                if (finalAuditList.size() > 0) {
                    this.saveBatch(finalAuditList);
                    if (finalAuditItemList.size() > 0) {
                        this.saleBonusAuditItemService.saveBatch(finalAuditItemList);
                    }
                }
                if (finalSummaryCrList.size() > 0) {
                    this.saleBonusSummaryService.saveBatch(finalSummaryCrList);
                }
                if (finalSummaryUpdList.size() > 0) {
                    this.saleBonusSummaryService.updateBatchById(finalSummaryUpdList);
                }
            }
        }
    }

    private void countBySubsidiaryMethod(SaleBonusAuditCrForm bonusAuditCrForm, List<SaleCountBonusDTO> contractList) {
        String companyId;
        switch (companyId = bonusAuditCrForm.getCompanyId()) {
            case "9": {
                BonusAccountUtil.saleBonusAccount(contractList);
                break;
            }
            case "14": {
                for (SaleCountBonusDTO dto : contractList) {
                    CommissionCalculator.calculateCommissionAmount(dto);
                }
                break;
            }
            case "3": {
                break;
            }
            case "2": {
                break;
            }
            default: {
                this.buildVirtualData(contractList);
            }
        }
    }

    private void buildVirtualData(List<SaleCountBonusDTO> contractList) {
        ArrayList<SaleBonusAuditItemEntity> userList = null;
        SaleBonusAuditItemEntity user = null;
        for (SaleCountBonusDTO result : contractList) {
            result.setPayableAmount(MathUtils.multiply(result.getValidContractAmount(), result.getContractReturnRatio()).divide(BigDecimal.valueOf(100L)).multiply(BigDecimal.valueOf(0.3)));
            result.setPayableBusinessAmount(result.getPayableAmount());
            userList = new ArrayList<SaleBonusAuditItemEntity>();
            user = new SaleBonusAuditItemEntity();
            user.setUserId(result.getSalerId());
            user.setBonusType(SaleBonusTypeEnum.BUSINESS.getEnCode());
            user.setPayableAmount(result.getPayableAmount().multiply(BigDecimal.valueOf(0.8)));
            userList.add(user);
            user = new SaleBonusAuditItemEntity();
            user.setUserId(result.getSalerHigherUp());
            user.setBonusType(SaleBonusTypeEnum.BUSINESS.getEnCode());
            user.setPayableAmount(result.getPayableAmount().multiply(BigDecimal.valueOf(0.2)));
            userList.add(user);
            result.setUserList(userList);
        }
    }

    public List<SaleCountBonusDTO> sendHttpAccountBonus(SaleBonusAuditCrForm bonusAuditCrForm, List<SaleCountBonusDTO> contractList) {
        List result = null;
        try {
            JSONObject returnData;
            JSONObject param;
            HttpEntity requestEntity;
            ResponseEntity response;
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(null, (cert, authType) -> true).build();
            CloseableHttpClient httpClient = HttpClients.custom().setSSLContext(sslContext).build();
            HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
            requestFactory.setHttpClient((HttpClient)httpClient);
            requestFactory.setConnectTimeout(10000);
            requestFactory.setReadTimeout(10000);
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            String url = "";
            if ("9".equals(bonusAuditCrForm.getCompanyId())) {
                url = this.opportunityPushConfig.getIsTest() == 1 ? "" : "";
            }
            if (StringUtils.isNotEmpty((String)((String)(response = restTemplate.postForEntity(url, (Object)(requestEntity = new HttpEntity((Object)(param = JSONObject.parseObject((String)JSONObject.toJSONString(contractList))), (MultiValueMap)headers)), String.class, new Object[0])).getBody())) && StringUtils.isNotEmpty((String)(returnData = JSONObject.parseObject((String)((String)response.getBody()))).getString("contractList"))) {
                result = JSONObject.parseArray((String)returnData.getString("contractList"), SaleCountBonusDTO.class);
            }
        }
        catch (Exception e) {
            result = null;
            this.log.error("\u5956\u91d1\u6838\u7b97\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    @Override
    public UserDepartmentDTO getUserDepartment(String userId) {
        if (StringUtils.isEmpty((String)userId)) {
            return null;
        }
        UserDepartmentDTO userDepartmentDTO = new UserDepartmentDTO();
        userDepartmentDTO.setUserId(userId);
        UserEntity userEntity = this.userService.getInfo(userId);
        if (null != userEntity) {
            userDepartmentDTO.setUserName(userEntity.getRealName());
            userDepartmentDTO.setPositionId(userEntity.getPositionId());
            userDepartmentDTO.setPositionName(this.baseDataUtil.posSelectValues(userEntity.getPositionId()));
            userDepartmentDTO.setHigherUp(userEntity.getManagerId());
            userDepartmentDTO.setHigherUpName(this.baseDataUtil.userSelectValue(userEntity.getManagerId()));
            OrganizeEntity organizeEntity = this.organizeService.getInfo(userEntity.getOrganizeId());
            if (null != organizeEntity) {
                userDepartmentDTO.setDepartment(organizeEntity.getId());
                userDepartmentDTO.setDepartmentName(organizeEntity.getFullName());
                String organizeIdTree = organizeEntity.getOrganizeIdTree();
                CharSequence[] organizeIdTreeArray = organizeIdTree.split(",");
                userDepartmentDTO.setDepartmentOne(organizeIdTreeArray[2]);
                userDepartmentDTO.setDepartmentOneName(this.baseDataUtil.comSelectValues(userDepartmentDTO.getDepartmentOne()));
                organizeIdTreeArray = Arrays.copyOfRange(organizeIdTreeArray, 2, organizeIdTreeArray.length);
                userDepartmentDTO.setDepartmentTree(String.join((CharSequence)",", organizeIdTreeArray));
                userDepartmentDTO.setDepartmentTreeName(this.baseDataUtil.comSelectValues(userDepartmentDTO.getDepartmentTree()));
                userDepartmentDTO.setDepartmentManager(organizeEntity.getManagerId());
                userDepartmentDTO.setDepartmentManagerName(this.baseDataUtil.userSelectValue(userDepartmentDTO.getDepartmentManager()));
            }
        }
        return userDepartmentDTO;
    }

    @Override
    public SaleBonusAuditInfoVO queryInfo(String id) {
        SaleBonusAuditEntity entity = this.getInfo(id);
        SaleBonusAuditInfoVO vo = (SaleBonusAuditInfoVO)JsonUtil.getJsonToBean((Object)entity, SaleBonusAuditInfoVO.class);
        vo.setContractTypeName(this.baseDataUtil.getDictName(vo.getContractType(), "contractType"));
        return vo;
    }

    @Override
    public void editInfo(SaleBonusAuditUpForm saleBonusAuditUpForm) {
        SaleBonusAuditEntity entity = (SaleBonusAuditEntity)JsonUtil.getJsonToBean((Object)saleBonusAuditUpForm, SaleBonusAuditEntity.class);
        this.updateById(entity);
        this.rkAttachmentService.deleteByObjId(saleBonusAuditUpForm.getId());
        List<RkAttachmentEntity> attachmentList = saleBonusAuditUpForm.getAttachmentList();
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            attachmentList.stream().forEach(attach -> {
                attach.setId(RandomUtil.uuId());
                attach.setObjId(entity.getId());
                attach.setFileType(AttachmentTypeEnum.BONUS_AUDIT_TYPE.getType());
            });
            this.rkAttachmentService.saveBatch(attachmentList);
        }
    }

    @Override
    public SaleBonusAuditSummaryDTO countData(SaleBonusAuditPagination saleBonusAuditPagination) {
        saleBonusAuditPagination.setIsSort(false);
        QueryWrapper<SaleBonusAuditEntity> queryWrapper = this.appendWrapper(saleBonusAuditPagination);
        queryWrapper.select(new String[]{"sum(actual_amount) actualAmount,sum(paid_amount) paidAmount,sum(pending_amount) pendingAmount"});
        Map summaryMap = this.getMap((Wrapper)queryWrapper);
        SaleBonusAuditSummaryDTO summary = (SaleBonusAuditSummaryDTO)JsonUtil.getJsonToBean((Object)summaryMap, SaleBonusAuditSummaryDTO.class);
        if (null == summary) {
            summary = new SaleBonusAuditSummaryDTO();
            summary.setActualAmount(BigDecimal.ZERO);
            summary.setPaidAmount(BigDecimal.ZERO);
            summary.setPendingAmount(BigDecimal.ZERO);
        }
        saleBonusAuditPagination.setStatus(null);
        queryWrapper = this.appendWrapper(saleBonusAuditPagination);
        queryWrapper.select(new String[]{"count(1) as count, status"});
        queryWrapper.groupBy((Object)"status");
        List maps = this.listMaps((Wrapper)queryWrapper);
        HashMap<String, Object> statusCount = new HashMap<String, Object>();
        int allCount = 0;
        for (Map map : maps) {
            allCount += Integer.parseInt(map.get("count").toString());
            statusCount.put(map.get("status").toString(), Integer.parseInt(map.get("count").toString()));
        }
        statusCount.put("all", allCount);
        summary.setStatusCount(statusCount);
        return summary;
    }

    @Override
    public List<SaleBonusAuditEntity> queryListByIds(List<String> bonusId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(SaleBonusAuditEntity::getId, bonusId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SaleBonusAuditEntity> queryListByFlowId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleBonusAuditEntity::getFlowId, (Object)id);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SaleBonusAuditEntity> queryListByBatchId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleBonusAuditEntity::getBonusBatchId, (Object)id);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void removeByFlowId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleBonusAuditEntity::getFlowId, (Object)id);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public SaleBonusSummaryEntity summaryData(SaleBonusAuditEntity bonusAuditEntity) {
        return this.saleBonusAuditMapper.summaryData(bonusAuditEntity);
    }
}

