/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.bonus.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.bonus.entity.SaleBonusAuditEntity;
import com.bringspring.bonus.entity.SaleBonusAuditItemEntity;
import com.bringspring.bonus.entity.SaleBonusBatchEntity;
import com.bringspring.bonus.mapper.SaleBonusAuditMapper;
import com.bringspring.bonus.mapper.SaleBonusBatchMapper;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditListVO;
import com.bringspring.bonus.model.salebonusaudit.SaleBonusAuditSummaryDTO;
import com.bringspring.bonus.model.salebonusaudititem.SaleBonusAuditItemModel;
import com.bringspring.bonus.model.salebonusaudititem.SaleBonusAuditItemPagination;
import com.bringspring.bonus.model.salebonusbatch.SaleBonusBatchCrForm;
import com.bringspring.bonus.model.salebonusbatch.SaleBonusBatchInfoVO;
import com.bringspring.bonus.model.salebonusbatch.SaleBonusBatchListVO;
import com.bringspring.bonus.model.salebonusbatch.SaleBonusBatchPagination;
import com.bringspring.bonus.model.salebonusbatch.SaleBonusBatchUpForm;
import com.bringspring.bonus.service.SaleBonusAuditItemService;
import com.bringspring.bonus.service.SaleBonusAuditService;
import com.bringspring.bonus.service.SaleBonusBatchService;
import com.bringspring.bonus.service.SaleBonusSummaryService;
import com.bringspring.bonus.util.BonusBatchStatusEnum;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.utils.CustomizeSortWrapper;
import com.bringspring.workflow.engine.annotation.FlowCallBackMethod;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="saleBonusGrantServiceImpl")
public class SaleBonusBatchServiceImpl
extends ServiceImpl<SaleBonusBatchMapper, SaleBonusBatchEntity>
implements SaleBonusBatchService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private SaleBonusAuditService saleBonusAuditService;
    @Autowired
    private SaleBonusAuditMapper saleBonusAuditMapper;
    @Autowired
    private SaleBonusAuditItemService saleBonusAuditItemService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private SaleBonusSummaryService saleBonusSummaryService;

    @Override
    public List<SaleBonusBatchEntity> getList(SaleBonusBatchPagination saleBonusBatchPagination) {
        QueryWrapper<SaleBonusBatchEntity> queryWrapper = this.appendWrapper(saleBonusBatchPagination);
        Page page = new Page(saleBonusBatchPagination.getCurrentPage(), saleBonusBatchPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return saleBonusBatchPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }

    private QueryWrapper<SaleBonusBatchEntity> appendWrapper(SaleBonusBatchPagination saleBonusBatchPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean permission = true;
        if (0 == saleBonusBatchPagination.getIsAuth()) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object obj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, saleBonusBatchPagination.getMenuId(), "sale_bonus_batch"));
            if (ObjectUtil.isEmpty((Object)obj)) {
                queryWrapper.lambda().eq(SaleBonusBatchEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId());
            } else {
                queryWrapper = (QueryWrapper)obj;
            }
        }
        if (StringUtils.isNotEmpty((String)StringUtils.trim((String)saleBonusBatchPagination.getBatchTitle()))) {
            queryWrapper.lambda().like(SaleBonusBatchEntity::getBatchTitle, (Object)StringUtils.trim((String)saleBonusBatchPagination.getBatchTitle()));
        }
        if (CollectionUtil.isNotEmpty(saleBonusBatchPagination.getCreatorTime())) {
            List<String> date = saleBonusBatchPagination.getCreatorTime();
            Long fir = Long.valueOf(date.get(0));
            Long sec = Long.valueOf(date.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(SaleBonusBatchEntity::getCreatorTime, (Object)new Date(fir))).le(SaleBonusBatchEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)saleBonusBatchPagination.getCompanyId())) {
            queryWrapper.lambda().eq(SaleBonusBatchEntity::getCompanyId, (Object)saleBonusBatchPagination.getCompanyId());
        }
        if (CollectionUtil.isNotEmpty(saleBonusBatchPagination.getCompanyIdList())) {
            queryWrapper.lambda().in(SaleBonusBatchEntity::getCompanyId, saleBonusBatchPagination.getCompanyIdList());
        }
        if (StringUtils.isNotEmpty((String)saleBonusBatchPagination.getStatus()) && !"all".equals(saleBonusBatchPagination.getStatus())) {
            queryWrapper.lambda().eq(SaleBonusBatchEntity::getStatus, (Object)saleBonusBatchPagination.getStatus());
        }
        if (saleBonusBatchPagination.getIsSort().booleanValue()) {
            if (StringUtils.isEmpty((String)saleBonusBatchPagination.getSidx())) {
                queryWrapper.lambda().orderByDesc(SaleBonusBatchEntity::getId);
            } else {
                try {
                    QueryWrapper customSortWrapper = CustomizeSortWrapper.appendWrapper(saleBonusBatchPagination, new SaleBonusBatchListVO(), queryWrapper);
                    if (ObjectUtil.isNull((Object)customSortWrapper)) {
                        String sidx = saleBonusBatchPagination.getSidx();
                        SaleBonusBatchEntity saleBonusAuditEntity = new SaleBonusBatchEntity();
                        Field declaredField = saleBonusAuditEntity.getClass().getDeclaredField(sidx);
                        declaredField.setAccessible(true);
                        String value = declaredField.getAnnotation(TableField.class).value();
                        queryWrapper = "asc".equals(saleBonusBatchPagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
                    } else {
                        queryWrapper = customSortWrapper;
                    }
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
        }
        return queryWrapper;
    }

    @Override
    public List<SaleBonusBatchEntity> getTypeList(SaleBonusBatchPagination saleBonusBatchPagination, String dataType) {
        QueryWrapper<SaleBonusBatchEntity> queryWrapper = this.appendWrapper(saleBonusBatchPagination);
        if ("0".equals(dataType)) {
            Page page = new Page(saleBonusBatchPagination.getCurrentPage(), saleBonusBatchPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return saleBonusBatchPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public SaleBonusBatchEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleBonusBatchEntity::getId, (Object)id);
        return (SaleBonusBatchEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(SaleBonusBatchEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void insertInfo(SaleBonusBatchCrForm saleBonusBatchCrForm) {
        SaleBonusBatchEntity entity = (SaleBonusBatchEntity)JsonUtil.getJsonToBean((Object)((Object)saleBonusBatchCrForm), SaleBonusBatchEntity.class);
        entity.setStatus(BonusBatchStatusEnum.UNCOMMIT.getEnCode());
        BigDecimal actualAmount = BigDecimal.ZERO;
        List<SaleBonusAuditEntity> bonusList = saleBonusBatchCrForm.getBonusList();
        for (SaleBonusAuditEntity bonus : bonusList) {
            bonus.setBonusBatchId(entity.getId());
            actualAmount = MathUtils.add(actualAmount, bonus.getActualAmount());
            this.saleBonusAuditItemService.fillBatchId(entity.getId(), bonus.getId());
        }
        entity.setActualAmount(actualAmount);
        entity.setPaidAmount(BigDecimal.ZERO);
        entity.setPendingAmount(actualAmount);
        this.save(entity);
        this.saleBonusAuditService.updateBatchById(bonusList);
        List<RkAttachmentEntity> attachmentList = saleBonusBatchCrForm.getAttachmentList();
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            attachmentList.stream().forEach(attach -> {
                attach.setId(RandomUtil.uuId());
                attach.setObjId(entity.getId());
                attach.setFileType(AttachmentTypeEnum.BONUS_AUDIT_BATCH_TYPE.getType());
            });
            this.rkAttachmentService.saveBatch(attachmentList);
        }
    }

    @Override
    public void editInfo(SaleBonusBatchUpForm saleBonusBatchUpForm) {
        SaleBonusBatchEntity entity = (SaleBonusBatchEntity)JsonUtil.getJsonToBean((Object)((Object)saleBonusBatchUpForm), SaleBonusBatchEntity.class);
        this.releaseBonus(entity.getId());
        BigDecimal actualAmount = BigDecimal.ZERO;
        List<SaleBonusAuditEntity> bonusList = saleBonusBatchUpForm.getBonusList();
        for (SaleBonusAuditEntity bonus : bonusList) {
            bonus.setBonusBatchId(entity.getId());
            actualAmount = MathUtils.add(actualAmount, bonus.getActualAmount());
            this.saleBonusAuditItemService.fillBatchId(entity.getId(), bonus.getId());
        }
        entity.setActualAmount(actualAmount);
        entity.setPaidAmount(BigDecimal.ZERO);
        entity.setPendingAmount(actualAmount);
        this.updateById(entity);
        this.saleBonusAuditService.updateBatchById(bonusList);
        this.rkAttachmentService.deleteByObjId(saleBonusBatchUpForm.getId());
        List<RkAttachmentEntity> attachmentList = saleBonusBatchUpForm.getAttachmentList();
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            attachmentList.stream().forEach(attach -> {
                attach.setId(RandomUtil.uuId());
                attach.setObjId(entity.getId());
                attach.setFileType(AttachmentTypeEnum.BONUS_AUDIT_BATCH_TYPE.getType());
            });
            this.rkAttachmentService.saveBatch(attachmentList);
        }
    }

    @Override
    public void releaseBonus(String id) {
        UpdateWrapper auditWrapper = new UpdateWrapper();
        auditWrapper.lambda().set(SaleBonusAuditEntity::getBonusBatchId, (Object)"");
        auditWrapper.lambda().eq(SaleBonusAuditEntity::getBonusBatchId, (Object)id);
        this.saleBonusAuditService.update((Wrapper)auditWrapper);
        UpdateWrapper itemWrapper = new UpdateWrapper();
        itemWrapper.lambda().set(SaleBonusAuditItemEntity::getBonusBatchId, (Object)"");
        itemWrapper.lambda().set(SaleBonusAuditItemEntity::getBatchStatus, (Object)BonusBatchStatusEnum.UNCOMMIT.getEnCode());
        itemWrapper.lambda().eq(SaleBonusAuditItemEntity::getBonusBatchId, (Object)id);
        this.saleBonusAuditItemService.update((Wrapper)itemWrapper);
    }

    @Override
    public SaleBonusBatchInfoVO queryInfo(String id) {
        SaleBonusBatchEntity entity = this.getInfo(id);
        SaleBonusBatchInfoVO vo = (SaleBonusBatchInfoVO)JsonUtil.getJsonToBean((Object)entity, SaleBonusBatchInfoVO.class);
        List<SaleBonusAuditEntity> bonusList = this.saleBonusAuditService.queryListByBatchId(entity.getId());
        if (CollectionUtil.isNotEmpty(bonusList)) {
            List bonusVOList = JsonUtil.getJsonToList(bonusList, SaleBonusAuditListVO.class);
            vo.setBonusList(bonusVOList);
        }
        SaleBonusAuditItemPagination pagination = new SaleBonusAuditItemPagination();
        pagination.setBonusBatchId(entity.getId());
        List<SaleBonusAuditItemModel> summaryList = this.saleBonusAuditItemService.summaryGroupByUser(pagination);
        vo.setBonusSummaryList(summaryList);
        List<RkAttachmentEntity> attachmentList = this.rkAttachmentService.getListByObjId(id);
        vo.setAttachmentList(attachmentList);
        return vo;
    }

    @Override
    @FlowCallBackMethod(fullName="\u5956\u91d1\u5ba1\u6838\u6d41\u7a0b\u56de\u8c03")
    public boolean updateEnableMarkById(String id, Integer enableMark, FlowModel model) {
        SaleBonusBatchEntity entity = this.getInfo(id);
        if (null != entity) {
            if ("7".equals(enableMark)) {
                this.releaseBonus(id);
                this.delete(entity);
            } else {
                entity.setFlowStatus(enableMark);
                entity.setStatus(BonusBatchStatusEnum.AUDIT.getEnCode());
                if (ObjectUtil.equal((Object)enableMark, (Object)2)) {
                    entity.setStatus(BonusBatchStatusEnum.GRANT.getEnCode());
                    BigDecimal paidAmount = BigDecimal.ZERO;
                    BigDecimal pendingAmount = BigDecimal.ZERO;
                    List<SaleBonusAuditItemEntity> bonusItemList = this.saleBonusAuditItemService.queryByBatchId(id);
                    if (CollectionUtil.isNotEmpty(bonusItemList)) {
                        ArrayList<String> bonusIds = new ArrayList<String>();
                        for (SaleBonusAuditItemEntity item : bonusItemList) {
                            item.setPaidAmount(item.getActualAmount());
                            item.setPendingAmount(BigDecimal.ZERO);
                            if (!bonusIds.contains(item.getBonusId())) {
                                bonusIds.add(item.getBonusId());
                            }
                            item.setBatchStatus(entity.getStatus());
                            paidAmount = MathUtils.add(paidAmount, item.getPaidAmount());
                            pendingAmount = MathUtils.add(pendingAmount, item.getPendingAmount());
                        }
                        this.saleBonusAuditItemService.updateBatchById(bonusItemList);
                        this.saleBonusAuditMapper.updatePaidAmount(bonusIds);
                        this.saleBonusSummaryService.updateSummaryData(bonusIds);
                    }
                    entity.setPaidAmount(paidAmount);
                    entity.setPendingAmount(pendingAmount);
                } else {
                    if (ObjectUtil.equal((Object)enableMark, (Object)3) || ObjectUtil.equal((Object)enableMark, (Object)6)) {
                        entity.setStatus(BonusBatchStatusEnum.UNCOMMIT.getEnCode());
                    } else if (ObjectUtil.equal((Object)enableMark, (Object)5) && "0".equals(model.getRejectAgreeStep())) {
                        entity.setStatus(BonusBatchStatusEnum.UNCOMMIT.getEnCode());
                    }
                    UpdateWrapper itemWrapper = new UpdateWrapper();
                    itemWrapper.lambda().set(SaleBonusAuditItemEntity::getBatchStatus, (Object)entity.getStatus());
                    itemWrapper.lambda().eq(SaleBonusAuditItemEntity::getBonusBatchId, (Object)id);
                    this.saleBonusAuditItemService.update((Wrapper)itemWrapper);
                }
                this.updateById(entity);
            }
        }
        return true;
    }

    @Override
    public SaleBonusAuditSummaryDTO countData(SaleBonusBatchPagination saleBonusBatchPagination) {
        saleBonusBatchPagination.setIsSort(false);
        QueryWrapper<SaleBonusBatchEntity> queryWrapper = this.appendWrapper(saleBonusBatchPagination);
        queryWrapper.select(new String[]{"sum(actual_amount) actualAmount,sum(paid_amount) paidAmount,sum(pending_amount) pendingAmount"});
        Map summaryMap = this.getMap((Wrapper)queryWrapper);
        SaleBonusAuditSummaryDTO summary = (SaleBonusAuditSummaryDTO)JsonUtil.getJsonToBean((Object)summaryMap, SaleBonusAuditSummaryDTO.class);
        if (null == summary) {
            summary = new SaleBonusAuditSummaryDTO();
            summary.setActualAmount(BigDecimal.ZERO);
            summary.setPaidAmount(BigDecimal.ZERO);
            summary.setPendingAmount(BigDecimal.ZERO);
        }
        saleBonusBatchPagination.setStatus(null);
        queryWrapper = this.appendWrapper(saleBonusBatchPagination);
        queryWrapper.select(new String[]{"count(1) as count, status"});
        queryWrapper.groupBy((Object)"status");
        List maps = this.listMaps((Wrapper)queryWrapper);
        HashMap<String, Object> statusCount = new HashMap<String, Object>();
        int allCount = 0;
        for (Map map : maps) {
            allCount += Integer.parseInt(map.get("count").toString());
            statusCount.put(map.get("status").toString(), Integer.parseInt(map.get("count").toString()));
        }
        statusCount.put("all", allCount);
        summary.setStatusCount(statusCount);
        return summary;
    }

    @Override
    public long countAuditNum(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SaleBonusAuditEntity::getBonusBatchId, (Object)id);
        return this.saleBonusAuditService.count((Wrapper)queryWrapper);
    }
}

