/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.bonus.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.bonus.entity.SaleBonusAuditEntity;
import com.bringspring.bonus.entity.SaleBonusSummaryEntity;
import com.bringspring.bonus.mapper.SaleBonusSummaryMapper;
import com.bringspring.bonus.service.SaleBonusAuditItemService;
import com.bringspring.bonus.service.SaleBonusAuditService;
import com.bringspring.bonus.service.SaleBonusSummaryService;
import com.bringspring.common.exception.DataException;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SaleBonusSummaryServiceImpl
extends ServiceImpl<SaleBonusSummaryMapper, SaleBonusSummaryEntity>
implements SaleBonusSummaryService {
    @Autowired
    private SaleBonusAuditService saleBonusAuditService;
    @Autowired
    private SaleBonusAuditItemService saleBonusAuditItemService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private SaleBonusSummaryMapper salesBonusSummaryMapper;

    @Override
    public void create(SaleBonusSummaryEntity entity) {
        this.save(entity);
    }

    @Override
    public List<SaleBonusSummaryEntity> queryListByContractIds(List<String> contractIdList) {
        if (CollectionUtils.isEmpty(contractIdList)) {
            return new ArrayList<SaleBonusSummaryEntity>();
        }
        return this.list((Wrapper)new QueryWrapper().lambda().in(SaleBonusSummaryEntity::getContractId, contractIdList));
    }

    @Override
    public void summaryAfterDel(SaleBonusAuditEntity bonusAuditEntity) throws DataException {
        SaleBonusSummaryEntity summary;
        if (null != bonusAuditEntity && null != (summary = this.queryByBonus(bonusAuditEntity))) {
            if (StringUtils.isEmpty((CharSequence)bonusAuditEntity.getPreBonusId())) {
                this.removeById(summary);
                if (StringUtils.isNotEmpty((CharSequence)summary.getProjectId())) {
                    UpdateWrapper projectWrapper = new UpdateWrapper();
                    projectWrapper.lambda().set(RkContractProjectEntity::getBonusSummaryId, (Object)"");
                    projectWrapper.lambda().eq(RkContractProjectEntity::getId, (Object)summary.getProjectId());
                    this.rkContractProjectService.update((Wrapper)projectWrapper);
                } else {
                    UpdateWrapper contractWrapper = new UpdateWrapper();
                    contractWrapper.lambda().set(RkContractEntity::getBonusSummaryId, (Object)"");
                    contractWrapper.lambda().eq(RkContractEntity::getId, (Object)summary.getContractId());
                    this.rkContractService.update((Wrapper)contractWrapper);
                }
            } else {
                summary.setAccountAgain("1");
                summary.setLatestBonusId(bonusAuditEntity.getPreBonusId());
                SaleBonusAuditEntity preBonus = (SaleBonusAuditEntity)this.saleBonusAuditService.getById((Serializable)((Object)bonusAuditEntity.getPreBonusId()));
                if (null == preBonus) {
                    throw new DataException("\u672a\u627e\u5230\u4e0a\u4e00\u6b21\u6838\u7b97\u6570\u636e");
                }
                BeanUtils.copyProperties((Object)preBonus, (Object)summary);
                SaleBonusSummaryEntity sumData = this.saleBonusAuditService.summaryData(bonusAuditEntity);
                BeanUtils.copyProperties((Object)sumData, (Object)summary);
                this.updateById(summary);
            }
        }
    }

    @Override
    public SaleBonusSummaryEntity queryByBonus(SaleBonusAuditEntity saleBonusAuditEntity) {
        return (SaleBonusSummaryEntity)this.getById((Serializable)((Object)saleBonusAuditEntity.getSummaryId()));
    }

    @Override
    public void updateSummaryData(List<String> bonusIds) {
        this.salesBonusSummaryMapper.updateSummaryData(bonusIds);
    }
}

