/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.bonus.util;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.bringspring.bonus.entity.SaleBonusAuditItemEntity;
import com.bringspring.bonus.model.salebonusaudit.SaleCountBonusDTO;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public class BonusAccountUtil {
    public static List<SaleCountBonusDTO> saleBonusAccount(List<SaleCountBonusDTO> contractList) {
        MathContext mc = new MathContext(2, RoundingMode.HALF_UP);
        String[] saleRate = new String[]{"0.01", "0.03", "0.04", "0.05"};
        String manageRate = "0.015";
        String qdbRate = "0.02";
        String qdbManageRate = "0.01";
        String zyRate = "0.015";
        String zyMahageRate = "0.01";
        contractList.stream().forEach(contract -> {
            if (contract.getContractReturnRatio().compareTo(new BigDecimal("30")) < 0) {
                contract.setPayableBusinessAmount(BigDecimal.ZERO);
                contract.setPayableAmount(BigDecimal.ZERO);
                return;
            }
            BigDecimal ratio = BigDecimal.ZERO;
            BigDecimal saleBonus = BigDecimal.ZERO;
            BigDecimal manageBouns = BigDecimal.ZERO;
            BigDecimal paySaleBonus = BigDecimal.ZERO;
            BigDecimal payManageBouns = BigDecimal.ZERO;
            if (StringUtils.isNotEmpty((CharSequence)contract.getDepartmentTreeName())) {
                if (contract.getDepartmentTreeName().contains("\u9500\u552e\u7ba1\u7406\u90e8")) {
                    if (contract.getContractProfitRate().compareTo(new BigDecimal(0)) >= 0 && contract.getContractProfitRate().compareTo(new BigDecimal(10)) <= 0) {
                        ratio = new BigDecimal(saleRate[0]);
                    }
                    if (contract.getContractProfitRate().compareTo(new BigDecimal(11)) >= 0 && contract.getContractProfitRate().compareTo(new BigDecimal(30)) <= 0) {
                        ratio = new BigDecimal(saleRate[1]);
                    }
                    if (contract.getContractProfitRate().compareTo(new BigDecimal(31)) >= 0 && contract.getContractProfitRate().compareTo(new BigDecimal(50)) <= 0) {
                        ratio = new BigDecimal(saleRate[2]);
                    }
                    if (contract.getContractProfitRate().compareTo(new BigDecimal(51)) >= 0 && contract.getContractProfitRate().compareTo(new BigDecimal(100)) <= 0) {
                        ratio = new BigDecimal(saleRate[3]);
                    }
                    saleBonus = contract.getValidContractAmount().multiply(ratio);
                    manageBouns = contract.getValidContractAmount().multiply(new BigDecimal(manageRate));
                } else if (contract.getDepartmentTreeName().contains("\u6e20\u9053\u53d1\u5c55\u90e8")) {
                    saleBonus = contract.getValidContractAmount().multiply(new BigDecimal(qdbRate));
                    manageBouns = contract.getValidContractAmount().multiply(new BigDecimal(qdbManageRate));
                } else if ("1".equals(contract.getIsZy())) {
                    saleBonus = contract.getValidContractAmount().multiply(new BigDecimal(zyRate));
                    manageBouns = contract.getValidContractAmount().multiply(new BigDecimal(zyMahageRate));
                }
                contract.setTotalBusinessAmount(saleBonus.setScale(2, RoundingMode.HALF_UP));
                contract.setTotalRegionAmount(manageBouns.setScale(2, RoundingMode.HALF_UP));
                contract.setTotalAmount(saleBonus.add(manageBouns).setScale(2, RoundingMode.HALF_UP));
                if (contract.getContractReturnRatio().compareTo(new BigDecimal("30")) >= 0 && contract.getContractReturnRatio().compareTo(new BigDecimal("60")) <= 0) {
                    paySaleBonus = contract.getContractReturnRatio().divide(new BigDecimal(100, mc)).multiply(saleBonus).multiply(new BigDecimal("0.5")).setScale(2, RoundingMode.HALF_UP);
                    payManageBouns = !contract.getSalerId().equals(contract.getDepartmentManager()) ? contract.getContractReturnRatio().divide(new BigDecimal(100, mc)).multiply(manageBouns).multiply(new BigDecimal("0.5")).setScale(2, RoundingMode.HALF_UP) : contract.getAccountRegionAmount();
                } else {
                    paySaleBonus = contract.getContractReturnRatio().divide(new BigDecimal(100, mc)).multiply(saleBonus).setScale(2, RoundingMode.HALF_UP);
                    payManageBouns = !contract.getSalerId().equals(contract.getDepartmentManager()) ? contract.getContractReturnRatio().divide(new BigDecimal(100, mc)).multiply(manageBouns).setScale(2, RoundingMode.HALF_UP) : contract.getAccountRegionAmount();
                }
            }
            contract.setCurrentBusinessAmount(paySaleBonus);
            contract.setCurrentRegionAmount(payManageBouns);
            contract.setCurrentAmount(paySaleBonus.add(payManageBouns));
            BigDecimal subtract = paySaleBonus.subtract(contract.getAccountBusinessAmount());
            contract.setPayableBusinessAmount(subtract);
            contract.setPayableAmount(subtract);
            ArrayList<SaleBonusAuditItemEntity> userList = new ArrayList<SaleBonusAuditItemEntity>();
            SaleBonusAuditItemEntity saleAuditItem = new SaleBonusAuditItemEntity();
            saleAuditItem.setUserId(contract.getSalerId());
            saleAuditItem.setBonusType("business");
            saleAuditItem.setPayableAmount(subtract);
            userList.add(saleAuditItem);
            if (!contract.getSalerId().equals(contract.getDepartmentManager())) {
                BigDecimal subtract1 = payManageBouns.subtract(contract.getAccountRegionAmount());
                contract.setPayableRegionAmount(subtract1);
                SaleBonusAuditItemEntity manageAuditItem = new SaleBonusAuditItemEntity();
                manageAuditItem.setUserId(contract.getDepartmentManager());
                manageAuditItem.setBonusType("region");
                manageAuditItem.setPayableAmount(subtract1);
                userList.add(manageAuditItem);
                contract.setPayableAmount(subtract.add(subtract1));
            }
            contract.setUserList(userList);
        });
        return contractList;
    }
}

