/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.bonus.util;

import com.bringspring.bonus.entity.SaleBonusAuditItemEntity;
import com.bringspring.bonus.model.salebonusaudit.ReturnAmountDTO;
import com.bringspring.bonus.model.salebonusaudit.SaleCountBonusDTO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;

public class CommissionCalculator {
    private static final BigDecimal EIGHTY_PERCENT = new BigDecimal("80");
    private static final BigDecimal FIVE_PERCENT = new BigDecimal("0.05");
    private static final BigDecimal[] PROFIT_THRESHOLDS = new BigDecimal[]{new BigDecimal("1000000"), new BigDecimal("1500000"), new BigDecimal("2000000")};
    private static final BigDecimal[] COMMISSION_RATES = new BigDecimal[]{new BigDecimal("0.085"), new BigDecimal("0.09"), new BigDecimal("0.095"), new BigDecimal("0.10")};

    public static void calculateCommissionAmount(SaleCountBonusDTO dto) {
        BigDecimal base = dto.getContractProfit().subtract(dto.getContractAmount().multiply(FIVE_PERCENT));
        if (base.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        CommissionRateResult rateResult = CommissionCalculator.calculateCommissionRateWithDetail(dto);
        BigDecimal commissionRate = rateResult.rate;
        String commissionRateDesc = rateResult.desc;
        if (commissionRate.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        BigDecimal totalCommission = base.multiply(commissionRate).setScale(2, RoundingMode.HALF_UP);
        BigDecimal totalDeduct = BigDecimal.ZERO;
        StringBuilder formulaBuilder = new StringBuilder();
        formulaBuilder.append(String.format("\u63d0\u6210\u6bd4\u4f8b\uff1a%s\n", commissionRateDesc));
        formulaBuilder.append(String.format("\u603b\u5e94\u53d1\u63d0\u6210 = (\u5408\u540c\u6bdb\u5229 - \u5408\u540c\u91d1\u989d \u00d7 5%%) \u00d7 \u63d0\u6210\u6bd4\u4f8b = (%.2f - %.2f \u00d7 5%%) \u00d7 %d%% = %.2f\u5143\n", dto.getContractProfit(), dto.getContractAmount(), commissionRate.multiply(BigDecimal.valueOf(100L)).setScale(0, RoundingMode.DOWN).intValue(), totalCommission));
        formulaBuilder.append("\u6263\u9664\u660e\u7ec6\uff1a\n");
        if (dto.getReturnAmountList() != null) {
            for (ReturnAmountDTO ra : dto.getReturnAmountList()) {
                String type = ra.getPaymentType();
                if (!"4387384381376235571".equals(type) && !"4387382873482004531".equals(type)) continue;
                DeductResult deductResult = CommissionCalculator.calculateDeductRatioWithDesc(ra);
                ra.setReduceAmount(BigDecimal.ZERO);
                ra.setCalcProcess("");
                if (deductResult.ratio.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal returnRatio = ra.getReturnAmount().divide(dto.getContractAmount(), 4, RoundingMode.HALF_UP);
                BigDecimal returnCommission = totalCommission.multiply(returnRatio);
                BigDecimal deduct = returnCommission.multiply(deductResult.ratio).setScale(2, RoundingMode.HALF_UP);
                totalDeduct = totalDeduct.add(deduct);
                ra.setReduceAmount(deduct);
                String calcProcess = String.format("\u6263\u6b3e = \u603b\u63d0\u6210 \u00d7 (\u56de\u6b3e\u91d1\u989d/\u5408\u540c\u91d1\u989d) \u00d7 %s = %.2f \u00d7 (%.2f/%.2f) \u00d7 %d%% = %.2f\u5143", deductResult.desc, totalCommission, ra.getReturnAmount(), dto.getContractAmount(), deductResult.ratio.multiply(BigDecimal.valueOf(100L)).setScale(0, RoundingMode.DOWN).intValue(), deduct);
                ra.setCalcProcess(calcProcess);
                formulaBuilder.append("  " + calcProcess + "\n");
            }
        }
        formulaBuilder.append(String.format("\u603b\u6263\u6b3e\uff1a%.2f\u5143\n", totalDeduct));
        BigDecimal finalAmount = totalCommission.subtract(totalDeduct).setScale(0, RoundingMode.HALF_UP);
        formulaBuilder.append(String.format("\u6700\u7ec8\u5e94\u53d1\u63d0\u6210\uff08\u53d6\u6574\uff09\uff1a%.2f\u5143\n", finalAmount));
        BigDecimal currentAmount = finalAmount.multiply(dto.getContractReturnRatio()).divide(BigDecimal.valueOf(100L)).setScale(0, RoundingMode.HALF_UP);
        formulaBuilder.append(String.format("\u7d2f\u8ba1\u5e94\u53d1\u63d0\u6210\uff08\u53d6\u6574\uff09= \u6700\u7ec8\u5e94\u53d1\u63d0\u6210 \u00d7 \u7d2f\u8ba1\u56de\u6b3e\u6bd4\u4f8b = %.2f \u00d7 %.2f%% = %.2f\u5143\n", finalAmount, dto.getContractReturnRatio(), currentAmount));
        dto.setCalcProcess(formulaBuilder.toString());
        dto.setCurrentBusinessAmount(currentAmount);
        dto.setPayableBusinessAmount(currentAmount.subtract(dto.getAccountBusinessAmount()));
        dto.setCurrentAmount(currentAmount);
        dto.setPayableAmount(dto.getPayableBusinessAmount());
        ArrayList<SaleBonusAuditItemEntity> userList = new ArrayList<SaleBonusAuditItemEntity>();
        SaleBonusAuditItemEntity businessBonus = new SaleBonusAuditItemEntity();
        businessBonus.setBonusType("business");
        businessBonus.setUserId(dto.getSalerId());
        businessBonus.setPayableAmount(dto.getPayableBusinessAmount());
        userList.add(businessBonus);
        dto.setUserList(userList);
    }

    private static CommissionRateResult calculateCommissionRateWithDetail(SaleCountBonusDTO dto) {
        String productType = dto.getProductType();
        BigDecimal profit = dto.getContractProfit();
        BigDecimal profitRate = dto.getContractProfitRate().divide(BigDecimal.valueOf(100L));
        if ("418769474020204677".equals(productType)) {
            BigDecimal rate = new BigDecimal("0.12");
            String desc = "12%\uff08\u8840\u6db2\u900f\u6790\uff09";
            return new CommissionRateResult(rate, desc);
        }
        if ("509671790159598277".equals(productType)) {
            if (profit.compareTo(new BigDecimal("1000000")) <= 0) {
                BigDecimal rate = new BigDecimal("0.085");
                String desc = "8.5%\uff08\u5b9e\u8bad\u2264100\u4e07\uff09";
                return new CommissionRateResult(rate, desc);
            }
            if (profit.compareTo(new BigDecimal("1500000")) <= 0) {
                BigDecimal rate = new BigDecimal("0.09");
                String desc = "9%\uff08\u5b9e\u8bad\u2264150\u4e07\uff09";
                return new CommissionRateResult(rate, desc);
            }
            if (profit.compareTo(new BigDecimal("2000000")) <= 0) {
                BigDecimal rate = new BigDecimal("0.095");
                String desc = "9.5%\uff08\u5b9e\u8bad\u2264200\u4e07\uff09";
                return new CommissionRateResult(rate, desc);
            }
            BigDecimal rate = new BigDecimal("0.10");
            String desc = "10%\uff08\u5b9e\u8bad>200\u4e07\uff09";
            return new CommissionRateResult(rate, desc);
        }
        if ("674873440351560325".equals(productType)) {
            if (profit.compareTo(new BigDecimal("200000")) <= 0) {
                BigDecimal rate = new BigDecimal("0.10");
                String desc = "10%\uff085G\u6025\u6551\u226420\u4e07\uff09";
                return new CommissionRateResult(rate, desc);
            }
            BigDecimal rate = new BigDecimal("0.12");
            String desc = "12%\uff085G\u6025\u6551>20\u4e07\uff09";
            return new CommissionRateResult(rate, desc);
        }
        if (("687253019825285317".equals(productType) || "700724189614572037".equals(productType)) && (dto.getContractAmount().compareTo(new BigDecimal("200000")) < 0 || profitRate.compareTo(new BigDecimal("0.5")) >= 0)) {
            if (profitRate.compareTo(new BigDecimal("0.55")) < 0) {
                BigDecimal rate = new BigDecimal("0.10");
                String desc = "10%\uff08AI/\u673a\u5668\u4eba<55%\uff09";
                return new CommissionRateResult(rate, desc);
            }
            if (profitRate.compareTo(new BigDecimal("0.60")) < 0) {
                BigDecimal rate = new BigDecimal("0.11");
                String desc = "11%\uff08AI/\u673a\u5668\u4eba<60%\uff09";
                return new CommissionRateResult(rate, desc);
            }
            if (profitRate.compareTo(new BigDecimal("0.65")) < 0) {
                BigDecimal rate = new BigDecimal("0.12");
                String desc = "12%\uff08AI/\u673a\u5668\u4eba<65%\uff09";
                return new CommissionRateResult(rate, desc);
            }
            if (profitRate.compareTo(new BigDecimal("0.70")) < 0) {
                BigDecimal rate = new BigDecimal("0.13");
                String desc = "13%\uff08AI/\u673a\u5668\u4eba<70%\uff09";
                return new CommissionRateResult(rate, desc);
            }
            if (profitRate.compareTo(new BigDecimal("0.70")) >= 0) {
                BigDecimal rate = new BigDecimal("0.14");
                String desc = "14%\uff08AI/\u673a\u5668\u4eba\u226570%\uff09";
                return new CommissionRateResult(rate, desc);
            }
        }
        if (profitRate.compareTo(new BigDecimal("0.5")) < 0 && !"410819565098899333".equals(dto.getSalerId())) {
            BigDecimal rate = new BigDecimal("0.06");
            String desc = "6%\uff08\u6bdb\u5229\u7387<50%\uff09";
            return new CommissionRateResult(rate, desc);
        }
        BigDecimal rate = new BigDecimal("0.08");
        String desc = "8%\uff08\u6bdb\u5229\u7387\u226550%\uff09";
        return new CommissionRateResult(rate, desc);
    }

    private static DeductResult calculateDeductRatioWithDesc(ReturnAmountDTO ra) {
        if (ra.getDueDate() == null || ra.getReturnDate() == null) {
            return new DeductResult(BigDecimal.ZERO, "0%\uff08\u672a\u8d85\u671f\uff09");
        }
        long days = (ra.getReturnDate().getTime() - ra.getDueDate().getTime()) / 86400000L;
        double years = (double)days / 365.0;
        if (years < 1.0) {
            return new DeductResult(BigDecimal.ZERO, "0%\uff081\u5e74\u5185\uff09");
        }
        if (years <= 1.5) {
            return new DeductResult(new BigDecimal("0.2"), "20%\uff081-1.5\u5e74\uff09");
        }
        if (years <= 2.0) {
            return new DeductResult(new BigDecimal("0.3"), "30%\uff081.5-2\u5e74\uff09");
        }
        if (years <= 2.5) {
            return new DeductResult(new BigDecimal("0.4"), "40%\uff082-2.5\u5e74\uff09");
        }
        return new DeductResult(new BigDecimal("0.5"), "50%\uff082.5\u5e74\u4ee5\u4e0a\uff09");
    }

    private static class CommissionRateResult {
        public BigDecimal rate;
        public String desc;

        public CommissionRateResult(BigDecimal rate, String desc) {
            this.rate = rate;
            this.desc = desc;
        }
    }

    private static class DeductResult {
        public BigDecimal ratio;
        public String desc;

        public DeductResult(BigDecimal ratio, String desc) {
            this.ratio = ratio;
            this.desc = desc;
        }
    }
}

