/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.WordUtil;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.constant.AfterSalesProjectWarrantyStateEnum;
import com.bringspring.contract.entity.AfterSalesProjectsEntity;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectAuthorizationBussEntity;
import com.bringspring.contract.entity.RkProjectTrendsEntity;
import com.bringspring.contract.mapper.RkContractMapper;
import com.bringspring.contract.model.aftersalesprojects.AfterSalesProjectsCrForm;
import com.bringspring.contract.model.aftersalesprojects.AfterSalesProjectsInfoVO;
import com.bringspring.contract.model.aftersalesprojects.AfterSalesProjectsListVO;
import com.bringspring.contract.model.aftersalesprojects.AfterSalesProjectsPagination;
import com.bringspring.contract.model.aftersalesprojects.AfterSalesProjectsPaginationExportModel;
import com.bringspring.contract.model.aftersalesprojects.AfterSalesProjectsUpForm;
import com.bringspring.contract.service.AfterSalesProjectsService;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractProjectMemberService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkProjectAuthorizationBussService;
import com.bringspring.contract.service.RkProjectTrendsService;
import com.bringspring.contract.utils.ProjectStateEnum;
import com.bringspring.contract.utils.ProjectTrendsEnum;
import com.bringspring.crm.entity.CrmCustomerContactsEntity;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.model.crmcustomercontacts.LinkManSelectListVO;
import com.bringspring.crm.service.CrmCustomerContactsService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.model.organize.OrganizeCrModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.ParamAddress;
import com.bringspring.visit.service.AfterInspectTaskService;
import com.bringspring.visit.service.AfterSalesQuestionService;
import com.bringspring.visit.service.AfterSalesRepairService;
import com.bringspring.visit.service.RkMarketLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5df2\u8f6c\u552e\u540e\u9879\u76ee"}, value="contract")
@RequestMapping(value={"/api/contract/AfterSalesProjects"})
public class AfterSalesProjectsController {
    private static final Logger log = LoggerFactory.getLogger(AfterSalesProjectsController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AfterSalesProjectsService afterSalesProjectsService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractMapper rkContractMapper;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkContractProjectMemberService rkContractProjectMemberService;
    @Autowired
    private AfterInspectTaskService afterInspectTaskService;
    @Autowired
    private RkAgentService agentService;
    @Autowired
    private CrmCustomerContactsService crmCustomerContactsService;
    @Autowired
    private AfterSalesRepairService afterSalesRepairService;
    @Autowired
    private AfterSalesQuestionService afterSalesQuestionService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private UserService userService;
    @Autowired
    private RkProjectAuthorizationBussService rkProjectAuthorizationBussService;
    @Autowired
    private RkProjectTrendsService rkProjectTrendsService;
    @Autowired
    private RkMarketLogService rkMarketLogService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@ParamAddress(field="customerAddress") @RequestBody AfterSalesProjectsPagination afterSalesProjectsPagination) throws IOException {
        List<AfterSalesProjectsEntity> list = this.afterSalesProjectsService.getList(afterSalesProjectsPagination);
        for (AfterSalesProjectsEntity afterSalesProjectsEntity : list) {
            afterSalesProjectsEntity.setAfterSalesPerson(this.baseDataUtil.userSelectValues(afterSalesProjectsEntity.getAfterSalesPerson()));
            afterSalesProjectsEntity.setAfterSalesManager(this.baseDataUtil.userSelectValues(afterSalesProjectsEntity.getAfterSalesManager()));
        }
        List listVO = JsonUtil.getJsonToList(list, AfterSalesProjectsListVO.class);
        for (AfterSalesProjectsListVO afterSalesProjectsVO : listVO) {
            RkContractProjectEntity projectEntity;
            long between;
            LocalDate endDate;
            LocalDate now;
            if (ObjectUtil.isNotEmpty((Object)afterSalesProjectsVO.getWarrantyStartDate()) && ObjectUtil.isNotEmpty((Object)afterSalesProjectsVO.getWarrantyEndDate()) && !StrUtil.equals((CharSequence)afterSalesProjectsVO.getWarrantyState(), (CharSequence)"derelivery")) {
                now = LocalDate.now();
                endDate = LocalDate.ofEpochDay(afterSalesProjectsVO.getWarrantyEndDate() / 86400000L);
                between = ChronoUnit.DAYS.between(now, endDate);
                afterSalesProjectsVO.setOffDate((int)between);
            }
            if (StrUtil.equals((CharSequence)afterSalesProjectsVO.getWarrantyState(), (CharSequence)"derelivery") && ObjectUtil.isNotEmpty((Object)afterSalesProjectsVO.getWarrantyEndDate())) {
                now = LocalDate.now();
                endDate = LocalDate.ofEpochDay(afterSalesProjectsVO.getWarrantyEndDate() / 86400000L);
                between = ChronoUnit.DAYS.between(endDate, now);
                afterSalesProjectsVO.setExpireDays((int)between);
            }
            afterSalesProjectsVO.setAssistantsUserId(afterSalesProjectsVO.getAssistantsUser());
            afterSalesProjectsVO.setAssistantsUser(this.baseDataUtil.userSelectValues(afterSalesProjectsVO.getAssistantsUser()));
            afterSalesProjectsVO.setCompanyName(this.baseDataUtil.comSelectValues(afterSalesProjectsVO.getCompanyId()));
            afterSalesProjectsVO.setWarrantyStateDesc(this.baseDataUtil.getDictName(afterSalesProjectsVO.getWarrantyState(), "afterSalesProjectWarrantyState"));
            if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsVO.getProduct())) {
                List<CrmProductEntity> listByProductIds = this.crmProductService.getListByProductIds(CollectionUtil.list((boolean)false, (Object[])afterSalesProjectsVO.getProduct().split(",")));
                String collect = listByProductIds.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(","));
                afterSalesProjectsVO.setProduct(collect);
            }
            afterSalesProjectsVO.setIncomeType(this.baseDataUtil.getDictName(afterSalesProjectsVO.getIncomeType(), "incomeType"));
            if (StringUtils.isNotEmpty((String)afterSalesProjectsVO.getDepartment())) {
                afterSalesProjectsVO.setDepartmentName(this.baseDataUtil.comSelectValues(afterSalesProjectsVO.getDepartment()));
            }
            afterSalesProjectsVO.setCustomerAddressName(this.baseDataUtil.provinceData(afterSalesProjectsVO.getAddress()));
            if (StrUtil.isEmpty((CharSequence)afterSalesProjectsVO.getCustomerAddressName())) {
                afterSalesProjectsVO.setCustomerAddressName(afterSalesProjectsVO.getAddress());
            }
            if (StrUtil.isNotBlank((CharSequence)afterSalesProjectsVO.getContractId())) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.lambda().eq(RkContractEntity::getId, (Object)afterSalesProjectsVO.getContractId());
                RkContractEntity rkContractEntity = (RkContractEntity)this.rkContractMapper.selectOne((Wrapper)queryWrapper);
                if (ObjectUtil.isNotEmpty((Object)rkContractEntity)) {
                    if (StrUtil.isBlank((CharSequence)afterSalesProjectsVO.getCustomerAddressName())) {
                        afterSalesProjectsVO.setCustomerAddressName(rkContractEntity.getCustomerAddressName());
                    }
                    afterSalesProjectsVO.setContractName(rkContractEntity.getContractName());
                    afterSalesProjectsVO.setContractNo(rkContractEntity.getContractCode());
                    afterSalesProjectsVO.setSalerName(rkContractEntity.getSalerName());
                    afterSalesProjectsVO.setContractSignTime(rkContractEntity.getSignDate());
                    if (!ObjectUtil.isNull((Object)rkContractEntity.getIsAgent()) && rkContractEntity.getIsAgent() == 1) {
                        afterSalesProjectsVO.setAgentName(((RkAgentEntity)this.agentService.getById((Serializable)((Object)rkContractEntity.getAgentId()))).getName());
                    } else {
                        afterSalesProjectsVO.setAgentName(rkContractEntity.getCustomerName());
                    }
                    afterSalesProjectsVO.setWarranty(rkContractEntity.getWarranty());
                }
            }
            if (ObjectUtil.isNull((Object)(projectEntity = this.rkContractProjectService.getInfo(afterSalesProjectsVO.getProjectId())))) {
                afterSalesProjectsVO.setManHourProjectState(1);
                continue;
            }
            if (!ObjectUtil.isNotNull((Object)afterSalesProjectsVO.getWarranty()) || !ObjectUtil.isNotNull((Object)projectEntity.getAcceptanceTime())) continue;
            afterSalesProjectsVO.setMaintenanceStartDate(DateUtil.dateAddDays((Date)projectEntity.getAcceptanceTime(), (int)1));
            afterSalesProjectsVO.setMaintenanceEndDate(DateUtil.dateAddMonths((Date)afterSalesProjectsVO.getMaintenanceStartDate(), (int)afterSalesProjectsVO.getWarranty()));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesProjectsPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/getProjectByCompanyId"})
    public ActionResult getProjectByCompanyId(@RequestBody AfterSalesProjectsPagination afterSalesProjectsPagination) throws IOException {
        List<AfterSalesProjectsEntity> list = this.afterSalesProjectsService.getProjectByCompanyId(afterSalesProjectsPagination);
        for (AfterSalesProjectsEntity afterSalesProjectsEntity : list) {
            afterSalesProjectsEntity.setAfterSalesPerson(this.baseDataUtil.userSelectValues(afterSalesProjectsEntity.getAfterSalesPerson()));
            afterSalesProjectsEntity.setAfterSalesManager(this.baseDataUtil.userSelectValues(afterSalesProjectsEntity.getAfterSalesManager()));
        }
        List listVO = JsonUtil.getJsonToList(list, AfterSalesProjectsListVO.class);
        for (AfterSalesProjectsListVO afterSalesProjectsVO : listVO) {
            RkContractProjectEntity projectEntity;
            afterSalesProjectsVO.setCompanyName(this.baseDataUtil.comSelectValues(afterSalesProjectsVO.getCompanyId()));
            if (StringUtils.isNotEmpty((String)afterSalesProjectsVO.getDepartment())) {
                afterSalesProjectsVO.setDepartmentName(this.baseDataUtil.comSelectValues(afterSalesProjectsVO.getDepartment()));
            }
            if (StrUtil.isNotBlank((CharSequence)afterSalesProjectsVO.getContractId())) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.lambda().eq(RkContractEntity::getId, (Object)afterSalesProjectsVO.getContractId());
                RkContractEntity rkContractEntity = (RkContractEntity)this.rkContractMapper.selectOne((Wrapper)queryWrapper);
                if (ObjectUtil.isNotEmpty((Object)rkContractEntity)) {
                    afterSalesProjectsVO.setCustomerAddressName(rkContractEntity.getCustomerAddressName());
                    afterSalesProjectsVO.setContractName(rkContractEntity.getContractName());
                    afterSalesProjectsVO.setContractNo(rkContractEntity.getContractCode());
                    afterSalesProjectsVO.setSalerName(rkContractEntity.getSalerName());
                    afterSalesProjectsVO.setContractSignTime(rkContractEntity.getSignDate());
                }
                if (!ObjectUtil.isNull((Object)rkContractEntity.getIsAgent()) && rkContractEntity.getIsAgent() == 1) {
                    afterSalesProjectsVO.setAgentName(((RkAgentEntity)this.agentService.getById((Serializable)((Object)rkContractEntity.getAgentId()))).getName());
                } else {
                    afterSalesProjectsVO.setAgentName(rkContractEntity.getCustomerName());
                }
            }
            if (!ObjectUtil.isNull((Object)(projectEntity = this.rkContractProjectService.getInfo(afterSalesProjectsVO.getProjectId())))) continue;
            afterSalesProjectsVO.setManHourProjectState(1);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesProjectsPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/getProjectCustomerList"})
    @NotCheckLogin
    public ActionResult getProjectCustomerList(@RequestBody AfterSalesProjectsPagination afterSalesProjectsPagination) throws IOException {
        List<AfterSalesProjectsEntity> list = this.afterSalesProjectsService.getProjectCustomerList(afterSalesProjectsPagination);
        if (CollectionUtil.isNotEmpty(list)) {
            for (AfterSalesProjectsEntity entity : list) {
                entity.setAfterSalesPerson(this.baseDataUtil.userSelectValues(entity.getAfterSalesPerson()));
                entity.setAssistantsUser(this.baseDataUtil.userSelectValues(entity.getAssistantsUser()));
                entity.setAfterSalesManager(this.baseDataUtil.userSelectValues(entity.getAfterSalesManager()));
                entity.setQuantity(this.afterSalesProjectsService.getByCustomerIdQuantity(entity.getCustomerId(), afterSalesProjectsPagination.getCompanyId()));
            }
        }
        List<AfterSalesProjectsListVO> listVo = this.getListVo(list);
        PageListVO vo = new PageListVO();
        vo.setList(listVo);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesProjectsPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getListByCustomerId"})
    public ActionResult getListByCustomerId(@RequestBody AfterSalesProjectsPagination afterSalesProjectsPagination) throws IOException {
        List<AfterSalesProjectsEntity> list = this.afterSalesProjectsService.getByCustomerId(afterSalesProjectsPagination);
        for (AfterSalesProjectsEntity entity : list) {
            entity.setAfterSalesPerson(this.baseDataUtil.userSelectValues(entity.getAfterSalesPerson()));
            entity.setAssistantsUser(this.baseDataUtil.userSelectValues(entity.getAssistantsUser()));
            entity.setAfterSalesManager(this.baseDataUtil.userSelectValues(entity.getAfterSalesManager()));
        }
        List<AfterSalesProjectsListVO> listVo = this.getListVo(list);
        PageListVO vo = new PageListVO();
        vo.setList(listVo);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)afterSalesProjectsPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private List<AfterSalesProjectsListVO> getListVo(List<AfterSalesProjectsEntity> list) {
        if (CollectionUtil.isEmpty(list)) {
            return CollectionUtil.list((boolean)false);
        }
        List listVO = JsonUtil.getJsonToList(list, AfterSalesProjectsListVO.class);
        for (AfterSalesProjectsListVO afterSalesProjectsVO : listVO) {
            OrganizeEntity byId = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)afterSalesProjectsVO.getCompanyId()));
            OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)byId.getPropertyJson(), OrganizeCrModel.class);
            afterSalesProjectsVO.setCompanyName(jsonToBean.getShortName());
            afterSalesProjectsVO.setWarrantyStateDesc(this.baseDataUtil.getDictName(afterSalesProjectsVO.getWarrantyState(), "afterSalesProjectWarrantyState"));
            if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsVO.getProduct())) {
                List<CrmProductEntity> listByProductIds = this.crmProductService.getListByProductIds(CollectionUtil.list((boolean)false, (Object[])afterSalesProjectsVO.getProduct().split(",")));
                String collect = listByProductIds.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(","));
                afterSalesProjectsVO.setProduct(collect);
            }
            afterSalesProjectsVO.setIncomeType(this.baseDataUtil.getDictName(afterSalesProjectsVO.getIncomeType(), "incomeType"));
            if (StringUtils.isNotEmpty((String)afterSalesProjectsVO.getDepartment())) {
                afterSalesProjectsVO.setDepartmentName(this.baseDataUtil.comSelectValues(afterSalesProjectsVO.getDepartment()));
            }
            if (!StrUtil.isNotBlank((CharSequence)afterSalesProjectsVO.getContractId())) continue;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(RkContractEntity::getId, (Object)afterSalesProjectsVO.getContractId());
            RkContractEntity rkContractEntity = (RkContractEntity)this.rkContractMapper.selectOne((Wrapper)queryWrapper);
            if (ObjectUtil.isNotEmpty((Object)rkContractEntity)) {
                CrmCustomerEntity info = this.crmCustomerService.getInfo(rkContractEntity.getCustomerId());
                if (ObjectUtil.isNotEmpty((Object)info)) {
                    rkContractEntity.setCustomerName(info.getName());
                }
                afterSalesProjectsVO.setCustomerAddressName(rkContractEntity.getCustomerAddressName());
            }
            afterSalesProjectsVO.setContractName(rkContractEntity.getContractName());
            afterSalesProjectsVO.setContractNo(rkContractEntity.getContractCode());
            afterSalesProjectsVO.setSalerName(rkContractEntity.getSalerName());
            afterSalesProjectsVO.setContractSignTime(rkContractEntity.getSignDate());
            if (!ObjectUtil.isNull((Object)rkContractEntity.getIsAgent()) && rkContractEntity.getIsAgent() == 1) {
                afterSalesProjectsVO.setAgentName(((RkAgentEntity)this.agentService.getById((Serializable)((Object)rkContractEntity.getAgentId()))).getName());
                continue;
            }
            afterSalesProjectsVO.setAgentName(rkContractEntity.getCustomerName());
        }
        return listVO;
    }

    @GetMapping(value={"/getListByCustomerId/{id}/Selector/{customerId}"})
    public ActionResult getListByCustomerId(@PathVariable(value="id") String id, @PathVariable(value="customerId") String customerId) throws IOException {
        ArrayList<LinkManSelectListVO> treeList = new ArrayList<LinkManSelectListVO>();
        if ("-1".equals(id)) {
            List<AfterSalesProjectsEntity> list = this.afterSalesProjectsService.getListProductInAndCustomerId(null, customerId);
            for (AfterSalesProjectsEntity vo : list) {
                LinkManSelectListVO linkMan = new LinkManSelectListVO();
                linkMan.setId(vo.getId());
                linkMan.setFullName(vo.getProjectName());
                linkMan.setIsLeaf(false);
                treeList.add(linkMan);
            }
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(CrmCustomerContactsEntity::getProjectId, (Object)id);
            List listMan = this.crmCustomerContactsService.list((Wrapper)queryWrapper);
            for (CrmCustomerContactsEntity vo : listMan) {
                LinkManSelectListVO linkMan = new LinkManSelectListVO();
                linkMan.setId(vo.getId());
                linkMan.setFullName(vo.getName() + "-" + vo.getPhone());
                linkMan.setIsLeaf(false);
                treeList.add(linkMan);
            }
        }
        return ActionResult.success(treeList);
    }

    @PostMapping(value={"countTabs"})
    public ActionResult countTabs(@RequestBody AfterSalesProjectsPagination afterSalesProjectsPagination) {
        List<Map<String, Object>> maps = this.afterSalesProjectsService.countTabs(afterSalesProjectsPagination);
        return ActionResult.success(maps);
    }

    @GetMapping(value={"countTab/{id}"})
    public ActionResult countPanorama(@PathVariable(value="id") String id) {
        HashMap map = MapUtil.newHashMap();
        long linkManCount = this.crmCustomerContactsService.getCustomerContactsCountByProjectId(id);
        long afterInspectCount = this.afterInspectTaskService.getAfterInspectCountByProjectId(id);
        long afterQuestionCount = this.afterSalesQuestionService.countByAfterProjectId(id);
        long repairCount = this.afterSalesRepairService.getRepairCountProjectId(id);
        long logCount = this.rkMarketLogService.countByProjectId(id);
        map.put("linkManCount", linkManCount);
        map.put("afterInspectCount", afterInspectCount);
        map.put("afterQuestionCount", afterQuestionCount);
        map.put("repairCount", repairCount);
        map.put("logCount", logCount);
        return ActionResult.success((Object)map);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid AfterSalesProjectsCrForm afterSalesProjectsCrForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkContractProjectEntity projectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)afterSalesProjectsCrForm.getProjectId()));
        AfterSalesProjectsEntity jsonToBean = (AfterSalesProjectsEntity)JsonUtil.getJsonToBean((Object)afterSalesProjectsCrForm, AfterSalesProjectsEntity.class);
        List jsonToList = CollectionUtil.list((boolean)false);
        if (CollectionUtil.isNotEmpty(afterSalesProjectsCrForm.getAttachmentList())) {
            jsonToList = JsonUtil.getJsonToList(afterSalesProjectsCrForm.getAttachmentList(), RkAttachmentEntity.class);
            jsonToList.stream().forEach(attachmentCrForm -> {
                attachmentCrForm.setId(RandomUtil.uuId());
                attachmentCrForm.setObjId(afterSalesProjectsCrForm.getProjectId());
                attachmentCrForm.setProjectId(afterSalesProjectsCrForm.getProjectId());
                attachmentCrForm.setFileType("project_" + ProjectStateEnum.toAfterSales_state_apply.getState());
            });
        }
        projectEntity.setAfterSalesAssistant(afterSalesProjectsCrForm.getAfterSalesAssistant());
        this.afterSalesProjectsService.saveProject(projectEntity, jsonToBean.getAfterSalesManager(), jsonToBean.getAssistantsUser(), jsonToBean.getAfterSalesPerson(), jsonToBean.getProduct(), userInfo.getUserId(), jsonToBean.getDepartment(), jsonToBean.getDepartmentTree(), AfterSalesProjectWarrantyStateEnum.MAINTENANCE_STATE.getState(), jsonToList);
        projectEntity.setState(ProjectStateEnum.toAfterSales_state.getState());
        projectEntity.setAfterSalesManager(afterSalesProjectsCrForm.getAfterSalesManager());
        projectEntity.setAfterSaleHeader(afterSalesProjectsCrForm.getAfterSalesPerson());
        projectEntity.setAfterSaleExecuteAssistantsUser(afterSalesProjectsCrForm.getAssistantsUser());
        this.rkContractProjectService.updateById(projectEntity);
        RkProjectTrendsEntity trendsEntity = new RkProjectTrendsEntity();
        trendsEntity.setCustomerId(projectEntity.getCustomerId());
        trendsEntity.setProjectId(projectEntity.getId());
        trendsEntity.setContractId(projectEntity.getContractId());
        trendsEntity.setId(RandomUtil.uuId());
        projectEntity.setState(ProjectStateEnum.toAfterSales_state.getState());
        trendsEntity.setNodeType(ProjectTrendsEnum.TRANSFER.getNode());
        trendsEntity.setNodeDesc(userInfo.getUserName() + "\u628a\u9879\u76ee\u8f6c\u5230\u552e\u540e");
        this.rkProjectTrendsService.save(trendsEntity);
        return ActionResult.success((String)"\u8f6c\u552e\u540e\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faWord")
    @GetMapping(value={"/Actions/ExportDetail/{id}"})
    public ActionResult ExportDetail(@PathVariable(value="id") String id, HttpServletResponse response) throws Exception {
        UserInfo userInfo = this.userProvider.get();
        AfterSalesProjectsEntity entity = this.afterSalesProjectsService.getInfo(id);
        AfterSalesProjectsInfoVO vo = (AfterSalesProjectsInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesProjectsInfoVO.class);
        vo.setAfterSalesPersonName(this.baseDataUtil.userSelectValues(vo.getAfterSalesPerson()));
        vo.setAssistantsUser(this.baseDataUtil.userSelectValues(vo.getAssistantsUser()));
        vo.setAfterSalesManager(this.baseDataUtil.userSelectValues(vo.getAfterSalesManager()));
        vo.setIncomeType(this.baseDataUtil.getDictName(vo.getIncomeType(), "incomeType"));
        vo.setWarrantyStateDesc(this.baseDataUtil.getDictName(vo.getWarrantyState(), "afterSalesProjectWarrantyState"));
        String inputUrl = this.configValueUtil.getTemplateFilePath() + "afterSaleProjectWord.docx";
        String name = entity.getProjectName() + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".docx";
        String outputUrl = this.configValueUtil.getTemporaryFilePath() + name;
        HashMap<String, String> testMap = new HashMap<String, String>();
        testMap.put("projectName", vo.getProjectName());
        testMap.put("projectCode", vo.getProjectCode());
        testMap.put("afterSalesPersoName", StringUtils.isNotEmpty((String)vo.getAfterSalesPersonName()) ? vo.getAfterSalesPersonName() : "---");
        testMap.put("projectAmoun", vo.getProjectAmount());
        if (ObjectUtil.isNotEmpty((Object)vo.getTransferDate())) {
            testMap.put("transferDate", DateUtil.daFormat((Long)vo.getTransferDate()));
        } else {
            testMap.put("transferDate", "----");
        }
        List<String[]> testList = this.afterSalesProjectsService.afterSalesQuestionExportDetail(id);
        List<String[]> testList2 = this.afterSalesProjectsService.afterInspectTaskExportDetail(id);
        List<String[]> testList3 = this.afterSalesProjectsService.rkContractExportDetail(entity.getContractId());
        ArrayList<List<String[]>> testListAll = new ArrayList<List<String[]>>();
        testListAll.add(null);
        testListAll.add(testList);
        testListAll.add(testList2);
        testListAll.add(testList3);
        WordUtil.changWord((String)inputUrl, (String)outputUrl, testMap, null, testListAll);
        if (FileUtil.fileIsFile((String)outputUrl)) {
            DownloadVO downloadVO = DownloadVO.builder().name(name).url(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary"))).build();
            return ActionResult.success((Object)downloadVO);
        }
        return ActionResult.success((String)"\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(AfterSalesProjectsPaginationExportModel afterSalesProjectsPaginationExportModel) throws IOException {
        if (StrUtil.isEmpty((CharSequence)afterSalesProjectsPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        AfterSalesProjectsPagination afterSalesProjectsPagination = (AfterSalesProjectsPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)afterSalesProjectsPaginationExportModel), AfterSalesProjectsPagination.class));
        List<AfterSalesProjectsEntity> list = this.afterSalesProjectsService.getTypeList(afterSalesProjectsPagination, afterSalesProjectsPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, AfterSalesProjectsListVO.class);
        for (AfterSalesProjectsListVO afterSalesProjectsVO : listVO) {
            RkContractProjectEntity projectEntity;
            long between;
            LocalDate endDate;
            LocalDate now;
            afterSalesProjectsVO.setAfterSalesPerson(this.baseDataUtil.userSelectValues(afterSalesProjectsVO.getAfterSalesPerson()));
            afterSalesProjectsVO.setAssistantsUser(this.baseDataUtil.userSelectValues(afterSalesProjectsVO.getAssistantsUser()));
            afterSalesProjectsVO.setAfterSalesManager(this.baseDataUtil.userSelectValues(afterSalesProjectsVO.getAfterSalesManager()));
            if (ObjectUtil.isNotNull((Object)afterSalesProjectsVO.getManHourState())) {
                afterSalesProjectsVO.setManHourState(afterSalesProjectsVO.getManHourState().equals("0") ? "\u5f00\u542f" : "\u5173\u95ed");
            }
            if (ObjectUtil.isNotEmpty((Object)afterSalesProjectsVO.getWarrantyStartDate()) && ObjectUtil.isNotEmpty((Object)afterSalesProjectsVO.getWarrantyEndDate()) && !StrUtil.equals((CharSequence)afterSalesProjectsVO.getWarrantyState(), (CharSequence)"derelivery")) {
                now = LocalDate.now();
                endDate = LocalDate.ofEpochDay(afterSalesProjectsVO.getWarrantyEndDate() / 86400000L);
                between = ChronoUnit.DAYS.between(now, endDate);
                afterSalesProjectsVO.setOffDate((int)between);
            }
            if (StrUtil.equals((CharSequence)afterSalesProjectsVO.getWarrantyState(), (CharSequence)"derelivery") && ObjectUtil.isNotEmpty((Object)afterSalesProjectsVO.getWarrantyEndDate())) {
                now = LocalDate.now();
                endDate = LocalDate.ofEpochDay(afterSalesProjectsVO.getWarrantyEndDate() / 86400000L);
                between = ChronoUnit.DAYS.between(endDate, now);
                afterSalesProjectsVO.setExpireDays((int)between);
            }
            afterSalesProjectsVO.setAssistantsUserId(afterSalesProjectsVO.getAssistantsUser());
            afterSalesProjectsVO.setAssistantsUser(this.baseDataUtil.userSelectValues(afterSalesProjectsVO.getAssistantsUser()));
            afterSalesProjectsVO.setCompanyName(this.baseDataUtil.comSelectValues(afterSalesProjectsVO.getCompanyId()));
            afterSalesProjectsVO.setWarrantyStateDesc(this.baseDataUtil.getDictName(afterSalesProjectsVO.getWarrantyState(), "afterSalesProjectWarrantyState"));
            if (StrUtil.isNotEmpty((CharSequence)afterSalesProjectsVO.getProduct())) {
                List<CrmProductEntity> listByProductIds = this.crmProductService.getListByProductIds(CollectionUtil.list((boolean)false, (Object[])afterSalesProjectsVO.getProduct().split(",")));
                String collect = listByProductIds.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(","));
                afterSalesProjectsVO.setProduct(collect);
            }
            afterSalesProjectsVO.setIncomeType(this.baseDataUtil.getDictName(afterSalesProjectsVO.getIncomeType(), "incomeType"));
            afterSalesProjectsVO.setDepartmentName(this.baseDataUtil.comSelectValues(afterSalesProjectsVO.getDepartment()));
            afterSalesProjectsVO.setCustomerAddressName(this.baseDataUtil.provinceData(afterSalesProjectsVO.getAddress()));
            if (StrUtil.isEmpty((CharSequence)afterSalesProjectsVO.getCustomerAddressName())) {
                afterSalesProjectsVO.setCustomerAddressName(afterSalesProjectsVO.getAddress());
            }
            if (StrUtil.isNotBlank((CharSequence)afterSalesProjectsVO.getContractId())) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.lambda().eq(RkContractEntity::getId, (Object)afterSalesProjectsVO.getContractId());
                RkContractEntity rkContractEntity = (RkContractEntity)this.rkContractMapper.selectOne((Wrapper)queryWrapper);
                if (ObjectUtil.isNotEmpty((Object)rkContractEntity)) {
                    if (StrUtil.isBlank((CharSequence)afterSalesProjectsVO.getCustomerAddressName())) {
                        afterSalesProjectsVO.setCustomerAddressName(rkContractEntity.getCustomerAddressName());
                    }
                    afterSalesProjectsVO.setContractName(rkContractEntity.getContractName());
                    afterSalesProjectsVO.setContractNo(rkContractEntity.getContractCode());
                    afterSalesProjectsVO.setSalerName(rkContractEntity.getSalerName());
                    afterSalesProjectsVO.setContractSignTime(rkContractEntity.getSignDate());
                    if (!ObjectUtil.isNull((Object)rkContractEntity.getIsAgent()) && rkContractEntity.getIsAgent() == 1) {
                        afterSalesProjectsVO.setAgentName(((RkAgentEntity)this.agentService.getById((Serializable)((Object)rkContractEntity.getAgentId()))).getName());
                    } else {
                        afterSalesProjectsVO.setAgentName(rkContractEntity.getCustomerName());
                    }
                    afterSalesProjectsVO.setWarranty(rkContractEntity.getWarranty());
                }
            }
            if (ObjectUtil.isNull((Object)(projectEntity = this.rkContractProjectService.getInfo(afterSalesProjectsVO.getProjectId())))) {
                afterSalesProjectsVO.setManHourProjectState(1);
                continue;
            }
            if (!ObjectUtil.isNotNull((Object)afterSalesProjectsVO.getWarranty()) || !ObjectUtil.isNotNull((Object)projectEntity.getAcceptanceTime())) continue;
            afterSalesProjectsVO.setMaintenanceStartDate(DateUtil.dateAddDays((Date)projectEntity.getAcceptanceTime(), (int)1));
            afterSalesProjectsVO.setMaintenanceEndDate(DateUtil.dateAddMonths((Date)afterSalesProjectsVO.getMaintenanceStartDate(), (int)afterSalesProjectsVO.getWarranty()));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd"));
        String[] keys = !StrUtil.isEmpty((CharSequence)afterSalesProjectsPaginationExportModel.getSelectKey()) ? afterSalesProjectsPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block56: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u516c\u53f8", (Object)"companyName"));
                        continue block56;
                    }
                    case "projectId": {
                        entitys.add(new ExcelExportEntity("\u9879\u76eeid", (Object)"projectId"));
                        continue block56;
                    }
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName"));
                        continue block56;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u7801", (Object)"projectCode"));
                        continue block56;
                    }
                    case "transferDate": {
                        entitys.add(new ExcelExportEntity("\u8f6c\u552e\u540e\u65f6\u95f4", (Object)"transferDate"));
                        continue block56;
                    }
                    case "customerId": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237id", (Object)"customerId"));
                        continue block56;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u540d\u79f0", (Object)"customerName"));
                        continue block56;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u5bf9\u8c61", (Object)"agentName"));
                        continue block56;
                    }
                    case "manHourState": {
                        entitys.add(new ExcelExportEntity("\u5de5\u65f6\u72b6\u6001", (Object)"manHourState"));
                        continue block56;
                    }
                    case "projectAmount": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u9879\u76ee\u91d1\u989d(\u5143)", (Object)"projectAmount");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block56;
                    }
                    case "warrantyStateDesc": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"warrantyStateDesc"));
                        continue block56;
                    }
                    case "offDate": {
                        entitys.add(new ExcelExportEntity("\u79bb\u5230\u671f\u5929\u6570", (Object)"offDate"));
                        continue block56;
                    }
                    case "expireDays": {
                        entitys.add(new ExcelExportEntity("\u8131\u4fdd\u5929\u6570", (Object)"expireDays"));
                        continue block56;
                    }
                    case "warrantyDate": {
                        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u65e5\u671f", (Object)"warrantyDate"));
                        continue block56;
                    }
                    case "contractSignTime": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u65e5\u671f", (Object)"contractSignTime"));
                        continue block56;
                    }
                    case "afterSalesPerson": {
                        entitys.add(new ExcelExportEntity("\u552e\u540e\u8d1f\u8d23\u4eba", (Object)"afterSalesPerson"));
                        continue block56;
                    }
                    case "assistantsUser": {
                        entitys.add(new ExcelExportEntity("\u534f\u52a9\u4eba", (Object)"assistantsUser"));
                        continue block56;
                    }
                    case "afterSalesManager": {
                        entitys.add(new ExcelExportEntity("\u552e\u540e\u533a\u57df\u8d1f\u8d23\u4eba", (Object)"afterSalesManager"));
                        continue block56;
                    }
                    case "departmentName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u90e8\u95e8", (Object)"departmentName"));
                        continue block56;
                    }
                    case "incomeType": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5927\u7c7b", (Object)"incomeType"));
                        continue block56;
                    }
                    case "product": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1", (Object)"product"));
                        continue block56;
                    }
                    case "customerAddressName": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u5730\u5740", (Object)"customerAddressName"));
                        continue block56;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                    Sheet sheetAt = workbook.getSheetAt(0);
                    int lastRowNum = sheetAt.getLastRowNum();
                    DataFormat dataFormat = workbook.createDataFormat();
                    CellStyle cellStyle = workbook.createCellStyle();
                    for (int i = 1; i <= lastRowNum; ++i) {
                        Row row = sheetAt.getRow(i);
                        int lastCellNum = row.getLastCellNum();
                        for (int j = 0; j < lastCellNum; ++j) {
                            Cell cell = row.getCell(j);
                            CellType cellType = cell.getCellType();
                            if (!ObjectUtil.equals((Object)cellType, (Object)CellType.NUMERIC)) continue;
                            cellStyle.setDataFormat(dataFormat.getFormat("#,##0.00"));
                            cell.setCellStyle(cellStyle);
                        }
                    }
                }
                String name = "\u552e\u540e\u9879\u76ee" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<AfterSalesProjectsInfoVO> info(@PathVariable(value="id") String id) {
        AfterSalesProjectsEntity entity = this.afterSalesProjectsService.getInfo(id);
        AfterSalesProjectsInfoVO vo = (AfterSalesProjectsInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesProjectsInfoVO.class);
        vo.setWarrantyStateDesc(this.baseDataUtil.getDictName(vo.getWarrantyState(), "afterSalesProjectWarrantyState"));
        if (ObjectUtil.isNotNull((Object)vo.getWarrantyEndDate()) && ObjectUtil.isNotNull((Object)vo.getWarrantyStartDate())) {
            List list = CollectionUtil.list((boolean)false, (Object[])new Long[]{vo.getWarrantyStartDate(), vo.getWarrantyEndDate()});
            vo.setWarrantyDate(list);
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<AfterSalesProjectsInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkProjectAuthorizationBussEntity info;
        AfterSalesProjectsEntity entity = this.afterSalesProjectsService.getInfo(id);
        AfterSalesProjectsInfoVO vo = (AfterSalesProjectsInfoVO)JsonUtil.getJsonToBean((Object)entity, AfterSalesProjectsInfoVO.class);
        vo.setAssistantsUserId(vo.getAssistantsUser());
        vo.setAfterSalesPersonName(this.baseDataUtil.userSelectValues(vo.getAfterSalesPerson()));
        vo.setAfterSalesManagerName(this.baseDataUtil.userSelectValues(vo.getAfterSalesManager()));
        vo.setAfterSalesAssistantName(this.baseDataUtil.userSelectValue(vo.getAfterSalesAssistant()));
        vo.setAssistantsUser(this.baseDataUtil.userSelectValues(vo.getAssistantsUser()));
        vo.setIncomeType(this.baseDataUtil.getDictName(vo.getIncomeType(), "incomeType"));
        vo.setWarrantyStateDesc(this.baseDataUtil.getDictName(vo.getWarrantyState(), "afterSalesProjectWarrantyState"));
        vo.setDepartmentName(this.baseDataUtil.comSelectValues(vo.getDepartment()));
        vo.setSalerName(entity.getSalerName());
        if (CollectionUtil.isNotEmpty(vo.getDepartmentTree())) {
            vo.setDepartmentTreeName(this.baseDataUtil.comSelectValues(String.join((CharSequence)",", vo.getDepartmentTree().toString())));
        }
        if (ObjectUtil.isNotNull((Object)vo.getWarrantyEndDate()) && ObjectUtil.isNotNull((Object)vo.getWarrantyStartDate())) {
            List list = CollectionUtil.list((boolean)false, (Object[])new Long[]{vo.getWarrantyStartDate(), vo.getWarrantyEndDate()});
            vo.setWarrantyDate(list);
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getProduct())) {
            List<CrmProductEntity> listByProductIds = this.crmProductService.getListByProductIds(CollectionUtil.list((boolean)false, (Object[])vo.getProduct().split(",")));
            String collect = listByProductIds.stream().map(CrmProductEntity::getProductName).collect(Collectors.joining(","));
            vo.setProduct(collect);
        }
        if (StrUtil.isNotBlank((CharSequence)entity.getContractId())) {
            RkContractEntity contract = this.rkContractService.getInfo(entity.getContractId());
            vo.setSalerName(contract.getSalerName());
            if (StrUtil.isNotBlank((CharSequence)contract.getAgentId())) {
                RkAgentEntity byId = (RkAgentEntity)this.agentService.getById((Serializable)((Object)contract.getAgentId()));
                if (ObjectUtil.isNotEmpty((Object)byId)) {
                    vo.setAgentName(byId.getName());
                } else {
                    vo.setAgentName(vo.getCustomerName());
                }
            }
        }
        OrganizeEntity byId = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)vo.getCompanyId()));
        OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)byId.getPropertyJson(), OrganizeCrModel.class);
        vo.setCompanyName(jsonToBean.getShortName());
        vo.setAddressName(this.baseDataUtil.provinceData(vo.getAddress()));
        if (StrUtil.isEmpty((CharSequence)vo.getAddressName())) {
            vo.setAddressName(vo.getAddress());
        }
        if (ObjectUtil.isNotEmpty((Object)(info = this.rkProjectAuthorizationBussService.getByProjectId(entity.getProjectId())))) {
            List list = CollectionUtil.list((boolean)false, (Object[])new Long[]{info.getActualStartDate().getTime(), info.getActualEndDate().getTime()});
            vo.setAccreditDate(list);
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/manHourState/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id) throws DataException {
        AfterSalesProjectsEntity info = this.afterSalesProjectsService.getInfo(id);
        RkContractProjectEntity projectEntity = this.rkContractProjectService.getInfo(info.getProjectId());
        if (ObjectUtil.isNotEmpty((Object)info) && ObjectUtil.isNotEmpty((Object)projectEntity)) {
            if (StrUtil.equals((CharSequence)info.getManHourState(), (CharSequence)"0")) {
                info.setManHourState("1");
            } else {
                info.setManHourState("0");
            }
            this.afterSalesProjectsService.update(id, info);
            projectEntity.setManHourState(info.getManHourState());
            this.rkContractProjectService.update(projectEntity.getId(), projectEntity);
            return StrUtil.equals((CharSequence)info.getManHourState(), (CharSequence)"0") ? ActionResult.success((String)"\u5f00\u542f\u6210\u529f") : ActionResult.success((String)"\u5173\u95ed\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid AfterSalesProjectsUpForm afterSalesProjectsUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        AfterSalesProjectsEntity entity = this.afterSalesProjectsService.getInfo(id);
        if (entity != null) {
            AfterSalesProjectsEntity subentity;
            if (CollectionUtil.isNotEmpty(afterSalesProjectsUpForm.getWarrantyDate())) {
                afterSalesProjectsUpForm.setWarrantyStartDate(afterSalesProjectsUpForm.getWarrantyDate().get(0));
                afterSalesProjectsUpForm.setWarrantyEndDate(afterSalesProjectsUpForm.getWarrantyDate().get(1));
            }
            if (ObjectUtil.isNotNull((Object)(subentity = (AfterSalesProjectsEntity)JsonUtil.getJsonToBean((Object)afterSalesProjectsUpForm, AfterSalesProjectsEntity.class)).getWarrantyEndDate())) {
                RkContractEntity byId;
                if (subentity.getWarrantyEndDate().before(DateUtil.getDayBegin())) {
                    subentity.setWarrantyState(AfterSalesProjectWarrantyStateEnum.DERELIVERY_STATE.getState());
                } else if (StrUtil.equals((CharSequence)entity.getWarrantyState(), (CharSequence)AfterSalesProjectWarrantyStateEnum.DERELIVERY_STATE.getState()) && StrUtil.isNotEmpty((CharSequence)entity.getContractId()) && ObjectUtil.isNotEmpty((Object)(byId = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)entity.getContractId()))))) {
                    DictionaryDataEntity byId1;
                    String contractType = byId.getContractType();
                    if (StrUtil.isNotEmpty((CharSequence)contractType) && ObjectUtil.isNotNull((Object)(byId1 = (DictionaryDataEntity)this.dictionaryDataService.getById((Serializable)((Object)contractType))))) {
                        contractType = byId1.getEnCode();
                    }
                    if (StrUtil.equals((CharSequence)contractType, (CharSequence)"afterSalesContract")) {
                        subentity.setWarrantyState(AfterSalesProjectWarrantyStateEnum.MAINTENANCE_STATE.getState());
                    } else {
                        subentity.setWarrantyState(AfterSalesProjectWarrantyStateEnum.WARRANTY_STATE.getState());
                    }
                }
            }
            subentity.setProjectId(entity.getProjectId());
            subentity.setDepartmentTree(CollectionUtil.join(afterSalesProjectsUpForm.getDepartmentTree(), (CharSequence)","));
            this.afterSalesProjectsService.update(id, subentity);
            RkContractProjectEntity info = this.rkContractProjectService.getInfo(entity.getProjectId());
            if (ObjectUtil.isNotEmpty((Object)info)) {
                info.setAfterSaleExecuteUser(subentity.getAfterSaleExecuteUser());
                info.setAfterSaleExecuteAssistantsUser(subentity.getAssistantsUser());
                info.setAfterSaleHeader(subentity.getAfterSalesPerson());
                info.setAfterSalesManager(subentity.getAfterSalesManager());
                info.setAfterSalesAssistant(subentity.getAfterSalesAssistant());
                this.rkContractProjectService.update(info.getId(), info);
                this.rkContractProjectMemberService.dealProjectMember("afterSale", info);
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        AfterSalesProjectsEntity entity = this.afterSalesProjectsService.getInfo(id);
        if (entity != null) {
            this.afterSalesProjectsService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

