/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.BeforeSaleSupportTemplateEntity;
import com.bringspring.contract.model.beforeSaleSupportTemplate.BeforeSaleSupportTemplateCrForm;
import com.bringspring.contract.model.beforeSaleSupportTemplate.BeforeSaleSupportTemplateInfoVO;
import com.bringspring.contract.model.beforeSaleSupportTemplate.BeforeSaleSupportTemplateListVO;
import com.bringspring.contract.model.beforeSaleSupportTemplate.BeforeSaleSupportTemplatePagination;
import com.bringspring.contract.model.beforeSaleSupportTemplate.BeforeSaleSupportTemplatePaginationExportModel;
import com.bringspring.contract.model.beforeSaleSupportTemplate.BeforeSaleSupportTemplateUpForm;
import com.bringspring.contract.service.BeforeSaleSupportTemplateService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u552e\u524d\u652f\u6301\u8bc4\u4ef7\u6a21\u677f"}, value="contract")
@RequestMapping(value={"/api/contract/BeforeSaleSupportTemplate"})
public class BeforeSaleSupportTemplateController {
    private static final Logger log = LoggerFactory.getLogger(BeforeSaleSupportTemplateController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BeforeSaleSupportTemplateService beforeSaleSupportTemplateService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody BeforeSaleSupportTemplatePagination beforeSaleSupportTemplatePagination) throws IOException {
        List<BeforeSaleSupportTemplateEntity> list = this.beforeSaleSupportTemplateService.getList(beforeSaleSupportTemplatePagination);
        for (BeforeSaleSupportTemplateEntity beforeSaleSupportTemplateEntity : list) {
            beforeSaleSupportTemplateEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(beforeSaleSupportTemplateEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, BeforeSaleSupportTemplateListVO.class);
        for (BeforeSaleSupportTemplateListVO beforeSaleSupportTemplateVO : listVO) {
            beforeSaleSupportTemplateVO.setEnabledMark(this.baseDataUtil.getDictName(beforeSaleSupportTemplateVO.getEnabledMark(), "whether"));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)beforeSaleSupportTemplatePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid BeforeSaleSupportTemplateCrForm beforeSaleSupportTemplateCrForm) throws DataException {
        this.beforeSaleSupportTemplateService.create(beforeSaleSupportTemplateCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(BeforeSaleSupportTemplatePaginationExportModel beforeSaleSupportTemplatePaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)beforeSaleSupportTemplatePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        BeforeSaleSupportTemplatePagination beforeSaleSupportTemplatePagination = (BeforeSaleSupportTemplatePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)beforeSaleSupportTemplatePaginationExportModel), BeforeSaleSupportTemplatePagination.class));
        List<BeforeSaleSupportTemplateEntity> list = this.beforeSaleSupportTemplateService.getTypeList(beforeSaleSupportTemplatePagination, beforeSaleSupportTemplatePaginationExportModel.getDataType());
        for (BeforeSaleSupportTemplateEntity beforeSaleSupportTemplateEntity : list) {
            beforeSaleSupportTemplateEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(beforeSaleSupportTemplateEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, BeforeSaleSupportTemplateListVO.class);
        for (BeforeSaleSupportTemplateListVO beforeSaleSupportTemplateVO : listVO) {
            beforeSaleSupportTemplateVO.setEnabledMark(this.baseDataUtil.getDictName(beforeSaleSupportTemplateVO.getEnabledMark(), "whether"));
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)beforeSaleSupportTemplatePaginationExportModel.getSelectKey()) ? beforeSaleSupportTemplatePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block30: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "assessmentIndicators": {
                        entitys.add(new ExcelExportEntity("\u8003\u6838\u6307\u6807", (Object)"assessmentIndicators"));
                        continue block30;
                    }
                    case "assessmentItems": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee", (Object)"assessmentItems"));
                        continue block30;
                    }
                    case "assessmentDimension": {
                        entitys.add(new ExcelExportEntity("\u8bc4\u4ef7\u7ef4\u5ea6", (Object)"assessmentDimension"));
                        continue block30;
                    }
                    case "assessmentDescription": {
                        entitys.add(new ExcelExportEntity("\u8be6\u7ec6\u5185\u5bb9", (Object)"assessmentDescription"));
                        continue block30;
                    }
                    case "assessmentHighScore": {
                        entitys.add(new ExcelExportEntity("\u6700\u9ad8\u503c", (Object)"assessmentHighScore"));
                        continue block30;
                    }
                    case "assessmentLowScore": {
                        entitys.add(new ExcelExportEntity("\u6700\u4f4e\u503c", (Object)"assessmentLowScore"));
                        continue block30;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u6709\u6548\u6807\u5fd7", (Object)"enabledMark"));
                        continue block30;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block30;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block30;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<BeforeSaleSupportTemplateInfoVO> info(@PathVariable(value="id") String id) {
        BeforeSaleSupportTemplateEntity entity = this.beforeSaleSupportTemplateService.getInfo(id);
        BeforeSaleSupportTemplateInfoVO vo = (BeforeSaleSupportTemplateInfoVO)JsonUtil.getJsonToBean((Object)entity, BeforeSaleSupportTemplateInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<BeforeSaleSupportTemplateInfoVO> detailInfo(@PathVariable(value="id") String id) {
        BeforeSaleSupportTemplateEntity entity = this.beforeSaleSupportTemplateService.getInfo(id);
        BeforeSaleSupportTemplateInfoVO vo = (BeforeSaleSupportTemplateInfoVO)JsonUtil.getJsonToBean((Object)entity, BeforeSaleSupportTemplateInfoVO.class);
        vo.setEnabledMark(this.baseDataUtil.getDictName(vo.getEnabledMark(), "whether"));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid BeforeSaleSupportTemplateUpForm beforeSaleSupportTemplateUpForm) throws DataException {
        this.beforeSaleSupportTemplateService.update(id, beforeSaleSupportTemplateUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        BeforeSaleSupportTemplateEntity entity = this.beforeSaleSupportTemplateService.getInfo(id);
        if (entity != null) {
            this.beforeSaleSupportTemplateService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

