/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import io.swagger.annotations.Api;
import java.io.File;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4ee3\u7406\u5546"}, value="contract")
@RequestMapping(value={"/api/contract/file"})
public class ImportFileTest {
    private static final Logger log = LoggerFactory.getLogger(ImportFileTest.class);
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private RkContractProjectService contractProjectService;

    public static void changeName(File file, String findValue, String replaceValue) {
        for (File subdirectory : Optional.ofNullable(file.listFiles()).orElse(new File[0])) {
            if (subdirectory.isDirectory() && subdirectory.listFiles().length > 0) {
                ImportFileTest.changeName(subdirectory, findValue, replaceValue);
                continue;
            }
            String newName = subdirectory.getParent() + File.separator + "20231026_yanshou_" + subdirectory.getName().replace(findValue, replaceValue);
            subdirectory.renameTo(new File(newName));
        }
        String newName = file.getParent() + File.separator + file.getName().replace(findValue, replaceValue);
        file.renameTo(new File(newName));
        System.out.println("\u64cd\u4f5c\u6210\u529f");
    }

    public static void main(String[] args) {
        String path = "D:\\rongke\\\u6587\u6863\\\u5408\u540c\u9644\u4ef6\\\u9a8c\u6536\u62a5\u544a-\u7b2c\u4e00\u6279";
        String findValue = "";
        String replaceValue = "";
        ImportFileTest.changeName(new File(path), findValue, replaceValue);
    }

    public static void main1(String[] args) {
        String directoryPath = "D:\\rongke\\\u6587\u6863\\\u5408\u540c\u9644\u4ef6\\\u9500\u552e\u5408\u540c-\u7b2c\u4e00\u6279";
        File directory = new File(directoryPath);
        if (directory.exists() && directory.isDirectory()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                System.out.println(file.getName());
                String filename = file.getName();
                long length = file.length();
                int index = filename.lastIndexOf(".");
                String name = filename.substring(0, index);
                String extension = filename.substring(index + 1);
                System.out.println(name);
                System.out.println(extension);
            }
        }
    }

    @PostMapping(value={"fileyanshou"})
    public ActionResult fileyanshou() {
        String directoryPath = "D:\\rongke\\\u6587\u6863\\\u5408\u540c\u9644\u4ef6\\\u9a8c\u6536\u62a5\u544a-\u7b2c\u4e00\u6279";
        File directory = new File(directoryPath);
        if (directory.exists() && directory.isDirectory()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                String filename = file.getName();
                long length = file.length();
                int index = filename.lastIndexOf(".");
                String name = filename.substring(0, index);
                String extension = filename.substring(index + 1);
                String replace = name.replace("20231026_yanshou_", "");
                List<RkContractEntity> listByCode = this.contractService.getListByCode(replace);
                if (CollectionUtil.isNotEmpty(listByCode) && listByCode.size() == 1) {
                    Object entity;
                    RkContractEntity contractEntity = listByCode.get(0);
                    List<RkContractProjectEntity> projectList = this.contractProjectService.getListByContractId(contractEntity.getId());
                    String id = "";
                    if (CollectionUtil.isEmpty(projectList)) {
                        entity = new RkContractProjectEntity();
                        ((RkContractProjectEntity)entity).setContractId(contractEntity.getId());
                        ((RkContractProjectEntity)entity).setProjectCode(contractEntity.getContractCode() + "-1");
                        id = RandomUtil.uuId();
                        ((RkContractProjectEntity)entity).setId(id);
                        ((RkContractProjectEntity)entity).setProjectName(contractEntity.getContractName());
                        ((RkContractProjectEntity)entity).setCustomerId(contractEntity.getCustomerId());
                        ((RkContractProjectEntity)entity).setCompanyId(contractEntity.getCompanyId());
                        ((RkContractProjectEntity)entity).setDepartmentTree("[]");
                        ((RkContractProjectEntity)entity).setIsUploadAcceptFile(1);
                        ((RkContractProjectEntity)entity).setIsAcceptance(0);
                        this.contractProjectService.save(entity);
                    } else {
                        id = projectList.get(0).getId();
                    }
                    entity = new RkAttachmentEntity();
                    ((RkAttachmentEntity)entity).setId(RandomUtil.uuId());
                    ((RkAttachmentEntity)entity).setContractId(contractEntity.getId());
                    ((RkAttachmentEntity)entity).setFileId(filename);
                    String url = "/api/file/Image/annex/" + filename;
                    ((RkAttachmentEntity)entity).setUrl(url);
                    ((RkAttachmentEntity)entity).setName(contractEntity.getContractName() + "\u9a8c\u6536\u62a5\u544a" + filename.replace("20231026_yanshou_", ""));
                    ((RkAttachmentEntity)entity).setFileSize(Double.valueOf(length));
                    ((RkAttachmentEntity)entity).setFileType("project");
                    ((RkAttachmentEntity)entity).setEnabledMark(1);
                    ((RkAttachmentEntity)entity).setProjectId(id);
                    this.attachmentService.save(entity);
                    contractEntity.setIsHaveAttachment(1);
                    this.contractService.update(contractEntity.getId(), contractEntity);
                    continue;
                }
                log.info("fileName:{},size:{}", (Object)filename, (Object)listByCode.size());
            }
        }
        return ActionResult.success();
    }

    @PostMapping(value={"createProject/{companyId}"})
    public ActionResult createProject(@PathVariable(value="companyId") String companyId) {
        List<RkContractEntity> listByCompanyIdAndNotDraft = this.contractService.getListByCompanyIdAndNotDraftNotHaveProject(companyId);
        for (RkContractEntity contractEntity : listByCompanyIdAndNotDraft) {
            List<RkContractProjectEntity> projectList = this.contractProjectService.getListByContractId(contractEntity.getId());
            String id = "";
            if (!CollectionUtil.isEmpty(projectList)) continue;
            RkContractProjectEntity entity = new RkContractProjectEntity();
            entity.setContractId(contractEntity.getId());
            entity.setProjectCode(contractEntity.getContractCode() + "-1");
            id = RandomUtil.uuId();
            entity.setId(id);
            entity.setProjectName(contractEntity.getContractName());
            entity.setCustomerId(contractEntity.getCustomerId());
            entity.setCompanyId(contractEntity.getCompanyId());
            entity.setDepartmentTree("[]");
            entity.setProjectRatio(new BigDecimal(100));
            entity.setProjectAmount(contractEntity.getContractAmount());
            entity.setIsUploadAcceptFile(0);
            entity.setIsAcceptance(0);
            entity.setReceivedState(0);
            entity.setReceivedAmount(BigDecimal.ZERO);
            entity.setReceivedRatio(BigDecimal.ZERO);
            entity.setIncomeType(contractEntity.getIncomeType());
            entity.setSalerId(contractEntity.getSalerId());
            entity.setSalerName(contractEntity.getSalerName());
            this.contractProjectService.save(entity);
        }
        return ActionResult.success();
    }

    @PostMapping(value={"file"})
    public ActionResult file() {
        String directoryPath = "D:\\rongke\\\u6587\u6863\\\u5408\u540c\u9644\u4ef6\\\u9500\u552e\u5408\u540c-\u7b2c\u4e00\u6279";
        File directory = new File(directoryPath);
        if (directory.exists() && directory.isDirectory()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                String filename = file.getName();
                long length = file.length();
                int index = filename.lastIndexOf(".");
                String name = filename.substring(0, index);
                String extension = filename.substring(index + 1);
                String replace = name.replace("20231026_", "");
                List<RkContractEntity> listByCode = this.contractService.getListByCode(replace);
                if (CollectionUtil.isNotEmpty(listByCode) && listByCode.size() == 1) {
                    RkContractEntity contractEntity = listByCode.get(0);
                    RkAttachmentEntity entity = new RkAttachmentEntity();
                    entity.setId(RandomUtil.uuId());
                    entity.setContractId(contractEntity.getId());
                    entity.setFileId(filename);
                    String url = "/api/file/Image/annex/" + filename;
                    entity.setUrl(url);
                    entity.setName(filename.replace("20231026_", ""));
                    entity.setFileSize(Double.valueOf(length));
                    entity.setFileType("contract");
                    entity.setEnabledMark(1);
                    this.attachmentService.save(entity);
                    contractEntity.setIsHaveAttachment(1);
                    this.contractService.update(contractEntity.getId(), contractEntity);
                    continue;
                }
                log.info("fileName:{},size:{}", (Object)filename, (Object)listByCode.size());
            }
        }
        return ActionResult.success();
    }
}

