/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.OaFileEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.model.oafile.FileImportReturnVO;
import com.bringspring.contract.model.oafile.FileImportVO;
import com.bringspring.contract.model.oafile.OaFileCrForm;
import com.bringspring.contract.model.oafile.OaFileInfoVO;
import com.bringspring.contract.model.oafile.OaFileListVO;
import com.bringspring.contract.model.oafile.OaFilePagination;
import com.bringspring.contract.model.oafile.OaFileUpForm;
import com.bringspring.contract.model.rkattachment.RkAttachmentCrForm;
import com.bringspring.contract.model.rkattachment.RkAttachmentListVO;
import com.bringspring.contract.service.OaFileService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.Records;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u6863\u6848\u7ba1\u7406"}, value="oa")
@RequestMapping(value={"/api/oa/OaFile"})
public class OaFileController {
    private static final Logger log = LoggerFactory.getLogger(OaFileController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OaFileService oaFileService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OaFilePagination oaFilePagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        String organizeId = userInfo.getOrganizeId();
        oaFilePagination.setUserId(userInfo.getUserId());
        oaFilePagination.setCompanyId(organizeId);
        List<OaFileEntity> list = this.oaFileService.getList(oaFilePagination);
        for (OaFileEntity oaFileEntity : list) {
            oaFileEntity.setFileId(this.baseDataUtil.userSelectValue(oaFileEntity.getFileId()));
            oaFileEntity.setChoseTypeName(this.baseDataUtil.getDictName(oaFileEntity.getChoseType(), Records.CHOSE_TYPE_DICT));
            oaFileEntity.setRecordPatternName(this.baseDataUtil.getDictName(oaFileEntity.getRecordPattern(), Records.RECORD_PATTERN_DICT));
            oaFileEntity.setRecordStatusName(this.baseDataUtil.getDictName(oaFileEntity.getRecordStatus(), Records.RECORD_STATUS_DICT));
            oaFileEntity.setSecrecyLevelName(this.baseDataUtil.getDictName(oaFileEntity.getSecrecyLevel(), Records.SECRECY_LEVEL_DICT));
            oaFileEntity.setRelationTypeName(this.baseDataUtil.getDictName(oaFileEntity.getRelationType(), Records.RELATION_TYPE_DICT));
            oaFileEntity.setIsEdit(oaFileEntity.getIsEdit());
        }
        List listVO = JsonUtil.getJsonToList(list, OaFileListVO.class);
        for (OaFileListVO oaFileListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)oaFilePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaFileCrForm oaFileCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        String organizeId = userInfo.getOrganizeId();
        oaFileCrForm.setCompanyId(organizeId);
        oaFileCrForm.setFileId(userInfo.getUserId());
        OaFileEntity entity = (OaFileEntity)JsonUtil.getJsonToBean((Object)oaFileCrForm, OaFileEntity.class);
        entity.setId(mainId);
        entity.setIsEdit(1);
        entity.setChoseTypeName(this.baseDataUtil.getDictName(entity.getChoseType(), Records.CHOSE_TYPE_DICT));
        entity.setRecordPatternName(this.baseDataUtil.getDictName(entity.getRecordPattern(), Records.RECORD_PATTERN_DICT));
        entity.setRecordStatusName(this.baseDataUtil.getDictName(entity.getRecordStatus(), Records.RECORD_STATUS_DICT));
        entity.setSecrecyLevelName(this.baseDataUtil.getDictName(entity.getSecrecyLevel(), Records.SECRECY_LEVEL_DICT));
        entity.setRelationTypeName(this.baseDataUtil.getDictName(entity.getRelationType(), Records.RELATION_TYPE_DICT));
        this.oaFileService.save(entity);
        List<RkAttachmentCrForm> attachmentList = oaFileCrForm.getAttachmentList();
        attachmentList.stream().forEach(attach -> {
            attach.setContractId(mainId);
            attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
        });
        List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
        this.rkAttachmentService.saveBatch(attachmentEntityList);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OaFileInfoVO> info(@PathVariable(value="id") String id) {
        OaFileEntity entity = this.oaFileService.getInfo(id);
        OaFileInfoVO vo = (OaFileInfoVO)JsonUtil.getJsonToBean((Object)entity, OaFileInfoVO.class);
        if (vo.getFileDate() != null) {
            vo.setFileDate(vo.getFileDate());
        }
        vo.setFileId(vo.getFileId());
        vo.setFileIdName(this.baseDataUtil.userSelectValue(vo.getFileId()));
        vo.setChoseTypeName(this.baseDataUtil.getDictName(vo.getChoseType(), ""));
        vo.setRecordPatternName(this.baseDataUtil.getDictName(vo.getRecordPattern(), ""));
        vo.setRecordStatusName(this.baseDataUtil.getDictName(vo.getRecordStatus(), ""));
        vo.setSecrecyLevelName(this.baseDataUtil.getDictName(vo.getSecrecyLevel(), ""));
        vo.setRelationTypeName(this.baseDataUtil.getDictName(vo.getRelationType(), ""));
        List<RkAttachmentEntity> listByContractId = this.rkAttachmentService.getListByContractId(id);
        List jsonToList = JsonUtil.getJsonToList(listByContractId, RkAttachmentListVO.class);
        vo.setAttachmentList(jsonToList);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OaFileInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OaFileEntity entity = this.oaFileService.getInfo(id);
        OaFileInfoVO vo = (OaFileInfoVO)JsonUtil.getJsonToBean((Object)entity, OaFileInfoVO.class);
        vo.setFileId(this.baseDataUtil.userSelectValue(vo.getFileId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaFileUpForm oaFileUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OaFileEntity entity = this.oaFileService.getInfo(id);
        if (entity != null) {
            OaFileEntity subentity = (OaFileEntity)JsonUtil.getJsonToBean((Object)oaFileUpForm, OaFileEntity.class);
            subentity.setFileDate(entity.getFileDate());
            subentity.setFileId(entity.getFileId());
            this.oaFileService.updateFile(id, oaFileUpForm);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OaFileEntity entity = this.oaFileService.getInfo(id);
        if (entity != null) {
            this.oaFileService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult<Object> Uploader() {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().endsWith(".xlsx") || file.getOriginalFilename().endsWith(".xls")) {
            String filePath = XSSEscape.escape((String)this.configValueUtil.getTemporaryFilePath());
            String fileName = XSSEscape.escape((String)(RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file)));
            FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
            try {
                UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)(filePath + fileName), (String)"temporary", (String)fileName);
            }
            catch (IOException e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            DownloadVO vo = DownloadVO.builder().build();
            vo.setName(fileName);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u6863\u6848\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u6863\u6848\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List fileImportList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, FileImportVO.class);
        if (CollectionUtil.isEmpty((Collection)fileImportList)) {
            return ActionResult.fail((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fileImportList.size() > 200) {
            return ActionResult.fail((String)"\u6700\u591a\u5bfc\u5165\u6570\u636e200\u6761");
        }
        List list = JsonUtil.getJsonToList((Object)fileImportList, Object.class);
        Map<String, Object> map = this.oaFileService.importPreview(list, new FileImportVO());
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<FileImportReturnVO> ImportData(@RequestBody FileImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), FileImportVO.class);
        FileImportReturnVO result = this.oaFileService.importData(dataList);
        return ActionResult.success((Object)result);
    }
}

