/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.contract.entity.OaProjectPlanApplyEntity;
import com.bringspring.contract.entity.OaProjectPlanDetailApplyEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.model.oaProjectStartWorkApply.OaProjectStartWorkApplyCrForm;
import com.bringspring.contract.model.rk_project_plan.RkProjectPlanDetailModel;
import com.bringspring.contract.model.rkattachment.RkAttachmentCrForm;
import com.bringspring.contract.model.rkprojectplan.RkProjectPlanInfoVO;
import com.bringspring.contract.service.OaProjectPlanApplyService;
import com.bringspring.contract.service.OaProjectPlanDetailApplyService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.crm.util.CrmReminderEnum;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u5b9e\u65bd\u5f00\u5de5\u7533\u8bf7"}, value="oa")
@RequestMapping(value={"/api/oa/OaProjectStartWorkApply"})
public class OaProjectStartWorkApplyController {
    private static final Logger log = LoggerFactory.getLogger(OaProjectStartWorkApplyController.class);
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private OaProjectPlanApplyService oaProjectPlanApplyService;
    @Autowired
    private OaProjectPlanDetailApplyService oaProjectPlanDetailApplyService;
    @Autowired
    private RkAttachmentService attachmentService;

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OaProjectStartWorkApplyCrForm form) throws Exception {
        String flowEngineId = "694469487906291973";
        if (StrUtil.isNotBlank((CharSequence)form.getFlowId())) {
            flowEngineId = form.getFlowId();
        }
        if (StrUtil.isBlank((CharSequence)form.getProjectId())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u8981\u5f00\u5de5\u7684\u9879\u76ee");
        }
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)form.getProjectId()));
        if (byId.getEnabledMark() == 0) {
            return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        String mainId = RandomUtil.uuId();
        form.setMainId(mainId);
        Boolean isProjectPlan = this.oaProjectPlanApplyService.create(form);
        if (!isProjectPlan.booleanValue()) {
            return ActionResult.fail((String)"\u9879\u76ee\u8ba1\u5212\u6a21\u677f\u5df2\u5b58\u5728");
        }
        FlowUtil.saveOrSubmit((String)form.getTaskId(), (String)flowEngineId, (String)form.getTemplateId(), (String)mainId, (Object)((Object)form), (Integer)form.getStatus(), (String)(byId.getProjectName() + "\u9879\u76ee\u5b9e\u65bd\u5f00\u5de5\u7533\u8bf7"));
        if (form.getStatus() == 0) {
            return ActionResult.success((String)CrmReminderEnum.TS.getType());
        }
        return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OaProjectStartWorkApplyCrForm form) throws DataException, WorkFlowException {
        RkContractProjectEntity byId;
        String flowEngineId = "694469487906291973";
        if (StrUtil.isNotBlank((CharSequence)form.getFlowId())) {
            flowEngineId = form.getFlowId();
        }
        if ((byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)form.getProjectId()))).getEnabledMark() == 0) {
            return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        OaProjectPlanApplyEntity infoByProjectId = this.oaProjectPlanApplyService.getInfo(form.getId());
        if (infoByProjectId != null) {
            this.oaProjectPlanApplyService.updatePlan(form, infoByProjectId.getId());
            FlowUtil.saveOrSubmit((String)form.getTaskId(), (String)flowEngineId, (String)form.getTemplateId(), (String)infoByProjectId.getId(), (Object)((Object)form), (Integer)form.getStatus(), (String)(byId.getProjectName() + "\u9879\u76ee\u5b9e\u65bd\u5f00\u5de5\u7533\u8bf7"));
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProjectPlanInfoVO> info(@PathVariable(value="id") String id) {
        OaProjectPlanApplyEntity entity = this.oaProjectPlanApplyService.getInfo(id);
        RkProjectPlanInfoVO vo = (RkProjectPlanInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProjectPlanInfoVO.class);
        if (ObjectUtil.isNotEmpty((Object)vo)) {
            ArrayList<Long> planTime = new ArrayList<Long>();
            planTime.add(vo.getPlanStartTime());
            planTime.add(vo.getPlanEndTime());
            vo.setPlanTime(planTime);
            List<OaProjectPlanDetailApplyEntity> RkProjectPlanDetailList = this.oaProjectPlanDetailApplyService.GetRkProjectPlanDetailList(vo.getId());
            List rkProjectPlanDetailModelList = JsonUtil.getJsonToList(RkProjectPlanDetailList, RkProjectPlanDetailModel.class);
            if (CollectionUtil.isNotEmpty((Collection)rkProjectPlanDetailModelList)) {
                for (RkProjectPlanDetailModel model : rkProjectPlanDetailModelList) {
                    List<OaProjectPlanDetailApplyEntity> subPlan;
                    List subPlanModel;
                    ArrayList<Long> planTimeMain = new ArrayList<Long>();
                    planTimeMain.add(model.getPlanStartTime());
                    planTimeMain.add(model.getPlanEndTime());
                    if (CollectionUtil.isNotEmpty(planTimeMain)) {
                        model.setPlanTime(planTimeMain);
                    } else {
                        model.setPlanTime(new ArrayList<Long>());
                    }
                    if (!CollectionUtil.isNotEmpty((Collection)(subPlanModel = JsonUtil.getJsonToList(subPlan = this.oaProjectPlanDetailApplyService.getSubPlan(model.getId()), RkProjectPlanDetailModel.class)))) continue;
                    subPlanModel.forEach(detail -> {
                        ArrayList<Long> planTimeSub = new ArrayList<Long>();
                        planTimeSub.add(detail.getPlanStartTime());
                        planTimeSub.add(detail.getPlanEndTime());
                        if (CollectionUtil.isNotEmpty(planTimeSub)) {
                            detail.setPlanTime(planTimeSub);
                        } else {
                            detail.setPlanTime(new ArrayList<Long>());
                        }
                    });
                    model.setSubPlanChildren(subPlanModel);
                }
                vo.setRkProjectPlanDetailList(rkProjectPlanDetailModelList);
            } else {
                vo.setRkProjectPlanDetailList(new ArrayList<RkProjectPlanDetailModel>());
            }
            List<RkAttachmentEntity> attachmentEntityList = this.attachmentService.getListByObjId(entity.getId());
            List attachmentList = JsonUtil.getJsonToList(attachmentEntityList, RkAttachmentCrForm.class);
            if (CollectionUtil.isNotEmpty((Collection)attachmentList)) {
                vo.setAttachmentList(attachmentList);
            } else {
                vo.setAttachmentList(new ArrayList<RkAttachmentCrForm>());
            }
        }
        return ActionResult.success((Object)vo);
    }
}

