/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.PurchaseGoodRecordEntity;
import com.bringspring.contract.entity.PurchaseGoodsListEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProcureEntity;
import com.bringspring.contract.entity.RkMaterialEntity;
import com.bringspring.contract.model.purchasegoodrecord.PurchaseGoodRecordCrForm;
import com.bringspring.contract.model.purchasegoodrecord.PurchaseGoodRecordExportModel;
import com.bringspring.contract.model.purchasegoodrecord.PurchaseGoodRecordInfoVO;
import com.bringspring.contract.model.purchasegoodrecord.PurchaseGoodRecordListVO;
import com.bringspring.contract.model.purchasegoodrecord.PurchaseGoodRecordPagination;
import com.bringspring.contract.model.purchasegoodrecord.PurchaseGoodRecordUpForm;
import com.bringspring.contract.service.PurchaseGoodRecordService;
import com.bringspring.contract.service.PurchaseGoodsListService;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkMaterialService;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d27\u7269\u64cd\u4f5c\u8bb0\u5f55"}, value="contract")
@RequestMapping(value={"/api/contract/PurchaseGoodRecord"})
public class PurchaseGoodRecordController {
    private static final Logger log = LoggerFactory.getLogger(PurchaseGoodRecordController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private PurchaseGoodRecordService purchaseGoodRecordService;
    @Autowired
    private PurchaseGoodsListService purchaseGoodsListService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RkMaterialService rkMaterialService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody PurchaseGoodRecordPagination purchaseGoodRecordPagination) throws IOException {
        purchaseGoodRecordPagination.setCompanyId(this.userProvider.get().getOrganizeId());
        List<PurchaseGoodRecordEntity> list = this.purchaseGoodRecordService.getList(purchaseGoodRecordPagination);
        for (PurchaseGoodRecordEntity object2 : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, PurchaseGoodRecordListVO.class);
        Iterator iterator = listVO.iterator();
        while (iterator.hasNext()) {
            PurchaseGoodRecordListVO purchaseGoodRecordVO;
            purchaseGoodRecordVO.setGoodsType((purchaseGoodRecordVO = (PurchaseGoodRecordListVO)iterator.next()).getGoodsType().equals("1") ? "\u6536\u8d27" : (purchaseGoodRecordVO.getGoodsType().equals("2") ? "\u9a8c\u8d27" : "\u9000\u8d27"));
            purchaseGoodRecordVO.setIsAgree(StringUtils.isEmpty((String)purchaseGoodRecordVO.getIsAgree()) ? "\u662f" : (purchaseGoodRecordVO.getIsAgree().equals("1") ? "\u662f" : "\u5426"));
            purchaseGoodRecordVO.setIsSatisfied(StringUtils.isEmpty((String)purchaseGoodRecordVO.getIsSatisfied()) ? "\u662f" : (purchaseGoodRecordVO.getIsSatisfied().equals("1") ? "\u662f" : "\u5426"));
            purchaseGoodRecordVO.setIsComplete(StringUtils.isEmpty((String)purchaseGoodRecordVO.getIsComplete()) ? "\u662f" : (purchaseGoodRecordVO.getIsComplete().equals("1") ? "\u662f" : "\u5426"));
            purchaseGoodRecordVO.setCreatorDeptId(this.baseDataUtil.comSelectValues(purchaseGoodRecordVO.getCreatorDeptId()));
            purchaseGoodRecordVO.setCreatorUserId(this.baseDataUtil.userSelectValue(purchaseGoodRecordVO.getCreatorUserId()));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)purchaseGoodRecordPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid PurchaseGoodRecordCrForm purchaseGoodRecordCrForm) throws DataException {
        RkContractProcureEntity procureEntity;
        RkContractEntity contract;
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        PurchaseGoodRecordEntity entity = (PurchaseGoodRecordEntity)JsonUtil.getJsonToBean((Object)purchaseGoodRecordCrForm, PurchaseGoodRecordEntity.class);
        entity.setId(mainId);
        String goodsId = entity.getGoodsId();
        entity.setCreatorTime(new Date());
        entity.setCreatorUserId(userInfo.getUserId());
        PurchaseGoodsListEntity entity1 = this.purchaseGoodsListService.getInfo(goodsId);
        RkMaterialEntity rkMaterial = this.rkMaterialService.getInfo(entity1.getMaterialId());
        entity.setApplyCode(entity1.getApplyCode());
        entity.setProcureCode(entity1.getHtCode());
        entity.setMaterialCode(entity1.getMaterialCode());
        entity.setMaterialProperties(this.baseDataUtil.getDictName(rkMaterial.getMaterialProperties(), "materialProperties"));
        entity.setMaterialType(this.baseDataUtil.getDictName(rkMaterial.getMaterialType(), "MaterialType"));
        entity.setMaterialBrand(this.baseDataUtil.getDictName(rkMaterial.getMaterialBrand(), "MaterialBrand"));
        entity.setMaterialUnit(this.baseDataUtil.getDictName(rkMaterial.getMaterialUnit(), "MaterialUnit"));
        entity.setMaterialName(rkMaterial.getMaterialName());
        entity.setMaterialModel(rkMaterial.getMaterialModel());
        entity.setMaterialDescription(entity1.getDescription());
        entity.setManager(this.baseDataUtil.userSelectValue(entity1.getXmjl()));
        entity.setApplyCount(entity1.getApplyCount().toString());
        entity.setApplyPrice(entity1.getApplyPrice().toString());
        entity.setXsCode(entity1.getXsCode());
        entity.setCompanyId(userInfo.getOrganizeId());
        if (StringUtils.isNotEmpty((String)entity1.getXsId()) && (contract = this.contractService.getInfo(entity1.getXsId())) != null) {
            entity.setXsName(contract.getContractName());
        }
        if (StringUtils.isNotEmpty((String)entity1.getHtId()) && (procureEntity = this.rkContractProcureService.getInfo(entity1.getHtId())) != null) {
            entity.setProcureName(procureEntity.getProcureName());
            entity.setProcureCreatorUserId(procureEntity.getApplyName());
            entity.setProcureCode(procureEntity.getProcureCode());
        }
        entity.setCreatorDeptId(userInfo.getDepartmentId());
        if (entity.getGoodsNumber().compareTo(entity1.getApplyCount()) == -1 || entity.getGoodsNumber().compareTo(entity1.getApplyCount()) == 0) {
            if (entity.getGoodsType() == 1) {
                entity1.setHarvestNumber(MathUtils.add(entity1.getHarvestNumber(), entity.getGoodsNumber()));
                this.purchaseGoodsListService.updateById(entity1);
                this.purchaseGoodRecordService.save(entity);
                return ActionResult.success((String)"\u6536\u8d27\u6210\u529f");
            }
            if (entity.getGoodsType() == 2) {
                entity1.setInspectionNumber(MathUtils.add(entity1.getInspectionNumber(), entity.getGoodsNumber()));
                this.purchaseGoodsListService.updateById(entity1);
                this.purchaseGoodRecordService.save(entity);
                return ActionResult.success((String)"\u9a8c\u8d27\u6210\u529f");
            }
            entity1.setReturnNumber(MathUtils.add(entity1.getReturnNumber(), entity.getGoodsNumber()));
            this.purchaseGoodsListService.updateById(entity1);
            this.purchaseGoodRecordService.save(entity);
            return ActionResult.success((String)"\u9000\u8d27\u6210\u529f");
        }
        return ActionResult.fail((String)"\u672c\u6b21\u786e\u8ba4\u6570\u91cf\u5927\u4e8e\u603b\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u8f38\u5165\uff01");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<PurchaseGoodRecordInfoVO> info(@PathVariable(value="id") String id) {
        PurchaseGoodRecordEntity entity = this.purchaseGoodRecordService.getInfo(id);
        PurchaseGoodRecordInfoVO vo = (PurchaseGoodRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, PurchaseGoodRecordInfoVO.class);
        vo.setGoodsNumber(entity.getGoodsNumber());
        vo.setGoodsType(vo.getGoodsType().equals("1") ? "\u6536\u8d27" : (vo.getGoodsType().equals("2") ? "\u9a8c\u8d27" : "\u9000\u8d27"));
        vo.setIsAgree(StringUtils.isEmpty((String)vo.getIsAgree()) ? "\u662f" : (vo.getIsAgree().equals("1") ? "\u662f" : "\u5426"));
        vo.setIsSatisfied(StringUtils.isEmpty((String)vo.getIsSatisfied()) ? "\u662f" : (vo.getIsSatisfied().equals("1") ? "\u662f" : "\u5426"));
        vo.setIsComplete(StringUtils.isEmpty((String)vo.getIsComplete()) ? "\u662f" : (vo.getIsComplete().equals("1") ? "\u662f" : "\u5426"));
        vo.setCreatorDeptId(this.baseDataUtil.comSelectValues(vo.getCreatorDeptId()));
        vo.setCreatorUserName(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<PurchaseGoodRecordInfoVO> detailInfo(@PathVariable(value="id") String id) {
        PurchaseGoodRecordEntity entity = this.purchaseGoodRecordService.getInfo(id);
        PurchaseGoodRecordInfoVO vo = (PurchaseGoodRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, PurchaseGoodRecordInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid PurchaseGoodRecordUpForm purchaseGoodRecordUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        PurchaseGoodRecordEntity entity = this.purchaseGoodRecordService.getInfo(id);
        if (entity != null) {
            PurchaseGoodRecordEntity subentity = (PurchaseGoodRecordEntity)JsonUtil.getJsonToBean((Object)purchaseGoodRecordUpForm, PurchaseGoodRecordEntity.class);
            this.purchaseGoodRecordService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        PurchaseGoodRecordEntity entity = this.purchaseGoodRecordService.getInfo(id);
        if (entity != null) {
            this.purchaseGoodRecordService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(PurchaseGoodRecordExportModel purchaseGoodRecordExportModel) throws IOException {
        if (StringUtil.isEmpty((String)purchaseGoodRecordExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        PurchaseGoodRecordPagination procurePagination = (PurchaseGoodRecordPagination)((Object)JsonUtil.getJsonToBean((Object)purchaseGoodRecordExportModel, PurchaseGoodRecordPagination.class));
        String organizeId = this.userProvider.get().getOrganizeId();
        List<PurchaseGoodRecordEntity> list = this.purchaseGoodRecordService.getTypeList(procurePagination, purchaseGoodRecordExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, PurchaseGoodRecordListVO.class);
        Iterator iterator = listVO.iterator();
        while (iterator.hasNext()) {
            PurchaseGoodsListEntity goods;
            PurchaseGoodRecordListVO purchaseGoodRecordVO;
            purchaseGoodRecordVO.setGoodsType((purchaseGoodRecordVO = (PurchaseGoodRecordListVO)iterator.next()).getGoodsType().equals("1") ? "\u6536\u8d27" : (purchaseGoodRecordVO.getGoodsType().equals("2") ? "\u9a8c\u8d27" : "\u9000\u8d27"));
            purchaseGoodRecordVO.setIsAgree(StringUtils.isEmpty((String)purchaseGoodRecordVO.getIsAgree()) ? "\u662f" : (purchaseGoodRecordVO.getIsAgree().equals("1") ? "\u662f" : "\u5426"));
            purchaseGoodRecordVO.setIsSatisfied(StringUtils.isEmpty((String)purchaseGoodRecordVO.getIsSatisfied()) ? "\u662f" : (purchaseGoodRecordVO.getIsSatisfied().equals("1") ? "\u662f" : "\u5426"));
            purchaseGoodRecordVO.setIsComplete(StringUtils.isEmpty((String)purchaseGoodRecordVO.getIsComplete()) ? "\u662f" : (purchaseGoodRecordVO.getIsComplete().equals("1") ? "\u662f" : "\u5426"));
            purchaseGoodRecordVO.setCreatorDeptId(this.baseDataUtil.comSelectValues(purchaseGoodRecordVO.getCreatorDeptId()));
            purchaseGoodRecordVO.setCreatorUserId(this.baseDataUtil.userSelectValue(purchaseGoodRecordVO.getCreatorUserId()));
            if (StringUtils.isNotEmpty((String)purchaseGoodRecordVO.getGoodsId()) && (goods = this.purchaseGoodsListService.getInfo(purchaseGoodRecordVO.getGoodsId())) != null) {
                purchaseGoodRecordVO.setCloseFlowStatus(goods.getCloseFlowStatus());
            }
            if (StringUtils.isNotEmpty((String)purchaseGoodRecordVO.getCloseFlowStatus())) {
                purchaseGoodRecordVO.setCloseFlowStatus(purchaseGoodRecordVO.getCloseFlowStatus().equals("2") ? "\u5173\u95ed" : "\u6253\u5f00");
                continue;
            }
            purchaseGoodRecordVO.setCloseFlowStatus("\u6253\u5f00");
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)purchaseGoodRecordExportModel.getSelectKey()) ? purchaseGoodRecordExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block64: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "goodsDate": {
                        entitys.add(new ExcelExportEntity("\u64cd\u4f5c\u65e5\u671f", (Object)"goodsDate"));
                        continue block64;
                    }
                    case "goodsType": {
                        entitys.add(new ExcelExportEntity("\u7c7b\u578b", (Object)"goodsType"));
                        continue block64;
                    }
                    case "creatorDeptId": {
                        entitys.add(new ExcelExportEntity("\u64cd\u4f5c\u5458\u90e8\u95e8", (Object)"creatorDeptId"));
                        continue block64;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u64cd\u4f5c\u5458", (Object)"creatorUserId"));
                        continue block64;
                    }
                    case "xsCode": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u53f7", (Object)"xsCode"));
                        continue block64;
                    }
                    case "xsName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u540d\u79f0", (Object)"xsName"));
                        continue block64;
                    }
                    case "goodsNumber": {
                        entitys.add(new ExcelExportEntity("\u672c\u6b21\u64cd\u4f5c\u6570\u91cf", (Object)"goodsNumber"));
                        continue block64;
                    }
                    case "applyCode": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u660e\u7ec6\u5355\u636e\u53f7", (Object)"applyCode"));
                        continue block64;
                    }
                    case "materialCode": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u7f16\u53f7", (Object)"materialCode"));
                        continue block64;
                    }
                    case "materialProperties": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u5c5e\u6027", (Object)"materialProperties"));
                        continue block64;
                    }
                    case "materialType": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u5206\u7c7b", (Object)"materialType"));
                        continue block64;
                    }
                    case "materialBrand": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u54c1\u724c", (Object)"materialBrand"));
                        continue block64;
                    }
                    case "materialName": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u540d\u79f0", (Object)"materialName"));
                        continue block64;
                    }
                    case "materialModel": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u578b\u53f7", (Object)"materialModel"));
                        continue block64;
                    }
                    case "materialDescription": {
                        entitys.add(new ExcelExportEntity("\u8be6\u7ec6\u914d\u7f6e", (Object)"materialDescription"));
                        continue block64;
                    }
                    case "materialUnit": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u91cf\u5355\u4f4d", (Object)"materialUnit"));
                        continue block64;
                    }
                    case "manager": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7ecf\u7406", (Object)"manager"));
                        continue block64;
                    }
                    case "applyCount": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u6570\u91cf", (Object)"applyCount"));
                        continue block64;
                    }
                    case "applyPrice": {
                        entitys.add(new ExcelExportEntity("\u5355\u4ef7", (Object)"applyPrice"));
                        continue block64;
                    }
                    case "procureCreatorUserId": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5458", (Object)"procureCreatorUserId"));
                        continue block64;
                    }
                    case "procureCode": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u53f7", (Object)"procureCode"));
                        continue block64;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u7cfb\u7edf\u64cd\u4f5c\u65e5\u671f", (Object)"creatorTime"));
                        continue block64;
                    }
                    case "isSatisfied": {
                        entitys.add(new ExcelExportEntity("\u7269\u6d41\u662f\u5426\u6ee1\u610f", (Object)"isSatisfied"));
                        continue block64;
                    }
                    case "isComplete": {
                        entitys.add(new ExcelExportEntity("\u5305\u88c5\u662f\u5426\u5b8c\u6574", (Object)"isComplete"));
                        continue block64;
                    }
                    case "isAgree": {
                        entitys.add(new ExcelExportEntity("\u6570\u91cf\u662f\u5426\u9884\u7b97\u76f8\u7b26", (Object)"isAgree"));
                        continue block64;
                    }
                    case "closeFlowStatus": {
                        entitys.add(new ExcelExportEntity("\u660e\u7ec6\u72b6\u6001", (Object)"closeFlowStatus"));
                        continue block64;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u6536\u9a8c\u8d27\u8bb0\u5f55");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/getGoodsRecordListByProcureId/{id}"})
    public ActionResult getGoodsRecordListByProcureId(@PathVariable(value="id") String procureId) {
        List<PurchaseGoodsListEntity> list = this.purchaseGoodsListService.findGoodsByProcureId(procureId);
        if (CollectionUtil.isNotEmpty(list)) {
            List<String> list1 = list.stream().map(PurchaseGoodsListEntity::getId).collect(Collectors.toList());
            List<PurchaseGoodRecordEntity> recordList = this.purchaseGoodRecordService.getListByGoodsIds(list1);
            List listVO = JsonUtil.getJsonToList(recordList, PurchaseGoodRecordListVO.class);
            Iterator iterator = listVO.iterator();
            while (iterator.hasNext()) {
                PurchaseGoodRecordListVO purchaseGoodRecordVO;
                purchaseGoodRecordVO.setGoodsType((purchaseGoodRecordVO = (PurchaseGoodRecordListVO)iterator.next()).getGoodsType().equals("1") ? "\u6536\u8d27" : (purchaseGoodRecordVO.getGoodsType().equals("2") ? "\u9a8c\u8d27" : "\u9000\u8d27"));
                purchaseGoodRecordVO.setIsAgree(StringUtils.isEmpty((String)purchaseGoodRecordVO.getIsAgree()) ? "\u662f" : (purchaseGoodRecordVO.getIsAgree().equals("1") ? "\u662f" : "\u5426"));
                purchaseGoodRecordVO.setIsSatisfied(StringUtils.isEmpty((String)purchaseGoodRecordVO.getIsSatisfied()) ? "\u662f" : (purchaseGoodRecordVO.getIsSatisfied().equals("1") ? "\u662f" : "\u5426"));
                purchaseGoodRecordVO.setIsComplete(StringUtils.isEmpty((String)purchaseGoodRecordVO.getIsComplete()) ? "\u662f" : (purchaseGoodRecordVO.getIsComplete().equals("1") ? "\u662f" : "\u5426"));
                purchaseGoodRecordVO.setCreatorDeptId(this.baseDataUtil.comSelectValues(purchaseGoodRecordVO.getCreatorDeptId()));
                purchaseGoodRecordVO.setCreatorUserId(this.baseDataUtil.userSelectValues(purchaseGoodRecordVO.getCreatorUserId()));
                if (!StringUtils.isNotEmpty((String)purchaseGoodRecordVO.getGoodsId())) continue;
                PurchaseGoodsListEntity purchaseGoodsListEntity = this.purchaseGoodsListService.getInfo(purchaseGoodRecordVO.getGoodsId());
                purchaseGoodRecordVO.setCloseFlowStatus(purchaseGoodsListEntity.getCloseFlowStatus());
            }
            return ActionResult.success((Object)listVO);
        }
        List listVO = CollectionUtil.list((boolean)false);
        return ActionResult.success((Object)listVO);
    }
}

