/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.PurchaseGoodRecordEntity;
import com.bringspring.contract.entity.PurchaseGoodsListEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProcureEntity;
import com.bringspring.contract.entity.RkMaterialEntity;
import com.bringspring.contract.entity.RkPurchaseApplyEntity;
import com.bringspring.contract.model.purchasegoodslist.ProcureGoodsListPaginationExportModel;
import com.bringspring.contract.model.purchasegoodslist.PurchaseGoodsListCrForm;
import com.bringspring.contract.model.purchasegoodslist.PurchaseGoodsListExportModel;
import com.bringspring.contract.model.purchasegoodslist.PurchaseGoodsListInfoVO;
import com.bringspring.contract.model.purchasegoodslist.PurchaseGoodsListListVO;
import com.bringspring.contract.model.purchasegoodslist.PurchaseGoodsListPagination;
import com.bringspring.contract.model.purchasegoodslist.PurchaseGoodsListUpForm;
import com.bringspring.contract.model.rkcontractprocure.RkContractProcurePaginationExportModel;
import com.bringspring.contract.service.CrmErpEnterService;
import com.bringspring.contract.service.PurchaseGoodRecordService;
import com.bringspring.contract.service.PurchaseGoodsListService;
import com.bringspring.contract.service.RkContractProcureRelationService;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkMaterialService;
import com.bringspring.contract.service.RkPurchaseApplyService;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.supplier.entity.SupplierEntity;
import com.bringspring.supplier.service.SupplierService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u91c7\u8d2d\u6536\u83b7\u9a8c\u8d27\u9000\u8d27"}, value="contract")
@RequestMapping(value={"/api/contract/PurchaseGoodsList"})
public class PurchaseGoodsListController {
    private static final Logger log = LoggerFactory.getLogger(PurchaseGoodsListController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private PurchaseGoodsListService purchaseGoodsListService;
    @Autowired
    private PurchaseGoodRecordService purchaseGoodRecordService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RkContractProcureService contractProcureService;
    @Autowired
    private SupplierService supplierService;
    @Autowired
    private RkPurchaseApplyService rkPurchaseApplyService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkContractProcureRelationService rkContractProcureRelationService;
    @Autowired
    private UserService userService;
    @Autowired
    private RkMaterialService rkMaterialService;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private CrmErpEnterService crmErpEnterService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody PurchaseGoodsListPagination purchaseGoodsListPagination) throws IOException {
        purchaseGoodsListPagination.setCompanyId(this.userProvider.get().getOrganizeId());
        List<PurchaseGoodsListEntity> list = this.purchaseGoodsListService.getList(purchaseGoodsListPagination);
        for (PurchaseGoodsListEntity purchaseGoodsListEntity : list) {
            purchaseGoodsListEntity.setMaterialUnit(this.baseDataUtil.getDictName(purchaseGoodsListEntity.getMaterialUnit(), "MaterialUnit"));
        }
        List listVO = JsonUtil.getJsonToList(list, PurchaseGoodsListListVO.class);
        for (PurchaseGoodsListListVO purchaseGoodsListListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)purchaseGoodsListPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid PurchaseGoodsListCrForm purchaseGoodsListCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        PurchaseGoodsListEntity entity = (PurchaseGoodsListEntity)JsonUtil.getJsonToBean((Object)purchaseGoodsListCrForm, PurchaseGoodsListEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        this.purchaseGoodsListService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<PurchaseGoodsListInfoVO> info(@PathVariable(value="id") String id) {
        PurchaseGoodsListEntity entity = this.purchaseGoodsListService.getInfo(id);
        PurchaseGoodsListInfoVO vo = (PurchaseGoodsListInfoVO)JsonUtil.getJsonToBean((Object)entity, PurchaseGoodsListInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<PurchaseGoodsListInfoVO> detailInfo(@PathVariable(value="id") String id) {
        PurchaseGoodsListEntity entity = this.purchaseGoodsListService.getInfo(id);
        PurchaseGoodsListInfoVO vo = (PurchaseGoodsListInfoVO)JsonUtil.getJsonToBean((Object)entity, PurchaseGoodsListInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid PurchaseGoodsListUpForm purchaseGoodsListUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        PurchaseGoodsListEntity entity = this.purchaseGoodsListService.getInfo(id);
        if (entity != null) {
            PurchaseGoodsListEntity subentity = (PurchaseGoodsListEntity)JsonUtil.getJsonToBean((Object)purchaseGoodsListUpForm, PurchaseGoodsListEntity.class);
            this.purchaseGoodsListService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        PurchaseGoodsListEntity entity = this.purchaseGoodsListService.getInfo(id);
        if (entity != null) {
            this.purchaseGoodsListService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @ApiOperation(value="\u4e00\u952e\u6536\u8d27")
    @GetMapping(value={"/batchHarvest/{ids}"})
    public ActionResult batchHarvest(@PathVariable(value="ids") String ids) {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            String[] idList = ids.split(",");
            List<String> allIdList = Arrays.asList(idList);
            List goodsList = this.purchaseGoodsListService.listByIds(allIdList);
            goodsList.stream().forEach(goods -> {
                if (goods.getApplyCount().compareTo(goods.getHarvestNumber()) != 0) {
                    RkContractProcureEntity procureEntity;
                    RkContractEntity contract;
                    PurchaseGoodRecordEntity goodRecord = new PurchaseGoodRecordEntity();
                    goodRecord.setGoodsNumber(MathUtils.substract(goods.getApplyCount(), goods.getHarvestNumber()));
                    goodRecord.setGoodsId(goods.getId());
                    goodRecord.setId(RandomUtil.uuId());
                    goodRecord.setGoodsDate(new Date());
                    goodRecord.setGoodsType(1);
                    goodRecord.setIsAgree(1);
                    goodRecord.setIsSatisfied(1);
                    goodRecord.setIsComplete(1);
                    goodRecord.setDescription("\u4e00\u952e\u6536\u8d27");
                    goodRecord.setCreatorUserId(this.userProvider.get().getUserId());
                    goodRecord.setCreatorTime(new Date());
                    goodRecord.setCreatorUserId(userInfo.getUserId());
                    RkMaterialEntity rkMaterial = this.rkMaterialService.getInfo(goods.getMaterialId());
                    goodRecord.setApplyCode(goods.getApplyCode());
                    goodRecord.setProcureCode(goods.getHtCode());
                    goodRecord.setMaterialCode(goods.getMaterialCode());
                    goodRecord.setMaterialProperties(this.baseDataUtil.getDictName(rkMaterial.getMaterialProperties(), "materialProperties"));
                    goodRecord.setMaterialType(this.baseDataUtil.getDictName(rkMaterial.getMaterialType(), "MaterialType"));
                    goodRecord.setMaterialBrand(this.baseDataUtil.getDictName(rkMaterial.getMaterialBrand(), "MaterialBrand"));
                    goodRecord.setMaterialUnit(this.baseDataUtil.getDictName(rkMaterial.getMaterialUnit(), "MaterialUnit"));
                    goodRecord.setMaterialName(rkMaterial.getMaterialName());
                    goodRecord.setMaterialModel(rkMaterial.getMaterialModel());
                    goodRecord.setMaterialDescription(goods.getDescription());
                    goodRecord.setManager(this.baseDataUtil.userSelectValue(goods.getXmjl()));
                    goodRecord.setApplyCount(goods.getApplyCount().toString());
                    goodRecord.setApplyPrice(goods.getApplyPrice().toString());
                    goodRecord.setXsCode(goods.getXsCode());
                    if (StringUtils.isNotEmpty((String)goods.getXsId()) && (contract = this.contractService.getInfo(goods.getXsId())) != null) {
                        goodRecord.setXsName(contract.getContractName());
                    }
                    if (StringUtils.isNotEmpty((String)goods.getHtId()) && (procureEntity = this.rkContractProcureService.getInfo(goods.getHtId())) != null) {
                        goodRecord.setProcureName(procureEntity.getProcureName());
                        goodRecord.setProcureCreatorUserId(procureEntity.getApplyName());
                        goodRecord.setProcureCode(procureEntity.getProcureCode());
                    }
                    goodRecord.setCreatorDeptId(userInfo.getDepartmentId());
                    this.purchaseGoodRecordService.save(goodRecord);
                    goods.setHarvestNumber(goods.getApplyCount());
                }
            });
            this.purchaseGoodsListService.updateBatchById(goodsList);
            return ActionResult.success((String)"\u4e00\u952e\u6536\u8d27\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @ApiOperation(value="\u4e00\u952e\u9a8c\u8d27")
    @GetMapping(value={"/batchInspection/{ids}"})
    public ActionResult batchInspection(@PathVariable(value="ids") String ids) {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            String[] idList = ids.split(",");
            List<String> allIdList = Arrays.asList(idList);
            List goodsList = this.purchaseGoodsListService.listByIds(allIdList);
            goodsList.stream().forEach(goods -> {
                if (goods.getApplyCount().compareTo(goods.getInspectionNumber()) != 0) {
                    RkContractProcureEntity procureEntity;
                    RkContractEntity contract;
                    PurchaseGoodRecordEntity goodRecord = new PurchaseGoodRecordEntity();
                    goodRecord.setGoodsNumber(MathUtils.substract(goods.getApplyCount(), goods.getInspectionNumber()));
                    goodRecord.setGoodsId(goods.getId());
                    goodRecord.setId(RandomUtil.uuId());
                    goodRecord.setGoodsDate(new Date());
                    goodRecord.setGoodsType(2);
                    goodRecord.setIsAgree(1);
                    goodRecord.setIsSatisfied(1);
                    goodRecord.setIsComplete(1);
                    goodRecord.setDescription("\u4e00\u952e\u9a8c\u8d27");
                    goodRecord.setCreatorUserId(this.userProvider.get().getUserId());
                    goodRecord.setCreatorTime(new Date());
                    goodRecord.setCreatorUserId(userInfo.getUserId());
                    RkMaterialEntity rkMaterial = this.rkMaterialService.getInfo(goods.getMaterialId());
                    goodRecord.setApplyCode(goods.getApplyCode());
                    goodRecord.setProcureCode(goods.getHtCode());
                    goodRecord.setMaterialCode(goods.getMaterialCode());
                    goodRecord.setMaterialProperties(this.baseDataUtil.getDictName(rkMaterial.getMaterialProperties(), "materialProperties"));
                    goodRecord.setMaterialType(this.baseDataUtil.getDictName(rkMaterial.getMaterialType(), "MaterialType"));
                    goodRecord.setMaterialBrand(this.baseDataUtil.getDictName(rkMaterial.getMaterialBrand(), "MaterialBrand"));
                    goodRecord.setMaterialUnit(this.baseDataUtil.getDictName(rkMaterial.getMaterialUnit(), "MaterialUnit"));
                    goodRecord.setMaterialName(rkMaterial.getMaterialName());
                    goodRecord.setMaterialModel(rkMaterial.getMaterialModel());
                    goodRecord.setMaterialDescription(goods.getDescription());
                    goodRecord.setManager(this.baseDataUtil.userSelectValue(goods.getXmjl()));
                    goodRecord.setApplyCount(goods.getApplyCount().toString());
                    goodRecord.setApplyPrice(goods.getApplyPrice().toString());
                    goodRecord.setXsCode(goods.getXsCode());
                    if (StringUtils.isNotEmpty((String)goods.getXsId()) && (contract = this.contractService.getInfo(goods.getXsId())) != null) {
                        goodRecord.setXsName(contract.getContractName());
                    }
                    if (StringUtils.isNotEmpty((String)goods.getHtId()) && (procureEntity = this.rkContractProcureService.getInfo(goods.getHtId())) != null) {
                        goodRecord.setProcureName(procureEntity.getProcureName());
                        goodRecord.setProcureCreatorUserId(procureEntity.getApplyName());
                        goodRecord.setProcureCode(procureEntity.getProcureCode());
                    }
                    goodRecord.setCreatorDeptId(userInfo.getDepartmentId());
                    this.purchaseGoodRecordService.save(goodRecord);
                    goods.setInspectionNumber(goods.getApplyCount());
                }
            });
            this.purchaseGoodsListService.updateBatchById(goodsList);
            return ActionResult.success((String)"\u4e00\u952e\u9a8c\u8d27\u6210\u529f");
        }
    }

    @PostMapping(value={"/getGoodsList"})
    public ActionResult getGoodsList(@RequestBody PurchaseGoodsListPagination purchaseGoodsListPagination) {
        List dataList = this.dictionaryDataService.getDicList("4360623057975783731");
        List<PurchaseGoodsListEntity> list = this.purchaseGoodsListService.findGoodsByIdAndKey(purchaseGoodsListPagination);
        List listVO = JsonUtil.getJsonToList(list, PurchaseGoodsListListVO.class);
        for (PurchaseGoodsListListVO purchaseGoodsListVO : listVO) {
            purchaseGoodsListVO.setHarvestNumber(this.crmErpEnterService.getHarvestNumber(purchaseGoodsListVO.getHtCode(), purchaseGoodsListVO.getMaterialCode()));
            purchaseGoodsListVO.setMaterialUnit(this.baseDataUtil.getDictName(purchaseGoodsListVO.getMaterialUnit(), "MaterialUnit"));
            purchaseGoodsListVO.setInvoiceTaxName(purchaseGoodsListVO.getApplyTaxRate());
            if (!StringUtils.isNotEmpty((String)purchaseGoodsListVO.getApplyTaxRate())) continue;
            List matchData = dataList.stream().filter(a -> a.getFullName().contains(purchaseGoodsListVO.getApplyTaxRate())).collect(Collectors.toList());
            purchaseGoodsListVO.setApplyTaxRate(matchData.stream().map(DictionaryDataEntity::getId).distinct().collect(Collectors.joining("")));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)purchaseGoodsListPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/findGoodsByProcure/{id}"})
    public ActionResult findGoodsByProcure(@PathVariable(value="id") String procureId) {
        List<PurchaseGoodsListEntity> list = this.purchaseGoodsListService.findGoodsByProcureId(procureId);
        List listVO = JsonUtil.getJsonToList(list, PurchaseGoodsListExportModel.class);
        List diclist = this.dictionaryDataService.list((Wrapper)new QueryWrapper());
        for (PurchaseGoodsListExportModel purchaseGoodsListVO : listVO) {
            BigDecimal returnNumber;
            List unitList;
            List brandList;
            List typeList;
            List propertiesList = diclist.stream().filter(a -> a.getEnCode().equals(purchaseGoodsListVO.getMaterialProperties())).filter(a -> a.getDictionaryTypeId().equals("523060482374910725")).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(propertiesList)) {
                purchaseGoodsListVO.setMaterialProperties(((DictionaryDataEntity)propertiesList.get(0)).getFullName());
            }
            if (CollectionUtil.isNotEmpty(typeList = diclist.stream().filter(a -> a.getEnCode().equals(purchaseGoodsListVO.getMaterialType())).filter(a -> a.getDictionaryTypeId().equals("495138245651205189")).collect(Collectors.toList()))) {
                purchaseGoodsListVO.setMaterialType(((DictionaryDataEntity)typeList.get(0)).getFullName());
            }
            if (CollectionUtil.isNotEmpty(brandList = diclist.stream().filter(a -> a.getEnCode().equals(purchaseGoodsListVO.getMaterialBrand())).filter(a -> a.getDictionaryTypeId().equals("495138354195598405")).collect(Collectors.toList()))) {
                purchaseGoodsListVO.setMaterialBrand(((DictionaryDataEntity)brandList.get(0)).getFullName());
            }
            if (CollectionUtil.isNotEmpty(unitList = diclist.stream().filter(a -> a.getEnCode().equals(purchaseGoodsListVO.getMaterialUnit())).filter(a -> a.getDictionaryTypeId().equals("495138486265842757")).collect(Collectors.toList()))) {
                purchaseGoodsListVO.setMaterialUnit(((DictionaryDataEntity)unitList.get(0)).getFullName());
            }
            if (StringUtils.isNotEmpty((String)purchaseGoodsListVO.getApplyType()) && purchaseGoodsListVO.getApplyType().equals("OaBudgetBuy")) {
                purchaseGoodsListVO.setApplyDate(DateUtil.daFormat((Date)purchaseGoodsListVO.getCreatorTime()));
                purchaseGoodsListVO.setApplyUser(purchaseGoodsListVO.getCreatorUserName());
            } else {
                RkPurchaseApplyEntity apply = this.rkPurchaseApplyService.getInfo(purchaseGoodsListVO.getParentId());
                if (apply != null) {
                    purchaseGoodsListVO.setApplyDate(DateUtil.daFormat((Date)apply.getCreatorTime()));
                    purchaseGoodsListVO.setApplyUser(this.baseDataUtil.userSelectValue(apply.getCreatorUserId()));
                }
            }
            purchaseGoodsListVO.setApplyCount(StringUtils.isEmpty((String)purchaseGoodsListVO.getApplyCount()) ? "0" : purchaseGoodsListVO.getApplyCount());
            purchaseGoodsListVO.setApplyPrice(StringUtils.isEmpty((String)purchaseGoodsListVO.getApplyPrice()) ? "0" : purchaseGoodsListVO.getApplyPrice());
            String total = MathUtils.multiply(purchaseGoodsListVO.getApplyCount(), purchaseGoodsListVO.getApplyPrice());
            purchaseGoodsListVO.setApplyTotal(total);
            if (StringUtils.isNotEmpty((String)purchaseGoodsListVO.getApplyTaxRate())) {
                Double tax = MathUtils.add(MathUtils.divide(Double.parseDouble(purchaseGoodsListVO.getApplyTaxRate()), 100.0, 2), 1.0);
                String unTaxTotal = MathUtils.divide(total, tax.toString(), 2);
                purchaseGoodsListVO.setNoTaxTotalPrice(unTaxTotal);
            }
            purchaseGoodsListVO.setContractCode(purchaseGoodsListVO.getXsCode());
            if (StringUtil.isNotEmpty((String)purchaseGoodsListVO.getXsId())) {
                RkContractEntity rkContractEntity = this.contractService.getInfo(purchaseGoodsListVO.getXsId());
                purchaseGoodsListVO.setContractName(rkContractEntity.getContractName());
                purchaseGoodsListVO.setContractUserName(rkContractEntity.getSalerName());
            }
            if (StringUtils.isNotEmpty((String)purchaseGoodsListVO.getArrivalDate())) {
                purchaseGoodsListVO.setArrivalDate(DateUtil.daFormatHHMMSS((Long)Long.parseLong(purchaseGoodsListVO.getArrivalDate())));
            }
            BigDecimal applyCount = BigDecimal.valueOf(Double.parseDouble(purchaseGoodsListVO.getApplyCount() == null ? "0" : purchaseGoodsListVO.getApplyCount()));
            BigDecimal harvestNumber = purchaseGoodsListVO.getHarvestNumber() == null ? BigDecimal.ZERO : purchaseGoodsListVO.getHarvestNumber();
            BigDecimal inspectionNumber = purchaseGoodsListVO.getInspectionNumber() == null ? BigDecimal.ZERO : purchaseGoodsListVO.getInspectionNumber();
            BigDecimal bigDecimal = returnNumber = purchaseGoodsListVO.getReturnNumber() == null ? BigDecimal.ZERO : purchaseGoodsListVO.getReturnNumber();
            if (MathUtils.substract(applyCount, harvestNumber).add(returnNumber).compareTo(BigDecimal.ZERO) <= 0 && MathUtils.substract(applyCount, inspectionNumber).add(returnNumber).compareTo(BigDecimal.ZERO) <= 0) {
                purchaseGoodsListVO.setGoodsStatue("\u5df2\u5168\u90e8\u6536\u9a8c\u8d27");
                continue;
            }
            purchaseGoodsListVO.setGoodsStatue("\u672a\u5168\u90e8\u6536\u9a8c\u8d27");
        }
        return ActionResult.success((Object)listVO);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkContractProcurePaginationExportModel rkContractProcurePaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkContractProcurePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        ProcureGoodsListPaginationExportModel purchaseGoodsListPagination = (ProcureGoodsListPaginationExportModel)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractProcurePaginationExportModel), ProcureGoodsListPaginationExportModel.class));
        String organizeId = this.userProvider.get().getOrganizeId();
        List<PurchaseGoodsListEntity> list = this.purchaseGoodsListService.findContractGoodsExport(purchaseGoodsListPagination);
        List listVO = JsonUtil.getJsonToList(list, PurchaseGoodsListExportModel.class);
        if (CollectionUtil.isNotEmpty((Collection)listVO)) {
            List diclist = this.dictionaryDataService.list((Wrapper)new QueryWrapper());
            List procurelist = this.contractProcureService.list((Wrapper)new QueryWrapper());
            List supplierList = this.supplierService.list((Wrapper)new QueryWrapper());
            List applyList = this.rkPurchaseApplyService.list((Wrapper)new QueryWrapper());
            List contractList = this.contractService.list((Wrapper)new QueryWrapper());
            List contractRelationList = this.rkContractProcureRelationService.list((Wrapper)new QueryWrapper());
            List userList = this.userService.list((Wrapper)new QueryWrapper());
            for (PurchaseGoodsListExportModel rkContractProcureListVO : listVO) {
                BigDecimal returnNumber;
                List matchContractList;
                List matchApply;
                List matchProcure;
                List unitList;
                List brandList;
                List typeList;
                List propertiesList = diclist.stream().filter(a -> a.getEnCode().equals(rkContractProcureListVO.getMaterialProperties())).filter(a -> a.getDictionaryTypeId().equals("523060482374910725")).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(propertiesList)) {
                    rkContractProcureListVO.setMaterialProperties(((DictionaryDataEntity)propertiesList.get(0)).getFullName());
                }
                if (CollectionUtil.isNotEmpty(typeList = diclist.stream().filter(a -> a.getEnCode().equals(rkContractProcureListVO.getMaterialType())).filter(a -> a.getDictionaryTypeId().equals("495138245651205189")).collect(Collectors.toList()))) {
                    rkContractProcureListVO.setMaterialType(((DictionaryDataEntity)typeList.get(0)).getFullName());
                }
                if (CollectionUtil.isNotEmpty(brandList = diclist.stream().filter(a -> a.getEnCode().equals(rkContractProcureListVO.getMaterialBrand())).filter(a -> a.getDictionaryTypeId().equals("495138354195598405")).collect(Collectors.toList()))) {
                    rkContractProcureListVO.setMaterialBrand(((DictionaryDataEntity)brandList.get(0)).getFullName());
                }
                if (CollectionUtil.isNotEmpty(unitList = diclist.stream().filter(a -> a.getEnCode().equals(rkContractProcureListVO.getMaterialUnit())).filter(a -> a.getDictionaryTypeId().equals("495138486265842757")).collect(Collectors.toList()))) {
                    rkContractProcureListVO.setMaterialUnit(((DictionaryDataEntity)unitList.get(0)).getFullName());
                }
                if (StringUtil.isNotEmpty((String)rkContractProcureListVO.getHtId()) && CollectionUtil.isNotEmpty(matchProcure = procurelist.stream().filter(a -> a.getId().equals(rkContractProcureListVO.getHtId())).collect(Collectors.toList()))) {
                    List payMethod;
                    RkContractProcureEntity procure = (RkContractProcureEntity)matchProcure.get(0);
                    rkContractProcureListVO.setProcureName(procure.getProcureName());
                    rkContractProcureListVO.setProcureAmount(procure.getProcureAmount().toString());
                    rkContractProcureListVO.setProcureApplyDate(DateUtil.daFormat((Date)procure.getApplyDate()));
                    rkContractProcureListVO.setProcureCode(procure.getProcureCode());
                    rkContractProcureListVO.setProcureApplyName(procure.getApplyName());
                    List matchSupplier = supplierList.stream().filter(a -> a.getId().equals(procure.getSupplierId())).collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(matchSupplier)) {
                        SupplierEntity supplier = (SupplierEntity)matchSupplier.get(0);
                        rkContractProcureListVO.setSupplierCode(supplier.getCode());
                        rkContractProcureListVO.setProcureSupplierName(supplier.getSupplierName());
                        rkContractProcureListVO.setSupplierLevel(supplier.getSupplierLevel());
                    }
                    rkContractProcureListVO.setDeliveryTime(procure.getDeliveryTime().toString());
                    if (StringUtils.isNotEmpty((String)procure.getPaymentMethodType()) && CollectionUtil.isNotEmpty(payMethod = diclist.stream().filter(a -> a.getId().equals(procure.getPaymentMethodType())).collect(Collectors.toList()))) {
                        rkContractProcureListVO.setPaymentMethodTypeName(((DictionaryDataEntity)payMethod.get(0)).getFullName());
                    }
                    rkContractProcureListVO.setWarranty(procure.getWarranty().toString());
                    rkContractProcureListVO.setEnableMark(procure.getEnableMark());
                }
                if (CollectionUtil.isNotEmpty(matchApply = applyList.stream().filter(a -> a.getId().equals(rkContractProcureListVO.getParentId())).collect(Collectors.toList()))) {
                    RkPurchaseApplyEntity apply = (RkPurchaseApplyEntity)matchApply.get(0);
                    rkContractProcureListVO.setApplyDate(DateUtil.daFormat((Date)apply.getCreatorTime()));
                    rkContractProcureListVO.setApplyUser(apply.getCreatorUserName());
                }
                if (StringUtils.isEmpty((String)rkContractProcureListVO.getApplyCount())) {
                    rkContractProcureListVO.setApplyCount("0");
                }
                if (StringUtils.isEmpty((String)rkContractProcureListVO.getApplyPrice())) {
                    rkContractProcureListVO.setApplyPrice("0");
                }
                String total = MathUtils.multiply(rkContractProcureListVO.getApplyCount(), rkContractProcureListVO.getApplyPrice());
                rkContractProcureListVO.setApplyTotal(total);
                if (StringUtils.isNotEmpty((String)rkContractProcureListVO.getApplyTaxRate())) {
                    Double tax = MathUtils.add(MathUtils.divide(Double.parseDouble(rkContractProcureListVO.getApplyTaxRate()), 100.0, 2), 1.0);
                    String unTaxTotal = MathUtils.divide(total, tax.toString(), 2);
                    rkContractProcureListVO.setNoTaxTotalPrice(unTaxTotal);
                }
                rkContractProcureListVO.setContractCode(rkContractProcureListVO.getXsCode());
                if (StringUtil.isNotEmpty((String)rkContractProcureListVO.getXsId()) && CollectionUtil.isNotEmpty(matchContractList = contractList.stream().filter(b -> rkContractProcureListVO.getXsId().equals(b.getId())).collect(Collectors.toList()))) {
                    rkContractProcureListVO.setContractName(matchContractList.stream().map(RkContractEntity::getContractName).distinct().collect(Collectors.joining(";")));
                    rkContractProcureListVO.setContractUserName(matchContractList.stream().map(RkContractEntity::getSalerName).distinct().collect(Collectors.joining(";")));
                }
                if (StringUtils.isNotEmpty((String)rkContractProcureListVO.getArrivalDate()) && !rkContractProcureListVO.getArrivalDate().contains("-")) {
                    rkContractProcureListVO.setArrivalDate(DateUtil.daFormatHHMMSS((Long)Long.parseLong(rkContractProcureListVO.getArrivalDate())));
                }
                BigDecimal applyCount = BigDecimal.valueOf(Double.parseDouble(rkContractProcureListVO.getApplyCount() == null ? "0" : rkContractProcureListVO.getApplyCount()));
                BigDecimal harvestNumber = rkContractProcureListVO.getHarvestNumber() == null ? BigDecimal.ZERO : rkContractProcureListVO.getHarvestNumber();
                BigDecimal inspectionNumber = rkContractProcureListVO.getInspectionNumber() == null ? BigDecimal.ZERO : rkContractProcureListVO.getInspectionNumber();
                BigDecimal bigDecimal = returnNumber = rkContractProcureListVO.getReturnNumber() == null ? BigDecimal.ZERO : rkContractProcureListVO.getReturnNumber();
                if (MathUtils.substract(applyCount, harvestNumber).add(returnNumber).compareTo(BigDecimal.ZERO) <= 0 && MathUtils.substract(applyCount, inspectionNumber).add(returnNumber).compareTo(BigDecimal.ZERO) <= 0) {
                    rkContractProcureListVO.setGoodsStatue("\u5df2\u5168\u90e8\u6536\u9a8c\u8d27");
                } else {
                    rkContractProcureListVO.setGoodsStatue("\u672a\u5168\u90e8\u6536\u9a8c\u8d27");
                }
                if (StringUtils.isNotEmpty((String)rkContractProcureListVO.getCloseFlowStatus())) {
                    rkContractProcureListVO.setCloseFlowStatus(rkContractProcureListVO.getCloseFlowStatus().equals("2") ? "\u5173\u95ed" : "\u6253\u5f00");
                    continue;
                }
                rkContractProcureListVO.setCloseFlowStatus("\u6253\u5f00");
            }
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkContractProcurePaginationExportModel.getSelectKey()) ? rkContractProcurePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block102: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "procureApplyDate": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u7533\u8bf7\u65e5\u671f", (Object)"procureApplyDate"));
                        continue block102;
                    }
                    case "procureCode": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u53f7", (Object)"procureCode"));
                        continue block102;
                    }
                    case "procureName": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u540d\u79f0", (Object)"procureName"));
                        continue block102;
                    }
                    case "procureAmount": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u91d1\u989d", (Object)"procureAmount"));
                        continue block102;
                    }
                    case "supplierCode": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u7f16\u7801", (Object)"supplierCode"));
                        continue block102;
                    }
                    case "procureSupplierName": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u540d\u79f0", (Object)"procureSupplierName"));
                        continue block102;
                    }
                    case "supplierLevel": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u7ea7\u522b", (Object)"supplierLevel"));
                        continue block102;
                    }
                    case "procureApplyName": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5458", (Object)"procureApplyName"));
                        continue block102;
                    }
                    case "deliveryTime": {
                        entitys.add(new ExcelExportEntity("\u8d27\u671f", (Object)"deliveryTime"));
                        continue block102;
                    }
                    case "paymentMethodTypeName": {
                        entitys.add(new ExcelExportEntity("\u4ed8\u6b3e\u5f62\u5f0f", (Object)"paymentMethodTypeName"));
                        continue block102;
                    }
                    case "warranty": {
                        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u671f", (Object)"warranty"));
                        continue block102;
                    }
                    case "enableMark": {
                        entitys.add(new ExcelExportEntity("\u5ba1\u6279\u72b6\u6001", (Object)"enableMark"));
                        continue block102;
                    }
                    case "applyUser": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u7533\u8bf7\u4eba", (Object)"applyUser"));
                        continue block102;
                    }
                    case "applyDate": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u7533\u8bf7\u65e5\u671f", (Object)"applyDate"));
                        continue block102;
                    }
                    case "applyCode": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u660e\u7ec6\u5355\u636e\u53f7", (Object)"applyCode"));
                        continue block102;
                    }
                    case "materialCode": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u7f16\u53f7", (Object)"materialCode"));
                        continue block102;
                    }
                    case "materialProperties": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u5c5e\u6027", (Object)"materialProperties"));
                        continue block102;
                    }
                    case "materialType": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u5206\u7c7b", (Object)"materialType"));
                        continue block102;
                    }
                    case "materialBrand": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u54c1\u724c", (Object)"materialBrand"));
                        continue block102;
                    }
                    case "materialName": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u540d\u79f0", (Object)"materialName"));
                        continue block102;
                    }
                    case "materialModel": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u578b\u53f7", (Object)"materialModel"));
                        continue block102;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u8be6\u7ec6\u914d\u7f6e", (Object)"description"));
                        continue block102;
                    }
                    case "materialUnit": {
                        entitys.add(new ExcelExportEntity("\u5355\u4f4d", (Object)"materialUnit"));
                        continue block102;
                    }
                    case "applyCount": {
                        entitys.add(new ExcelExportEntity("\u6570\u91cf", (Object)"applyCount"));
                        continue block102;
                    }
                    case "applyPrice": {
                        entitys.add(new ExcelExportEntity("\u5355\u4ef7", (Object)"applyPrice"));
                        continue block102;
                    }
                    case "applyTotal": {
                        entitys.add(new ExcelExportEntity("\u603b\u989d", (Object)"applyTotal"));
                        continue block102;
                    }
                    case "applyTaxRate": {
                        entitys.add(new ExcelExportEntity("\u7a0e\u7387", (Object)"applyTaxRate"));
                        continue block102;
                    }
                    case "noTaxTotalPrice": {
                        entitys.add(new ExcelExportEntity("\u65e0\u7a0e\u603b\u4ef7", (Object)"noTaxTotalPrice"));
                        continue block102;
                    }
                    case "supplierName": {
                        entitys.add(new ExcelExportEntity("\u6307\u5b9a\u4f9b\u5e94\u5546", (Object)"supplierName"));
                        continue block102;
                    }
                    case "supplierPerson": {
                        entitys.add(new ExcelExportEntity("\u6307\u5b9a\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba", (Object)"supplierPerson"));
                        continue block102;
                    }
                    case "supplierTel": {
                        entitys.add(new ExcelExportEntity("\u6307\u5b9a\u4f9b\u5e94\u5546\u8054\u7cfb\u7535\u8bdd", (Object)"supplierTel"));
                        continue block102;
                    }
                    case "arrivalLocation": {
                        entitys.add(new ExcelExportEntity("\u5230\u8d27\u5730\u5740", (Object)"arrivalLocation"));
                        continue block102;
                    }
                    case "arrivalDate": {
                        entitys.add(new ExcelExportEntity("\u5230\u8d27\u65e5\u671f", (Object)"arrivalDate"));
                        continue block102;
                    }
                    case "arrivalContactPerson": {
                        entitys.add(new ExcelExportEntity("\u5230\u8d27\u8054\u7cfb\u4eba", (Object)"arrivalContactPerson"));
                        continue block102;
                    }
                    case "arrivalContactTel": {
                        entitys.add(new ExcelExportEntity("\u5230\u8d27\u8054\u7cfb\u4eba\u7535\u8bdd", (Object)"arrivalContactTel"));
                        continue block102;
                    }
                    case "warrantyPeriod": {
                        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u671f", (Object)"warrantyPeriod"));
                        continue block102;
                    }
                    case "remarks": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"remarks"));
                        continue block102;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u5ba2\u6237", (Object)"agentName"));
                        continue block102;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block102;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u53f7", (Object)"contractCode"));
                        continue block102;
                    }
                    case "contractUserName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u7ecf\u7406", (Object)"contractUserName"));
                        continue block102;
                    }
                    case "invoiceTotal": {
                        entitys.add(new ExcelExportEntity("\u7d2f\u8ba1\u56de\u53d1\u7968\u91d1\u989d", (Object)"invoiceTotal"));
                        continue block102;
                    }
                    case "paymentTotal": {
                        entitys.add(new ExcelExportEntity("\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d", (Object)"paymentTotal"));
                        continue block102;
                    }
                    case "goodsStatue": {
                        entitys.add(new ExcelExportEntity("\u6536\u9a8c\u8d27\u60c5\u51b5", (Object)"goodsStatue"));
                        continue block102;
                    }
                    case "closeFlowStatus": {
                        entitys.add(new ExcelExportEntity("\u660e\u7ec6\u72b6\u6001", (Object)"closeFlowStatus"));
                        continue block102;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u91c7\u8d2d\u5408\u540c\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

