/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkAgentManagerEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractVerifyEntity;
import com.bringspring.contract.model.rkagent.RkAgentCrForm;
import com.bringspring.contract.model.rkagent.RkAgentInfoVO;
import com.bringspring.contract.model.rkagent.RkAgentListVO;
import com.bringspring.contract.model.rkagent.RkAgentPagination;
import com.bringspring.contract.model.rkagent.RkAgentPaginationExportModel;
import com.bringspring.contract.model.rkagent.RkAgentUpForm;
import com.bringspring.contract.service.RkAgentManagerService;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractVerifyService;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.RoleUtils;
import com.bringspring.crm.entity.CrmCustomerContactsEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.service.CrmCustomerContactsService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4ee3\u7406\u5546"}, value="contract")
@RequestMapping(value={"/api/contract/RkAgent"})
public class RkAgentController {
    private static final Logger log = LoggerFactory.getLogger(RkAgentController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RoleUtils roleUtils;
    @Autowired
    private RkContractVerifyService rkContractVerifyService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private RkAgentManagerService rkAgentManagerService;
    @Autowired
    private CrmCustomerContactsService crmCustomerContactsService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkAgentPagination rkAgentPagination) throws IOException {
        if (StrUtil.isBlank((CharSequence)rkAgentPagination.getCompanyId()) && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkAgentPagination.setCompanyId(this.userProvider.get().getOrganizeId());
        }
        List<RkAgentEntity> list = this.rkAgentService.getList(rkAgentPagination);
        List listVO = JsonUtil.getJsonToList(list, RkAgentListVO.class);
        for (RkAgentListVO rkAgentVO : listVO) {
            List<String> ids;
            List organizeEntity;
            rkAgentVO.setType(this.baseDataUtil.getDictName(rkAgentVO.getType(), Constants.AGENT_TYPE_DICT_ID));
            rkAgentVO.setRegion(this.baseDataUtil.provinceData(rkAgentVO.getRegion()));
            rkAgentVO.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(rkAgentVO.getCreatorUserId()));
            rkAgentVO.setEnterpriseScale(this.baseDataUtil.getDictName(rkAgentVO.getEnterpriseScale(), "enterpriseSize"));
            if (StringUtils.isNotEmpty((String)rkAgentVO.getAgentProduct()) && !rkAgentVO.getAgentProduct().equals("null")) {
                StringBuffer stringBuffer = new StringBuffer();
                List<String> stringList = Arrays.asList(rkAgentVO.getAgentProduct().split(","));
                for (String s : stringList) {
                    CrmProductCategoryEntity categoryServiceInfo = this.crmProductCategoryService.getInfo(s);
                    if (!ObjectUtil.isNotNull((Object)categoryServiceInfo)) continue;
                    stringBuffer.append(categoryServiceInfo.getName() + ",");
                }
                if (!StrUtil.isBlank((CharSequence)stringBuffer.toString()) && stringBuffer.length() != 0) {
                    rkAgentVO.setAgentProduct(stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(",")).toString());
                }
            }
            rkAgentVO.setSaleId(this.baseDataUtil.userSelectValues(rkAgentVO.getSaleId()));
            rkAgentVO.setChannelType(this.baseDataUtil.getDictName(rkAgentVO.getChannelType(), "channelType"));
            if (StrUtil.isBlank((CharSequence)rkAgentVO.getCompanyId()) || !ObjectUtil.isNotEmpty((Object)(organizeEntity = this.organizeService.listByIds(ids = Arrays.asList(rkAgentVO.getCompanyId().split(",")))))) continue;
            rkAgentVO.setCompanyId(organizeEntity.stream().map(OrganizeEntity::getShortName).collect(Collectors.joining(",")));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkAgentPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getListSimple/{companyId}", "/getListSimple"})
    public ActionResult getListSimple(@PathVariable(required=false) String companyId) {
        if (StringUtils.isBlank((CharSequence)companyId)) {
            companyId = this.userProvider.get().getOrganizeId();
        }
        List<RkAgentEntity> list = this.rkAgentService.getListByCompanyId(companyId);
        return ActionResult.success(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkAgentCrForm rkAgentCrForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            String companyId = rkAgentCrForm.getCompanyId();
            if (StrUtil.isBlank((CharSequence)companyId)) {
                companyId = userInfo.getOrganizeId();
                rkAgentCrForm.setCompanyId(companyId);
            }
            if (this.rkAgentService.checkExistNameAndCompanyId(rkAgentCrForm.getName(), companyId)) {
                return ActionResult.fail((String)"\u540d\u79f0\u4e0d\u80fd\u91cd\u590d,\u8bf7\u8054\u7cfb\u6e20\u9053\u5c0f\u7ec4");
            }
            if (StringUtils.isNotEmpty((String)rkAgentCrForm.getAgentProduct())) {
                rkAgentCrForm.setAgentProduct(rkAgentCrForm.getAgentProduct().replaceAll("\"", "").replaceAll("]", "").replace("[", ""));
            }
            RkAgentEntity entity = (RkAgentEntity)JsonUtil.getJsonToBean((Object)rkAgentCrForm, RkAgentEntity.class);
            entity.setId(mainId);
            if (!ObjectUtil.isEmpty((Object)entity.getName())) {
                entity.setPinyin(PinyinUtil.getFirstLetter((String)entity.getName(), (String)"").toUpperCase());
            }
            RkAgentManagerEntity rkAgentManagerEntity = this.rkAgentManagerService.saveOrUpdateData(entity);
            entity.setParentId(rkAgentManagerEntity.getId());
            this.rkAgentService.save(entity);
            if (StrUtil.isNotEmpty((CharSequence)entity.getContact()) || StrUtil.isNotEmpty((CharSequence)entity.getContactNo())) {
                this.saveContact(entity);
            }
            HashMap map = MapUtil.newHashMap();
            map.put("id", entity.getId());
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f", (Object)map);
        }
    }

    private boolean saveContact(RkAgentEntity rkAgentEntity) {
        CrmCustomerContactsEntity contactsEntity = (CrmCustomerContactsEntity)JsonUtil.getJsonToBean((Object)rkAgentEntity, CrmCustomerContactsEntity.class);
        contactsEntity.setId(RandomUtil.uuId());
        contactsEntity.setAgentId(rkAgentEntity.getId());
        contactsEntity.setAgentManagerId(rkAgentEntity.getParentId());
        contactsEntity.setCustomerSource("agent");
        contactsEntity.setName(rkAgentEntity.getContact());
        contactsEntity.setPost(rkAgentEntity.getContactPosition());
        contactsEntity.setPhone(rkAgentEntity.getContactNo());
        contactsEntity.setPublicMark(1);
        contactsEntity.setPublicType("companyIdPublic");
        contactsEntity.setObjectId(rkAgentEntity.getCompanyId());
        contactsEntity.setEnabledMark(0);
        contactsEntity.setIsBlock(0);
        contactsEntity.setPinyin(PinyinUtil.getFirstLetter((String)contactsEntity.getName(), (String)"").toUpperCase());
        contactsEntity.setOriginalCreatorUserId(this.userProvider.get().getUserId());
        return this.crmCustomerContactsService.save(contactsEntity);
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkAgentPaginationExportModel rkAgentPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkAgentPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkAgentPagination rkAgentPagination = (RkAgentPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkAgentPaginationExportModel), RkAgentPagination.class));
        List<List<String>> region = rkAgentPagination.getRegion();
        if (CollectionUtil.isNotEmpty(region)) {
            List searchRegion = CollectionUtil.list((boolean)false);
            region.stream().forEach(l -> searchRegion.add(l.get(0)));
            rkAgentPagination.setSearchRegion(searchRegion);
        }
        List<RkAgentEntity> list = this.rkAgentService.getTypeList(rkAgentPagination, rkAgentPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, RkAgentListVO.class);
        for (RkAgentListVO rkAgentVO : listVO) {
            List<String> ids;
            List<CrmProductCategoryEntity> productList;
            rkAgentVO.setType(this.baseDataUtil.getDictName(rkAgentVO.getType(), Constants.AGENT_TYPE_DICT_ID));
            rkAgentVO.setRegion(this.baseDataUtil.provinceData(rkAgentVO.getRegion()));
            if (StringUtils.isNotEmpty((String)rkAgentVO.getAgentProduct()) && ObjectUtil.isNotEmpty(productList = this.crmProductCategoryService.getInfoByIdList(ids = Arrays.asList(rkAgentVO.getAgentProduct().split(","))))) {
                rkAgentVO.setAgentProduct(productList.stream().map(CrmProductCategoryEntity::getName).collect(Collectors.joining(",")));
            }
            rkAgentVO.setCompanyId(this.baseDataUtil.comSelectValue(rkAgentVO.getCompanyId(), "1"));
            rkAgentVO.setSaleId(this.baseDataUtil.userSelectValue(rkAgentVO.getSaleId()));
            rkAgentVO.setCreatorUserId(this.baseDataUtil.userSelectValues(rkAgentVO.getCreatorUserId()));
            rkAgentVO.setChannelType(this.baseDataUtil.getDictName(rkAgentVO.getChannelType(), "channelType"));
            rkAgentVO.setEnterpriseScale(this.baseDataUtil.getDictName(rkAgentVO.getEnterpriseScale(), "enterpriseSize"));
            rkAgentVO.setIsGeneralTaxpayer(StrUtil.equals((CharSequence)rkAgentVO.getIsGeneralTaxpayer(), (CharSequence)"1") ? "\u662f" : "\u5426");
            rkAgentVO.setSharingLevel(this.baseDataUtil.getDictName(rkAgentVO.getSharingLevel(), "sharingLevel"));
            rkAgentVO.setResourceRelationship(this.baseDataUtil.getDictName(rkAgentVO.getResourceRelationship(), "resourceRelationship"));
            rkAgentVO.setPartnership(this.baseDataUtil.getDictName(rkAgentVO.getPartnership(), "partnership"));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkAgentPaginationExportModel.getSelectKey()) ? rkAgentPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block62: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u540d\u79f0", (Object)"name"));
                        continue block62;
                    }
                    case "productDesc": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u63cf\u8ff0", (Object)"productDesc"));
                        continue block62;
                    }
                    case "contact": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba", (Object)"contact"));
                        continue block62;
                    }
                    case "contactNo": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u7535\u8bdd", (Object)"contactNo"));
                        continue block62;
                    }
                    case "address": {
                        entitys.add(new ExcelExportEntity("\u5730\u5740", (Object)"address"));
                        continue block62;
                    }
                    case "type": {
                        entitys.add(new ExcelExportEntity("\u7c7b\u578b", (Object)"type"));
                        continue block62;
                    }
                    case "region": {
                        entitys.add(new ExcelExportEntity("\u5927\u533a", (Object)"region"));
                        continue block62;
                    }
                    case "agentProduct": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1", (Object)"agentProduct"));
                        continue block62;
                    }
                    case "companyId": {
                        entitys.add(new ExcelExportEntity("\u516c\u53f8", (Object)"companyId"));
                        continue block62;
                    }
                    case "saleId": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u4eba\u5458", (Object)"saleId"));
                        continue block62;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u6dfb\u52a0\u4eba", (Object)"creatorUserId"));
                        continue block62;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u6dfb\u52a0\u65f6\u95f4", (Object)"creatorTime"));
                        continue block62;
                    }
                    case "socialCreditCode": {
                        entitys.add(new ExcelExportEntity("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801", (Object)"socialCreditCode"));
                        continue block62;
                    }
                    case "channelType": {
                        entitys.add(new ExcelExportEntity("\u6e20\u9053\u7c7b\u578b", (Object)"channelType"));
                        continue block62;
                    }
                    case "legalRepresentative": {
                        entitys.add(new ExcelExportEntity("\u6cd5\u5b9a\u4ee3\u8868\u4eba", (Object)"legalRepresentative"));
                        continue block62;
                    }
                    case "enterpriseScale": {
                        entitys.add(new ExcelExportEntity("\u4f01\u4e1a\u89c4\u6a21", (Object)"enterpriseScale"));
                        continue block62;
                    }
                    case "isGeneralTaxpayer": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u4e00\u822c\u7eb3\u7a0e\u4eba", (Object)"isGeneralTaxpayer"));
                        continue block62;
                    }
                    case "registeredCapital": {
                        entitys.add(new ExcelExportEntity("\u6ce8\u518c\u8d44\u91d1(\u5143)", (Object)"registeredCapital"));
                        continue block62;
                    }
                    case "paidFunds": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u7f34\u8d44\u91d1(\u5143)", (Object)"paidFunds"));
                        continue block62;
                    }
                    case "businessScope": {
                        entitys.add(new ExcelExportEntity("\u8425\u4e1a\u8303\u56f4", (Object)"businessScope"));
                        continue block62;
                    }
                    case "cooperationContractAmount": {
                        entitys.add(new ExcelExportEntity("\u5df2\u5408\u4f5c\u5408\u540c\u91d1\u989d", (Object)"cooperationContractAmount"));
                        continue block62;
                    }
                    case "cooperationYear": {
                        entitys.add(new ExcelExportEntity("\u5df2\u5408\u4f5c\u5e74\u4efd", (Object)"cooperationYear"));
                        continue block62;
                    }
                    case "sharingLevel": {
                        entitys.add(new ExcelExportEntity("\u5171\u4eab\u7ea7\u522b", (Object)"sharingLevel"));
                        continue block62;
                    }
                    case "resourceRelationship": {
                        entitys.add(new ExcelExportEntity("\u8d44\u6e90\u5173\u7cfb", (Object)"resourceRelationship"));
                        continue block62;
                    }
                    case "partnership": {
                        entitys.add(new ExcelExportEntity("\u4f19\u4f34\u5173\u7cfb", (Object)"partnership"));
                        continue block62;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkAgentInfoVO> info(@PathVariable(value="id") String id) {
        RkAgentEntity entity = this.rkAgentService.getInfoHandleRegionDate(id);
        RkAgentInfoVO vo = (RkAgentInfoVO)JsonUtil.getJsonToBean((Object)entity, RkAgentInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkAgentInfoVO> detailInfo(@PathVariable(value="id") String id) {
        List<String> ids;
        List organizeEntity;
        RkAgentEntity entity = this.rkAgentService.getInfo(id);
        RkAgentInfoVO vo = (RkAgentInfoVO)JsonUtil.getJsonToBean((Object)entity, RkAgentInfoVO.class);
        vo.setType(this.baseDataUtil.getDictName(vo.getType(), Constants.AGENT_TYPE_DICT_ID));
        vo.setRegion(this.baseDataUtil.provinceData(vo.getRegion()));
        vo.setEnterpriseScaleId(vo.getEnterpriseScale());
        vo.setEnterpriseScale(this.baseDataUtil.getDictName(entity.getEnterpriseScale(), "enterpriseSize"));
        StringBuffer stringBuffer = new StringBuffer();
        if (StringUtils.isNotEmpty((String)vo.getAgentProduct()) && !vo.getAgentProduct().equals("null")) {
            List<String> stringList = Arrays.asList(vo.getAgentProduct().split(","));
            for (String s : stringList) {
                CrmProductCategoryEntity categoryServiceInfo = this.crmProductCategoryService.getInfo(s);
                stringBuffer.append(categoryServiceInfo.getName() + ",");
            }
            vo.setAgentProduct(stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(",")).toString());
        }
        vo.setSaleId(this.baseDataUtil.userSelectValues(vo.getSaleId()));
        vo.setChannelType(this.baseDataUtil.getDictName(vo.getChannelType(), "channelType"));
        if (!StrUtil.isBlank((CharSequence)vo.getCompanyId()) && ObjectUtil.isNotEmpty((Object)(organizeEntity = this.organizeService.listByIds(ids = Arrays.asList(vo.getCompanyId().split(",")))))) {
            vo.setCompanyId(organizeEntity.stream().map(OrganizeEntity::getShortName).collect(Collectors.joining(",")));
        }
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkAgentUpForm rkAgentUpForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            RkAgentEntity entity = this.rkAgentService.getInfo(id);
            if (entity != null) {
                RkAgentEntity subentity;
                String companyId = rkAgentUpForm.getCompanyId();
                if (StrUtil.isBlank((CharSequence)companyId)) {
                    companyId = userInfo.getOrganizeId();
                    rkAgentUpForm.setCompanyId(companyId);
                }
                if (this.rkAgentService.checkExistNameAndCompanyId(rkAgentUpForm.getName(), companyId, id)) {
                    return ActionResult.fail((String)"\u540d\u79f0\u4e0d\u80fd\u91cd\u590d,\u8bf7\u8054\u7cfb\u6e20\u9053\u5c0f\u7ec4");
                }
                if (StringUtils.isNotEmpty((String)rkAgentUpForm.getAgentProduct())) {
                    rkAgentUpForm.setAgentProduct(rkAgentUpForm.getAgentProduct().replaceAll("\"", "").replaceAll("]", "").replace("[", ""));
                }
                if (!ObjectUtil.isEmpty((Object)(subentity = (RkAgentEntity)JsonUtil.getJsonToBean((Object)rkAgentUpForm, RkAgentEntity.class)).getName())) {
                    subentity.setPinyin(PinyinUtil.getFirstLetter((String)subentity.getName(), (String)"").toUpperCase());
                }
                RkAgentManagerEntity rkAgentManagerEntity = this.rkAgentManagerService.saveOrUpdateData(subentity);
                subentity.setParentId(rkAgentManagerEntity.getId());
                this.rkAgentService.update(id, subentity);
                if (StrUtil.isNotEmpty((CharSequence)rkAgentUpForm.getContact()) || StrUtil.isNotEmpty((CharSequence)rkAgentUpForm.getContactNo())) {
                    this.updateContact(rkAgentUpForm, entity);
                }
                return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    private boolean updateContact(RkAgentUpForm rkAgentUpForm, RkAgentEntity entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCustomerContactsEntity::getAgentId, (Object)entity.getId());
        List list = this.crmCustomerContactsService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return true;
        }
        return this.saveContact((RkAgentEntity)JsonUtil.getJsonToBean((Object)rkAgentUpForm, RkAgentEntity.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            RkAgentEntity entity = this.rkAgentService.getInfo(id);
            if (entity != null) {
                List<RkContractEntity> listByAgentId = this.contractService.getListByAgentId(id);
                if (CollectionUtil.isNotEmpty(listByAgentId)) {
                    return ActionResult.fail((String)"\u6b64\u4e2d\u95f4\u5546\u5df2\u5173\u8054\u5408\u540c\uff0c\u4e0d\u80fd\u5220\u9664");
                }
                List<RkContractVerifyEntity> listByAgentId1 = this.rkContractVerifyService.getListByAgentId(id);
                if (CollectionUtil.isNotEmpty(listByAgentId1)) {
                    return ActionResult.fail((String)"\u6b64\u4e2d\u95f4\u5546\u5df2\u5173\u8054\u5408\u540c\uff0c\u4e0d\u80fd\u5220\u9664");
                }
                this.rkAgentService.delete(entity);
            }
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
    }

    @PostMapping(value={"/getAgentListByParent"})
    public ActionResult getAgentListByParent(@RequestBody RkAgentPagination rkAgentPagination) {
        List<RkAgentEntity> list = this.rkAgentService.getList(rkAgentPagination);
        List listVO = JsonUtil.getJsonToList(list, RkAgentListVO.class);
        for (RkAgentListVO rkAgentVO : listVO) {
            List<String> ids;
            List organizeEntity;
            rkAgentVO.setType(this.baseDataUtil.getDictName(rkAgentVO.getType(), Constants.AGENT_TYPE_DICT_ID));
            rkAgentVO.setRegion(this.baseDataUtil.provinceData(rkAgentVO.getRegion()));
            rkAgentVO.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(rkAgentVO.getCreatorUserId()));
            rkAgentVO.setEnterpriseScale(this.baseDataUtil.getDictName(rkAgentVO.getEnterpriseScale(), "enterpriseSize"));
            if (StringUtils.isNotEmpty((String)rkAgentVO.getAgentProduct()) && !rkAgentVO.getAgentProduct().equals("null")) {
                StringBuffer stringBuffer = new StringBuffer();
                List<String> stringList = Arrays.asList(rkAgentVO.getAgentProduct().split(","));
                for (String s : stringList) {
                    CrmProductCategoryEntity categoryServiceInfo = this.crmProductCategoryService.getInfo(s);
                    if (!ObjectUtil.isNotNull((Object)categoryServiceInfo)) continue;
                    stringBuffer.append(categoryServiceInfo.getName() + ",");
                }
                if (!StrUtil.isBlank((CharSequence)stringBuffer.toString()) && stringBuffer.length() != 0) {
                    rkAgentVO.setAgentProduct(stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(",")).toString());
                }
            }
            rkAgentVO.setSaleId(this.baseDataUtil.userSelectValues(rkAgentVO.getSaleId()));
            rkAgentVO.setChannelType(this.baseDataUtil.getDictName(rkAgentVO.getChannelType(), "channelType"));
            if (StrUtil.isBlank((CharSequence)rkAgentVO.getCompanyId()) || !ObjectUtil.isNotEmpty((Object)(organizeEntity = this.organizeService.listByIds(ids = Arrays.asList(rkAgentVO.getCompanyId().split(",")))))) continue;
            rkAgentVO.setCompanyId(organizeEntity.stream().map(OrganizeEntity::getShortName).collect(Collectors.joining(",")));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkAgentPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }
}

