/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkAgentManagerEntity;
import com.bringspring.contract.model.rkAgentManager.RkAgentManagerCrForm;
import com.bringspring.contract.model.rkAgentManager.RkAgentManagerInfoVO;
import com.bringspring.contract.model.rkAgentManager.RkAgentManagerListVO;
import com.bringspring.contract.model.rkAgentManager.RkAgentManagerPagination;
import com.bringspring.contract.model.rkAgentManager.RkAgentManagerPaginationExportModel;
import com.bringspring.contract.model.rkAgentManager.RkAgentManagerUpForm;
import com.bringspring.contract.service.RkAgentManagerService;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.service.CrmCustomerContactsService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5408\u4f5c\u4f19\u4f34\u6e20\u9053\u7ba1\u7406"}, value="contract")
@RequestMapping(value={"/api/contract/RkAgentManager"})
public class RkAgentManagerController {
    private static final Logger log = LoggerFactory.getLogger(RkAgentManagerController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkAgentManagerService rkAgentManagerService;
    @Autowired
    private CrmCustomerContactsService crmCustomerContactsService;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkAgentManagerPagination rkAgentManagerPagination) throws IOException {
        List<RkAgentManagerEntity> list = this.rkAgentManagerService.getList(rkAgentManagerPagination);
        for (RkAgentManagerEntity rkAgentManagerEntity : list) {
            rkAgentManagerEntity.setEnterpriseScale(this.baseDataUtil.getDictName(rkAgentManagerEntity.getEnterpriseScale(), "542983706814469381"));
            rkAgentManagerEntity.setIsGeneralTaxpayer(this.baseDataUtil.getDictName(rkAgentManagerEntity.getIsGeneralTaxpayer(), "401373862127762245"));
        }
        List listVO = JsonUtil.getJsonToList(list, RkAgentManagerListVO.class);
        for (RkAgentManagerListVO rkAgentManagerVO : listVO) {
            List<RkAgentEntity> agentList = this.rkAgentService.getManagerListByParentId(rkAgentManagerVO.getId());
            for (RkAgentEntity rkAgentVO : agentList) {
                List<String> ids;
                List organizeEntity;
                rkAgentVO.setRegion(this.baseDataUtil.provinceData(rkAgentVO.getRegion()));
                if (StringUtils.isNotEmpty((String)rkAgentVO.getAgentProduct()) && !rkAgentVO.getAgentProduct().equals("null")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    List<String> stringList = Arrays.asList(rkAgentVO.getAgentProduct().split(","));
                    for (String s : stringList) {
                        CrmProductCategoryEntity categoryServiceInfo = this.crmProductCategoryService.getInfo(s);
                        if (!ObjectUtil.isNotNull((Object)categoryServiceInfo)) continue;
                        stringBuffer.append(categoryServiceInfo.getName() + ",");
                    }
                    if (!StrUtil.isBlank((CharSequence)stringBuffer.toString()) && stringBuffer.length() != 0) {
                        rkAgentVO.setAgentProduct(stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(",")).toString());
                    }
                }
                rkAgentVO.setSaleId(this.baseDataUtil.userSelectValues(rkAgentVO.getSaleId()));
                rkAgentVO.setChannelType(this.baseDataUtil.getDictName(rkAgentVO.getChannelType(), "channelType"));
                if (StrUtil.isBlank((CharSequence)rkAgentVO.getCompanyId()) || !ObjectUtil.isNotEmpty((Object)(organizeEntity = this.organizeService.listByIds(ids = Arrays.asList(rkAgentVO.getCompanyId().split(",")))))) continue;
                rkAgentVO.setCompanyId(organizeEntity.stream().map(OrganizeEntity::getShortName).collect(Collectors.joining(",")));
            }
            rkAgentManagerVO.setAgentProduct(agentList.stream().map(RkAgentEntity::getAgentProduct).distinct().collect(Collectors.joining(",")));
            rkAgentManagerVO.setChannelType(agentList.stream().map(RkAgentEntity::getChannelType).distinct().collect(Collectors.joining(",")));
            rkAgentManagerVO.setSaleId(agentList.stream().map(RkAgentEntity::getSaleId).distinct().collect(Collectors.joining(",")));
            rkAgentManagerVO.setCompanyId(agentList.stream().map(RkAgentEntity::getCompanyId).distinct().collect(Collectors.joining(",")));
            rkAgentManagerVO.setRegion(agentList.stream().map(RkAgentEntity::getRegion).distinct().collect(Collectors.joining(",")));
            rkAgentManagerVO.setAgentProduct(StrUtil.isEmpty((CharSequence)rkAgentManagerVO.getAgentProduct()) ? "" : rkAgentManagerVO.getAgentProduct().replace("null", ""));
            rkAgentManagerVO.setChannelType(StrUtil.isEmpty((CharSequence)rkAgentManagerVO.getChannelType()) ? "" : rkAgentManagerVO.getChannelType().replace("null", ""));
            rkAgentManagerVO.setSaleId(StrUtil.isEmpty((CharSequence)rkAgentManagerVO.getSaleId()) ? "" : rkAgentManagerVO.getSaleId().replace("null", ""));
            rkAgentManagerVO.setCompanyId(StrUtil.isEmpty((CharSequence)rkAgentManagerVO.getCompanyId()) ? "" : rkAgentManagerVO.getCompanyId().replace("null", ""));
            rkAgentManagerVO.setRegion(StrUtil.isEmpty((CharSequence)rkAgentManagerVO.getRegion()) ? "" : rkAgentManagerVO.getRegion().replace("null", ""));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkAgentManagerPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid RkAgentManagerCrForm rkAgentManagerCrForm) throws DataException {
        if (this.rkAgentManagerService.checkExistName(rkAgentManagerCrForm.getName())) {
            return ActionResult.fail((String)"\u540d\u79f0\u4e0d\u80fd\u91cd\u590d,\u8bf7\u786e\u8ba4");
        }
        this.rkAgentManagerService.create(rkAgentManagerCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkAgentManagerPaginationExportModel rkAgentManagerPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)rkAgentManagerPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkAgentManagerPagination rkAgentManagerPagination = (RkAgentManagerPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkAgentManagerPaginationExportModel), RkAgentManagerPagination.class));
        List<RkAgentManagerEntity> list = this.rkAgentManagerService.getTypeList(rkAgentManagerPagination, rkAgentManagerPaginationExportModel.getDataType());
        for (RkAgentManagerEntity rkAgentManagerEntity : list) {
            rkAgentManagerEntity.setEnterpriseScale(this.baseDataUtil.getDictName(rkAgentManagerEntity.getEnterpriseScale(), "542983706814469381"));
            rkAgentManagerEntity.setIsGeneralTaxpayer(this.baseDataUtil.getDictName(rkAgentManagerEntity.getIsGeneralTaxpayer(), "401373862127762245"));
        }
        List listVO = JsonUtil.getJsonToList(list, RkAgentManagerListVO.class);
        for (RkAgentManagerListVO rkAgentManagerListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)rkAgentManagerPaginationExportModel.getSelectKey()) ? rkAgentManagerPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block36: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u4f01\u4e1a\u540d\u79f0", (Object)"name"));
                        continue block36;
                    }
                    case "pinyin": {
                        entitys.add(new ExcelExportEntity("\u62fc\u97f3", (Object)"pinyin"));
                        continue block36;
                    }
                    case "address": {
                        entitys.add(new ExcelExportEntity("\u5730\u5740", (Object)"address"));
                        continue block36;
                    }
                    case "socialCreditCode": {
                        entitys.add(new ExcelExportEntity("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801", (Object)"socialCreditCode"));
                        continue block36;
                    }
                    case "legalRepresentative": {
                        entitys.add(new ExcelExportEntity("\u6cd5\u5b9a\u4ee3\u8868\u4eba", (Object)"legalRepresentative"));
                        continue block36;
                    }
                    case "registeredCapital": {
                        entitys.add(new ExcelExportEntity("\u6ce8\u518c\u8d44\u91d1(\u5143)", (Object)"registeredCapital"));
                        continue block36;
                    }
                    case "paidFunds": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u7f34\u8d44\u91d1(\u5143)", (Object)"paidFunds"));
                        continue block36;
                    }
                    case "businessSituation": {
                        entitys.add(new ExcelExportEntity("\u4f01\u4e1a\u72b6\u51b5", (Object)"businessSituation"));
                        continue block36;
                    }
                    case "enterpriseScale": {
                        entitys.add(new ExcelExportEntity("\u4f01\u4e1a\u89c4\u6a21", (Object)"enterpriseScale"));
                        continue block36;
                    }
                    case "isGeneralTaxpayer": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u4e00\u822c\u7eb3\u7a0e\u4eba", (Object)"isGeneralTaxpayer"));
                        continue block36;
                    }
                    case "businessScope": {
                        entitys.add(new ExcelExportEntity("\u8425\u4e1a\u8303\u56f4", (Object)"businessScope"));
                        continue block36;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65e5\u671f", (Object)"creatorTime"));
                        continue block36;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkAgentManagerInfoVO> info(@PathVariable(value="id") String id) {
        RkAgentManagerEntity entity = this.rkAgentManagerService.getInfo(id);
        RkAgentManagerInfoVO vo = (RkAgentManagerInfoVO)JsonUtil.getJsonToBean((Object)entity, RkAgentManagerInfoVO.class);
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkAgentManagerInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkAgentManagerEntity entity = this.rkAgentManagerService.getInfo(id);
        RkAgentManagerInfoVO vo = (RkAgentManagerInfoVO)JsonUtil.getJsonToBean((Object)entity, RkAgentManagerInfoVO.class);
        vo.setEnterpriseScale(this.baseDataUtil.getDictName(vo.getEnterpriseScale(), "enterpriseSize"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkAgentManagerUpForm rkAgentManagerUpForm) throws DataException {
        if (this.rkAgentManagerService.checkExistName(rkAgentManagerUpForm.getName(), id)) {
            return ActionResult.fail((String)"\u540d\u79f0\u4e0d\u80fd\u91cd\u590d,\u8bf7\u786e\u8ba4");
        }
        this.rkAgentManagerService.update(id, rkAgentManagerUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkAgentManagerEntity entity = this.rkAgentManagerService.getInfo(id);
        if (entity != null) {
            this.rkAgentManagerService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"countAgentPanorama/{id}"})
    public ActionResult countAgentPanorama(@PathVariable(value="id") String id, String menuId) {
        HashMap map = MapUtil.newHashMap();
        long contactCount = this.crmCustomerContactsService.countByAgentrId(id, "agent");
        long agentCount = this.rkAgentService.agentCountByParent(id);
        map.put("contactCount", contactCount);
        map.put("agentCount", agentCount);
        return ActionResult.success((Object)map);
    }
}

