/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkProjectPlanDetailEntity;
import com.bringspring.contract.mapper.RkAttachmentMapper;
import com.bringspring.contract.model.rkattachment.RkAttachmentCrForm;
import com.bringspring.contract.model.rkattachment.RkAttachmentFileListVO;
import com.bringspring.contract.model.rkattachment.RkAttachmentInfoVO;
import com.bringspring.contract.model.rkattachment.RkAttachmentListVO;
import com.bringspring.contract.model.rkattachment.RkAttachmentPagination;
import com.bringspring.contract.model.rkattachment.RkAttachmentUpForm;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectUpForm;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkProjectPlanDetailService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9644\u4ef6"}, value="contract")
@RequestMapping(value={"/api/contract/RkAttachment"})
public class RkAttachmentController {
    private static final Logger log = LoggerFactory.getLogger(RkAttachmentController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private RkAttachmentMapper rkAttachmentMapper;
    @Autowired
    private RkContractProjectService contractProjectService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkProjectPlanDetailService rkProjectPlanDetailService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkAttachmentPagination rkAttachmentPagination) throws IOException {
        List<RkAttachmentEntity> list = this.rkAttachmentService.getList(rkAttachmentPagination);
        for (RkAttachmentEntity rkAttachmentEntity : list) {
            rkAttachmentEntity.setUrl(this.baseDataUtil.getFileNameInJson(rkAttachmentEntity.getUrl()));
        }
        List listVO = JsonUtil.getJsonToList(list, RkAttachmentListVO.class);
        for (RkAttachmentListVO rkAttachmentVO : listVO) {
            rkAttachmentVO.setCreatorUserId(this.baseDataUtil.userSelectValue(rkAttachmentVO.getCreatorUserId()));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkAttachmentPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @GetMapping(value={"/getListByContractIdAndFileType/{contractId}/{fileType}"})
    public ActionResult getListByContractIdAndType(@PathVariable(value="contractId") String contractId, @PathVariable(value="fileType") String fileType) {
        return ActionResult.success(this.rkAttachmentService.getListByContractIdAndFileType(contractId, fileType));
    }

    @GetMapping(value={"/getListByContractIdAndFileType/{contractId}"})
    public ActionResult getListByContractId(@PathVariable(value="contractId") String contractId) {
        List<RkAttachmentEntity> listByContractId = this.rkAttachmentService.getListByContractId(contractId);
        return ActionResult.success(listByContractId);
    }

    @GetMapping(value={"/getListByContractIdAndFileTypeNew/{contractId}"})
    public ActionResult getListByContractIdNew(@PathVariable(value="contractId") String contractId) {
        List<RkAttachmentEntity> listByContractId = this.rkAttachmentService.getListByContractId(contractId);
        listByContractId.stream().forEach(entity -> {
            RkAttachmentInfoVO jsonToBean = (RkAttachmentInfoVO)JsonUtil.getJsonToBean((Object)entity, RkAttachmentInfoVO.class);
            entity.setAttachmentEntityList(CollectionUtil.list((boolean)false, (Object[])new RkAttachmentInfoVO[]{jsonToBean}));
        });
        return ActionResult.success(listByContractId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkAttachmentCrForm rkAttachmentCrForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            RkAttachmentEntity entity = (RkAttachmentEntity)JsonUtil.getJsonToBean((Object)rkAttachmentCrForm, RkAttachmentEntity.class);
            entity.setId(mainId);
            this.rkAttachmentService.save(entity);
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping(value={"createBatch"})
    @DSTransactional
    public ActionResult createBatch(@RequestBody @Valid List<RkAttachmentCrForm> list) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            List entityList = JsonUtil.getJsonToList(list, RkAttachmentEntity.class);
            entityList.stream().forEach(entity -> entity.setId(RandomUtil.uuId()));
            this.rkAttachmentService.saveBatch(entityList);
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping(value={"updateProjectBatch"})
    @DSTransactional
    public ActionResult updateProjectBatch(@RequestBody @Valid List<RkAttachmentCrForm> list) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            List entityList = JsonUtil.getJsonToList(list, RkAttachmentEntity.class);
            for (RkAttachmentEntity entity2 : entityList) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.lambda().and(x -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(RkAttachmentEntity::getContractId, (Object)entity2.getContractId())).or()).eq(RkAttachmentEntity::getInvoiceId, (Object)entity2.getInvoiceId())).or()).eq(RkAttachmentEntity::getPlanId, (Object)entity2.getPlanId())).or()).eq(RkAttachmentEntity::getProjectId, (Object)entity2.getProjectId());
                });
                List oldList = this.rkAttachmentService.list((Wrapper)queryWrapper);
                if (!CollectionUtil.isNotEmpty((Collection)oldList)) continue;
                this.rkAttachmentService.removeBatchByIds(oldList);
            }
            entityList.stream().forEach(entity -> entity.setId(RandomUtil.uuId()));
            this.rkAttachmentService.saveBatch(entityList);
            return ActionResult.success((String)"\u4fee\u6539\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping(value={"addProjectBatch"})
    @DSTransactional
    public ActionResult addProjectBatch(@RequestBody @Valid List<RkAttachmentCrForm> list) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            List entityList = JsonUtil.getJsonToList(list, RkAttachmentEntity.class);
            if (CollectionUtil.isNotEmpty((Collection)entityList)) {
                entityList.stream().forEach(entity -> entity.setId(RandomUtil.uuId()));
                this.rkAttachmentService.saveBatch(entityList);
            }
            return ActionResult.success((String)"\u4e0a\u4f20\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping(value={"changeProjectBatch"})
    @DSTransactional
    public ActionResult changeProjectBatch(@RequestBody RkContractProjectUpForm upForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            if (StringUtils.isNotEmpty((String)upForm.getId())) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.lambda().eq(RkAttachmentEntity::getProjectId, (Object)upForm.getId());
                this.rkAttachmentService.remove((Wrapper)queryWrapper);
                if (CollectionUtil.isNotEmpty(upForm.getAttachmentList())) {
                    List entityList = JsonUtil.getJsonToList(upForm.getAttachmentList(), RkAttachmentEntity.class);
                    entityList.stream().forEach(entity -> {
                        entity.setId(RandomUtil.uuId());
                        entity.setProjectId(upForm.getId());
                        if (StringUtils.isEmpty((String)entity.getFileType())) {
                            entity.setFileType(AttachmentTypeEnum.PROJECT_TYPE.getType());
                        }
                    });
                    this.rkAttachmentService.saveBatch(entityList);
                }
            }
            return ActionResult.success((String)"\u64cd\u4f5c\u6210\u529f");
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkAttachmentInfoVO> info(@PathVariable(value="id") String id) {
        RkAttachmentEntity entity = this.rkAttachmentService.getInfo(id);
        RkAttachmentInfoVO vo = (RkAttachmentInfoVO)JsonUtil.getJsonToBean((Object)entity, RkAttachmentInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkAttachmentInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkAttachmentEntity entity = this.rkAttachmentService.getInfo(id);
        RkAttachmentInfoVO vo = (RkAttachmentInfoVO)JsonUtil.getJsonToBean((Object)entity, RkAttachmentInfoVO.class);
        vo.setUrl(this.baseDataUtil.getFileNameInJson(vo.getUrl()));
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkAttachmentUpForm rkAttachmentUpForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            RkAttachmentEntity entity = this.rkAttachmentService.getInfo(id);
            if (entity != null) {
                RkAttachmentEntity subentity = (RkAttachmentEntity)JsonUtil.getJsonToBean((Object)rkAttachmentUpForm, RkAttachmentEntity.class);
                this.rkAttachmentService.update(id, subentity);
                return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            RkAttachmentEntity entity = this.rkAttachmentService.getInfo(id);
            if (entity != null) {
                UpdateWrapper updateWrapper;
                List<RkAttachmentEntity> attachmentEntityList;
                List<RkAttachmentEntity> listByProjectId;
                List<RkAttachmentEntity> listByObjId;
                RkProjectPlanDetailEntity byId;
                this.rkAttachmentService.delete(entity);
                if (StrUtil.equals((CharSequence)entity.getFileType(), (CharSequence)"projectPlan") && ObjectUtil.isNotNull((Object)(byId = (RkProjectPlanDetailEntity)this.rkProjectPlanDetailService.getById((Serializable)((Object)entity.getObjId())))) && CollectionUtil.isEmpty(listByObjId = this.rkAttachmentService.getListByObjId(entity.getObjId()))) {
                    byId.setIsUploadDeliverables(0);
                    this.rkProjectPlanDetailService.updateById(byId);
                }
                if (!ObjectUtil.isEmpty((Object)entity.getProjectId()) && CollectionUtil.isEmpty(listByProjectId = this.rkAttachmentService.getListByProjectId(entity.getProjectId()))) {
                    this.contractProjectService.updateIsUploadAcceptFile(entity.getProjectId(), 0);
                }
                if (StringUtils.isNotEmpty((String)entity.getContractId()) && AttachmentTypeEnum.CONTRACT_TYPE.getType().equals(entity.getFileType())) {
                    attachmentEntityList = this.rkAttachmentService.getListByContractIdAndFileType(entity.getContractId(), AttachmentTypeEnum.CONTRACT_TYPE.getType());
                    if (CollectionUtil.isEmpty(attachmentEntityList)) {
                        updateWrapper = new UpdateWrapper();
                        updateWrapper.lambda().set(RkContractEntity::getIsHaveAttachment, (Object)0);
                        updateWrapper.eq((Object)"id", (Object)entity.getContractId());
                        this.rkContractService.update((Wrapper)updateWrapper);
                    }
                } else if (StringUtils.isNotEmpty((String)entity.getContractId()) && AttachmentTypeEnum.DOUBLE_SIGNED_CONTRACT_TYPE.getType().equals(entity.getFileType()) && CollectionUtil.isEmpty(attachmentEntityList = this.rkAttachmentService.getListByContractIdAndFileType(entity.getContractId(), AttachmentTypeEnum.DOUBLE_SIGNED_CONTRACT_TYPE.getType()))) {
                    updateWrapper = new UpdateWrapper();
                    updateWrapper.lambda().set(RkContractEntity::getDoubleSignedAttachment, (Object)0);
                    updateWrapper.eq((Object)"id", (Object)entity.getContractId());
                    this.rkContractService.update((Wrapper)updateWrapper);
                }
            }
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
    }

    @GetMapping(value={"/getListByProjectId/{projectId}"})
    public ActionResult getListByProjectId(@PathVariable(value="projectId") String projectId) {
        List<RkAttachmentEntity> listByProjectId = this.rkAttachmentService.getListByProjectId(projectId);
        listByProjectId.stream().forEach(entity -> {
            RkAttachmentInfoVO jsonToBean = (RkAttachmentInfoVO)JsonUtil.getJsonToBean((Object)entity, RkAttachmentInfoVO.class);
            entity.setAttachmentEntityList(CollectionUtil.list((boolean)false, (Object[])new RkAttachmentInfoVO[]{jsonToBean}));
        });
        List jsonToList = JsonUtil.getJsonToList(listByProjectId, RkAttachmentListVO.class);
        return ActionResult.success((Object)jsonToList);
    }

    @GetMapping(value={"/getListByProjectType/{projectId}"})
    public ActionResult getListByProjectType(@PathVariable(value="projectId") String projectId) {
        List<RkAttachmentFileListVO> listByProjectId = this.rkAttachmentMapper.getListByProjectIdType(projectId);
        for (RkAttachmentFileListVO vo : listByProjectId) {
            vo.setFileTypeName(this.baseDataUtil.getDictName(vo.getFileType(), "projectAccessoryType") + "\u6587\u4ef6");
            BigDecimal two11 = new BigDecimal(vo.getFileSize() / 1024.0);
            double three = two11.setScale(2, 4).doubleValue();
            vo.setFileSize(three);
        }
        return ActionResult.success(listByProjectId);
    }

    @GetMapping(value={"/getListByProjectTypeInit/{projectId}/{fileType}"})
    public ActionResult getListByProjectTypeInit(@PathVariable(value="projectId") String projectId, @PathVariable(value="fileType") String fileType) {
        List<RkAttachmentEntity> listByProjectId = this.rkAttachmentService.getListByProjectIdTypeInit(fileType, projectId);
        listByProjectId.stream().forEach(entity -> {
            RkAttachmentInfoVO jsonToBean = (RkAttachmentInfoVO)JsonUtil.getJsonToBean((Object)entity, RkAttachmentInfoVO.class);
            entity.setAttachmentEntityList(CollectionUtil.list((boolean)false, (Object[])new RkAttachmentInfoVO[]{jsonToBean}));
        });
        List jsonToList = JsonUtil.getJsonToList(listByProjectId, RkAttachmentListVO.class);
        for (RkAttachmentListVO vo : jsonToList) {
            vo.setFileType(this.baseDataUtil.getDictName(vo.getFileType(), "projectAccessoryType"));
            vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        }
        return ActionResult.success((Object)jsonToList);
    }

    @ApiOperation(value="\u538b\u7f29\u6587\u4ef6\u5939\u5e76\u4e0b\u8f7d")
    @PostMapping(value={"/toZip"})
    public ActionResult toZip(@RequestBody RkAttachmentFileListVO vo) {
        DownloadVO allDocumentByParentId = this.rkAttachmentService.getAllByProjectId(vo);
        return ActionResult.success((Object)allDocumentByParentId);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e0b\u8f7d\u6587\u4ef6\u94fe\u63a5")
    @PostMapping(value={"/Download/{id}"})
    public ActionResult<DownloadVO> download(@PathVariable(value="id") String id) {
        UserInfo userInfo = this.userProvider.get();
        RkAttachmentEntity entity = this.rkAttachmentService.getInfo(id);
        if (entity != null) {
            String result;
            int lastIndex;
            if (StringUtils.isNull((Object)entity.getSecondFilePath()) && (lastIndex = (result = entity.getUrl().replaceAll("^\\D+", "")).lastIndexOf(Character.toString('/'))) != -1) {
                entity.setSecondFilePath(result.substring(0, lastIndex) + "/");
            }
            String name = entity.getSecondFilePath() + entity.getFileId();
            String fileName = userInfo.getId() + "#" + name + "#document";
            DownloadVO vo = DownloadVO.builder().name(entity.getName()).url(UploaderUtil.uploaderFile((String)fileName)).build();
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)MsgCode.FA018.get());
    }

    @GetMapping(value={"/getListByObjId/{objId}"})
    public ActionResult getListByObjId(@PathVariable(value="objId") String objId) {
        List list = CollectionUtil.list((boolean)false, (Object[])objId.split(","));
        List<RkAttachmentEntity> listByProjectId = this.rkAttachmentService.getListByObjIdIn(list);
        listByProjectId.stream().forEach(entity -> {
            RkAttachmentInfoVO jsonToBean = (RkAttachmentInfoVO)JsonUtil.getJsonToBean((Object)entity, RkAttachmentInfoVO.class);
            entity.setAttachmentEntityList(CollectionUtil.list((boolean)false, (Object[])new RkAttachmentInfoVO[]{jsonToBean}));
        });
        List jsonToList = JsonUtil.getJsonToList(listByProjectId, RkAttachmentListVO.class);
        return ActionResult.success((Object)jsonToList);
    }
}

