/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractAssetsLedgerEntity;
import com.bringspring.contract.model.contract_assets_ledger.RkContractAssetsLedgerCrForm;
import com.bringspring.contract.model.contract_assets_ledger.RkContractAssetsLedgerInfoVO;
import com.bringspring.contract.model.contract_assets_ledger.RkContractAssetsLedgerPagination;
import com.bringspring.contract.model.contract_assets_ledger.RkContractAssetsLedgerPaginationExportModel;
import com.bringspring.contract.model.contract_assets_ledger.RkContractAssetsLedgerUpForm;
import com.bringspring.contract.model.rkcontract.RkContractListVO;
import com.bringspring.contract.model.rkcontract.RkContractPagination;
import com.bringspring.contract.service.RkcontrActassetsLedgerService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.utils.ParamAddress;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5408\u540c\u8d44\u4ea7\u53f0\u8d26"}, value="rkContractAssetsLedger")
@RequestMapping(value={"/api/contract/rkContractAssetsledger/"})
public class RkContractAssetsLedgerController {
    private static final Logger log = LoggerFactory.getLogger(RkContractAssetsLedgerController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RkcontrActassetsLedgerService rkcontractassetsledgerService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@ParamAddress(field="customerAddress") @RequestBody RkContractPagination rkContractPagination) throws IOException {
        List<RkContractListVO> listContractVO = this.rkcontractassetsledgerService.getRkContractAssetsLedgerList(rkContractPagination);
        List allCompanyList = this.organizeService.getAllCompanyList("");
        block0: for (RkContractListVO task : listContractVO) {
            for (OrganizeEntity company : allCompanyList) {
                if (!StringUtils.isNotEmpty((String)task.getCompanyId()) || !company.getId().equals(task.getCompanyId())) continue;
                task.setCompanyName(company.getShortName());
                continue block0;
            }
        }
        PageListVO vo = new PageListVO();
        vo.setList(listContractVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getAssetsledgerlist"})
    public ActionResult listAssetsledger(@RequestBody RkContractAssetsLedgerPagination ledgerPagination) throws IOException {
        List<RkContractAssetsLedgerInfoVO> listContractVO = this.rkcontractassetsledgerService.getRkContractAssetsLedgerInfoVO(ledgerPagination);
        List allCompanyList = this.organizeService.getAllCompanyList("");
        block0: for (RkContractAssetsLedgerInfoVO task : listContractVO) {
            for (OrganizeEntity company : allCompanyList) {
                if (!StringUtils.isNotEmpty((String)task.getCompanyId()) || !company.getId().equals(task.getCompanyId())) continue;
                task.setCompanyName(company.getShortName());
                continue block0;
            }
        }
        PageListVO vo = new PageListVO();
        vo.setList(listContractVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ledgerPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid RkContractAssetsLedgerCrForm rkcontractassetsledgerCrForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            if (ObjectUtil.isEmpty((Object)rkcontractassetsledgerCrForm.getAgentName())) {
                rkcontractassetsledgerCrForm.setAgentName(rkcontractassetsledgerCrForm.getCustomerName());
            }
            RkContractAssetsLedgerEntity entity = (RkContractAssetsLedgerEntity)JsonUtil.getJsonToBean((Object)rkcontractassetsledgerCrForm, RkContractAssetsLedgerEntity.class);
            entity.setId(mainId);
            entity.setCreatorUserId(userInfo.getUserId());
            entity.setCreatorTime(new Date());
            entity.setEnabledMark(0);
            this.rkcontractassetsledgerService.save(entity);
            RkContractAssetsLedgerEntity entityCheckAmount = new RkContractAssetsLedgerEntity();
            entityCheckAmount.setCheckAmount(rkcontractassetsledgerCrForm.getCheckAmount());
            entityCheckAmount.setContractId(rkcontractassetsledgerCrForm.getContractId());
            this.rkcontractassetsledgerService.updateContractassetsledgerCheckAmoutn(entityCheckAmount);
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractAssetsLedgerInfoVO> info(@PathVariable(value="id") String id) {
        RkContractAssetsLedgerEntity entity = this.rkcontractassetsledgerService.getInfo(id);
        RkContractAssetsLedgerInfoVO vo = (RkContractAssetsLedgerInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractAssetsLedgerInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractListVO> detailInfo(@PathVariable(value="id") String contractId) {
        RkContractListVO entity = this.rkcontractassetsledgerService.getDetailInfo(contractId);
        return ActionResult.success((Object)entity);
    }

    @PutMapping(value={"/update/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkContractAssetsLedgerUpForm rkcontractassetsledgerUpForm) throws DataException {
        RkContractAssetsLedgerEntity entity = this.rkcontractassetsledgerService.getInfo(id);
        if (entity != null) {
            UserInfo userInfo = this.userProvider.get();
            RkContractAssetsLedgerEntity subentity = (RkContractAssetsLedgerEntity)JsonUtil.getJsonToBean((Object)rkcontractassetsledgerUpForm, RkContractAssetsLedgerEntity.class);
            subentity.setLastModifyUserId(userInfo.getUserId());
            subentity.setLastModifyTime(new Date());
            this.rkcontractassetsledgerService.update(id, subentity);
            RkContractAssetsLedgerEntity entityCheckAmount = new RkContractAssetsLedgerEntity();
            entityCheckAmount.setCheckAmount(rkcontractassetsledgerUpForm.getCheckAmount());
            entityCheckAmount.setContractId(entity.getContractId());
            this.rkcontractassetsledgerService.updateContractassetsledgerCheckAmoutn(entityCheckAmount);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkContractAssetsLedgerEntity entity = this.rkcontractassetsledgerService.getInfo(id);
        if (entity != null) {
            entity.setEnabledMark(1);
            entity.setDeleteUserId(this.userProvider.get().getUserId());
            entity.setDeleteTime(new Date());
            this.rkcontractassetsledgerService.update(id, entity);
            RkContractAssetsLedgerEntity entityCheckAmount = new RkContractAssetsLedgerEntity();
            if (ObjectUtil.isNotEmpty((Object)entity.getCheckAmount()) && ObjectUtil.isNotEmpty((Object)entity.getCheckAmountMonth())) {
                entityCheckAmount.setCheckAmount(entity.getCheckAmount().subtract(entity.getCheckAmountMonth()));
            }
            entityCheckAmount.setContractId(entity.getContractId());
            this.rkcontractassetsledgerService.updateContractassetsledgerCheckAmoutn(entityCheckAmount);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u5408\u540c\u8d44\u4ea7\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload/contractAssets"})
    public ActionResult<DownloadVO> TemplateDownloadContractAssets() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u5408\u540c\u8d44\u4ea7.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u5408\u540c\u8d44\u4ea7.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5408\u540c\u53f0\u8d26\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload/contractLedger"})
    public ActionResult<DownloadVO> TemplateDownloadcontractLedger() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u5408\u540c\u53f0\u8d26.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u5408\u540c\u53f0\u8d26.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5408\u540c\u8d44\u4ea7\u5bfc\u51faExcel")
    @GetMapping(value={"/actions/Export/contractAssets"})
    public ActionResult exportContractAssets(RkContractAssetsLedgerPaginationExportModel exportModel) throws IOException {
        DownloadVO vo = this.rkcontractassetsledgerService.exportContractAssets(exportModel);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5408\u540c\u53f0\u8d26\u5bfc\u51faExcel")
    @GetMapping(value={"/actions/Export/contractLedaer"})
    public ActionResult exportContractLedaer(RkContractAssetsLedgerPaginationExportModel exportModel) throws IOException, ParseException {
        DownloadVO vo = this.rkcontractassetsledgerService.exportContractLedger(exportModel);
        return ActionResult.success((Object)vo);
    }
}

