/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractChangeEntity;
import com.bringspring.contract.model.rkcontractchange.RkContractChangeCrForm;
import com.bringspring.contract.model.rkcontractchange.RkContractChangeInfoVO;
import com.bringspring.contract.model.rkcontractchange.RkContractChangeListVO;
import com.bringspring.contract.model.rkcontractchange.RkContractChangePagination;
import com.bringspring.contract.model.rkcontractchange.RkContractChangeUpForm;
import com.bringspring.contract.service.RkContractChangeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5408\u540c\u53d8\u52a8\u8bb0\u5f55"}, value="contract")
@RequestMapping(value={"/api/contract/RkContractChange"})
public class RkContractChangeController {
    private static final Logger log = LoggerFactory.getLogger(RkContractChangeController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractChangeService rkContractChangeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkContractChangePagination rkContractChangePagination) throws IOException {
        List<RkContractChangeEntity> list = this.rkContractChangeService.getList(rkContractChangePagination);
        for (RkContractChangeEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, RkContractChangeListVO.class);
        for (RkContractChangeListVO rkContractChangeListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractChangePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkContractChangeCrForm rkContractChangeCrForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            RkContractChangeEntity entity = (RkContractChangeEntity)JsonUtil.getJsonToBean((Object)rkContractChangeCrForm, RkContractChangeEntity.class);
            entity.setId(mainId);
            this.rkContractChangeService.save(entity);
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractChangeInfoVO> info(@PathVariable(value="id") String id) {
        RkContractChangeEntity entity = this.rkContractChangeService.getInfo(id);
        RkContractChangeInfoVO vo = (RkContractChangeInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractChangeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractChangeInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkContractChangeEntity entity = this.rkContractChangeService.getInfo(id);
        RkContractChangeInfoVO vo = (RkContractChangeInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractChangeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkContractChangeUpForm rkContractChangeUpForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            RkContractChangeEntity entity = this.rkContractChangeService.getInfo(id);
            if (entity != null) {
                RkContractChangeEntity subentity = (RkContractChangeEntity)JsonUtil.getJsonToBean((Object)rkContractChangeUpForm, RkContractChangeEntity.class);
                this.rkContractChangeService.update(id, subentity);
                return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            RkContractChangeEntity entity = this.rkContractChangeService.getInfo(id);
            if (entity != null) {
                this.rkContractChangeService.delete(entity);
            }
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
    }

    @GetMapping(value={"/getChangeListByContractId/{contractId}"})
    public ActionResult getChangeListByContractId(@PathVariable(value="contractId") String contractId) {
        List<RkContractChangeEntity> changeListByContractId = this.rkContractChangeService.getChangeListByContractId(contractId);
        List jsonToList = JsonUtil.getJsonToList(changeListByContractId, RkContractChangeCrForm.class);
        for (RkContractChangeCrForm contractChangeCrForm : jsonToList) {
            contractChangeCrForm.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(contractChangeCrForm.getCreatorUserId()));
        }
        return ActionResult.success((Object)jsonToList);
    }
}

