/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractCollectionInvoiceEntity;
import com.bringspring.contract.model.rkcontractcollectioninvoice.RkContractCollectionInvoiceCrForm;
import com.bringspring.contract.model.rkcontractcollectioninvoice.RkContractCollectionInvoiceInfoVO;
import com.bringspring.contract.model.rkcontractcollectioninvoice.RkContractCollectionInvoiceListVO;
import com.bringspring.contract.model.rkcontractcollectioninvoice.RkContractCollectionInvoicePagination;
import com.bringspring.contract.model.rkcontractcollectioninvoice.RkContractCollectionInvoiceUpForm;
import com.bringspring.contract.service.RkContractCollectionInvoiceService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u56de\u6b3e\u53d1\u7968\u8bb0\u5f55"}, value="contract")
@RequestMapping(value={"/api/contract/RkContractCollectionInvoice"})
public class RkContractCollectionInvoiceController {
    private static final Logger log = LoggerFactory.getLogger(RkContractCollectionInvoiceController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractCollectionInvoiceService rkContractCollectionInvoiceService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkContractCollectionInvoicePagination rkContractCollectionInvoicePagination) throws IOException {
        List<RkContractCollectionInvoiceEntity> list = this.rkContractCollectionInvoiceService.getList(rkContractCollectionInvoicePagination);
        List listVO = JsonUtil.getJsonToList(list, RkContractCollectionInvoiceListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractCollectionInvoicePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkContractCollectionInvoiceCrForm rkContractCollectionInvoiceCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkContractCollectionInvoiceEntity entity = (RkContractCollectionInvoiceEntity)JsonUtil.getJsonToBean((Object)rkContractCollectionInvoiceCrForm, RkContractCollectionInvoiceEntity.class);
        entity.setId(mainId);
        this.rkContractCollectionInvoiceService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractCollectionInvoiceInfoVO> info(@PathVariable(value="id") String id) {
        RkContractCollectionInvoiceEntity entity = this.rkContractCollectionInvoiceService.getInfo(id);
        RkContractCollectionInvoiceInfoVO vo = (RkContractCollectionInvoiceInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractCollectionInvoiceInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractCollectionInvoiceInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkContractCollectionInvoiceEntity entity = this.rkContractCollectionInvoiceService.getInfo(id);
        RkContractCollectionInvoiceInfoVO vo = (RkContractCollectionInvoiceInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractCollectionInvoiceInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkContractCollectionInvoiceUpForm rkContractCollectionInvoiceUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkContractCollectionInvoiceEntity entity = this.rkContractCollectionInvoiceService.getInfo(id);
        if (entity != null) {
            RkContractCollectionInvoiceEntity subentity = (RkContractCollectionInvoiceEntity)JsonUtil.getJsonToBean((Object)rkContractCollectionInvoiceUpForm, RkContractCollectionInvoiceEntity.class);
            this.rkContractCollectionInvoiceService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkContractCollectionInvoiceEntity entity = this.rkContractCollectionInvoiceService.getInfo(id);
        if (entity != null) {
            this.rkContractCollectionInvoiceService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

