/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.constant.CompanyIdEnum;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkContractCollectionRecordEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.entity.RkContractSettlementEntity;
import com.bringspring.contract.entity.RkContractSettlementRecordEntity;
import com.bringspring.contract.model.rkcontract.RkContractPagination;
import com.bringspring.contract.model.rkcontractcollectionrecord.ContractCollectionImportReturnVO;
import com.bringspring.contract.model.rkcontractcollectionrecord.ContractCollectionImportVO;
import com.bringspring.contract.model.rkcontractcollectionrecord.RkContractCollectionRecordCrForm;
import com.bringspring.contract.model.rkcontractcollectionrecord.RkContractCollectionRecordInfoVO;
import com.bringspring.contract.model.rkcontractcollectionrecord.RkContractCollectionRecordListVO;
import com.bringspring.contract.model.rkcontractcollectionrecord.RkContractCollectionRecordPagination;
import com.bringspring.contract.model.rkcontractcollectionrecord.RkContractCollectionRecordPaginationExportModel;
import com.bringspring.contract.model.rkcontractcollectionrecord.RkContractCollectionRecordUpForm;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractCollectionRecordService;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractSettlementRecordService;
import com.bringspring.contract.service.RkContractSettlementService;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.SettlementRate;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.organize.OrganizeCrModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5408\u540c\u5230\u6b3e\u8bb0\u5f55"}, value="contract")
@RequestMapping(value={"/api/contract/RkContractCollectionRecord"})
public class RkContractCollectionRecordController {
    private static final Logger log = LoggerFactory.getLogger(RkContractCollectionRecordController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractCollectionRecordService rkContractCollectionRecordService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkAgentService agentService;
    @Autowired
    private RkContractProjectService contractProjectService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RkContractPaymentService contractPaymentService;
    @Autowired
    private SaleContractCustomerService saleContractCustomerService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RkContractReturnPlanService rkContractReturnPlanService;
    @Autowired
    private ServiceAllUtil serviceAllUtil;
    @Autowired
    private SettlementRate settlementRate;
    @Autowired
    private RkContractSettlementService rkContractSettlementService;
    @Autowired
    private UserService userService;
    @Autowired
    private RkContractSettlementRecordService rkContractSettlementRecordService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkContractCollectionRecordPagination rkContractCollectionRecordPagination) throws IOException {
        String organizeId = this.userProvider.get().getOrganizeId();
        List<RkContractCollectionRecordEntity> list = this.rkContractCollectionRecordService.getList(rkContractCollectionRecordPagination);
        List<RkContractCollectionRecordListVO> listVO = this.appendListVo(list, null);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractCollectionRecordPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    public List<RkContractCollectionRecordListVO> appendListVo(List<RkContractCollectionRecordEntity> list, BigDecimal shiHanGPM) {
        List listVO = JsonUtil.getJsonToList(list, RkContractCollectionRecordListVO.class);
        for (RkContractCollectionRecordListVO rkContractCollectionRecordVO : listVO) {
            OrganizeEntity salerCompany;
            if (ObjectUtil.isNotEmpty((Object)rkContractCollectionRecordVO.getReturnAmount()) && "636567520685427789".equals(rkContractCollectionRecordVO.getContractType()) && !rkContractCollectionRecordVO.getReturnAmount().equals(rkContractCollectionRecordVO.getMatchAmount())) {
                rkContractCollectionRecordVO.setIsCollection("0");
            }
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)rkContractCollectionRecordVO.getContractId()));
            rkContractCollectionRecordVO.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(rkContractCollectionRecordVO.getCreatorUserId()));
            rkContractCollectionRecordVO.setContractCode(byId.getContractCode());
            rkContractCollectionRecordVO.setContractAmount(byId.getContractAmount());
            rkContractCollectionRecordVO.setReturnRatio(byId.getReturnRatio());
            rkContractCollectionRecordVO.setContractName(byId.getContractName());
            rkContractCollectionRecordVO.setSignDate(byId.getSignDate());
            rkContractCollectionRecordVO.setArchivedTime(byId.getArchivedTime());
            rkContractCollectionRecordVO.setValidContractAmount(byId.getValidContractAmount());
            rkContractCollectionRecordVO.setProfit(byId.getProfit());
            rkContractCollectionRecordVO.setSalerId(byId.getSalerName());
            rkContractCollectionRecordVO.setSalerName(byId.getSalerName());
            rkContractCollectionRecordVO.setArchivedTime(byId.getArchivedTime());
            rkContractCollectionRecordVO.setCompanyName(this.organizeService.getInfo(byId.getCompanyId()).getShortName());
            rkContractCollectionRecordVO.setCustomerName(((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)rkContractCollectionRecordVO.getCustomerId()))).getName());
            if (!ObjectUtil.isEmpty((Object)byId.getIsAgent()) && byId.getIsAgent() == 1) {
                rkContractCollectionRecordVO.setAgentName(ObjectUtil.isEmpty((Object)byId.getAgentId()) ? "" : ((RkAgentEntity)this.agentService.getById((Serializable)((Object)byId.getAgentId()))).getName());
            } else {
                rkContractCollectionRecordVO.setAgentName(this.saleContractCustomerService.getCustomerNamesByContractId(byId.getId()));
            }
            if (StringUtils.isNotEmpty((String)byId.getCustomerIds())) {
                rkContractCollectionRecordVO.setCustomerNames(this.saleContractCustomerService.getCustomerNamesByContractId(byId.getId()));
            }
            rkContractCollectionRecordVO.setCollectionWayDesc(this.baseDataUtil.getDictName(rkContractCollectionRecordVO.getCollectionWay(), ""));
            rkContractCollectionRecordVO.setIncomeType(this.crmProductCategoryService.getNameByIds(byId.getIncomeType()));
            rkContractCollectionRecordVO.setContractType(this.baseDataUtil.getDictName(byId.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
            if (StrUtil.isNotEmpty((CharSequence)rkContractCollectionRecordVO.getSalerCompanyId()) && !StrUtil.equals((CharSequence)rkContractCollectionRecordVO.getSalerCompanyId(), (CharSequence)rkContractCollectionRecordVO.getCompanyId()) && ObjectUtil.isNotNull((Object)(salerCompany = this.organizeService.getInfo(rkContractCollectionRecordVO.getSalerCompanyId())))) {
                OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)salerCompany.getPropertyJson(), OrganizeCrModel.class);
                rkContractCollectionRecordVO.setSalerCompanyName(jsonToBean.getShortName());
            }
            byId.setSalesPerson(byId.getSalerId());
            if (!ObjectUtil.isNotEmpty((Object)shiHanGPM)) continue;
            UserEntity userInfo = this.serviceAllUtil.getUserInfo(byId.getSalesPerson());
            if (ObjectUtil.isNotEmpty((Object)userInfo)) {
                OrganizeEntity organizeInfo = this.serviceAllUtil.getOrganizeInfo(userInfo.getOrganizeId());
                if (ObjectUtil.isNotEmpty((Object)organizeInfo)) {
                    byId.setSalerCompanyId(organizeInfo.getOrganizeId());
                }
                if (ObjectUtil.isNotEmpty((Object)byId.getSalerCompanyId())) {
                    CompanyIdEnum companyIdEnum = CompanyIdEnum.getCompanyIdEnum(byId.getSalerCompanyId());
                    if (companyIdEnum.getType().equals("ZY")) {
                        rkContractCollectionRecordVO.setIsSealerLeader("\u662f");
                        rkContractCollectionRecordVO.setReturnPaymentType("newSigned");
                        rkContractCollectionRecordVO.setReturnPaymentTypeDesc("\u65b0\u7b7e");
                    } else {
                        rkContractCollectionRecordVO.setIsSealerLeader("\u5426");
                        List<RkContractReturnPlanEntity> planByContractId = this.rkContractReturnPlanService.getPlanByContractId(rkContractCollectionRecordVO.getContractId());
                        if (CollectionUtil.isNotEmpty(planByContractId)) {
                            RkContractReturnPlanEntity returnPlanEntity = planByContractId.get(0);
                            UserEntity returnPlanUser = this.userService.getInfo(returnPlanEntity.getSalerId());
                            OrganizeEntity organizeEntity = this.serviceAllUtil.getOrganizeInfo(returnPlanUser.getOrganizeId());
                            if (!byId.getSalesPerson().equals(returnPlanEntity.getSalerId())) {
                                if (!byId.getSalerCompanyId().equals(organizeEntity.getOrganizeId())) {
                                    CompanyIdEnum returnPlanCompanyIdEnum = CompanyIdEnum.getCompanyIdEnum(organizeEntity.getOrganizeId());
                                    if (returnPlanCompanyIdEnum.getType().equals("ZY")) {
                                        rkContractCollectionRecordVO.setReturnPaymentType("transferHistory");
                                        rkContractCollectionRecordVO.setReturnPaymentTypeDesc("\u79fb\u4ea4\u5386\u53f2");
                                    }
                                } else {
                                    rkContractCollectionRecordVO.setReturnPaymentType("history");
                                    rkContractCollectionRecordVO.setReturnPaymentTypeDesc("\u5386\u53f2");
                                }
                            } else {
                                rkContractCollectionRecordVO.setReturnPaymentType("history");
                                rkContractCollectionRecordVO.setReturnPaymentTypeDesc("\u5386\u53f2");
                            }
                        } else {
                            rkContractCollectionRecordVO.setReturnPaymentType("history");
                            rkContractCollectionRecordVO.setReturnPaymentTypeDesc("\u5386\u53f2");
                        }
                    }
                }
            } else {
                rkContractCollectionRecordVO.setIsSealerLeader("\u5426");
                rkContractCollectionRecordVO.setReturnPaymentType("history");
                rkContractCollectionRecordVO.setReturnPaymentTypeDesc("\u5386\u53f2");
            }
            rkContractCollectionRecordVO.setSumReturnAmount(byId.getReturnAmount());
            if (ObjectUtil.isEmpty((Object)rkContractCollectionRecordVO.getSumReturnAmount())) {
                rkContractCollectionRecordVO.setSumReturnAmount(new BigDecimal(rkContractCollectionRecordVO.getReturnAmount()));
            }
            if (ObjectUtil.isNotEmpty((Object)byId.getReturnRatio())) {
                rkContractCollectionRecordVO.setSumReturnRate(byId.getReturnRatio());
            } else {
                rkContractCollectionRecordVO.setSumReturnRate(new BigDecimal(rkContractCollectionRecordVO.getReturnRate()));
            }
            RkContractSettlementEntity settlementEntity = this.rkContractSettlementService.getInfoByContractId(rkContractCollectionRecordVO.getContractId());
            if (ObjectUtil.isEmpty((Object)byId.getReturnAmount())) {
                byId.setReturnAmount(BigDecimal.ZERO);
            }
            if (ObjectUtil.isNotEmpty((Object)rkContractCollectionRecordVO.getSumReturnRate())) {
                if (rkContractCollectionRecordVO.getSumReturnRate().compareTo(BigDecimal.valueOf(90L)) >= 0) {
                    rkContractCollectionRecordVO.setIsReturnSettlement("1");
                } else {
                    rkContractCollectionRecordVO.setIsReturnSettlement("0");
                }
            }
            if (ObjectUtil.isNotEmpty((Object)settlementEntity)) {
                rkContractCollectionRecordVO.setSumSettlementAmount(settlementEntity.getSumSettlementAmount());
                if (ObjectUtil.isNotEmpty((Object)settlementEntity.getSettlementCount())) {
                    if (byId.getReturnSettlementStatus().equals("inSettlement")) {
                        rkContractCollectionRecordVO.setSettlementStatusDesc("\u7ed3\u7b97\u4e2d");
                        rkContractCollectionRecordVO.setSettlementStatus("inSettlement");
                    }
                    if (byId.getReturnSettlementStatus().equals("settled")) {
                        rkContractCollectionRecordVO.setSettlementStatusDesc("\u5168\u90e8\u7ed3\u7b97");
                        rkContractCollectionRecordVO.setSettlementStatus("settled");
                    } else if (byId.getReturnSettlementStatus().equals("partSettled")) {
                        rkContractCollectionRecordVO.setSettlementStatusDesc("\u90e8\u5206\u7ed3\u7b97");
                        rkContractCollectionRecordVO.setSettlementStatus("partSettled");
                    }
                }
                rkContractCollectionRecordVO.setNewSettlementDate(settlementEntity.getNewSettlementDate());
            }
            if (byId.getReturnSettlementStatus().equals("notSettled")) {
                rkContractCollectionRecordVO.setSettlementStatusDesc("\u672a\u53d1\u8d77\u7ed3\u7b97");
                rkContractCollectionRecordVO.setSettlementStatus("notSettled");
            }
            if (ObjectUtil.isNotEmpty((Object)settlementEntity) && ObjectUtil.isNotEmpty((Object)settlementEntity.getCommissionRate())) {
                rkContractCollectionRecordVO.setCommissionRate(settlementEntity.getCommissionRate());
                List<RkContractSettlementRecordEntity> settlementRecordList = this.rkContractSettlementRecordService.getListByContractId(rkContractCollectionRecordVO.getContractId());
                if (CollectionUtil.isNotEmpty(settlementRecordList)) {
                    rkContractCollectionRecordVO.setIsAdjust("1");
                }
            } else {
                this.settlementRate.getCommissionRate(rkContractCollectionRecordVO, shiHanGPM);
            }
            rkContractCollectionRecordVO.setNotReturnAmount(byId.getContractAmount().subtract(byId.getReturnAmount()));
            if (ObjectUtil.isNotEmpty((Object)rkContractCollectionRecordVO.getSumReturnRate()) && ObjectUtil.isNotEmpty((Object)rkContractCollectionRecordVO.getSettlementStatus()) && !rkContractCollectionRecordVO.getSettlementStatus().equals("settled") && ObjectUtil.isNotEmpty((Object)rkContractCollectionRecordVO.getCommissionRate())) {
                BigDecimal returnSettlementAmount;
                if (rkContractCollectionRecordVO.getSumReturnRate().compareTo(BigDecimal.valueOf(90L)) >= 0 && rkContractCollectionRecordVO.getSumReturnRate().compareTo(BigDecimal.valueOf(100L)) < 0 && rkContractCollectionRecordVO.getSettlementStatus().equals("notSettled")) {
                    if (ObjectUtil.isNotEmpty((Object)byId.getValidContractAmount())) {
                        returnSettlementAmount = byId.getValidContractAmount().multiply(BigDecimal.valueOf(0.9)).multiply(rkContractCollectionRecordVO.getCommissionRate());
                        rkContractCollectionRecordVO.setReturnSettlementAmount(returnSettlementAmount);
                    } else if (ObjectUtil.isNotEmpty((Object)byId.getProfit()) && byId.getCompanyId().equals("14")) {
                        returnSettlementAmount = byId.getProfit().multiply(BigDecimal.valueOf(0.9)).multiply(rkContractCollectionRecordVO.getCommissionRate());
                        rkContractCollectionRecordVO.setReturnSettlementAmount(returnSettlementAmount);
                    }
                }
                if (rkContractCollectionRecordVO.getSumReturnRate().compareTo(BigDecimal.valueOf(100L)) == 0) {
                    if (ObjectUtil.isNotEmpty((Object)byId.getValidContractAmount())) {
                        if (ObjectUtil.isNotEmpty((Object)settlementEntity)) {
                            if (ObjectUtil.isEmpty((Object)settlementEntity.getSettlementCount()) && byId.getReturnSettlementStatus().equals("notSettled")) {
                                returnSettlementAmount = byId.getValidContractAmount().multiply(rkContractCollectionRecordVO.getCommissionRate());
                                rkContractCollectionRecordVO.setReturnSettlementAmount(returnSettlementAmount);
                            }
                            if (ObjectUtil.isNotEmpty((Object)settlementEntity.getSettlementCount()) && settlementEntity.getSettlementCount().equals(1)) {
                                returnSettlementAmount = byId.getValidContractAmount().multiply(BigDecimal.valueOf(0.1)).multiply(rkContractCollectionRecordVO.getCommissionRate());
                                rkContractCollectionRecordVO.setReturnSettlementAmount(returnSettlementAmount);
                            }
                        } else if (byId.getReturnSettlementStatus().equals("notSettled")) {
                            returnSettlementAmount = byId.getValidContractAmount().multiply(rkContractCollectionRecordVO.getCommissionRate());
                            rkContractCollectionRecordVO.setReturnSettlementAmount(returnSettlementAmount);
                        }
                    } else if (byId.getCompanyId().equals("14") && ObjectUtil.isNotEmpty((Object)rkContractCollectionRecordVO.getProfit())) {
                        if (ObjectUtil.isNotEmpty((Object)settlementEntity)) {
                            if (ObjectUtil.isEmpty((Object)settlementEntity.getSettlementCount())) {
                                returnSettlementAmount = byId.getProfit().multiply(rkContractCollectionRecordVO.getCommissionRate());
                                rkContractCollectionRecordVO.setReturnSettlementAmount(returnSettlementAmount);
                            }
                            if (ObjectUtil.isNotEmpty((Object)settlementEntity.getSettlementCount()) && settlementEntity.getSettlementCount().equals(1)) {
                                returnSettlementAmount = byId.getProfit().multiply(BigDecimal.valueOf(0.1)).multiply(rkContractCollectionRecordVO.getCommissionRate());
                                rkContractCollectionRecordVO.setReturnSettlementAmount(returnSettlementAmount);
                            }
                        }
                        if (ObjectUtil.isEmpty((Object)settlementEntity)) {
                            returnSettlementAmount = byId.getProfit().multiply(rkContractCollectionRecordVO.getCommissionRate());
                            rkContractCollectionRecordVO.setReturnSettlementAmount(returnSettlementAmount);
                        }
                    }
                }
            }
            if (rkContractCollectionRecordVO.getSettlementStatus().equals("settled")) {
                rkContractCollectionRecordVO.setIsReturnSettlement("0");
                rkContractCollectionRecordVO.setReturnSettlementAmount(BigDecimal.ZERO);
            }
            if (!ObjectUtil.isNotEmpty((Object)rkContractCollectionRecordVO.getReturnPaymentType()) || !rkContractCollectionRecordVO.getReturnPaymentType().equals("transferHistory") || !ObjectUtil.isNotEmpty((Object)rkContractCollectionRecordVO.getReturnSettlementAmount())) continue;
            rkContractCollectionRecordVO.setReturnSettlementAmount(rkContractCollectionRecordVO.getReturnSettlementAmount().multiply(BigDecimal.valueOf(0.6)));
        }
        return listVO;
    }

    @PostMapping(value={"countAmount"})
    public ActionResult countAmount(@RequestBody RkContractCollectionRecordPagination rkContractCollectionRecordPagination) {
        if (CollectionUtil.isEmpty(rkContractCollectionRecordPagination.getReturnDate())) {
            rkContractCollectionRecordPagination.setReturnDate(CollectionUtil.list((boolean)false, (Object[])new Date[]{DateUtil.getBeginDayOfMonth(), DateUtil.getEndDayOfMonth()}));
        }
        Map<String, Object> stringObjectMap = this.rkContractCollectionRecordService.countAmount(rkContractCollectionRecordPagination);
        return ActionResult.success(stringObjectMap);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @PostMapping(value={"/Actions/Export"})
    public ActionResult Export(@RequestBody RkContractCollectionRecordPaginationExportModel rkContractCollectionRecordPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkContractCollectionRecordPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkContractCollectionRecordPagination rkContractCollectionRecordPagination = (RkContractCollectionRecordPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractCollectionRecordPaginationExportModel), RkContractCollectionRecordPagination.class));
        List<RkContractCollectionRecordEntity> list = this.rkContractCollectionRecordService.getTypeList(rkContractCollectionRecordPagination, rkContractCollectionRecordPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, RkContractCollectionRecordListVO.class);
        RkAgentEntity agent = null;
        for (RkContractCollectionRecordListVO rkContractCollectionRecordVO : listVO) {
            OrganizeEntity salerCompany;
            OrganizeCrModel jsonToBean;
            OrganizeEntity company;
            try {
                if (ObjectUtil.isNotNull((Object)rkContractCollectionRecordVO.getReturnDate())) {
                    rkContractCollectionRecordVO.setReturnDateDesc(DateUtil.longToDate((long)(rkContractCollectionRecordVO.getReturnDate() / 1000L)));
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)rkContractCollectionRecordVO.getContractId()));
            rkContractCollectionRecordVO.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(rkContractCollectionRecordVO.getCreatorUserId()));
            rkContractCollectionRecordVO.setContractCode(byId.getContractCode());
            rkContractCollectionRecordVO.setContractName(byId.getContractName());
            rkContractCollectionRecordVO.setContractAmount(byId.getContractAmount());
            rkContractCollectionRecordVO.setReturnRatio(byId.getReturnRatio());
            rkContractCollectionRecordVO.setSignDate(byId.getSignDate());
            rkContractCollectionRecordVO.setArchivedTime(byId.getArchivedTime());
            rkContractCollectionRecordVO.setCustomerName(ObjectUtil.isEmpty((Object)byId.getCustomerId()) ? "" : ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)byId.getCustomerId()))).getName());
            if (!ObjectUtil.isEmpty((Object)byId.getIsAgent()) && byId.getIsAgent() == 1) {
                agent = (RkAgentEntity)this.agentService.getById((Serializable)((Object)byId.getAgentId()));
                if (null != agent) {
                    rkContractCollectionRecordVO.setAgentName(agent.getName());
                } else {
                    rkContractCollectionRecordVO.setAgentName("");
                }
            } else {
                rkContractCollectionRecordVO.setAgentName(rkContractCollectionRecordVO.getCustomerName());
            }
            rkContractCollectionRecordVO.setIncomeType(this.crmProductCategoryService.getNameByIds(byId.getIncomeType()));
            rkContractCollectionRecordVO.setContractType(this.baseDataUtil.getDictName(byId.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
            if (StrUtil.isNotEmpty((CharSequence)rkContractCollectionRecordVO.getCompanyId()) && ObjectUtil.isNotNull((Object)(company = this.organizeService.getInfo(rkContractCollectionRecordVO.getCompanyId())))) {
                jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)company.getPropertyJson(), OrganizeCrModel.class);
                rkContractCollectionRecordVO.setCompanyId(jsonToBean.getShortName());
            }
            if (!StrUtil.isNotEmpty((CharSequence)rkContractCollectionRecordVO.getSalerCompanyId()) || StrUtil.equals((CharSequence)rkContractCollectionRecordVO.getSalerCompanyId(), (CharSequence)rkContractCollectionRecordVO.getCompanyId()) || !ObjectUtil.isNotNull((Object)(salerCompany = this.organizeService.getInfo(rkContractCollectionRecordVO.getSalerCompanyId())))) continue;
            jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)salerCompany.getPropertyJson(), OrganizeCrModel.class);
            rkContractCollectionRecordVO.setSalerCompanyName(jsonToBean.getShortName());
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd"));
        String[] keys = !StringUtil.isEmpty((String)rkContractCollectionRecordPaginationExportModel.getSelectKey()) ? rkContractCollectionRecordPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block48: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "returnDateDesc": {
                        entitys.add(new ExcelExportEntity("\u5230\u6b3e\u65e5\u671f", (Object)"returnDateDesc"));
                        continue block48;
                    }
                    case "returnAmount": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u5230\u6b3e\u91d1\u989d(\u5143)", (Object)"returnAmount");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block48;
                    }
                    case "returnRate": {
                        entitys.add(new ExcelExportEntity("\u5230\u6b3e\u6bd4\u4f8b(%)", (Object)"returnRate"));
                        continue block48;
                    }
                    case "returnRatio": {
                        entitys.add(new ExcelExportEntity("\u5df2\u56de\u6b3e\u6bd4\u4f8b(%)", (Object)"returnRatio"));
                        continue block48;
                    }
                    case "companyId": {
                        entitys.add(new ExcelExportEntity("\u516c\u53f8", (Object)"companyId"));
                        continue block48;
                    }
                    case "salerCompanyName": {
                        entitys.add(new ExcelExportEntity("\u8425\u9500\u5e73\u53f0", (Object)"salerCompanyName"));
                        continue block48;
                    }
                    case "contractAmount": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u5408\u540c\u91d1\u989d(\u5143)", (Object)"contractAmount");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block48;
                    }
                    case "signDate": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u65e5\u671f", (Object)"signDate"));
                        continue block48;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block48;
                    }
                    case "archivedTime": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u5f52\u6863\u65e5\u671f", (Object)"archivedTime"));
                        continue block48;
                    }
                    case "customerProvName": {
                        entitys.add(new ExcelExportEntity("\u7701\u4efd", (Object)"customerProvName"));
                        continue block48;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block48;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u5bf9\u8c61", (Object)"agentName"));
                        continue block48;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerName"));
                        continue block48;
                    }
                    case "contractType": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7c7b\u578b", (Object)"contractType"));
                        continue block48;
                    }
                    case "incomeType": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5927\u7c7b", (Object)"incomeType"));
                        continue block48;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u5f55\u5165\u4eba", (Object)"creatorUserId"));
                        continue block48;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u5f55\u5165\u65f6\u95f4", (Object)"creatorTime"));
                        continue block48;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkContractCollectionRecordCrForm rkContractCollectionRecordCrForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            rkContractCollectionRecordCrForm.setCompanyId(userInfo.getOrganizeId());
            HashMap map = this.rkContractCollectionRecordService.saveCollectionRecord(rkContractCollectionRecordCrForm);
            if (ObjectUtil.isEmpty(map.get("error"))) {
                return ActionResult.success((String)"\u6536\u6b3e\u6210\u529f");
            }
            return ActionResult.fail((String)map.get("error").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping(value={"/updateDigitalRecord"})
    @DSTransactional
    public ActionResult digitalCollectionRecord(@RequestBody @Valid RkContractCollectionRecordCrForm rkContractCollectionRecordCrForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            rkContractCollectionRecordCrForm.setCompanyId(userInfo.getOrganizeId());
            HashMap map = this.rkContractCollectionRecordService.updateDigitalRecord(rkContractCollectionRecordCrForm);
            if (ObjectUtil.isEmpty(map.get("error"))) {
                return ActionResult.success((String)"\u6536\u6b3e\u6210\u529f");
            }
            return ActionResult.fail((String)map.get("error").toString());
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractCollectionRecordInfoVO> info(@PathVariable(value="id") String id) {
        RkContractProjectEntity projectEntity;
        RkContractCollectionRecordEntity entity = this.rkContractCollectionRecordService.getInfo(id);
        RkContractCollectionRecordInfoVO vo = (RkContractCollectionRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractCollectionRecordInfoVO.class);
        RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)entity.getContractId()));
        vo.setContractCode(byId.getContractCode());
        vo.setContractName(byId.getContractName());
        vo.setContractReturnRatio(byId.getReturnRatio());
        vo.setContractReturnAmount(byId.getReturnAmount());
        vo.setContractReturnState(byId.getReturnState());
        vo.setContractAmount(byId.getContractAmount() + "");
        vo.setContractType(this.baseDataUtil.getDictName(byId.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
        vo.setIncomeType(this.crmProductCategoryService.getNameByIds(byId.getIncomeType()));
        vo.setIndustryType(this.baseDataUtil.getDictName(byId.getIndustryType(), "industryType"));
        vo.setProjectName(ObjectUtil.isEmpty((Object)entity.getProjectId()) ? "" : ((RkContractProjectEntity)this.contractProjectService.getById((Serializable)((Object)entity.getProjectId()))).getProjectName());
        vo.setCollectionWayDesc(this.baseDataUtil.getDictName(entity.getCollectionWay(), "collectionWay"));
        vo.setPaymentType(this.baseDataUtil.getDictName(entity.getPaymentType(), "paymentType"));
        vo.setCustomerName(ObjectUtil.isEmpty((Object)byId.getCustomerId()) ? "" : ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)byId.getCustomerId()))).getName());
        if (StrUtil.isNotBlank((CharSequence)entity.getProjectId()) && ObjectUtil.isNotNull((Object)(projectEntity = (RkContractProjectEntity)this.contractProjectService.getById((Serializable)((Object)entity.getProjectId()))))) {
            vo.setReceivedAmount(projectEntity.getReceivedAmount());
            vo.setReceivedRatio(projectEntity.getReceivedRatio());
            vo.setProjectCode(projectEntity.getProjectCode());
            vo.setProjectAmount(projectEntity.getProjectAmount());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractCollectionRecordInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkContractCollectionRecordEntity entity = this.rkContractCollectionRecordService.getInfo(id);
        RkContractCollectionRecordInfoVO vo = (RkContractCollectionRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractCollectionRecordInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkContractCollectionRecordUpForm rkContractCollectionRecordUpForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            RkContractCollectionRecordEntity entity = this.rkContractCollectionRecordService.getInfo(id);
            if (entity != null) {
                RkContractCollectionRecordEntity subentity = (RkContractCollectionRecordEntity)JsonUtil.getJsonToBean((Object)rkContractCollectionRecordUpForm, RkContractCollectionRecordEntity.class);
                this.rkContractCollectionRecordService.update(id, subentity);
                return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            HashMap map = this.rkContractCollectionRecordService.deleteCollectionRecord(id);
            if (ObjectUtil.isEmpty(map.get("error"))) {
                return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
            }
            return ActionResult.fail((String)map.get("error").toString());
        }
    }

    @GetMapping(value={"/getListByContractId/{contractId}"})
    public ActionResult getListByContractId(@PathVariable(value="contractId") String contractId) {
        List<RkContractCollectionRecordEntity> listByContractId = this.rkContractCollectionRecordService.getListByContractId(contractId);
        List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractCollectionRecordListVO.class);
        for (RkContractCollectionRecordListVO rkContractCollectionRecordVO : jsonToList) {
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)rkContractCollectionRecordVO.getContractId()));
            rkContractCollectionRecordVO.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(rkContractCollectionRecordVO.getCreatorUserId()));
            rkContractCollectionRecordVO.setContractCode(byId.getContractCode());
            rkContractCollectionRecordVO.setContractName(byId.getContractName());
            rkContractCollectionRecordVO.setSignDate(byId.getSignDate());
            rkContractCollectionRecordVO.setArchivedTime(byId.getArchivedTime());
            rkContractCollectionRecordVO.setCustomerName(ObjectUtil.isEmpty((Object)byId.getCustomerId()) ? "" : ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)byId.getCustomerId()))).getName());
            if (!ObjectUtil.isEmpty((Object)byId.getIsAgent()) && byId.getIsAgent() == 1) {
                rkContractCollectionRecordVO.setAgentId(ObjectUtil.isEmpty((Object)byId.getAgentId()) ? "" : ((RkAgentEntity)this.agentService.getById((Serializable)((Object)byId.getAgentId()))).getName());
            }
            rkContractCollectionRecordVO.setIncomeType(this.crmProductCategoryService.getNameByIds(byId.getIncomeType()));
            rkContractCollectionRecordVO.setContractType(this.baseDataUtil.getDictName(byId.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
        }
        return ActionResult.success((Object)jsonToList);
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u5230\u6b3e\u8bb0\u5f55.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u5230\u6b3e\u8bb0\u5f55.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List collectionImportVOS = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, ContractCollectionImportVO.class);
        List list = JsonUtil.getJsonToList((Object)collectionImportVOS, Object.class);
        Map<String, Object> map = this.contractPaymentService.importPreview(list, new ContractCollectionImportVO());
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<ContractCollectionImportReturnVO> ImportData(@RequestBody ContractCollectionImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), ContractCollectionImportVO.class);
        ContractCollectionImportReturnVO result = this.rkContractCollectionRecordService.importData(dataList);
        return ActionResult.success((Object)result);
    }

    @ApiOperation(value="\u5bfc\u51fa\u9519\u8bef\u62a5\u544a")
    @PostMapping(value={"/ExportExceptionData"})
    public ActionResult<DownloadVO> exportExceptionData(@RequestBody ContractCollectionImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), Object.class);
        DownloadVO vo = this.contractService.exportExceptionData(dataList, new ContractCollectionImportVO());
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getReturnAmountForSettlement"})
    public ActionResult getReturnAmountForSettlement(@RequestBody RkContractCollectionRecordPagination rkContractCollectionRecordPagination) throws IOException {
        List<String> regionList = Arrays.asList("41", "42", "31", "45");
        if (CollectionUtil.isEmpty(rkContractCollectionRecordPagination.getRegionIdList())) {
            rkContractCollectionRecordPagination.setRegionIdList(regionList);
        }
        rkContractCollectionRecordPagination.setCommissionType("commission");
        List<RkContractCollectionRecordEntity> list = this.rkContractCollectionRecordService.getList(rkContractCollectionRecordPagination);
        BigDecimal shiHanGPM = this.getShiHanGPM(rkContractCollectionRecordPagination);
        List<RkContractCollectionRecordListVO> listVO = this.appendListVo(list, shiHanGPM);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractCollectionRecordPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private BigDecimal getShiHanGPM(RkContractCollectionRecordPagination rkContractCollectionRecordPagination) {
        List<String> companyIdList = Arrays.asList("14");
        List<String> regionList = Arrays.asList("41", "42", "31", "45");
        RkContractPagination rkContractPagination = new RkContractPagination();
        rkContractPagination.setRegionIdList(regionList);
        rkContractPagination.setCompanyIdList(companyIdList);
        rkContractPagination.setMenuId("436126727484251909");
        rkContractPagination.setCreatorTime(rkContractCollectionRecordPagination.getReturnDate());
        rkContractPagination.setIsAuth(0);
        rkContractPagination.setSort("desc");
        List<RkContractEntity> contractList = this.contractService.getListByNoPage(rkContractPagination);
        BigDecimal totalContractAmount = contractList.stream().map(t -> t.getContractAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalProfit = contractList.stream().filter(t -> ObjectUtil.isNotEmpty((Object)t.getProfit())).map(t -> t.getProfit()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal shiHanGPM = BigDecimal.ZERO;
        if (ObjectUtil.isNotEmpty((Object)totalContractAmount) && totalContractAmount.compareTo(BigDecimal.ZERO) > 0) {
            shiHanGPM = totalProfit.divide(totalContractAmount, 2, 4);
        }
        return shiHanGPM;
    }

    @PostMapping(value={"/countBySettlementStage"})
    public ActionResult countBySettlementStage(@RequestBody RkContractCollectionRecordPagination rkContractCollectionRecordPagination) {
        List<RkContractCollectionRecordEntity> list = this.rkContractCollectionRecordService.getListByNoPage(rkContractCollectionRecordPagination);
        List idList = list.stream().map(RkContractCollectionRecordEntity::getContractId).collect(Collectors.toList());
        HashMap map = MapUtil.newHashMap();
        if (CollectionUtil.isNotEmpty(idList)) {
            List contractList = this.contractService.listByIds(idList);
            long notSettled = contractList.stream().filter(t -> ObjectUtil.isNotEmpty((Object)t.getReturnSettlementStatus())).filter(t -> t.getReturnSettlementStatus().equals("notSettled")).count();
            long inSettlement = contractList.stream().filter(t -> ObjectUtil.isNotEmpty((Object)t.getReturnSettlementStatus())).filter(t -> t.getReturnSettlementStatus().equals("inSettlement")).count();
            long settled = contractList.stream().filter(t -> ObjectUtil.isNotEmpty((Object)t.getReturnSettlementStatus())).filter(t -> t.getReturnSettlementStatus().equals("settled")).count();
            long partSettled = contractList.stream().filter(t -> ObjectUtil.isNotEmpty((Object)t.getReturnSettlementStatus())).filter(t -> t.getReturnSettlementStatus().equals("partSettled")).count();
            map.put("notSettled", notSettled);
            map.put("inSettlement", inSettlement);
            map.put("settled", settled);
            map.put("partSettled", partSettled);
        }
        return ActionResult.success((Object)map);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @PostMapping(value={"/Actions/ExportReturnAmountForSettlement"})
    public ActionResult ExportReturnAmountForSettlement(@RequestBody RkContractCollectionRecordPaginationExportModel rkContractCollectionRecordPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkContractCollectionRecordPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkContractCollectionRecordPagination rkContractCollectionRecordPagination = (RkContractCollectionRecordPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractCollectionRecordPaginationExportModel), RkContractCollectionRecordPagination.class));
        List<String> regionList = Arrays.asList("41", "42", "31", "45");
        if (CollectionUtil.isEmpty(rkContractCollectionRecordPagination.getRegionIdList())) {
            rkContractCollectionRecordPagination.setRegionIdList(regionList);
        }
        rkContractCollectionRecordPagination.setCommissionType("commission");
        List<RkContractCollectionRecordEntity> list = this.rkContractCollectionRecordService.getTypeList(rkContractCollectionRecordPagination, rkContractCollectionRecordPaginationExportModel.getDataType());
        BigDecimal shiHanGPM = this.getShiHanGPM(rkContractCollectionRecordPagination);
        List<RkContractCollectionRecordListVO> listVO = this.appendListVo(list, shiHanGPM);
        listVO.stream().forEach(t -> {
            if (ObjectUtil.isNotEmpty((Object)t.getIsReturnSettlement())) {
                if (t.getIsReturnSettlement().equals("1")) {
                    t.setIsReturnSettlement("\u662f");
                } else {
                    t.setIsReturnSettlement("\u5426");
                }
            }
            if (ObjectUtil.isEmpty((Object)t.getSumSettlementAmount())) {
                t.setSumSettlementAmount(BigDecimal.ZERO);
            }
            if (ObjectUtil.isEmpty((Object)t.getReturnSettlementAmount())) {
                t.setReturnSettlementAmount(BigDecimal.ZERO);
            }
            if (ObjectUtil.isEmpty((Object)t.getValidContractAmount())) {
                t.setValidContractAmount(BigDecimal.ZERO);
            }
            if (ObjectUtil.isEmpty((Object)t.getCommissionRate())) {
                t.setCommissionRate(BigDecimal.ZERO);
            }
        });
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkContractCollectionRecordPaginationExportModel.getSelectKey()) ? rkContractCollectionRecordPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.createSettlementExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadVO createSettlementExcel(String temporaryFilePath, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block60: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block60;
                    }
                    case "returnPaymentTypeDesc": {
                        entitys.add(new ExcelExportEntity("\u56de\u6b3e\u7c7b\u578b", (Object)"returnPaymentTypeDesc"));
                        continue block60;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block60;
                    }
                    case "salerName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u4eba\u5458", (Object)"salerName"));
                        continue block60;
                    }
                    case "archivedTime": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u5f52\u6863\u65e5\u671f", (Object)"archivedTime"));
                        continue block60;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block60;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u5bf9\u8c61", (Object)"agentName"));
                        continue block60;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerName"));
                        continue block60;
                    }
                    case "contractType": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7c7b\u578b", (Object)"contractType"));
                        continue block60;
                    }
                    case "isSealerLeader": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u667a\u533b\u4e3b\u5bfc", (Object)"isSealerLeader"));
                        continue block60;
                    }
                    case "incomeType": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5927\u7c7b", (Object)"incomeType"));
                        continue block60;
                    }
                    case "contractAmount": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u91d1\u989d\uff08\u5143\uff09", (Object)"contractAmount"));
                        continue block60;
                    }
                    case "validContractAmount": {
                        entitys.add(new ExcelExportEntity("\u6709\u6548\u5408\u540c\u91d1\u989d\uff08\u5143\uff09", (Object)"validContractAmount"));
                        continue block60;
                    }
                    case "settlementStatusDesc": {
                        entitys.add(new ExcelExportEntity("\u7ed3\u7b97\u72b6\u6001", (Object)"settlementStatusDesc"));
                        continue block60;
                    }
                    case "returnAmount": {
                        entitys.add(new ExcelExportEntity("\u56de\u6b3e\u91d1\u989d\uff08\u5143\uff09", (Object)"returnAmount"));
                        continue block60;
                    }
                    case "sumReturnAmount": {
                        entitys.add(new ExcelExportEntity("\u7d2f\u8ba1\u56de\u6b3e\u91d1\u989d\uff08\u5143\uff09", (Object)"sumReturnAmount"));
                        continue block60;
                    }
                    case "returnRate": {
                        entitys.add(new ExcelExportEntity("\u56de\u6b3e\u6bd4\u4f8b", (Object)"returnRate"));
                        continue block60;
                    }
                    case "sumReturnRate": {
                        entitys.add(new ExcelExportEntity("\u7d2f\u8ba1\u56de\u6b3e\u6bd4\u4f8b", (Object)"sumReturnRate"));
                        continue block60;
                    }
                    case "notReturnAmount": {
                        entitys.add(new ExcelExportEntity("\u672a\u56de\u6b3e\u91d1\u989d\uff08\u5143\uff09", (Object)"notReturnAmount"));
                        continue block60;
                    }
                    case "returnSettlementAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u6b21\u5e94\u7ed3\u7b97\u91d1\u989d", (Object)"returnSettlementAmount"));
                        continue block60;
                    }
                    case "sumSettlementAmount": {
                        entitys.add(new ExcelExportEntity("\u7d2f\u8ba1\u5df2\u7ed3\u7b97\u91d1\u989d", (Object)"sumSettlementAmount"));
                        continue block60;
                    }
                    case "commissionRate": {
                        entitys.add(new ExcelExportEntity("\u63d0\u6210\u6bd4\u4f8b", (Object)"commissionRate"));
                        continue block60;
                    }
                    case "isReturnSettlement": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u53ef\u7ed3\u7b97", (Object)"isReturnSettlement"));
                        continue block60;
                    }
                    case "newSettlementDate": {
                        entitys.add(new ExcelExportEntity("\u6700\u65b0\u7ed3\u7b97\u65e5\u671f", (Object)"newSettlementDate"));
                        continue block60;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u667a\u533b\u56de\u6b3e\u7ed3\u7b97\u8868\u5355");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u667a\u533b\u56de\u6b3e\u7ed3\u7b97\u8868\u5355" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

