/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.constant.CompanyIdEnum;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractCollectionRecordEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractPaymentEntity;
import com.bringspring.contract.entity.RkContractProcureRelationEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.entity.RkContractSettlementEntity;
import com.bringspring.contract.entity.RkContractSettlementRecordEntity;
import com.bringspring.contract.entity.RkContractTaxEntity;
import com.bringspring.contract.entity.RkReturnPlanTrackingEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.model.countAmount.CountAmountVO;
import com.bringspring.contract.model.rkarchived.RkArachivedUpForm;
import com.bringspring.contract.model.rkattachment.RkAttachmentCrForm;
import com.bringspring.contract.model.rkcontract.ContractImportReturnVO;
import com.bringspring.contract.model.rkcontract.ContractImportVO;
import com.bringspring.contract.model.rkcontract.RkCompanyContractStatisticsLedger;
import com.bringspring.contract.model.rkcontract.RkContractCrForm;
import com.bringspring.contract.model.rkcontract.RkContractInfoVO;
import com.bringspring.contract.model.rkcontract.RkContractListVO;
import com.bringspring.contract.model.rkcontract.RkContractPagination;
import com.bringspring.contract.model.rkcontract.RkContractPaginationExportModel;
import com.bringspring.contract.model.rkcontract.RkContractPaginationVO;
import com.bringspring.contract.model.rkcontract.RkContractUpForm;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentListVO;
import com.bringspring.contract.model.rkcontractprocure.OaContractInternalTransactionInfo;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectListVO;
import com.bringspring.contract.model.rkcontractreturnplan.RkContractReturnPlanOverdueListVO;
import com.bringspring.contract.model.rkcontractreturnplan.RkContractReturnPlanPagination;
import com.bringspring.contract.model.rkcontracttax.RkContractTaxInfoVO;
import com.bringspring.contract.service.OaContractInternalCrmService;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractCollectionRecordService;
import com.bringspring.contract.service.RkContractInvoiceDetailService;
import com.bringspring.contract.service.RkContractInvoiceService;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProcureRelationService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractSettlementRecordService;
import com.bringspring.contract.service.RkContractSettlementService;
import com.bringspring.contract.service.RkContractTaxService;
import com.bringspring.contract.service.RkReturnPlanTrackingService;
import com.bringspring.contract.service.RkcontrActassetsLedgerService;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.ContractEnableMarkEnum;
import com.bringspring.contract.utils.ContractReturnPlanUilts;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.ProjectStateEnum;
import com.bringspring.contract.utils.ReturnPlanEnum;
import com.bringspring.contract.utils.RoleUtils;
import com.bringspring.contract.utils.SaleNoContractStatusEnum;
import com.bringspring.contract.utils.SettlementRate;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerCompanyRelationService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.quotation.entity.SaleQuotationEntity;
import com.bringspring.quotation.entity.SaleQuotationProfitEntity;
import com.bringspring.quotation.service.SaleQuotationProfitService;
import com.bringspring.quotation.service.SaleQuotationService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.organize.OrganizeCrModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.ParamAddress;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.visit.utils.DeleteMarkEnum;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u5408\u540c"}, value="contract")
@RequestMapping(value={"/api/contract/RkContract"})
public class RkContractController {
    private static final Logger log = LoggerFactory.getLogger(RkContractController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkAgentService agentService;
    @Autowired
    private RkContractReturnPlanService contractReturnPlanService;
    @Autowired
    private RkContractProjectService contractProjectService;
    @Autowired
    private RkContractPaymentService contractPaymentService;
    @Autowired
    private RkContractCollectionRecordService contractCollectionRecordService;
    @Autowired
    private RkContractInvoiceDetailService contractInvoiceDetailService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private UserService userService;
    @Autowired
    private RkContractInvoiceService contractInvoiceService;
    @Autowired
    private RoleUtils roleUtils;
    @Autowired
    private RkContractTaxService contractTaxService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private CrmCustomerCompanyRelationService crmCustomerCompanyRelationService;
    @Autowired
    private RkReturnPlanTrackingService rkReturnPlanTrackingService;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkcontrActassetsLedgerService rkcontrActassetsLedgerService;
    @Autowired
    private RkContractProcureRelationService rkContractProcureRelationService;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private SaleQuotationService saleQuotationService;
    @Autowired
    private SaleQuotationProfitService saleQuotationProfitService;
    @Autowired
    private SaleNoContractService saleNoContractService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private SaleContractCustomerService saleContractCustomerService;
    @Autowired
    private OaContractInternalCrmService oaContractInternalCrmService;
    @Autowired
    private ServiceAllUtil serviceAllUtil;
    @Autowired
    private RkContractCollectionRecordService rkContractCollectionRecordService;
    @Autowired
    private SettlementRate settlementRate;
    @Autowired
    private RkContractSettlementService rkContractSettlementService;
    @Autowired
    private RkContractSettlementRecordService rkContractSettlementRecordService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@ParamAddress(field="customerAddress") @RequestBody RkContractPagination rkContractPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        String organizeId = userInfo.getOrganizeId();
        List<List<String>> region = rkContractPagination.getCustomerRegion();
        if (CollectionUtil.isNotEmpty(region)) {
            List searchRegion = CollectionUtil.list((boolean)false);
            region.stream().forEach(l -> searchRegion.add(l.get(0)));
            rkContractPagination.setSearchCustomerRegion(searchRegion);
        }
        List<RkContractEntity> list = this.rkContractService.getList(rkContractPagination);
        List<RkContractListVO> listVO = this.appendListVo(list, false);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        RkContractPaginationVO page = (RkContractPaginationVO)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractPagination), RkContractPaginationVO.class));
        vo.setPagination((PaginationVO)page);
        return ActionResult.success((Object)vo);
    }

    private List<RkContractListVO> appendListVo(List<RkContractEntity> list, boolean isExport) {
        List listVO = JsonUtil.getJsonToList(list, RkContractListVO.class);
        Object customer = null;
        RkAgentEntity agent = null;
        HashMap customerMap = MapUtil.newHashMap();
        HashMap agentMap = MapUtil.newHashMap();
        if (isExport) {
            List<CrmCustomerEntity> companyCustomer = this.crmCustomerService.getCompanyCustomer();
            companyCustomer.stream().forEach(x -> customerMap.put(x.getId(), x));
            this.rkAgentService.listSimpleIdAndName().stream().forEach(x -> agentMap.put(x.getId(), x));
        }
        for (RkContractListVO vo : listVO) {
            UserEntity userInfo;
            String s2;
            OrganizeEntity byId;
            vo.setContractTaxRate(this.baseDataUtil.getDictName(vo.getContractTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
            vo.setSalesPerson(vo.getSalerId());
            vo.setSalerId(vo.getSalerName());
            vo.setOriginalSalerName(this.baseDataUtil.userSelectValueNoAccount(vo.getOriginalSalerId()));
            vo.setContractTypeName(this.baseDataUtil.getDictName(vo.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
            vo.setFinancialAcceptanceUser(this.baseDataUtil.userSelectValues(vo.getFinancialAcceptanceUser()));
            vo.setSalesSupportUser(this.baseDataUtil.userSelectValues(vo.getSalesSupportUser()));
            vo.setOpportunityAssistanceUser(this.baseDataUtil.userSelectValues(vo.getOpportunityAssistanceUser()));
            vo.setProposalProducer(this.baseDataUtil.userSelectValues(vo.getProposalProducer()));
            vo.setAssistingUser(this.baseDataUtil.userSelectValues(vo.getAssistingUser()));
            vo.setRegion(vo.getRegionName());
            vo.setCustomerRegion(vo.getCustomerRegionName());
            vo.setDepartment(vo.getDepartmentTreeName());
            vo.setIncomeTypeName(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
            vo.setIndustryType(this.baseDataUtil.getDictName(vo.getIndustryType(), "industryType"));
            vo.setMasterId(ObjectUtil.isEmpty((Object)vo.getMasterId()) ? "" : ((RkContractEntity)this.rkContractService.getById((Serializable)((Object)vo.getMasterId()))).getContractName());
            if (StringUtils.isNotEmpty((String)vo.getCompanyId())) {
                vo.setCompanyName(this.organizeService.getInfo(vo.getCompanyId()).getShortName());
            }
            if (StrUtil.isNotEmpty((CharSequence)vo.getSalerCompanyId()) && !StrUtil.equals((CharSequence)vo.getSalerCompanyId(), (CharSequence)vo.getCompanyId()) && ObjectUtil.isNotNull((Object)(byId = this.organizeService.getInfo(vo.getSalerCompanyId())))) {
                OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)byId.getPropertyJson(), OrganizeCrModel.class);
                vo.setSalerCompanyName(jsonToBean.getShortName());
            }
            if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
                String customerNames = "";
                List customerNameList = CollectionUtil.list((boolean)false);
                if (isExport) {
                    if (StrUtil.isNotBlank((CharSequence)vo.getCustomerIds())) {
                        String[] split;
                        for (String id : split = vo.getCustomerIds().split(",")) {
                            if (!customerMap.containsKey(id)) continue;
                            CrmCustomerEntity customer1 = (CrmCustomerEntity)customerMap.get(id);
                            customerNameList.add(customer1.getName());
                        }
                    }
                    if (CollectionUtil.isNotEmpty((Collection)customerNameList)) {
                        customerNames = StrUtil.join((CharSequence)",", (Iterable)customerNameList);
                    }
                }
                if (StrUtil.isBlank((CharSequence)customerNames)) {
                    customerNames = this.saleContractCustomerService.getCustomerNamesByContractId(vo.getId());
                }
                vo.setCustomerNames(customerNames);
                vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
            }
            if ("1".equals(vo.getIsAgent())) {
                if (StringUtils.isNotEmpty((String)vo.getAgentId()) && null != (agent = agentMap.containsKey(vo.getAgentId()) ? (RkAgentEntity)agentMap.get(vo.getAgentId()) : this.agentService.getInfo(vo.getAgentId()))) {
                    vo.setAgentName(agent.getName());
                    vo.setAgentType(this.baseDataUtil.getDictName(agent.getType(), "agentType"));
                }
            } else {
                vo.setAgentName(vo.getCustomerNames());
            }
            vo.setEnableMarkDesc(this.baseDataUtil.getDictName(vo.getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
            vo.setSpecialTypeName(this.baseDataUtil.getDictName(vo.getSpecialType(), Constants.SPECIAL_TYPE_DICT));
            vo.setPromotionType(this.baseDataUtil.getDictName(vo.getPromotionType(), "promotionType"));
            List<RkContractReturnPlanEntity> planList = this.contractReturnPlanService.getPlanByContractId(vo.getId());
            vo.setPlanNum(planList.size());
            if (CollectionUtil.isNotEmpty(planList)) {
                vo.setPlanTotalReturnAmount(planList.stream().map(RkContractReturnPlanEntity::getReturnAmount).reduce(BigDecimal::add).get());
            }
            List collect = planList.stream().filter(x -> ContractReturnPlanUilts.checkIsOverdue(x)).collect(Collectors.toList());
            List collect1 = planList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getSendAmount())).collect(Collectors.toList());
            vo.setHavePaymentArrival(!CollectionUtil.isEmpty(collect1));
            if (!StrUtil.equals((CharSequence)vo.getEnableMark(), (CharSequence)ContractEnableMarkEnum.ENABLE_COMPLETED.getEnableMark())) {
                BigDecimal arrearsAmount = collect.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount().subtract(ObjectUtil.isEmpty((Object)y.getReturnAmount()) ? BigDecimal.ZERO : y.getReturnAmount())), BigDecimal::add);
                vo.setArrearsAmount(arrearsAmount);
                vo.setIsOverdue(CollectionUtil.isNotEmpty(collect) ? 1 : 0);
            } else {
                vo.setArrearsAmount(BigDecimal.ZERO);
                vo.setIsOverdue(0);
            }
            vo.setNotReturnAmount(MathUtils.substract(vo.getContractAmount(), vo.getReturnAmount()));
            List haveDueDateList = planList.stream().filter(s -> ObjectUtil.isNotNull((Object)s.getDueDate())).collect(Collectors.toList());
            BigDecimal totalReceiveAmount = haveDueDateList.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount()), BigDecimal::add);
            String nextReceiveAmount = MathUtils.substract(totalReceiveAmount + "", vo.getReturnAmount());
            if (new BigDecimal(nextReceiveAmount).compareTo(BigDecimal.ZERO) > 0) {
                vo.setNextReceiveAmount(nextReceiveAmount);
            } else {
                vo.setNextReceiveAmount("0");
            }
            List<RkContractPaymentEntity> listByContractId = this.contractPaymentService.getListByContractId(vo.getId());
            List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractPaymentListVO.class);
            vo.setPaymentList(jsonToList);
            if (StrUtil.isNotEmpty((CharSequence)vo.getSalesLiaison()) && StrUtil.isNotEmpty((CharSequence)(s2 = this.baseDataUtil.userSelectValues(vo.getSalesLiaison())))) {
                vo.setSalesLiaisonName(s2);
            }
            if (ObjectUtil.isNotEmpty((Object)vo.getIsAgent())) {
                if (StrUtil.equals((CharSequence)vo.getIsAgent(), (CharSequence)"1")) {
                    vo.setIsAgentDesc("\u6e20\u9053");
                } else {
                    vo.setIsAgentDesc("\u76f4\u7b7e");
                }
            }
            if (ObjectUtil.isNotEmpty((Object)(userInfo = this.serviceAllUtil.getUserInfo(vo.getSalesPerson())))) {
                OrganizeEntity organizeInfo = this.serviceAllUtil.getOrganizeInfo(userInfo.getOrganizeId());
                if (ObjectUtil.isNotEmpty((Object)organizeInfo)) {
                    vo.setSalerCompanyId(organizeInfo.getOrganizeId());
                }
                if (ObjectUtil.isNotEmpty((Object)vo.getSalerCompanyId())) {
                    CompanyIdEnum companyIdEnum = CompanyIdEnum.getCompanyIdEnum(vo.getSalerCompanyId());
                    if (companyIdEnum.getType().equals("ZY")) {
                        vo.setIsSealerLeader("\u662f");
                    } else {
                        vo.setIsSealerLeader("\u5426");
                    }
                } else {
                    vo.setIsSealerLeader("\u5426");
                }
            } else {
                vo.setIsSealerLeader("\u5426");
            }
            List<RkContractCollectionRecordEntity> collectionRecordList = this.rkContractCollectionRecordService.getListByContractId(vo.getId());
            if (CollectionUtil.isNotEmpty(collectionRecordList)) {
                vo.setIsReturnAmountRecord("\u662f");
            } else {
                vo.setIsReturnAmountRecord("\u5426");
            }
            List<RkContractProjectEntity> projectListByContractId = this.rkContractProjectService.getListByContractId(vo.getId());
            if (CollectionUtil.isNotEmpty(projectListByContractId)) {
                vo.setIsHaveProject("\u5df2\u8fdb\u573a");
            } else {
                vo.setIsHaveProject("\u672a\u8fdb\u573a");
            }
            RkContractSettlementEntity settlementEntity = this.rkContractSettlementService.getInfoByContractId(vo.getId());
            if (ObjectUtil.isNotEmpty((Object)settlementEntity)) {
                vo.setBaseFeeRate(settlementEntity.getBaseFeeRate());
                List<RkContractSettlementRecordEntity> settlementRecordList = this.rkContractSettlementRecordService.getListByContractId(settlementEntity.getContractId());
                if (CollectionUtil.isNotEmpty(settlementRecordList)) {
                    vo.setIsAdjust("1");
                }
            } else {
                this.settlementRate.getServiceFee(vo);
            }
            if (ObjectUtil.isNotEmpty((Object)vo.getBaseFeeRate()) && ObjectUtil.isNotEmpty((Object)vo.getValidContractAmount())) {
                vo.setBaseFeeAmount(vo.getValidContractAmount().multiply(vo.getBaseFeeRate()).setScale(2, 4));
            }
            if (vo.getIsHaveProject().equals("\u5df2\u8fdb\u573a") || vo.getIsReturnAmountRecord().equals("\u662f")) {
                vo.setThisBaseAmount(vo.getBaseFeeAmount());
            }
            if (ObjectUtil.isNotEmpty((Object)settlementEntity) && ObjectUtil.isNotEmpty((Object)settlementEntity.getSettlementAmount())) {
                vo.setSettlementAmount(settlementEntity.getSettlementAmount());
                vo.setNotSettlementAmount(settlementEntity.getNotSettlementAmount());
            }
            if (ObjectUtil.isEmpty((Object)vo.getNotSettlementAmount()) || vo.getNotSettlementAmount().compareTo(BigDecimal.ZERO) == 0) {
                vo.setNotSettlementAmount(vo.getThisBaseAmount());
            }
            if (ObjectUtil.isNotEmpty((Object)vo.getSettlementStatus())) {
                if (vo.getSettlementStatus().equals("notSettled")) {
                    vo.setSettlementStatusDesc("\u672a\u53d1\u8d77\u7ed3\u7b97");
                } else if (vo.getSettlementStatus().equals("settled")) {
                    vo.setSettlementStatusDesc("\u5df2\u7ed3\u7b97");
                    vo.setSettlementAmount(settlementEntity.getSettlementAmount());
                    vo.setNotSettlementAmount(settlementEntity.getNotSettlementAmount());
                    vo.setThisBaseAmount(settlementEntity.getThisBaseAmount());
                    vo.setBaseFeeRate(settlementEntity.getBaseFeeRate());
                    vo.setBaseFeeAmount(settlementEntity.getBaseFeeAmount());
                } else {
                    vo.setSettlementStatusDesc("\u7ed3\u7b97\u4e2d");
                }
            }
            vo.setIsCrossRegion(this.baseDataUtil.getDictName(vo.getIsCrossRegion(), "whether"));
            if (!isExport) {
                FlowTaskEntity flowTaskEntity;
                if (StrUtil.isNotEmpty((CharSequence)vo.getChangeTaskId())) {
                    flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getChangeTaskId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
                    if (flowTaskEntity != null) {
                        vo.setChangeFlowState(flowTaskEntity.getStatus());
                    } else {
                        vo.setChangeFlowState(null);
                    }
                }
                if (!StrUtil.isNotEmpty((CharSequence)vo.getVoidedTaskId())) continue;
                flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getVoidedTaskId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
                if (flowTaskEntity != null) {
                    vo.setVoidedFlowState(flowTaskEntity.getStatus());
                    continue;
                }
                vo.setVoidedFlowState(null);
                continue;
            }
            if (!ObjectUtil.isEmpty((Object)vo.getIsHaveAttachment()) && StrUtil.equals((CharSequence)vo.getIsHaveAttachment(), (CharSequence)"1")) {
                vo.setIsHaveAttachment("\u662f");
            } else {
                vo.setIsHaveAttachment("\u5426");
            }
            if (!ObjectUtil.isEmpty((Object)vo.getIsAgent()) && StrUtil.equals((CharSequence)vo.getIsAgent(), (CharSequence)"1")) {
                vo.setIsAgent("\u662f");
                continue;
            }
            vo.setIsAgent("\u5426");
        }
        return listVO;
    }

    @PostMapping(value={"/getByCompanyId/{companyId}"})
    public ActionResult getByCompanyId(@PathVariable(value="companyId") String companyId, @RequestBody RkContractPagination rkContractPagination) {
        List<RkContractEntity> result = this.rkContractService.listByCompanyId(companyId, rkContractPagination);
        List listVO = JsonUtil.getJsonToList(result, RkContractListVO.class);
        RkAgentEntity agent = null;
        for (RkContractListVO vo : listVO) {
            vo.setContractType(this.baseDataUtil.getDictName(vo.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
            if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
                vo.setCustomerNames(this.saleContractCustomerService.getCustomerNamesByContractId(vo.getId()));
                vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
            }
            if ("1".equals(vo.getIsAgent())) {
                if (!StringUtils.isNotEmpty((String)vo.getAgentId()) || null == (agent = this.agentService.getInfo(vo.getAgentId()))) continue;
                vo.setAgentName(agent.getName());
                vo.setAgentType(this.baseDataUtil.getDictName(agent.getType(), "agentType"));
                continue;
            }
            vo.setAgentName(vo.getCustomerNames());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        RkContractPaginationVO page = (RkContractPaginationVO)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractPagination), RkContractPaginationVO.class));
        vo.setPagination((PaginationVO)page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"countAmount"})
    public ActionResult countAmount(@RequestBody RkContractPagination rkContractPagination) {
        String organizeId = this.userProvider.get().getOrganizeId();
        UserInfo userInfo = this.userProvider.get();
        List<List<String>> region = rkContractPagination.getCustomerRegion();
        if (CollectionUtil.isNotEmpty(region)) {
            List searchRegion = CollectionUtil.list((boolean)false);
            region.stream().forEach(l -> searchRegion.add(l.get(0)));
            rkContractPagination.setSearchCustomerRegion(searchRegion);
        }
        Map<String, Object> stringObjectMap = this.rkContractService.countAmount(rkContractPagination);
        CountAmountVO countAmountVO = new CountAmountVO(rkContractPagination.getSignDate(), rkContractPagination.getCompanyId());
        Map<String, Object> map = this.contractCollectionRecordService.countAmount(countAmountVO);
        stringObjectMap.putAll(map);
        return ActionResult.success(stringObjectMap);
    }

    @GetMapping(value={"/middleman/{id}"})
    public ActionResult<RkAgentEntity> middleman(@PathVariable(value="id") String id) {
        RkContractEntity info = this.rkContractService.getInfo(id);
        if (DeleteMarkEnum.DELETE.getDeleteMark().compareTo(info.getIsAgent()) == 0) {
            RkAgentEntity agentEntity = this.rkAgentService.getInfo(info.getAgentId());
            return ActionResult.success((Object)agentEntity);
        }
        RkAgentEntity agentEntity = new RkAgentEntity();
        agentEntity.setName("\u65e0");
        return ActionResult.success((Object)agentEntity);
    }

    @PostMapping(value={"countAmountByPlan"})
    public ActionResult countAmountByPlan(@RequestBody RkContractPagination rkContractPagination) {
        String organizeId = this.userProvider.get().getOrganizeId();
        UserInfo userInfo = this.userProvider.get();
        List<List<String>> region = rkContractPagination.getCustomerRegion();
        if (CollectionUtil.isNotEmpty(region)) {
            List searchRegion = CollectionUtil.list((boolean)false);
            region.stream().forEach(l -> searchRegion.add(l.get(0)));
            rkContractPagination.setSearchCustomerRegion(searchRegion);
        }
        Map<String, Object> stringObjectMap = this.rkContractService.countAmountByPlan(rkContractPagination);
        List contractIdList = CollectionUtil.list((boolean)false);
        if (ObjectUtil.isNotNull(stringObjectMap) && ObjectUtil.isNotNull((Object)stringObjectMap.get("contractIdList"))) {
            contractIdList = JsonUtil.getJsonToList((Object)stringObjectMap.get("contractIdList"), String.class);
        }
        CountAmountVO countAmountVO = new CountAmountVO(rkContractPagination.getSignDate(), rkContractPagination.getCompanyId(), contractIdList, "contract");
        countAmountVO.setMenuId(rkContractPagination.getMenuId());
        Map<String, Object> collectionMap = this.contractCollectionRecordService.countAmountByContractIdList(countAmountVO);
        RkContractReturnPlanPagination returnPlanPagination = new RkContractReturnPlanPagination();
        returnPlanPagination.setCompanyId(rkContractPagination.getCompanyId());
        returnPlanPagination.setContractIdList(contractIdList);
        returnPlanPagination.setSearchType(countAmountVO.getSearchType());
        Map<String, Object> invoiceMap = this.contractInvoiceService.countAmountByContractIdList(countAmountVO);
        Map<String, Object> sendMap = this.contractReturnPlanService.countSendAmountByContractIdList(countAmountVO);
        Map<String, Object> overdueMap = this.contractReturnPlanService.countOverdueAmountByContractIdListOrPlan(returnPlanPagination);
        Map<String, Object> receivableAmount = this.contractReturnPlanService.countReceivableAmountByContractIdListOrPlan(returnPlanPagination);
        Map<String, Object> amountOfDueReceivables = this.contractReturnPlanService.countAmountOfDueReceivablesByContractIdListOrPlan(returnPlanPagination);
        stringObjectMap.putAll(collectionMap);
        stringObjectMap.putAll(invoiceMap);
        stringObjectMap.putAll(sendMap);
        stringObjectMap.putAll(overdueMap);
        stringObjectMap.putAll(receivableAmount);
        stringObjectMap.putAll(amountOfDueReceivables);
        return ActionResult.success(stringObjectMap);
    }

    @GetMapping(value={"/listSimple/{customerId}"})
    public ActionResult listSimple(@PathVariable(value="customerId") String customerId) {
        List enableMarkList = CollectionUtil.list((boolean)false);
        enableMarkList.add(ContractEnableMarkEnum.ENABLE_EXECUTE.getEnableMark());
        enableMarkList.add(ContractEnableMarkEnum.ENABLE_COMPLETED.getEnableMark());
        enableMarkList.add(ContractEnableMarkEnum.ENABLE_IMPROVED.getEnableMark());
        List<RkContractEntity> list = this.rkContractService.listSimpleByCustomerIdAndEnableMarkIn(customerId, enableMarkList);
        List listVO = JsonUtil.getJsonToList(list, RkContractListVO.class);
        for (RkContractListVO vo : listVO) {
            vo.setSalerId(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
            vo.setContractTypeDesc(this.baseDataUtil.getDictName(vo.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
            vo.setRegion(this.baseDataUtil.provinceData(vo.getRegion()));
            vo.setDepartment(this.baseDataUtil.comSelectValues(vo.getDepartmentTree()));
            vo.setIncomeType(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
            vo.setIndustryType(this.baseDataUtil.getDictName(vo.getIndustryType(), "industryType"));
            if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
                vo.setCustomerNames(this.saleContractCustomerService.getCustomerNamesByContractId(vo.getId()));
                vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
            }
            if ("1".equals(vo.getIsAgent())) {
                RkAgentEntity agent;
                if (!StringUtils.isNotEmpty((String)vo.getAgentId()) || null == (agent = this.agentService.getInfo(vo.getAgentId()))) continue;
                vo.setAgentName(agent.getName());
                continue;
            }
            vo.setAgentId(vo.getCustomerIds());
            vo.setAgentName(vo.getCustomerNames());
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(list, (String)"yyyy-MM-dd HH:mm:ss"));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().like(SaleNoContractEntity::getCustomerIds, (Object)customerId);
        queryWrapper.lambda().eq(SaleNoContractEntity::getCompanyId, (Object)this.userProvider.get().getOrganizeId());
        queryWrapper.lambda().eq(SaleNoContractEntity::getDeleteFlag, (Object)DeleteMarkEnum.NOT_DELETE.getDeleteMark());
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(SaleNoContractStatusEnum.UNRECOGNIZED_STATUS.getStatus());
        statusList.add(SaleNoContractStatusEnum.VERIFICATION_IN_PROGRESS_STATUS.getStatus());
        queryWrapper.lambda().in(SaleNoContractEntity::getStatus, statusList);
        List maps = this.saleNoContractService.listMaps((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)maps)) {
            String id = "";
            String customerIds = "";
            String agentId = "";
            for (Map map : maps) {
                id = String.valueOf(map.get("ID"));
                customerIds = String.valueOf(map.get("customerIds"));
                agentId = String.valueOf(map.get("agentId"));
                map.put("contractAmount", map.get("expectedContractAmount"));
                map.put("signDate", map.get("expectedSignDate"));
                map.put("isAgent", map.get("isAgent"));
                map.put("id", id);
                map.put("noContractId", id);
                if (StringUtils.isNotEmpty((String)customerIds)) {
                    map.put("customerNames", this.saleContractCustomerService.getCustomerNamesByContractId(id));
                    map.put("customerName", String.valueOf(map.get("customerNames")).split(",")[0]);
                }
                if ("1".equals(String.valueOf(map.get("isAgent")))) {
                    RkAgentEntity agent;
                    map.put("agentId", agentId);
                    if (!StringUtils.isNotEmpty((String)agentId) || null == (agent = this.agentService.getInfo(agentId))) continue;
                    map.put("agentName", agent.getName());
                    continue;
                }
                map.put("agentId", String.valueOf(map.get("customerIds")));
                map.put("agentName", String.valueOf(map.get("customerNames")));
            }
            mapList.addAll(maps);
        }
        return ActionResult.success((Object)mapList);
    }

    @GetMapping(value={"/listSimpleByAgent/{agentId}"})
    public ActionResult listSimpleByAgentId(@PathVariable(value="agentId") String agentId, String source, String enableMark) {
        List enableMarkList = CollectionUtil.list((boolean)false);
        if (StrUtil.isNotEmpty((CharSequence)enableMark)) {
            Object[] split = enableMark.split(",");
            List list = CollectionUtil.list((boolean)false, (Object[])split);
            enableMarkList.addAll(list);
        } else {
            enableMarkList.add(ContractEnableMarkEnum.ENABLE_EXECUTE.getEnableMark());
            enableMarkList.add(ContractEnableMarkEnum.ENABLE_COMPLETED.getEnableMark());
            if (StrUtil.isNotEmpty((CharSequence)source) && StrUtil.equals((CharSequence)source, (CharSequence)"notDraft")) {
                enableMarkList.add(ContractEnableMarkEnum.ENABLE_IMPROVED.getEnableMark());
                enableMarkList.add(ContractEnableMarkEnum.ENABLE_VOIDED.getEnableMark());
            }
        }
        List<RkContractEntity> list = this.rkContractService.listSimpleByAgentIdAndEnableMarkIn(agentId, enableMarkList);
        List listVO = JsonUtil.getJsonToList(list, RkContractListVO.class);
        for (RkContractListVO vo : listVO) {
            vo.setSalerId(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
            vo.setContractTypeDesc(this.baseDataUtil.getDictName(vo.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
            vo.setRegion(this.baseDataUtil.provinceData(vo.getRegion()));
            vo.setDepartment(this.baseDataUtil.comSelectValues(vo.getDepartmentTree()));
            vo.setIncomeType(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
            vo.setIndustryType(this.baseDataUtil.getDictName(vo.getIndustryType(), "industryType"));
            if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
                vo.setCustomerNames(this.saleContractCustomerService.getCustomerNamesByContractId(vo.getId()));
                vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
            }
            if ("1".equals(vo.getIsAgent())) {
                RkAgentEntity agent;
                if (!StringUtils.isNotEmpty((String)vo.getAgentId()) || null == (agent = this.agentService.getInfo(vo.getAgentId()))) continue;
                vo.setAgentName(agent.getName());
                continue;
            }
            vo.setAgentId(vo.getCustomerIds());
            vo.setAgentName(vo.getCustomerNames());
        }
        return ActionResult.success((Object)listVO);
    }

    @GetMapping(value={"/listSimpleByAgentAndCustomer/{agentId}/{customerId}"})
    public ActionResult listSimpleByAgentIdAndCustomerId(@PathVariable(value="agentId") String agentId, @PathVariable(value="customerId") String customerId, String enableMark) {
        List enableMarkList = CollectionUtil.list((boolean)false);
        if (StrUtil.isNotEmpty((CharSequence)enableMark)) {
            Object[] split = enableMark.split(",");
            List list = CollectionUtil.list((boolean)false, (Object[])split);
            enableMarkList.addAll(list);
        } else {
            enableMarkList.add(ContractEnableMarkEnum.ENABLE_EXECUTE.getEnableMark());
            enableMarkList.add(ContractEnableMarkEnum.ENABLE_COMPLETED.getEnableMark());
        }
        List<RkContractEntity> list = this.rkContractService.listSimpleByAgentIdAndCustomerIdAndEnableMarkIn(agentId, customerId, enableMarkList);
        List listVO = JsonUtil.getJsonToList(list, RkContractListVO.class);
        for (RkContractListVO vo : listVO) {
            vo.setSalerId(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
            vo.setContractTypeDesc(this.baseDataUtil.getDictName(vo.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
            vo.setRegion(this.baseDataUtil.provinceData(vo.getRegion()));
            vo.setDepartment(this.baseDataUtil.comSelectValues(vo.getDepartmentTree()));
            vo.setIncomeType(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
            vo.setIndustryType(this.baseDataUtil.getDictName(vo.getIndustryType(), "industryType"));
            if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
                vo.setCustomerNames(this.saleContractCustomerService.getCustomerNamesByContractId(vo.getId()));
                vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
            }
            if ("1".equals(vo.getIsAgent())) {
                RkAgentEntity agent;
                if (!StringUtils.isNotEmpty((String)vo.getAgentId()) || null == (agent = this.agentService.getInfo(vo.getAgentId()))) continue;
                vo.setAgentName(agent.getName());
                continue;
            }
            vo.setAgentId(vo.getCustomerIds());
            vo.setAgentName(vo.getCustomerNames());
        }
        return ActionResult.success((Object)listVO);
    }

    public static void main(String[] args) {
        String letter = PinyinUtil.getFirstLetter((String)"\u90d1\u5dde\u5927\u5b66\u7b2c\u4e00\u9644\u5c5e\u533b\u9662", (String)"");
        System.out.println("\u4f60\u597d\u7684\u9996\u5b57\u6bcd\uff1a" + letter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping(value={"/createPayment"})
    public synchronized ActionResult createPayment(@RequestBody @Valid RkContractUpForm rkContractUpForm) {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            RkContractEntity entity = this.rkContractService.getInfo(rkContractUpForm.getId());
            if (entity != null) {
                entity.setPaymentDescription(rkContractUpForm.getPaymentDescription());
                entity.setPaymentMethod(rkContractUpForm.getPaymentMethod());
                this.rkContractService.update(entity.getId(), entity);
                HashMap map = this.rkContractService.updatePayment(rkContractUpForm);
                if (ObjectUtil.isEmpty(map.get("error"))) {
                    return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
                }
                return ActionResult.fail((String)map.get("error").toString());
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    @PostMapping(value={"/financial"})
    public ActionResult financial(@ParamAddress(field="customerAddress") @RequestBody RkContractPagination rkContractPagination) {
        UserInfo userInfo = this.userProvider.get();
        rkContractPagination.setEnableMark(CollectionUtil.list((boolean)false, (Object[])new String[]{ContractEnableMarkEnum.ENABLE_EXECUTE.getEnableMark()}));
        List<RkContractEntity> contractEntityList = this.rkContractService.getList(rkContractPagination);
        PageListVO vo = new PageListVO();
        vo.setList(this.handContractFinancial(contractEntityList, false));
        RkContractPaginationVO page = (RkContractPaginationVO)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractPagination), RkContractPaginationVO.class));
        vo.setPagination((PaginationVO)page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/financial/Export"})
    public ActionResult export(@RequestBody RkContractPaginationExportModel rkContractPaginationExportModel) {
        if (StringUtil.isEmpty((String)rkContractPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkContractPagination rkContractPagination = (RkContractPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractPaginationExportModel), RkContractPagination.class));
        String organizeId = this.userProvider.get().getOrganizeId();
        rkContractPagination.setEnableMark(CollectionUtil.list((boolean)false, (Object[])new String[]{ContractEnableMarkEnum.ENABLE_EXECUTE.getEnableMark()}));
        List<List<String>> region = rkContractPagination.getCustomerRegion();
        if (CollectionUtil.isNotEmpty(region)) {
            List searchRegion = CollectionUtil.list((boolean)false);
            region.stream().forEach(l -> searchRegion.add(l.get(0)));
            rkContractPagination.setSearchCustomerRegion(searchRegion);
        }
        List<RkContractEntity> list = this.rkContractService.getTypeList(rkContractPagination, rkContractPaginationExportModel.getDataType());
        List<RkContractReturnPlanOverdueListVO> listVO = this.handContractFinancial(list, true);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd"));
        String[] keys = !StringUtil.isEmpty((String)rkContractPaginationExportModel.getSelectKey()) ? rkContractPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo, "financial");
        return ActionResult.success((Object)vo);
    }

    private List<RkContractReturnPlanOverdueListVO> handContractFinancial(List<RkContractEntity> contractEntityList, boolean isExport) {
        HashMap map = MapUtil.newHashMap();
        HashMap customerMap = MapUtil.newHashMap();
        HashMap agentMap = MapUtil.newHashMap();
        HashMap contractTypeMap = MapUtil.newHashMap();
        if (isExport) {
            List<CrmCustomerEntity> companyCustomer = this.crmCustomerService.getCompanyCustomer();
            companyCustomer.stream().forEach(x -> customerMap.put(x.getId(), x));
            this.rkAgentService.listSimpleIdAndName().stream().forEach(x -> agentMap.put(x.getId(), x));
        }
        UserInfo userInfo = this.userProvider.get();
        List returnList = CollectionUtil.list((boolean)false);
        for (RkContractEntity entity : contractEntityList) {
            List nowMonth;
            CountAmountVO countAmountVO;
            Map<String, Object> collectionMap;
            String s;
            RkContractReturnPlanOverdueListVO overdueListVO;
            CrmCustomerEntity byId = (CrmCustomerEntity)customerMap.get(entity.getCustomerId());
            if (ObjectUtil.isEmpty((Object)byId)) {
                byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()));
                customerMap.put(entity.getCustomerId(), byId);
            }
            if (!ObjectUtil.isEmpty((Object)byId)) {
                entity.setCustomerName(byId.getName());
            }
            if (!ObjectUtil.isEmpty((Object)entity.getIsAgent()) && entity.getIsAgent() == 1) {
                RkAgentEntity agentEntity = (RkAgentEntity)agentMap.get(entity.getAgentId());
                if (ObjectUtil.isEmpty((Object)agentEntity)) {
                    agentEntity = (RkAgentEntity)this.agentService.getById((Serializable)((Object)entity.getAgentId()));
                    agentMap.put(entity.getAgentId(), agentEntity);
                }
                entity.setAgentId(ObjectUtil.isEmpty((Object)entity.getAgentId()) ? "" : agentEntity.getName());
            }
            if (!ObjectUtil.isEmpty((Object)entity.getIsAgent()) && entity.getIsAgent() == 0) {
                entity.setAgentId(entity.getCustomerName());
            }
            if (StrUtil.isNotEmpty((CharSequence)(overdueListVO = (RkContractReturnPlanOverdueListVO)JsonUtil.getJsonToBean((Object)entity, RkContractReturnPlanOverdueListVO.class)).getCompanyId())) {
                OrganizeEntity byId2 = this.organizeService.getInfo(overdueListVO.getCompanyId());
                if (ObjectUtil.isNotNull((Object)byId)) {
                    OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)byId2.getPropertyJson(), OrganizeCrModel.class);
                    overdueListVO.setCompanyName(jsonToBean.getShortName());
                }
            }
            if (ObjectUtil.isEmpty((Object)(s = (String)contractTypeMap.get(overdueListVO.getContractType())))) {
                s = this.baseDataUtil.getDictName(overdueListVO.getContractType(), "contractType");
                contractTypeMap.put(overdueListVO.getContractType(), s);
            }
            overdueListVO.setContractType(s);
            if (StrUtil.isNotEmpty((CharSequence)entity.getSalerName())) {
                overdueListVO.setSalerId(entity.getSalerName());
            } else if (StrUtil.isNotEmpty((CharSequence)entity.getSalerId())) {
                overdueListVO.setSalerId(this.baseDataUtil.userSelectValueNoAccount(entity.getSalerId()));
            }
            List<RkContractProjectEntity> acceptListByContractId = this.contractProjectService.getAcceptListByContractId(entity.getId());
            if (CollectionUtil.isNotEmpty(acceptListByContractId)) {
                overdueListVO.setAcceptanceTime(acceptListByContractId.get(0).getAcceptanceTime());
            }
            if (CollectionUtil.isNotEmpty(collectionMap = this.contractCollectionRecordService.countAmount(countAmountVO = new CountAmountVO((List<Date>)(nowMonth = CollectionUtil.list((boolean)false, (Object[])new Date[]{DateUtil.getBeginDayOfMonth(), DateUtil.getEndDayOfMonth()})), userInfo.getOrganizeId(), entity.getId())))) {
                Object totalReturnAmount = collectionMap.get("totalReturnAmount");
                overdueListVO.setNowMonthReturnAmount(new BigDecimal(totalReturnAmount.toString()));
            } else {
                overdueListVO.setNowMonthReturnAmount(BigDecimal.ZERO);
            }
            List<RkContractReturnPlanEntity> listOverdueTypeByContractId = this.contractReturnPlanService.getListOverdueTypeByContractIdAndCompanyId(entity.getId(), userInfo.getOrganizeId(), entity);
            if (CollectionUtil.isNotEmpty(listOverdueTypeByContractId)) {
                List<String> collect = listOverdueTypeByContractId.stream().map(RkContractReturnPlanEntity::getId).collect(Collectors.toList());
                List<RkReturnPlanTrackingEntity> trackingEntityList = this.rkReturnPlanTrackingService.getListByContactIdAndPlanIdIn(entity.getId(), collect);
                if (CollectionUtil.isNotEmpty(trackingEntityList)) {
                    String dicNameList;
                    String[] split;
                    RkReturnPlanTrackingEntity trackingEntity = trackingEntityList.get(0);
                    if (StrUtil.isNotEmpty((CharSequence)trackingEntity.getCommunicationProgress())) {
                        split = trackingEntity.getCommunicationProgress().split(",");
                        dicNameList = this.baseDataUtil.getDictName(trackingEntity.getCommunicationProgress(), "communicationProgress");
                        overdueListVO.setCommunicationProgress(dicNameList);
                    }
                    if (StrUtil.isNotEmpty((CharSequence)trackingEntity.getNotReturnType())) {
                        split = trackingEntity.getNotReturnType().split(",");
                        dicNameList = this.baseDataUtil.getDictName(trackingEntity.getNotReturnType(), "notReturnType");
                        overdueListVO.setNotReturnType(dicNameList);
                    }
                    overdueListVO.setNotReturnReason(trackingEntity.getNotReturnReason());
                }
            }
            BigDecimal totalOverdueAmount = BigDecimal.ZERO;
            Date dueDate = DateUtil.getNowDate();
            for (RkContractReturnPlanEntity plan : listOverdueTypeByContractId) {
                long overdueDays = 0L;
                if (!ObjectUtil.isEmpty((Object)plan.getDueDate())) {
                    long l = DateUtil.getDiffDays((Date)DateUtil.getDayBegin(), (Date)plan.getDueDate());
                    if (l < 0L) {
                        overdueDays = l * -1L;
                    }
                    if (plan.getDueDate().before(dueDate)) {
                        dueDate = plan.getDueDate();
                    }
                    overdueListVO.setDueDate(dueDate);
                }
                if (StrUtil.isNotEmpty((CharSequence)plan.getPaymentType())) {
                    DictionaryDataEntity info1 = (DictionaryDataEntity)map.get(plan.getPaymentType());
                    if (ObjectUtil.isEmpty((Object)info1)) {
                        info1 = this.dictionaryDataService.getInfo(plan.getPaymentType());
                        map.put(plan.getPaymentType(), info1);
                    }
                    if (ObjectUtil.isNotNull((Object)info1)) {
                        if (StrUtil.equals((CharSequence)info1.getEnCode(), (CharSequence)"advanceCharge")) {
                            overdueListVO.setAdvanceChargeAmount(MathUtils.substract(plan.getReceivableAmount(), plan.getReturnAmount()));
                            overdueListVO.setAdvanceChargeOverdue(overdueDays);
                            totalOverdueAmount = MathUtils.add(totalOverdueAmount, overdueListVO.getAdvanceChargeAmount());
                        }
                        if (StrUtil.equals((CharSequence)info1.getEnCode(), (CharSequence)"paymentArrival")) {
                            overdueListVO.setPaymentArrivalAmount(MathUtils.substract(plan.getReceivableAmount(), plan.getReturnAmount()));
                            overdueListVO.setPaymentArrivalOverdue(overdueDays);
                            totalOverdueAmount = MathUtils.add(totalOverdueAmount, overdueListVO.getPaymentArrivalAmount());
                        }
                        if (StrUtil.equals((CharSequence)info1.getEnCode(), (CharSequence)"retentionMoney")) {
                            overdueListVO.setRetentionMoneyAmount(MathUtils.substract(plan.getReceivableAmount(), plan.getReturnAmount()));
                            overdueListVO.setRetentionMoneyOverdue(overdueDays);
                            totalOverdueAmount = MathUtils.add(totalOverdueAmount, overdueListVO.getRetentionMoneyAmount());
                        }
                        if (StrUtil.equals((CharSequence)info1.getEnCode(), (CharSequence)"acceptancePayment")) {
                            overdueListVO.setAcceptancePaymentAmount(MathUtils.substract(plan.getReceivableAmount(), plan.getReturnAmount()));
                            overdueListVO.setAcceptancePaymentOverdue(overdueDays);
                            totalOverdueAmount = MathUtils.add(totalOverdueAmount, overdueListVO.getAcceptancePaymentAmount());
                        }
                    }
                }
                overdueListVO.setArrearsAmount(totalOverdueAmount);
            }
            returnList.add(overdueListVO);
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public synchronized ActionResult create(@RequestBody @Valid RkContractCrForm rkContractCrForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            rkContractCrForm.setCompanyId(userInfo.getOrganizeId());
            if (StrUtil.isNotBlank((CharSequence)rkContractCrForm.getSalesLiaison())) {
                rkContractCrForm.setSalesLiaisonName(this.baseDataUtil.userSelectValues(rkContractCrForm.getSalesLiaison()));
                UserEntity byId = (UserEntity)this.userService.getById((Serializable)((Object)rkContractCrForm.getSalesLiaison()));
                rkContractCrForm.setLiaisonDepartment(byId.getOrganizeId());
                rkContractCrForm.setLiaisonCompany(this.userService.getUserCompany(rkContractCrForm.getSalesLiaison()));
            }
            rkContractCrForm.setJcContractTypeName(this.baseDataUtil.getDictName(rkContractCrForm.getJcContractType(), "jcContractType"));
            HashMap contract = this.rkContractService.createContract(rkContractCrForm);
            if (ObjectUtil.isEmpty(contract.get("error"))) {
                return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
            }
            return ActionResult.fail((String)contract.get("error").toString());
        }
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @PostMapping(value={"/Actions/Export"})
    public ActionResult Export(@RequestBody RkContractPaginationExportModel rkContractPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkContractPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkContractPagination rkContractPagination = (RkContractPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractPaginationExportModel), RkContractPagination.class));
        String organizeId = this.userProvider.get().getOrganizeId();
        List<List<String>> region = rkContractPagination.getCustomerRegion();
        if (CollectionUtil.isNotEmpty(region)) {
            List searchRegion = CollectionUtil.list((boolean)false);
            region.stream().forEach(l -> searchRegion.add(l.get(0)));
            rkContractPagination.setSearchCustomerRegion(searchRegion);
        }
        List<RkContractEntity> list = this.rkContractService.getTypeList(rkContractPagination, rkContractPaginationExportModel.getDataType());
        List<RkContractListVO> listVO = this.appendListVo(list, true);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd"));
        String[] keys = !StringUtil.isEmpty((String)rkContractPaginationExportModel.getSelectKey()) ? rkContractPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo, "contract");
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo, String type) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block148: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block148;
                    }
                    case "customerProvName": {
                        entitys.add(new ExcelExportEntity("\u7701\u4efd", (Object)"customerProvName"));
                        continue block148;
                    }
                    case "salerCompanyName": {
                        entitys.add(new ExcelExportEntity("\u8425\u9500\u5e73\u53f0", (Object)"salerCompanyName"));
                        continue block148;
                    }
                    case "yongYou": {
                        entitys.add(new ExcelExportEntity("\u7528\u53cbU8\u8d26\u53f7", (Object)"yongYou"));
                        continue block148;
                    }
                    case "promotionType": {
                        entitys.add(new ExcelExportEntity("\u63a8\u5e7f\u7c7b\u578b", (Object)"promotionType"));
                        continue block148;
                    }
                    case "agentId": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u5bf9\u8c61", (Object)"agentId"));
                        continue block148;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u5bf9\u8c61", (Object)"agentName"));
                        continue block148;
                    }
                    case "customerId": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerId"));
                        continue block148;
                    }
                    case "customerNames": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerNames"));
                        continue block148;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block148;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block148;
                    }
                    case "contractAmount": {
                        ExcelExportEntity contractAmount = new ExcelExportEntity("\u5408\u540c\u91d1\u989d\uff08\u5143\uff09", (Object)"contractAmount");
                        contractAmount.setType(10);
                        entitys.add(contractAmount);
                        continue block148;
                    }
                    case "signDate": {
                        entitys.add(new ExcelExportEntity("\u7b7e\u8ba2\u65e5\u671f", (Object)"signDate"));
                        continue block148;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u5f55\u5165\u65e5\u671f", (Object)"creatorTime"));
                        continue block148;
                    }
                    case "passTime": {
                        entitys.add(new ExcelExportEntity("\u901a\u8fc7\u65e5\u671f", (Object)"passTime"));
                        continue block148;
                    }
                    case "enableMark": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u72b6\u6001", (Object)"enableMark"));
                        continue block148;
                    }
                    case "enableMarkDesc": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u72b6\u6001", (Object)"enableMarkDesc"));
                        continue block148;
                    }
                    case "contractType": {
                        if (StrUtil.equals((CharSequence)type, (CharSequence)"contract")) {
                            entitys.add(new ExcelExportEntity("\u5408\u540c\u7c7b\u578b", (Object)"contractType"));
                            continue block148;
                        }
                        entitys.add(new ExcelExportEntity("\u4e1a\u52a1\u5c5e\u6027", (Object)"contractType"));
                        continue block148;
                    }
                    case "contractTypeName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7c7b\u578b", (Object)"contractTypeName"));
                        continue block148;
                    }
                    case "salerId": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u4eba\u5458", (Object)"salerId"));
                        continue block148;
                    }
                    case "salesLiaisonName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5bf9\u63a5\u4eba", (Object)"salesLiaisonName"));
                        continue block148;
                    }
                    case "department": {
                        entitys.add(new ExcelExportEntity("\u90e8\u95e8", (Object)"department"));
                        continue block148;
                    }
                    case "region": {
                        entitys.add(new ExcelExportEntity("\u5927\u533a", (Object)"region"));
                        continue block148;
                    }
                    case "customerRegion": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u533a\u57df(\u6700\u7ec8\u7528\u6237\u6240\u5728\u533a\u57df)", (Object)"customerRegion"));
                        continue block148;
                    }
                    case "incomeType": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5927\u7c7b", (Object)"incomeTypeName"));
                        continue block148;
                    }
                    case "industryType": {
                        entitys.add(new ExcelExportEntity("\u884c\u4e1a\u7c7b\u578b", (Object)"industryType"));
                        continue block148;
                    }
                    case "profit": {
                        ExcelExportEntity profit = new ExcelExportEntity("\u6bdb\u5229\u6da6\uff08\u5143\uff09", (Object)"profit");
                        profit.setType(10);
                        entitys.add(profit);
                        continue block148;
                    }
                    case "isAgent": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u4ee3\u7406\u5408\u540c", (Object)"isAgent"));
                        continue block148;
                    }
                    case "agentType": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u5bf9\u8c61\u7c7b\u578b", (Object)"agentType"));
                        continue block148;
                    }
                    case "returnAmount": {
                        ExcelExportEntity returnAmount = new ExcelExportEntity("\u5df2\u56de\u6b3e\u91d1\u989d\uff08\u5143\uff09", (Object)"returnAmount");
                        returnAmount.setType(10);
                        entitys.add(returnAmount);
                        continue block148;
                    }
                    case "returnRatio": {
                        entitys.add(new ExcelExportEntity("\u5df2\u56de\u6b3e\u6bd4\u4f8b(%)", (Object)"returnRatio"));
                        continue block148;
                    }
                    case "warranty": {
                        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u671f\u9650(\u6708)", (Object)"warranty"));
                        continue block148;
                    }
                    case "arrearsAmount": {
                        ExcelExportEntity arrearsAmount;
                        if (StrUtil.equals((CharSequence)type, (CharSequence)"contract")) {
                            arrearsAmount = new ExcelExportEntity("\u6536\u6b3e\u903e\u671f\u56de\u6b3e\uff08\u5143\uff09", (Object)"arrearsAmount");
                            arrearsAmount.setType(10);
                            entitys.add(arrearsAmount);
                            continue block148;
                        }
                        arrearsAmount = new ExcelExportEntity("\u5df2\u8d85\u671f\u91d1\u989d\u5408\u8ba1\uff08\u5143\uff09", (Object)"arrearsAmount");
                        arrearsAmount.setType(10);
                        entitys.add(arrearsAmount);
                        continue block148;
                    }
                    case "paymentMethod": {
                        entitys.add(new ExcelExportEntity("\u4ed8\u6b3e\u65b9\u5f0f", (Object)"paymentMethod"));
                        continue block148;
                    }
                    case "isHaveAttachment": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u5df2\u4e0a\u4f20\u9644\u4ef6", (Object)"isHaveAttachment"));
                        continue block148;
                    }
                    case "expectedReturnTime": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u8fd4\u56de\u65e5\u671f", (Object)"expectedReturnTime"));
                        continue block148;
                    }
                    case "departmentTreeName": {
                        entitys.add(new ExcelExportEntity("\u533a\u57df", (Object)"departmentTreeName"));
                        continue block148;
                    }
                    case "paymentDescription": {
                        entitys.add(new ExcelExportEntity("\u4ed8\u6b3e\u65b9\u5f0f", (Object)"paymentDescription"));
                        continue block148;
                    }
                    case "nowMonthReturnAmount": {
                        ExcelExportEntity profit = new ExcelExportEntity("\u5f53\u6708\u56de\u6b3e\u91d1\u989d\uff08\u5143\uff09", (Object)"nowMonthReturnAmount");
                        profit.setType(10);
                        entitys.add(profit);
                        continue block148;
                    }
                    case "advanceChargeAmount": {
                        ExcelExportEntity profit = new ExcelExportEntity("\u9884\u4ed8\u6b3e\uff08\u5143\uff09", (Object)"advanceChargeAmount");
                        profit.setType(10);
                        entitys.add(profit);
                        continue block148;
                    }
                    case "advanceChargeOverdue": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u8d85\u671f\u5929\u6570", (Object)"advanceChargeOverdue");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block148;
                    }
                    case "paymentArrivalAmount": {
                        ExcelExportEntity profit = new ExcelExportEntity("\u5230\u8d27\u6b3e\uff08\u5143\uff09", (Object)"paymentArrivalAmount");
                        profit.setType(10);
                        entitys.add(profit);
                        continue block148;
                    }
                    case "paymentArrivalOverdue": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u8d85\u671f\u5929\u6570", (Object)"paymentArrivalOverdue");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block148;
                    }
                    case "retentionMoneyAmount": {
                        ExcelExportEntity profit = new ExcelExportEntity("\u8d28\u4fdd\u6b3e\uff08\u5143\uff09", (Object)"retentionMoneyAmount");
                        profit.setType(10);
                        entitys.add(profit);
                        continue block148;
                    }
                    case "retentionMoneyOverdue": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u8d85\u671f\u5929\u6570", (Object)"retentionMoneyOverdue");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block148;
                    }
                    case "acceptancePaymentAmount": {
                        ExcelExportEntity profit = new ExcelExportEntity("\u9a8c\u6536\u6b3e\uff08\u5143\uff09", (Object)"acceptancePaymentAmount");
                        profit.setType(10);
                        entitys.add(profit);
                        continue block148;
                    }
                    case "acceptancePaymentOverdue": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u8d85\u671f\u5929\u6570", (Object)"acceptancePaymentOverdue");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block148;
                    }
                    case "dueDate": {
                        entitys.add(new ExcelExportEntity("\u5e94\u56de\u6b3e\u65e5\u671f", (Object)"dueDate"));
                        continue block148;
                    }
                    case "actSendAmount": {
                        ExcelExportEntity profit = new ExcelExportEntity("\u53d1\u8d27\u91d1\u989d\uff08\u5143\uff09", (Object)"actSendAmount");
                        profit.setType(10);
                        entitys.add(profit);
                        continue block148;
                    }
                    case "lastSendTime": {
                        entitys.add(new ExcelExportEntity("\u6700\u540e\u4e00\u7b14\u53d1\u8d27\u65e5\u671f", (Object)"lastSendTime"));
                        continue block148;
                    }
                    case "acceptanceTime": {
                        entitys.add(new ExcelExportEntity("\u9a8c\u6536\u65e5\u671f", (Object)"acceptanceTime"));
                        continue block148;
                    }
                    case "invoiceAmount": {
                        ExcelExportEntity profit = new ExcelExportEntity("\u5f00\u7968\u91d1\u989d\uff08\u5143\uff09", (Object)"invoiceAmount");
                        profit.setType(10);
                        entitys.add(profit);
                        continue block148;
                    }
                    case "communicationProgress": {
                        entitys.add(new ExcelExportEntity("\u6c9f\u901a\u8fdb\u5ea6", (Object)"communicationProgress"));
                        continue block148;
                    }
                    case "notReturnReason": {
                        entitys.add(new ExcelExportEntity("\u672a\u56de\u6b3e\u539f\u56e0", (Object)"notReturnReason"));
                        continue block148;
                    }
                    case "notReturnType": {
                        entitys.add(new ExcelExportEntity("\u672a\u56de\u6b3e\u539f\u56e0\u5206\u7c7b", (Object)"notReturnType"));
                        continue block148;
                    }
                    case "remark": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"remark"));
                        continue block148;
                    }
                    case "contractAmountDesc": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u91d1\u989d\uff08\u5143\uff09", (Object)"contractAmountDesc"));
                        continue block148;
                    }
                    case "validContractAmount": {
                        ExcelExportEntity validContractAmount = new ExcelExportEntity("\u6709\u6548\u5408\u540c\u91d1\u989d\uff08\u5143\uff09", (Object)"validContractAmount");
                        validContractAmount.setType(10);
                        entitys.add(validContractAmount);
                        continue block148;
                    }
                    case "managerType": {
                        entitys.add(new ExcelExportEntity("\u7ba1\u7406\u5206\u7c7b", (Object)"managerType"));
                        continue block148;
                    }
                    case "amountExcludingTax": {
                        ExcelExportEntity amountExcludingTax = new ExcelExportEntity("\u4e0d\u542b\u7a0e\u91d1\u989d\uff08\u5143\uff09", (Object)"amountExcludingTax");
                        amountExcludingTax.setType(10);
                        entitys.add(amountExcludingTax);
                        continue block148;
                    }
                    case "archivedTime": {
                        entitys.add(new ExcelExportEntity("\u5f52\u6863\u65e5\u671f", (Object)"archivedTime"));
                        continue block148;
                    }
                    case "contractArchiveType": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u6863\u6848\u5206\u7c7b", (Object)"contractArchiveType"));
                        continue block148;
                    }
                    case "contractTaxRate": {
                        entitys.add(new ExcelExportEntity("\u7a0e\u7387", (Object)"contractTaxRate"));
                        continue block148;
                    }
                    case "contractContent": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u5185\u5bb9", (Object)"contractContent"));
                        continue block148;
                    }
                    case "shallMentionAmount": {
                        ExcelExportEntity shallMentionAmount = new ExcelExportEntity("\u5e94\u63d0\u91d1\u989d\uff08\u5143\uff09", (Object)"shallMentionAmount");
                        shallMentionAmount.setType(10);
                        entitys.add(shallMentionAmount);
                        continue block148;
                    }
                    case "businessAmount": {
                        ExcelExportEntity businessAmount = new ExcelExportEntity("\u4e1a\u52a1\u91d1\u989d\uff08\u5143\uff09", (Object)"businessAmount");
                        businessAmount.setType(10);
                        entitys.add(businessAmount);
                        continue block148;
                    }
                    case "jcContractTypeName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7c7b\u578b", (Object)"jcContractTypeName"));
                        continue block148;
                    }
                    case "isCrossRegion": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u8de8\u533a\u57df", (Object)"isCrossRegion"));
                        continue block148;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "";
                name = StrUtil.equals((CharSequence)type, (CharSequence)"contract") ? "\u5408\u540c\u62a5\u8868" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx" : "\u8d22\u52a1\u7edf\u8ba1" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @PostMapping(value={"/Actions/Export/getCompanyContractStatisticsLedger"})
    public ActionResult exportCompanyContract(@RequestBody RkContractPaginationExportModel rkContractPaginationExportModel) throws IOException {
        DownloadVO downloadVO = this.rkContractService.exportCompanyContract(rkContractPaginationExportModel);
        return ActionResult.success((Object)downloadVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/batchRemove/{ids}"})
    @DSTransactional
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        Object object = this.$lock;
        synchronized (object) {
            String[] idList = ids.split(",");
            int i = 0;
            for (String allId : idList) {
                this.delete(allId);
                ++i;
            }
            if (i == 0) {
                return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25");
            }
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractInfoVO> info(@PathVariable(value="id") String id) {
        RkContractEntity entity = this.rkContractService.getInfo(id);
        RkContractInfoVO vo = null;
        if (null != entity) {
            Map<String, Object> temp;
            SaleNoContractEntity noContract;
            SaleQuotationProfitEntity profit;
            String userSelectValue;
            SaleQuotationEntity quotation;
            List<RkAttachmentEntity> attachmentEntityList;
            List attachmentList;
            UserEntity byId;
            String[] split;
            vo = (RkContractInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractInfoVO.class);
            if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
                vo.setCustomerNames(this.saleContractCustomerService.getCustomerNamesByContractId(vo.getId()));
                vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
                vo.setCustomerList(this.saleContractCustomerService.getListByContractId(vo.getId()));
            }
            if ("1".equals(vo.getIsAgent()) && StringUtils.isNotEmpty((String)vo.getAgentId())) {
                RkAgentEntity agent = this.agentService.getInfo(vo.getAgentId());
                if (null != agent) {
                    vo.setAgentName(agent.getName());
                    vo.setAgentNames(agent.getName());
                }
            } else {
                vo.setAgentName(vo.getCustomerName());
                vo.setAgentNames(vo.getCustomerNames());
            }
            if (StrUtil.isNotEmpty((CharSequence)entity.getDepartmentTree())) {
                split = entity.getDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",");
                vo.setDepartmentTree(Arrays.asList(split));
            }
            if (StrUtil.isNotEmpty((CharSequence)entity.getDepartmentTree())) {
                split = entity.getDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",");
                vo.setDepartmentTree(Arrays.asList(split));
            }
            vo.setNotSaleInvoiceAmount(MathUtils.substract(vo.getContractAmount(), vo.getSaleInvoiceAmount()));
            vo.setSalerName(entity.getSalerName());
            vo.setContractTypeDesc(this.baseDataUtil.getDictName(entity.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
            vo.setIndustryTypeDesc(this.baseDataUtil.getDictName(entity.getIndustryType(), "industryType"));
            vo.setIncomeTypeDesc(this.crmProductCategoryService.getNameByIds(entity.getIncomeType()));
            vo.setRegionName(entity.getRegionName());
            vo.setIsNeedPayAdvance(entity.getIsNeedPayAdvance());
            vo.setIsStamp(entity.getIsStamp());
            vo.setIsSubcontract(entity.getIsSubcontract());
            vo.setProfitAmount(entity.getProfitAmount());
            if (StrUtil.isNotEmpty((CharSequence)vo.getSalerId()) && ObjectUtil.isNotNull((Object)(byId = this.userService.getInfo(vo.getSalerId())))) {
                vo.setSalerManager(this.baseDataUtil.userSelectValues(byId.getManagerId()));
            }
            if (ObjectUtil.isEmpty((Object)vo.getInvoiceAmount())) {
                vo.setInvoiceAmount(BigDecimal.ZERO);
                vo.setInvoiceProportion(BigDecimal.ZERO);
            } else {
                vo.setInvoiceAmount(entity.getInvoiceAmount());
            }
            vo.setDepartmentName(entity.getDepartmentTreeName());
            if (!ObjectUtil.isEmpty((Object)vo.getIsArchived()) && StrUtil.equals((CharSequence)vo.getIsArchived(), (CharSequence)"1")) {
                vo.setArchivedLocation(this.baseDataUtil.getDictName(vo.getArchivedLocation(), Constants.ARCHIVELOCATION_DICT_ID));
                vo.setArchivedBy(this.baseDataUtil.userSelectValueNoAccount(vo.getArchivedBy()));
            }
            vo.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
            List<RkContractPaymentEntity> listByContractId = this.contractPaymentService.getListByContractId(id);
            List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractPaymentListVO.class);
            vo.setPaymentList(jsonToList);
            List<RkContractTaxEntity> rkContractTaxEntities = this.contractTaxService.listByContractId(id);
            List jsonToList1 = JsonUtil.getJsonToList(rkContractTaxEntities, RkContractTaxInfoVO.class);
            vo.setTaxList(jsonToList1);
            List<RkContractReturnPlanEntity> planList = this.contractReturnPlanService.getPlanByContractId(vo.getId());
            if (CollectionUtil.isNotEmpty(planList)) {
                BigDecimal bigDecimal = planList.stream().map(RkContractReturnPlanEntity::getReceivableAmount).reduce(BigDecimal::add).get();
                vo.setPlanTotalAmount(bigDecimal);
                BigDecimal bigDecimal1 = planList.stream().map(RkContractReturnPlanEntity::getReturnAmount).reduce(BigDecimal::add).get();
                vo.setPlanTotalReturnAmount(bigDecimal1);
            }
            if (CollectionUtil.isNotEmpty((Collection)(attachmentList = JsonUtil.getJsonToList(attachmentEntityList = this.attachmentService.getListByContractIdAndFileType(id, AttachmentTypeEnum.CONTRACT_TYPE.getType()), RkAttachmentCrForm.class)))) {
                vo.setAttachmentList(attachmentList);
            } else {
                vo.setAttachmentList(new ArrayList<RkAttachmentCrForm>());
            }
            attachmentEntityList = this.attachmentService.getListByContractIdAndFileType(id, AttachmentTypeEnum.DOUBLE_SIGNED_CONTRACT_TYPE.getType());
            attachmentList = JsonUtil.getJsonToList(attachmentEntityList, RkAttachmentCrForm.class);
            if (CollectionUtil.isNotEmpty((Collection)attachmentList)) {
                vo.setDoubleSignedAttachmentList(attachmentList);
            } else {
                vo.setDoubleSignedAttachmentList(new ArrayList<RkAttachmentCrForm>());
            }
            vo.setPlanNum(planList.size());
            List collect = planList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getDueDate()) && x.getReturnState() != ReturnPlanEnum.END.getState() && DateUtil.dateToString((Date)DateUtil.getNowDate(), (String)"yyyy-MM-dd").compareTo(DateUtil.dateToString((Date)x.getDueDate(), (String)"yyyy-MM-dd")) > 0).collect(Collectors.toList());
            BigDecimal arrearsAmount = collect.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount().subtract(ObjectUtil.isEmpty((Object)y.getReturnAmount()) ? BigDecimal.ZERO : y.getReturnAmount())), BigDecimal::add);
            vo.setArrearsAmount(arrearsAmount);
            vo.setIsOverdue(CollectionUtil.isNotEmpty(collect) ? 1 : 0);
            if (StringUtils.isNotEmpty((String)entity.getOpportunityId())) {
                List<String> idList = Arrays.asList(entity.getOpportunityId().split(","));
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.lambda().in(RkProjectReportingEntity::getId, idList);
                List reportingList = this.rkProjectReportingService.list((Wrapper)queryWrapper);
                if (CollectionUtil.isNotEmpty((Collection)reportingList)) {
                    String opportunityName = reportingList.stream().map(RkProjectReportingEntity::getReportingProject).collect(Collectors.joining(","));
                    vo.setOpportunityName(opportunityName);
                }
            }
            String quotationPrefix = "";
            if (StringUtils.isNotEmpty((String)entity.getQuotationId()) && null != (quotation = this.saleQuotationService.getInfo(entity.getQuotationId()))) {
                if (StringUtils.isNotEmpty((String)quotation.getSerialNumber())) {
                    quotationPrefix = quotation.getSerialNumber();
                } else {
                    CrmCustomerEntity customer;
                    RkProjectReportingEntity reporting = this.rkProjectReportingService.getInfo(quotation.getOpportunityId());
                    if (ObjectUtil.isNotEmpty((Object)reporting) && StringUtils.isNotEmpty((String)reporting.getCustomerId()) && null != (customer = this.crmCustomerService.getInfo(reporting.getCustomerId()))) {
                        quotationPrefix = customer.getName();
                    }
                }
                userSelectValue = this.baseDataUtil.userSelectValue(quotation.getQuotationUser());
                String quotationName = quotationPrefix + "-" + userSelectValue;
                vo.setQuotationName(quotationName);
            }
            if (StringUtils.isNotEmpty((String)entity.getQuotationProfitId()) && null != (profit = this.saleQuotationProfitService.getInfo(entity.getQuotationProfitId()))) {
                userSelectValue = this.baseDataUtil.userSelectValue(profit.getSaleId());
                vo.setQuotationProfitName(quotationPrefix + "-" + userSelectValue);
            }
            if (StringUtils.isNotEmpty((String)vo.getNoContractId()) && null != (noContract = this.saleNoContractService.getInfo(vo.getNoContractId()))) {
                vo.setNoContractName(noContract.getContractName());
                vo.setNoContractAssociationId(noContract.getContractId());
            }
            if (StringUtils.isNotEmpty((String)vo.getInternalContractId()) && ObjectUtil.isNotEmpty(temp = this.oaContractInternalCrmService.getInfoById(vo.getInternalContractId()))) {
                OaContractInternalTransactionInfo oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean(temp, OaContractInternalTransactionInfo.class);
                vo.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
            }
            vo.setPartyBName(this.baseDataUtil.getDictName(vo.getPartyB(), "ContractInternalTransactionSignSubject"));
            List<RkContractProjectEntity> projectList = this.rkContractProjectService.getListByContractId(vo.getId());
            List projectListVO = JsonUtil.getJsonToList(projectList, RkContractProjectListVO.class);
            for (RkContractProjectListVO project : projectListVO) {
                if (!StringUtils.isNotEmpty((String)project.getCustomerId())) continue;
                project.setCustomerName(this.crmCustomerService.getInfo(project.getCustomerId()).getName());
            }
            vo.setProjectList(projectListVO);
        }
        return ActionResult.success(vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkContractEntity entity = this.rkContractService.getInfo(id);
        RkContractInfoVO vo = null;
        if (null != entity) {
            Map<String, Object> temp;
            SaleNoContractEntity noContract;
            SaleQuotationProfitEntity profit;
            String userSelectValue;
            SaleQuotationEntity quotation;
            List<RkAttachmentEntity> attachmentEntityList;
            List attachmentList;
            StringBuffer stringBuffer;
            vo = (RkContractInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractInfoVO.class);
            vo.setIsNeedPayAdvance(vo.getIsNeedPayAdvance());
            vo.setCostTaxRate(this.baseDataUtil.getDictName(vo.getCostTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
            vo.setPromotionType(this.baseDataUtil.getDictName(vo.getPromotionType(), "promotionType"));
            vo.setIsStamp(vo.getIsStamp());
            vo.setIsSubcontract(vo.getIsSubcontract());
            vo.setProfitAmount(vo.getProfitAmount());
            vo.setStartContractTime(vo.getStartContractTime());
            vo.setEndContractTime(vo.getEndContractTime());
            vo.setContractTaxRate(this.baseDataUtil.getDictName(vo.getContractTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
            vo.setSalerId(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
            vo.setContractType(this.baseDataUtil.getDictName(vo.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
            vo.setContractTypeDesc(this.baseDataUtil.getDictName(vo.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
            vo.setIsStampType(this.baseDataUtil.getDictName(vo.getIsStampType(), Constants.STAMP_TYPE_DICT_ID));
            vo.setPaymentMethodType(this.baseDataUtil.getDictName(vo.getPaymentMethodType(), ""));
            vo.setIndustryType(this.baseDataUtil.getDictName(vo.getIndustryType(), "industryType"));
            vo.setIncomeType(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
            vo.setFinancialAcceptanceUser(this.baseDataUtil.userSelectValues(vo.getFinancialAcceptanceUser()));
            vo.setSalesSupportUser(this.baseDataUtil.userSelectValues(vo.getSalesSupportUser()));
            vo.setOpportunityAssistanceUser(this.baseDataUtil.userSelectValues(vo.getOpportunityAssistanceUser()));
            vo.setProposalProducer(this.baseDataUtil.userSelectValues(vo.getProposalProducer()));
            vo.setAssistingUser(this.baseDataUtil.userSelectValues(vo.getAssistingUser()));
            vo.setRegion(entity.getRegionName());
            vo.setDepartment(entity.getDepartmentTreeName());
            if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
                vo.setCustomerNames(this.saleContractCustomerService.getCustomerNamesByContractId(vo.getId()));
                vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
            }
            if ("1".equals(vo.getIsAgent())) {
                RkAgentEntity agent;
                if (StringUtils.isNotEmpty((String)vo.getAgentId()) && null != (agent = this.agentService.getInfo(vo.getAgentId()))) {
                    vo.setAgentName(agent.getName());
                }
            } else {
                vo.setAgentName(vo.getCustomerNames());
            }
            vo.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
            vo.setMasterId(ObjectUtil.isEmpty((Object)vo.getMasterId()) ? "" : ((RkContractEntity)this.rkContractService.getById((Serializable)((Object)vo.getMasterId()))).getContractName());
            vo.setEnableMarkDesc(this.baseDataUtil.getDictName(vo.getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
            vo.setSpecialTypeName(this.baseDataUtil.getDictName(vo.getSpecialType(), Constants.SPECIAL_TYPE_DICT));
            vo.setCustomerRegion(entity.getCustomerRegionName());
            vo.setArchivedByDesc(this.baseDataUtil.userSelectValueNoAccount(vo.getArchivedBy()));
            vo.setArchivedLocationDesc(this.baseDataUtil.getDictName(vo.getArchivedLocation(), "archiveLocation"));
            List<RkContractReturnPlanEntity> planList = this.contractReturnPlanService.getPlanByContractId(vo.getId());
            vo.setPlanNum(planList.size());
            List collect = planList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getDueDate()) && x.getReturnState() != ReturnPlanEnum.END.getState() && DateUtil.dateToString((Date)DateUtil.getNowDate(), (String)"yyyy-MM-dd").compareTo(DateUtil.dateToString((Date)x.getDueDate(), (String)"yyyy-MM-dd")) > 0).collect(Collectors.toList());
            BigDecimal arrearsAmount = collect.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount().subtract(ObjectUtil.isEmpty((Object)y.getReturnAmount()) ? BigDecimal.ZERO : y.getReturnAmount())), BigDecimal::add);
            vo.setArrearsAmount(arrearsAmount);
            List<RkContractPaymentEntity> listByContractId = this.contractPaymentService.getListByContractId(id);
            List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractPaymentListVO.class);
            vo.setPaymentList(jsonToList);
            List<RkContractTaxEntity> rkContractTaxEntities = this.contractTaxService.listByContractId(id);
            List jsonToList1 = JsonUtil.getJsonToList(rkContractTaxEntities, RkContractTaxInfoVO.class);
            vo.setTaxList(jsonToList1);
            if (vo.getIsMoreTax() != null && vo.getIsMoreTax() == 1 && CollectionUtil.isNotEmpty((Collection)jsonToList1)) {
                stringBuffer = new StringBuffer();
                for (RkContractTaxInfoVO rkContractTaxInfoVO : jsonToList1) {
                    if (rkContractTaxInfoVO.getTaxType() != null && rkContractTaxInfoVO.getTaxType().equals("cost")) continue;
                    stringBuffer.append("\uff0c" + rkContractTaxInfoVO.getTaxName());
                }
                vo.setContractTaxRate(stringBuffer.toString().replaceFirst("\uff0c", ""));
            }
            if (vo.getCostIsMoreTax() != null && vo.getCostIsMoreTax() == 1 && CollectionUtil.isNotEmpty((Collection)jsonToList1)) {
                stringBuffer = new StringBuffer();
                for (RkContractTaxInfoVO rkContractTaxInfoVO : jsonToList1) {
                    if (rkContractTaxInfoVO.getTaxType() == null || !rkContractTaxInfoVO.getTaxType().equals("cost")) continue;
                    stringBuffer.append("\uff0c" + rkContractTaxInfoVO.getTaxName());
                }
                vo.setCostTaxRate(stringBuffer.toString().replaceFirst("\uff0c", ""));
            }
            if (CollectionUtil.isNotEmpty((Collection)(attachmentList = JsonUtil.getJsonToList(attachmentEntityList = this.attachmentService.getListByContractIdAndFileType(id, AttachmentTypeEnum.CONTRACT_TYPE.getType()), RkAttachmentCrForm.class)))) {
                vo.setAttachmentList(attachmentList);
            } else {
                vo.setAttachmentList(new ArrayList<RkAttachmentCrForm>());
            }
            attachmentEntityList = this.attachmentService.getListByContractIdAndFileType(id, AttachmentTypeEnum.DOUBLE_SIGNED_CONTRACT_TYPE.getType());
            attachmentList = JsonUtil.getJsonToList(attachmentEntityList, RkAttachmentCrForm.class);
            if (CollectionUtil.isNotEmpty((Collection)attachmentList)) {
                vo.setDoubleSignedAttachmentList(attachmentList);
            } else {
                vo.setDoubleSignedAttachmentList(new ArrayList<RkAttachmentCrForm>());
            }
            if (StringUtils.isEmpty((String)vo.getCustomerAddressName())) {
                vo.setCustomerAddressName(this.baseDataUtil.provinceData(vo.getCustomerAddress()));
            }
            if (StringUtils.isNotEmpty((String)entity.getOpportunityId())) {
                List<String> idList = Arrays.asList(entity.getOpportunityId().split(","));
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.lambda().in(RkProjectReportingEntity::getId, idList);
                List reportingList = this.rkProjectReportingService.list((Wrapper)queryWrapper);
                if (CollectionUtil.isNotEmpty((Collection)reportingList)) {
                    String opportunityName = reportingList.stream().map(RkProjectReportingEntity::getReportingProject).collect(Collectors.joining(","));
                    vo.setOpportunityName(opportunityName);
                }
            }
            String quotationPrefix = "";
            if (StringUtils.isNotEmpty((String)entity.getQuotationId()) && null != (quotation = this.saleQuotationService.getInfo(entity.getQuotationId()))) {
                if (StringUtils.isNotEmpty((String)quotation.getSerialNumber())) {
                    quotationPrefix = quotation.getSerialNumber();
                } else {
                    CrmCustomerEntity customer;
                    RkProjectReportingEntity reporting = this.rkProjectReportingService.getInfo(quotation.getOpportunityId());
                    if (StringUtils.isNotEmpty((String)reporting.getCustomerId()) && null != (customer = this.crmCustomerService.getInfo(reporting.getCustomerId()))) {
                        quotationPrefix = customer.getName();
                    }
                }
                userSelectValue = this.baseDataUtil.userSelectValue(quotation.getQuotationUser());
                String quotationName = quotationPrefix + "-" + userSelectValue;
                vo.setQuotationName(quotationName);
            }
            if (StringUtils.isNotEmpty((String)entity.getQuotationProfitId()) && null != (profit = this.saleQuotationProfitService.getInfo(entity.getQuotationProfitId()))) {
                userSelectValue = this.baseDataUtil.userSelectValue(profit.getSaleId());
                vo.setQuotationProfitName(quotationPrefix + "-" + userSelectValue);
            }
            vo.setBiddingStatusName(this.baseDataUtil.getDictName(entity.getBiddingStatus(), "biddingStatus"));
            vo.setContractSigningStatusName(this.baseDataUtil.getDictName(entity.getContractSigningStatus(), "contractSigningStatus"));
            if (StringUtils.isNotEmpty((String)vo.getNoContractId()) && null != (noContract = this.saleNoContractService.getInfo(vo.getNoContractId()))) {
                vo.setNoContractName(noContract.getContractName());
                vo.setNoContractAssociationId(noContract.getContractId());
            }
            if (StringUtils.isNotEmpty((String)vo.getInternalContractId()) && ObjectUtil.isNotEmpty(temp = this.oaContractInternalCrmService.getInfoById(vo.getInternalContractId()))) {
                OaContractInternalTransactionInfo oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean(temp, OaContractInternalTransactionInfo.class);
                vo.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
                vo.setServiceDepartmentManagerName(this.baseDataUtil.userSelectValues(oaContractInternalTransactionInfo.getServiceUser()));
            }
            vo.setPartyBName(this.baseDataUtil.getDictName(vo.getPartyB(), "ContractInternalTransactionSignSubject"));
            vo.setIsCrossRegion(this.baseDataUtil.getDictName(vo.getIsCrossRegion(), "whether"));
        }
        return ActionResult.success(vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/updateFile/{id}"})
    @DSTransactional
    public ActionResult updateFile(@PathVariable(value="id") String id, @RequestBody @Valid RkContractUpForm rkContractUpForm) {
        Object object = this.$lock;
        synchronized (object) {
            RkContractEntity entity = this.rkContractService.getInfo(id);
            if (entity != null) {
                HashMap map = this.rkContractService.updateContractFile(id, rkContractUpForm);
                if (ObjectUtil.isEmpty(map.get("error"))) {
                    return ActionResult.success((String)"\u4e0a\u4f20\u9644\u4ef6\u6210\u529f");
                }
                return ActionResult.fail((String)map.get("error").toString());
            }
            return ActionResult.fail((String)"\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25\uff0c\u5408\u540c\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkContractUpForm rkContractUpForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            RkContractEntity entity = this.rkContractService.getInfo(id);
            if (entity != null) {
                if (StrUtil.isNotBlank((CharSequence)rkContractUpForm.getSalesLiaison())) {
                    rkContractUpForm.setSalesLiaisonName(this.baseDataUtil.userSelectValues(rkContractUpForm.getSalesLiaison()));
                    UserEntity byId = (UserEntity)this.userService.getById((Serializable)((Object)rkContractUpForm.getSalesLiaison()));
                    rkContractUpForm.setLiaisonDepartment(byId.getOrganizeId());
                    rkContractUpForm.setLiaisonCompany(this.userService.getUserCompany(rkContractUpForm.getSalesLiaison()));
                }
                rkContractUpForm.setJcContractTypeName(this.baseDataUtil.getDictName(rkContractUpForm.getJcContractType(), "jcContractType"));
                HashMap map = this.rkContractService.updateContract(id, rkContractUpForm);
                if (ObjectUtil.isEmpty(map.get("error"))) {
                    return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
                }
                return ActionResult.fail((String)map.get("error").toString());
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            RkContractEntity entity = this.rkContractService.getInfo(id);
            if (entity != null) {
                if (!StrUtil.equals((CharSequence)entity.getEnableMark(), (CharSequence)ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark())) {
                    return ActionResult.fail((String)"\u5408\u540c\u4e0d\u662f\u8349\u7a3f\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664!");
                }
                List<RkContractProjectEntity> listByContractId = this.rkContractProjectService.getListByContractId(id);
                List collect = listByContractId.stream().filter(project -> StrUtil.isNotBlank((CharSequence)project.getState()) && !StrUtil.equals((CharSequence)project.getState(), (CharSequence)ProjectStateEnum.notStartApply_state.getState())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(collect)) {
                    return ActionResult.fail((String)"\u5408\u540c\u5173\u8054\u7684\u9879\u76ee\u5df2\u7ecf\u5f00\u5de5\uff0c\u4e0d\u80fd\u5220\u9664!");
                }
                long l = this.rkcontrActassetsLedgerService.countByContractId(id);
                if (l > 0L) {
                    return ActionResult.fail((String)"\u5408\u540c\u5173\u8054\u7684\u6709\u53f0\u8d26\uff0c\u4e0d\u80fd\u5220\u9664!");
                }
                List<RkContractProcureRelationEntity> procureRelationEntityList = this.rkContractProcureRelationService.listByContractId(id);
                if (CollectionUtil.isNotEmpty(procureRelationEntityList)) {
                    return ActionResult.fail((String)"\u9500\u552e\u5408\u540c\u5173\u8054\u7684\u6709\u91c7\u8d2d\u5408\u540c\uff0c\u4e0d\u80fd\u5220\u9664!");
                }
            } else {
                return ActionResult.fail((String)"\u5408\u540c\u4e0d\u5b58\u5728");
            }
            this.rkContractService.deleteContract(entity);
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/handleVoided/{id}"})
    public ActionResult voided(@PathVariable(value="id") String id, String reason) {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            RkContractEntity entity = this.rkContractService.getInfo(id);
            if (entity != null) {
                if (!StrUtil.equals((CharSequence)entity.getEnableMark(), (CharSequence)ContractEnableMarkEnum.ENABLE_COMPLETED.getEnableMark()) && !StrUtil.equals((CharSequence)entity.getEnableMark(), (CharSequence)ContractEnableMarkEnum.ENABLE_EXECUTE.getEnableMark())) {
                    return ActionResult.fail((String)"\u5408\u540c\u4e0d\u662f\u6267\u884c\u4e2d\u6216\u8005\u5df2\u5b8c\u6210\u72b6\u6001\uff0c\u4e0d\u80fd\u4f5c\u5e9f!");
                }
                if (!ObjectUtil.isEmpty((Object)entity.getReturnAmount()) && entity.getReturnAmount().compareTo(BigDecimal.ZERO) == 1) {
                    return ActionResult.fail((String)"\u5408\u540c\u5df2\u6709\u6536\u6b3e\uff0c\u4e0d\u80fd\u4f5c\u5e9f!");
                }
                if (!ObjectUtil.isEmpty((Object)entity.getInvoiceAmount()) && entity.getInvoiceAmount().compareTo(BigDecimal.ZERO) == 1) {
                    return ActionResult.fail((String)"\u5408\u540c\u5df2\u5f00\u53d1\u7968\uff0c\u4e0d\u80fd\u4f5c\u5e9f!");
                }
            } else {
                return ActionResult.fail((String)"\u5408\u540c\u4e0d\u5b58\u5728");
            }
            this.rkContractService.voidedContract(id, reason, userInfo.getUserId());
            return ActionResult.success((String)"\u4f5c\u5e9f\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/handleDraft/{id}"})
    public ActionResult draft(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            RkContractEntity entity = this.rkContractService.getInfo(id);
            if (entity != null) {
                if (StrUtil.equals((CharSequence)entity.getEnableMark(), (CharSequence)ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark())) {
                    return ActionResult.fail((String)"\u5408\u540c\u5df2\u7ecf\u662f\u8349\u7a3f\uff0c\u4e0d\u80fd\u518d\u6b21\u9000\u56de\u8349\u7a3f!");
                }
                if (!ObjectUtil.isEmpty((Object)entity.getReturnAmount()) && entity.getReturnAmount().compareTo(BigDecimal.ZERO) == 1) {
                    return ActionResult.fail((String)"\u5408\u540c\u5df2\u6709\u6536\u6b3e\uff0c\u4e0d\u80fd\u9000\u56de\u8349\u7a3f!");
                }
                if (!ObjectUtil.isEmpty((Object)entity.getInvoiceAmount()) && entity.getInvoiceAmount().compareTo(BigDecimal.ZERO) == 1) {
                    return ActionResult.fail((String)"\u5408\u540c\u5df2\u5f00\u53d1\u7968\uff0c\u4e0d\u80fd\u9000\u56de\u8349\u7a3f!");
                }
                List<RkContractReturnPlanEntity> planList = this.contractReturnPlanService.getPlanByContractId(id);
                if (CollectionUtil.size(planList) > 0) {
                    return ActionResult.fail((String)"\u5408\u540c\u5df2\u7ecf\u6709\u4ed8\u6b3e\u8ba1\u5212\uff0c\u4e0d\u80fd\u9000\u56de\u8349\u7a3f!");
                }
                long l = this.rkcontrActassetsLedgerService.countByContractId(id);
                if (l > 0L) {
                    return ActionResult.fail((String)"\u5408\u540c\u5173\u8054\u7684\u6709\u53f0\u8d26\uff0c\u4e0d\u80fd\u9000\u56de\u5230\u8349\u7a3f\u72b6\u6001!");
                }
            } else {
                return ActionResult.fail((String)"\u5408\u540c\u4e0d\u5b58\u5728");
            }
            entity.setEnableMark(ContractEnableMarkEnum.ENABLE_DRAFT.getEnableMark());
            entity.setIsChangeNow(0);
            this.rkContractService.update(id, entity);
            return ActionResult.success((String)"\u9000\u56de\u8349\u7a3f\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/archived"})
    public ActionResult archived(@RequestBody RkArachivedUpForm rkArachivedUpForm) {
        Object object = this.$lock;
        synchronized (object) {
            RkContractEntity byId = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)rkArachivedUpForm.getContractId()));
            if (ObjectUtil.isEmpty((Object)byId)) {
                return ActionResult.fail((String)"\u5408\u540c\u4e0d\u5b58\u5728");
            }
            RkContractEntity jsonToBean = (RkContractEntity)JsonUtil.getJsonToBean((Object)rkArachivedUpForm, RkContractEntity.class);
            jsonToBean.setIsArchived(1);
            this.rkContractService.contractArachived(rkArachivedUpForm);
            return ActionResult.success((String)"\u5f52\u6863\u6210\u529f");
        }
    }

    @GetMapping(value={"/code/{code}"})
    public ActionResult checkInvoiceNumber(@PathVariable(value="code") String code) {
        if (StrUtil.isNotEmpty((CharSequence)code)) {
            code = code.trim();
        }
        List<RkContractEntity> list = this.rkContractService.getListByCode(code);
        return ActionResult.success(list);
    }

    @GetMapping(value={"/getSimpleAndProjectCount/{contractId}"})
    public ActionResult getSimpleAndProjectCount(@PathVariable(value="contractId") String contractId) {
        RkContractEntity byId = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)contractId));
        RkContractInfoVO jsonToBean = (RkContractInfoVO)JsonUtil.getJsonToBean((Object)byId, RkContractInfoVO.class);
        jsonToBean.setIncomeTypeDesc(this.crmProductCategoryService.getNameByIds(jsonToBean.getIncomeType()));
        jsonToBean.setContractTypeDesc(this.baseDataUtil.getDictName(jsonToBean.getContractType(), "contractType"));
        jsonToBean.setIndustryTypeDesc(this.baseDataUtil.getDictName(jsonToBean.getIndustryType(), "industryType"));
        jsonToBean.setSalerName(this.baseDataUtil.userSelectValueNoAccount(jsonToBean.getSalerId()));
        List<RkContractTaxEntity> rkContractTaxEntities = this.contractTaxService.listByContractId(contractId);
        List jsonToList1 = JsonUtil.getJsonToList(rkContractTaxEntities, RkContractTaxInfoVO.class);
        jsonToBean.setTaxList(jsonToList1);
        if (jsonToBean.getIsMoreTax() != null && jsonToBean.getIsMoreTax() == 1) {
            if (CollectionUtil.isNotEmpty((Collection)jsonToList1)) {
                String collect1 = jsonToList1.stream().map(RkContractTaxInfoVO::getTaxName).collect(Collectors.joining(","));
                jsonToBean.setContractTaxRate(collect1);
            }
        } else {
            RkContractTaxInfoVO infoVO = new RkContractTaxInfoVO();
            infoVO.setTaxId(jsonToBean.getContractTaxRate());
            infoVO.setTaxName(this.baseDataUtil.getDictName(jsonToBean.getContractTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
            List list = CollectionUtil.list((boolean)false, (Object[])new RkContractTaxInfoVO[]{infoVO});
            jsonToBean.setTaxList(list);
            jsonToBean.setContractTaxRate(infoVO.getTaxName());
        }
        if (StringUtils.isNotEmpty((String)jsonToBean.getCustomerIds())) {
            jsonToBean.setCustomerNames(this.saleContractCustomerService.getCustomerNamesByContractId(jsonToBean.getId()));
            jsonToBean.setCustomerName(jsonToBean.getCustomerNames().split(",")[0]);
            jsonToBean.setCustomerList(this.saleContractCustomerService.getListByContractId(jsonToBean.getId()));
        }
        if ("1".equals(jsonToBean.getIsAgent())) {
            RkAgentEntity agent;
            if (StringUtils.isNotEmpty((String)jsonToBean.getAgentId()) && null != (agent = this.agentService.getInfo(jsonToBean.getAgentId()))) {
                jsonToBean.setAgentName(agent.getName());
            }
        } else {
            jsonToBean.setAgentName(jsonToBean.getCustomerNames());
        }
        List<RkContractProjectEntity> list = this.contractProjectService.getListByContractId(contractId);
        List<RkContractProjectEntity> projectEntityList = this.contractProjectService.getListByContractIdHaveDel(contractId);
        BigDecimal reduce = list.stream().filter(project -> !ObjectUtil.isEmpty((Object)project.getProjectAmount())).map(RkContractProjectEntity::getProjectAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        jsonToBean.setProjectCount(list.size());
        jsonToBean.setProjectCountHaveDel(projectEntityList.size());
        jsonToBean.setProjectAmount(MathUtils.substract(byId.getContractAmount(), reduce));
        BigDecimal divide = MathUtils.divide(MathUtils.multiply(jsonToBean.getProjectAmount(), new BigDecimal(100)), byId.getContractAmount(), 2);
        jsonToBean.setProjectRatio(divide);
        return ActionResult.success((Object)jsonToBean);
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult<Object> Uploader() {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().endsWith(".xlsx") || file.getOriginalFilename().endsWith(".xls")) {
            String filePath = XSSEscape.escape((String)this.configValueUtil.getTemporaryFilePath());
            String fileName = XSSEscape.escape((String)(RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file)));
            FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
            try {
                UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)(filePath + fileName), (String)"temporary", (String)fileName);
            }
            catch (IOException e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            DownloadVO vo = DownloadVO.builder().build();
            vo.setName(fileName);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u5408\u540c\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u5408\u540c\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List contractList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, ContractImportVO.class);
        if (CollectionUtil.isEmpty((Collection)contractList)) {
            return ActionResult.fail((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (contractList.size() > 500) {
            return ActionResult.fail((String)"\u6700\u591a\u5bfc\u5165\u6570\u636e500\u6761");
        }
        List list = JsonUtil.getJsonToList((Object)contractList, Object.class);
        Map<String, Object> map = this.contractPaymentService.importPreview(list, new ContractImportVO());
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<ContractImportReturnVO> ImportData(@RequestBody ContractImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), ContractImportVO.class);
        ContractImportReturnVO result = this.rkContractService.importData(dataList);
        return ActionResult.success((Object)result);
    }

    @ApiOperation(value="\u5bfc\u51fa\u9519\u8bef\u62a5\u544a")
    @PostMapping(value={"/ExportExceptionData"})
    public ActionResult<DownloadVO> exportExceptionData(@RequestBody ContractImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), Object.class);
        DownloadVO vo = this.rkContractService.exportExceptionData(dataList, new ContractImportVO());
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"toCustomerCompany"})
    public ActionResult toCustomerCompany() {
        this.rkContractService.toCustomerCompany(null);
        return ActionResult.success();
    }

    @GetMapping(value={"countPanorama/{id}"})
    public ActionResult countPanorama(@PathVariable(value="id") String id) {
        HashMap map = MapUtil.newHashMap();
        long planCount = this.contractReturnPlanService.countByContractId(id);
        long collectionCount = this.contractCollectionRecordService.countByContractId(id);
        long projectCount = this.contractProjectService.countByContractId(id);
        long invoiceCount = this.contractInvoiceService.countByContractId(id);
        long attachmentCount = this.attachmentService.countByContractId(id);
        map.put("planCount", planCount);
        map.put("collectionCount", collectionCount);
        map.put("projectCount", projectCount);
        map.put("invoiceCount", invoiceCount);
        map.put("attachmentCount", attachmentCount);
        return ActionResult.success((Object)map);
    }

    @PostMapping(value={"getContractComprehensiveInfo"})
    public ActionResult getContractComprehensiveInfo(@RequestBody RkContractPaginationExportModel rkContractPagination) {
        List contractComprehensiveInfo = this.rkContractService.getContractComprehensiveInfo(rkContractPagination);
        PageListVO vo = new PageListVO();
        vo.setList(contractComprehensiveInfo);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"getProductChannelInfo"})
    public ActionResult getProductChannelInfo(@RequestBody RkContractPaginationExportModel rkContractPagination) {
        List contractComprehensiveInfo = this.rkContractService.getProductChannelInfo(rkContractPagination);
        PageListVO vo = new PageListVO();
        vo.setList(contractComprehensiveInfo);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"getCompanyContractStatisticsLedger"})
    public ActionResult getCompanyContractStatisticsLedger(@RequestBody RkContractPagination rkContractPagination) {
        List<RkCompanyContractStatisticsLedger> companyContractStatisticsLedger = this.rkContractService.getCompanyContractStatisticsLedger(rkContractPagination, "0");
        PageListVO vo = new PageListVO();
        vo.setList(companyContractStatisticsLedger);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @PostMapping(value={"/Actions/ExportContractComprehensiveInfo"})
    public ActionResult ExportContractComprehensiveInfo(@RequestBody RkContractPaginationExportModel rkContractPagination) throws IOException {
        if (StringUtil.isEmpty((String)rkContractPagination.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        DownloadVO vo = this.rkContractService.exportData(rkContractPagination);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @PostMapping(value={"/Actions/ExportProductChannelInfo"})
    public ActionResult ExportProductChannelInfo(@RequestBody RkContractPaginationExportModel rkContractPagination) throws IOException {
        if (StringUtil.isEmpty((String)rkContractPagination.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        DownloadVO vo = this.rkContractService.exportProductChannelData(rkContractPagination);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u5408\u540c\u5217\u8868\u7528\u4e8e\u6838\u9500")
    @PostMapping(value={"/getContractsForWriteOff"})
    public ActionResult getContractsForWriteOff(@RequestBody RkContractPagination rkContractPagination) throws IOException {
        List<RkContractListVO> listVO = this.rkContractService.getContractsForWriteOff(rkContractPagination);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u667a\u533b\u57fa\u7840\u670d\u52a1\u8d39")
    @PostMapping(value={"/getContractsForServiceFree"})
    public ActionResult getContractsForServiceFree(@RequestBody RkContractPagination rkContractPagination) throws IOException {
        List<String> regionList = Arrays.asList("41", "42", "31", "45");
        if (CollectionUtil.isEmpty(rkContractPagination.getRegionIdList())) {
            rkContractPagination.setRegionIdList(regionList);
        }
        rkContractPagination.setServiceFeeType("serviceFee");
        List<RkContractEntity> list = this.rkContractService.getList(rkContractPagination);
        for (RkContractEntity contractEntity : list) {
            if (!ObjectUtil.isEmpty((Object)contractEntity.getSettlementStatus())) continue;
            contractEntity.setSettlementStatus("notSettled");
            this.rkContractService.updateById(contractEntity);
        }
        List<RkContractListVO> listVO = this.appendListVo(list, false);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        RkContractPaginationVO page = (RkContractPaginationVO)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractPagination), RkContractPaginationVO.class));
        vo.setPagination((PaginationVO)page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/countBySettlementStage"})
    public ActionResult countBySettlementStage(@RequestBody RkContractPagination rkContractPagination) {
        rkContractPagination.setServiceFeeType("serviceCount");
        List<String> regionList = Arrays.asList("41", "42", "31", "45");
        if (CollectionUtil.isEmpty(rkContractPagination.getRegionIdList())) {
            rkContractPagination.setRegionIdList(regionList);
        }
        List<RkContractEntity> list = this.rkContractService.getListByNoPage(rkContractPagination);
        long notSettled = list.stream().filter(t -> ObjectUtil.isNotEmpty((Object)t.getSettlementStatus())).filter(t -> t.getSettlementStatus().equals("notSettled")).count();
        long settlement = list.stream().filter(t -> ObjectUtil.isNotEmpty((Object)t.getSettlementStatus())).filter(t -> t.getSettlementStatus().equals("settlement")).count();
        long settled = list.stream().filter(t -> ObjectUtil.isNotEmpty((Object)t.getSettlementStatus())).filter(t -> t.getSettlementStatus().equals("settled")).count();
        HashMap map = MapUtil.newHashMap();
        map.put("notSettled", notSettled);
        map.put("settlement", settlement);
        map.put("settled", settled);
        return ActionResult.success((Object)map);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @PostMapping(value={"/Actions/ExportContractsForServiceFree"})
    public ActionResult ExportContractsForServiceFree(@RequestBody RkContractPaginationExportModel rkContractPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkContractPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkContractPagination rkContractPagination = (RkContractPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractPaginationExportModel), RkContractPagination.class));
        List<String> regionList = Arrays.asList("41", "42", "31", "45");
        if (CollectionUtil.isEmpty(rkContractPagination.getRegionIdList())) {
            rkContractPagination.setRegionIdList(regionList);
        }
        rkContractPagination.setServiceFeeType("serviceFee");
        List<RkContractEntity> list = this.rkContractService.getTypeList(rkContractPagination, rkContractPaginationExportModel.getDataType());
        List<RkContractListVO> listVO = this.appendListVo(list, true);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkContractPaginationExportModel.getSelectKey()) ? rkContractPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatServiceFeeExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatServiceFeeExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block54: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block54;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block54;
                    }
                    case "salerName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u4eba\u5458", (Object)"salerName"));
                        continue block54;
                    }
                    case "archivedTime": {
                        entitys.add(new ExcelExportEntity("\u5f52\u6863\u65e5\u671f", (Object)"archivedTime"));
                        continue block54;
                    }
                    case "enableMarkDesc": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u72b6\u6001", (Object)"enableMarkDesc"));
                        continue block54;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block54;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u5bf9\u8c61", (Object)"agentName"));
                        continue block54;
                    }
                    case "customerNames": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerNames"));
                        continue block54;
                    }
                    case "isAgentDesc": {
                        entitys.add(new ExcelExportEntity("\u4ee3\u7406\u5408\u540c", (Object)"isAgentDesc"));
                        continue block54;
                    }
                    case "isSealerLeader": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u667a\u533b\u4e3b\u5bfc", (Object)"isSealerLeader"));
                        continue block54;
                    }
                    case "isReturnAmountRecord": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u6536\u5230\u6536\u4ed8\u6b3e", (Object)"isReturnAmountRecord"));
                        continue block54;
                    }
                    case "isHaveProject": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u5df2\u8fdb\u573a", (Object)"isHaveProject"));
                        continue block54;
                    }
                    case "incomeTypeName": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5927\u7c7b", (Object)"incomeTypeName"));
                        continue block54;
                    }
                    case "contractAmount": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u603b\u989d(\u5143)", (Object)"contractAmount"));
                        continue block54;
                    }
                    case "validContractAmount": {
                        entitys.add(new ExcelExportEntity("\u6709\u6548\u5408\u540c\u91d1\u989d(\u5143)", (Object)"validContractAmount"));
                        continue block54;
                    }
                    case "settlementStatusDesc": {
                        entitys.add(new ExcelExportEntity("\u7ed3\u7b97\u72b6\u6001", (Object)"settlementStatusDesc"));
                        continue block54;
                    }
                    case "baseFeeRate": {
                        entitys.add(new ExcelExportEntity("\u57fa\u7840\u8d39\u7528\u7ed3\u7b97\u6bd4\u4f8b", (Object)"baseFeeRate"));
                        continue block54;
                    }
                    case "baseFeeAmount": {
                        entitys.add(new ExcelExportEntity("\u57fa\u7840\u8d39\u7528\u7ed3\u7b97\u91d1\u989d(\u5143)", (Object)"baseFeeAmount"));
                        continue block54;
                    }
                    case "thisBaseAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u6b21\u57fa\u7840\u8d39\u7528\u7ed3\u7b97\u91d1\u989d(\u5143)", (Object)"thisBaseAmount"));
                        continue block54;
                    }
                    case "settlementAmount": {
                        entitys.add(new ExcelExportEntity("\u5df2\u7ed3\u7b97\u91d1\u989d(\u5143)", (Object)"settlementAmount"));
                        continue block54;
                    }
                    case "notSettlementAmount": {
                        entitys.add(new ExcelExportEntity("\u672a\u7ed3\u7b97\u91d1\u989d(\u5143)", (Object)"notSettlementAmount"));
                        continue block54;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u667a\u533b\u57fa\u7840\u670d\u52a1\u8d39\u8868\u5355");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u667a\u533b\u57fa\u7840\u670d\u52a1\u8d39\u8868\u5355" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

