/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractInvoiceDetailEntity;
import com.bringspring.contract.entity.RkContractInvoiceEntity;
import com.bringspring.contract.model.rkcontractcollectionrecord.RkContractCollectionRecordPagination;
import com.bringspring.contract.model.rkcontractinvoice.ContractInvoiceImportReturnVO;
import com.bringspring.contract.model.rkcontractinvoice.ContractInvoiceImportVO;
import com.bringspring.contract.model.rkcontractinvoice.RkContractInvoiceCrForm;
import com.bringspring.contract.model.rkcontractinvoice.RkContractInvoiceInfoVO;
import com.bringspring.contract.model.rkcontractinvoice.RkContractInvoiceListVO;
import com.bringspring.contract.model.rkcontractinvoice.RkContractInvoicePagination;
import com.bringspring.contract.model.rkcontractinvoice.RkContractInvoicePaginationExportModel;
import com.bringspring.contract.model.rkcontractinvoice.RkContractInvoiceReceiveCrForm;
import com.bringspring.contract.model.rkcontractinvoice.RkContractInvoiceUpForm;
import com.bringspring.contract.model.rkcontractinvoicedetail.RkContractInvoiceDetailExport;
import com.bringspring.contract.model.rkcontractinvoicedetail.RkContractInvoiceDetailModel;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractCollectionRecordService;
import com.bringspring.contract.service.RkContractInvoiceDetailService;
import com.bringspring.contract.service.RkContractInvoiceService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.utils.InvoiceStateEnum;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5408\u540c\u53d1\u7968"}, value="contract")
@RequestMapping(value={"/api/contract/RkContractInvoice"})
public class RkContractInvoiceController {
    private static final Logger log = LoggerFactory.getLogger(RkContractInvoiceController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractInvoiceService rkContractInvoiceService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkAgentService agentService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RkContractInvoiceDetailService contractInvoiceDetailService;
    @Autowired
    private RkContractCollectionRecordService contractCollectionRecordService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkContractInvoicePagination rkContractInvoicePagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        if (CollectionUtil.isNotEmpty(rkContractInvoicePagination.getRegion())) {
            List searchRegion = CollectionUtil.list((boolean)false);
            rkContractInvoicePagination.getRegion().stream().forEach(l -> searchRegion.add(l.get(0)));
            rkContractInvoicePagination.setSearchRegion(searchRegion);
        }
        List<RkContractInvoiceEntity> list = this.rkContractInvoiceService.getList(rkContractInvoicePagination);
        List listVO = JsonUtil.getJsonToList(list, RkContractInvoiceListVO.class);
        for (RkContractInvoiceListVO rkContractInvoiceVO : listVO) {
            rkContractInvoiceVO.setHandledBy(this.baseDataUtil.userSelectValueNoAccount(rkContractInvoiceVO.getHandledBy()));
            rkContractInvoiceVO.setRate(this.baseDataUtil.getDictName(rkContractInvoiceVO.getRate(), "invoiceRate"));
            rkContractInvoiceVO.setInvoiceType(this.baseDataUtil.getDictName(rkContractInvoiceVO.getInvoiceType(), "invoiceType"));
            rkContractInvoiceVO.setStateDesc(this.baseDataUtil.getDictName(rkContractInvoiceVO.getState(), "invoiceState"));
            rkContractInvoiceVO.setDeliveryPerson(this.baseDataUtil.userSelectValueNoAccount(rkContractInvoiceVO.getDeliveryPerson()));
            rkContractInvoiceVO.setDeliveryWay(this.baseDataUtil.getDictName(rkContractInvoiceVO.getDeliveryWay(), "deliveryWay"));
            rkContractInvoiceVO.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(rkContractInvoiceVO.getCreatorUserId()));
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)rkContractInvoiceVO.getContractId()));
            if (!ObjectUtil.isEmpty((Object)byId)) {
                rkContractInvoiceVO.setContractName(byId.getContractName());
                rkContractInvoiceVO.setCustomerName(((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)byId.getCustomerId()))).getName());
                if (!ObjectUtil.isEmpty((Object)byId.getIsAgent()) && byId.getIsAgent() == 1) {
                    rkContractInvoiceVO.setAgentName(((RkAgentEntity)this.agentService.getById((Serializable)((Object)byId.getAgentId()))).getName());
                } else {
                    rkContractInvoiceVO.setAgentName(rkContractInvoiceVO.getCustomerName());
                }
                rkContractInvoiceVO.setContractCode(byId.getContractCode());
                rkContractInvoiceVO.setRegion(this.baseDataUtil.provinceData(byId.getRegion()));
            }
            List<RkContractInvoiceDetailEntity> listByInvoiceId = this.contractInvoiceDetailService.getListByInvoiceId(rkContractInvoiceVO.getId());
            String collect = listByInvoiceId.stream().map(RkContractInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.joining(","));
            rkContractInvoiceVO.setInvoiceNumber(collect);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractInvoicePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"countAmount"})
    public ActionResult countAmount(@RequestBody RkContractInvoicePagination rkContractInvoicePagination) {
        UserInfo userInfo = this.userProvider.get();
        if (CollectionUtil.isNotEmpty(rkContractInvoicePagination.getRegion())) {
            List searchRegion = CollectionUtil.list((boolean)false);
            rkContractInvoicePagination.getRegion().stream().forEach(l -> searchRegion.add(l.get(0)));
            rkContractInvoicePagination.setSearchRegion(searchRegion);
        }
        rkContractInvoicePagination.setCompanyId(userInfo.getOrganizeId());
        if (CollectionUtil.isEmpty(rkContractInvoicePagination.getInvoiceDate())) {
            rkContractInvoicePagination.setInvoiceDate(CollectionUtil.list((boolean)false, (Object[])new Date[]{DateUtil.getBeginDayOfMonth(), DateUtil.getEndDayOfMonth()}));
        }
        List stateList = CollectionUtil.list((boolean)false, (Object[])new String[]{InvoiceStateEnum.STATE_ISSUED.getState(), InvoiceStateEnum.STATE_MAILED.getState()});
        rkContractInvoicePagination.setStateList(stateList);
        List<RkContractInvoiceEntity> listNotPage = this.rkContractInvoiceService.getListNotPage(rkContractInvoicePagination);
        Map<String, Object> stringObjectMap = this.contractInvoiceDetailService.countAmount(listNotPage);
        RkContractCollectionRecordPagination rkContractCollectionRecordPagination = new RkContractCollectionRecordPagination();
        rkContractCollectionRecordPagination.setReturnDate(rkContractInvoicePagination.getInvoiceDate());
        rkContractCollectionRecordPagination.setCompanyId(userInfo.getOrganizeId());
        Map<String, Object> stringObjectMap1 = this.contractCollectionRecordService.countAmount(rkContractCollectionRecordPagination);
        stringObjectMap.putAll(stringObjectMap1);
        return ActionResult.success(stringObjectMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkContractInvoiceCrForm rkContractInvoiceCrForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            rkContractInvoiceCrForm.setCompanyId(userInfo.getOrganizeId());
            HashMap map = this.rkContractInvoiceService.saveInvoice(rkContractInvoiceCrForm);
            if (ObjectUtil.isEmpty(map.get("error"))) {
                return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
            }
            return ActionResult.fail((String)map.get("error").toString());
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractInvoiceInfoVO> info(@PathVariable(value="id") String id) {
        RkContractInvoiceInfoVO vo;
        RkContractInvoiceEntity entity = this.rkContractInvoiceService.getInfo(id);
        vo.setCustomerName(ObjectUtil.isEmpty((Object)(vo = (RkContractInvoiceInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractInvoiceInfoVO.class)).getCustomerId()) ? "" : ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)vo.getCustomerId()))).getName());
        vo.setContractName(ObjectUtil.isEmpty((Object)vo.getContractId()) ? "" : ((RkContractEntity)this.contractService.getById((Serializable)((Object)vo.getContractId()))).getContractName());
        vo.setHandledByName(this.baseDataUtil.userSelectValueNoAccount(vo.getHandledBy()));
        vo.setRateDesc(this.baseDataUtil.getDictName(vo.getRate(), "invoiceRate"));
        vo.setInvoiceTypeDesc(this.baseDataUtil.getDictName(vo.getInvoiceType(), "invoiceType"));
        vo.setState(this.baseDataUtil.getDictName(vo.getState(), "invoiceState"));
        vo.setDeliveryPerson(this.baseDataUtil.userSelectValueNoAccount(vo.getDeliveryPerson()));
        vo.setDeliveryWayDesc(this.baseDataUtil.getDictName(vo.getDeliveryWay(), "deliveryWay"));
        DictionaryDataEntity deliInfo = (DictionaryDataEntity)this.dictionaryDataService.getById((Serializable)((Object)vo.getDeliveryWay()));
        if (!ObjectUtil.isEmpty((Object)deliInfo)) {
            vo.setDeliveryWayEnCode(deliInfo.getEnCode());
        }
        vo.setCustomerName(ObjectUtil.isEmpty((Object)vo.getCustomerId()) ? "" : ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)vo.getCustomerId()))).getName());
        vo.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)vo.getContractId()));
        if (!ObjectUtil.isEmpty((Object)byId)) {
            vo.setContractName(byId.getContractName());
            vo.setCustomerName(((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)byId.getCustomerId()))).getName());
            vo.setAgentId(byId.getAgentId());
            if (!ObjectUtil.isEmpty((Object)byId.getIsAgent()) && byId.getIsAgent() == 1) {
                vo.setAgentName(((RkAgentEntity)this.agentService.getById((Serializable)((Object)byId.getAgentId()))).getName());
            } else {
                vo.setAgentName(vo.getCustomerName());
            }
            vo.setIsAgent(byId.getIsAgent());
            vo.setContractCode(byId.getContractCode());
            vo.setRegion(this.baseDataUtil.provinceData(byId.getRegion()));
            vo.setSalerId(byId.getSalerName());
        }
        List<RkContractInvoiceDetailEntity> listByInvoiceId = this.contractInvoiceDetailService.getListByInvoiceId(id);
        List jsonToList = JsonUtil.getJsonToList(listByInvoiceId, RkContractInvoiceDetailModel.class);
        vo.setRkcontractinvoicedetailList(jsonToList);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractInvoiceInfoVO> detailInfo(@PathVariable(value="id") String id) {
        DictionaryDataEntity dataEntity;
        RkContractInvoiceEntity entity = this.rkContractInvoiceService.getInfo(id);
        RkContractInvoiceInfoVO vo = (RkContractInvoiceInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractInvoiceInfoVO.class);
        vo.setHandledByName(this.baseDataUtil.userSelectValueNoAccount(vo.getHandledBy()));
        vo.setRateDesc(this.baseDataUtil.getDictName(vo.getRate(), "invoiceRate"));
        vo.setInvoiceTypeDesc(this.baseDataUtil.getDictName(vo.getInvoiceType(), "invoiceType"));
        vo.setState(this.baseDataUtil.getDictName(vo.getState(), "invoiceState"));
        vo.setDeliveryPerson(this.baseDataUtil.userSelectValueNoAccount(vo.getDeliveryPerson()));
        vo.setDeliveryWayDesc(this.baseDataUtil.getDictName(vo.getDeliveryWay(), "deliveryWay"));
        if (StrUtil.isNotEmpty((CharSequence)vo.getDeliveryWay()) && ObjectUtil.isNotNull((Object)(dataEntity = (DictionaryDataEntity)this.dictionaryDataService.getById((Serializable)((Object)vo.getDeliveryWay()))))) {
            vo.setDeliveryWayEnCode(dataEntity.getEnCode());
        }
        vo.setCustomerName(ObjectUtil.isEmpty((Object)vo.getCustomerId()) ? "" : ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)vo.getCustomerId()))).getName());
        vo.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        vo.setReceiver(this.baseDataUtil.userSelectValueNoAccount(vo.getReceiver()));
        vo.setReceiverDepartmentTree(this.baseDataUtil.comSelectValues(vo.getReceiverDepartmentTree()));
        vo.setReceiverDepartment(this.baseDataUtil.comSelectValues(vo.getReceiverDepartment()));
        RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)vo.getContractId()));
        if (!ObjectUtil.isEmpty((Object)byId)) {
            vo.setContractName(byId.getContractName());
            vo.setCustomerName(((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)byId.getCustomerId()))).getName());
            if (!ObjectUtil.isEmpty((Object)byId.getIsAgent()) && byId.getIsAgent() == 1) {
                vo.setAgentName(((RkAgentEntity)this.agentService.getById((Serializable)((Object)byId.getAgentId()))).getName());
            } else {
                vo.setAgentName(vo.getCustomerName());
            }
            vo.setIsAgent(byId.getIsAgent());
            vo.setContractCode(byId.getContractCode());
            vo.setRegion(this.baseDataUtil.provinceData(byId.getRegion()));
            vo.setSalerId(byId.getSalerName());
        }
        List<RkContractInvoiceDetailEntity> listByInvoiceId = this.contractInvoiceDetailService.getListByInvoiceId(id);
        List jsonToList = JsonUtil.getJsonToList(listByInvoiceId, RkContractInvoiceDetailModel.class);
        vo.setRkcontractinvoicedetailList(jsonToList);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkContractInvoiceUpForm rkContractInvoiceUpForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            RkContractInvoiceEntity entity = this.rkContractInvoiceService.getInfo(id);
            if (entity != null) {
                rkContractInvoiceUpForm.setCreatorUserId(entity.getCreatorUserId());
                HashMap map = this.rkContractInvoiceService.updateInvoice(rkContractInvoiceUpForm);
                if (ObjectUtil.isEmpty(map.get("error"))) {
                    return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
                }
                return ActionResult.fail((String)map.get("error").toString());
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            RkContractInvoiceEntity entity = this.rkContractInvoiceService.getInfo(id);
            if (entity != null) {
                this.rkContractInvoiceService.deleteInvoice(entity);
            }
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
    }

    @GetMapping(value={"/invoiceNumber/{invoiceNumber}"})
    public ActionResult checkInvoiceNumber(@PathVariable(value="invoiceNumber") String invoiceNumber) {
        List<RkContractInvoiceEntity> byInvoiceNumber = this.rkContractInvoiceService.getByInvoiceNumber(invoiceNumber);
        return ActionResult.success(byInvoiceNumber);
    }

    @GetMapping(value={"/expressNumber/{expressNumber}"})
    public ActionResult checkExpressNumber(@PathVariable(value="expressNumber") String expressNumber) {
        List<RkContractInvoiceEntity> list = this.rkContractInvoiceService.getByExpressNumber(expressNumber);
        return ActionResult.success(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping(value={"receiver"})
    public ActionResult receiver(@RequestBody RkContractInvoiceReceiveCrForm invoiceReceiveCrForm) {
        Object object = this.$lock;
        synchronized (object) {
            RkContractInvoiceEntity byId = (RkContractInvoiceEntity)this.rkContractInvoiceService.getById((Serializable)((Object)invoiceReceiveCrForm.getId()));
            if (ObjectUtil.isEmpty((Object)byId)) {
                return ActionResult.fail((String)"\u53d1\u7968\u4e0d\u5b58\u5728");
            }
            byId.setIsReceiver(1);
            RkContractInvoiceEntity jsonToBean = (RkContractInvoiceEntity)JsonUtil.getJsonToBean((Object)invoiceReceiveCrForm, RkContractInvoiceEntity.class);
            byId.setReceiver(jsonToBean.getReceiver());
            byId.setReceiverDepartment(jsonToBean.getReceiverDepartment());
            byId.setReceiverDepartmentTree(jsonToBean.getReceiverDepartmentTree());
            byId.setReceiverRemark(jsonToBean.getReceiverRemark());
            byId.setReceiverTime(jsonToBean.getReceiverTime());
            this.rkContractInvoiceService.update(invoiceReceiveCrForm.getId(), byId);
            return ActionResult.success((String)"\u9886\u53d6\u6210\u529f");
        }
    }

    @GetMapping(value={"/Actions/Export/detail"})
    public ActionResult ExportDetail(RkContractInvoiceDetailExport rkContractInvoiceDetailExport) {
        UserInfo userInfo = this.userProvider.get();
        if (StringUtil.isEmpty((String)rkContractInvoiceDetailExport.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        List<RkContractInvoiceDetailEntity> listByInvoiceId = this.contractInvoiceDetailService.getListByInvoiceId(rkContractInvoiceDetailExport.getInvoiceId());
        listByInvoiceId.stream().forEach(entity -> {
            entity.setContractId(((RkContractEntity)this.contractService.getById((Serializable)((Object)entity.getContractId()))).getContractName());
            if (StrUtil.equals((CharSequence)entity.getCustomerId(), (CharSequence)entity.getAgentId())) {
                entity.setCustomerId(((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()))).getName());
                entity.setAgentId(entity.getCustomerId());
            } else {
                entity.setCustomerId(((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()))).getName());
                entity.setAgentId(((RkAgentEntity)this.agentService.getById((Serializable)((Object)entity.getAgentId()))).getName());
            }
        });
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listByInvoiceId, (String)"yyyy-MM-dd"));
        String[] keys = !StringUtil.isEmpty((String)rkContractInvoiceDetailExport.getSelectKey()) ? rkContractInvoiceDetailExport.getSelectKey().split(",") : new String[]{};
        DownloadVO vo = this.creatModelExcelDeail(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkContractInvoicePaginationExportModel rkContractInvoicePaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkContractInvoicePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkContractInvoicePagination rkContractInvoicePagination = (RkContractInvoicePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractInvoicePaginationExportModel), RkContractInvoicePagination.class));
        UserInfo userInfo = this.userProvider.get();
        if (CollectionUtil.isNotEmpty(rkContractInvoicePagination.getRegion())) {
            List searchRegion = CollectionUtil.list((boolean)false);
            rkContractInvoicePagination.getRegion().stream().forEach(l -> searchRegion.add(l.get(0)));
            rkContractInvoicePagination.setSearchRegion(searchRegion);
        }
        rkContractInvoicePagination.setCompanyId(userInfo.getOrganizeId());
        List<RkContractInvoiceEntity> list = this.rkContractInvoiceService.getTypeList(rkContractInvoicePagination, rkContractInvoicePaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, RkContractInvoiceListVO.class);
        for (RkContractInvoiceListVO rkContractInvoiceVO : listVO) {
            rkContractInvoiceVO.setHandledBy(this.baseDataUtil.userSelectValueNoAccount(rkContractInvoiceVO.getHandledBy()));
            rkContractInvoiceVO.setRate(this.baseDataUtil.getDictName(rkContractInvoiceVO.getRate(), "invoiceRate"));
            rkContractInvoiceVO.setInvoiceType(this.baseDataUtil.getDictName(rkContractInvoiceVO.getInvoiceType(), "invoiceType"));
            rkContractInvoiceVO.setStateDesc(this.baseDataUtil.getDictName(rkContractInvoiceVO.getState(), "invoiceState"));
            rkContractInvoiceVO.setDeliveryPerson(this.baseDataUtil.userSelectValueNoAccount(rkContractInvoiceVO.getDeliveryPerson()));
            rkContractInvoiceVO.setDeliveryWay(this.baseDataUtil.getDictName(rkContractInvoiceVO.getDeliveryWay(), "deliveryWay"));
            rkContractInvoiceVO.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(rkContractInvoiceVO.getCreatorUserId()));
            if (ObjectUtil.isNotNull((Object)rkContractInvoiceVO.getInvoiceDate())) {
                rkContractInvoiceVO.setInvoiceDateDesc(DateUtil.dateToString((Date)rkContractInvoiceVO.getInvoiceDate(), (String)"yyyy-MM-dd"));
            }
            rkContractInvoiceVO.setIsReceiverDesc(rkContractInvoiceVO.getIsReceiver() == 1 ? "\u662f" : "\u5426");
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)rkContractInvoiceVO.getContractId()));
            if (!ObjectUtil.isEmpty((Object)byId)) {
                rkContractInvoiceVO.setContractName(byId.getContractName());
                rkContractInvoiceVO.setCustomerName(((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)byId.getCustomerId()))).getName());
                if (!ObjectUtil.isEmpty((Object)byId.getIsAgent()) && byId.getIsAgent() == 1) {
                    rkContractInvoiceVO.setAgentName(((RkAgentEntity)this.agentService.getById((Serializable)((Object)byId.getAgentId()))).getName());
                } else {
                    rkContractInvoiceVO.setAgentName(rkContractInvoiceVO.getCustomerName());
                }
                rkContractInvoiceVO.setContractCode(byId.getContractCode());
                rkContractInvoiceVO.setRegion(this.baseDataUtil.provinceData(byId.getRegion()));
            }
            List<RkContractInvoiceDetailEntity> listByInvoiceId = this.contractInvoiceDetailService.getListByInvoiceId(rkContractInvoiceVO.getId());
            String collect = listByInvoiceId.stream().map(RkContractInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.joining(","));
            rkContractInvoiceVO.setInvoiceNumber(collect);
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkContractInvoicePaginationExportModel.getSelectKey()) ? rkContractInvoicePaginationExportModel.getSelectKey().split(",") : new String[]{};
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block56: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block56;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block56;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u5bf9\u8c61", (Object)"agentName"));
                        continue block56;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerName"));
                        continue block56;
                    }
                    case "isReceiverDesc": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u9886\u53d6", (Object)"isReceiverDesc"));
                        continue block56;
                    }
                    case "region": {
                        entitys.add(new ExcelExportEntity("\u5927\u533a", (Object)"region"));
                        continue block56;
                    }
                    case "handledBy": {
                        entitys.add(new ExcelExportEntity("\u5f00\u7968\u4eba", (Object)"handledBy"));
                        continue block56;
                    }
                    case "invoiceNumber": {
                        entitys.add(new ExcelExportEntity("\u53d1\u7968\u53f7", (Object)"invoiceNumber"));
                        continue block56;
                    }
                    case "invoiceDateDesc": {
                        entitys.add(new ExcelExportEntity("\u5f00\u7968\u65e5\u671f", (Object)"invoiceDateDesc"));
                        continue block56;
                    }
                    case "rate": {
                        entitys.add(new ExcelExportEntity("\u7a0e\u7387", (Object)"rate"));
                        continue block56;
                    }
                    case "invoiceAmount": {
                        ExcelExportEntity excelExportEntity = new ExcelExportEntity("\u53d1\u7968\u91d1\u989d(\u5143)", (Object)"invoiceAmount");
                        excelExportEntity.setType(10);
                        entitys.add(excelExportEntity);
                        continue block56;
                    }
                    case "taxAmount": {
                        entitys.add(new ExcelExportEntity("\u7a0e\u989d(\u5143)", (Object)"taxAmount"));
                        continue block56;
                    }
                    case "invoiceType": {
                        entitys.add(new ExcelExportEntity("\u53d1\u7968\u7c7b\u578b", (Object)"invoiceType"));
                        continue block56;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u767b\u8bb0\u4eba", (Object)"creatorUserId"));
                        continue block56;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u767b\u8bb0\u65e5\u671f", (Object)"creatorTime"));
                        continue block56;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"description"));
                        continue block56;
                    }
                    case "stateDesc": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"stateDesc"));
                        continue block56;
                    }
                    case "deliveryPerson": {
                        entitys.add(new ExcelExportEntity("\u9001\u7968\u4eba", (Object)"deliveryPerson"));
                        continue block56;
                    }
                    case "deliveryWay": {
                        entitys.add(new ExcelExportEntity("\u9001\u7968\u65b9\u5f0f", (Object)"deliveryWay"));
                        continue block56;
                    }
                    case "hospitalPerson": {
                        entitys.add(new ExcelExportEntity("\u7b7e\u6536\u4eba", (Object)"hospitalPerson"));
                        continue block56;
                    }
                    case "expressNumber": {
                        entitys.add(new ExcelExportEntity("\u5feb\u9012\u5355\u53f7", (Object)"expressNumber"));
                        continue block56;
                    }
                    case "expressRemark": {
                        entitys.add(new ExcelExportEntity("\u5feb\u9012\u5907\u6ce8", (Object)"expressRemark"));
                        continue block56;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u53d1\u7968\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u53d1\u7968\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcelDeail(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block28: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "contractId": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractId"));
                        continue block28;
                    }
                    case "agentId": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u5bf9\u8c61", (Object)"agentId"));
                        continue block28;
                    }
                    case "customerId": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerId"));
                        continue block28;
                    }
                    case "invoiceNumber": {
                        entitys.add(new ExcelExportEntity("\u53d1\u7968\u53f7", (Object)"invoiceNumber"));
                        continue block28;
                    }
                    case "invoiceAmount": {
                        ExcelExportEntity invoiceAmount = new ExcelExportEntity("\u53d1\u7968\u91d1\u989d(\u5143)", (Object)"invoiceAmount");
                        invoiceAmount.setType(10);
                        entitys.add(invoiceAmount);
                        continue block28;
                    }
                    case "amountExcludingTax": {
                        ExcelExportEntity amountExcludingTax = new ExcelExportEntity("\u4e0d\u542b\u7a0e\u91d1\u989d(\u5143)", (Object)"amountExcludingTax");
                        amountExcludingTax.setType(10);
                        entitys.add(amountExcludingTax);
                        continue block28;
                    }
                    case "taxAmount": {
                        ExcelExportEntity taxAmount = new ExcelExportEntity("\u7a0e\u989d(\u5143)", (Object)"taxAmount");
                        taxAmount.setType(10);
                        entitys.add(taxAmount);
                        continue block28;
                    }
                    case "invoiceDate": {
                        entitys.add(new ExcelExportEntity("\u5f00\u7968\u65e5\u671f", (Object)"invoiceDate"));
                        continue block28;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u53d1\u7968\u660e\u7ec6\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u53d1\u7968\u660e\u7ec6\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u9500\u552e\u53d1\u7968\u5bfc\u5165\u6a21\u677f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u9500\u552e\u53d1\u7968\u5bfc\u5165\u6a21\u677f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List ImportList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, ContractInvoiceImportVO.class);
        if (CollectionUtil.isEmpty((Collection)ImportList)) {
            return ActionResult.fail((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ImportList.size() > 3000) {
            return ActionResult.fail((String)"\u6700\u591a\u5bfc\u5165\u6570\u636e3000\u6761");
        }
        Map<String, Object> map = this.rkContractInvoiceService.importPreview(ImportList);
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<ContractInvoiceImportReturnVO> ImportData(@RequestBody ContractInvoiceImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), ContractInvoiceImportVO.class);
        ContractInvoiceImportReturnVO result = this.rkContractInvoiceService.importData(dataList);
        return ActionResult.success((Object)result);
    }

    @ApiOperation(value="\u5bfc\u51fa\u9519\u8bef\u62a5\u544a")
    @PostMapping(value={"/ExportExceptionData"})
    public ActionResult<DownloadVO> exportExceptionData(@RequestBody ContractInvoiceImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), Object.class);
        DownloadVO vo = this.rkContractInvoiceService.exportExceptionData(dataList, new ContractInvoiceImportVO());
        return ActionResult.success((Object)vo);
    }
}

