/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkContractPaymentEntity;
import com.bringspring.contract.model.rkcontractpayment.ContractPaymentImportReturnVO;
import com.bringspring.contract.model.rkcontractpayment.ContractPaymentImportVO;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentCrForm;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentInfoVO;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentListVO;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentPagination;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentUpForm;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5408\u540c\u4ed8\u6b3e\u65b9\u5f0f"}, value="contract")
@RequestMapping(value={"/api/contract/RkContractPayment"})
public class RkContractPaymentController {
    private static final Logger log = LoggerFactory.getLogger(RkContractPaymentController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractPaymentService rkContractPaymentService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RkContractService contractService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkContractPaymentPagination rkContractPaymentPagination) throws IOException {
        List<RkContractPaymentEntity> list = this.rkContractPaymentService.getList(rkContractPaymentPagination);
        for (RkContractPaymentEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, RkContractPaymentListVO.class);
        for (RkContractPaymentListVO rkContractPaymentListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractPaymentPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkContractPaymentCrForm rkContractPaymentCrForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            RkContractPaymentEntity entity = (RkContractPaymentEntity)JsonUtil.getJsonToBean((Object)rkContractPaymentCrForm, RkContractPaymentEntity.class);
            entity.setId(mainId);
            this.rkContractPaymentService.save(entity);
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
        }
    }

    @GetMapping(value={"/getListNotPlanByContractId/{contractId}"})
    public ActionResult getListNotPlanByContractId(@PathVariable(value="contractId") String contractId) {
        List<RkContractPaymentEntity> listByContractId = this.rkContractPaymentService.getListByContractIdNotPlan(contractId);
        List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractPaymentListVO.class);
        jsonToList.stream().forEach(vo -> vo.setPaymentTypeEnCode(((DictionaryDataEntity)this.dictionaryDataService.getById((Serializable)((Object)vo.getPaymentType()))).getEnCode()));
        return ActionResult.success((Object)jsonToList);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractPaymentInfoVO> info(@PathVariable(value="id") String id) {
        RkContractPaymentEntity entity = this.rkContractPaymentService.getInfo(id);
        RkContractPaymentInfoVO vo = (RkContractPaymentInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractPaymentInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractPaymentInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkContractPaymentEntity entity = this.rkContractPaymentService.getInfo(id);
        RkContractPaymentInfoVO vo = (RkContractPaymentInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractPaymentInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkContractPaymentUpForm rkContractPaymentUpForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            RkContractPaymentEntity entity = this.rkContractPaymentService.getInfo(id);
            if (entity != null) {
                RkContractPaymentEntity subentity = (RkContractPaymentEntity)JsonUtil.getJsonToBean((Object)rkContractPaymentUpForm, RkContractPaymentEntity.class);
                this.rkContractPaymentService.update(id, subentity);
                return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            RkContractPaymentEntity entity = this.rkContractPaymentService.getInfo(id);
            if (entity != null) {
                this.rkContractPaymentService.delete(entity);
            }
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u4ed8\u6b3e\u65b9\u5f0f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u4ed8\u6b3e\u65b9\u5f0f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List contractList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, ContractPaymentImportVO.class);
        List list = JsonUtil.getJsonToList((Object)contractList, Object.class);
        Map<String, Object> map = this.rkContractPaymentService.importPreview(list, new ContractPaymentImportVO());
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<ContractPaymentImportReturnVO> ImportData(@RequestBody ContractPaymentImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), ContractPaymentImportVO.class);
        ContractPaymentImportReturnVO result = this.rkContractPaymentService.importData(dataList);
        return ActionResult.success((Object)result);
    }

    @ApiOperation(value="\u5bfc\u51fa\u9519\u8bef\u62a5\u544a")
    @PostMapping(value={"/ExportExceptionData"})
    public ActionResult<DownloadVO> exportExceptionData(@RequestBody ContractPaymentImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), Object.class);
        DownloadVO vo = this.contractService.exportExceptionData(dataList, new ContractPaymentImportVO());
        return ActionResult.success((Object)vo);
    }
}

