/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkContractPilotProjectEntity;
import com.bringspring.contract.model.rkcontractpilotproject.RkContractPilotProjectCrForm;
import com.bringspring.contract.model.rkcontractpilotproject.RkContractPilotProjectInfoVO;
import com.bringspring.contract.model.rkcontractpilotproject.RkContractPilotProjectListVO;
import com.bringspring.contract.model.rkcontractpilotproject.RkContractPilotProjectPagination;
import com.bringspring.contract.model.rkcontractpilotproject.RkContractPilotProjectPaginationExportModel;
import com.bringspring.contract.model.rkcontractpilotproject.RkContractPilotProjectUpForm;
import com.bringspring.contract.service.RkContractPilotProjectService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bd5\u70b9\u63a8\u5e7f\u9879\u76ee\u5ba1\u6279\u7533\u8bf7"}, value="crm")
@RequestMapping(value={"/api/crm/RkContractPilotProject"})
public class RkContractPilotProjectController {
    private static final Logger log = LoggerFactory.getLogger(RkContractPilotProjectController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractPilotProjectService rkContractPilotProjectService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkContractPilotProjectPagination rkContractPilotProjectPagination) throws IOException {
        List<RkContractPilotProjectEntity> list = this.rkContractPilotProjectService.getList(rkContractPilotProjectPagination);
        for (RkContractPilotProjectEntity iterator : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, RkContractPilotProjectListVO.class);
        for (RkContractPilotProjectListVO rkContractPilotProjectVO : listVO) {
            rkContractPilotProjectVO.setPilotTypeName(this.baseDataUtil.getDictName(rkContractPilotProjectVO.getPilotType(), "pilotTypeOptions"));
        }
        for (RkContractPilotProjectListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractPilotProjectPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid RkContractPilotProjectCrForm rkContractPilotProjectCrForm) throws DataException, WorkFlowException {
        String visualId = "574933311277814085";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkContractPilotProjectEntity entity = (RkContractPilotProjectEntity)JsonUtil.getJsonToBean((Object)((Object)rkContractPilotProjectCrForm), RkContractPilotProjectEntity.class);
        entity.setId(mainId);
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setCreatorUserName(userInfo.getRealName());
        entity.setCreatorTime((Date)DateUtil.date());
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setPilotAreaName(this.baseDataUtil.provinceData(entity.getPilotArea()));
        this.rkContractPilotProjectService.save(entity);
        FlowUtil.saveOrSubmit((String)rkContractPilotProjectCrForm.getTaskId(), (String)visualId, (String)rkContractPilotProjectCrForm.getTemplateId(), (String)mainId, (Object)((Object)rkContractPilotProjectCrForm), (Integer)rkContractPilotProjectCrForm.getStatus(), (String)rkContractPilotProjectCrForm.getProjectName());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkContractPilotProjectPaginationExportModel rkContractPilotProjectPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)rkContractPilotProjectPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkContractPilotProjectPagination rkContractPilotProjectPagination = (RkContractPilotProjectPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractPilotProjectPaginationExportModel), RkContractPilotProjectPagination.class));
        List<RkContractPilotProjectEntity> list = this.rkContractPilotProjectService.getTypeList(rkContractPilotProjectPagination, rkContractPilotProjectPaginationExportModel.getDataType());
        for (RkContractPilotProjectEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, RkContractPilotProjectListVO.class);
        for (RkContractPilotProjectListVO rkContractPilotProjectVO : listVO) {
            rkContractPilotProjectVO.setPilotType(this.baseDataUtil.getDictName(rkContractPilotProjectVO.getPilotType(), "pilotTypeOptions"));
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)rkContractPilotProjectPaginationExportModel.getSelectKey()) ? rkContractPilotProjectPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block28: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerName"));
                        continue block28;
                    }
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName"));
                        continue block28;
                    }
                    case "pilotAreaName": {
                        entitys.add(new ExcelExportEntity("\u63a8\u5e7f\u533a\u57df", (Object)"pilotAreaName"));
                        continue block28;
                    }
                    case "pilotType": {
                        entitys.add(new ExcelExportEntity("\u63a8\u5e7f\u7c7b\u578b", (Object)"pilotType"));
                        continue block28;
                    }
                    case "pilotCycle": {
                        entitys.add(new ExcelExportEntity("\u5468\u671f\u5f00\u59cb", (Object)"pilotCycleStart"));
                        entitys.add(new ExcelExportEntity("\u5468\u671f\u7ed3\u675f", (Object)"pilotCycleEnd"));
                        continue block28;
                    }
                    case "pilotReason": {
                        entitys.add(new ExcelExportEntity("\u8bd5\u70b9\u63a8\u5e7f\u539f\u56e0", (Object)"pilotReason"));
                        continue block28;
                    }
                    case "creatorUserName": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4eba", (Object)"creatorUserName"));
                        continue block28;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u65e5\u671f", (Object)"creatorTime"));
                        continue block28;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractPilotProjectInfoVO> info(@PathVariable(value="id") String id) {
        RkContractPilotProjectEntity entity = this.rkContractPilotProjectService.getInfo(id);
        RkContractPilotProjectInfoVO vo = (RkContractPilotProjectInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractPilotProjectInfoVO.class);
        vo.setPilotTypeName(this.baseDataUtil.getDictName(vo.getPilotType(), "pilotTypeOptions"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkContractPilotProjectUpForm rkContractPilotProjectUpForm) throws DataException, WorkFlowException {
        String visualId = "574933311277814085";
        UserInfo userInfo = this.userProvider.get();
        RkContractPilotProjectEntity entity = this.rkContractPilotProjectService.getInfo(id);
        if (entity != null) {
            RkContractPilotProjectEntity subentity = (RkContractPilotProjectEntity)JsonUtil.getJsonToBean((Object)((Object)rkContractPilotProjectUpForm), RkContractPilotProjectEntity.class);
            subentity.setPilotAreaName(this.baseDataUtil.provinceData(subentity.getPilotArea()));
            this.rkContractPilotProjectService.update(id, subentity);
            FlowUtil.saveOrSubmit((String)rkContractPilotProjectUpForm.getTaskId(), (String)visualId, (String)rkContractPilotProjectUpForm.getTemplateId(), (String)id, (Object)((Object)rkContractPilotProjectUpForm), (Integer)rkContractPilotProjectUpForm.getStatus(), (String)rkContractPilotProjectUpForm.getProjectName());
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkContractPilotProjectEntity entity = this.rkContractPilotProjectService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null && taskEntity != null) {
                try {
                    FlowUtil.delete((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.rkContractPilotProjectService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

