/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractPaymentEntity;
import com.bringspring.contract.entity.RkContractProcureEntity;
import com.bringspring.contract.entity.RkContractProcureRelationEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractTaxEntity;
import com.bringspring.contract.entity.RkProcureInvoiceEntity;
import com.bringspring.contract.entity.RkProcureInvoiceRelationEntity;
import com.bringspring.contract.entity.RkPurchaseApplyEntity;
import com.bringspring.contract.entity.RkpurchaseapplydetaillistEntity;
import com.bringspring.contract.model.rkattachment.RkAttachmentCrForm;
import com.bringspring.contract.model.rkcontract.RkContractPaymentVO;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentListVO;
import com.bringspring.contract.model.rkcontractprocure.OaContractInternalTransactionInfo;
import com.bringspring.contract.model.rkcontractprocure.ProcureImportReturnVO;
import com.bringspring.contract.model.rkcontractprocure.ProcureImportVO;
import com.bringspring.contract.model.rkcontractprocure.RkContractProcureCrForm;
import com.bringspring.contract.model.rkcontractprocure.RkContractProcureInfoVO;
import com.bringspring.contract.model.rkcontractprocure.RkContractProcureListVO;
import com.bringspring.contract.model.rkcontractprocure.RkContractProcurePagination;
import com.bringspring.contract.model.rkcontractprocure.RkContractProcurePaginationExportModel;
import com.bringspring.contract.model.rkcontractprocure.RkContractProcureUpForm;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectListVO;
import com.bringspring.contract.model.rkcontracttax.RkContractTaxInfoVO;
import com.bringspring.contract.service.OaContractInternalCrmService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProcureRelationService;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractTaxService;
import com.bringspring.contract.service.RkProcureInvoiceRelationService;
import com.bringspring.contract.service.RkProcureInvoiceService;
import com.bringspring.contract.service.RkPurchaseApplyService;
import com.bringspring.contract.service.RkpurchaseapplydetaillistService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.crm.util.CrmReminderEnum;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u91c7\u8d2d\u5408\u540c\u5ba1\u6279"}, value="contract")
@RequestMapping(value={"/api/contract/RkContractProcure"})
public class RkContractProcureController {
    private static final Logger log = LoggerFactory.getLogger(RkContractProcureController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private RkContractPaymentService contractPaymentService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractProcureRelationService contractProcureRelationService;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private RkProcureInvoiceRelationService rkProcureInvoiceRelationService;
    @Autowired
    private RkProcureInvoiceService rkProcureInvoiceService;
    @Autowired
    private RkpurchaseapplydetaillistService rkpurchaseapplydetaillistService;
    @Autowired
    private RkContractTaxService rkContractTaxService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkPurchaseApplyService rkPurchaseApplyService;
    @Autowired
    private RkContractProcureRelationService rkContractProcureRelationService;
    @Autowired
    private OaContractInternalCrmService oaContractInternalCrmService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkContractProcurePagination rkContractProcurePagination) throws IOException {
        List<RkContractProcureEntity> list = this.rkContractProcureService.getList(rkContractProcurePagination);
        for (RkContractProcureEntity rkContractProcureEntity : list) {
            rkContractProcureEntity.setApplyId(this.baseDataUtil.userSelectValueNoAccount(rkContractProcureEntity.getApplyId()));
            rkContractProcureEntity.setSupplierId(this.baseDataUtil.userSelectValueNoAccount(rkContractProcureEntity.getSupplierId()));
        }
        List listVO = JsonUtil.getJsonToList(list, RkContractProcureListVO.class);
        for (RkContractProcureListVO rkContractProcureVO : listVO) {
            List<RkProcureInvoiceRelationEntity> listByInvoice = this.rkProcureInvoiceRelationService.listByInvoice(rkContractProcureVO.getId());
            List collect = listByInvoice.stream().map(RkProcureInvoiceRelationEntity::getInvoiceId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                List list1 = this.rkProcureInvoiceService.listByIds(collect);
                List<RkProcureInvoiceEntity> complete = list1.stream().filter(invoice -> invoice.getEnableMark().equals("complete")).collect(Collectors.toList());
                rkContractProcureVO.setInvoiceList(complete);
            } else {
                rkContractProcureVO.setInvoiceList(new ArrayList<RkProcureInvoiceEntity>());
            }
            if (!ObjectUtil.isNotEmpty((Object)rkContractProcureVO.getProjectId())) continue;
            RkContractProjectListVO projectInfo = this.rkContractProcureService.getProjectInfo(rkContractProcureVO.getProjectId());
            rkContractProcureVO.setProjectList(projectInfo);
        }
        for (RkContractProcureListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractProcurePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping
    @RepeatSubmit
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkContractProcureCrForm rkContractProcureCrForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            Map<String, Object> temp;
            OaContractInternalTransactionInfo oaContractInternalTransactionInfo;
            String[] split;
            String flowEngineId = "484638330001034437";
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            String organizeId = userInfo.getOrganizeId();
            rkContractProcureCrForm.setCompanyId(organizeId);
            if (!StrUtil.equals((CharSequence)"1", (CharSequence)rkContractProcureCrForm.getIsInternalContract())) {
                rkContractProcureCrForm.setProcureCode(this.baseDataUtil.getBillNumber(organizeId + "procureCode", Boolean.valueOf(false)));
            }
            RkContractProjectListVO projectInfo = rkContractProcureCrForm.getProjectList();
            RkContractProcureEntity entity = (RkContractProcureEntity)JsonUtil.getJsonToBean((Object)((Object)rkContractProcureCrForm), RkContractProcureEntity.class);
            entity.setId(mainId);
            entity.setProcureType("0");
            if (ObjectUtil.isNotEmpty((Object)projectInfo)) {
                entity.setProjectId(projectInfo.getId());
                if (ObjectUtil.isNotEmpty((Object)projectInfo.getProjectHeader())) {
                    entity.setProjectManager(projectInfo.getProjectHeader());
                    entity.setProjectManagerName(this.baseDataUtil.userSelectValue(entity.getProjectManager()));
                    rkContractProcureCrForm.setSalesDepartment(projectInfo.getSaleDepartment());
                }
            }
            entity.setSalesPerson(rkContractProcureCrForm.getSalesPerson());
            entity.setApplyName(userInfo.getRealName());
            if (!ObjectUtil.isEmpty((Object)entity.getApplyDepartmentTree()) && (split = entity.getApplyDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",")).length > 0) {
                entity.setApplyDepartmentTreeName(this.baseDataUtil.comSelectValues(entity.getApplyDepartmentTree()));
                entity.setApplyDepartmentOne(split[0]);
                entity.setApplyDepartmentOneName(this.baseDataUtil.comSelectValues(entity.getApplyDepartmentOne()));
                entity.setApplyDepartment(split[split.length - 1]);
                entity.setApplyDepartmentName(this.baseDataUtil.comSelectValues(entity.getApplyDepartment()));
            }
            entity.setEnableMark(this.baseDataUtil.getDictName(entity.getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
            if (!ObjectUtil.isEmpty((Object)entity.getStampType())) {
                entity.setStampTypeName(this.baseDataUtil.getDictName(entity.getStampType(), Constants.STAMP_TYPE_DICT_ID));
            }
            entity.setInvoiceTaxName(this.baseDataUtil.getDictName(entity.getInvoiceTax(), Constants.CONTRACT_TAX_RATE_DICT_ID));
            entity.setInvoiceTypeName(this.baseDataUtil.getDictName(entity.getInvoiceType(), Constants.PROCURE_INVOICE_CODE));
            entity.setAccumulatePaymentAmount(BigDecimal.ZERO);
            entity.setAccumulateInvoiceAmount(BigDecimal.ZERO);
            entity.setNotPaymentAmount(BigDecimal.ZERO);
            List<RkpurchaseapplydetaillistEntity> purchaseApplyList = rkContractProcureCrForm.getPurchaseApplyList();
            if (CollectionUtil.isNotEmpty(purchaseApplyList)) {
                List applyUserList = purchaseApplyList.stream().map(RkpurchaseapplydetaillistEntity::getCreatorUserId).distinct().collect(Collectors.toList());
                entity.setManagerApplyUser(CollectionUtil.isNotEmpty(applyUserList) ? (String)applyUserList.get(0) : "");
                rkContractProcureCrForm.setManagerApplyUser(entity.getManagerApplyUser());
            }
            this.rkContractProcureService.save(entity);
            rkContractProcureCrForm.setStampTypeName(entity.getStampTypeName());
            rkContractProcureCrForm.setSalesPerson(entity.getSalesPerson());
            rkContractProcureCrForm.setProjectManager(entity.getProjectManager());
            rkContractProcureCrForm.setContractLevel(entity.getContractLevel());
            if (CollectionUtil.isNotEmpty(rkContractProcureCrForm.getPaymentMethodList())) {
                List<RkContractPaymentVO> paymentMethodList = rkContractProcureCrForm.getPaymentMethodList();
                paymentMethodList.stream().forEach(payment -> {
                    if (!ObjectUtil.isEmpty((Object)payment.getPaymentName()) && ObjectUtil.isEmpty((Object)payment.getPaymentType())) {
                        payment.setPaymentType(PinyinUtil.getFirstLetter((String)payment.getPaymentName(), (String)"").toUpperCase());
                    }
                });
                String objectToString = JsonUtil.getObjectToString(paymentMethodList);
                entity.setPaymentJson(objectToString);
                List jsonToList = JsonUtil.getJsonToList(paymentMethodList, RkContractPaymentEntity.class);
                jsonToList.stream().forEach(payment -> {
                    payment.setContractId(entity.getId());
                    payment.setId(RandomUtil.uuId());
                });
                this.contractPaymentService.saveBatch(jsonToList);
            }
            List<RkAttachmentCrForm> attachmentList = rkContractProcureCrForm.getAttachmentList();
            attachmentList.stream().forEach(attach -> {
                attach.setContractId(mainId);
                attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
            this.attachmentService.saveBatch(attachmentEntityList);
            if (CollectionUtil.isNotEmpty(purchaseApplyList)) {
                if (!"save".equals(rkContractProcureCrForm.getEnableMark())) {
                    purchaseApplyList.stream().forEach(purchaseApply -> this.rkpurchaseapplydetaillistService.addHtCode(mainId, rkContractProcureCrForm.getProcureCode(), String.valueOf(rkContractProcureCrForm.getStatus()), purchaseApply.getId()));
                } else {
                    purchaseApplyList.stream().forEach(purchaseApply -> purchaseApply.setHtCode(entity.getProcureCode()));
                    this.rkpurchaseapplydetaillistService.updateBatchById(purchaseApplyList);
                }
            }
            if (ObjectUtil.isNotEmpty((Object)entity.getInternalContractId()) && ObjectUtil.isNotEmpty((Object)(oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean(temp = this.oaContractInternalCrmService.getInfoById(entity.getInternalContractId()), OaContractInternalTransactionInfo.class)))) {
                rkContractProcureCrForm.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
                rkContractProcureCrForm.setInteralContractApplyUser(oaContractInternalTransactionInfo.getApplyUserId());
            }
            String flowTitle = (rkContractProcureCrForm.getProcureCode() == null ? "" : rkContractProcureCrForm.getProcureCode()) + "-" + rkContractProcureCrForm.getSupplierName();
            FlowUtil.saveOrSubmit((String)rkContractProcureCrForm.getTaskId(), (String)flowEngineId, (String)rkContractProcureCrForm.getTemplateId(), (String)mainId, (Object)((Object)rkContractProcureCrForm), (Integer)rkContractProcureCrForm.getStatus(), (String)flowTitle);
            if (rkContractProcureCrForm.getStatus() == 0) {
                return ActionResult.success((String)CrmReminderEnum.TS.getType());
            }
            return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractProcureInfoVO> info(@PathVariable(value="id") String id) {
        Map<String, Object> temp;
        OaContractInternalTransactionInfo oaContractInternalTransactionInfo;
        List jsonToList;
        List<RkContractPaymentEntity> listByContractId;
        RkContractProcureEntity entity = this.rkContractProcureService.getInfo(id);
        RkContractProcureInfoVO vo = (RkContractProcureInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractProcureInfoVO.class);
        if (StrUtil.isNotEmpty((CharSequence)entity.getApplyDepartmentTree())) {
            String[] split = entity.getApplyDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",");
            vo.setApplyDepartmentTree(Arrays.asList(split));
        }
        vo.setApplyDepartment(entity.getApplyDepartmentTreeName());
        vo.setProcureName(entity.getProcureName());
        vo.setApplyName(this.baseDataUtil.userSelectValueNoAccount(entity.getApplyId()));
        vo.setInvoiceTaxName(this.baseDataUtil.getDictName(entity.getInvoiceTax(), Constants.CONTRACT_TAX_RATE_DICT_ID));
        vo.setInvoiceTypeName(this.baseDataUtil.getDictName(entity.getInvoiceType(), Constants.PROCURE_INVOICE_CODE));
        vo.setStampTypeName(this.baseDataUtil.getDictName(entity.getStampType(), Constants.STAMP_TYPE_DICT_ID));
        vo.setPaymentMethodTypeName(this.baseDataUtil.getDictName(entity.getPaymentMethodType(), Constants.PROCURE_PAYMENT_CODE));
        vo.setApplyName(this.baseDataUtil.userSelectValueNoAccount(entity.getApplyId()));
        vo.setPartyAName(this.baseDataUtil.getDictName(entity.getPartyA(), "ContractInternalTransactionSignSubject"));
        List<RkContractTaxEntity> taxEntities = this.rkContractTaxService.listByContractId(id);
        if (CollectionUtil.isNotEmpty(taxEntities)) {
            List taxInfoList = JsonUtil.getJsonToList(taxEntities, RkContractTaxInfoVO.class);
            vo.setTaxList(taxInfoList);
        } else {
            vo.setTaxList(new ArrayList<RkContractTaxInfoVO>());
        }
        if (ObjectUtil.isEmpty((Object)entity.getProcureId())) {
            listByContractId = this.contractPaymentService.getListByContractId(id);
            jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractPaymentListVO.class);
            vo.setPaymentMethodList(jsonToList);
        } else {
            listByContractId = this.contractPaymentService.getListByContractId(entity.getProcureId());
            jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractPaymentListVO.class);
            vo.setPaymentMethodList(jsonToList);
        }
        List<RkProcureInvoiceRelationEntity> listByInvoice = this.rkProcureInvoiceRelationService.listByInvoice(id);
        List collect1 = listByInvoice.stream().map(RkProcureInvoiceRelationEntity::getInvoiceId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(collect1)) {
            List invoiceInfo = this.rkProcureInvoiceService.listByIds(collect1);
            List<RkProcureInvoiceEntity> complete = invoiceInfo.stream().filter(invoice -> invoice.getEnableMark().equals("complete")).collect(Collectors.toList());
            vo.setInvoiceList(complete);
        } else {
            ArrayList<RkProcureInvoiceEntity> list = new ArrayList<RkProcureInvoiceEntity>();
            vo.setInvoiceList(list);
        }
        List<RkpurchaseapplydetaillistEntity> listByPurchaseApply = this.rkpurchaseapplydetaillistService.listByProcureCode(entity.getProcureCode());
        listByPurchaseApply.stream().forEach(purchase -> {
            purchase.setPurchaseAmount(MathUtils.multiply(purchase.getApplyCount(), purchase.getApplyPrice()));
            if (ObjectUtil.isNotEmpty((Object)purchase.getArrivalDate())) {
                purchase.setArrivalDateTime(Long.parseLong(purchase.getArrivalDate()));
            }
            purchase.setApplyTaxRateName(this.baseDataUtil.getDictName(purchase.getApplyTaxRate(), "contractRate"));
            RkPurchaseApplyEntity info = this.rkPurchaseApplyService.getInfo(purchase.getParentId());
            if (ObjectUtil.isNotEmpty((Object)info)) {
                purchase.setProjectName(info.getProjectName());
                purchase.setParentCode(info.getFormId());
            }
        });
        vo.setPurchaseApplyList(listByPurchaseApply);
        if (ObjectUtil.isNotEmpty((Object)entity.getProjectId())) {
            RkContractProjectListVO projectInfo1 = this.rkContractProcureService.getProjectInfo(entity.getProjectId());
            vo.setProjectList(projectInfo1);
        }
        if (ObjectUtil.isNotEmpty((Object)entity.getInternalContractId()) && ObjectUtil.isNotEmpty((Object)(oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean(temp = this.oaContractInternalCrmService.getInfoById(entity.getInternalContractId()), OaContractInternalTransactionInfo.class)))) {
            vo.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
            vo.setInteralContractApplyUser(oaContractInternalTransactionInfo.getApplyUserId());
        }
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkContractProcureUpForm rkContractProcureUpForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            String flowEngineId = "484638330001034437";
            RkContractProcureEntity entity = this.rkContractProcureService.getInfo(id);
            RkContractProjectListVO projectList = rkContractProcureUpForm.getProjectList();
            RkContractProjectEntity projectInfo = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)projectList.getId()));
            if (entity != null) {
                Map<String, Object> temp;
                OaContractInternalTransactionInfo oaContractInternalTransactionInfo;
                RkContractProcureEntity subentity = (RkContractProcureEntity)JsonUtil.getJsonToBean((Object)((Object)rkContractProcureUpForm), RkContractProcureEntity.class);
                subentity.setStampTypeName(this.baseDataUtil.getDictName(subentity.getStampType(), Constants.STAMP_TYPE_DICT_ID));
                subentity.setSalesPerson(subentity.getSalesPerson());
                List<RkpurchaseapplydetaillistEntity> purchaseApplyList = rkContractProcureUpForm.getPurchaseApplyList();
                if (CollectionUtil.isNotEmpty(purchaseApplyList)) {
                    List applyUserList = purchaseApplyList.stream().map(RkpurchaseapplydetaillistEntity::getCreatorUserId).distinct().collect(Collectors.toList());
                    subentity.setManagerApplyUser(CollectionUtil.isNotEmpty(applyUserList) ? (String)applyUserList.get(0) : "");
                }
                rkContractProcureUpForm.setManagerApplyUser(subentity.getManagerApplyUser());
                this.rkContractProcureService.updateForm(id, rkContractProcureUpForm);
                rkContractProcureUpForm.setStampTypeName(subentity.getStampTypeName());
                rkContractProcureUpForm.setSalesPerson(subentity.getSalesPerson());
                rkContractProcureUpForm.setContractLevel(entity.getContractLevel());
                if (ObjectUtil.isNotEmpty((Object)projectInfo)) {
                    rkContractProcureUpForm.setProjectManager(projectInfo.getProjectHeader());
                }
                this.rkpurchaseapplydetaillistService.removeHtCode(rkContractProcureUpForm.getProcureCode());
                if (CollectionUtil.isNotEmpty(purchaseApplyList)) {
                    if (!"save".equals(rkContractProcureUpForm.getEnableMark())) {
                        purchaseApplyList.stream().forEach(purchaseApply -> this.rkpurchaseapplydetaillistService.addHtCode(subentity.getId(), rkContractProcureUpForm.getProcureCode(), String.valueOf(rkContractProcureUpForm.getStatus()), purchaseApply.getId()));
                    } else {
                        purchaseApplyList.stream().forEach(purchaseApply -> purchaseApply.setHtCode(entity.getProcureCode()));
                        this.rkpurchaseapplydetaillistService.updateBatchById(purchaseApplyList);
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)entity.getInternalContractId()) && ObjectUtil.isNotEmpty((Object)(oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean(temp = this.oaContractInternalCrmService.getInfoById(entity.getInternalContractId()), OaContractInternalTransactionInfo.class)))) {
                    rkContractProcureUpForm.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
                    rkContractProcureUpForm.setInteralContractApplyUser(oaContractInternalTransactionInfo.getApplyUserId());
                }
                String flowTitle = (rkContractProcureUpForm.getProcureCode() == null ? "" : rkContractProcureUpForm.getProcureCode()) + "-" + rkContractProcureUpForm.getSupplierName();
                FlowUtil.saveOrSubmit((String)rkContractProcureUpForm.getTaskId(), (String)flowEngineId, (String)rkContractProcureUpForm.getTemplateId(), (String)id, (Object)((Object)rkContractProcureUpForm), (Integer)rkContractProcureUpForm.getStatus(), (String)flowTitle);
                if (rkContractProcureUpForm.getStatus() == 0) {
                    return ActionResult.success((String)CrmReminderEnum.TS.getType());
                }
                return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            RkContractProcureEntity entity = this.rkContractProcureService.getInfo(id);
            if (entity != null) {
                FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
                if (taskEntity != null) {
                    try {
                        FlowUtil.deleteByProcessId((String)id);
                    }
                    catch (WorkFlowException e) {
                        e.printStackTrace();
                    }
                }
                this.rkContractProcureService.delete(entity);
            }
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult<Object> Uploader() {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().endsWith(".xlsx") || file.getOriginalFilename().endsWith(".xls")) {
            String filePath = XSSEscape.escape((String)this.configValueUtil.getTemporaryFilePath());
            String fileName = XSSEscape.escape((String)(RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file)));
            FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
            try {
                UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)(filePath + fileName), (String)"temporary", (String)fileName);
            }
            catch (IOException e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            DownloadVO vo = DownloadVO.builder().build();
            vo.setName(fileName);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u91c7\u8d2d\u5408\u540c\u6a21\u677f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u91c7\u8d2d\u5408\u540c\u6a21\u677f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List fileImportList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, ProcureImportVO.class);
        if (CollectionUtil.isEmpty((Collection)fileImportList)) {
            return ActionResult.fail((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fileImportList.size() > 200) {
            return ActionResult.fail((String)"\u6700\u591a\u5bfc\u5165\u6570\u636e200\u6761");
        }
        Map<String, Object> map = this.rkContractProcureService.importPreview(fileImportList);
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkContractProcurePaginationExportModel rkContractProcurePaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkContractProcurePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkContractProcurePagination procurePagination = (RkContractProcurePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractProcurePaginationExportModel), RkContractProcurePagination.class));
        String organizeId = this.userProvider.get().getOrganizeId();
        List<RkContractProcureEntity> list = this.rkContractProcureService.getTypeList(procurePagination, rkContractProcurePaginationExportModel.getDataType());
        for (RkContractProcureEntity rkContractProcureEntity : list) {
            rkContractProcureEntity.setApplyId(rkContractProcureEntity.getApplyName());
            rkContractProcureEntity.setInvoiceType(this.baseDataUtil.getDictName(rkContractProcureEntity.getInvoiceType(), Constants.PROCURE_INVOICE_CODE));
            rkContractProcureEntity.setInvoiceTax(this.baseDataUtil.getDictName(rkContractProcureEntity.getInvoiceTax(), Constants.CONTRACT_TAX_RATE_DICT_ID));
            rkContractProcureEntity.setPaymentMethodType(this.baseDataUtil.getDictName(rkContractProcureEntity.getPaymentMethodType(), Constants.PROCURE_PAYMENT_CODE));
        }
        List listVO = JsonUtil.getJsonToList(list, RkContractProcureListVO.class);
        for (RkContractProcureListVO rkContractProcureListVO : listVO) {
            List<RkContractProcureRelationEntity> listByContractId1 = this.contractProcureRelationService.listByContractId1(rkContractProcureListVO.getId());
            List collect1 = listByContractId1.stream().map(RkContractProcureRelationEntity::getContractId).collect(Collectors.toList());
            RkContractProjectEntity projectInfoEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)rkContractProcureListVO.getProjectId()));
            if (ObjectUtil.isNotEmpty((Object)projectInfoEntity)) {
                RkContractEntity contractInfo = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)projectInfoEntity.getContractId()));
                if (ObjectUtil.isNotEmpty((Object)contractInfo)) {
                    rkContractProcureListVO.setContractCode(contractInfo.getContractCode());
                }
                rkContractProcureListVO.setProjectCode(projectInfoEntity.getProjectCode());
                continue;
            }
            if (!CollectionUtil.isNotEmpty(collect1)) continue;
            List list1 = this.rkContractService.listByIds(collect1);
            rkContractProcureListVO.setContractCode(list1.stream().map(RkContractEntity::getContractCode).distinct().collect(Collectors.joining(",")));
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkContractProcurePaginationExportModel.getSelectKey()) ? rkContractProcurePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block40: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "procureName": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u540d\u79f0", (Object)"procureName"));
                        continue block40;
                    }
                    case "procureCode": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u7f16\u53f7", (Object)"procureCode"));
                        continue block40;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block40;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u53f7", (Object)"projectCode"));
                        continue block40;
                    }
                    case "supplierName": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u540d\u79f0", (Object)"supplierName"));
                        continue block40;
                    }
                    case "supplierBank": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u5361\u53f7", (Object)"supplierBank"));
                        continue block40;
                    }
                    case "supplierAccount": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u8d26\u6237", (Object)"supplierAccount"));
                        continue block40;
                    }
                    case "procureAmount": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u91d1\u989d", (Object)"procureAmount"));
                        continue block40;
                    }
                    case "applyId": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5458", (Object)"applyId"));
                        continue block40;
                    }
                    case "applyDate": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u65e5\u671f", (Object)"applyDate"));
                        continue block40;
                    }
                    case "warranty": {
                        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u671f", (Object)"warranty"));
                        continue block40;
                    }
                    case "deliveryTime": {
                        entitys.add(new ExcelExportEntity("\u8d27\u671f", (Object)"deliveryTime"));
                        continue block40;
                    }
                    case "accumulatePaymentAmount": {
                        entitys.add(new ExcelExportEntity("\u7d2f\u8ba1\u4ed8\u6b3e", (Object)"accumulatePaymentAmount"));
                        continue block40;
                    }
                    case "accumulateInvoiceAmount": {
                        entitys.add(new ExcelExportEntity("\u7d2f\u8ba1\u53d1\u7968", (Object)"accumulateInvoiceAmount"));
                        continue block40;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u91c7\u8d2d\u5408\u540c\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<ProcureImportReturnVO> ImportData(@RequestBody ProcureImportVO data) throws DataException {
        List dataList = JsonUtil.getJsonToList(data.getList(), ProcureImportVO.class);
        ProcureImportReturnVO result = this.rkContractProcureService.importData(dataList);
        return ActionResult.success((Object)result);
    }
}

