/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkContractProductEntity;
import com.bringspring.contract.model.rkcontractproduct.ContractProductImportReturnVO;
import com.bringspring.contract.model.rkcontractproduct.ContractProductImportVO;
import com.bringspring.contract.model.rkcontractproduct.RkContractProductCrForm;
import com.bringspring.contract.model.rkcontractproduct.RkContractProductInfoVO;
import com.bringspring.contract.model.rkcontractproduct.RkContractProductListVO;
import com.bringspring.contract.model.rkcontractproduct.RkContractProductPagination;
import com.bringspring.contract.model.rkcontractproduct.RkContractProductUpForm;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProductService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.crm.entity.CrmProductVersionEntity;
import com.bringspring.crm.model.crmproductversion.CrmProductVersionListVO;
import com.bringspring.crm.service.CrmProductVersionService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5408\u540c\u5173\u8054\u4ea7\u54c1"}, value="contract")
@RequestMapping(value={"/api/contract/RkContractProduct"})
public class RkContractProductController {
    private static final Logger log = LoggerFactory.getLogger(RkContractProductController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractProductService rkContractProductService;
    @Autowired
    private CrmProductVersionService crmProductVersionService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RkContractPaymentService rkContractPaymentService;
    @Autowired
    private RkContractService contractService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkContractProductPagination rkContractProductPagination) throws IOException {
        List<RkContractProductEntity> list = this.rkContractProductService.getList(rkContractProductPagination);
        for (RkContractProductEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, RkContractProductListVO.class);
        for (RkContractProductListVO rkContractProductListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractProductPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @GetMapping(value={"/getListByContractId/{contractId}"})
    public ActionResult getListByContractId(@PathVariable(value="contractId") String contractId) {
        List<RkContractProductEntity> listByContractId = this.rkContractProductService.getListByContractId(contractId);
        List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractProductListVO.class);
        for (RkContractProductListVO vo : jsonToList) {
            List<CrmProductVersionEntity> listByProductId = this.crmProductVersionService.getListByProductId(vo.getProductId());
            List versionListVOS = JsonUtil.getJsonToList(listByProductId, CrmProductVersionListVO.class);
            vo.setVersionList(versionListVOS);
        }
        return ActionResult.success((Object)jsonToList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkContractProductCrForm rkContractProductCrForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            RkContractProductEntity entity = (RkContractProductEntity)JsonUtil.getJsonToBean((Object)rkContractProductCrForm, RkContractProductEntity.class);
            entity.setId(mainId);
            this.rkContractProductService.save(entity);
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractProductInfoVO> info(@PathVariable(value="id") String id) {
        RkContractProductEntity entity = this.rkContractProductService.getInfo(id);
        RkContractProductInfoVO vo = (RkContractProductInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractProductInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractProductInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkContractProductEntity entity = this.rkContractProductService.getInfo(id);
        RkContractProductInfoVO vo = (RkContractProductInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractProductInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkContractProductUpForm rkContractProductUpForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            RkContractProductEntity entity = this.rkContractProductService.getInfo(id);
            if (entity != null) {
                RkContractProductEntity subentity = (RkContractProductEntity)JsonUtil.getJsonToBean((Object)rkContractProductUpForm, RkContractProductEntity.class);
                this.rkContractProductService.update(id, subentity);
                return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            RkContractProductEntity entity = this.rkContractProductService.getInfo(id);
            if (entity != null) {
                this.rkContractProductService.delete(entity);
            }
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u5408\u540c\u4ea7\u54c1\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u5408\u540c\u4ea7\u54c1\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List contractList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, ContractProductImportVO.class);
        List list = JsonUtil.getJsonToList((Object)contractList, Object.class);
        Map<String, Object> map = this.rkContractPaymentService.importPreview(list, new ContractProductImportVO());
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<ContractProductImportReturnVO> ImportData(@RequestBody ContractProductImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), ContractProductImportVO.class);
        ContractProductImportReturnVO result = this.rkContractProductService.importData(dataList);
        return ActionResult.success((Object)result);
    }

    @ApiOperation(value="\u5bfc\u51fa\u9519\u8bef\u62a5\u544a")
    @PostMapping(value={"/ExportExceptionData"})
    public ActionResult<DownloadVO> exportExceptionData(@RequestBody ContractProductImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), Object.class);
        DownloadVO vo = this.contractService.exportExceptionData(dataList, new ContractProductImportVO());
        return ActionResult.success((Object)vo);
    }
}

