/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.ConvertUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.AfterSalesProjectsEntity;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractCollectionRecordEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProductEntity;
import com.bringspring.contract.entity.RkContractProjectCostEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractProjectMarkTrendsEntity;
import com.bringspring.contract.entity.RkProjectPlanEntity;
import com.bringspring.contract.entity.RkProjectProductEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.mapper.RkContractProjectCostMapper;
import com.bringspring.contract.model.rkattachment.RkAttachmentCrForm;
import com.bringspring.contract.model.rkcontract.RkContractInfoVO;
import com.bringspring.contract.model.rkcontractproject.OaAcceptModel;
import com.bringspring.contract.model.rkcontractproject.RkAcceptProjectArchivedCrForm;
import com.bringspring.contract.model.rkcontractproject.RkAcceptProjectCrForm;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectCrForm;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectInfoVO;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectListVO;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectPagination;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectPaginationExportModel;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectUpForm;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectUserAllUpForm;
import com.bringspring.contract.model.rkcontractproject.RkProjectAssignedForm;
import com.bringspring.contract.model.rkcontractproject.RkProjectTotalVo;
import com.bringspring.contract.service.AfterSalesProjectsService;
import com.bringspring.contract.service.OaAcceptService;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractCollectionRecordService;
import com.bringspring.contract.service.RkContractProductService;
import com.bringspring.contract.service.RkContractProjectCostService;
import com.bringspring.contract.service.RkContractProjectMarkTrendsService;
import com.bringspring.contract.service.RkContractProjectMemberService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkProjectAcceptService;
import com.bringspring.contract.service.RkProjectAuthorizationBussService;
import com.bringspring.contract.service.RkProjectPlanDetailService;
import com.bringspring.contract.service.RkProjectPlanService;
import com.bringspring.contract.service.RkProjectProductService;
import com.bringspring.contract.service.RkProjectQuestionService;
import com.bringspring.contract.service.RkProjectStartService;
import com.bringspring.contract.service.RkProjectTaskService;
import com.bringspring.contract.service.RkProjectTransferAftersaleService;
import com.bringspring.contract.service.RkProjectTrendsService;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.DateUtils;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.ProjectStateEnum;
import com.bringspring.contract.utils.ProjectTypeEnum;
import com.bringspring.crm.entity.CrmAuthorizationModuleEntity;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.service.CrmAuthorizationModuleService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.purchase.model.oaPurchasePlan.OaPurchasePlanListVO;
import com.bringspring.purchase.service.OaPurchasePlanService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.DesensitizedUtilCustomer;
import com.bringspring.utils.ParamAddress;
import com.bringspring.visit.service.RkMarketLogService;
import com.bringspring.visit.utils.AfterSalesRoleUtils;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorEntity;
import com.bringspring.workflow.engine.service.FlowTaskNodeService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5408\u540c\u9879\u76ee\u5173\u8054\u8868"}, value="contract")
@RequestMapping(value={"/api/contract/RkContractProject"})
public class RkContractProjectController {
    private static final Logger log = LoggerFactory.getLogger(RkContractProjectController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkProjectProductService projectProductService;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private RkContractCollectionRecordService contractCollectionRecordService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkAgentService agentService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RkProjectTrendsService rkProjectTrendsService;
    @Autowired
    private UserService userService;
    @Autowired
    private RkProjectStartService rkProjectStartService;
    @Autowired
    private RkProjectAcceptService rkProjectAcceptService;
    @Autowired
    private RkProjectTransferAftersaleService rkProjectTransferAftersaleService;
    @Autowired
    private RkProjectPlanService rkProjectPlanService;
    @Autowired
    private RkProjectAuthorizationBussService rkProjectAuthorizationBussService;
    @Autowired
    private RkProjectPlanDetailService rkProjectPlanDetailService;
    @Autowired
    private RkProjectTaskService rkProjectTaskService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RkContractProductService rkContractProductService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractProjectCostMapper rkContractProjectCostMapper;
    @Autowired
    private RkContractProjectCostService rkContractProjectCostService;
    @Autowired
    private RkProjectQuestionService rkProjectQuestionService;
    @Autowired
    private RkMarketLogService rkMarketLogService;
    @Autowired
    private SaleNoContractService saleNoContractService;
    @Autowired
    private AfterSalesProjectsService afterSalesProjectsService;
    @Autowired
    private RkContractCollectionRecordService rkContractCollectionRecordService;
    @Autowired
    private RkContractProjectMemberService rkContractProjectMemberService;
    @Autowired
    private SaleContractCustomerService saleContractCustomerService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private FlowTaskNodeService flowTaskNodeService;
    @Autowired
    private FlowTaskOperatorService flowTaskOperatorService;
    @Autowired
    private OaAcceptService oaAcceptService;
    @Autowired
    private CrmAuthorizationModuleService crmAuthorizationModuleService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private AfterSalesRoleUtils afterSalesRoleUtils;
    @Autowired
    private RkContractProjectMarkTrendsService rkContractProjectMarkTrendsService;
    @Autowired
    private OaPurchasePlanService oaPurchasePlanService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@ParamAddress(field="customerAddress,signAddress") @RequestBody RkContractProjectPagination rkContractProjectPagination) throws IOException, WorkFlowException {
        UserInfo userInfo = this.userProvider.get();
        List<RkContractProjectEntity> list = this.rkContractProjectService.getList(rkContractProjectPagination);
        List<RkContractProjectListVO> listVO = this.appendListVo(list, false);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractProjectPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private List<RkContractProjectListVO> appendListVo(List<RkContractProjectEntity> list, Boolean isExport) throws WorkFlowException {
        Map<String, ProjectStateEnum> allToMap = ProjectStateEnum.getAllToMap();
        List listVO = JsonUtil.getJsonToList(list, RkContractProjectListVO.class);
        for (RkContractProjectListVO rkContractProjectVO : listVO) {
            List<RkAttachmentEntity> listByProjectId;
            FlowTaskEntity flowTaskEntity;
            RkAgentEntity agent;
            String collect;
            List<RkContractProductEntity> listByContractId;
            CrmCustomerEntity customer;
            rkContractProjectVO.setMarkType(this.baseDataUtil.getDictName(rkContractProjectVO.getMarkType(), "projectMark"));
            rkContractProjectVO.setProjectTypeManage(this.baseDataUtil.getDictName(rkContractProjectVO.getProjectTypeManage(), "projectTypeManage"));
            rkContractProjectVO.setProjectTeamMember(this.baseDataUtil.userSelectValues(rkContractProjectVO.getProjectTeamMember()));
            rkContractProjectVO.setProjectTeamDepartment(this.baseDataUtil.comSelectValues(rkContractProjectVO.getProjectTeamDepartment()));
            rkContractProjectVO.setProjectIncomeTypeName(this.baseDataUtil.getDictName(rkContractProjectVO.getProjectIncomeType(), "contractType"));
            rkContractProjectVO.setSalerCompanyName(this.afterSalesRoleUtils.getCompanyShortName(rkContractProjectVO.getSalerCompanyId()));
            rkContractProjectVO.setProjectNature(this.baseDataUtil.getDictName(rkContractProjectVO.getProjectNature(), "projectNature"));
            rkContractProjectVO.setProjectHeaderDesc(this.baseDataUtil.userSelectValueNoAccount(rkContractProjectVO.getProjectHeader()));
            rkContractProjectVO.setIncomeTypeDesc(this.crmProductCategoryService.getNameByIds(rkContractProjectVO.getIncomeType()));
            rkContractProjectVO.setTaxRate(this.baseDataUtil.getDictName(rkContractProjectVO.getTaxRate(), "projectTaxRate"));
            rkContractProjectVO.setDepartmentOne(this.baseDataUtil.comSelectValue(rkContractProjectVO.getDepartmentOne(), ""));
            rkContractProjectVO.setDepartment(this.baseDataUtil.comSelectValue(rkContractProjectVO.getDepartment(), ""));
            rkContractProjectVO.setKnowByName(this.baseDataUtil.userSelectValue(rkContractProjectVO.getKnowBy()));
            if (StringUtils.isNotEmpty((String)rkContractProjectVO.getCustomerId()) && null != (customer = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)rkContractProjectVO.getCustomerId())))) {
                rkContractProjectVO.setCustomerName(customer.getName());
                rkContractProjectVO.setGrade(customer.getGrade());
                rkContractProjectVO.setGradeName(this.baseDataUtil.getDictName(customer.getGrade(), "CustomerGrade"));
                rkContractProjectVO.setAddress(customer.getAddress());
                rkContractProjectVO.setAddressName(this.baseDataUtil.provinceData(customer.getAddress()));
            }
            if (StringUtils.isNotEmpty((String)rkContractProjectVO.getCompanyId())) {
                rkContractProjectVO.setCompanyName(this.organizeService.getInfo(rkContractProjectVO.getCompanyId()).getShortName());
            }
            if (ObjectUtil.isEmpty((Object)rkContractProjectVO.getSureIncome())) {
                rkContractProjectVO.setSureIncome(BigDecimal.ZERO);
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(RkContractProjectCostEntity::getProjectId, (Object)rkContractProjectVO.getId());
            queryWrapper.lambda().eq(RkContractProjectCostEntity::getState, (Object)"1");
            List rkContractProjectCostEntities = this.rkContractProjectCostMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)rkContractProjectCostEntities)) {
                BigDecimal sum = rkContractProjectCostEntities.stream().map(RkContractProjectCostEntity::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                rkContractProjectVO.setProjectCostName(sum);
                BigDecimal divide = MathUtils.divide(MathUtils.multiply(sum, new BigDecimal(100)), rkContractProjectVO.getProjectAmount(), 2);
                rkContractProjectVO.setProportionName(divide);
                if (divide.compareTo(new BigDecimal(2)) > 0) {
                    rkContractProjectVO.setProjectCostState("1");
                }
            } else {
                rkContractProjectVO.setProjectCostName(BigDecimal.ZERO);
                rkContractProjectVO.setProportionName(BigDecimal.ZERO);
            }
            rkContractProjectVO.setStateCode(rkContractProjectVO.getState());
            if (ProjectTypeEnum.MANAGER.getEnCode().equals(rkContractProjectVO.getProjectType())) {
                rkContractProjectVO.setStateDesc(this.baseDataUtil.getDictName(rkContractProjectVO.getState(), "managerProjectState"));
            } else {
                rkContractProjectVO.setState(StringUtils.isEmpty((String)rkContractProjectVO.getState()) ? "" : allToMap.get(rkContractProjectVO.getState()).getDesc());
            }
            if (!StrUtil.isBlank((CharSequence)rkContractProjectVO.getContractId())) {
                listByContractId = this.rkContractProductService.getListByContractId(rkContractProjectVO.getContractId());
                collect = listByContractId.stream().map(RkContractProductEntity::getProductName).collect(Collectors.joining(","));
                rkContractProjectVO.setProductName(collect);
                RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)rkContractProjectVO.getContractId()));
                if (ObjectUtil.isNotEmpty((Object)byId)) {
                    rkContractProjectVO.setSignDate(byId.getSignDate());
                    rkContractProjectVO.setCompanyId(byId.getCompanyId());
                    rkContractProjectVO.setCompanyName(((OrganizeEntity)this.organizeService.getById((Serializable)((Object)byId.getCompanyId()))).getFullName());
                    rkContractProjectVO.setContractCode(byId.getContractCode());
                    rkContractProjectVO.setContractType(this.baseDataUtil.getDictName(byId.getContractType(), "contractType"));
                    rkContractProjectVO.setCustomerId(byId.getCustomerId());
                    rkContractProjectVO.setSalesPerson(byId.getSalerId());
                    rkContractProjectVO.setSaler(byId.getSalerName());
                    rkContractProjectVO.setSaleDepartment(byId.getDepartmentName());
                    rkContractProjectVO.setContractLevel(byId.getContractLevel());
                    rkContractProjectVO.setContractName(byId.getContractName());
                    rkContractProjectVO.setAcceptArchivedBy(StrUtil.isBlank((CharSequence)rkContractProjectVO.getAcceptArchivedBy()) ? "" : this.baseDataUtil.userSelectValueNoAccount(rkContractProjectVO.getAcceptArchivedBy()));
                    rkContractProjectVO.setContractAmount(byId.getContractAmount());
                    rkContractProjectVO.setReturnAmount(byId.getReturnAmount());
                    rkContractProjectVO.setInvoiceAmount(byId.getInvoiceAmount());
                    rkContractProjectVO.setNotInvoiceAmount(byId.getNotInvoiceAmount());
                    rkContractProjectVO.setStartContractTime(byId.getStartContractTime());
                    rkContractProjectVO.setEndContractTime(byId.getEndContractTime());
                    rkContractProjectVO.setSingDate(DateUtil.getTime((Date)byId.getSignDate()) * 1000L);
                    rkContractProjectVO.setPaymentMethod(byId.getPaymentMethod());
                    rkContractProjectVO.setProjectSource("XS-HT");
                    rkContractProjectVO.setAgentId(byId.getAgentId());
                    if (ObjectUtil.equals((Object)byId.getIsAgent(), (Object)1)) {
                        if (StringUtils.isNotEmpty((String)byId.getAgentId()) && null != (agent = this.agentService.getInfo(byId.getAgentId()))) {
                            rkContractProjectVO.setAgentName(agent.getName());
                        }
                    } else if (StringUtils.isNotEmpty((String)byId.getCustomerIds())) {
                        rkContractProjectVO.setAgentName(this.saleContractCustomerService.getCustomerNamesByContractId(byId.getId()));
                    }
                }
            } else if (!StrUtil.isBlank((CharSequence)rkContractProjectVO.getNoContractId())) {
                listByContractId = this.rkContractProductService.getListByContractId(rkContractProjectVO.getNoContractId());
                collect = listByContractId.stream().map(RkContractProductEntity::getProductName).collect(Collectors.joining(","));
                rkContractProjectVO.setProductName(collect);
                SaleNoContractEntity noContract = (SaleNoContractEntity)this.saleNoContractService.getById((Serializable)((Object)rkContractProjectVO.getNoContractId()));
                if (null != noContract) {
                    rkContractProjectVO.setSignDate(noContract.getExpectedSignDate());
                    rkContractProjectVO.setContractCode(noContract.getContractCode());
                    rkContractProjectVO.setContractName(noContract.getContractName());
                    rkContractProjectVO.setContractAmount(noContract.getExpectedContractAmount());
                    rkContractProjectVO.setSingDate(DateUtil.getTime((Date)noContract.getExpectedSignDate()) * 1000L);
                    rkContractProjectVO.setAgentId(noContract.getAgentId());
                    if (ObjectUtil.equals((Object)noContract.getIsAgent(), (Object)1)) {
                        if (StringUtils.isNotEmpty((String)noContract.getAgentId()) && null != (agent = this.agentService.getInfo(noContract.getAgentId()))) {
                            rkContractProjectVO.setAgentName(agent.getName());
                        }
                    } else if (StringUtils.isNotEmpty((String)noContract.getCustomerIds())) {
                        rkContractProjectVO.setAgentName(this.saleContractCustomerService.getCustomerNamesByContractId(noContract.getId()));
                    }
                }
            }
            if (isExport.booleanValue()) continue;
            RkProjectPlanEntity infoByProjectId = this.rkProjectPlanService.getInfoByProjectId(rkContractProjectVO.getId());
            if (ObjectUtil.isNotEmpty((Object)infoByProjectId)) {
                rkContractProjectVO.setHavePlan(true);
            }
            if (StrUtil.isNotEmpty((CharSequence)rkContractProjectVO.getAuthorizationApplyId())) {
                flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)rkContractProjectVO.getAuthorizationApplyId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
                if (flowTaskEntity != null) {
                    rkContractProjectVO.setAuthorizationApplyState(flowTaskEntity.getStatus());
                } else {
                    rkContractProjectVO.setAuthorizationApplyState(null);
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)rkContractProjectVO.getStartWorkApplyId())) {
                flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)rkContractProjectVO.getStartWorkApplyId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
                if (flowTaskEntity != null) {
                    rkContractProjectVO.setStartWorkApplyState(flowTaskEntity.getStatus());
                } else {
                    rkContractProjectVO.setStartWorkApplyState(null);
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)rkContractProjectVO.getStopApplyId())) {
                flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)rkContractProjectVO.getStopApplyId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
                if (flowTaskEntity != null) {
                    rkContractProjectVO.setStopApplyState(flowTaskEntity.getStatus());
                } else {
                    rkContractProjectVO.setStopApplyState(null);
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)rkContractProjectVO.getStartApplyId())) {
                flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)rkContractProjectVO.getStartApplyId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
                if (flowTaskEntity != null) {
                    rkContractProjectVO.setFlowStartApplyState(flowTaskEntity.getStatus());
                } else {
                    rkContractProjectVO.setFlowStartApplyState(null);
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)rkContractProjectVO.getChangeHeaderApplyId())) {
                flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)rkContractProjectVO.getChangeHeaderApplyId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
                if (flowTaskEntity != null) {
                    rkContractProjectVO.setFlowChangeHeaderApplyState(flowTaskEntity.getStatus());
                } else {
                    rkContractProjectVO.setFlowChangeHeaderApplyState(null);
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)rkContractProjectVO.getAcceptApplyId())) {
                flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)rkContractProjectVO.getAcceptApplyId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
                if (flowTaskEntity != null) {
                    rkContractProjectVO.setFlowAcceptApplyState(flowTaskEntity.getStatus());
                } else {
                    rkContractProjectVO.setFlowAcceptApplyState(null);
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)rkContractProjectVO.getTransferApplyId())) {
                flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)rkContractProjectVO.getTransferApplyId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
                if (flowTaskEntity != null) {
                    rkContractProjectVO.setFlowTransferApplyState(flowTaskEntity.getStatus());
                } else {
                    rkContractProjectVO.setFlowTransferApplyState(null);
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)rkContractProjectVO.getChangePlanApplyId())) {
                flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)rkContractProjectVO.getChangePlanApplyId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
                if (flowTaskEntity != null) {
                    rkContractProjectVO.setFlowChangePlanApplyState(flowTaskEntity.getStatus());
                } else {
                    rkContractProjectVO.setFlowChangePlanApplyState(null);
                }
            }
            if (ObjectUtil.isNotEmpty((Object)rkContractProjectVO.getAcceptApplyId())) {
                FlowTaskNodeEntity flowTaskNodeEntity;
                flowTaskEntity = this.flowTaskService.getDraftTaskByProcessId(rkContractProjectVO.getAcceptApplyId());
                if (ObjectUtil.isNotEmpty((Object)flowTaskEntity) && ObjectUtil.isNotEmpty((Object)(flowTaskNodeEntity = (FlowTaskNodeEntity)this.flowTaskNodeService.getById((Serializable)((Object)flowTaskEntity.getThisStepId()))))) {
                    List operatorList = this.flowTaskOperatorService.getListByNode(flowTaskEntity.getId(), flowTaskNodeEntity.getId());
                    String result = operatorList.stream().map(FlowTaskOperatorEntity::getHandleId).collect(Collectors.joining(","));
                    String userName = this.baseDataUtil.userSelectValues(result);
                    rkContractProjectVO.setCurrentApprove(userName);
                }
                if ("0".equals(rkContractProjectVO.getIsAcceptance()) && rkContractProjectVO.getStateCode().equals("toBeAccepted")) {
                    rkContractProjectVO.setIsAcceptance("toBeAccepted");
                }
            }
            if (CollectionUtil.isNotEmpty(listByProjectId = this.rkAttachmentService.getListByProjectId(rkContractProjectVO.getId()))) {
                rkContractProjectVO.setIsHaveAttachment(1);
                continue;
            }
            rkContractProjectVO.setIsHaveAttachment(0);
        }
        return listVO;
    }

    @PostMapping(value={"projectTotalByState"})
    public ActionResult<RkProjectTotalVo> projectTotalByState(@ParamAddress(field="customerAddress,signAddress") @RequestBody RkContractProjectPagination rkContractProjectPagination) {
        RkProjectTotalVo vo = this.rkContractProjectService.projectTotalByState(rkContractProjectPagination);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"maintenance"})
    public ActionResult maintenance(@ParamAddress(field="customerAddress,signAddress") @RequestBody RkContractProjectPagination rkContractProjectPagination) {
        rkContractProjectPagination.setIsMaintenance(1);
        rkContractProjectPagination.setIsAcceptance("1");
        List<RkContractProjectEntity> list = this.rkContractProjectService.getList(rkContractProjectPagination);
        for (RkContractProjectEntity entity : list) {
            entity.setProjectHeader(this.baseDataUtil.userSelectValueNoAccount(entity.getProjectHeader()));
            entity.setIncomeType(this.crmProductCategoryService.getNameByIds(entity.getIncomeType()));
            entity.setTaxRate(this.baseDataUtil.getDictName(entity.getTaxRate(), "projectTaxRate"));
        }
        List<RkContractProjectListVO> listVO = this.handMaintenance(list);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractProjectPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/maintenance/Export"})
    public ActionResult export(@ParamAddress(field="customerAddress,signAddress") @RequestBody RkContractProjectPaginationExportModel rkContractProjectPaginationExportModel) {
        if (StringUtil.isEmpty((String)rkContractProjectPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkContractProjectPagination rkContractProjectPagination = (RkContractProjectPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractProjectPaginationExportModel), RkContractProjectPagination.class));
        rkContractProjectPagination.setIsMaintenance(1);
        rkContractProjectPagination.setIsAcceptance("1");
        List<RkContractProjectEntity> list = this.rkContractProjectService.getTypeList(rkContractProjectPagination, rkContractProjectPaginationExportModel.getDataType());
        for (RkContractProjectEntity entity : list) {
            entity.setProjectHeader(this.baseDataUtil.userSelectValueNoAccount(entity.getProjectHeader()));
            entity.setIncomeType(this.crmProductCategoryService.getNameByIds(entity.getIncomeType()));
            entity.setTaxRate(this.baseDataUtil.getDictName(entity.getTaxRate(), "projectTaxRate"));
        }
        List<RkContractProjectListVO> listVO = this.handMaintenance(list);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd"));
        if (CollectionUtil.isNotEmpty((Collection)mapList)) {
            mapList.stream().forEach(m -> {
                String s;
                DateTime expectedSigningDate;
                if (ObjectUtil.isNotNull(m.get("singDate"))) {
                    expectedSigningDate = cn.hutool.core.date.DateUtil.date((long)Long.valueOf(m.get("singDate").toString()));
                    s = cn.hutool.core.date.DateUtil.formatDate((Date)expectedSigningDate);
                    m.put("singDate", s);
                }
                if (ObjectUtil.isNotNull(m.get("acceptanceTime"))) {
                    expectedSigningDate = cn.hutool.core.date.DateUtil.date((long)Long.valueOf(m.get("acceptanceTime").toString()));
                    s = cn.hutool.core.date.DateUtil.formatDate((Date)expectedSigningDate);
                    m.put("acceptanceTime", s);
                }
            });
        }
        String[] keys = !StringUtil.isEmpty((String)rkContractProjectPaginationExportModel.getSelectKey()) ? rkContractProjectPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo, "maintenance");
        return ActionResult.success((Object)vo);
    }

    private List<RkContractProjectListVO> handMaintenance(List<RkContractProjectEntity> list) {
        List listVO = JsonUtil.getJsonToList(list, RkContractProjectListVO.class);
        Map<String, ProjectStateEnum> allToMap = ProjectStateEnum.getAllToMap();
        for (RkContractProjectListVO rkContractProjectVO : listVO) {
            CrmCustomerEntity customer;
            rkContractProjectVO.setStateCode(rkContractProjectVO.getState());
            rkContractProjectVO.setState(StringUtils.isEmpty((String)rkContractProjectVO.getState()) ? "" : allToMap.get(rkContractProjectVO.getState()).getDesc());
            if (StringUtils.isNotEmpty((String)rkContractProjectVO.getCustomerId()) && null != (customer = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)rkContractProjectVO.getCustomerId())))) {
                rkContractProjectVO.setCustomerName(customer.getName());
                rkContractProjectVO.setGrade(customer.getGrade());
                rkContractProjectVO.setGradeName(this.baseDataUtil.getDictName(customer.getGrade(), "CustomerGrade"));
                rkContractProjectVO.setAddress(customer.getAddress());
                rkContractProjectVO.setAddressName(this.baseDataUtil.provinceData(customer.getAddress()));
            }
            if (StringUtils.isNotEmpty((String)rkContractProjectVO.getCompanyId())) {
                rkContractProjectVO.setCompanyName(this.organizeService.getInfo(rkContractProjectVO.getCompanyId()).getShortName());
            }
            List<RkContractProductEntity> listByContractId = this.rkContractProductService.getListByContractId(rkContractProjectVO.getContractId());
            String collect = listByContractId.stream().map(RkContractProductEntity::getProductName).collect(Collectors.joining(","));
            rkContractProjectVO.setProductName(collect);
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)rkContractProjectVO.getContractId()));
            if (!ObjectUtil.isNotEmpty((Object)byId)) continue;
            rkContractProjectVO.setWarranty(byId.getWarranty());
            rkContractProjectVO.setRetentionMoneyAmount(byId.getRetentionMoneyAmount());
            if (ObjectUtil.isNull((Object)rkContractProjectVO.getRetentionMoneyAmount())) {
                rkContractProjectVO.setRetentionMoneyAmount(BigDecimal.ZERO);
            }
            if (ObjectUtil.isNotNull((Object)rkContractProjectVO.getProjectRatio())) {
                rkContractProjectVO.setProjectRetentionMoneyAmount(MathUtils.divide(MathUtils.multiply(byId.getRetentionMoneyAmount(), new BigDecimal(100)), rkContractProjectVO.getProjectRatio(), 2, BigDecimal.ZERO));
            } else {
                rkContractProjectVO.setProjectRetentionMoneyAmount(byId.getRetentionMoneyAmount());
            }
            if (ObjectUtil.isNull((Object)rkContractProjectVO.getProjectRetentionMoneyAmount())) {
                rkContractProjectVO.setProjectRetentionMoneyAmount(BigDecimal.ZERO);
            }
            if (ObjectUtil.isNotNull((Object)rkContractProjectVO.getAcceptanceTime())) {
                rkContractProjectVO.setWarrantyStartDate(DateUtil.dateAddDays((Date)DateUtil.daFormatDate((Long)rkContractProjectVO.getAcceptanceTime()), (int)1));
                if (ObjectUtil.isNotNull((Object)rkContractProjectVO.getWarranty())) {
                    rkContractProjectVO.setWarrantyEndDate(DateUtil.dateAddMonths((Date)rkContractProjectVO.getWarrantyStartDate(), (int)rkContractProjectVO.getWarranty()));
                    long l = DateUtil.getDiffDays((Date)DateUtil.getDayBegin(), (Date)rkContractProjectVO.getWarrantyEndDate());
                    rkContractProjectVO.setDaysRemaining(l);
                    rkContractProjectVO.setDaysRemainingStr(DateUtils.dayConverter(l));
                }
            }
            rkContractProjectVO.setCompanyId(byId.getCompanyId());
            rkContractProjectVO.setCompanyName(((OrganizeEntity)this.organizeService.getById((Serializable)((Object)byId.getCompanyId()))).getFullName());
            rkContractProjectVO.setContractCode(byId.getContractCode());
            rkContractProjectVO.setCustomerId(byId.getCustomerId());
            rkContractProjectVO.setSaler(byId.getSalerName());
            rkContractProjectVO.setSaleDepartment(byId.getDepartmentName());
            if (StrUtil.isEmpty((CharSequence)rkContractProjectVO.getIncomeType())) {
                rkContractProjectVO.setIncomeType(this.crmProductCategoryService.getNameByIds(byId.getIncomeType()));
            }
            rkContractProjectVO.setContractName(byId.getContractName());
            rkContractProjectVO.setAcceptArchivedBy(StrUtil.isBlank((CharSequence)rkContractProjectVO.getAcceptArchivedBy()) ? "" : this.baseDataUtil.userSelectValueNoAccount(rkContractProjectVO.getAcceptArchivedBy()));
            rkContractProjectVO.setContractAmount(byId.getContractAmount());
            rkContractProjectVO.setSingDate(DateUtil.getTime((Date)byId.getSignDate()) * 1000L);
            rkContractProjectVO.setPaymentMethod(byId.getPaymentMethod());
            rkContractProjectVO.setProjectSource("XS-HT");
            rkContractProjectVO.setAgentId(byId.getAgentId());
            if (ObjectUtil.equals((Object)byId.getIsAgent(), (Object)1)) {
                RkAgentEntity agent;
                if (!StringUtils.isNotEmpty((String)byId.getAgentId()) || null == (agent = this.agentService.getInfo(byId.getAgentId()))) continue;
                rkContractProjectVO.setAgentName(agent.getName());
                continue;
            }
            if (!StringUtils.isNotEmpty((String)byId.getCustomerIds())) continue;
            rkContractProjectVO.setAgentName(this.saleContractCustomerService.getCustomerNamesByContractId(byId.getId()));
        }
        return listVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo, String type) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block52: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName"));
                        continue block52;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u53f7", (Object)"projectCode"));
                        continue block52;
                    }
                    case "state": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u9636\u6bb5", (Object)"state"));
                        continue block52;
                    }
                    case "projectHeader": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7ecf\u7406", (Object)"projectHeader"));
                        continue block52;
                    }
                    case "incomeType": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5927\u7c7b", (Object)"incomeTypeDesc"));
                        continue block52;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u5bf9\u8c61", (Object)"agentName"));
                        continue block52;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerName"));
                        continue block52;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block52;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block52;
                    }
                    case "contractAmount": {
                        ExcelExportEntity contractAmount = new ExcelExportEntity("\u5408\u540c\u91d1\u989d(\u5143)", (Object)"contractAmount");
                        contractAmount.setType(10);
                        entitys.add(contractAmount);
                        continue block52;
                    }
                    case "signDate": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u65e5\u671f", (Object)"signDate"));
                        continue block52;
                    }
                    case "singDate": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u65e5\u671f", (Object)"singDate"));
                        continue block52;
                    }
                    case "acceptanceTime": {
                        entitys.add(new ExcelExportEntity("\u9a8c\u6536\u65e5\u671f", (Object)"acceptanceTime"));
                        continue block52;
                    }
                    case "warranty": {
                        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u671f\u9650(\u6708)", (Object)"warranty"));
                        continue block52;
                    }
                    case "warrantyEndDate": {
                        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u5f00\u59cb\u65e5\u671f", (Object)"warrantyEndDate"));
                        continue block52;
                    }
                    case "warrantyStartDate": {
                        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u7ed3\u675f\u65e5\u671f", (Object)"warrantyStartDate"));
                        continue block52;
                    }
                    case "projectAmount": {
                        ExcelExportEntity profit = new ExcelExportEntity("\u9879\u76ee\u91d1\u989d(\u5143)", (Object)"projectAmount");
                        profit.setType(10);
                        entitys.add(profit);
                        continue block52;
                    }
                    case "retentionMoneyAmount": {
                        ExcelExportEntity profit = new ExcelExportEntity("\u5408\u540c\u8d28\u4fdd\u91d1\u989d(\u5143)", (Object)"retentionMoneyAmount");
                        profit.setType(10);
                        entitys.add(profit);
                        continue block52;
                    }
                    case "projectRetentionMoneyAmount": {
                        ExcelExportEntity profit = new ExcelExportEntity("\u9879\u76ee\u8d28\u4fdd\u91d1\u989d(\u5143)", (Object)"projectRetentionMoneyAmount");
                        profit.setType(10);
                        entitys.add(profit);
                        continue block52;
                    }
                    case "daysRemaining": {
                        entitys.add(new ExcelExportEntity("\u7ef4\u4fdd\u5269\u4f59\u5929\u6570", (Object)"daysRemaining"));
                        continue block52;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "";
                name = StrUtil.equals((CharSequence)type, (CharSequence)"project") ? "\u9879\u76ee" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx" : "\u7ef4\u4fdd\u9879\u76ee" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    public static void main(String[] args) {
        System.out.println(DesensitizedUtilCustomer.password((String)"15093386148@qq.com"));
        System.out.println(DesensitizedUtilCustomer.desensitized("123213", DesensitizedUtilCustomer.DesensitizedTypeCustomer.All));
        System.out.println(DesensitizedUtilCustomer.desensitized((CharSequence)"123213", (DesensitizedUtil.DesensitizedType)DesensitizedUtil.DesensitizedType.PASSWORD));
    }

    @PostMapping(value={"countByState"})
    public ActionResult countByEnabledMark(@ParamAddress(field="customerAddress,signAddress") @RequestBody RkContractProjectPagination rkContractProjectPagination) {
        List<Map<String, Object>> maps = this.rkContractProjectService.countByState(rkContractProjectPagination);
        return ActionResult.success(maps);
    }

    @GetMapping(value={"/getByCustomerId/{customerId}"})
    public ActionResult getByCustomerId(@PathVariable(value="customerId") String customerId) {
        UserInfo userInfo = this.userProvider.get();
        List<RkContractProjectEntity> list = this.rkContractProjectService.getListByCustomerIdAndCompanyId(customerId, userInfo.getOrganizeId());
        return ActionResult.success(list);
    }

    @PostMapping(value={"/getByCompanyIdAndAddress"})
    public ActionResult getByCustomerId(@ParamAddress(field="customerAddress,signAddress") @RequestBody RkContractProjectPagination rkContractProjectPagination) {
        rkContractProjectPagination.setIsAuth(0);
        List<List<String>> customerAddress = rkContractProjectPagination.getCustomerAddress();
        if (CollectionUtil.isEmpty(customerAddress)) {
            customerAddress = new ArrayList<List<String>>();
        }
        customerAddress.add(rkContractProjectPagination.getAddress());
        rkContractProjectPagination.setCustomerAddress(customerAddress);
        List<RkContractProjectEntity> list = this.rkContractProjectService.getList(rkContractProjectPagination);
        List listVO = JsonUtil.getJsonToList(list, RkContractProjectListVO.class);
        Map<String, ProjectStateEnum> allToMap = ProjectStateEnum.getAllToMap();
        listVO.stream().forEach(entity -> {
            CrmCustomerEntity customer;
            entity.setIncomeTypeDesc(this.crmProductCategoryService.getNameByIds(entity.getIncomeType()));
            if (StrUtil.isNotEmpty((CharSequence)entity.getCustomerId()) && ObjectUtil.isNotNull((Object)(customer = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()))))) {
                entity.setCustomerName(customer.getName());
                entity.setGrade(customer.getGrade());
                entity.setClassificationCode(customer.getClassificationCode());
                entity.setGradeName(this.baseDataUtil.getDictName(customer.getGrade(), "CustomerGrade"));
                entity.setAddress(customer.getAddress());
                entity.setAddressName(this.baseDataUtil.provinceData(customer.getAddress()));
                if (StrUtil.isNotEmpty((CharSequence)customer.getAddress())) {
                    String[] split = customer.getAddress().replace("\"", "").replace("[", "").replace("]", "").split(",");
                    entity.setRegion(split[0]);
                    entity.setRegionName(this.baseDataUtil.provinceData(split[0]));
                }
            }
            entity.setState(((ProjectStateEnum)((Object)((Object)allToMap.get(entity.getState())))).getDesc());
        });
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractProjectPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping
    @Transactional
    @RepeatSubmit
    public ActionResult create(@RequestBody @Valid RkContractProjectCrForm rkContractProjectCrForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            CrmProductEntity crmProductEntity;
            UserInfo userInfo = this.userProvider.get();
            rkContractProjectCrForm.setCompanyId(userInfo.getOrganizeId());
            RkContractProjectEntity infoByCode = this.rkContractProjectService.getInfoByCode(rkContractProjectCrForm.getProjectCode());
            if (ObjectUtil.isNotNull((Object)infoByCode)) {
                return ActionResult.fail((String)"\u9879\u76ee\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
            }
            List<CrmAuthorizationModuleEntity> moduleList = this.crmAuthorizationModuleService.getByIds(rkContractProjectCrForm.getAuthorizationModuleIds());
            if (CollectionUtil.isNotEmpty(moduleList)) {
                rkContractProjectCrForm.setAuthorizationModule(moduleList.stream().map(CrmAuthorizationModuleEntity::getModuleName).distinct().collect(Collectors.joining(",")));
            }
            if (StrUtil.isNotEmpty((CharSequence)rkContractProjectCrForm.getJcProductId()) && ObjectUtil.isNotEmpty((Object)(crmProductEntity = this.crmProductService.getInfo(rkContractProjectCrForm.getJcProductId())))) {
                rkContractProjectCrForm.setJcProductName(crmProductEntity.getProductName());
            }
            this.rkContractProjectService.saveProject(rkContractProjectCrForm);
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
        }
    }

    @GetMapping(value={"/getByContractId/{contractId}"})
    public ActionResult getByContractId(@PathVariable(value="contractId") String contractId, String customerId) {
        List<RkContractProjectEntity> list = CollectionUtil.list((boolean)false);
        list = StrUtil.isNotEmpty((CharSequence)customerId) ? this.rkContractProjectService.getListByContractIdAndCustomerId(contractId, customerId) : this.rkContractProjectService.getListByContractId(contractId);
        if (CollectionUtil.isEmpty(list)) {
            list = this.rkContractProjectService.getListByNoContractId(contractId);
        }
        RkContractEntity contract = (RkContractEntity)this.contractService.getById((Serializable)((Object)contractId));
        SaleNoContractEntity noContract = null;
        if (null == contract) {
            noContract = (SaleNoContractEntity)this.saleNoContractService.getById((Serializable)((Object)contractId));
        }
        Map<String, String> collect = list.stream().collect(Collectors.toMap(RkContractProjectEntity::getId, RkContractProjectEntity::getDepartmentTree));
        List listVO = JsonUtil.getJsonToList(list, RkContractProjectListVO.class);
        for (RkContractProjectListVO entity : listVO) {
            CrmCustomerEntity info;
            entity.setProjectId(entity.getId());
            entity.setStateDesc(this.baseDataUtil.getDictName(entity.getState(), "projectState"));
            entity.setProjectNatureDesc(this.baseDataUtil.getDictName(entity.getProjectNature(), "projectNature"));
            entity.setProjectHeaderDesc(this.baseDataUtil.userSelectValueNoAccount(entity.getProjectHeader()));
            entity.setTaxRateDesc(this.baseDataUtil.getDictName(entity.getTaxRate(), "projectTaxRate"));
            String[] split = collect.get(entity.getId()).replace("\"", "").replace("[", "").replace("]", "").split(",");
            if (ObjectUtil.isNotEmpty((Object)contract)) {
                entity.setIncomeTypeDesc(this.crmProductCategoryService.getNameByIds(contract.getIncomeType()));
                entity.setIndustryTypeDesc(this.baseDataUtil.getDictName(contract.getIndustryType(), "industryType"));
            } else if (null != noContract) {
                entity.setIncomeTypeDesc(this.crmProductCategoryService.getNameByIds(noContract.getIncomeType()));
            }
            entity.setProjectIncomeTypeName(this.baseDataUtil.getDictName(entity.getProjectIncomeType(), "contractType"));
            entity.setDepartmentTree(Arrays.asList(split));
            entity.setRegionName(this.baseDataUtil.provinceData(entity.getRegion()));
            entity.setDepartmentName(this.baseDataUtil.comSelectValues(collect.get(entity.getId())));
            List<RkProjectProductEntity> listByProjectId = this.projectProductService.getListByProjectId(entity.getId(), true);
            entity.setProductEntityList(listByProjectId);
            List<String> idList = listByProjectId.stream().map(RkProjectProductEntity::getProductId).collect(Collectors.toList());
            List<String> nameList = listByProjectId.stream().map(RkProjectProductEntity::getProductName).collect(Collectors.toList());
            entity.setProductNameList(nameList);
            entity.setProductList(idList);
            if (!StringUtils.isNotEmpty((String)entity.getCustomerId()) || !ObjectUtil.isNotNull((Object)(info = this.crmCustomerService.getInfo(entity.getCustomerId())))) continue;
            entity.setCustomerName(info.getName());
        }
        return ActionResult.success((Object)listVO);
    }

    @GetMapping(value={"/getCanStartByContractId/{contractId}"})
    public ActionResult getCanStartByContractId(@PathVariable(value="contractId") String contractId) {
        List<RkContractProjectEntity> canStartByContractId = this.rkContractProjectService.getCanStartByContractId(contractId);
        return ActionResult.success(canStartByContractId);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractProjectInfoVO> info(@PathVariable(value="id") String id) {
        SaleNoContractEntity noContract;
        RkContractProjectEntity entity = this.rkContractProjectService.getInfo(id);
        if (ObjectUtil.isEmpty((Object)entity)) {
            return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        RkContractProjectInfoVO vo = (RkContractProjectInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractProjectInfoVO.class);
        vo.setProjectIncomeTypeName(this.baseDataUtil.getDictName(vo.getProjectIncomeType(), "contractType"));
        vo.setProjectId(vo.getId());
        if (!StrUtil.isBlank((CharSequence)entity.getCustomerId())) {
            vo.setCustomerName(((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()))).getName());
        }
        if (!StrUtil.isBlank((CharSequence)entity.getContractId())) {
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)entity.getContractId()));
            if (ObjectUtil.isNotEmpty((Object)byId)) {
                vo.setContractCode(byId.getContractCode());
                vo.setContractName(byId.getContractName());
                vo.setContractAmount(byId.getContractAmount());
                vo.setIsAgent(byId.getIsAgent());
                vo.setAgentId(byId.getAgentId());
                if (ObjectUtil.equals((Object)byId.getIsAgent(), (Object)1)) {
                    RkAgentEntity agent;
                    if (StringUtils.isNotEmpty((String)byId.getAgentId()) && null != (agent = this.agentService.getInfo(byId.getAgentId()))) {
                        vo.setAgentName(agent.getName());
                    }
                } else if (StringUtils.isNotEmpty((String)byId.getCustomerIds())) {
                    vo.setAgentName(this.saleContractCustomerService.getCustomerNamesByContractId(byId.getId()));
                }
                vo.setSalerId(byId.getSalerId());
                vo.setSalerName(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
            }
        } else if (!StrUtil.isBlank((CharSequence)entity.getNoContractId()) && null != (noContract = (SaleNoContractEntity)this.saleNoContractService.getById((Serializable)((Object)entity.getNoContractId())))) {
            vo.setContractCode(noContract.getContractCode());
            vo.setContractName(noContract.getContractName());
            vo.setContractAmount(noContract.getExpectedContractAmount());
            vo.setIsAgent(ConvertUtil.toInt((Object)noContract.getIsAgent(), (Integer)0));
            vo.setAgentId(noContract.getAgentId());
            if (ObjectUtil.equals((Object)vo.getIsAgent(), (Object)1)) {
                RkAgentEntity agent;
                if (StringUtils.isNotEmpty((String)vo.getAgentId()) && null != (agent = this.agentService.getInfo(vo.getAgentId()))) {
                    vo.setAgentName(agent.getName());
                }
            } else if (StringUtils.isNotEmpty((String)noContract.getCustomerIds())) {
                vo.setAgentName(this.saleContractCustomerService.getCustomerNamesByContractId(noContract.getId()));
            }
            vo.setSalerId(noContract.getSalerId());
            vo.setSalerName(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
        }
        List<RkAttachmentEntity> listByProjectTypeId = this.attachmentService.getListByProjectTypeId(id, AttachmentTypeEnum.PROJECT_DESENSITIZATION_CONTRACT_TYPE.getType());
        vo.setAttachmentList(listByProjectTypeId);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"countTab/{id}"})
    public ActionResult countPanorama(@PathVariable(value="id") String id) {
        HashMap map = MapUtil.newHashMap();
        long planCount = this.rkProjectPlanDetailService.countByProjectId(id);
        long taskCount = this.rkProjectTaskService.countByProjectId(id);
        long attachmentCount = this.attachmentService.countByProjectId(id);
        long costCount = this.rkContractProjectCostService.countByProjectId(id);
        long questionCount = this.rkProjectQuestionService.countByProjectId(id, null);
        long authorizationCount = this.rkProjectAuthorizationBussService.countByProjectId(id);
        long logCount = this.rkMarketLogService.countByProjectId(id);
        map.put("planCount", planCount);
        map.put("taskCount", taskCount);
        map.put("attachmentCount", attachmentCount);
        map.put("costCount", costCount);
        map.put("questionCount", questionCount);
        map.put("authorizationCount", authorizationCount);
        map.put("logCount", logCount);
        return ActionResult.success((Object)map);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractProjectInfoVO> detailInfo(@PathVariable(value="id") String id) {
        List<OaPurchasePlanListVO> purchasePlanList;
        FlowTaskEntity flowTaskEntity;
        String collect;
        List<RkContractProductEntity> listByContractId;
        RkContractProjectEntity entity = this.rkContractProjectService.getInfo(id);
        if (ObjectUtil.isEmpty((Object)entity)) {
            return ActionResult.success((Object)new RkContractProjectInfoVO());
        }
        RkContractProjectInfoVO vo = (RkContractProjectInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractProjectInfoVO.class);
        vo.setProjectIncomeTypeName(this.baseDataUtil.getDictName(vo.getProjectIncomeType(), "contractType"));
        RkContractProjectMarkTrendsEntity trendsEntity = this.rkContractProjectMarkTrendsService.byProjectId(id);
        if (ObjectUtil.isNotEmpty((Object)trendsEntity)) {
            vo.setMarkDescription(trendsEntity.getMarkRemarks());
        }
        if (!StrUtil.isBlank((CharSequence)vo.getAuthorizedUser())) {
            vo.setAuthorizedUserName(this.baseDataUtil.userSelectValues(vo.getAuthorizedUser()));
        }
        if (StringUtils.isNotEmpty((String)vo.getCustomerId())) {
            vo.setCustomerName(this.crmCustomerService.getInfo(vo.getCustomerId()).getName());
        }
        vo.setStateCode(vo.getState());
        Map<String, ProjectStateEnum> allToMap = ProjectStateEnum.getAllToMap();
        vo.setState(StringUtils.isEmpty((String)vo.getState()) ? "" : allToMap.get(vo.getState()).getDesc());
        vo.setProjectNature(this.baseDataUtil.getDictName(vo.getProjectNature(), "projectNature"));
        vo.setMarkType(this.baseDataUtil.getDictName(vo.getMarkType(), "projectMark"));
        vo.setRegionalHeadId(vo.getRegionalHead());
        vo.setOldRegionHeader(vo.getRegionalHead());
        vo.setProjectHeaderId(vo.getProjectHeader());
        vo.setRegionalHead(this.baseDataUtil.userSelectValueNoAccount(vo.getRegionalHead()));
        vo.setProjectHeader(this.baseDataUtil.userSelectValueNoAccount(vo.getProjectHeader()));
        vo.setExecuteUserCode(vo.getExecuteUser());
        vo.setExecuteUser(this.baseDataUtil.userSelectValues(vo.getExecuteUser()));
        vo.setAssistantsUserId(vo.getAssistantsUser());
        vo.setExecuteAssistantsUserId(entity.getExecuteAssistantsUser());
        if (StrUtil.isNotEmpty((CharSequence)vo.getExecuteAssistantsUser())) {
            vo.setExecuteAssistantsUser(this.baseDataUtil.userSelectValues(vo.getExecuteAssistantsUser()));
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getAssistantsUser())) {
            vo.setAssistantsUser(this.baseDataUtil.userSelectValues(vo.getAssistantsUser()));
        }
        vo.setIncomeType(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
        vo.setTaxRate(this.baseDataUtil.getDictName(vo.getTaxRate(), "projectTaxRate"));
        vo.setDepartmentOne(this.baseDataUtil.comSelectValue(vo.getDepartmentOne(), ""));
        if (!StrUtil.isBlank((CharSequence)vo.getContractId())) {
            listByContractId = this.rkContractProductService.getListByContractId(vo.getContractId());
            collect = listByContractId.stream().map(RkContractProductEntity::getProductName).collect(Collectors.joining(","));
            vo.setProductName(collect);
            RkContractEntity byId = (RkContractEntity)this.contractService.getById((Serializable)((Object)entity.getContractId()));
            if (ObjectUtil.isNotEmpty((Object)byId)) {
                UserEntity info;
                OrganizeEntity byId1;
                vo.setContractCode(byId.getContractCode());
                vo.setContractType(this.baseDataUtil.getDictName(byId.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
                vo.setContractName(byId.getContractName());
                vo.setContractAmount(byId.getContractAmount());
                if (StrUtil.isNotEmpty((CharSequence)vo.getAcceptedBy()) && ObjectUtil.isNotNull((Object)(byId1 = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)(info = this.userService.getInfo(vo.getAcceptedBy())).getOrganizeId()))))) {
                    vo.setAcceptedDeparment(byId1.getFullName());
                }
                vo.setAcceptedBy(this.baseDataUtil.userSelectValueNoAccount(vo.getAcceptedBy()));
                vo.setSalerId(byId.getSalerId());
                vo.setSaler(byId.getSalerName());
                vo.setSaleDepartment(byId.getDepartmentName());
                vo.setIsAgent(byId.getIsAgent());
                vo.setAgentId(byId.getAgentId());
                if (ObjectUtil.equals((Object)byId.getIsAgent(), (Object)1)) {
                    RkAgentEntity agent;
                    if (StringUtils.isNotEmpty((String)byId.getAgentId()) && null != (agent = this.agentService.getInfo(byId.getAgentId()))) {
                        vo.setAgentName(agent.getName());
                    }
                } else if (StringUtils.isNotEmpty((String)byId.getCustomerIds())) {
                    vo.setAgentName(this.saleContractCustomerService.getCustomerNamesByContractId(byId.getId()));
                }
                vo.setReturnAmount(byId.getReturnAmount());
            }
        } else if (!StrUtil.isBlank((CharSequence)vo.getNoContractId())) {
            listByContractId = this.rkContractProductService.getListByContractId(vo.getNoContractId());
            collect = listByContractId.stream().map(RkContractProductEntity::getProductName).collect(Collectors.joining(","));
            vo.setProductName(collect);
            SaleNoContractEntity noContract = (SaleNoContractEntity)this.saleNoContractService.getById((Serializable)((Object)vo.getNoContractId()));
            if (null != noContract) {
                vo.setContractCode(noContract.getContractCode());
                vo.setContractName(noContract.getContractName());
                vo.setContractAmount(noContract.getExpectedContractAmount());
                vo.setIsAgent(ConvertUtil.toInt((Object)noContract.getIsAgent(), (Integer)0));
                vo.setAgentId(noContract.getAgentId());
                if (ObjectUtil.equals((Object)vo.getIsAgent(), (Object)1)) {
                    RkAgentEntity agent;
                    if (StringUtils.isNotEmpty((String)vo.getAgentId()) && null != (agent = this.agentService.getInfo(vo.getAgentId()))) {
                        vo.setAgentName(agent.getName());
                    }
                } else if (StringUtils.isNotEmpty((String)noContract.getCustomerIds())) {
                    vo.setAgentName(this.saleContractCustomerService.getCustomerNamesByContractId(noContract.getId()));
                }
            }
        }
        RkProjectPlanEntity infoByProjectId = this.rkProjectPlanService.getInfoByProjectId(vo.getId());
        if (ObjectUtil.isNotEmpty((Object)infoByProjectId)) {
            vo.setHavePlan(true);
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getStartApplyId())) {
            flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getStartApplyId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowStartApplyState(flowTaskEntity.getStatus());
            } else {
                vo.setFlowStartApplyState(null);
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getStartWorkApplyId())) {
            flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getStartWorkApplyId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setStartWorkApplyState(flowTaskEntity.getStatus());
            } else {
                vo.setStartWorkApplyState(null);
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getChangeHeaderApplyId())) {
            flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getChangeHeaderApplyId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowChangeHeaderApplyState(flowTaskEntity.getStatus());
            } else {
                vo.setFlowChangeHeaderApplyState(null);
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getAcceptApplyId())) {
            flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getAcceptApplyId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowAcceptApplyState(flowTaskEntity.getStatus());
            } else {
                vo.setFlowAcceptApplyState(null);
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getTransferApplyId())) {
            flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getTransferApplyId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowTransferApplyState(flowTaskEntity.getStatus());
            } else {
                vo.setFlowTransferApplyState(null);
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getChangePlanApplyId())) {
            flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getChangePlanApplyId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowChangePlanApplyState(flowTaskEntity.getStatus());
            } else {
                vo.setFlowChangePlanApplyState(null);
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getAuthorizationApplyId())) {
            flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getAuthorizationApplyId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setAuthorizationApplyState(flowTaskEntity.getStatus());
            } else {
                vo.setAuthorizationApplyState(null);
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getStopApplyId())) {
            flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getStopApplyId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setStopApplyState(flowTaskEntity.getStatus());
            } else {
                vo.setStopApplyState(null);
            }
        }
        BigDecimal sum = this.rkContractProjectCostService.totalityCostByProject(entity.getId());
        vo.setProjectCostName(sum);
        if (ObjectUtil.isNotEmpty((Object)vo.getProjectAmount())) {
            BigDecimal divide = MathUtils.divide(MathUtils.multiply(sum, new BigDecimal(100)), vo.getProjectAmount(), 2);
            vo.setProportionName(divide);
        }
        if (StringUtil.isNotEmpty((String)vo.getExecuteUserDepartment())) {
            vo.setExecuteUserDepartmentName(this.baseDataUtil.comSelectValues(vo.getExecuteUserDepartment()));
        }
        if (StringUtil.isNotEmpty((String)vo.getExecuteAssistantsUserDepartment())) {
            vo.setExecuteAssistantsUserDepartmentName(this.baseDataUtil.comSelectValues(vo.getExecuteAssistantsUserDepartment()));
        }
        vo.setAfterSaleExecuteUserName(this.baseDataUtil.userSelectValues(vo.getAfterSaleExecuteUser()));
        vo.setAfterSaleExecuteAssistantsUserName(this.baseDataUtil.userSelectValues(vo.getAfterSaleExecuteAssistantsUser()));
        vo.setAfterSaleHeaderName(this.baseDataUtil.userSelectValues(vo.getAfterSaleHeader()));
        vo.setAfterSalesManagerName(this.baseDataUtil.userSelectValues(vo.getAfterSalesManager()));
        vo.setAfterSalesAssistantName(this.baseDataUtil.userSelectValue(vo.getAfterSalesAssistant()));
        if (StrUtil.isNotEmpty((CharSequence)vo.getContractId()) && CollectionUtil.isNotEmpty(purchasePlanList = this.oaPurchasePlanService.getByContractId(vo.getContractId()))) {
            vo.setPurchasePlanList(purchasePlanList);
        }
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PutMapping(value={"/userAll/{id}"})
    @Transactional
    @RepeatSubmit
    public ActionResult updateUserAll(@PathVariable(value="id") String id, @RequestBody @Valid RkContractProjectUserAllUpForm upForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            RkContractProjectEntity entity = this.rkContractProjectService.getInfo(id);
            if (ObjectUtil.isNotEmpty((Object)entity)) {
                List<RkContractCollectionRecordEntity> listByProjectId;
                entity.setRegionalHead(upForm.getRegionalHead());
                entity.setProjectHeader(upForm.getProjectHeaderId());
                entity.setAssistantsUser(upForm.getAssistantsUserId());
                entity.setExecuteUser(upForm.getExecuteUserCode());
                entity.setExecuteAssistantsUser(upForm.getExecuteAssistantsUserId());
                entity.setExecuteUserDepartment(upForm.getExecuteUserDepartment());
                entity.setExecuteAssistantsUserDepartment(upForm.getExecuteAssistantsUserDepartment());
                entity.setAfterSalesManager(upForm.getAfterSalesManager());
                entity.setAfterSaleExecuteUser(upForm.getAfterSaleExecuteUser());
                entity.setAfterSaleExecuteAssistantsUser(upForm.getAfterSaleExecuteAssistantsUser());
                entity.setAfterSaleHeader(upForm.getAfterSaleHeader());
                entity.setAfterSalesAssistant(upForm.getAfterSalesAssistant());
                entity.setSendType(upForm.getSendType());
                this.rkContractProjectService.updateUserAll(entity);
                this.rkContractProjectMemberService.dealProjectMember("", entity);
                AfterSalesProjectsEntity afterSalesProjectsEntity = this.afterSalesProjectsService.byProjectCode(entity.getProjectCode());
                if (StrUtil.isNotEmpty((CharSequence)upForm.getProjectHeaderId()) && CollectionUtil.isNotEmpty(listByProjectId = this.rkContractCollectionRecordService.getListByProjectId(entity.getId()))) {
                    listByProjectId.stream().forEach(record -> {
                        record.setProjectManagerId(upForm.getProjectHeaderId());
                        this.rkContractCollectionRecordService.updateById(record);
                    });
                }
                if (ObjectUtil.isNotEmpty((Object)afterSalesProjectsEntity)) {
                    if (StringUtils.isNotEmpty((String)upForm.getAfterSaleHeader())) {
                        afterSalesProjectsEntity.setAfterSalesPerson(upForm.getAfterSaleHeader());
                    }
                    if (StringUtils.isNotEmpty((String)upForm.getAfterSaleExecuteUser())) {
                        afterSalesProjectsEntity.setAfterSaleExecuteUser(upForm.getAfterSaleExecuteUser());
                    }
                    if (StringUtils.isNotEmpty((String)upForm.getAfterSaleExecuteAssistantsUser())) {
                        afterSalesProjectsEntity.setAssistantsUser(upForm.getAfterSaleExecuteAssistantsUser());
                    }
                    if (StringUtils.isNotEmpty((String)upForm.getAfterSalesManager())) {
                        afterSalesProjectsEntity.setAfterSalesManager(upForm.getAfterSalesManager());
                    }
                    if (StringUtils.isNotEmpty((String)upForm.getAfterSalesAssistant())) {
                        afterSalesProjectsEntity.setAfterSalesAssistant(upForm.getAfterSalesAssistant());
                    }
                    this.afterSalesProjectsService.update(afterSalesProjectsEntity.getId(), afterSalesProjectsEntity);
                }
                return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PutMapping(value={"/{id}"})
    @Transactional
    @RepeatSubmit
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkContractProjectUpForm rkContractProjectUpForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            RkContractProjectEntity entity = this.rkContractProjectService.getInfo(id);
            if (entity != null) {
                CrmProductEntity crmProductEntity;
                List<CrmAuthorizationModuleEntity> moduleList = this.crmAuthorizationModuleService.getByIds(rkContractProjectUpForm.getAuthorizationModuleIds());
                if (CollectionUtil.isNotEmpty(moduleList)) {
                    rkContractProjectUpForm.setAuthorizationModule(moduleList.stream().map(CrmAuthorizationModuleEntity::getModuleName).distinct().collect(Collectors.joining(",")));
                }
                if (StrUtil.isNotEmpty((CharSequence)rkContractProjectUpForm.getJcProductId()) && ObjectUtil.isNotEmpty((Object)(crmProductEntity = this.crmProductService.getInfo(rkContractProjectUpForm.getJcProductId())))) {
                    rkContractProjectUpForm.setJcProductName(crmProductEntity.getProductName());
                }
                this.rkContractProjectService.updateProject(rkContractProjectUpForm);
                return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            RkContractProjectEntity entity = this.rkContractProjectService.getInfo(id);
            if (entity != null) {
                if (StrUtil.isNotBlank((CharSequence)entity.getState()) && !StrUtil.equals((CharSequence)entity.getState(), (CharSequence)ProjectStateEnum.notStartApply_state.getState())) {
                    return ActionResult.fail((String)"\u9879\u76ee\u5df2\u7ecf\u5f00\u5de5\uff0c\u4e0d\u80fd\u5220\u9664");
                }
                List<RkContractCollectionRecordEntity> listByProjectId = this.contractCollectionRecordService.getListByProjectId(id);
                if (CollectionUtil.isNotEmpty(listByProjectId)) {
                    return ActionResult.fail((String)"\u8be5\u9879\u76ee\u5df2\u5173\u8054\u5230\u6b3e\u8bb0\u5f55\uff0c\u4e0d\u80fd\u5220\u9664");
                }
                List<RkAttachmentEntity> listByProjectId1 = this.attachmentService.getListByProjectId(id);
                if (CollectionUtil.isNotEmpty(listByProjectId1)) {
                    return ActionResult.fail((String)"\u8be5\u9879\u76ee\u5df2\u5173\u8054\u56de\u6b3e\u8ba1\u5212\uff0c\u4e0d\u80fd\u5220\u9664");
                }
                entity.setEnabledMark(0);
                entity.setDeleteTime(DateUtil.getNowDate());
                entity.setDeleteUserId(userInfo.getUserId());
                this.rkContractProjectService.updateById(entity);
            }
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping(value={"accept"})
    public ActionResult accept(@RequestBody RkAcceptProjectCrForm acceptProjectCrForm) {
        Object object = this.$lock;
        synchronized (object) {
            RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)acceptProjectCrForm.getProjectId()));
            if (ObjectUtil.isNull((Object)byId)) {
                return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            if (byId.getEnabledMark() == 0) {
                return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            byId.setIsAcceptance(1);
            byId.setState("accepted");
            byId.setAcceptedBy(acceptProjectCrForm.getAcceptedBy());
            byId.setAcceptRemark(acceptProjectCrForm.getAcceptRemark());
            byId.setAcceptanceTime(acceptProjectCrForm.getAcceptanceTime());
            this.rkContractProjectService.updateById(byId);
            return ActionResult.success((String)"\u9a8c\u6536\u786e\u8ba4\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @GetMapping(value={"/know/{id}"})
    public ActionResult know(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)id));
            if (ObjectUtil.isNull((Object)byId)) {
                return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            if (byId.getEnabledMark() == 0) {
                return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            byId.setIsKnow(0);
            byId.setIsAcceptance(1);
            byId.setState("accepted");
            if (ObjectUtil.isNull((Object)byId.getAcceptanceTime())) {
                byId.setAcceptedBy(userInfo.getUserId());
                byId.setAcceptanceTime(DateUtil.getNowDate());
            }
            byId.setKnowBy(userInfo.getUserId());
            byId.setKnowTime(DateUtil.getNowDate());
            this.rkContractProjectService.updateById(byId);
            return ActionResult.success((String)"\u786e\u8ba4\u5df2\u77e5\u6653\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DSTransactional
    @PostMapping(value={"/updateAcceptFile"})
    public ActionResult updateAcceptFile(@RequestBody RkAcceptProjectCrForm rkAcceptProjectCrForm) {
        Object object = this.$lock;
        synchronized (object) {
            if (CollectionUtil.isEmpty(rkAcceptProjectCrForm.getAttachmentList())) {
                return ActionResult.fail((String)"\u8bf7\u4e0a\u4f20\u9644\u4ef6");
            }
            RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)rkAcceptProjectCrForm.getProjectId()));
            if (byId.getEnabledMark() == 0) {
                return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            List<RkAttachmentCrForm> attachmentList = rkAcceptProjectCrForm.getAttachmentList();
            attachmentList.stream().forEach(attach -> {
                attach.setContractId(byId.getContractId());
                attach.setProjectId(rkAcceptProjectCrForm.getProjectId());
                attach.setFileType(AttachmentTypeEnum.PROJECT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
            this.attachmentService.saveBatch(attachmentEntityList);
            byId.setIsUploadAcceptFile(1);
            this.rkContractProjectService.updateById(byId);
            return ActionResult.success((String)"\u4e0a\u4f20\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping(value={"/archived"})
    public ActionResult archived(@RequestBody RkAcceptProjectArchivedCrForm rkAcceptProjectArchivedCrForm) {
        Object object = this.$lock;
        synchronized (object) {
            RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)rkAcceptProjectArchivedCrForm.getProjectId()));
            if (ObjectUtil.isNull((Object)byId)) {
                return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            if (byId.getEnabledMark() == 0) {
                return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            UserInfo userInfo = this.userProvider.get();
            byId.setAcceptArchivedBoxNumber(rkAcceptProjectArchivedCrForm.getAcceptArchivedBoxNumber());
            byId.setAcceptArchivedCupboard(rkAcceptProjectArchivedCrForm.getAcceptArchivedCupboard());
            byId.setAcceptArchivedLocation(rkAcceptProjectArchivedCrForm.getAcceptArchivedLocation());
            byId.setAcceptArchivedVolume(rkAcceptProjectArchivedCrForm.getAcceptArchivedVolume());
            byId.setAcceptArchivedBy(userInfo.getUserId());
            byId.setAcceptArchivedTime(new Date());
            byId.setAcceptIsArchived(1);
            byId.setArchivedRemark(rkAcceptProjectArchivedCrForm.getArchivedRemark());
            this.rkContractProjectService.updateById(byId);
            return ActionResult.success((String)"\u5f52\u6863\u6210\u529f");
        }
    }

    @RepeatSubmit
    @PostMapping(value={"assigned"})
    public ActionResult assigned(@RequestBody @Valid RkProjectAssignedForm assignedForm) throws Exception {
        if (StrUtil.isBlank((CharSequence)assignedForm.getId())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u8981\u5206\u6d3e\u7684\u9879\u76ee");
        }
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)assignedForm.getId()));
        if (byId.getEnabledMark() == 0) {
            return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        if (StrUtil.isBlank((CharSequence)assignedForm.getType())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5206\u6d3e\u7c7b\u578b");
        }
        this.rkContractProjectService.assignedProject(assignedForm);
        String msg = "\u5206\u6d3e\u6210\u529f";
        if (StrUtil.equals((CharSequence)assignedForm.getType(), (CharSequence)"execute")) {
            msg = "\u6307\u5b9a\u5b9e\u65bd\u4eba\u5458\u6210\u529f";
        }
        if (StrUtil.equals((CharSequence)assignedForm.getType(), (CharSequence)"changeExecute")) {
            msg = "\u66f4\u6362\u5b9e\u65bd\u4eba\u5458\u6210\u529f";
        }
        if (StrUtil.equals((CharSequence)assignedForm.getType(), (CharSequence)"changeRegionHeader")) {
            msg = "\u53d8\u66f4\u533a\u57df\u8d1f\u8d23\u4eba\u6210\u529f";
        }
        return ActionResult.success((String)msg);
    }

    @RepeatSubmit
    @PostMapping(value={"startOrStop"})
    public ActionResult startOrStop(@RequestBody @Valid RkProjectAssignedForm assignedForm) {
        if (StrUtil.isBlank((CharSequence)assignedForm.getId())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u9879\u76ee");
        }
        RkContractProjectEntity byId = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)assignedForm.getId()));
        if (ObjectUtil.isNull((Object)byId)) {
            return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        if (byId.getEnabledMark() == 0) {
            return ActionResult.fail((String)"\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        this.rkContractProjectService.startOrStopProject(assignedForm);
        return ActionResult.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/acceptExport"})
    public ActionResult acceptExport(@ParamAddress(field="customerAddress,signAddress") RkContractProjectPaginationExportModel rkContractProjectPaginationExportModel) throws IOException, WorkFlowException {
        if (StringUtil.isEmpty((String)rkContractProjectPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkContractProjectPagination rkContractProjectPagination = (RkContractProjectPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractProjectPaginationExportModel), RkContractProjectPagination.class));
        List<RkContractProjectEntity> list = this.rkContractProjectService.getTypeList(rkContractProjectPagination, rkContractProjectPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, RkContractProjectListVO.class);
        for (RkContractProjectListVO rkContractProjectListVO : listVO) {
            RkContractEntity contractInfo;
            if (StringUtils.isNotEmpty((String)rkContractProjectListVO.getCustomerId())) {
                rkContractProjectListVO.setCustomerName(this.crmCustomerService.getInfo(rkContractProjectListVO.getCustomerId()).getName());
            }
            if (ObjectUtil.isNotEmpty((Object)rkContractProjectListVO.getAcceptApplyId())) {
                FlowTaskEntity flowTaskEntity = this.flowTaskService.getDraftTaskByProcessId(rkContractProjectListVO.getAcceptApplyId());
                if (ObjectUtil.isNotEmpty((Object)flowTaskEntity)) {
                    FlowTaskNodeEntity flowTaskNodeEntity = (FlowTaskNodeEntity)this.flowTaskNodeService.getById((Serializable)((Object)flowTaskEntity.getThisStepId()));
                    List operatorList = this.flowTaskOperatorService.getListByNode(flowTaskEntity.getId(), flowTaskNodeEntity.getId());
                    String result = operatorList.stream().map(FlowTaskOperatorEntity::getHandleId).collect(Collectors.joining(","));
                    String userName = this.baseDataUtil.userSelectValues(result);
                    rkContractProjectListVO.setCurrentApprove(userName);
                }
                if ("0".equals(rkContractProjectListVO.getIsAcceptance()) && rkContractProjectListVO.getState().equals("toBeAccepted")) {
                    rkContractProjectListVO.setIsAcceptance("toBeAccepted");
                }
                OaAcceptModel oaAcceptModel = this.oaAcceptService.getInfoById(rkContractProjectListVO.getAcceptApplyId());
                rkContractProjectListVO.setAcceptedBy(this.baseDataUtil.userSelectValue(oaAcceptModel.getAcceptedBy()));
                rkContractProjectListVO.setAcceptedTime(oaAcceptModel.getAcceptedTime());
            }
            if (!ObjectUtil.isNotEmpty((Object)(contractInfo = (RkContractEntity)this.contractService.getById((Serializable)((Object)rkContractProjectListVO.getContractId()))))) continue;
            rkContractProjectListVO.setContractCode(contractInfo.getContractCode());
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd"));
        String[] keys = !StringUtil.isEmpty((String)rkContractProjectPaginationExportModel.getSelectKey()) ? rkContractProjectPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatAcceptModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadVO creatAcceptModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block26: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName"));
                        continue block26;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block26;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u53f7", (Object)"projectCode"));
                        continue block26;
                    }
                    case "acceptedBy": {
                        entitys.add(new ExcelExportEntity("\u9a8c\u6536\u53d1\u8d77\u4eba", (Object)"acceptedBy"));
                        continue block26;
                    }
                    case "acceptedTime": {
                        entitys.add(new ExcelExportEntity("\u9a8c\u6536\u53d1\u8d77\u65f6\u95f4", (Object)"acceptedTime"));
                        continue block26;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerName"));
                        continue block26;
                    }
                    case "currentApprove": {
                        entitys.add(new ExcelExportEntity("\u5f53\u524d\u5ba1\u6279\u4eba", (Object)"currentApprove"));
                        continue block26;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u9879\u76ee\u9a8c\u6536\u53f0\u8d26" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(@ParamAddress(field="customerAddress,signAddress") RkContractProjectPaginationExportModel rkContractProjectPaginationExportModel) throws IOException, WorkFlowException {
        if (StringUtil.isEmpty((String)rkContractProjectPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkContractProjectPagination rkContractProjectPagination = (RkContractProjectPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractProjectPaginationExportModel), RkContractProjectPagination.class));
        List<RkContractProjectEntity> list = this.rkContractProjectService.getTypeList(rkContractProjectPagination, rkContractProjectPaginationExportModel.getDataType());
        List<RkContractProjectListVO> listVO = this.appendListVo(list, true);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd"));
        if (CollectionUtil.isNotEmpty((Collection)mapList)) {
            mapList.stream().forEach(m -> {
                String s;
                DateTime expectedSigningDate;
                if (ObjectUtil.isNotNull(m.get("singDate"))) {
                    expectedSigningDate = cn.hutool.core.date.DateUtil.date((long)Long.valueOf(m.get("singDate").toString()));
                    s = cn.hutool.core.date.DateUtil.formatDate((Date)expectedSigningDate);
                    m.put("singDate", s);
                }
                if (ObjectUtil.isNotNull(m.get("acceptanceTime"))) {
                    expectedSigningDate = cn.hutool.core.date.DateUtil.date((long)Long.valueOf(m.get("acceptanceTime").toString()));
                    s = cn.hutool.core.date.DateUtil.formatDate((Date)expectedSigningDate);
                    m.put("acceptanceTime", s);
                }
            });
        }
        String[] keys = !StringUtil.isEmpty((String)rkContractProjectPaginationExportModel.getSelectKey()) ? rkContractProjectPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatListModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadVO creatListModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block78: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName"));
                        continue block78;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u53f7", (Object)"projectCode"));
                        continue block78;
                    }
                    case "sureIncome": {
                        entitys.add(new ExcelExportEntity("\u53ef\u786e\u8ba4\u91d1\u989d", (Object)"sureIncome"));
                        continue block78;
                    }
                    case "allConfirmIncome": {
                        entitys.add(new ExcelExportEntity("\u5df2\u786e\u8ba4\u91d1\u989d", (Object)"allConfirmIncome"));
                        continue block78;
                    }
                    case "confirmIncomeDate": {
                        entitys.add(new ExcelExportEntity("\u6700\u65b0\u786e\u6536\u65e5\u671f", (Object)"confirmIncomeDate"));
                        continue block78;
                    }
                    case "state": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u9636\u6bb5", (Object)"state"));
                        continue block78;
                    }
                    case "projectPlanRatio": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u5b8c\u6210\u6bd4\u4f8b", (Object)"projectPlanRatio"));
                        continue block78;
                    }
                    case "contractType": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7c7b\u578b", (Object)"contractType"));
                        continue block78;
                    }
                    case "projectCostName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u8d39\u7528", (Object)"projectCostName"));
                        continue block78;
                    }
                    case "proportionName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u8d39\u7528\u5360\u6bd4", (Object)"proportionName"));
                        continue block78;
                    }
                    case "startDate": {
                        entitys.add(new ExcelExportEntity("\u5f00\u5de5\u65e5\u671f", (Object)"startDate"));
                        continue block78;
                    }
                    case "projectHeaderDesc": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7ecf\u7406", (Object)"projectHeaderDesc"));
                        continue block78;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u6700\u7ec8\u7528\u6237", (Object)"customerName"));
                        continue block78;
                    }
                    case "receivedAmount": {
                        entitys.add(new ExcelExportEntity("\u5df2\u56de\u6b3e\u91d1\u989d", (Object)"receivedAmount"));
                        continue block78;
                    }
                    case "receivedRatio": {
                        entitys.add(new ExcelExportEntity("\u56de\u6b3e\u6bd4\u4f8b", (Object)"receivedRatio"));
                        continue block78;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u5bf9\u8c61", (Object)"agentName"));
                        continue block78;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block78;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block78;
                    }
                    case "incomeType": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5927\u7c7b", (Object)"incomeType"));
                        continue block78;
                    }
                    case "signDate": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u65e5\u671f", (Object)"signDate"));
                        continue block78;
                    }
                    case "acceptanceTime": {
                        entitys.add(new ExcelExportEntity("\u9a8c\u6536\u65e5\u671f", (Object)"acceptanceTime"));
                        continue block78;
                    }
                    case "addressName": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u5730\u5740", (Object)"addressName"));
                        continue block78;
                    }
                    case "projectAmount": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u91d1\u989d", (Object)"projectAmount"));
                        continue block78;
                    }
                    case "jcProductName": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1", (Object)"jcProductName"));
                        continue block78;
                    }
                    case "authorizationModule": {
                        entitys.add(new ExcelExportEntity("\u6388\u6743\u6a21\u5757", (Object)"authorizationModule"));
                        continue block78;
                    }
                    case "copyrightName": {
                        entitys.add(new ExcelExportEntity("\u8457\u4f5c\u6743\u540d\u79f0", (Object)"copyrightName"));
                        continue block78;
                    }
                    case "copyrightAmount": {
                        entitys.add(new ExcelExportEntity("\u8457\u4f5c\u6743\u91d1\u989d(\u5143)", (Object)"copyrightAmount"));
                        continue block78;
                    }
                    case "performStatusName": {
                        entitys.add(new ExcelExportEntity("\u5c65\u884c\u72b6\u6001", (Object)"performStatusName"));
                        continue block78;
                    }
                    case "hardSalePrice": {
                        entitys.add(new ExcelExportEntity("\u786c\u4ef6\u552e\u51fa\u5355\u4ef7(\u5143)", (Object)"hardSalePrice"));
                        continue block78;
                    }
                    case "publicKeyA": {
                        entitys.add(new ExcelExportEntity("\u516c\u94a5A", (Object)"publicKeyA"));
                        continue block78;
                    }
                    case "publicKeyB": {
                        entitys.add(new ExcelExportEntity("\u516c\u94a5B", (Object)"publicKeyB"));
                        continue block78;
                    }
                    case "markType": {
                        entitys.add(new ExcelExportEntity("\u6807\u8bb0", (Object)"markType"));
                        continue block78;
                    }
                    case "projectIncomeTypeName": {
                        entitys.add(new ExcelExportEntity("\u6536\u5165\u7c7b\u578b", (Object)"projectIncomeTypeName"));
                        continue block78;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u9879\u76ee\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/getContractCodeAndProjectCode"})
    public ActionResult getContractCodeAndProjectCode(String contractCode, String projectCode) {
        List list = CollectionUtil.list((boolean)false);
        String type = "";
        RkContractEntity contractEntity = null;
        if (StrUtil.isNotBlank((CharSequence)projectCode)) {
            RkContractProjectEntity projectEntity = this.rkContractProjectService.getInfoByCode(projectCode, this.userProvider.get().getOrganizeId());
            RkContractProjectInfoVO projectInfoVO = (RkContractProjectInfoVO)JsonUtil.getJsonToBean((Object)projectEntity, RkContractProjectInfoVO.class);
            if (ObjectUtil.isNotEmpty((Object)projectInfoVO)) {
                projectInfoVO.setCustomerName(this.crmCustomerService.getInfo(projectInfoVO.getCustomerId()).getName());
                list.add(projectInfoVO);
                contractEntity = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)projectInfoVO.getContractId()));
                type = "project";
            }
        } else if (StrUtil.isNotBlank((CharSequence)contractCode) && ObjectUtil.isNotEmpty((Object)(contractEntity = this.rkContractService.getInfoByCode(contractCode, this.userProvider.get().getOrganizeId())))) {
            type = "contract";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        RkContractInfoVO jsonToBean = (RkContractInfoVO)JsonUtil.getJsonToBean(contractEntity, RkContractInfoVO.class);
        if (ObjectUtil.isNotNull((Object)jsonToBean)) {
            if (StringUtils.isNotEmpty((String)jsonToBean.getCustomerIds())) {
                jsonToBean.setCustomerNames(this.saleContractCustomerService.getCustomerNamesByContractId(jsonToBean.getId()));
                jsonToBean.setCustomerName(jsonToBean.getCustomerNames().split(",")[0]);
            }
            if ("1".equals(jsonToBean.getIsAgent())) {
                RkAgentEntity agent;
                if (StringUtils.isNotEmpty((String)jsonToBean.getAgentId()) && null != (agent = this.agentService.getInfo(jsonToBean.getAgentId()))) {
                    jsonToBean.setAgentName(agent.getName());
                }
            } else {
                jsonToBean.setAgentName(jsonToBean.getCustomerNames());
            }
            jsonToBean.setIncomeTypeDesc(this.crmProductCategoryService.getNameByIds(jsonToBean.getIncomeType()));
        }
        map.put("contract", jsonToBean);
        map.put("projectList", list);
        map.put("type", type);
        return ActionResult.success(map);
    }
}

