/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.MessageTypeEnum;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractProjectCostEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.model.rkContractCost.RkContractProjectCostCrForm;
import com.bringspring.contract.model.rkContractCost.RkContractProjectCostInfoVO;
import com.bringspring.contract.model.rkContractCost.RkContractProjectCostListVO;
import com.bringspring.contract.model.rkContractCost.RkContractProjectCostPagination;
import com.bringspring.contract.model.rkContractCost.RkContractProjectCostUpForm;
import com.bringspring.contract.model.rkattachment.RkAttachmentCrForm;
import com.bringspring.contract.model.rkattachment.RkAttachmentInfoVO;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractProjectCostService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.model.organize.OrganizeCrModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.MessageUtils;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"rk_contract_project_cost"}, value="contract")
@RequestMapping(value={"/api/contract/RkContractProjectCost"})
public class RkContractProjectCostController {
    private static final Logger log = LoggerFactory.getLogger(RkContractProjectCostController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractProjectCostService rkContractProjectCostService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkContractProjectCostPagination rkContractProjectCostPagination) throws IOException {
        List<RkContractProjectCostEntity> list = this.rkContractProjectCostService.getList(rkContractProjectCostPagination);
        for (RkContractProjectCostEntity rkContractProjectCostEntity : list) {
            rkContractProjectCostEntity.setProjectCode(this.baseDataUtil.getDictName(rkContractProjectCostEntity.getProjectCode(), "projectCost"));
        }
        List listVO = JsonUtil.getJsonToList(list, RkContractProjectCostListVO.class);
        for (RkContractProjectCostListVO rkContractProjectCostVO : listVO) {
            OrganizeEntity byId;
            rkContractProjectCostVO.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(rkContractProjectCostVO.getCreatorUserId()));
            rkContractProjectCostVO.setAffirmUserId(this.baseDataUtil.userSelectValueNoAccount(rkContractProjectCostVO.getAffirmUserId()));
            if (!StrUtil.isNotEmpty((CharSequence)rkContractProjectCostVO.getCompanyId()) || !ObjectUtil.isNotNull((Object)(byId = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)rkContractProjectCostVO.getCompanyId()))))) continue;
            OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)byId.getPropertyJson(), OrganizeCrModel.class);
            rkContractProjectCostVO.setCompanyName(jsonToBean.getShortName());
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractProjectCostPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkContractProjectCostCrForm rkContractProjectCostCrForm) throws Exception {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkContractProjectCostEntity entity = (RkContractProjectCostEntity)JsonUtil.getJsonToBean((Object)rkContractProjectCostCrForm, RkContractProjectCostEntity.class);
        entity.setProjectId(rkContractProjectCostCrForm.getRkContractProjectId());
        RkContractProjectEntity info = this.rkContractProjectService.getInfo(rkContractProjectCostCrForm.getRkContractProjectId());
        if (StringUtils.isNotEmpty((String)info.getRegionalHead())) {
            entity.setRegionalHead(info.getRegionalHead());
        }
        if (StringUtils.isNotEmpty((String)info.getProjectHeader())) {
            entity.setProjectHeader(info.getProjectHeader());
        }
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setId(mainId);
        if (ObjectUtil.isNotEmpty((Object)rkContractProjectCostCrForm.getState())) {
            if (rkContractProjectCostCrForm.getState().booleanValue()) {
                entity.setState("1");
            } else {
                entity.setState("0");
                if (StringUtils.isNotEmpty((String)info.getProjectHeader())) {
                    entity.setAffirmUserId(info.getProjectHeader());
                }
            }
        } else {
            entity.setState("0");
            if (StringUtils.isNotEmpty((String)info.getProjectHeader())) {
                entity.setAffirmUserId(info.getProjectHeader());
            }
        }
        this.rkContractProjectCostService.save(entity);
        RkAttachmentEntity rkAttachmentEntity = new RkAttachmentEntity();
        rkAttachmentEntity.setObjId(mainId);
        rkAttachmentEntity.setProjectId(entity.getProjectId());
        rkAttachmentEntity.setFileType("project_cost");
        if (CollectionUtil.isNotEmpty(rkContractProjectCostCrForm.getAttachmentEntityList())) {
            for (RkAttachmentCrForm rkAttachmentCrForm : rkContractProjectCostCrForm.getAttachmentEntityList()) {
                String mainId2 = RandomUtil.uuId();
                rkAttachmentEntity.setId(mainId2);
                rkAttachmentEntity.setFileId(rkAttachmentCrForm.getFileId());
                rkAttachmentEntity.setUrl(rkAttachmentCrForm.getUrl());
                rkAttachmentEntity.setName(rkAttachmentCrForm.getName());
                rkAttachmentEntity.setSecondFilePath(rkAttachmentCrForm.getSecondFilePath());
                if (StringUtils.isNotEmpty((String)rkAttachmentCrForm.getFileSize())) {
                    rkAttachmentEntity.setFileSize(Double.valueOf(rkAttachmentCrForm.getFileSize()));
                }
                this.rkAttachmentService.create(rkAttachmentEntity);
            }
        }
        if (!info.getCompanyId().equals("14")) {
            String messageTime = DateUtil.dateFormat((Date)new Date());
            String title = userInfo.getUserName() + "\u63d0\u4ea4\u4e86" + entity.getProjectName() + "\u9879\u76ee\u7684\u8d39\u7528\uff0c\u8bf7\u524d\u5f80\u786e\u8ba4\uff01";
            String content = "\u9879\u76ee\u540d\u79f0\uff1a" + entity.getProjectName() + "\n\u9879\u76ee\u7f16\u7801\uff1a" + entity.getProjectCode() + "\n\u5ba2\u6237\u540d\u79f0\uff1a" + entity.getCustomerName() + "\n\u91d1\u989d\uff1a" + entity.getPrice() + "\n\u8d39\u7528\u63cf\u8ff0\uff1a" + entity.getContent() + "\n\u521b\u5efa\u65f6\u95f4\uff1a" + messageTime;
            this.pushToAssgin(title, content, info.getProjectHeader());
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    public void pushToAssgin(String title, String content, String userId) throws Exception {
        String taskCode = MessageTypeEnum.PROJECT_COST_TEMPLATE.getMessage();
        String sendCode = MessageTypeEnum.PROJECT_COST_TEMPLATE.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        keys.put("title", title);
        keys.put("content", content);
        String appUrl = "/#/pages/project/projectCost/index?menuId=581740626756795205";
        String pcUrl = "/#/contract/project/ProjectCostListPage";
        String termType = TermTypeEnum.TERM_APP_PC.getCode();
        this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, userId, termType, null);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractProjectCostInfoVO> info(@PathVariable(value="id") String id) {
        RkContractProjectCostEntity entity = this.rkContractProjectCostService.getInfo(id);
        RkContractProjectCostInfoVO vo = (RkContractProjectCostInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractProjectCostInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        vo.setAffirmUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getAffirmUserId()));
        List<RkAttachmentEntity> listByProjectTypeId = this.rkAttachmentService.getListByProjectTypeId(id, "project_cost");
        ArrayList<RkAttachmentInfoVO> infoVOArrayList = new ArrayList<RkAttachmentInfoVO>();
        listByProjectTypeId.stream().forEach(attachmentEntity -> {
            RkAttachmentInfoVO jsonToBean = (RkAttachmentInfoVO)JsonUtil.getJsonToBean((Object)attachmentEntity, RkAttachmentInfoVO.class);
            infoVOArrayList.add(jsonToBean);
        });
        vo.setAttachmentEntityList(infoVOArrayList);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractProjectCostInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkContractProjectCostEntity entity = this.rkContractProjectCostService.getInfo(id);
        RkContractProjectCostInfoVO vo = (RkContractProjectCostInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractProjectCostInfoVO.class);
        vo.setProjectCode(this.baseDataUtil.getDictName(vo.getProjectCode(), "projectCost"));
        List<RkAttachmentEntity> listByProjectTypeId = this.rkAttachmentService.getListByProjectTypeId(entity.getProjectId(), "project_cost");
        listByProjectTypeId.stream().forEach(attachmentEntity -> {
            RkAttachmentInfoVO jsonToBean = (RkAttachmentInfoVO)JsonUtil.getJsonToBean((Object)attachmentEntity, RkAttachmentInfoVO.class);
            vo.setAttachmentEntityList(CollectionUtil.list((boolean)false, (Object[])new RkAttachmentInfoVO[]{jsonToBean}));
        });
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkContractProjectCostUpForm rkContractProjectCostUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkContractProjectCostEntity entity = this.rkContractProjectCostService.getInfo(id);
        if (entity != null) {
            RkContractProjectCostEntity subentity = (RkContractProjectCostEntity)JsonUtil.getJsonToBean((Object)rkContractProjectCostUpForm, RkContractProjectCostEntity.class);
            if (entity.getState().equals("2")) {
                subentity.setState("0");
            }
            this.rkContractProjectCostService.update(id, subentity);
            this.rkAttachmentService.deleteByProjectTypeId(id, "project_cost");
            RkAttachmentEntity rkAttachmentEntity = new RkAttachmentEntity();
            rkAttachmentEntity.setObjId(entity.getId());
            rkAttachmentEntity.setProjectId(entity.getProjectId());
            rkAttachmentEntity.setFileType("project_cost");
            if (CollectionUtil.isNotEmpty(rkContractProjectCostUpForm.getAttachmentEntityList())) {
                for (RkAttachmentCrForm rkAttachmentCrForm : rkContractProjectCostUpForm.getAttachmentEntityList()) {
                    String mainId2 = RandomUtil.uuId();
                    rkAttachmentEntity.setId(mainId2);
                    rkAttachmentEntity.setFileId(rkAttachmentCrForm.getFileId());
                    rkAttachmentEntity.setUrl(rkAttachmentCrForm.getUrl());
                    rkAttachmentEntity.setName(rkAttachmentCrForm.getName());
                    rkAttachmentEntity.setSecondFilePath(rkAttachmentCrForm.getSecondFilePath());
                    if (StringUtils.isNotEmpty((String)rkAttachmentCrForm.getFileSize())) {
                        rkAttachmentEntity.setFileSize(Double.valueOf(rkAttachmentCrForm.getFileSize()));
                    }
                    this.rkAttachmentService.create(rkAttachmentEntity);
                }
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/principal/{id}/{state}"})
    @DSTransactional
    public ActionResult principalUpdate(@PathVariable(value="id") String id, @PathVariable(value="state") String state, @RequestBody @Valid RkContractProjectCostUpForm rkContractProjectCostUpForm) throws Exception {
        UserInfo userInfo = this.userProvider.get();
        RkContractProjectCostEntity entity = this.rkContractProjectCostService.getInfo(id);
        if (entity != null) {
            RkContractProjectCostEntity subentity = (RkContractProjectCostEntity)JsonUtil.getJsonToBean((Object)rkContractProjectCostUpForm, RkContractProjectCostEntity.class);
            subentity.setState(state);
            if (state.equals("1")) {
                subentity.setAffirmUserId(userInfo.getUserId());
                subentity.setAffirmTime(new Date());
                this.rkContractProjectCostService.update(id, subentity);
                String messageTime = DateUtil.dateFormat((Date)new Date());
                String title = "\u4f60\u63d0\u4ea4\u4e86" + entity.getProjectName() + "\u9879\u76ee\u7684\u8d39\u7528\u5df2\u5b8c\u6210\uff0c\u8bf7\u67e5\u770b\uff01";
                String content = "\u9879\u76ee\u540d\u79f0\uff1a" + entity.getProjectName() + "\n\u9879\u76ee\u7f16\u7801\uff1a" + entity.getProjectCode() + "\n\u5ba2\u6237\u540d\u79f0" + entity.getCustomerName() + "\n\u91d1\u989d\uff1a" + entity.getPrice() + "\n\u786e\u8ba4\u65f6\u95f4\uff1a" + messageTime;
                this.pushToAssgin(title, content, entity.getCreatorUserId());
                return ActionResult.success((String)"\u786e\u8ba4\u6210\u529f");
            }
            subentity.setAffirmUserId(userInfo.getUserId());
            subentity.setAffirmTime(new Date());
            this.rkContractProjectCostService.update(id, subentity);
            String messageTime = DateUtil.dateFormat((Date)new Date());
            String title = "\u4f60\u63d0\u4ea4\u4e86" + entity.getProjectName() + "\u9879\u76ee\u7684\u8d39\u7528\uff0c\u88ab\u9a73\u56de\uff01";
            String content = "\u9879\u76ee\u540d\u79f0\uff1a" + entity.getProjectName() + "\n\u9879\u76ee\u7f16\u7801\uff1a" + entity.getProjectCode() + "\n\u5ba2\u6237\u540d\u79f0" + entity.getCustomerName() + "\n\u91d1\u989d\uff1a" + entity.getPrice() + "\n\u9a73\u56de\u65f6\u95f4\uff1a" + messageTime;
            this.pushToAssgin(title, content, entity.getCreatorUserId());
            return ActionResult.success((String)"\u9a73\u56de\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkContractProjectCostEntity entity = this.rkContractProjectCostService.getInfo(id);
        if (entity != null) {
            this.rkAttachmentService.deleteByObjId(id);
            this.rkContractProjectCostService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

