/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractProjectMemberEntity;
import com.bringspring.contract.model.rkcontractprojectmember.RkContractProjectMemberModel;
import com.bringspring.contract.model.rkcontractprojectmember.RkContractProjectMemberPagination;
import com.bringspring.contract.service.RkContractProjectMemberService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u6210\u5458"}, value="contract")
@RequestMapping(value={"/api/contract/RkContractProjectMember"})
public class RkContractProjectMemberController {
    private static final Logger log = LoggerFactory.getLogger(RkContractProjectMemberController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RkContractProjectMemberService rkContractProjectMemberService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkContractProjectMemberPagination rkContractProjectPagination) throws IOException {
        List<RkContractProjectMemberEntity> list = this.rkContractProjectMemberService.getList(rkContractProjectPagination);
        List<RkContractProjectMemberModel> listVO = this.appendListVo(list);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractProjectPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    private List<RkContractProjectMemberModel> appendListVo(List<RkContractProjectMemberEntity> list) {
        List modelList = JsonUtil.getJsonToList(list, RkContractProjectMemberModel.class);
        for (RkContractProjectMemberModel model : modelList) {
            model.setCreatorUserName(this.baseDataUtil.userSelectValue(model.getCreatorUserId()));
            model.setMemberUserName(this.baseDataUtil.userSelectValue(model.getMemberUserId()));
            model.setProjectRoleName(this.baseDataUtil.getDictName(model.getProjectRole(), "projectRole"));
        }
        return modelList;
    }
}

