/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkContractProjectBuyEntity;
import com.bringspring.contract.entity.RkContractProjectNEntity;
import com.bringspring.contract.model.rkcontractprojectnjf.RkContractProjectBuyModel;
import com.bringspring.contract.model.rkcontractprojectnjf.RkContractProjectNCrForm;
import com.bringspring.contract.model.rkcontractprojectnjf.RkContractProjectNInfoVO;
import com.bringspring.contract.model.rkcontractprojectnjf.RkContractProjectNListVO;
import com.bringspring.contract.model.rkcontractprojectnjf.RkContractProjectNPagination;
import com.bringspring.contract.model.rkcontractprojectnjf.RkContractProjectNPaginationExportModel;
import com.bringspring.contract.model.rkcontractprojectnjf.RkContractProjectNUpForm;
import com.bringspring.contract.service.RkContractProjectBuyService;
import com.bringspring.contract.service.RkContractProjectNService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u5217\u8868"}, value="contract")
@RequestMapping(value={"/api/contract/RkContractProjectN"})
public class RkContractProjectNController {
    private static final Logger log = LoggerFactory.getLogger(RkContractProjectNController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractProjectNService rkContractProjectNService;
    @Autowired
    private RkContractProjectBuyService rk_contractProjectBuyService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkContractProjectNPagination rkContractProjectNPagination) throws IOException {
        List<RkContractProjectNEntity> list = this.rkContractProjectNService.getList(rkContractProjectNPagination);
        for (RkContractProjectNEntity rkContractProjectNEntity : list) {
            rkContractProjectNEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(rkContractProjectNEntity.getCreatorUserId()));
            rkContractProjectNEntity.setProjectManager(this.baseDataUtil.userSelectValues(rkContractProjectNEntity.getProjectManager()));
            rkContractProjectNEntity.setSupportCompany(this.baseDataUtil.getDictName(rkContractProjectNEntity.getSupportCompany(), "499248793733047493"));
        }
        List listVO = JsonUtil.getJsonToList(list, RkContractProjectNListVO.class);
        for (RkContractProjectNListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractProjectNPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        RkContractProjectNCrForm rkContractProjectNCrForm = (RkContractProjectNCrForm)((Object)JsonUtil.getJsonToBean(crData, RkContractProjectNCrForm.class));
        String flowEngineId = "518061630219625861";
        String billNumberCode = "ScientificResearchProject";
        if (rkContractProjectNCrForm.getProjectType().equals("YF")) {
            flowEngineId = "519130115204982277";
            billNumberCode = "DevelopmentProject";
        } else if (rkContractProjectNCrForm.getProjectCode().equals("GL")) {
            billNumberCode = "ManageProject";
        }
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        rkContractProjectNCrForm.setCreatorUserId(userInfo.getUserId());
        rkContractProjectNCrForm.setCreatorTime(DateUtil.getNow());
        rkContractProjectNCrForm.setProjectCode(this.baseDataUtil.getBillNumber(billNumberCode, Boolean.valueOf(false)));
        RkContractProjectNEntity entity = (RkContractProjectNEntity)JsonUtil.getJsonToBean((Object)((Object)rkContractProjectNCrForm), RkContractProjectNEntity.class);
        entity.setId(mainId);
        this.rkContractProjectNService.save(entity);
        List rkContractProjectCgList = JsonUtil.getJsonToList(rkContractProjectNCrForm.getRkContractProjectBuyList(), RkContractProjectBuyEntity.class);
        for (RkContractProjectBuyEntity entitys : rkContractProjectCgList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setParentId(entity.getId());
            this.rk_contractProjectBuyService.save(entitys);
        }
        FlowUtil.saveOrSubmit((String)rkContractProjectNCrForm.getTaskId(), (String)flowEngineId, (String)rkContractProjectNCrForm.getTemplateId(), (String)mainId, (Object)((Object)rkContractProjectNCrForm), (Integer)rkContractProjectNCrForm.getStatus(), (String)rkContractProjectNCrForm.getProjectName());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkContractProjectNPaginationExportModel rkContractProjectNPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkContractProjectNPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkContractProjectNPagination rkContractProjectNPagination = (RkContractProjectNPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractProjectNPaginationExportModel), RkContractProjectNPagination.class));
        List<RkContractProjectNEntity> list = this.rkContractProjectNService.getTypeList(rkContractProjectNPagination, rkContractProjectNPaginationExportModel.getDataType());
        for (RkContractProjectNEntity rkContractProjectNEntity : list) {
            rkContractProjectNEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(rkContractProjectNEntity.getCreatorUserId()));
            rkContractProjectNEntity.setProjectManager(this.baseDataUtil.userSelectValues(rkContractProjectNEntity.getProjectManager()));
            rkContractProjectNEntity.setSupportCompany(this.baseDataUtil.getDictName(rkContractProjectNEntity.getSupportCompany(), "499248793733047493"));
        }
        List listVO = JsonUtil.getJsonToList(list, RkContractProjectNListVO.class);
        for (RkContractProjectNListVO rkContractProjectNListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkContractProjectNPaginationExportModel.getSelectKey()) ? rkContractProjectNPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block46: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block46;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block46;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u7801", (Object)"projectCode"));
                        continue block46;
                    }
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName"));
                        continue block46;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u63cf\u8ff0", (Object)"description"));
                        continue block46;
                    }
                    case "projectStartDate": {
                        entitys.add(new ExcelExportEntity("\u5f00\u59cb\u65e5\u671f", (Object)"projectStartDate"));
                        continue block46;
                    }
                    case "projectManager": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7ecf\u7406", (Object)"projectManager"));
                        continue block46;
                    }
                    case "projectType": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7c7b\u578b", (Object)"projectType"));
                        continue block46;
                    }
                    case "projectMount": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u91d1\u989d", (Object)"projectMount"));
                        continue block46;
                    }
                    case "materialsBudget": {
                        entitys.add(new ExcelExportEntity("\u6750\u6599\u9884\u7b97", (Object)"materialsBudget"));
                        continue block46;
                    }
                    case "serviceBudget": {
                        entitys.add(new ExcelExportEntity("\u670d\u52a1\u9884\u7b97", (Object)"serviceBudget"));
                        continue block46;
                    }
                    case "laborBudget": {
                        entitys.add(new ExcelExportEntity("\u4eba\u5de5\u9884\u7b97", (Object)"laborBudget"));
                        continue block46;
                    }
                    case "feeBudget": {
                        entitys.add(new ExcelExportEntity("\u8d39\u7528\u9884\u7b97", (Object)"feeBudget"));
                        continue block46;
                    }
                    case "otherBudget": {
                        entitys.add(new ExcelExportEntity("\u5176\u5b83\u9884\u7b97", (Object)"otherBudget"));
                        continue block46;
                    }
                    case "supportCompany": {
                        entitys.add(new ExcelExportEntity("\u652f\u6491\u516c\u53f8", (Object)"supportCompany"));
                        continue block46;
                    }
                    case "expectedReturn": {
                        entitys.add(new ExcelExportEntity("\u9884\u671f\u6536\u76ca", (Object)"expectedReturn"));
                        continue block46;
                    }
                    case "belongYear": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u5e74\u4efd", (Object)"belongYear"));
                        continue block46;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractProjectNInfoVO> info(@PathVariable(value="id") String id) {
        RkContractProjectNEntity entity = this.rkContractProjectNService.getInfo(id);
        RkContractProjectNInfoVO vo = (RkContractProjectNInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractProjectNInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        List<RkContractProjectBuyEntity> rkContractProjectCgList = this.rkContractProjectNService.GetRkContractProjectBuyList(id);
        for (RkContractProjectBuyEntity rkContractProjectBuyEntity : rkContractProjectCgList) {
        }
        vo.setRkContractProjectBuyList(JsonUtil.getJsonToList(rkContractProjectCgList, RkContractProjectBuyModel.class));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        RkContractProjectNUpForm rkContractProjectNUpForm = (RkContractProjectNUpForm)((Object)JsonUtil.getJsonToBean(upData, RkContractProjectNUpForm.class));
        String flowEngineId = "518061630219625861";
        if (rkContractProjectNUpForm.getProjectType().equals("YF")) {
            flowEngineId = "519130115204982277";
        }
        UserInfo userInfo = this.userProvider.get();
        RkContractProjectNEntity entity = this.rkContractProjectNService.getInfo(id);
        if (entity != null) {
            RkContractProjectNEntity subentity = (RkContractProjectNEntity)JsonUtil.getJsonToBean((Object)((Object)rkContractProjectNUpForm), RkContractProjectNEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.rkContractProjectNService.update(id, subentity);
            QueryWrapper rkContractProjectCgqueryWrapper = new QueryWrapper();
            rkContractProjectCgqueryWrapper.lambda().eq(RkContractProjectBuyEntity::getParentId, (Object)entity.getId());
            this.rk_contractProjectBuyService.remove((Wrapper)rkContractProjectCgqueryWrapper);
            List rkContractProjectCgList = JsonUtil.getJsonToList(rkContractProjectNUpForm.getRkContractProjectBuyList(), RkContractProjectBuyEntity.class);
            for (RkContractProjectBuyEntity entitys : rkContractProjectCgList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setParentId(entity.getId());
                this.rk_contractProjectBuyService.save(entitys);
            }
            FlowUtil.saveOrSubmit((String)rkContractProjectNUpForm.getTaskId(), (String)flowEngineId, (String)rkContractProjectNUpForm.getTemplateId(), (String)id, (Object)((Object)rkContractProjectNUpForm), (Integer)rkContractProjectNUpForm.getStatus(), (String)rkContractProjectNUpForm.getProjectName());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkContractProjectNEntity entity = this.rkContractProjectNService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.rkContractProjectNService.delete(entity);
            QueryWrapper queryWrapperRk_contract_project_cg = new QueryWrapper();
            queryWrapperRk_contract_project_cg.lambda().eq(RkContractProjectBuyEntity::getParentId, (Object)entity.getId());
            this.rk_contractProjectBuyService.remove((Wrapper)queryWrapperRk_contract_project_cg);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

