/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.constant.CompanyIdEnum;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.entity.RkReturnPlanFollowEntity;
import com.bringspring.contract.model.rkcontractreturnplan.RkContractReturnPlanCrForm;
import com.bringspring.contract.model.rkcontractreturnplan.RkContractReturnPlanInfoVO;
import com.bringspring.contract.model.rkcontractreturnplan.RkContractReturnPlanListVO;
import com.bringspring.contract.model.rkcontractreturnplan.RkContractReturnPlanPagination;
import com.bringspring.contract.model.rkcontractreturnplan.RkContractReturnPlanPaginationExportModel;
import com.bringspring.contract.model.rkcontractreturnplan.RkContractReturnPlanUpForm;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractCollectionRecordService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkReturnPlanFollowService;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.ContractReturnPlanUilts;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.ReturnPlanEnum;
import com.bringspring.contract.utils.ReturnPlanOverdueDayEnum;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.ParamAddress;
import com.bringspring.visit.utils.AfterSalesRoleUtils;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5408\u540c\u56de\u6b3e\u8ba1\u5212"}, value="contract")
@RequestMapping(value={"/api/contract/RkContractReturnPlan"})
public class RkContractReturnPlanController {
    private static final Logger log = LoggerFactory.getLogger(RkContractReturnPlanController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractReturnPlanService rkContractReturnPlanService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkAgentService agentService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkContractCollectionRecordService contractCollectionRecordService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private SaleContractCustomerService saleContractCustomerService;
    @Autowired
    private AfterSalesRoleUtils afterSalesRoleUtils;
    @Autowired
    private RkReturnPlanFollowService rkReturnPlanFollowService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@ParamAddress(field="customerAddress") @RequestBody RkContractReturnPlanPagination rkContractReturnPlanPagination) throws IOException {
        rkContractReturnPlanPagination.setSearchOverdueDateList(RkContractReturnPlanController.getOverdueDateList(rkContractReturnPlanPagination.getOverdueYears()));
        rkContractReturnPlanPagination.setSearchOverdueDateListMulti(RkContractReturnPlanController.getOverdueDateListMulti(rkContractReturnPlanPagination.getOverdueYearsList()));
        List<RkContractReturnPlanEntity> list = this.rkContractReturnPlanService.getList(rkContractReturnPlanPagination);
        List<RkContractReturnPlanListVO> listVO = this.dealReturnPlanList(list, false);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractReturnPlanPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"countAmountByPlan"})
    public ActionResult countAmountByPlan(@RequestBody RkContractReturnPlanPagination rkContractReturnPlanPagination) {
        rkContractReturnPlanPagination.setSearchOverdueDateList(RkContractReturnPlanController.getOverdueDateList(rkContractReturnPlanPagination.getOverdueYears()));
        rkContractReturnPlanPagination.setSearchOverdueDateListMulti(RkContractReturnPlanController.getOverdueDateListMulti(rkContractReturnPlanPagination.getOverdueYearsList()));
        HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
        List zero = CollectionUtil.list((boolean)false, (Object[])new String[]{"", DateUtil.dateFormat((Date)DateUtil.dateAddYears((Date)DateUtil.getDayBegin(), (int)-1))});
        List one = CollectionUtil.list((boolean)false, (Object[])new String[]{DateUtil.dateFormat((Date)DateUtil.dateAddYears((Date)DateUtil.getDayBegin(), (int)-1)), DateUtil.dateFormat((Date)DateUtil.dateAddYears((Date)DateUtil.getDayBegin(), (int)-2))});
        List two = CollectionUtil.list((boolean)false, (Object[])new String[]{DateUtil.dateFormat((Date)DateUtil.dateAddYears((Date)DateUtil.getDayBegin(), (int)-2)), DateUtil.dateFormat((Date)DateUtil.dateAddYears((Date)DateUtil.getDayBegin(), (int)-3))});
        List three = CollectionUtil.list((boolean)false, (Object[])new String[]{DateUtil.dateFormat((Date)DateUtil.dateAddYears((Date)DateUtil.getDayBegin(), (int)-3)), DateUtil.dateFormat((Date)DateUtil.dateAddYears((Date)DateUtil.getDayBegin(), (int)-4))});
        List four = CollectionUtil.list((boolean)false, (Object[])new String[]{DateUtil.dateFormat((Date)DateUtil.dateAddYears((Date)DateUtil.getDayBegin(), (int)-4)), DateUtil.dateFormat((Date)DateUtil.dateAddYears((Date)DateUtil.getDayBegin(), (int)-5))});
        List five = CollectionUtil.list((boolean)false, (Object[])new String[]{DateUtil.dateFormat((Date)DateUtil.dateAddYears((Date)DateUtil.getDayBegin(), (int)-5)), ""});
        Map<String, Object> overdueMap = this.rkContractReturnPlanService.countOverdueAmountByContractIdListOrPlan(rkContractReturnPlanPagination);
        Map<String, Object> receivableAmount = this.rkContractReturnPlanService.countReceivableAmountByContractIdListOrPlan(rkContractReturnPlanPagination);
        Map<String, Object> amountOfDueReceivables = this.rkContractReturnPlanService.countAmountOfDueReceivablesByContractIdListOrPlan(rkContractReturnPlanPagination);
        rkContractReturnPlanPagination.setOverdueDateList(zero);
        rkContractReturnPlanPagination.setKey("zeroOverdue");
        Map<String, Object> zeroOverdueMap = this.rkContractReturnPlanService.countOverdueAmountByContractIdListOrPlan(rkContractReturnPlanPagination);
        rkContractReturnPlanPagination.setOverdueDateList(one);
        rkContractReturnPlanPagination.setKey("oneOverdue");
        Map<String, Object> oneOverdueMap = this.rkContractReturnPlanService.countOverdueAmountByContractIdListOrPlan(rkContractReturnPlanPagination);
        rkContractReturnPlanPagination.setOverdueDateList(two);
        rkContractReturnPlanPagination.setKey("twoOverdue");
        Map<String, Object> twoOverdueMap = this.rkContractReturnPlanService.countOverdueAmountByContractIdListOrPlan(rkContractReturnPlanPagination);
        rkContractReturnPlanPagination.setOverdueDateList(three);
        rkContractReturnPlanPagination.setKey("threeOverdue");
        Map<String, Object> threeOverdueMap = this.rkContractReturnPlanService.countOverdueAmountByContractIdListOrPlan(rkContractReturnPlanPagination);
        rkContractReturnPlanPagination.setOverdueDateList(four);
        rkContractReturnPlanPagination.setKey("fourOverdue");
        Map<String, Object> fourOverdueMap = this.rkContractReturnPlanService.countOverdueAmountByContractIdListOrPlan(rkContractReturnPlanPagination);
        rkContractReturnPlanPagination.setOverdueDateList(five);
        rkContractReturnPlanPagination.setKey("fiveOverdue");
        Map<String, Object> fiveOverdueMap = this.rkContractReturnPlanService.countOverdueAmountByContractIdListOrPlan(rkContractReturnPlanPagination);
        stringObjectMap.putAll(overdueMap);
        stringObjectMap.putAll(receivableAmount);
        stringObjectMap.putAll(amountOfDueReceivables);
        stringObjectMap.putAll(oneOverdueMap);
        stringObjectMap.putAll(twoOverdueMap);
        stringObjectMap.putAll(threeOverdueMap);
        stringObjectMap.putAll(zeroOverdueMap);
        stringObjectMap.putAll(fourOverdueMap);
        stringObjectMap.putAll(fiveOverdueMap);
        return ActionResult.success(stringObjectMap);
    }

    public static String getDaysText(int days) {
        if (days <= 2) {
            return "2\u5929\u5185";
        }
        if (days <= 5) {
            return "5\u5929\u5185";
        }
        if (days <= 7) {
            return "7\u5929\u5185";
        }
        if (days <= 14) {
            return "14\u5929\u5185";
        }
        if (days <= 30) {
            return "30\u5929\u5185";
        }
        return "\u66f4\u4e45";
    }

    public static List<String> getOverdueDateList(String overdueYears) {
        List overdueDate = CollectionUtil.list((boolean)false);
        if (StrUtil.isNotEmpty((CharSequence)overdueYears)) {
            if (StrUtil.equals((CharSequence)overdueYears, (CharSequence)"6")) {
                overdueDate = CollectionUtil.list((boolean)false, (Object[])new String[]{DateUtil.dateFormat((Date)DateUtil.dateAddYears((Date)DateUtil.getDayBegin(), (int)-5)), ""});
            } else if (StrUtil.equals((CharSequence)overdueYears, (CharSequence)"1")) {
                overdueDate = CollectionUtil.list((boolean)false, (Object[])new String[]{"", DateUtil.dateFormat((Date)DateUtil.dateAddYears((Date)DateUtil.getDayBegin(), (int)-1))});
            } else if (StrUtil.equals((CharSequence)overdueYears, (CharSequence)"0")) {
                overdueDate = CollectionUtil.list((boolean)false, (Object[])new String[]{"", ""});
            } else {
                Integer overdueYear = Integer.parseInt(overdueYears);
                overdueDate = CollectionUtil.list((boolean)false, (Object[])new String[]{DateUtil.dateFormat((Date)DateUtil.dateAddYears((Date)DateUtil.getDayBegin(), (int)(-1 * (overdueYear - 1)))), DateUtil.dateFormat((Date)DateUtil.dateAddYears((Date)DateUtil.getDayBegin(), (int)(-1 * overdueYear)))});
            }
        }
        return overdueDate;
    }

    public static List<List<String>> getOverdueDateListMulti(List<String> overdueYearsList) {
        List overdueDate = CollectionUtil.list((boolean)false);
        if (CollectionUtil.isNotEmpty(overdueYearsList)) {
            for (String overdueYear : overdueYearsList) {
                overdueDate.add(RkContractReturnPlanController.getOverdueDateList(overdueYear));
            }
        }
        return overdueDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping
    @DSTransactional
    @RepeatSubmit
    public ActionResult create(@RequestBody @Valid RkContractReturnPlanCrForm rkContractReturnPlanCrForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            rkContractReturnPlanCrForm.setCompanyId(userInfo.getOrganizeId());
            String billNumber = this.baseDataUtil.getBillNumber(userInfo.getOrganizeId() + "PlanCode", Boolean.valueOf(false));
            rkContractReturnPlanCrForm.setPlanCode(billNumber);
            HashMap map = this.rkContractReturnPlanService.createPlan(rkContractReturnPlanCrForm);
            if (ObjectUtil.isEmpty(map.get("error"))) {
                return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
            }
            return ActionResult.fail((String)map.get("error").toString());
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractReturnPlanInfoVO> info(@PathVariable(value="id") String id) {
        RkContractReturnPlanEntity entity = this.rkContractReturnPlanService.getInfo(id);
        RkContractReturnPlanInfoVO vo = (RkContractReturnPlanInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractReturnPlanInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/{ids}"})
    public ActionResult getSelectPlanList(@PathVariable(value="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List planList = CollectionUtil.list((boolean)false);
        idList.stream().forEach(id -> {
            RkContractReturnPlanEntity byId = (RkContractReturnPlanEntity)this.rkContractReturnPlanService.getById((Serializable)((Object)id));
            if (ObjectUtil.isNotEmpty((Object)byId)) {
                planList.add(byId);
            }
        });
        List listVO = JsonUtil.getJsonToList((Object)planList, RkContractReturnPlanListVO.class);
        for (RkContractReturnPlanListVO vo : listVO) {
            RkContractProjectEntity projectInfo = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)vo.getProjectId()));
            if (ObjectUtil.isNotNull((Object)projectInfo)) {
                vo.setProjectName(projectInfo.getProjectName());
                vo.setProjectCode(projectInfo.getProjectCode());
                vo.setProjectAmount(projectInfo.getProjectAmount());
                vo.setProjectInvoiceAmount(projectInfo.getInvoiceAmount());
            }
            if (ObjectUtil.isEmpty((Object)vo.getInvoiceAmount())) {
                vo.setInvoiceAmount(BigDecimal.ZERO);
            }
            if (!ObjectUtil.isEmpty((Object)vo.getRemainingInvoicedAmount())) continue;
            vo.setRemainingInvoicedAmount(BigDecimal.ZERO);
        }
        return ActionResult.success((Object)listVO);
    }

    @GetMapping(value={"/getByProjectId/{projectId}"})
    public ActionResult getByProjectId(@PathVariable(value="projectId") String projectId) {
        List<RkContractReturnPlanEntity> planByProjectId = this.rkContractReturnPlanService.getPlanByProjectId(projectId);
        RkContractProjectEntity projectInfo = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)projectId));
        List listVO = JsonUtil.getJsonToList(planByProjectId, RkContractReturnPlanListVO.class);
        for (RkContractReturnPlanListVO vo : listVO) {
            if (ObjectUtil.isNotNull((Object)projectInfo)) {
                vo.setProjectName(projectInfo.getProjectName());
                vo.setProjectCode(projectInfo.getProjectCode());
                vo.setProjectAmount(projectInfo.getProjectAmount());
                vo.setProjectInvoiceAmount(projectInfo.getInvoiceAmount());
                vo.setProjectAcceptanceTime(projectInfo.getAcceptanceTime());
            }
            if (ObjectUtil.isEmpty((Object)vo.getInvoiceAmount())) {
                vo.setInvoiceAmount(BigDecimal.ZERO);
            }
            if (!ObjectUtil.isEmpty((Object)vo.getRemainingInvoicedAmount())) continue;
            vo.setRemainingInvoicedAmount(vo.getReceivableAmount());
        }
        return ActionResult.success((Object)listVO);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractReturnPlanInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkContractReturnPlanEntity entity = this.rkContractReturnPlanService.getInfo(id);
        RkContractReturnPlanInfoVO vo = (RkContractReturnPlanInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractReturnPlanInfoVO.class);
        vo.setPaymentType(this.baseDataUtil.getDictName(vo.getPaymentType(), Constants.RETURN_PLAN_PAYMENT_TYPE_DICT_ID));
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PutMapping(value={"/{id}"})
    @DSTransactional
    @RepeatSubmit
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkContractReturnPlanUpForm rkContractReturnPlanUpForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            UserInfo userInfo = this.userProvider.get();
            RkContractReturnPlanEntity entity = this.rkContractReturnPlanService.getInfo(id);
            if (entity != null) {
                RkContractReturnPlanEntity subentity = (RkContractReturnPlanEntity)JsonUtil.getJsonToBean((Object)rkContractReturnPlanUpForm, RkContractReturnPlanEntity.class);
                this.rkContractReturnPlanService.update(id, subentity);
                return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            RkContractReturnPlanEntity entity = this.rkContractReturnPlanService.getInfo(id);
            if (entity != null) {
                this.rkContractReturnPlanService.delete(entity);
            }
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
    }

    @GetMapping(value={"/getPlanByContractId/{contractId}"})
    public ActionResult getPlanByContractId(@PathVariable(value="contractId") String contractId, String projectId) throws ParseException {
        List<RkContractReturnPlanEntity> planByContractId = CollectionUtil.list((boolean)false);
        planByContractId = StrUtil.isNotEmpty((CharSequence)projectId) ? this.rkContractReturnPlanService.getPlanByContractIdAndProjectId(contractId, projectId) : this.rkContractReturnPlanService.getPlanByContractId(contractId);
        if (CollectionUtil.isEmpty(planByContractId)) {
            planByContractId = this.rkContractReturnPlanService.getPlanByContractIdAndProjectIdIsNull(contractId);
        }
        RkContractEntity byId = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)contractId));
        List jsonToList = JsonUtil.getJsonToList(planByContractId, RkContractReturnPlanCrForm.class);
        for (int i = 0; i < jsonToList.size(); ++i) {
            RkContractProjectEntity projectEntity;
            RkContractReturnPlanCrForm planCrForm = (RkContractReturnPlanCrForm)jsonToList.get(i);
            planCrForm.setPaymentTypeDesc(this.baseDataUtil.getDictName(planCrForm.getPaymentType(), Constants.RETURN_PLAN_PAYMENT_TYPE_DICT_ID));
            DictionaryDataEntity dataEntity = (DictionaryDataEntity)this.dictionaryDataService.getById((Serializable)((Object)planCrForm.getPaymentType()));
            if (ObjectUtil.isNotNull((Object)dataEntity)) {
                planCrForm.setPaymentTypeEnCode(dataEntity.getEnCode());
            }
            if (StrUtil.isNotEmpty((CharSequence)planCrForm.getProjectId()) && ObjectUtil.isNotNull((Object)(projectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)planCrForm.getProjectId()))))) {
                planCrForm.setProjectName(projectEntity.getProjectName());
                planCrForm.setProjectCode(projectEntity.getProjectCode());
            }
            planCrForm.setNotReturnTypeDesc(this.baseDataUtil.getDictName(planCrForm.getNotReturnType(), Constants.NOTRETURNTYPE_DICT_ID));
            planCrForm.setContractName(byId.getContractName());
            planCrForm.setContractCode(byId.getContractCode());
            planCrForm.setContractAmount(byId.getContractAmount() + "");
            planCrForm.setCustomerName(ObjectUtil.isEmpty((Object)byId.getCustomerId()) ? "" : ((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)byId.getCustomerId()))).getName());
            if (!ObjectUtil.isEmpty((Object)byId.getIsAgent()) && byId.getIsAgent() == 1) {
                planCrForm.setAgentId(ObjectUtil.isEmpty((Object)byId.getAgentId()) ? "" : ((RkAgentEntity)this.agentService.getById((Serializable)((Object)byId.getAgentId()))).getName());
            } else {
                planCrForm.setAgentId(planCrForm.getCustomerName());
            }
            planCrForm.setPlanNum("\u7b2c" + (i + 1) + "\u671f(\u5171" + jsonToList.size() + "\u671f)");
            planCrForm.setOverdueDays(0L);
            if (!ObjectUtil.notEqual((Object)planCrForm.getReturnState(), (Object)ReturnPlanEnum.END.getState())) continue;
            Long checkDate = planCrForm.getActualDueDate();
            if (!StrUtil.equals((CharSequence)planCrForm.getCompanyId(), (CharSequence)CompanyIdEnum.MiJIAN.getId())) {
                checkDate = planCrForm.getDueDate();
            }
            Map<String, ReturnPlanOverdueDayEnum> allToMap = ReturnPlanOverdueDayEnum.getAllToMap();
            ReturnPlanOverdueDayEnum dayEnum = allToMap.get(planCrForm.getCompanyId());
            long overdueDay = 0L;
            if (ObjectUtil.isNotNull((Object)((Object)dayEnum))) {
                overdueDay = dayEnum.getOverdueDay();
            }
            if (ObjectUtil.isEmpty((Object)checkDate)) continue;
            Date date = DateUtil.longToDate((long)(checkDate / 1000L));
            long l = (long)DateUtil.getDiffDays((Date)DateUtil.getDayBegin(), (Date)date) + overdueDay;
            if (DateUtil.getDiffDays((Date)DateUtil.getDayBegin(), (Date)date) < 0) {
                planCrForm.setOverdueDays((l - overdueDay) * -1L);
            }
            if (l >= 0L) continue;
            planCrForm.setOverdueDays(l * -1L);
            planCrForm.setArrearsAmount(MathUtils.toBigDecimal(MathUtils.substract(planCrForm.getReceivableAmount(), planCrForm.getReturnAmount().toString())));
        }
        return ActionResult.success((Object)jsonToList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/updatePlan"})
    public ActionResult updatePlan(@RequestBody @Valid List<RkContractReturnPlanUpForm> list) {
        Object object = this.$lock;
        synchronized (object) {
            if (CollectionUtil.isEmpty(list)) {
                return ActionResult.success((String)"\u65e0\u56de\u6b3e\u8ba1\u5212");
            }
            HashMap map = this.rkContractReturnPlanService.updatePlan(list);
            if (ObjectUtil.isEmpty(map.get("error"))) {
                return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ActionResult.fail((String)map.get("error").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/deleteBatch"})
    public ActionResult deleteBatch(@RequestBody List<String> idList) {
        Object object = this.$lock;
        synchronized (object) {
            HashMap map = this.rkContractReturnPlanService.deleteBatch(idList);
            if (ObjectUtil.isEmpty(map.get("error"))) {
                return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
            }
            return ActionResult.fail((String)map.get("error").toString());
        }
    }

    private List<RkContractReturnPlanListVO> dealReturnPlanList(List<RkContractReturnPlanEntity> list, boolean isExport) {
        List arrearsYear = this.dictionaryDataService.getList("arrearsYear");
        Map<String, String> collect = arrearsYear.stream().collect(Collectors.toMap(DictionaryDataEntity::getEnCode, DictionaryDataEntity::getFullName));
        List listVO = JsonUtil.getJsonToList(list, RkContractReturnPlanListVO.class);
        for (RkContractReturnPlanListVO rkContractReturnPlanVO : listVO) {
            rkContractReturnPlanVO.setSalerCompanyName(this.afterSalesRoleUtils.getCompanyShortName(rkContractReturnPlanVO.getSalerCompanyId()));
            rkContractReturnPlanVO.setPaymentTypeId(rkContractReturnPlanVO.getPaymentType());
            rkContractReturnPlanVO.setPaymentType(this.baseDataUtil.getDictName(rkContractReturnPlanVO.getPaymentType(), Constants.RETURN_PLAN_PAYMENT_TYPE_DICT_ID));
            RkContractEntity contractEntity = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)rkContractReturnPlanVO.getContractId()));
            rkContractReturnPlanVO.setCustomerName(((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)rkContractReturnPlanVO.getCustomerId()))).getName());
            rkContractReturnPlanVO.setCustomerNames(this.saleContractCustomerService.getCustomerNamesByContractId(contractEntity.getId()));
            rkContractReturnPlanVO.setContractName(ObjectUtil.isEmpty((Object)contractEntity) ? "" : contractEntity.getContractName());
            rkContractReturnPlanVO.setContractReturnRate(ObjectUtil.isEmpty((Object)contractEntity) ? "0.00" : (ObjectUtil.isNull((Object)contractEntity.getReturnRatio()) ? "0.00" : contractEntity.getReturnRatio() + ""));
            rkContractReturnPlanVO.setContractCode(ObjectUtil.isEmpty((Object)contractEntity) ? "" : contractEntity.getContractCode());
            rkContractReturnPlanVO.setContractAmount(ObjectUtil.isEmpty((Object)contractEntity) ? BigDecimal.ZERO : contractEntity.getContractAmount());
            rkContractReturnPlanVO.setContractState(ObjectUtil.isEmpty((Object)contractEntity) ? "" : contractEntity.getEnableMark());
            rkContractReturnPlanVO.setContractType(ObjectUtil.isEmpty((Object)contractEntity) ? "" : this.baseDataUtil.getDictName(contractEntity.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
            rkContractReturnPlanVO.setContractStateDesc(ObjectUtil.isEmpty((Object)contractEntity) ? "" : this.baseDataUtil.getDictName(contractEntity.getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
            rkContractReturnPlanVO.setSignDate(contractEntity.getSignDate());
            rkContractReturnPlanVO.setArchivedTime(contractEntity.getArchivedTime());
            String agentName = "";
            String agentNames = "";
            if (ObjectUtil.isNotNull((Object)contractEntity)) {
                if (StrUtil.equals((CharSequence)contractEntity.getAgentId(), (CharSequence)contractEntity.getCustomerId())) {
                    agentName = rkContractReturnPlanVO.getCustomerName();
                    agentNames = rkContractReturnPlanVO.getCustomerNames();
                } else {
                    RkAgentEntity byId = (RkAgentEntity)this.agentService.getById((Serializable)((Object)rkContractReturnPlanVO.getAgentId()));
                    agentNames = agentName = ObjectUtil.isNull((Object)byId) ? "" : byId.getName();
                }
            }
            rkContractReturnPlanVO.setAgentName(agentName);
            rkContractReturnPlanVO.setAgentNames(agentNames);
            RkContractProjectEntity projectEntity = null;
            if (StrUtil.isNotEmpty((CharSequence)rkContractReturnPlanVO.getProjectId())) {
                projectEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)rkContractReturnPlanVO.getProjectId()));
            }
            if (ObjectUtil.isNotNull(projectEntity)) {
                rkContractReturnPlanVO.setProjectName(projectEntity.getProjectName());
                rkContractReturnPlanVO.setProjectCode(projectEntity.getProjectCode());
                rkContractReturnPlanVO.setProjectAmount(projectEntity.getProjectAmount());
                rkContractReturnPlanVO.setProjectInvoiceAmount(projectEntity.getInvoiceAmount());
                rkContractReturnPlanVO.setProjectAcceptanceTime(projectEntity.getAcceptanceTime());
                rkContractReturnPlanVO.setProjectReturnRate(ObjectUtil.isEmpty((Object)projectEntity.getReceivedRatio()) ? "0.00" : projectEntity.getReceivedRatio() + "");
            }
            if (ObjectUtil.isNotNull((Object)rkContractReturnPlanVO.getFollowTime())) {
                int followDays = DateUtil.getDiffDays((Date)rkContractReturnPlanVO.getFollowTime(), (Date)DateUtil.getDayBegin());
                rkContractReturnPlanVO.setFollowDays(followDays);
                rkContractReturnPlanVO.setFollowDaysDesc(RkContractReturnPlanController.getDaysText(followDays));
            }
            rkContractReturnPlanVO.setReceivableAmountBalance(MathUtils.substract(rkContractReturnPlanVO.getReceivableAmount(), rkContractReturnPlanVO.getReturnAmount()));
            ContractReturnPlanUilts.checkReturnPlanOverdue(rkContractReturnPlanVO, collect);
            if (!isExport) continue;
            this.getReturnPlanFollowRecord(rkContractReturnPlanVO);
        }
        return listVO;
    }

    private RkContractReturnPlanListVO getReturnPlanFollowRecord(RkContractReturnPlanListVO rkContractReturnPlanVO) {
        String planId = rkContractReturnPlanVO.getId();
        List<RkReturnPlanFollowEntity> listByPlanId = this.rkReturnPlanFollowService.getListByPlanId(planId);
        List filteredList = listByPlanId.stream().filter(entity -> entity.getCommunication() != null && entity.getCreatorTime() != null).sorted(Comparator.comparing(RkReturnPlanFollowEntity::getCreatorTime)).collect(Collectors.toList());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder sb = new StringBuilder();
        StringBuilder salesSb = new StringBuilder();
        StringBuilder salesDirectorSb = new StringBuilder();
        StringBuilder deliverySb = new StringBuilder();
        StringBuilder officeSb = new StringBuilder();
        StringBuilder legalSb = new StringBuilder();
        for (RkReturnPlanFollowEntity entity2 : filteredList) {
            sb.append("[").append(sdf.format(entity2.getCreatorTime())).append("] ").append(entity2.getCommunication()).append("\n");
            if (StrUtil.equals((CharSequence)entity2.getFeedBackSource(), (CharSequence)"salesFeedback")) {
                salesSb.append("[").append(sdf.format(entity2.getCreatorTime())).append("] ").append(entity2.getCommunication()).append("\n");
            }
            if (StrUtil.equals((CharSequence)entity2.getFeedBackSource(), (CharSequence)"salesDirectorFeedback")) {
                salesDirectorSb.append("[").append(sdf.format(entity2.getCreatorTime())).append("] ").append(entity2.getCommunication()).append("\n");
            }
            if (StrUtil.equals((CharSequence)entity2.getFeedBackSource(), (CharSequence)"salesDelivery")) {
                salesSb.append("[").append(sdf.format(entity2.getCreatorTime())).append("] ").append(entity2.getCommunication()).append("\n");
            }
            if (StrUtil.equals((CharSequence)entity2.getFeedBackSource(), (CharSequence)"officeFeedback")) {
                officeSb.append("[").append(sdf.format(entity2.getCreatorTime())).append("] ").append(entity2.getCommunication()).append("\n");
            }
            if (!StrUtil.equals((CharSequence)entity2.getFeedBackSource(), (CharSequence)"legalFeedback")) continue;
            legalSb.append("[").append(sdf.format(entity2.getCreatorTime())).append("] ").append(entity2.getCommunication()).append("\n");
        }
        rkContractReturnPlanVO.setReturnPlanFollowRecord(sb.toString());
        rkContractReturnPlanVO.setSalesFollowRecord(salesSb.toString());
        rkContractReturnPlanVO.setSalesDirectorFollowRecord(salesDirectorSb.toString());
        rkContractReturnPlanVO.setDeliveryFollowRecord(deliverySb.toString());
        rkContractReturnPlanVO.setOfficeFollowRecord(officeSb.toString());
        rkContractReturnPlanVO.setLegalFollowRecord(legalSb.toString());
        return rkContractReturnPlanVO;
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @PostMapping(value={"/Actions/Export"})
    public ActionResult Export(@RequestBody RkContractReturnPlanPaginationExportModel rkContractReturnPlanPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkContractReturnPlanPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkContractReturnPlanPagination rkContractReturnPlanPagination = (RkContractReturnPlanPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractReturnPlanPaginationExportModel), RkContractReturnPlanPagination.class));
        rkContractReturnPlanPagination.setSearchOverdueDateList(RkContractReturnPlanController.getOverdueDateList(rkContractReturnPlanPagination.getOverdueYears()));
        rkContractReturnPlanPagination.setSearchOverdueDateListMulti(RkContractReturnPlanController.getOverdueDateListMulti(rkContractReturnPlanPagination.getOverdueDateList()));
        List<RkContractReturnPlanEntity> list = this.rkContractReturnPlanService.getTypeList(rkContractReturnPlanPagination, rkContractReturnPlanPaginationExportModel.getDataType());
        List<RkContractReturnPlanListVO> listVO = this.dealReturnPlanList(list, true);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd"));
        for (Map map : mapList) {
            Object isImplementHelp;
            Object followDaysDesc;
            Object returnState;
            Object isAgreement;
            Object isReceive = map.get("isReceive");
            if (ObjectUtil.isNotEmpty(isReceive)) {
                if (ObjectUtil.equals(isReceive, (Object)1)) {
                    map.put("isReceive", "\u80fd");
                }
                if (ObjectUtil.equals(isReceive, (Object)0)) {
                    map.put("isReceive", "\u5426");
                }
                if (ObjectUtil.equals(isReceive, (Object)-1)) {
                    map.put("isReceive", "\u672a\u786e\u5b9a");
                }
            }
            if (ObjectUtil.isNotEmpty(isAgreement = map.get("isAgreement"))) {
                if (ObjectUtil.equals(isAgreement, (Object)1)) {
                    map.put("isAgreement", "\u80fd");
                }
                if (ObjectUtil.equals(isAgreement, (Object)0)) {
                    map.put("isAgreement", "\u5426");
                }
                if (ObjectUtil.equals(isAgreement, (Object)-1)) {
                    map.put("isAgreement", "\u672a\u786e\u5b9a");
                }
            }
            if (ObjectUtil.isNotEmpty(returnState = map.get("returnState"))) {
                if (ObjectUtil.equals(returnState, (Object)1)) {
                    map.put("returnState", "\u90e8\u5206\u5b8c\u6210");
                }
                if (ObjectUtil.equals(returnState, (Object)0)) {
                    map.put("returnState", "\u672a\u5b8c\u6210");
                }
                if (ObjectUtil.equals(returnState, (Object)2)) {
                    map.put("returnState", "\u5df2\u5b8c\u6210");
                }
            }
            if (ObjectUtil.isNull(followDaysDesc = map.get("followDaysDesc"))) {
                map.put("followDaysDesc", "\u65e0");
            }
            if (ObjectUtil.isNull(isImplementHelp = map.get("isImplementHelp"))) {
                map.put("isImplementHelp", "\u5426");
                continue;
            }
            if (ObjectUtil.equals(isImplementHelp, (Object)"1")) {
                map.put("isImplementHelp", "\u662f");
                continue;
            }
            map.put("isImplementHelp", "\u5426");
        }
        String[] keys = !StringUtil.isEmpty((String)rkContractReturnPlanPaginationExportModel.getSelectKey()) ? rkContractReturnPlanPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo, "");
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo, String type) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block116: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "planCode": {
                        entitys.add(new ExcelExportEntity("PN\u7f16\u53f7", (Object)"planCode"));
                        continue block116;
                    }
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block116;
                    }
                    case "followDaysDesc": {
                        entitys.add(new ExcelExportEntity("\u6700\u8fd1\u6c9f\u901a", (Object)"followDaysDesc"));
                        continue block116;
                    }
                    case "followNum": {
                        entitys.add(new ExcelExportEntity("\u6c9f\u901a\u6b21\u6570", (Object)"followNum"));
                        continue block116;
                    }
                    case "overdueDaysYearDesc": {
                        entitys.add(new ExcelExportEntity("\u903e\u671f\u8d26\u9f84", (Object)"overdueDaysYearDesc"));
                        continue block116;
                    }
                    case "returnState": {
                        entitys.add(new ExcelExportEntity("\u56de\u6b3e\u62a5\u544a", (Object)"returnState"));
                        continue block116;
                    }
                    case "contractReturnRate": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u56de\u6b3e\u6bd4\u4f8b", (Object)"contractReturnRate"));
                        continue block116;
                    }
                    case "projectReturnRate": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u56de\u6b3e\u6bd4\u4f8b", (Object)"projectReturnRate"));
                        continue block116;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block116;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block116;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u53f7", (Object)"projectCode"));
                        continue block116;
                    }
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName"));
                        continue block116;
                    }
                    case "customerProvName": {
                        entitys.add(new ExcelExportEntity("\u7701\u4efd", (Object)"customerProvName"));
                        continue block116;
                    }
                    case "signDate": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u65e5\u671f", (Object)"signDate"));
                        continue block116;
                    }
                    case "archivedTime": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u5f52\u6863\u65e5\u671f", (Object)"archivedTime"));
                        continue block116;
                    }
                    case "contractType": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7c7b\u578b", (Object)"contractType"));
                        continue block116;
                    }
                    case "projectAmount": {
                        ExcelExportEntity contractAmount = new ExcelExportEntity("\u9879\u76ee\u91d1\u989d(\u5143)", (Object)"projectAmount");
                        contractAmount.setType(10);
                        entitys.add(contractAmount);
                        continue block116;
                    }
                    case "projectInvoiceAmount": {
                        ExcelExportEntity contractAmount = new ExcelExportEntity("\u9879\u76ee\u5f00\u7968\u91d1\u989d(\u5143)", (Object)"projectInvoiceAmount");
                        contractAmount.setType(10);
                        entitys.add(contractAmount);
                        continue block116;
                    }
                    case "contractAmount": {
                        ExcelExportEntity contractAmount = new ExcelExportEntity("\u5408\u540c\u603b\u91d1\u989d(\u5143)", (Object)"contractAmount");
                        contractAmount.setType(10);
                        entitys.add(contractAmount);
                        continue block116;
                    }
                    case "receivableAmount": {
                        ExcelExportEntity contractAmount = new ExcelExportEntity("\u5e94\u56de\u6b3e\u91d1\u989d(\u5143)", (Object)"receivableAmount");
                        contractAmount.setType(10);
                        entitys.add(contractAmount);
                        continue block116;
                    }
                    case "receivableAmountBalance": {
                        ExcelExportEntity contractAmount = new ExcelExportEntity("\u5269\u4f59\u5e94\u56de\u6b3e\u91d1\u989d(\u5143)", (Object)"receivableAmountBalance");
                        contractAmount.setType(10);
                        entitys.add(contractAmount);
                        continue block116;
                    }
                    case "dueAccountsReceivableBalance": {
                        ExcelExportEntity contractAmount = new ExcelExportEntity("\u5230\u671f\u5269\u4f59\u5e94\u56de\u6b3e\u91d1\u989d(\u5143)", (Object)"dueAccountsReceivableBalance");
                        contractAmount.setType(10);
                        entitys.add(contractAmount);
                        continue block116;
                    }
                    case "returnAmount": {
                        ExcelExportEntity contractAmount = new ExcelExportEntity("\u5df2\u56de\u6b3e\u91d1\u989d(\u5143)", (Object)"returnAmount");
                        contractAmount.setType(10);
                        entitys.add(contractAmount);
                        continue block116;
                    }
                    case "arrearsAmount": {
                        ExcelExportEntity contractAmount = new ExcelExportEntity("\u903e\u671f\u91d1\u989d(\u5143)", (Object)"arrearsAmount");
                        contractAmount.setType(10);
                        entitys.add(contractAmount);
                        continue block116;
                    }
                    case "invoiceAmount": {
                        ExcelExportEntity contractAmount = new ExcelExportEntity("\u5df2\u5f00\u7968\u91d1\u989d(\u5143)", (Object)"invoiceAmount");
                        contractAmount.setType(10);
                        entitys.add(contractAmount);
                        continue block116;
                    }
                    case "remainingInvoicedAmount": {
                        ExcelExportEntity contractAmount = new ExcelExportEntity("\u672a\u5f00\u7968\u91d1\u989d(\u5143)", (Object)"remainingInvoicedAmount");
                        contractAmount.setType(10);
                        entitys.add(contractAmount);
                        continue block116;
                    }
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u540d\u79f0", (Object)"customerName"));
                        continue block116;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7b7e\u8ba2\u5bf9\u8c61", (Object)"agentName"));
                        continue block116;
                    }
                    case "paymentType": {
                        entitys.add(new ExcelExportEntity("\u56de\u6b3e\u7c7b\u578b", (Object)"paymentType"));
                        continue block116;
                    }
                    case "paymentCondition": {
                        entitys.add(new ExcelExportEntity("\u56de\u6b3e\u6761\u4ef6", (Object)"paymentCondition"));
                        continue block116;
                    }
                    case "returnRate": {
                        entitys.add(new ExcelExportEntity("\u5df2\u56de\u6b3e\u6bd4\u4f8b(%)", (Object)"returnRate"));
                        continue block116;
                    }
                    case "overdueDays": {
                        entitys.add(new ExcelExportEntity("\u903e\u671f\u5929\u6570", (Object)"overdueDays"));
                        continue block116;
                    }
                    case "latestPaymentDate": {
                        entitys.add(new ExcelExportEntity("\u6700\u65b0\u56de\u6b3e\u65e5\u671f", (Object)"latestPaymentDate"));
                        continue block116;
                    }
                    case "projectAcceptanceTime": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u9a8c\u6536\u65e5\u671f", (Object)"projectAcceptanceTime"));
                        continue block116;
                    }
                    case "salerName": {
                        entitys.add(new ExcelExportEntity("\u56de\u6b3e\u8d1f\u8d23\u4eba", (Object)"salerName"));
                        continue block116;
                    }
                    case "dueDate": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u56de\u6b3e\u65e5\u671f", (Object)"dueDate"));
                        continue block116;
                    }
                    case "actualDueDate": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u9645\u5e94\u6536\u65e5\u671f", (Object)"actualDueDate"));
                        continue block116;
                    }
                    case "markName": {
                        entitys.add(new ExcelExportEntity("\u7279\u6b8a\u6807\u8bb0", (Object)"markName"));
                        continue block116;
                    }
                    case "followUserName": {
                        entitys.add(new ExcelExportEntity("\u6700\u65b0\u6c9f\u901a\u4eba", (Object)"followUserName"));
                        continue block116;
                    }
                    case "followTime": {
                        entitys.add(new ExcelExportEntity("\u6700\u65b0\u6c9f\u901a\u65f6\u95f4", (Object)"followTime"));
                        continue block116;
                    }
                    case "communication": {
                        entitys.add(new ExcelExportEntity("\u6700\u65b0\u6c9f\u901a\u5185\u5bb9", (Object)"communication"));
                        continue block116;
                    }
                    case "againDate": {
                        entitys.add(new ExcelExportEntity("\u4e0b\u6b21\u6c9f\u901a\u65e5\u671f", (Object)"againDate"));
                        continue block116;
                    }
                    case "estimatedMonth": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u56de\u6b3e\u6708\u4efd", (Object)"estimatedMonth"));
                        continue block116;
                    }
                    case "isReceive": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u56de\u6b3e", (Object)"isReceive"));
                        continue block116;
                    }
                    case "isAgreement": {
                        entitys.add(new ExcelExportEntity("\u8fd8\u6b3e\u534f\u8bae", (Object)"isAgreement"));
                        continue block116;
                    }
                    case "returnPlanFollowRecord": {
                        entitys.add(new ExcelExportEntity("\u56de\u6b3e\u6c9f\u901a\u8bb0\u5f55", (Object)"returnPlanFollowRecord"));
                        continue block116;
                    }
                    case "salesFollowRecord": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u53cd\u9988", (Object)"salesFollowRecord"));
                        continue block116;
                    }
                    case "salesDirectorFollowRecord": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u603b\u76d1\u53cd\u9988", (Object)"salesDirectorFollowRecord"));
                        continue block116;
                    }
                    case "deliveryFollowRecord": {
                        entitys.add(new ExcelExportEntity("\u4ea4\u4ed8\u53cd\u9988", (Object)"deliveryFollowRecord"));
                        continue block116;
                    }
                    case "officeFollowRecord": {
                        entitys.add(new ExcelExportEntity("\u603b\u7ecf\u529e\u53cd\u9988", (Object)"officeFollowRecord"));
                        continue block116;
                    }
                    case "legalFollowRecord": {
                        entitys.add(new ExcelExportEntity("\u6cd5\u52a1\u53cd\u9988", (Object)"legalFollowRecord"));
                        continue block116;
                    }
                    case "isImplementHelp": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u5b9e\u65bd\u534f\u52a9", (Object)"isImplementHelp"));
                        continue block116;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u56de\u6b3e\u8ddf\u8fdb" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

