/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractSendRecordEntity;
import com.bringspring.contract.model.rkcontractsendrecord.RkContractSendRecordCrForm;
import com.bringspring.contract.model.rkcontractsendrecord.RkContractSendRecordInfoVO;
import com.bringspring.contract.model.rkcontractsendrecord.RkContractSendRecordListVO;
import com.bringspring.contract.model.rkcontractsendrecord.RkContractSendRecordPagination;
import com.bringspring.contract.model.rkcontractsendrecord.RkContractSendRecordUpForm;
import com.bringspring.contract.service.RkContractSendRecordService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u53d1\u8d27\u767b\u8bb0"}, value="contract")
@RequestMapping(value={"/api/contract/RkContractSendRecord"})
public class RkContractSendRecordController {
    private static final Logger log = LoggerFactory.getLogger(RkContractSendRecordController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractSendRecordService rkContractSendRecordService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkContractSendRecordPagination rkContractSendRecordPagination) throws IOException {
        List<RkContractSendRecordEntity> list = this.rkContractSendRecordService.getList(rkContractSendRecordPagination);
        for (RkContractSendRecordEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, RkContractSendRecordListVO.class);
        for (RkContractSendRecordListVO rkContractSendRecordListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractSendRecordPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkContractSendRecordCrForm rkContractSendRecordCrForm) throws DataException {
        HashMap map = this.rkContractSendRecordService.createSend(rkContractSendRecordCrForm);
        if (ObjectUtil.isEmpty(map.get("error"))) {
            return ActionResult.success((String)"\u767b\u8bb0\u6210\u529f");
        }
        return ActionResult.fail((String)map.get("error").toString());
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractSendRecordInfoVO> info(@PathVariable(value="id") String id) {
        RkContractSendRecordEntity entity = this.rkContractSendRecordService.getInfo(id);
        RkContractSendRecordInfoVO vo = (RkContractSendRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractSendRecordInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractSendRecordInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkContractSendRecordEntity entity = this.rkContractSendRecordService.getInfo(id);
        RkContractSendRecordInfoVO vo = (RkContractSendRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractSendRecordInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkContractSendRecordUpForm rkContractSendRecordUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkContractSendRecordEntity entity = this.rkContractSendRecordService.getInfo(id);
        if (entity != null) {
            RkContractSendRecordEntity subentity = (RkContractSendRecordEntity)JsonUtil.getJsonToBean((Object)rkContractSendRecordUpForm, RkContractSendRecordEntity.class);
            this.rkContractSendRecordService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkContractSendRecordEntity entity = this.rkContractSendRecordService.getInfo(id);
        if (entity != null) {
            this.rkContractSendRecordService.deleteSendRecord(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/getListByContractId/{contractId}"})
    public ActionResult getListByContractId(@PathVariable(value="contractId") String contractId) {
        List<RkContractSendRecordEntity> list = this.rkContractSendRecordService.getListByContractId(contractId);
        List listVO = JsonUtil.getJsonToList(list, RkContractSendRecordListVO.class);
        for (RkContractSendRecordListVO rkContractSendRecordVO : listVO) {
            rkContractSendRecordVO.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(rkContractSendRecordVO.getCreatorUserId()));
        }
        return ActionResult.success((Object)listVO);
    }
}

