/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractSettlementRecordEntity;
import com.bringspring.contract.model.rkcontractsettlementrecord.RkContractSettlementRecordCrForm;
import com.bringspring.contract.model.rkcontractsettlementrecord.RkContractSettlementRecordInfoVO;
import com.bringspring.contract.model.rkcontractsettlementrecord.RkContractSettlementRecordListVO;
import com.bringspring.contract.model.rkcontractsettlementrecord.RkContractSettlementRecordPagination;
import com.bringspring.contract.model.rkcontractsettlementrecord.RkContractSettlementRecordUpForm;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractSettlementRecordService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u667a\u533b\u7ed3\u7b97\u6bd4\u4f8b\u8c03\u6574\u8bb0\u5f55"}, value="contract")
@RequestMapping(value={"/api/contract/RkContractSettlementRecord"})
public class RkContractSettlementRecordController {
    private static final Logger log = LoggerFactory.getLogger(RkContractSettlementRecordController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractSettlementRecordService rkContractSettlementRecordService;
    @Autowired
    private RkContractService rkContractService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkContractSettlementRecordPagination rkContractSettlementRecordPagination) throws IOException {
        List<RkContractSettlementRecordEntity> contractList = this.rkContractSettlementRecordService.getListByContractId(rkContractSettlementRecordPagination.getContractId());
        List listVO = JsonUtil.getJsonToList(contractList, RkContractSettlementRecordListVO.class);
        for (RkContractSettlementRecordListVO vo : listVO) {
            RkContractEntity contractEntity = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)vo.getContractId()));
            if (!ObjectUtil.isNotEmpty((Object)contractEntity)) continue;
            vo.setContractCode(contractEntity.getContractCode());
            vo.setContractAmount(contractEntity.getContractAmount());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractSettlementRecordPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid RkContractSettlementRecordCrForm rkContractSettlementRecordCrForm) throws DataException {
        this.rkContractSettlementRecordService.create(rkContractSettlementRecordCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractSettlementRecordInfoVO> info(@PathVariable(value="id") String id) {
        RkContractSettlementRecordEntity entity = this.rkContractSettlementRecordService.getInfo(id);
        RkContractSettlementRecordInfoVO vo = (RkContractSettlementRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractSettlementRecordInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractSettlementRecordInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkContractSettlementRecordEntity entity = this.rkContractSettlementRecordService.getInfo(id);
        RkContractSettlementRecordInfoVO vo = (RkContractSettlementRecordInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractSettlementRecordInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkContractSettlementRecordUpForm rkContractSettlementRecordUpForm) throws DataException {
        this.rkContractSettlementRecordService.update(id, rkContractSettlementRecordUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkContractSettlementRecordEntity entity = this.rkContractSettlementRecordService.getInfo(id);
        if (entity != null) {
            this.rkContractSettlementRecordService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

