/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractPaymentEntity;
import com.bringspring.contract.entity.RkContractProductEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.entity.RkContractTaxEntity;
import com.bringspring.contract.entity.RkContractVerifyEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.model.rkContractVerify.RkContractVerifyCrForm;
import com.bringspring.contract.model.rkContractVerify.RkContractVerifyInfoVO;
import com.bringspring.contract.model.rkContractVerify.RkContractVerifyListVO;
import com.bringspring.contract.model.rkContractVerify.RkContractVerifyPagination;
import com.bringspring.contract.model.rkContractVerify.RkContractVerifyPaginationExportModel;
import com.bringspring.contract.model.rkContractVerify.RkContractVerifyUpForm;
import com.bringspring.contract.model.rkContractVerifyFileResponse.RkContractVerifyFileResponseUpForm;
import com.bringspring.contract.model.rkattachment.RkAttachmentCrForm;
import com.bringspring.contract.model.rkcontract.RkContractPaymentVO;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentListVO;
import com.bringspring.contract.model.rkcontractprocure.OaContractInternalTransactionInfo;
import com.bringspring.contract.model.rkcontractproduct.RkContractProductCrForm;
import com.bringspring.contract.model.rkcontracttax.RkContractTaxInfoVO;
import com.bringspring.contract.service.OaContractCustomerService;
import com.bringspring.contract.service.OaContractInternalCrmService;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractCollectionRecordService;
import com.bringspring.contract.service.RkContractInvoiceService;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProductService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractTaxService;
import com.bringspring.contract.service.RkContractVerifyService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.contract.utils.ReturnPlanEnum;
import com.bringspring.contract.utils.RoleUtils;
import com.bringspring.crm.controller.CrmFileController;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.util.CrmReminderEnum;
import com.bringspring.purchase.entity.OaContractPurchasePlanEntity;
import com.bringspring.purchase.entity.OaPurchasePlanEntity;
import com.bringspring.purchase.service.OaContractPurchasePlanService;
import com.bringspring.purchase.service.OaPurchasePlanService;
import com.bringspring.quotation.entity.SaleQuotationEntity;
import com.bringspring.quotation.entity.SaleQuotationProfitEntity;
import com.bringspring.quotation.service.SaleQuotationProfitService;
import com.bringspring.quotation.service.SaleQuotationService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.organize.OrganizeCrModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.BillCustomizeUtils;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorEntity;
import com.bringspring.workflow.engine.service.FlowTaskNodeService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5408\u540c\u5ba1\u6279"}, value="contractApproval")
@RequestMapping(value={"/api/contract/RkContractVerify"})
public class RkContractVerifyController {
    private static final Logger log = LoggerFactory.getLogger(RkContractVerifyController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractVerifyService rkContractVerifyService;
    @Autowired
    private UserService userService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractCollectionRecordService contractCollectionRecordService;
    @Autowired
    private RkContractInvoiceService contractInvoiceService;
    @Autowired
    private RkContractReturnPlanService contractReturnPlanService;
    @Autowired
    private RoleUtils roleUtils;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkAgentService agentService;
    @Autowired
    private RkContractPaymentService contractPaymentService;
    @Autowired
    private RkContractTaxService contractTaxService;
    @Autowired
    private RkContractProductService contractProductService;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private SaleQuotationService saleQuotationService;
    @Autowired
    private SaleQuotationProfitService saleQuotationProfitService;
    @Autowired
    private SaleNoContractService saleNoContractService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private FlowTaskNodeService flowTaskNodeService;
    @Autowired
    private FlowTaskOperatorService flowTaskOperatorService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private OaContractCustomerService oaContractCustomerService;
    @Autowired
    private OaContractInternalCrmService oaContractInternalCrmService;
    private CrmFileController crmFileController;
    @Autowired
    private OaContractPurchasePlanService oaContractPurchasePlanService;
    @Autowired
    private OaPurchasePlanService oaPurchasePlanService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkContractVerifyPagination rkContractVerifyPagination) throws IOException, WorkFlowException {
        UserInfo userInfo = this.userProvider.get();
        String organizeId = userInfo.getOrganizeId();
        List<List<String>> region = rkContractVerifyPagination.getCustomerRegion();
        if (CollectionUtil.isNotEmpty(region)) {
            List searchRegion = CollectionUtil.list((boolean)false);
            region.stream().forEach(l -> searchRegion.add(l.get(0)));
            rkContractVerifyPagination.setSearchCustomerRegion(searchRegion);
        }
        List<RkContractVerifyEntity> list = this.rkContractVerifyService.getList(rkContractVerifyPagination);
        List<RkContractVerifyListVO> listVO = this.appendListVo(list, false);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractVerifyPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"countAmountByPlan"})
    public ActionResult countAmountByPlan(@RequestBody RkContractVerifyPagination rkContractVerifyPagination) throws WorkFlowException {
        Map<String, Object> stringObjectMap = this.rkContractVerifyService.countAmountByPlan(rkContractVerifyPagination);
        HashMap map = MapUtil.newHashMap();
        map.put("totalAuditAmount", "0");
        List<RkContractVerifyEntity> list = this.rkContractVerifyService.getList(rkContractVerifyPagination);
        List<RkContractVerifyListVO> listVO = this.appendListVo(list, false);
        if (CollectionUtil.isNotEmpty(listVO)) {
            BigDecimal totalAuditAmount = listVO.stream().filter(x -> ObjectUtil.equals((Object)x.getFlowState(), (Object)2)).filter(x -> ObjectUtil.isNotEmpty((Object)x.getContractAmount())).map(RkContractVerifyListVO::getContractAmount).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
            map.put("totalAuditAmount", totalAuditAmount);
        }
        stringObjectMap.putAll(map);
        return ActionResult.success(stringObjectMap);
    }

    private List<RkContractVerifyListVO> appendListVo(List<RkContractVerifyEntity> list, boolean isExport) throws WorkFlowException {
        List listVO = JsonUtil.getJsonToList(list, RkContractVerifyListVO.class);
        RkAgentEntity agent = null;
        for (RkContractVerifyListVO vo : listVO) {
            String s;
            OrganizeEntity byId;
            vo.setContractTaxRate(this.baseDataUtil.getDictName(vo.getContractTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
            vo.setSalerId(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
            vo.setContractTypeName(this.baseDataUtil.getDictName(vo.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
            vo.setFinancialAcceptanceUser(this.baseDataUtil.userSelectValues(vo.getFinancialAcceptanceUser()));
            vo.setSalesSupportUser(this.baseDataUtil.userSelectValues(vo.getSalesSupportUser()));
            vo.setOpportunityAssistanceUser(this.baseDataUtil.userSelectValues(vo.getOpportunityAssistanceUser()));
            vo.setProposalProducer(this.baseDataUtil.userSelectValues(vo.getProposalProducer()));
            vo.setAssistingUser(this.baseDataUtil.userSelectValues(vo.getAssistingUser()));
            vo.setRegion(vo.getRegionName());
            vo.setIsNeedPayAdvance(vo.getIsNeedPayAdvance());
            vo.setIsStamp(vo.getIsStamp());
            vo.setCustomerRegion(vo.getCustomerRegionName());
            vo.setDepartment(vo.getDepartmentTreeName());
            vo.setIncomeType(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
            vo.setIndustryType(this.baseDataUtil.getDictName(vo.getIndustryType(), "industryType"));
            vo.setMasterId(ObjectUtil.isEmpty((Object)vo.getMasterId()) ? "" : ((RkContractEntity)this.rkContractService.getById((Serializable)((Object)vo.getMasterId()))).getContractName());
            if (StringUtils.isNotEmpty((String)vo.getCompanyId())) {
                vo.setCompanyName(this.organizeService.getInfo(vo.getCompanyId()).getShortName());
            }
            if (StrUtil.isNotEmpty((CharSequence)vo.getSalerCompanyId()) && !StrUtil.equals((CharSequence)vo.getSalerCompanyId(), (CharSequence)vo.getCompanyId()) && ObjectUtil.isNotNull((Object)(byId = this.organizeService.getInfo(vo.getSalerCompanyId())))) {
                OrganizeCrModel jsonToBean = (OrganizeCrModel)JsonUtil.getJsonToBean((String)byId.getPropertyJson(), OrganizeCrModel.class);
                vo.setSalerCompanyName(jsonToBean.getShortName());
            }
            if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
                vo.setCustomerNames(this.oaContractCustomerService.getCustomerNamesByContractId(vo.getId()));
                vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
            }
            if ("1".equals(vo.getIsAgent())) {
                if (StringUtils.isNotEmpty((String)vo.getAgentId()) && null != (agent = this.agentService.getInfo(vo.getAgentId()))) {
                    vo.setAgentName(agent.getName());
                    vo.setAgentType(this.baseDataUtil.getDictName(agent.getType(), "agentType"));
                }
            } else {
                vo.setAgentName(vo.getCustomerNames());
            }
            vo.setEnableMarkDesc(this.baseDataUtil.getDictName(vo.getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
            vo.setSpecialTypeName(this.baseDataUtil.getDictName(vo.getSpecialType(), Constants.SPECIAL_TYPE_DICT));
            List<RkContractReturnPlanEntity> planList = this.contractReturnPlanService.getPlanByContractId(vo.getId());
            List collect = planList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getDueDate()) && x.getReturnState() != ReturnPlanEnum.END.getState() && DateUtil.dateToString((Date)DateUtil.getNowDate(), (String)"yyyy-MM-dd").compareTo(DateUtil.dateToString((Date)x.getDueDate(), (String)"yyyy-MM-dd")) > 0).collect(Collectors.toList());
            BigDecimal arrearsAmount = collect.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount().subtract(ObjectUtil.isEmpty((Object)y.getReturnAmount()) ? BigDecimal.ZERO : y.getReturnAmount())), BigDecimal::add);
            vo.setArrearsAmount(arrearsAmount);
            vo.setIsOverdue(CollectionUtil.isNotEmpty(collect) ? 1 : 0);
            vo.setNotReturnAmount(MathUtils.substract(vo.getContractAmount(), vo.getReturnAmount()));
            if (StrUtil.isNotEmpty((CharSequence)vo.getSalesLiaison()) && StrUtil.isNotEmpty((CharSequence)(s = this.baseDataUtil.userSelectValues(vo.getSalesLiaison())))) {
                vo.setSalesLiaisonName(s);
            }
            if (!isExport) {
                FlowTaskEntity flowTaskEntity;
                FlowTaskNodeEntity flowTaskNodeEntity;
                FlowTaskEntity taskEntity = this.flowTaskService.getDraftTaskByProcessId(vo.getId());
                if (ObjectUtil.isNotEmpty((Object)taskEntity) && ObjectUtil.isNotEmpty((Object)(flowTaskNodeEntity = (FlowTaskNodeEntity)this.flowTaskNodeService.getById((Serializable)((Object)taskEntity.getThisStepId()))))) {
                    List operatorList = this.flowTaskOperatorService.getListByNode(taskEntity.getId(), flowTaskNodeEntity.getId());
                    String result = operatorList.stream().map(FlowTaskOperatorEntity::getHandleId).collect(Collectors.joining(","));
                    String userName = this.baseDataUtil.userSelectValues(result);
                    vo.setThisStepPerson(userName);
                }
                if ((flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus})) != null) {
                    vo.setFlowState(flowTaskEntity.getStatus());
                } else {
                    vo.setFlowState(null);
                }
            }
            vo.setIsCrossRegion(this.baseDataUtil.getDictName(vo.getIsCrossRegion(), "whether"));
        }
        return listVO;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractVerifyInfoVO> info(@PathVariable(value="id") String id) {
        List<OaPurchasePlanEntity> detailList;
        Map<String, Object> temp;
        SaleNoContractEntity noContract;
        SaleQuotationProfitEntity profit;
        String userSelectValue;
        SaleQuotationEntity quotation;
        RkAgentEntity agent;
        RkContractVerifyEntity entity = this.rkContractVerifyService.getInfo(id);
        String[] split = entity.getDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",");
        RkContractVerifyInfoVO vo = (RkContractVerifyInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractVerifyInfoVO.class);
        if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
            vo.setCustomerNames(this.oaContractCustomerService.getCustomerNamesByContractId(vo.getId()));
            vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
            vo.setCustomerList(this.oaContractCustomerService.getListByContractId(vo.getId()));
        }
        if ("1".equals(vo.getIsAgent()) && StringUtils.isNotEmpty((String)vo.getAgentId()) && null != (agent = this.agentService.getInfo(vo.getAgentId()))) {
            vo.setAgentName(agent.getName());
        }
        vo.setDepartmentTree(Arrays.asList(split));
        vo.setSalerName(entity.getSalerName());
        vo.setContractLevel(entity.getContractLevel());
        vo.setContractTypeDesc(this.baseDataUtil.getDictName(vo.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
        vo.setIndustryTypeDesc(this.baseDataUtil.getDictName(vo.getIndustryType(), ""));
        vo.setIncomeTypeDesc(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
        vo.setIncomeTypeName(vo.getIncomeTypeDesc());
        vo.setRegionName(entity.getRegionName());
        vo.setDepartmentName(entity.getDepartmentTreeName());
        vo.setIsNeedPayAdvance(entity.getIsNeedPayAdvance());
        vo.setIsStamp(entity.getIsStamp());
        vo.setIsSubcontract(entity.getIsSubcontract());
        vo.setProfitAmount(entity.getProfitAmount());
        if (!ObjectUtil.isEmpty((Object)vo.getIsArchived()) && StrUtil.equals((CharSequence)vo.getIsArchived(), (CharSequence)"1")) {
            vo.setArchivedLocation(this.baseDataUtil.getDictName(vo.getArchivedLocation(), Constants.ARCHIVELOCATION_DICT_ID));
            vo.setArchivedBy(this.baseDataUtil.userSelectValueNoAccount(vo.getArchivedBy()));
        }
        vo.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        List<RkContractPaymentEntity> listByContractId = this.contractPaymentService.getListByContractId(id);
        List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractPaymentListVO.class);
        vo.setPaymentList(jsonToList);
        List<RkContractTaxEntity> rkContractTaxEntities = this.contractTaxService.listByContractId(id);
        List jsonToList1 = JsonUtil.getJsonToList(rkContractTaxEntities, RkContractTaxInfoVO.class);
        vo.setTaxList(jsonToList1);
        List<RkContractReturnPlanEntity> planList = this.contractReturnPlanService.getPlanByContractId(vo.getId());
        if (CollectionUtil.isNotEmpty(planList)) {
            BigDecimal bigDecimal = planList.stream().map(RkContractReturnPlanEntity::getReceivableAmount).reduce(BigDecimal::add).get();
            vo.setPlanTotalAmount(bigDecimal);
        }
        vo.setPlanNum(planList.size());
        List collect = planList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getDueDate()) && x.getReturnState() != ReturnPlanEnum.END.getState() && DateUtil.dateToString((Date)DateUtil.getNowDate(), (String)"yyyy-MM-dd").compareTo(DateUtil.dateToString((Date)x.getDueDate(), (String)"yyyy-MM-dd")) > 0).collect(Collectors.toList());
        BigDecimal arrearsAmount = collect.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount().subtract(ObjectUtil.isEmpty((Object)y.getReturnAmount()) ? BigDecimal.ZERO : y.getReturnAmount())), BigDecimal::add);
        vo.setArrearsAmount(arrearsAmount);
        vo.setIsOverdue(CollectionUtil.isNotEmpty(collect) ? 1 : 0);
        if (StringUtils.isNotEmpty((String)entity.getOpportunityId())) {
            List<String> idList = Arrays.asList(entity.getOpportunityId().split(","));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(RkProjectReportingEntity::getId, idList);
            List reportingList = this.rkProjectReportingService.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)reportingList)) {
                String opportunityName = reportingList.stream().map(RkProjectReportingEntity::getReportingProject).collect(Collectors.joining(","));
                vo.setOpportunityName(opportunityName);
            }
        }
        String quotationPrefix = "";
        if (StringUtils.isNotEmpty((String)entity.getQuotationId()) && null != (quotation = this.saleQuotationService.getInfo(entity.getQuotationId()))) {
            if (StringUtils.isNotEmpty((String)quotation.getSerialNumber())) {
                quotationPrefix = quotation.getSerialNumber();
            } else {
                CrmCustomerEntity customer;
                RkProjectReportingEntity reporting = this.rkProjectReportingService.getInfo(quotation.getOpportunityId());
                if (StringUtils.isNotEmpty((String)reporting.getCustomerId()) && null != (customer = this.crmCustomerService.getInfo(reporting.getCustomerId()))) {
                    quotationPrefix = customer.getName();
                }
            }
            userSelectValue = this.baseDataUtil.userSelectValue(quotation.getQuotationUser());
            String quotationName = quotationPrefix + "-" + userSelectValue;
            vo.setQuotationName(quotationName);
        }
        if (StringUtils.isNotEmpty((String)entity.getQuotationProfitId()) && null != (profit = this.saleQuotationProfitService.getInfo(entity.getQuotationProfitId()))) {
            userSelectValue = this.baseDataUtil.userSelectValue(profit.getSaleId());
            vo.setQuotationProfitName(quotationPrefix + "-" + userSelectValue);
        }
        if (StringUtils.isNotEmpty((String)vo.getNoContractId()) && null != (noContract = this.saleNoContractService.getInfo(vo.getNoContractId()))) {
            vo.setNoContractName(noContract.getContractName());
            vo.setNoContractAssociationId(noContract.getContractId());
        }
        if (StringUtils.isNotEmpty((String)vo.getInternalContractId()) && ObjectUtil.isNotEmpty(temp = this.oaContractInternalCrmService.getInfoById(vo.getInternalContractId()))) {
            OaContractInternalTransactionInfo oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean(temp, OaContractInternalTransactionInfo.class);
            vo.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
            vo.setInternalContractApplyUser(oaContractInternalTransactionInfo.getApplyUserId());
        }
        vo.setPartyBName(this.baseDataUtil.getDictName(vo.getPartyB(), "ContractInternalTransactionSignSubject"));
        List<OaContractPurchasePlanEntity> purchasePlanList = this.oaContractPurchasePlanService.getPlanListByContractId(id);
        if (StrUtil.isNotEmpty((CharSequence)vo.getNoContractId()) && CollectionUtil.isNotEmpty(detailList = this.oaPurchasePlanService.getByNoContractId(vo.getNoContractId()))) {
            purchasePlanList.addAll(JsonUtil.getJsonToList(detailList, OaContractPurchasePlanEntity.class));
        }
        vo.setPurchasePlanList(purchasePlanList);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping
    @RepeatSubmit(interval=10000)
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkContractVerifyCrForm rkContractVerifyCrForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            RkAgentEntity agent;
            List<OaContractPurchasePlanEntity> purchasePlanList;
            Map<String, Object> temp;
            List<RkContractVerifyEntity> listByCode;
            String[] split;
            String flowEngineId = "471650562752905285";
            if (StrUtil.isNotBlank((CharSequence)rkContractVerifyCrForm.getFlowId())) {
                flowEngineId = rkContractVerifyCrForm.getFlowId();
            }
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            String organizeId = userInfo.getOrganizeId();
            if (StrUtil.isNotBlank((CharSequence)rkContractVerifyCrForm.getCompanyId())) {
                organizeId = rkContractVerifyCrForm.getCompanyId();
            }
            rkContractVerifyCrForm.setCompanyId(organizeId);
            if (StrUtil.isNotBlank((CharSequence)rkContractVerifyCrForm.getSalesLiaison())) {
                rkContractVerifyCrForm.setSalesLiaisonName(this.baseDataUtil.userSelectValues(rkContractVerifyCrForm.getSalesLiaison()));
                UserEntity byId = (UserEntity)this.userService.getById((Serializable)((Object)rkContractVerifyCrForm.getSalesLiaison()));
                rkContractVerifyCrForm.setLiaisonDepartment(byId.getOrganizeId());
                rkContractVerifyCrForm.setLiaisonCompany(this.userService.getUserCompany(rkContractVerifyCrForm.getSalesLiaison()));
            }
            OrganizeEntity directlyUnderCompanyById = this.organizeService.getDirectlyUnderCompanyById(rkContractVerifyCrForm.getSalerCompanyId());
            rkContractVerifyCrForm.setSalerPlatFormCompanyId(directlyUnderCompanyById.getParentId());
            rkContractVerifyCrForm.setIsDepartLeader(this.isLeader(rkContractVerifyCrForm.getSalerId()));
            RkContractVerifyEntity entity = (RkContractVerifyEntity)JsonUtil.getJsonToBean((Object)((Object)rkContractVerifyCrForm), RkContractVerifyEntity.class);
            entity.setId(mainId);
            if (!ObjectUtil.isEmpty((Object)entity.getDepartmentTree()) && (split = entity.getDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",")).length > 0) {
                entity.setDepartmentTreeName(this.baseDataUtil.comSelectValues(entity.getDepartmentTree()));
                entity.setDepartmentOne(split[0]);
                entity.setDepartmentOneName(this.baseDataUtil.comSelectValues(entity.getDepartmentOne()));
                entity.setDepartment(split[split.length - 1]);
                entity.setDepartmentName(this.baseDataUtil.comSelectValues(entity.getDepartment()));
            }
            entity.setEnableMark(this.baseDataUtil.getDictName(entity.getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
            if (ObjectUtil.isNotEmpty((Object)entity.getIsStampType())) {
                entity.setStampTypeName(this.baseDataUtil.getDictName(entity.getIsStampType(), Constants.STAMP_TYPE_DICT_ID));
            }
            entity.setContractLevel(this.baseDataUtil.getDictName(entity.getContractLevel(), Constants.CONTRACT_LEVEL_DICT_ID));
            if (StringUtils.isNotEmpty((String)rkContractVerifyCrForm.getCustomerAddress())) {
                split = rkContractVerifyCrForm.getCustomerAddress().replace("\"", "").replace("[", "").replace("]", "").split(",");
                for (int i = 0; i < split.length; ++i) {
                    if (i == 0) {
                        entity.setCustomerRegion(split[0]);
                        entity.setCustomerRegionName(this.baseDataUtil.provinceData(entity.getCustomerRegion()));
                        continue;
                    }
                    if (i == 1) {
                        entity.setCustomerProv(split[1]);
                        entity.setCustomerProvName(this.baseDataUtil.provinceData(entity.getCustomerProv()));
                        continue;
                    }
                    if (i != 2) continue;
                    entity.setCustomerCity(split[2]);
                    entity.setCustomerCityName(this.baseDataUtil.provinceData(entity.getCustomerCity()));
                }
                entity.setCustomerAddressName(this.baseDataUtil.provinceData(rkContractVerifyCrForm.getCustomerAddress()));
            }
            if (StringUtils.isEmpty((String)rkContractVerifyCrForm.getContractCode()) && rkContractVerifyCrForm.getStatus() != 0 && null != rkContractVerifyCrForm.getAutoContractCode() && rkContractVerifyCrForm.getAutoContractCode().booleanValue() && "9".equals(entity.getCompanyId())) {
                entity.setContractCode(BillCustomizeUtils.getMJContractBill());
            }
            if (ObjectUtil.isNotEmpty((Object)rkContractVerifyCrForm.getContractCode()) && CollectionUtil.isNotEmpty(listByCode = this.rkContractVerifyService.getListByCode(rkContractVerifyCrForm.getContractCode())) && listByCode.size() > 1) {
                return ActionResult.fail((String)"\u5408\u540c\u7f16\u53f7\u5df2\u5b58\u5728");
            }
            if (StringUtils.isNotEmpty((String)entity.getCustomerIds())) {
                this.oaContractCustomerService.insertListByCustomerIds(entity.getId(), entity.getCustomerIds());
            }
            if (ObjectUtil.equals((Object)entity.getIsAgent(), (Object)1)) {
                entity.setAgentIds(entity.getAgentId());
            } else {
                entity.setAgentId(entity.getCustomerId());
                entity.setAgentIds(entity.getCustomerIds());
            }
            if (rkContractVerifyCrForm.getStatus() != 0) {
                RkContractEntity contractEntity = new RkContractEntity();
                BeanUtils.copyProperties((Object)entity, (Object)contractEntity);
                if (this.rkContractService.checkContractIsExist(contractEntity)) {
                    throw new DataException("\u5408\u540c\u5df2\u5b58\u5728\uff01");
                }
            }
            this.rkContractVerifyService.save(entity);
            rkContractVerifyCrForm.setDepartmentName(entity.getDepartmentName());
            rkContractVerifyCrForm.setSalerId(entity.getSalerId());
            rkContractVerifyCrForm.setDepartmentOneName(entity.getDepartmentOneName());
            rkContractVerifyCrForm.setStampTypeName(entity.getStampTypeName());
            rkContractVerifyCrForm.setIsStampType(entity.getIsStampType());
            rkContractVerifyCrForm.setIsStamp(entity.getIsStamp());
            rkContractVerifyCrForm.setContractLevel(entity.getContractLevel());
            rkContractVerifyCrForm.setContractAmount(entity.getContractAmount());
            if (CollectionUtil.isNotEmpty(rkContractVerifyCrForm.getTaxList())) {
                List jsonToList = JsonUtil.getJsonToList(rkContractVerifyCrForm.getTaxList(), RkContractTaxEntity.class);
                jsonToList.stream().forEach(tax -> {
                    tax.setContractId(mainId);
                    tax.setId(RandomUtil.uuId());
                });
                this.contractTaxService.saveBatch(jsonToList);
            }
            List<RkContractPaymentVO> paymentList = rkContractVerifyCrForm.getPaymentList();
            List jsonToList = JsonUtil.getJsonToList(paymentList, RkContractPaymentEntity.class);
            jsonToList.stream().forEach(payment -> {
                payment.setContractId(entity.getId());
                payment.setId(RandomUtil.uuId());
                if (!ObjectUtil.isEmpty((Object)entity.getContractAmount()) && !ObjectUtil.isEmpty((Object)payment.getPaymentRatio())) {
                    String multiply = MathUtils.multiply(entity.getContractAmount() + "", payment.getPaymentRatio() + "");
                    String divide = MathUtils.divide(multiply, "100", 2);
                    payment.setReceivableAmount(MathUtils.toBigDecimal(divide));
                }
            });
            this.contractPaymentService.saveBatch(jsonToList);
            List<RkContractProductCrForm> productList = rkContractVerifyCrForm.getProductList();
            productList.stream().forEach(product -> product.setContractId(mainId));
            List productEntityList = JsonUtil.getJsonToList(productList, RkContractProductEntity.class);
            this.contractProductService.saveBatch(productEntityList);
            List<RkAttachmentCrForm> attachmentList = rkContractVerifyCrForm.getAttachmentList();
            attachmentList.stream().forEach(attach -> {
                attach.setContractId(mainId);
                attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
            this.attachmentService.saveBatch(attachmentEntityList);
            if (StringUtils.isNotEmpty((String)rkContractVerifyCrForm.getInternalContractId()) && ObjectUtil.isNotEmpty(temp = this.oaContractInternalCrmService.getInfoById(rkContractVerifyCrForm.getInternalContractId()))) {
                OaContractInternalTransactionInfo oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean(temp, OaContractInternalTransactionInfo.class);
                rkContractVerifyCrForm.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
                rkContractVerifyCrForm.setInternalContractApplyUser(oaContractInternalTransactionInfo.getApplyUserId());
            }
            if (ObjectUtil.isNotEmpty(purchasePlanList = rkContractVerifyCrForm.getPurchasePlanList())) {
                for (OaContractPurchasePlanEntity p : purchasePlanList) {
                    p.setContractId(mainId);
                    if (!StrUtil.isEmpty((CharSequence)p.getNoContractId())) continue;
                    p.setId(RandomUtil.uuId());
                    p.setCompanyId(rkContractVerifyCrForm.getSalerCompanyId());
                    p.setContractCode(rkContractVerifyCrForm.getContractCode());
                    p.setContractName(rkContractVerifyCrForm.getContractName());
                    p.setCustomerId(rkContractVerifyCrForm.getCustomerId());
                    p.setSalerId(rkContractVerifyCrForm.getSalerId());
                    this.oaContractPurchasePlanService.save(p);
                }
            }
            String flowTitle = "";
            if (ObjectUtil.equals((Object)rkContractVerifyCrForm.getIsAgent(), (Object)1) && StringUtils.isNotEmpty((String)rkContractVerifyCrForm.getAgentId()) && null != (agent = this.agentService.getInfo(rkContractVerifyCrForm.getAgentId()))) {
                flowTitle = agent.getName();
            }
            if (StringUtils.isNotEmpty((String)flowTitle)) {
                flowTitle = flowTitle + "-";
            }
            flowTitle = flowTitle + rkContractVerifyCrForm.getContractName();
            FlowUtil.saveOrSubmit((String)rkContractVerifyCrForm.getTaskId(), (String)flowEngineId, (String)rkContractVerifyCrForm.getTemplateId(), (String)mainId, (Object)((Object)rkContractVerifyCrForm), (Integer)rkContractVerifyCrForm.getStatus(), (String)flowTitle);
            if (rkContractVerifyCrForm.getStatus() == 0) {
                return ActionResult.success((String)CrmReminderEnum.TS.getType());
            }
            return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
        }
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkContractVerifyPaginationExportModel rkContractVerifyPaginationExportModel) throws IOException, WorkFlowException {
        if (StringUtil.isEmpty((String)rkContractVerifyPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkContractVerifyPagination rkContractVerifyPagination = (RkContractVerifyPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractVerifyPaginationExportModel), RkContractVerifyPagination.class));
        List<RkContractVerifyEntity> list = this.rkContractVerifyService.getTypeList(rkContractVerifyPagination, rkContractVerifyPaginationExportModel.getDataType());
        List<RkContractVerifyListVO> listVO = this.appendListVo(list, true);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkContractVerifyPaginationExportModel.getSelectKey()) ? rkContractVerifyPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block28: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block28;
                    }
                    case "masterId": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u53f7", (Object)"masterId"));
                        continue block28;
                    }
                    case "contractTypeName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7c7b\u578b", (Object)"contractTypeName"));
                        continue block28;
                    }
                    case "specialTypeName": {
                        entitys.add(new ExcelExportEntity("\u7279\u6b8a\u5408\u540c", (Object)"specialTypeName"));
                        continue block28;
                    }
                    case "contractAmount": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u603b\u91d1\u989d", (Object)"contractAmount"));
                        continue block28;
                    }
                    case "isNeedPayAdvance": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u9700\u8981\u57ab\u8d44", (Object)"isNeedPayAdvance"));
                        continue block28;
                    }
                    case "departmentName": {
                        entitys.add(new ExcelExportEntity("\u90e8\u95e8\u540d\u79f0", (Object)"departmentName"));
                        continue block28;
                    }
                    case "isCrossRegion": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u8de8\u533a\u57df", (Object)"isCrossRegion"));
                        continue block28;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @DeleteMapping(value={"/batchRemove/{ids}"})
    @DSTransactional
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        String[] idList = ids.split(",");
        List<String> allIdList = Arrays.asList(idList);
        ArrayList<String> columnIdList = new ArrayList<String>(20);
        int i = 0;
        for (String allId : allIdList) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)allId, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity == null) {
                columnIdList.add(allId);
                continue;
            }
            if (!taskEntity.getStatus().equals(0)) continue;
            try {
                FlowUtil.deleteByProcessId((String)allId);
                columnIdList.add(allId);
                ++i;
            }
            catch (WorkFlowException e) {
                e.printStackTrace();
            }
        }
        this.rkContractVerifyService.removeByIds(columnIdList);
        if (i == 0 && columnIdList.size() == 0) {
            return ActionResult.fail((String)"\u6d41\u7a0b\u5df2\u53d1\u8d77\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractVerifyInfoVO> detailInfo(@PathVariable(value="id") String id) {
        List<OaPurchasePlanEntity> detailList;
        Map<String, Object> temp;
        SaleNoContractEntity noContract;
        SaleQuotationProfitEntity profit;
        String userSelectValue;
        SaleQuotationEntity quotation;
        String collect1;
        RkContractVerifyEntity entity = this.rkContractVerifyService.getInfo(id);
        RkContractVerifyInfoVO vo = (RkContractVerifyInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractVerifyInfoVO.class);
        vo.setSalerName(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
        vo.setContractTaxRate(this.baseDataUtil.getDictName(vo.getContractTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
        vo.setCostTaxRate(this.baseDataUtil.getDictName(vo.getCostTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
        vo.setContractType(this.baseDataUtil.getDictName(vo.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
        vo.setIsStampType(this.baseDataUtil.getDictName(vo.getIsStampType(), Constants.STAMP_TYPE_DICT_ID));
        vo.setPaymentMethodType(this.baseDataUtil.getDictName(vo.getPaymentMethodType(), Constants.PAYMENT_METHOD_TYPE));
        vo.setIndustryType(this.baseDataUtil.getDictName(vo.getIndustryType(), Constants.INDUSTRY_TYPE));
        vo.setIncomeTypeName(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
        vo.setContractTypeDesc(this.baseDataUtil.getDictName(vo.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
        vo.setContractLevelName(this.baseDataUtil.getDictName(vo.getContractLevel(), Constants.CONTRACT_LEVEL_DICT_ID));
        vo.setFinancialAcceptanceUser(this.baseDataUtil.userSelectValues(vo.getFinancialAcceptanceUser()));
        vo.setSalesSupportUser(this.baseDataUtil.userSelectValues(vo.getSalesSupportUser()));
        vo.setOpportunityAssistanceUser(this.baseDataUtil.userSelectValues(vo.getOpportunityAssistanceUser()));
        vo.setProposalProducer(this.baseDataUtil.userSelectValues(vo.getProposalProducer()));
        vo.setAssistingUser(this.baseDataUtil.userSelectValues(vo.getAssistingUser()));
        if (StringUtils.isEmpty((String)vo.getCustomerAddressName())) {
            vo.setCustomerAddressName(this.baseDataUtil.provinceData(vo.getCustomerAddress()));
        }
        vo.setRegion(this.baseDataUtil.provinceData(vo.getRegion()));
        vo.setDepartment(entity.getDepartmentTreeName());
        if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
            vo.setCustomerNames(this.oaContractCustomerService.getCustomerNamesByContractId(vo.getId()));
            vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
            vo.setCustomerList(this.oaContractCustomerService.getListByContractId(vo.getId()));
        }
        if ("1".equals(vo.getIsAgent())) {
            RkAgentEntity agent;
            if (StringUtils.isNotEmpty((String)vo.getAgentId()) && null != (agent = this.agentService.getInfo(vo.getAgentId()))) {
                vo.setAgentName(agent.getName());
                vo.setAgentType(this.baseDataUtil.getDictName(agent.getType(), "agentType"));
            }
        } else {
            vo.setAgentName(vo.getCustomerNames());
        }
        vo.setMasterId(ObjectUtil.isEmpty((Object)vo.getMasterId()) ? "" : ((RkContractEntity)this.rkContractService.getById((Serializable)((Object)vo.getMasterId()))).getContractName());
        vo.setEnableMarkDesc(this.baseDataUtil.getDictName(vo.getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
        vo.setCustomerRegion(entity.getCustomerRegionName());
        vo.setArchivedByDesc(this.baseDataUtil.userSelectValueNoAccount(vo.getArchivedBy()));
        vo.setArchivedLocationDesc(this.baseDataUtil.getDictName(vo.getArchivedLocation(), ""));
        vo.setPromotionTypeName(this.baseDataUtil.getDictName(vo.getPromotionType(), "promotionType"));
        vo.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        vo.setSignUserName(this.baseDataUtil.userSelectValues(vo.getSignUserId()));
        vo.setInvoiceTypeName(this.baseDataUtil.getDictName(vo.getInvoiceType(), "contractInvoiceType"));
        List<RkContractReturnPlanEntity> planList = this.contractReturnPlanService.getPlanByContractId(vo.getId());
        vo.setPlanNum(planList.size());
        List collect = planList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getDueDate()) && x.getReturnState() != ReturnPlanEnum.END.getState() && DateUtil.dateToString((Date)DateUtil.getNowDate(), (String)"yyyy-MM-dd").compareTo(DateUtil.dateToString((Date)x.getDueDate(), (String)"yyyy-MM-dd")) > 0).collect(Collectors.toList());
        BigDecimal arrearsAmount = collect.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount().subtract(ObjectUtil.isEmpty((Object)y.getReturnAmount()) ? BigDecimal.ZERO : y.getReturnAmount())), BigDecimal::add);
        vo.setArrearsAmount(arrearsAmount);
        List<RkContractPaymentEntity> listByContractId = this.contractPaymentService.getListByContractId(id);
        List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractPaymentListVO.class);
        vo.setPaymentList(jsonToList);
        List<RkContractTaxEntity> rkContractTaxEntities = this.contractTaxService.listByContractId(id);
        List jsonToList1 = JsonUtil.getJsonToList(rkContractTaxEntities, RkContractTaxInfoVO.class);
        vo.setTaxList(jsonToList1);
        if (vo.getIsMoreTax() != null && vo.getIsMoreTax() == 1 && CollectionUtil.isNotEmpty((Collection)jsonToList1)) {
            collect1 = jsonToList1.stream().filter(i -> !i.getTaxType().equals("cost")).map(RkContractTaxInfoVO::getTaxName).collect(Collectors.joining(","));
            vo.setContractTaxRate(collect1);
        }
        if (vo.getCostIsMoreTax() != null && vo.getCostIsMoreTax() == 1 && CollectionUtil.isNotEmpty((Collection)jsonToList1)) {
            collect1 = jsonToList1.stream().filter(i -> i.getTaxType().equals("cost")).map(RkContractTaxInfoVO::getTaxName).collect(Collectors.joining(","));
            vo.setCostTaxRate(collect1);
        }
        if (StringUtils.isNotEmpty((String)entity.getOpportunityId())) {
            List<String> idList = Arrays.asList(entity.getOpportunityId().split(","));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(RkProjectReportingEntity::getId, idList);
            List reportingList = this.rkProjectReportingService.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)reportingList)) {
                String opportunityName = reportingList.stream().map(RkProjectReportingEntity::getReportingProject).collect(Collectors.joining(","));
                vo.setOpportunityName(opportunityName);
            }
        }
        String quotationPrefix = "";
        if (StringUtils.isNotEmpty((String)entity.getQuotationId()) && null != (quotation = this.saleQuotationService.getInfo(entity.getQuotationId()))) {
            if (StringUtils.isNotEmpty((String)quotation.getSerialNumber())) {
                quotationPrefix = quotation.getSerialNumber();
            } else {
                CrmCustomerEntity customer;
                RkProjectReportingEntity reporting = this.rkProjectReportingService.getInfo(quotation.getOpportunityId());
                if (StringUtils.isNotEmpty((String)reporting.getCustomerId()) && null != (customer = this.crmCustomerService.getInfo(reporting.getCustomerId()))) {
                    quotationPrefix = customer.getName();
                }
            }
            userSelectValue = this.baseDataUtil.userSelectValue(quotation.getQuotationUser());
            String quotationName = quotationPrefix + "-" + userSelectValue;
            vo.setQuotationName(quotationName);
        }
        if (StringUtils.isNotEmpty((String)entity.getQuotationProfitId()) && null != (profit = this.saleQuotationProfitService.getInfo(entity.getQuotationProfitId()))) {
            userSelectValue = this.baseDataUtil.userSelectValue(profit.getSaleId());
            vo.setQuotationProfitName(quotationPrefix + "-" + userSelectValue);
        }
        vo.setBiddingStatusName(this.baseDataUtil.getDictName(entity.getBiddingStatus(), "biddingStatus"));
        vo.setContractSigningStatusName(this.baseDataUtil.getDictName(entity.getContractSigningStatus(), "contractSigningStatus"));
        if (StringUtils.isNotEmpty((String)vo.getNoContractId()) && null != (noContract = this.saleNoContractService.getInfo(vo.getNoContractId()))) {
            vo.setNoContractName(noContract.getContractName());
            vo.setNoContractAssociationId(noContract.getContractId());
        }
        if (StringUtils.isNotEmpty((String)vo.getInternalContractId()) && ObjectUtil.isNotEmpty(temp = this.oaContractInternalCrmService.getInfoById(vo.getInternalContractId()))) {
            OaContractInternalTransactionInfo oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean(temp, OaContractInternalTransactionInfo.class);
            vo.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
            vo.setInternalContractApplyUser(oaContractInternalTransactionInfo.getApplyUserId());
        }
        vo.setPartyBName(this.baseDataUtil.getDictName(vo.getPartyB(), "ContractInternalTransactionSignSubject"));
        List<OaContractPurchasePlanEntity> purchasePlanList = this.oaContractPurchasePlanService.getPlanListByContractId(id);
        if (StrUtil.isNotEmpty((CharSequence)vo.getNoContractId()) && CollectionUtil.isNotEmpty(detailList = this.oaPurchasePlanService.getByNoContractId(vo.getNoContractId()))) {
            purchasePlanList.addAll(JsonUtil.getJsonToList(detailList, OaContractPurchasePlanEntity.class));
        }
        vo.setPurchasePlanList(purchasePlanList);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detailForm/{id}"})
    public ActionResult<RkContractVerifyInfoVO> detailForm(@PathVariable(value="id") String id) {
        RkContractVerifyEntity entity = this.rkContractVerifyService.getInfo(id);
        RkContractVerifyInfoVO vo = (RkContractVerifyInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractVerifyInfoVO.class);
        vo.setIsNeedPayAdvance(vo.getIsNeedPayAdvance());
        vo.setIsStamp(vo.getIsStamp());
        vo.setIsSubcontract(vo.getIsSubcontract());
        vo.setProfitAmount(vo.getProfitAmount());
        vo.setStartContractTime(vo.getStartContractTime());
        vo.setEndContractTime(vo.getEndContractTime());
        vo.setContractTaxRate(this.baseDataUtil.getDictName(vo.getContractTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
        vo.setSalerId(this.baseDataUtil.userSelectValueNoAccount(vo.getSalerId()));
        vo.setContractType(this.baseDataUtil.getDictName(vo.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
        vo.setIsStampType(this.baseDataUtil.getDictName(vo.getIsStampType(), Constants.STAMP_TYPE_DICT_ID));
        vo.setPaymentMethodType(this.baseDataUtil.getDictName(vo.getPaymentMethodType(), ""));
        vo.setContractTypeDesc(this.baseDataUtil.getDictName(vo.getContractType(), Constants.CONTRACT_TYPE_DICT_ID));
        vo.setIndustryType(this.baseDataUtil.getDictName(vo.getIndustryType(), ""));
        vo.setIncomeType(this.crmProductCategoryService.getNameByIds(vo.getIncomeType()));
        vo.setFinancialAcceptanceUser(this.baseDataUtil.userSelectValues(vo.getFinancialAcceptanceUser()));
        vo.setSalesSupportUser(this.baseDataUtil.userSelectValues(vo.getSalesSupportUser()));
        vo.setOpportunityAssistanceUser(this.baseDataUtil.userSelectValues(vo.getOpportunityAssistanceUser()));
        vo.setProposalProducer(this.baseDataUtil.userSelectValues(vo.getProposalProducer()));
        vo.setAssistingUser(this.baseDataUtil.userSelectValues(vo.getAssistingUser()));
        vo.setRegion(entity.getRegionName());
        vo.setDepartment(entity.getDepartmentTreeName());
        if (StringUtils.isNotEmpty((String)vo.getCustomerIds())) {
            vo.setCustomerNames(this.oaContractCustomerService.getCustomerNamesByContractId(vo.getId()));
            vo.setCustomerName(vo.getCustomerNames().split(",")[0]);
            vo.setCustomerList(this.oaContractCustomerService.getListByContractId(vo.getId()));
        }
        if ("1".equals(vo.getIsAgent())) {
            RkAgentEntity agent;
            if (StringUtils.isNotEmpty((String)vo.getAgentId()) && null != (agent = this.agentService.getInfo(vo.getAgentId()))) {
                vo.setAgentName(agent.getName());
                vo.setAgentType(this.baseDataUtil.getDictName(agent.getType(), "agentType"));
            }
        } else {
            vo.setAgentName(vo.getCustomerNames());
        }
        vo.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        vo.setMasterId(ObjectUtil.isEmpty((Object)vo.getMasterId()) ? "" : ((RkContractEntity)this.rkContractService.getById((Serializable)((Object)vo.getMasterId()))).getContractName());
        vo.setEnableMarkDesc(this.baseDataUtil.getDictName(vo.getEnableMark(), Constants.ENABLE_MARK_DICT_ID));
        vo.setCustomerRegion(entity.getCustomerRegionName());
        vo.setArchivedByDesc(this.baseDataUtil.userSelectValueNoAccount(vo.getArchivedBy()));
        vo.setArchivedLocationDesc(this.baseDataUtil.getDictName(vo.getArchivedLocation(), ""));
        List<RkContractReturnPlanEntity> planList = this.contractReturnPlanService.getPlanByContractId(vo.getId());
        vo.setPlanNum(planList.size());
        List collect = planList.stream().filter(x -> !ObjectUtil.isEmpty((Object)x.getDueDate()) && x.getReturnState() != ReturnPlanEnum.END.getState() && DateUtil.dateToString((Date)DateUtil.getNowDate(), (String)"yyyy-MM-dd").compareTo(DateUtil.dateToString((Date)x.getDueDate(), (String)"yyyy-MM-dd")) > 0).collect(Collectors.toList());
        BigDecimal arrearsAmount = collect.stream().reduce(BigDecimal.ZERO, (x, y) -> x.add(y.getReceivableAmount().subtract(ObjectUtil.isEmpty((Object)y.getReturnAmount()) ? BigDecimal.ZERO : y.getReturnAmount())), BigDecimal::add);
        vo.setArrearsAmount(arrearsAmount);
        List<RkContractPaymentEntity> listByContractId = this.contractPaymentService.getListByContractId(id);
        List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractPaymentListVO.class);
        vo.setPaymentList(jsonToList);
        List<RkContractTaxEntity> rkContractTaxEntities = this.contractTaxService.listByContractId(id);
        List jsonToList1 = JsonUtil.getJsonToList(rkContractTaxEntities, RkContractTaxInfoVO.class);
        vo.setTaxList(jsonToList1);
        if (vo.getIsMoreTax() != null && vo.getIsMoreTax() == 1 && CollectionUtil.isNotEmpty((Collection)jsonToList1)) {
            String collect1 = jsonToList1.stream().map(RkContractTaxInfoVO::getTaxName).collect(Collectors.joining(","));
            vo.setContractTaxRate(collect1);
        }
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit(interval=10000)
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkContractVerifyUpForm rkContractVerifyUpForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            List<RkContractVerifyEntity> listByCode;
            String flowEngineId = "471650562752905285";
            if (StrUtil.isNotBlank((CharSequence)rkContractVerifyUpForm.getFlowId())) {
                flowEngineId = rkContractVerifyUpForm.getFlowId();
            }
            UserInfo userInfo = this.userProvider.get();
            OrganizeEntity directlyUnderCompanyById = this.organizeService.getDirectlyUnderCompanyById(rkContractVerifyUpForm.getSalerCompanyId());
            rkContractVerifyUpForm.setSalerPlatFormCompanyId(directlyUnderCompanyById.getParentId());
            RkContractVerifyEntity entity = this.rkContractVerifyService.getInfo(id);
            if (ObjectUtil.isNotEmpty((Object)rkContractVerifyUpForm.getContractCode()) && CollectionUtil.isNotEmpty(listByCode = this.rkContractVerifyService.getListByCode(rkContractVerifyUpForm.getContractCode())) && listByCode.size() > 1) {
                return ActionResult.fail((String)"\u5408\u540c\u7f16\u53f7\u5df2\u5b58\u5728");
            }
            if (entity != null) {
                RkAgentEntity agent;
                Map<String, Object> temp;
                String[] split;
                if (StrUtil.isNotBlank((CharSequence)rkContractVerifyUpForm.getSalesLiaison())) {
                    rkContractVerifyUpForm.setSalesLiaisonName(this.baseDataUtil.userSelectValues(rkContractVerifyUpForm.getSalesLiaison()));
                    UserEntity byId = (UserEntity)this.userService.getById((Serializable)((Object)rkContractVerifyUpForm.getSalesLiaison()));
                    rkContractVerifyUpForm.setLiaisonDepartment(byId.getOrganizeId());
                    rkContractVerifyUpForm.setLiaisonCompany(this.userService.getUserCompany(rkContractVerifyUpForm.getSalesLiaison()));
                }
                rkContractVerifyUpForm.setIsDepartLeader(this.isLeader(rkContractVerifyUpForm.getSalerId()));
                RkContractVerifyEntity subentity = (RkContractVerifyEntity)JsonUtil.getJsonToBean((Object)((Object)rkContractVerifyUpForm), RkContractVerifyEntity.class);
                if (!ObjectUtil.isEmpty((Object)subentity.getDepartmentTree()) && (split = subentity.getDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",")).length > 0) {
                    subentity.setDepartmentTreeName(this.baseDataUtil.comSelectValues(subentity.getDepartmentTree()));
                    subentity.setDepartmentOne(split[0]);
                    subentity.setDepartmentOneName(this.baseDataUtil.comSelectValues(subentity.getDepartmentOne()));
                    subentity.setDepartment(split[split.length - 1]);
                    subentity.setDepartmentName(this.baseDataUtil.comSelectValues(subentity.getDepartment()));
                }
                if (ObjectUtil.isNotEmpty((Object)subentity.getIsStampType())) {
                    subentity.setIsStampType(subentity.getIsStampType());
                    subentity.setStampTypeName(this.baseDataUtil.getDictName(entity.getIsStampType(), Constants.STAMP_TYPE_DICT_ID));
                }
                subentity.setContractLevel(this.baseDataUtil.getDictName(subentity.getContractLevel(), Constants.CONTRACT_LEVEL_DICT_ID));
                if (CollectionUtil.isNotEmpty(rkContractVerifyUpForm.getTaxList())) {
                    List jsonToList = JsonUtil.getJsonToList(rkContractVerifyUpForm.getTaxList(), RkContractTaxEntity.class);
                    jsonToList.stream().forEach(tax -> {
                        tax.setContractId(entity.getId());
                        tax.setId(RandomUtil.uuId());
                    });
                    this.contractTaxService.deleteByContractId(entity.getId());
                    this.contractTaxService.saveBatch(jsonToList);
                }
                if (StringUtils.isNotEmpty((String)rkContractVerifyUpForm.getCustomerAddress())) {
                    split = rkContractVerifyUpForm.getCustomerAddress().replace("\"", "").replace("[", "").replace("]", "").split(",");
                    for (int i = 0; i < split.length; ++i) {
                        if (i == 0) {
                            subentity.setCustomerRegion(split[0]);
                            subentity.setCustomerRegionName(this.baseDataUtil.provinceData(entity.getCustomerRegion()));
                            continue;
                        }
                        if (i == 1) {
                            subentity.setCustomerProv(split[1]);
                            subentity.setCustomerProvName(this.baseDataUtil.provinceData(entity.getCustomerProv()));
                            continue;
                        }
                        if (i != 2) continue;
                        subentity.setCustomerCity(split[2]);
                        subentity.setCustomerCityName(this.baseDataUtil.provinceData(entity.getCustomerCity()));
                    }
                    subentity.setCustomerAddressName(this.baseDataUtil.provinceData(rkContractVerifyUpForm.getCustomerAddress()));
                } else {
                    subentity.setCustomerRegion("");
                    subentity.setCustomerRegionName("");
                    subentity.setCustomerProv("");
                    subentity.setCustomerProvName("");
                    subentity.setCustomerCity("");
                    subentity.setCustomerCityName("");
                    subentity.setCustomerAddressName("");
                }
                if (StringUtils.isEmpty((String)rkContractVerifyUpForm.getContractCode()) && rkContractVerifyUpForm.getStatus() != 0 && null != rkContractVerifyUpForm.getAutoContractCode() && rkContractVerifyUpForm.getAutoContractCode().booleanValue() && "9".equals(entity.getCompanyId())) {
                    subentity.setContractCode(BillCustomizeUtils.getMJContractBill());
                }
                this.oaContractCustomerService.removeByContractId(id);
                if (StringUtils.isNotEmpty((String)subentity.getCustomerIds())) {
                    this.oaContractCustomerService.insertListByCustomerIds(id, subentity.getCustomerIds());
                }
                if (ObjectUtil.equals((Object)subentity.getIsAgent(), (Object)1)) {
                    subentity.setAgentIds(subentity.getAgentId());
                } else {
                    subentity.setAgentId(subentity.getCustomerId());
                    subentity.setAgentIds(subentity.getCustomerIds());
                }
                this.rkContractVerifyService.update(id, subentity, rkContractVerifyUpForm.getAttachmentList());
                if (rkContractVerifyUpForm.getStatus() != 0) {
                    RkContractEntity contractEntity = new RkContractEntity();
                    BeanUtils.copyProperties((Object)subentity, (Object)contractEntity);
                    if (this.rkContractService.checkContractIsExist(contractEntity)) {
                        throw new DataException("\u5408\u540c\u5df2\u5b58\u5728\uff01");
                    }
                }
                rkContractVerifyUpForm.setDepartmentName(subentity.getDepartmentName());
                rkContractVerifyUpForm.setDepartmentOneName(subentity.getDepartmentOneName());
                rkContractVerifyUpForm.setStampTypeName(subentity.getStampTypeName());
                rkContractVerifyUpForm.setIsStamp(subentity.getIsStamp());
                rkContractVerifyUpForm.setIsStampType(subentity.getIsStampType());
                rkContractVerifyUpForm.setContractLevel(subentity.getContractLevel());
                rkContractVerifyUpForm.setSalerId(subentity.getSalerId());
                rkContractVerifyUpForm.setContractAmount(subentity.getContractAmount());
                if (StringUtils.isNotEmpty((String)rkContractVerifyUpForm.getInternalContractId()) && ObjectUtil.isNotEmpty(temp = this.oaContractInternalCrmService.getInfoById(rkContractVerifyUpForm.getInternalContractId()))) {
                    OaContractInternalTransactionInfo oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean(temp, OaContractInternalTransactionInfo.class);
                    rkContractVerifyUpForm.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
                    rkContractVerifyUpForm.setInternalContractApplyUser(oaContractInternalTransactionInfo.getApplyUserId());
                }
                this.oaContractPurchasePlanService.deleteByContractId(id);
                List<OaContractPurchasePlanEntity> purchasePlanList = rkContractVerifyUpForm.getPurchasePlanList();
                if (ObjectUtil.isNotEmpty(purchasePlanList)) {
                    for (OaContractPurchasePlanEntity p : purchasePlanList) {
                        p.setContractId(id);
                        if (!StrUtil.isEmpty((CharSequence)p.getNoContractId())) continue;
                        p.setId(RandomUtil.uuId());
                        p.setCompanyId(rkContractVerifyUpForm.getSalerCompanyId());
                        p.setContractCode(rkContractVerifyUpForm.getContractCode());
                        p.setContractName(rkContractVerifyUpForm.getContractName());
                        p.setCustomerId(rkContractVerifyUpForm.getCustomerId());
                        p.setSalerId(rkContractVerifyUpForm.getSalerId());
                        this.oaContractPurchasePlanService.save(p);
                    }
                }
                String flowTitle = "";
                if (ObjectUtil.equals((Object)subentity.getIsAgent(), (Object)1) && StringUtils.isNotEmpty((String)subentity.getAgentId()) && null != (agent = this.agentService.getInfo(subentity.getAgentId()))) {
                    flowTitle = agent.getName();
                }
                if (StringUtils.isNotEmpty((String)flowTitle)) {
                    flowTitle = flowTitle + "-";
                }
                flowTitle = flowTitle + subentity.getContractName();
                FlowUtil.saveOrSubmit((String)rkContractVerifyUpForm.getTaskId(), (String)flowEngineId, (String)rkContractVerifyUpForm.getTemplateId(), (String)id, (Object)((Object)rkContractVerifyUpForm), (Integer)rkContractVerifyUpForm.getStatus(), (String)flowTitle);
                if (rkContractVerifyUpForm.getStatus() == 0) {
                    return ActionResult.success((String)CrmReminderEnum.TS.getType());
                }
                return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkContractVerifyEntity entity = this.rkContractVerifyService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.rkContractVerifyService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    private String isLeader(String userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(UserEntity::getManagerId, (Object)userId);
        List userList = this.userService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)userList)) {
            return "1";
        }
        return "2";
    }

    @PostMapping(value={"/getContractFileContent/{companyId}"})
    @DSTransactional
    public ActionResult getContractFileContent(@RequestBody @Valid List<RkAttachmentCrForm> fileList, @PathVariable(value="companyId") String companyId) {
        if (StringUtils.isNotEmpty((String)companyId)) {
            companyId = this.userProvider.get().getOrganizeId();
        }
        RkContractVerifyFileResponseUpForm upForm = this.rkContractVerifyService.getContractFileContent(fileList, companyId);
        return ActionResult.success((Object)upForm);
    }
}

