/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkContractVerifyFileResponseEntity;
import com.bringspring.contract.model.rkContractVerifyFileResponse.RkContractVerifyFileResponseCrForm;
import com.bringspring.contract.model.rkContractVerifyFileResponse.RkContractVerifyFileResponseInfoVO;
import com.bringspring.contract.model.rkContractVerifyFileResponse.RkContractVerifyFileResponseListVO;
import com.bringspring.contract.model.rkContractVerifyFileResponse.RkContractVerifyFileResponsePagination;
import com.bringspring.contract.model.rkContractVerifyFileResponse.RkContractVerifyFileResponsePaginationExportModel;
import com.bringspring.contract.model.rkContractVerifyFileResponse.RkContractVerifyFileResponseUpForm;
import com.bringspring.contract.service.RkContractVerifyFileResponseService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9500\u552e\u5408\u540c\u8bc6\u522b\u7ed3\u679c"}, value="contract")
@RequestMapping(value={"/api/contract/RkContractVerifyFileResponse"})
public class RkContractVerifyFileResponseController {
    private static final Logger log = LoggerFactory.getLogger(RkContractVerifyFileResponseController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractVerifyFileResponseService rkContractVerifyFileResponseService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkContractVerifyFileResponsePagination rkContractVerifyFileResponsePagination) throws IOException {
        List<RkContractVerifyFileResponseEntity> list = this.rkContractVerifyFileResponseService.getList(rkContractVerifyFileResponsePagination);
        for (RkContractVerifyFileResponseEntity rkContractVerifyFileResponseEntity : list) {
            rkContractVerifyFileResponseEntity.setCreatorUserId(this.baseDataUtil.userSelectValues(rkContractVerifyFileResponseEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, RkContractVerifyFileResponseListVO.class);
        for (RkContractVerifyFileResponseListVO rkContractVerifyFileResponseListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkContractVerifyFileResponsePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid RkContractVerifyFileResponseCrForm rkContractVerifyFileResponseCrForm) throws DataException {
        this.rkContractVerifyFileResponseService.create(rkContractVerifyFileResponseCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkContractVerifyFileResponsePaginationExportModel rkContractVerifyFileResponsePaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)rkContractVerifyFileResponsePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkContractVerifyFileResponsePagination rkContractVerifyFileResponsePagination = (RkContractVerifyFileResponsePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkContractVerifyFileResponsePaginationExportModel), RkContractVerifyFileResponsePagination.class));
        List<RkContractVerifyFileResponseEntity> list = this.rkContractVerifyFileResponseService.getTypeList(rkContractVerifyFileResponsePagination, rkContractVerifyFileResponsePaginationExportModel.getDataType());
        for (RkContractVerifyFileResponseEntity rkContractVerifyFileResponseEntity : list) {
            rkContractVerifyFileResponseEntity.setCreatorUserId(this.baseDataUtil.userSelectValues(rkContractVerifyFileResponseEntity.getCreatorUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, RkContractVerifyFileResponseListVO.class);
        for (RkContractVerifyFileResponseListVO rkContractVerifyFileResponseListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)rkContractVerifyFileResponsePaginationExportModel.getSelectKey()) ? rkContractVerifyFileResponsePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block46: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "responseXml": {
                        entitys.add(new ExcelExportEntity("\u7ed3\u679c", (Object)"responseXml"));
                        continue block46;
                    }
                    case "attId": {
                        entitys.add(new ExcelExportEntity("\u6587\u672cid", (Object)"attId"));
                        continue block46;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block46;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7f16\u7801", (Object)"contractCode"));
                        continue block46;
                    }
                    case "contractJia": {
                        entitys.add(new ExcelExportEntity("\u7532\u65b9\u5bf9\u8c61", (Object)"contractJia"));
                        continue block46;
                    }
                    case "customerAddressName": {
                        entitys.add(new ExcelExportEntity("\u7532\u65b9\u5730\u5740", (Object)"customerAddressName"));
                        continue block46;
                    }
                    case "contractYi": {
                        entitys.add(new ExcelExportEntity("\u4e59\u65b9\u5bf9\u8c61", (Object)"contractYi"));
                        continue block46;
                    }
                    case "contractYiAddress": {
                        entitys.add(new ExcelExportEntity("\u4e59\u65b9\u5730\u5740", (Object)"contractYiAddress"));
                        continue block46;
                    }
                    case "contractAmount": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u91d1\u989d", (Object)"contractAmount"));
                        continue block46;
                    }
                    case "paymentDescription": {
                        entitys.add(new ExcelExportEntity("\u4ed8\u6b3e\u65b9\u5f0f", (Object)"paymentDescription"));
                        continue block46;
                    }
                    case "addressDate": {
                        entitys.add(new ExcelExportEntity("\u4ea4\u8d27\u5730\u70b9", (Object)"addressDate"));
                        continue block46;
                    }
                    case "subjectMatterList": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1", (Object)"subjectMatterList"));
                        continue block46;
                    }
                    case "paymentList": {
                        entitys.add(new ExcelExportEntity("\u4ed8\u6b3e\u65b9\u5f0f", (Object)"paymentList"));
                        continue block46;
                    }
                    case "statusmsg": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"statusmsg"));
                        continue block46;
                    }
                    case "errormsg": {
                        entitys.add(new ExcelExportEntity("\u9519\u8bef", (Object)"errormsg"));
                        continue block46;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block46;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block46;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkContractVerifyFileResponseInfoVO> info(@PathVariable(value="id") String id) {
        RkContractVerifyFileResponseEntity entity = this.rkContractVerifyFileResponseService.getInfo(id);
        RkContractVerifyFileResponseInfoVO vo = (RkContractVerifyFileResponseInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractVerifyFileResponseInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkContractVerifyFileResponseInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkContractVerifyFileResponseEntity entity = this.rkContractVerifyFileResponseService.getInfo(id);
        RkContractVerifyFileResponseInfoVO vo = (RkContractVerifyFileResponseInfoVO)JsonUtil.getJsonToBean((Object)entity, RkContractVerifyFileResponseInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValues(vo.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkContractVerifyFileResponseUpForm rkContractVerifyFileResponseUpForm) throws DataException {
        this.rkContractVerifyFileResponseService.update(id, rkContractVerifyFileResponseUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkContractVerifyFileResponseEntity entity = this.rkContractVerifyFileResponseService.getInfo(id);
        if (entity != null) {
            this.rkContractVerifyFileResponseService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

