/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkMaterialEntity;
import com.bringspring.contract.entity.RkpurchaseapplydetaillistEntity;
import com.bringspring.contract.model.rkmaterial.RkMaterialCrForm;
import com.bringspring.contract.model.rkmaterial.RkMaterialExcelModel;
import com.bringspring.contract.model.rkmaterial.RkMaterialImportVO;
import com.bringspring.contract.model.rkmaterial.RkMaterialInfoVO;
import com.bringspring.contract.model.rkmaterial.RkMaterialListVO;
import com.bringspring.contract.model.rkmaterial.RkMaterialPagination;
import com.bringspring.contract.model.rkmaterial.RkMaterialPaginationExportModel;
import com.bringspring.contract.model.rkmaterial.RkMaterialUpForm;
import com.bringspring.contract.model.rkpurchaseapplydetaillist.RkpurchaseapplydetaillistPagination;
import com.bringspring.contract.service.RkMaterialService;
import com.bringspring.contract.service.RkpurchaseapplydetaillistService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u7269\u6599\u6863\u6848"}, value="contract")
@RequestMapping(value={"/api/contract/Rkmaterial"})
public class RkMaterialController {
    private static final Logger log = LoggerFactory.getLogger(RkMaterialController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkMaterialService rkmaterialService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RkpurchaseapplydetaillistService rkpurchaseapplydetaillistService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkMaterialPagination rkmaterialPagination) throws IOException {
        List<RkMaterialEntity> list = this.rkmaterialService.getList(rkmaterialPagination);
        for (RkMaterialEntity rkMaterialEntity : list) {
            rkMaterialEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(rkMaterialEntity.getCreatorUserId()));
            rkMaterialEntity.setMaterialType(this.baseDataUtil.getDictName(rkMaterialEntity.getMaterialType(), "MaterialType"));
            rkMaterialEntity.setMaterialBrand(this.baseDataUtil.getDictName(rkMaterialEntity.getMaterialBrand(), "MaterialBrand"));
            rkMaterialEntity.setMaterialUnit(this.baseDataUtil.getDictName(rkMaterialEntity.getMaterialUnit(), "MaterialUnit"));
            rkMaterialEntity.setMaterialProperties(this.baseDataUtil.getDictName(rkMaterialEntity.getMaterialProperties(), "materialProperties"));
        }
        List listVO = JsonUtil.getJsonToList(list, RkMaterialListVO.class);
        for (RkMaterialListVO rkMaterialListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkmaterialPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkMaterialCrForm rkmaterialCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        rkmaterialCrForm.setCreatorUserId(userInfo.getUserId());
        rkmaterialCrForm.setCreatorTime(DateUtil.getNow());
        RkMaterialEntity entity = (RkMaterialEntity)JsonUtil.getJsonToBean((Object)rkmaterialCrForm, RkMaterialEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        this.rkmaterialService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkMaterialInfoVO> info(@PathVariable(value="id") String id) {
        RkMaterialEntity entity = this.rkmaterialService.getInfo(id);
        RkMaterialInfoVO vo = (RkMaterialInfoVO)JsonUtil.getJsonToBean((Object)entity, RkMaterialInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkMaterialInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkMaterialEntity entity = this.rkmaterialService.getInfo(id);
        RkMaterialInfoVO vo = (RkMaterialInfoVO)JsonUtil.getJsonToBean((Object)entity, RkMaterialInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setMaterialType(this.baseDataUtil.getDictName(vo.getMaterialType(), "MaterialType"));
        vo.setMaterialBrand(this.baseDataUtil.getDictName(vo.getMaterialBrand(), "MaterialBrand"));
        vo.setMaterialUnit(this.baseDataUtil.getDictName(vo.getMaterialUnit(), "MaterialUnit"));
        vo.setMaterialUnit(this.baseDataUtil.getDictName(vo.getMaterialUnit(), "MaterialUnit"));
        vo.setMaterialProperties(this.baseDataUtil.getDictName(vo.getMaterialProperties(), "materialProperties"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkMaterialUpForm rkmaterialUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkMaterialEntity entity = this.rkmaterialService.getInfo(id);
        if (entity != null) {
            List<RkpurchaseapplydetaillistEntity> list = this.rkpurchaseapplydetaillistService.getListNoPage(rkmaterialUpForm.getMaterialCode());
            if (list.size() > 0) {
                return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u66f4\u65b0");
            }
            RkMaterialEntity subentity = (RkMaterialEntity)JsonUtil.getJsonToBean((Object)rkmaterialUpForm, RkMaterialEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.rkmaterialService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkMaterialEntity entity = this.rkmaterialService.getInfo(id);
        if (entity != null) {
            RkpurchaseapplydetaillistPagination rkpurchaseapplydetaillistPagination = new RkpurchaseapplydetaillistPagination();
            rkpurchaseapplydetaillistPagination.setMenuId("500221328691823749");
            rkpurchaseapplydetaillistPagination.setMaterialId(entity.getId());
            rkpurchaseapplydetaillistPagination.setCloseFlowStatus("1");
            List<RkpurchaseapplydetaillistEntity> list = this.rkpurchaseapplydetaillistService.getList(rkpurchaseapplydetaillistPagination);
            if (list.size() > 0) {
                return ActionResult.fail((String)"\u5220\u9664\u5931\u8d25\uff0c\u7269\u6599\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            this.rkmaterialService.delete(entity);
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
        return ActionResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/getMaxCode"})
    public ActionResult getMaxCode() throws IOException {
        RkMaterialPagination rkMaterialPagination = new RkMaterialPagination();
        rkMaterialPagination.setMenuId("495256432287943813");
        String maxCode = this.rkmaterialService.getMaxCode(rkMaterialPagination);
        return ActionResult.success((String)maxCode);
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult Uploader() {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().endsWith(".xlsx") || file.getOriginalFilename().endsWith(".xls")) {
            String filePath = this.configValueUtil.getTemporaryFilePath();
            String fileName = RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file);
            fileName = XSSEscape.escape((String)fileName);
            FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
            DownloadVO vo = DownloadVO.builder().build();
            vo.setName(fileName);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List pList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, RkMaterialExcelModel.class);
        Map<String, Object> map = this.rkmaterialService.importPreview(pList);
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult ImportData(@RequestBody RkMaterialExcelModel data) {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u4fe1\u606f\u4e3a\u7a7a\uff0c\u5bfc\u5165\u5931\u8d25");
        }
        List dataList = JsonUtil.getJsonToList(data.getList(), RkMaterialExcelModel.class);
        RkMaterialImportVO result = this.rkmaterialService.importData(dataList);
        return ActionResult.success((Object)result);
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u7269\u6599\u6863\u6848.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u7269\u6599\u6863\u6848.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkMaterialPaginationExportModel rkMaterialPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkMaterialPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkMaterialPagination rkMaterialPagination = (RkMaterialPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkMaterialPaginationExportModel), RkMaterialPagination.class));
        List<RkMaterialEntity> list = this.rkmaterialService.getTypeList(rkMaterialPagination, rkMaterialPaginationExportModel.getDataType());
        for (RkMaterialEntity rkMaterialEntity : list) {
            rkMaterialEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(rkMaterialEntity.getCreatorUserId()));
            rkMaterialEntity.setMaterialType(this.baseDataUtil.getDictName(rkMaterialEntity.getMaterialType(), "MaterialType"));
            rkMaterialEntity.setMaterialBrand(this.baseDataUtil.getDictName(rkMaterialEntity.getMaterialBrand(), "MaterialBrand"));
            rkMaterialEntity.setMaterialUnit(this.baseDataUtil.getDictName(rkMaterialEntity.getMaterialUnit(), "MaterialUnit"));
            rkMaterialEntity.setMaterialProperties(this.baseDataUtil.getDictName(rkMaterialEntity.getMaterialProperties(), "materialProperties"));
        }
        List listVO = JsonUtil.getJsonToList(list, RkMaterialListVO.class);
        for (RkMaterialListVO rkMaterialListVO : listVO) {
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkMaterialPaginationExportModel.getSelectKey()) ? rkMaterialPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block30: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block30;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block30;
                    }
                    case "materialCode": {
                        entitys.add(new ExcelExportEntity("\u7f16\u7801", (Object)"materialCode"));
                        continue block30;
                    }
                    case "materialProperties": {
                        entitys.add(new ExcelExportEntity("\u5c5e\u6027", (Object)"materialProperties"));
                        continue block30;
                    }
                    case "materialType": {
                        entitys.add(new ExcelExportEntity("\u5206\u7c7b", (Object)"materialType"));
                        continue block30;
                    }
                    case "materialBrand": {
                        entitys.add(new ExcelExportEntity("\u54c1\u724c", (Object)"materialBrand"));
                        continue block30;
                    }
                    case "materialName": {
                        entitys.add(new ExcelExportEntity("\u540d\u79f0", (Object)"materialName"));
                        continue block30;
                    }
                    case "materialModel": {
                        entitys.add(new ExcelExportEntity("\u578b\u53f7", (Object)"materialModel"));
                        continue block30;
                    }
                    case "materialUnit": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u91cf\u5355\u4f4d", (Object)"materialUnit"));
                        continue block30;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

