/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkPaymentCheckEntity;
import com.bringspring.contract.entity.RkPaymentCheckRelationEntity;
import com.bringspring.contract.entity.RkProcurePaymentEntity;
import com.bringspring.contract.model.rkpaymentcheck.RkPaymentCheckCrForm;
import com.bringspring.contract.model.rkpaymentcheck.RkPaymentCheckInfoVO;
import com.bringspring.contract.model.rkpaymentcheck.RkPaymentCheckListVO;
import com.bringspring.contract.model.rkpaymentcheck.RkPaymentCheckPagination;
import com.bringspring.contract.model.rkpaymentcheck.RkPaymentCheckUpForm;
import com.bringspring.contract.model.rkpaymentcheck.RkPaymentVo;
import com.bringspring.contract.model.rkpaymentcheckrelation.RkPaymentCheckRelationListVO;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkPaymentCheckRelationService;
import com.bringspring.contract.service.RkPaymentCheckService;
import com.bringspring.contract.service.RkProcurePaymentRelationService;
import com.bringspring.contract.service.RkProcurePaymentService;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.crm.util.CrmReminderEnum;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u91c7\u8d2d\u4ed8\u6b3e\u590d\u6838"}, value="contract")
@RequestMapping(value={"/api/contract/RkPaymentCheck"})
public class RkPaymentCheckController {
    private static final Logger log = LoggerFactory.getLogger(RkPaymentCheckController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkPaymentCheckService rkPaymentCheckService;
    @Autowired
    private RkPaymentCheckRelationService rkPaymentCheckRelationService;
    @Autowired
    private RkProcurePaymentService rkProcurePaymentService;
    @Autowired
    private RkProcurePaymentRelationService rkProcurePaymentRelationService;
    @Autowired
    private RkContractProcureService rkContractProcureService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkPaymentCheckPagination rkPaymentCheckPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        String organizeId = userInfo.getOrganizeId();
        rkPaymentCheckPagination.setUserId(userInfo.getUserId());
        rkPaymentCheckPagination.setCompanyId(organizeId);
        List<RkPaymentCheckEntity> list = this.rkPaymentCheckService.getList(rkPaymentCheckPagination);
        for (RkPaymentCheckEntity rkPaymentCheckEntity : list) {
            rkPaymentCheckEntity.setCheckerId(this.baseDataUtil.userSelectValue(rkPaymentCheckEntity.getCheckerId()));
        }
        List listVO = JsonUtil.getJsonToList(list, RkPaymentCheckListVO.class);
        for (RkPaymentCheckListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkPaymentCheckPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @RepeatSubmit
    @DSTransactional
    public ActionResult create(@RequestBody RkPaymentCheckCrForm rkPaymentCheckCrForm) throws DataException, WorkFlowException {
        String flowEngineId = "496225111603593797";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        String organizeId = userInfo.getOrganizeId();
        rkPaymentCheckCrForm.setCompanyId(organizeId);
        rkPaymentCheckCrForm.setCheckDate(DateUtil.getNow());
        rkPaymentCheckCrForm.setCheckCode(this.baseDataUtil.getBillNumber("checkCode", Boolean.valueOf(false)));
        rkPaymentCheckCrForm.setCheckerId(userInfo.getUserId());
        RkPaymentCheckEntity entity = (RkPaymentCheckEntity)JsonUtil.getJsonToBean((Object)((Object)rkPaymentCheckCrForm), RkPaymentCheckEntity.class);
        entity.setId(mainId);
        entity.setCheckPaymentDate(entity.getCheckPaymentDate());
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setCreatorTime(new Date());
        entity.setEnableMark(entity.getEnableMark());
        this.rkPaymentCheckService.save(entity);
        List<RkPaymentVo> payList = rkPaymentCheckCrForm.getPayList();
        List jsonToList = JsonUtil.getJsonToList(payList, RkPaymentCheckRelationEntity.class);
        jsonToList.stream().forEach(payment -> {
            payment.setPayId(payment.getPayId());
            payment.setId(RandomUtil.uuId());
            payment.setCheckId(entity.getId());
            payment.setSupplierId(payment.getSupplierId());
            payment.setProcureCode(payment.getProcureCode());
            payment.setProcureId(payment.getProcureId());
            payment.setSupplierName(payment.getSupplierName());
            payment.setCreatorTime(new Date());
            payment.setCreatorUserId(userInfo.getUserId());
        });
        this.rkPaymentCheckRelationService.saveBatch(jsonToList);
        if (entity.getEnableMark() != "save") {
            List<RkPaymentCheckRelationEntity> listByPayId = this.rkPaymentCheckRelationService.listByPayId(entity.getId());
            List collect = listByPayId.stream().map(RkPaymentCheckRelationEntity::getPayId).collect(Collectors.toList());
            List list = this.rkProcurePaymentService.listByIds(collect);
            list.stream().forEach(payment -> {
                RkPaymentCheckRelationEntity checkInfo = this.rkPaymentCheckRelationService.getInfoByCheckId(entity.getId(), payment.getId());
                payment.setCheckAmount(MathUtils.substract(payment.getCheckAmount(), checkInfo.getCheckAmount()));
            });
            this.rkProcurePaymentService.updateBatchById(list);
        }
        FlowUtil.saveOrSubmit((String)rkPaymentCheckCrForm.getTaskId(), (String)flowEngineId, (String)rkPaymentCheckCrForm.getTemplateId(), (String)mainId, (Object)((Object)rkPaymentCheckCrForm), (Integer)rkPaymentCheckCrForm.getStatus());
        if (rkPaymentCheckCrForm.getStatus() == 0) {
            return ActionResult.success((String)CrmReminderEnum.TS.getType());
        }
        return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkPaymentCheckInfoVO> info(@PathVariable(value="id") String id) {
        RkPaymentCheckEntity entity = this.rkPaymentCheckService.getInfo(id);
        RkPaymentCheckInfoVO vo = (RkPaymentCheckInfoVO)JsonUtil.getJsonToBean((Object)entity, RkPaymentCheckInfoVO.class);
        if (vo.getCheckDate() != null) {
            vo.setCheckDate(vo.getCheckDate());
        }
        if (vo.getCheckPaymentDate() != null) {
            vo.setCheckPaymentDate(vo.getCheckPaymentDate());
        }
        vo.setCheckerName(this.baseDataUtil.userSelectValueNoAccount(vo.getCheckerId()));
        List<RkPaymentCheckRelationEntity> listByPayId = this.rkPaymentCheckRelationService.listByPayId(id);
        List jsonToList = JsonUtil.getJsonToList(listByPayId, RkPaymentCheckRelationListVO.class);
        for (RkPaymentCheckRelationListVO r : jsonToList) {
            RkProcurePaymentEntity p;
            if (!StringUtils.isNotEmpty((String)r.getPayId()) || (p = this.rkProcurePaymentService.getInfo(r.getPayId())) == null) continue;
            r.setPaymentAmount(p.getPaymentAmount());
        }
        vo.setPayList(jsonToList);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @RepeatSubmit
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody RkPaymentCheckUpForm rkPaymentCheckUpForm) throws DataException, WorkFlowException {
        String flowEngineId = "496225111603593797";
        UserInfo userInfo = this.userProvider.get();
        RkPaymentCheckEntity entity = this.rkPaymentCheckService.getInfo(id);
        if (entity != null) {
            RkPaymentCheckEntity subentity = (RkPaymentCheckEntity)JsonUtil.getJsonToBean((Object)((Object)rkPaymentCheckUpForm), RkPaymentCheckEntity.class);
            subentity.setCheckDate(entity.getCheckDate());
            subentity.setCheckPaymentDate(entity.getCheckPaymentDate());
            subentity.setCheckerId(entity.getCheckerId());
            subentity.setLastModifyUserId(userInfo.getUserId());
            subentity.setLastModifyTime(new Date());
            this.rkPaymentCheckService.updateCheck(id, rkPaymentCheckUpForm);
            FlowUtil.saveOrSubmit((String)rkPaymentCheckUpForm.getTaskId(), (String)flowEngineId, (String)rkPaymentCheckUpForm.getTemplateId(), (String)id, (Object)((Object)rkPaymentCheckUpForm), (Integer)rkPaymentCheckUpForm.getStatus());
            if (rkPaymentCheckUpForm.getStatus() == 0) {
                return ActionResult.success((String)CrmReminderEnum.TS.getType());
            }
            return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @RepeatSubmit
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkPaymentCheckEntity entity = this.rkPaymentCheckService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.rkPaymentCheckService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

