/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkPaymentCheckEntity;
import com.bringspring.contract.entity.RkPaymentCheckRelationEntity;
import com.bringspring.contract.entity.RkProcurePaymentEntity;
import com.bringspring.contract.model.rkpaymentcheckrelation.RkPaymentCheckRelationCrForm;
import com.bringspring.contract.model.rkpaymentcheckrelation.RkPaymentCheckRelationInfoVO;
import com.bringspring.contract.model.rkpaymentcheckrelation.RkPaymentCheckRelationListForBuyerVO;
import com.bringspring.contract.model.rkpaymentcheckrelation.RkPaymentCheckRelationListVO;
import com.bringspring.contract.model.rkpaymentcheckrelation.RkPaymentCheckRelationPagination;
import com.bringspring.contract.model.rkpaymentcheckrelation.RkPaymentCheckRelationUpForm;
import com.bringspring.contract.service.RkPaymentCheckRelationService;
import com.bringspring.contract.service.RkPaymentCheckService;
import com.bringspring.contract.service.RkProcurePaymentService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u590d\u6838\u5173\u8054\u4ed8\u6b3e"}, value="contract")
@RequestMapping(value={"/api/contract/RkPaymentCheckRelation"})
public class RkPaymentCheckRelationController {
    private static final Logger log = LoggerFactory.getLogger(RkPaymentCheckRelationController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkPaymentCheckRelationService rkPaymentCheckRelationService;
    @Autowired
    private RkPaymentCheckService rkPaymentCheckService;
    @Autowired
    private RkProcurePaymentService rkProcurePaymentService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkPaymentCheckRelationPagination rkPaymentCheckRelationPagination) throws IOException, ParseException {
        List<RkPaymentCheckRelationEntity> list = this.rkPaymentCheckRelationService.getList(rkPaymentCheckRelationPagination);
        for (RkPaymentCheckRelationEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, RkPaymentCheckRelationListVO.class);
        for (RkPaymentCheckRelationListVO rkPaymentCheckRelationListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkPaymentCheckRelationPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping(value={"/buyerList"})
    public ActionResult buyerList(@RequestBody RkPaymentCheckRelationPagination rkPaymentCheckRelationPagination) throws IOException {
        List<RkPaymentCheckRelationEntity> list = this.rkPaymentCheckRelationService.getList(rkPaymentCheckRelationPagination);
        List listVO = JsonUtil.getJsonToList(list, RkPaymentCheckRelationListForBuyerVO.class);
        for (RkPaymentCheckRelationListForBuyerVO rkPaymentCheckRelationVO : listVO) {
            FlowTaskEntity flowTaskEntity;
            RkProcurePaymentEntity payment = this.rkProcurePaymentService.getInfo(rkPaymentCheckRelationVO.getPayId());
            rkPaymentCheckRelationVO.setPaymentCreatorTime(DateUtil.dateFormat((Date)payment.getCreatorTime()));
            rkPaymentCheckRelationVO.setPaymentCreatorUserId(payment.getCreatorUserId());
            rkPaymentCheckRelationVO.setPaymentCreatorUser(payment.getPayName());
            rkPaymentCheckRelationVO.setPaymentAmount(payment.getPaymentAmount());
            if (ObjectUtil.isNotEmpty((Object)rkPaymentCheckRelationVO.getActualPayDate())) {
                rkPaymentCheckRelationVO.setActualPayDate(DateUtil.date((long)Long.parseLong(rkPaymentCheckRelationVO.getActualPayDate())).toDateStr());
            }
            if ((flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)rkPaymentCheckRelationVO.getCheckId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus})) != null) {
                rkPaymentCheckRelationVO.setEnableMark(flowTaskEntity.getStatus().toString());
            } else {
                rkPaymentCheckRelationVO.setEnableMark("");
            }
            if (rkPaymentCheckRelationVO.getEnableMark().equals("2")) {
                rkPaymentCheckRelationVO.setEnableMarkDesc("\u5df2\u652f\u4ed8");
                continue;
            }
            if (rkPaymentCheckRelationVO.getEnableMark().equals("1")) {
                rkPaymentCheckRelationVO.setEnableMarkDesc("\u590d\u6838\u4e2d");
                continue;
            }
            rkPaymentCheckRelationVO.setEnableMarkDesc("\u672a\u652f\u4ed8");
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkPaymentCheckRelationPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkPaymentCheckRelationCrForm rkPaymentCheckRelationCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkPaymentCheckRelationEntity entity = (RkPaymentCheckRelationEntity)JsonUtil.getJsonToBean((Object)rkPaymentCheckRelationCrForm, RkPaymentCheckRelationEntity.class);
        entity.setId(mainId);
        this.rkPaymentCheckRelationService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkPaymentCheckRelationInfoVO> info(@PathVariable(value="id") String id) {
        RkPaymentCheckRelationEntity entity = this.rkPaymentCheckRelationService.getInfo(id);
        RkPaymentCheckRelationInfoVO vo = (RkPaymentCheckRelationInfoVO)JsonUtil.getJsonToBean((Object)entity, RkPaymentCheckRelationInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<RkPaymentCheckRelationInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkPaymentCheckRelationEntity entity = this.rkPaymentCheckRelationService.getInfo(id);
        RkPaymentCheckRelationInfoVO vo = (RkPaymentCheckRelationInfoVO)JsonUtil.getJsonToBean((Object)entity, RkPaymentCheckRelationInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkPaymentCheckRelationUpForm rkPaymentCheckRelationUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        RkPaymentCheckRelationEntity entity = this.rkPaymentCheckRelationService.getInfo(id);
        if (entity != null) {
            RkPaymentCheckRelationEntity subentity = (RkPaymentCheckRelationEntity)JsonUtil.getJsonToBean((Object)rkPaymentCheckRelationUpForm, RkPaymentCheckRelationEntity.class);
            this.rkPaymentCheckRelationService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkPaymentCheckRelationEntity entity = this.rkPaymentCheckRelationService.getInfo(id);
        if (entity != null) {
            this.rkPaymentCheckRelationService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/getListByProcureId/{id}"})
    public ActionResult getListByProcureId(@PathVariable(value="id") String id) throws IOException {
        List<RkPaymentCheckRelationEntity> list = this.rkPaymentCheckRelationService.getListByProcureId(id);
        List listVO = JsonUtil.getJsonToList(list, RkPaymentCheckRelationListVO.class);
        for (RkPaymentCheckRelationListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity;
            RkPaymentCheckEntity rkPaymentCheckEntity;
            if (StringUtils.isNotEmpty((String)vo.getPayId())) {
                RkProcurePaymentEntity a = this.rkProcurePaymentService.getInfo(vo.getPayId());
                vo.setPaymentIllustrate(a.getPaymentIllustrate());
                vo.setPaymentAmount(a.getPaymentAmount());
                vo.setPayDate(a.getPayDate());
            }
            if (StringUtils.isNotEmpty((String)vo.getCheckId()) && (rkPaymentCheckEntity = this.rkPaymentCheckService.getInfo(vo.getCheckId())) != null) {
                vo.setCheckPaymentDate(rkPaymentCheckEntity.getCheckPaymentDate());
            }
            if ((flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getPayId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus})) != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        return ActionResult.success((Object)listVO);
    }
}

