/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkContractPaymentEntity;
import com.bringspring.contract.entity.RkContractProcureEntity;
import com.bringspring.contract.entity.RkContractTaxEntity;
import com.bringspring.contract.entity.RkProcureBreakEntity;
import com.bringspring.contract.entity.RkProcureManageEntity;
import com.bringspring.contract.entity.RkpurchaseapplydetaillistEntity;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentListVO;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectListVO;
import com.bringspring.contract.model.rkcontracttax.RkContractTaxInfoVO;
import com.bringspring.contract.model.rkprocurebreak.RkProcureBreakCrForm;
import com.bringspring.contract.model.rkprocurebreak.RkProcureBreakInfoVO;
import com.bringspring.contract.model.rkprocurebreak.RkProcureBreakListVO;
import com.bringspring.contract.model.rkprocurebreak.RkProcureBreakPagination;
import com.bringspring.contract.model.rkprocurebreak.RkProcureBreakUpForm;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkContractTaxService;
import com.bringspring.contract.service.RkProcureBreakService;
import com.bringspring.contract.service.RkProcureManageService;
import com.bringspring.contract.service.RkpurchaseapplydetaillistService;
import com.bringspring.contract.utils.Constants;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u91c7\u8d2d\u5408\u540c\u4e2d\u6b62"}, value="contract")
@RequestMapping(value={"/api/contract/RkProcureBreak"})
public class RkProcureBreakController {
    private static final Logger log = LoggerFactory.getLogger(RkProcureBreakController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProcureBreakService rkProcureBreakService;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private RkContractPaymentService rkContractPaymentService;
    @Autowired
    private RkContractTaxService rkContractTaxService;
    @Autowired
    private RkpurchaseapplydetaillistService rkpurchaseapplydetaillistService;
    @Autowired
    private RkProcureManageService rkProcureManageService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProcureBreakPagination rkProcureBreakPagination) throws IOException {
        List<RkProcureBreakEntity> list = this.rkProcureBreakService.getList(rkProcureBreakPagination);
        List listVO = JsonUtil.getJsonToList(list, RkProcureBreakListVO.class);
        for (RkProcureBreakListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProcureBreakPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkProcureBreakCrForm rkProcureBreakCrForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            String flowEngineId = "501646177666813765";
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            RkProcureBreakEntity entity = (RkProcureBreakEntity)JsonUtil.getJsonToBean((Object)((Object)rkProcureBreakCrForm), RkProcureBreakEntity.class);
            RkContractProjectListVO projectInfo = rkProcureBreakCrForm.getProjectList();
            entity.setId(mainId);
            if (entity != null) {
                if (!ObjectUtil.isEmpty((Object)entity.getAccumulatePaymentAmount()) && entity.getAccumulatePaymentAmount().compareTo(BigDecimal.ZERO) == 1) {
                    return ActionResult.fail((String)"\u8be5\u5408\u540c\u5df2\u7ecf\u5173\u8054\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u4e2d\u6b62");
                }
                if (!ObjectUtil.isEmpty((Object)entity.getNotPaymentAmount()) && entity.getNotPaymentAmount().compareTo(BigDecimal.ZERO) == 1) {
                    return ActionResult.fail((String)"\u8be5\u5408\u540c\u5df2\u7ecf\u5173\u8054\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u4e2d\u6b62");
                }
            }
            entity.setProcureType("1");
            entity.setProcureId(rkProcureBreakCrForm.getProcureId());
            entity.setProjectId(projectInfo.getId());
            entity.setCreatorTime(new Date());
            entity.setCreatorUserId(userInfo.getUserId());
            RkProcureManageEntity procureInfo = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)entity.getProcureId()));
            procureInfo.setProcureStatus("breaking");
            this.rkProcureManageService.updateById(procureInfo);
            RkContractProcureEntity info = (RkContractProcureEntity)this.rkContractProcureService.getById((Serializable)((Object)entity.getProcureId()));
            info.setProcureStatus("breaking");
            this.rkContractProcureService.updateById(info);
            if (ObjectUtil.isNotEmpty((Object)entity.getStampType())) {
                entity.setStampTypeName(this.baseDataUtil.getDictName(entity.getStampType(), Constants.STAMP_TYPE_DICT_ID));
            }
            this.rkProcureBreakService.save(entity);
            rkProcureBreakCrForm.setStampTypeName(entity.getStampTypeName());
            FlowUtil.saveOrSubmit((String)rkProcureBreakCrForm.getTaskId(), (String)flowEngineId, (String)rkProcureBreakCrForm.getTemplateId(), (String)mainId, (Object)((Object)rkProcureBreakCrForm), (Integer)rkProcureBreakCrForm.getStatus(), (String)procureInfo.getProcureName());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProcureBreakInfoVO> info(@PathVariable(value="id") String id) {
        RkProcureBreakEntity entity = this.rkProcureBreakService.getInfo(id);
        RkProcureBreakInfoVO vo = (RkProcureBreakInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProcureBreakInfoVO.class);
        vo.setProcureId(entity.getProcureId());
        List<RkContractTaxEntity> taxEntities = this.rkContractTaxService.listByContractId(id);
        if (CollectionUtil.isNotEmpty(taxEntities)) {
            List taxInfoList = JsonUtil.getJsonToList(taxEntities, RkContractTaxInfoVO.class);
            vo.setTaxList(taxInfoList);
        } else {
            vo.setTaxList(new ArrayList<RkContractTaxInfoVO>());
        }
        List<RkContractPaymentEntity> listByContractId = this.rkContractPaymentService.getListByContractId(entity.getProcureId());
        List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractPaymentListVO.class);
        vo.setPaymentMethodList(jsonToList);
        List<RkpurchaseapplydetaillistEntity> listByPurchaseApply = this.rkpurchaseapplydetaillistService.listByProcureCode(entity.getProcureCode());
        vo.setPurchaseApplyList(listByPurchaseApply);
        if (ObjectUtil.isNotEmpty((Object)entity.getProjectId())) {
            RkContractProjectListVO projectInfo1 = this.rkContractProcureService.getProjectInfo(entity.getProjectId());
            vo.setProjectList(projectInfo1);
        }
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProcureBreakUpForm rkProcureBreakUpForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            String flowEngineId = "501646177666813765";
            RkProcureBreakEntity entity = this.rkProcureBreakService.getInfo(id);
            if (entity != null) {
                RkProcureBreakEntity subentity = (RkProcureBreakEntity)JsonUtil.getJsonToBean((Object)((Object)rkProcureBreakUpForm), RkProcureBreakEntity.class);
                RkProcureManageEntity procureInfo = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)rkProcureBreakUpForm.getProcureId()));
                procureInfo.setProcureStatus("breaking");
                this.rkProcureManageService.updateById(procureInfo);
                RkContractProcureEntity info = (RkContractProcureEntity)this.rkContractProcureService.getById((Serializable)((Object)entity.getProcureId()));
                info.setProcureStatus("breaking");
                this.rkContractProcureService.updateById(info);
                this.rkProcureBreakService.update(id, subentity);
                FlowUtil.saveOrSubmit((String)rkProcureBreakUpForm.getTaskId(), (String)flowEngineId, (String)rkProcureBreakUpForm.getTemplateId(), (String)id, (Object)((Object)rkProcureBreakUpForm), (Integer)rkProcureBreakUpForm.getStatus(), (String)rkProcureBreakUpForm.getProcureName());
                return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            RkProcureBreakEntity entity = this.rkProcureBreakService.getInfo(id);
            if (entity != null) {
                FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
                if (taskEntity != null) {
                    try {
                        FlowUtil.deleteByProcessId((String)id);
                    }
                    catch (WorkFlowException e) {
                        e.printStackTrace();
                    }
                }
                this.rkProcureBreakService.delete(entity);
            }
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PutMapping(value={"/break/{id}"})
    @DSTransactional
    public ActionResult procureBreak(@PathVariable(value="id") String id, @RequestBody @Valid RkProcureBreakUpForm rkProcureBreakUpForm) throws DataException {
        Object object = this.$lock;
        synchronized (object) {
            String flowEngineId = "501646177666813765";
            UserInfo userInfo = this.userProvider.get();
            RkProcureBreakEntity entity = this.rkProcureBreakService.getInfo(id);
            entity.setProcureStatus("break");
            if (entity != null) {
                if (!ObjectUtil.isEmpty((Object)entity.getAccumulatePaymentAmount()) && entity.getAccumulatePaymentAmount().compareTo(BigDecimal.ZERO) == 1) {
                    return ActionResult.fail((String)"\u8be5\u5408\u540c\u5df2\u7ecf\u5173\u8054\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u4e2d\u6b62");
                }
                if (!ObjectUtil.isEmpty((Object)entity.getNotPaymentAmount()) && entity.getNotPaymentAmount().compareTo(BigDecimal.ZERO) == 1) {
                    return ActionResult.fail((String)"\u8be5\u5408\u540c\u5df2\u7ecf\u5173\u8054\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u4e2d\u6b62");
                }
            }
            RkProcureBreakEntity subentity = (RkProcureBreakEntity)JsonUtil.getJsonToBean((Object)((Object)rkProcureBreakUpForm), RkProcureBreakEntity.class);
            this.rkProcureBreakService.update(id, entity);
            if (FlowTaskStatusEnum.Handle.getCode().equals(rkProcureBreakUpForm.getStatus())) {
                return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85");
            }
            return ActionResult.success((String)"\u4f5c\u5e9f\u6210\u529f");
        }
    }
}

