/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractPaymentEntity;
import com.bringspring.contract.entity.RkContractProcureEntity;
import com.bringspring.contract.entity.RkProcureChangeEntity;
import com.bringspring.contract.entity.RkProcureChangeRelationEntity;
import com.bringspring.contract.entity.RkProcureManageEntity;
import com.bringspring.contract.entity.RkpurchaseapplydetaillistEntity;
import com.bringspring.contract.model.rkattachment.RkAttachmentCrForm;
import com.bringspring.contract.model.rkcontract.RkContractPaymentVO;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentListVO;
import com.bringspring.contract.model.rkcontractprocure.OaContractInternalTransactionInfo;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectListVO;
import com.bringspring.contract.model.rkprocurechange.RkProcureChangeCrForm;
import com.bringspring.contract.model.rkprocurechange.RkProcureChangeInfoVO;
import com.bringspring.contract.model.rkprocurechange.RkProcureChangeListVO;
import com.bringspring.contract.model.rkprocurechange.RkProcureChangePagination;
import com.bringspring.contract.model.rkprocurechange.RkProcureChangeUpForm;
import com.bringspring.contract.service.OaContractInternalCrmService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkProcureChangeRelationService;
import com.bringspring.contract.service.RkProcureChangeService;
import com.bringspring.contract.service.RkProcureManageService;
import com.bringspring.contract.service.RkpurchaseapplydetaillistService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.Constants;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u91c7\u8d2d\u5408\u540c\u53d8\u66f4"}, value="contract")
@RequestMapping(value={"/api/contract/RkProcureChange"})
public class RkProcureChangeController {
    private static final Logger log = LoggerFactory.getLogger(RkProcureChangeController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProcureChangeService rkProcureChangeService;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private RkContractPaymentService rkContractPaymentService;
    @Autowired
    private RkProcureChangeRelationService rkProcureChangeRelationService;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private RkProcureManageService rkProcureManageService;
    @Autowired
    private RkpurchaseapplydetaillistService rkpurchaseapplydetaillistService;
    @Autowired
    private OaContractInternalCrmService oaContractInternalCrmService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProcureChangePagination rkProcureChangePagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        String organizeId = userInfo.getOrganizeId();
        rkProcureChangePagination.setUserId(userInfo.getUserId());
        rkProcureChangePagination.setCompanyId(organizeId);
        List<RkProcureChangeEntity> list = this.rkProcureChangeService.getList(rkProcureChangePagination);
        List listVO = JsonUtil.getJsonToList(list, RkProcureChangeListVO.class);
        for (RkProcureChangeListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProcureChangePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping
    @RepeatSubmit
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkProcureChangeCrForm rkProcureChangeCrForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            Map<String, Object> temp;
            OaContractInternalTransactionInfo oaContractInternalTransactionInfo;
            String[] split;
            String flowEngineId = "499198694076388869";
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            rkProcureChangeCrForm.setChangeCode(this.baseDataUtil.getBillNumber("changeCode", Boolean.valueOf(false)));
            rkProcureChangeCrForm.setChangeId(userInfo.getUserId());
            String procureId = rkProcureChangeCrForm.getProcureId();
            RkContractProcureEntity procureInfo = this.rkContractProcureService.getInfo(procureId);
            RkProcureManageEntity info = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)procureId));
            RkProcureChangeEntity entity = (RkProcureChangeEntity)JsonUtil.getJsonToBean((Object)((Object)rkProcureChangeCrForm), RkProcureChangeEntity.class);
            entity.setManagerApplyUser(info.getManagerApplyUser());
            RkContractProjectListVO projectInfo = rkProcureChangeCrForm.getProjectList();
            entity.setId(mainId);
            entity.setProjectId(projectInfo.getId());
            entity.setSalesPerson(rkProcureChangeCrForm.getSalesPerson());
            if (ObjectUtil.isNotEmpty((Object)projectInfo.getProjectHeader())) {
                entity.setProjectManager(projectInfo.getProjectHeader());
                entity.setProjectManagerName(this.baseDataUtil.userSelectValue(entity.getProjectManager()));
            }
            if (ObjectUtil.isNotEmpty((Object)procureInfo)) {
                if (entity.getEnableMark().equals("save")) {
                    procureInfo.setProcureStatus("execute");
                    info.setProcureStatus("execute");
                } else {
                    procureInfo.setProcureStatus("changing");
                    info.setProcureStatus("changing");
                }
                this.rkContractProcureService.updateById(procureInfo);
            }
            this.rkProcureManageService.updateById(info);
            if (!ObjectUtil.isEmpty((Object)entity.getChangeDepartmentTree()) && (split = entity.getChangeDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",")).length > 0) {
                entity.setChangeDepartmentTreeName(this.baseDataUtil.comSelectValues(entity.getChangeDepartmentTree()));
                entity.setChangeDepartmentOne(split[0]);
                entity.setChangeDepartmentOneName(this.baseDataUtil.comSelectValues(entity.getChangeDepartmentOne()));
                entity.setChangeDepartment(split[split.length - 1]);
                entity.setChangeDepartmentName(this.baseDataUtil.comSelectValues(entity.getChangeDepartment()));
            }
            if (!ObjectUtil.isEmpty((Object)entity.getCStampType())) {
                entity.setCStampTypeName(this.baseDataUtil.getDictName(entity.getCStampType(), Constants.STAMP_TYPE_DICT_ID));
            }
            entity.setSalesPerson(entity.getSalesPerson());
            entity.setInvoiceTaxName(this.baseDataUtil.getDictName(entity.getInvoiceTax(), Constants.CONTRACT_TAX_RATE_DICT_ID));
            entity.setInvoiceTypeName(this.baseDataUtil.getDictName(entity.getInvoiceType(), Constants.PROCURE_INVOICE_CODE));
            entity.setPaymentMethodTypeName(this.baseDataUtil.getDictName(entity.getPaymentMethodType(), Constants.PROCURE_PAYMENT_CODE));
            String objectToString1 = JsonUtil.getObjectToString((Object)rkProcureChangeCrForm.getEditNewForm());
            entity.setEditNewForm(objectToString1);
            entity.setManagerType(info.getManagerType());
            this.rkProcureChangeService.save(entity);
            rkProcureChangeCrForm.setCStampTypeName(entity.getCStampTypeName());
            rkProcureChangeCrForm.setSalesPerson(entity.getSalesPerson());
            rkProcureChangeCrForm.setProcureAmount(entity.getProcureAmount());
            rkProcureChangeCrForm.setProjectManager(entity.getProjectManager());
            rkProcureChangeCrForm.setManagerApplyUser(entity.getManagerApplyUser());
            rkProcureChangeCrForm.setManagerType(info.getManagerType());
            if (CollectionUtil.isNotEmpty(rkProcureChangeCrForm.getPaymentMethodList())) {
                List<RkContractPaymentVO> paymentMethodList = rkProcureChangeCrForm.getPaymentMethodList();
                paymentMethodList.stream().forEach(payment -> {
                    if (!ObjectUtil.isEmpty((Object)payment.getPaymentName()) && ObjectUtil.isEmpty((Object)payment.getPaymentType())) {
                        payment.setPaymentType(PinyinUtil.getFirstLetter((String)payment.getPaymentName(), (String)"").toUpperCase());
                    }
                });
                String objectToString = JsonUtil.getObjectToString(paymentMethodList);
                entity.setPaymentJson(objectToString);
                List jsonToList = JsonUtil.getJsonToList(paymentMethodList, RkContractPaymentEntity.class);
                jsonToList.stream().forEach(payment -> {
                    payment.setContractId(entity.getId());
                    payment.setId(RandomUtil.uuId());
                });
                this.rkContractPaymentService.saveBatch(jsonToList);
            }
            if (CollectionUtil.isNotEmpty(rkProcureChangeCrForm.getAttachmentList())) {
                this.attachmentService.deleteByContractId(entity.getId(), AttachmentTypeEnum.CONTRACT_TYPE.getType());
                List<RkAttachmentCrForm> attachmentList = rkProcureChangeCrForm.getAttachmentList();
                attachmentList.stream().forEach(attach -> {
                    attach.setContractId(mainId);
                    attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
                });
                List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
                this.attachmentService.saveOrUpdateBatch(attachmentEntityList);
            }
            RkProcureChangeRelationEntity changeRelationEntity = new RkProcureChangeRelationEntity();
            changeRelationEntity.setProcureId(procureId);
            changeRelationEntity.setChangeId(entity.getId());
            changeRelationEntity.setId(RandomUtil.uuId());
            changeRelationEntity.setCreatorUserId(userInfo.getUserId());
            changeRelationEntity.setCreatorTime(new Date());
            this.rkProcureChangeRelationService.save(changeRelationEntity);
            if (!ObjectUtil.isNotNull((Object)info) && !ObjectUtil.isEmpty((Object)info)) {
                RkProcureChangeEntity changInfo = this.rkProcureChangeService.getInfo(entity.getId());
                changInfo.setCDeliveryTime(info.getDeliveryTime());
                changInfo.setCInvoiceTax(info.getInvoiceTax());
                changInfo.setCInvoiceTaxName(info.getInvoiceTaxName());
                changInfo.setCProcureAmount(info.getProcureAmount());
                changInfo.setCProcureAmountBig(info.getProcureAmountBig());
                changInfo.setCProcureName(info.getProcureName());
                changInfo.setProcureCode(info.getProcureCode());
                changInfo.setCSupplierId(info.getSupplierId());
                changInfo.setCSupplierName(info.getSupplierName());
                changInfo.setCSupplierBank(info.getSupplierBank());
                changInfo.setCSupplierAccount(info.getSupplierAccount());
                changInfo.setCInvoiceType(info.getInvoiceType());
                changInfo.setCInvoiceTypeName(info.getInvoiceTypeName());
                changInfo.setCInvoiceTax(info.getInvoiceTax());
                changInfo.setCInvoiceTaxName(info.getInvoiceTaxName());
                changInfo.setCWarranty(info.getWarranty());
                changInfo.setAccumulatePaymentAmount(info.getAccumulatePaymentAmount());
                changInfo.setNotPaymentAmount(info.getNotPaymentAmount());
                this.rkProcureChangeService.updateById(changInfo);
            }
            if (ObjectUtil.isNotEmpty((Object)info.getInternalContractId()) && ObjectUtil.isNotEmpty((Object)(oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean(temp = this.oaContractInternalCrmService.getInfoById(info.getInternalContractId()), OaContractInternalTransactionInfo.class)))) {
                rkProcureChangeCrForm.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
                rkProcureChangeCrForm.setInteralContractApplyUser(oaContractInternalTransactionInfo.getApplyUserId());
            }
            FlowUtil.saveOrSubmit((String)rkProcureChangeCrForm.getTaskId(), (String)flowEngineId, (String)rkProcureChangeCrForm.getTemplateId(), (String)mainId, (Object)((Object)rkProcureChangeCrForm), (Integer)rkProcureChangeCrForm.getStatus(), (String)rkProcureChangeCrForm.getProcureName());
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProcureChangeInfoVO> info(@PathVariable(value="id") String id) {
        Map<String, Object> temp;
        OaContractInternalTransactionInfo oaContractInternalTransactionInfo;
        RkProcureChangeEntity entity = this.rkProcureChangeService.getInfo(id);
        RkProcureChangeInfoVO vo = (RkProcureChangeInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProcureChangeInfoVO.class);
        String[] split = entity.getChangeDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",");
        vo.setChangeDepartmentTree(Arrays.asList(split));
        String[] split1 = entity.getApplyDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",");
        vo.setApplyDepartmentTree(Arrays.asList(split1));
        vo.setChangeId(this.baseDataUtil.userSelectValue(vo.getChangeId()));
        if (vo.getChangeDate() != null) {
            vo.setChangeDate(vo.getChangeDate());
        }
        vo.setChangeId(entity.getChangeId());
        vo.setChangeDepartmentTreeName(this.baseDataUtil.comSelectValues(entity.getChangeDepartmentTree()));
        vo.setChangeName(this.baseDataUtil.userSelectValueNoAccount(entity.getChangeId()));
        vo.setPaymentMethodTypeName(this.baseDataUtil.getDictName(entity.getPaymentMethodType(), Constants.PROCURE_PAYMENT_CODE));
        vo.setChangeContent(vo.getChangeContent());
        vo.setChangeReason(vo.getChangeReason());
        vo.setInvoiceTaxName(this.baseDataUtil.getDictName(vo.getInvoiceTax(), Constants.CONTRACT_TAX_RATE_DICT_ID));
        vo.setChangeCode(vo.getChangeCode());
        vo.setInvoiceTypeName(this.baseDataUtil.getDictName(vo.getInvoiceType(), Constants.PROCURE_INVOICE_CODE));
        vo.setProcureAmount(vo.getProcureAmount());
        vo.setDeliveryTime(vo.getDeliveryTime());
        vo.setSupplierName(entity.getSupplierName());
        vo.setSupplierBank(vo.getSupplierBank());
        vo.setSupplierAccount(vo.getSupplierAccount());
        vo.setWarranty(vo.getWarranty());
        vo.setEditNewForm(vo.getEditNewForm());
        List<RkContractPaymentEntity> listByChangeId = this.rkContractPaymentService.getListByContractId(id);
        List changeList = JsonUtil.getJsonToList(listByChangeId, RkContractPaymentListVO.class);
        vo.setPaymentMethodList(changeList);
        RkProcureChangeRelationEntity byProcureId = this.rkProcureChangeRelationService.getByProcureId(id);
        String procureId = byProcureId.getProcureId();
        vo.setProcureId(procureId);
        List<RkpurchaseapplydetaillistEntity> listByPurchaseApply = this.rkpurchaseapplydetaillistService.listByProcureCode(entity.getProcureCode());
        vo.setPurchaseApplyList(listByPurchaseApply);
        if (ObjectUtil.isNotEmpty((Object)entity.getProjectId())) {
            RkContractProjectListVO projectInfo1 = this.rkContractProcureService.getProjectInfo(entity.getProjectId());
            vo.setProjectList(projectInfo1);
        }
        vo.setPartyAName(this.baseDataUtil.getDictName(entity.getPartyA(), "ContractInternalTransactionSignSubject"));
        RkProcureManageEntity procureManager = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)procureId));
        if (ObjectUtil.isNotEmpty((Object)procureManager.getInternalContractId()) && ObjectUtil.isNotEmpty((Object)(oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean(temp = this.oaContractInternalCrmService.getInfoById(procureManager.getInternalContractId()), OaContractInternalTransactionInfo.class)))) {
            vo.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
            vo.setInteralContractApplyUser(oaContractInternalTransactionInfo.getApplyUserId());
        }
        vo.setManagerApplyUser(procureManager.getManagerApplyUser());
        vo.setManagerType(procureManager.getManagerType());
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProcureChangeUpForm rkProcureChangeUpForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            String flowEngineId = "499198694076388869";
            UserInfo userInfo = this.userProvider.get();
            RkProcureChangeEntity entity = this.rkProcureChangeService.getInfo(id);
            if (entity != null) {
                Map<String, Object> temp;
                OaContractInternalTransactionInfo oaContractInternalTransactionInfo;
                RkProcureChangeEntity subentity = (RkProcureChangeEntity)JsonUtil.getJsonToBean((Object)((Object)rkProcureChangeUpForm), RkProcureChangeEntity.class);
                subentity.setChangeId(entity.getChangeId());
                subentity.setChangeDate(entity.getChangeDate());
                String procureId = rkProcureChangeUpForm.getProcureId();
                RkProcureManageEntity procureInfo = this.rkProcureManageService.getInfo(procureId);
                if (subentity.getEnableMark().equals("save")) {
                    procureInfo.setProcureStatus("execute");
                } else {
                    procureInfo.setProcureStatus("changing");
                }
                this.rkProcureManageService.updateById(procureInfo);
                rkProcureChangeUpForm.setManagerApplyUser(procureInfo.getManagerApplyUser());
                this.rkProcureChangeService.updateChange(id, rkProcureChangeUpForm);
                rkProcureChangeUpForm.setManagerType(procureInfo.getManagerType());
                rkProcureChangeUpForm.setProcureAmount(entity.getProcureAmount());
                rkProcureChangeUpForm.setCStampTypeName(entity.getCStampTypeName());
                rkProcureChangeUpForm.setSalesPerson(entity.getSalesPerson());
                rkProcureChangeUpForm.setProjectManager(entity.getProjectManager());
                if (ObjectUtil.isNotEmpty((Object)procureInfo.getInternalContractId()) && ObjectUtil.isNotEmpty((Object)(oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean(temp = this.oaContractInternalCrmService.getInfoById(procureInfo.getInternalContractId()), OaContractInternalTransactionInfo.class)))) {
                    rkProcureChangeUpForm.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
                    rkProcureChangeUpForm.setInteralContractApplyUser(oaContractInternalTransactionInfo.getApplyUserId());
                }
                FlowUtil.saveOrSubmit((String)rkProcureChangeUpForm.getTaskId(), (String)flowEngineId, (String)rkProcureChangeUpForm.getTemplateId(), (String)id, (Object)((Object)rkProcureChangeUpForm), (Integer)rkProcureChangeUpForm.getStatus(), (String)rkProcureChangeUpForm.getProcureName());
                return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkProcureChangeEntity entity = this.rkProcureChangeService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.rkProcureChangeService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/getListByProcureId/{id}"})
    public ActionResult getListByProcureId(@PathVariable(value="id") String procureId) throws IOException {
        List<RkProcureChangeRelationEntity> list = this.rkProcureChangeRelationService.getListByProcureId(procureId);
        List changeids = list.stream().map(RkProcureChangeRelationEntity::getChangeId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(changeids)) {
            List changeList = this.rkProcureChangeService.listByIds(changeids);
            for (RkProcureChangeEntity entity : changeList) {
                entity.setChangeId(this.baseDataUtil.userSelectValue(entity.getChangeId()));
                entity.setInvoiceTax(this.baseDataUtil.getDictName(entity.getInvoiceTax(), ""));
                entity.setInvoiceType(this.baseDataUtil.getDictName(entity.getInvoiceType(), ""));
                entity.setPaymentMethodType(this.baseDataUtil.getDictName(entity.getPaymentMethodType(), ""));
                entity.setStampType(this.baseDataUtil.getDictName(entity.getStampType(), ""));
                entity.setSupplierId(this.baseDataUtil.userSelectValueNoAccount(entity.getSupplierId()));
            }
            List listVO = JsonUtil.getJsonToList((Object)changeList, RkProcureChangeListVO.class);
            for (RkProcureChangeListVO vo : listVO) {
                FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
                if (flowTaskEntity != null) {
                    vo.setFlowState(flowTaskEntity.getStatus());
                    continue;
                }
                vo.setFlowState(null);
            }
            return ActionResult.success((Object)listVO);
        }
        List listVO = CollectionUtil.list((boolean)false);
        return ActionResult.success((Object)listVO);
    }
}

