/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractPaymentEntity;
import com.bringspring.contract.entity.RkContractProcureEntity;
import com.bringspring.contract.entity.RkContractTaxEntity;
import com.bringspring.contract.entity.RkProcureInvoiceDetailRelEntity;
import com.bringspring.contract.entity.RkProcureInvoiceEntity;
import com.bringspring.contract.entity.RkProcureInvoiceManageEntity;
import com.bringspring.contract.entity.RkProcureInvoiceRelationEntity;
import com.bringspring.contract.entity.RkProcureManageEntity;
import com.bringspring.contract.model.rkattachment.RkAttachmentCrForm;
import com.bringspring.contract.model.rkcontract.ContractImportVO;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentListVO;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectListVO;
import com.bringspring.contract.model.rkcontracttax.RkContractTaxInfoVO;
import com.bringspring.contract.model.rkprocureinvoice.RkProcureInvoiceExportVO;
import com.bringspring.contract.model.rkprocureinvoice.RkProcureInvoiceListVO;
import com.bringspring.contract.model.rkprocureinvoice.RkProcureInvoicePagination;
import com.bringspring.contract.model.rkprocureinvoice.RkProcureInvoicePaginationExportModel;
import com.bringspring.contract.model.rkprocureinvoice.RkProcureInvoiceUpForm;
import com.bringspring.contract.model.rkprocureinvoicedetailrel.RkProcureInvoiceDetailRelListVO;
import com.bringspring.contract.model.rkprocureinvoicemanage.RkInvoiceDetailVO;
import com.bringspring.contract.model.rkprocureinvoicemanage.RkInvoiceManageImportReturnVO;
import com.bringspring.contract.model.rkprocureinvoicemanage.RkInvoiceManageImportVO;
import com.bringspring.contract.model.rkprocureinvoicemanage.RkProcureInvoiceManageCrForm;
import com.bringspring.contract.model.rkprocureinvoicemanage.RkProcureInvoiceManageInfoVO;
import com.bringspring.contract.model.rkprocureinvoicemanage.RkProcureInvoiceManageListVO;
import com.bringspring.contract.model.rkprocureinvoicemanage.RkProcureInvoiceManagePagination;
import com.bringspring.contract.model.rkprocureinvoicemanage.RkProcureInvoiceManageUpForm;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProcureRelationService;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractTaxService;
import com.bringspring.contract.service.RkProcureInvoiceDetailRelService;
import com.bringspring.contract.service.RkProcureInvoiceManageService;
import com.bringspring.contract.service.RkProcureInvoiceRelationService;
import com.bringspring.contract.service.RkProcureInvoiceService;
import com.bringspring.contract.service.RkProcureManageService;
import com.bringspring.contract.service.RkProcurePaymentService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u91c7\u8d2d\u53d1\u7968\u767b\u8bb0"}, value="contract")
@RequestMapping(value={"/api/contract/RkProcureInvoiceManage"})
public class RkProcureInvoiceManageController {
    private static final Logger log = LoggerFactory.getLogger(RkProcureInvoiceManageController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProcureInvoiceManageService rkProcureInvoiceManageService;
    @Autowired
    private RkProcureInvoiceRelationService rkProcureInvoiceRelationService;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private RkContractProcureRelationService rkContractProcureRelationService;
    @Autowired
    private RkProcurePaymentService rkProcurePaymentService;
    @Autowired
    private RkProcureInvoiceDetailRelService rkProcureInvoiceDetailRelService;
    @Autowired
    private RkContractPaymentService rkContractPaymentService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RkContractTaxService rkContractTaxService;
    @Autowired
    private RkProcureInvoiceService rkProcureInvoiceService;
    @Autowired
    private RkProcureManageService rkProcureManageService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProcureInvoiceManagePagination rkProcureInvoiceManagePagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        String organizeId = userInfo.getOrganizeId();
        rkProcureInvoiceManagePagination.setUserId(userInfo.getUserId());
        rkProcureInvoiceManagePagination.setCompanyId(organizeId);
        List<RkProcureInvoiceManageEntity> list = this.rkProcureInvoiceManageService.getList(rkProcureInvoiceManagePagination);
        for (RkProcureInvoiceManageEntity rkProcureInvoiceManageEntity : list) {
            rkProcureInvoiceManageEntity.setApplyId(this.baseDataUtil.userSelectValueNoAccount(rkProcureInvoiceManageEntity.getApplyId()));
            rkProcureInvoiceManageEntity.setInvoiceTax(this.baseDataUtil.getDictName(rkProcureInvoiceManageEntity.getInvoiceTax(), ""));
            rkProcureInvoiceManageEntity.setInvoiceTypeName(this.baseDataUtil.getDictName(rkProcureInvoiceManageEntity.getInvoiceType(), Constants.INVOICE_REGISTER_CODE));
            rkProcureInvoiceManageEntity.setInvoicePattern(this.baseDataUtil.getDictName(rkProcureInvoiceManageEntity.getInvoicePattern(), ""));
        }
        List listVO = JsonUtil.getJsonToList(list, RkProcureInvoiceManageListVO.class);
        for (RkProcureInvoiceManageListVO rkProcureInvoiceManageVO : listVO) {
            List<RkProcureInvoiceDetailRelEntity> listByInvoiceId = this.rkProcureInvoiceDetailRelService.listByInvoiceId(rkProcureInvoiceManageVO.getId());
            rkProcureInvoiceManageVO.setInvoiceDetailList(listByInvoiceId);
            List<RkProcureInvoiceRelationEntity> listByProcureId = this.rkProcureInvoiceRelationService.listByProcureId(rkProcureInvoiceManageVO.getId());
            List collect = listByProcureId.stream().map(RkProcureInvoiceRelationEntity::getProcureId).collect(Collectors.toList());
            List procureList = this.rkProcureManageService.listByIds(collect);
            rkProcureInvoiceManageVO.setProcureInfoList(procureList);
            procureList.stream().forEach(procure -> {
                if (ObjectUtil.isNotEmpty((Object)procure.getProjectId())) {
                    RkContractProjectListVO projectInfo = this.rkContractProcureService.getProjectInfo(procure.getProjectId());
                    rkProcureInvoiceManageVO.setProjectInfo(projectInfo);
                }
            });
        }
        for (RkProcureInvoiceManageListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProcureInvoiceManagePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkProcureInvoiceManageCrForm rkProcureInvoiceManageCrForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            String[] split;
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            String organizeId = userInfo.getOrganizeId();
            rkProcureInvoiceManageCrForm.setCompanyId(organizeId);
            rkProcureInvoiceManageCrForm.setInvoiceCode(this.baseDataUtil.getBillNumber("InvoiceCode", Boolean.valueOf(false)));
            RkProcureInvoiceManageEntity entity = (RkProcureInvoiceManageEntity)JsonUtil.getJsonToBean((Object)rkProcureInvoiceManageCrForm, RkProcureInvoiceManageEntity.class);
            entity.setId(mainId);
            if (!ObjectUtil.isEmpty((Object)entity.getApplyDepartmentTree()) && (split = entity.getApplyDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",")).length > 0) {
                entity.setApplyDepartmentTreeName(this.baseDataUtil.comSelectValues(entity.getApplyDepartmentTree()));
                entity.setApplyDepartmentOne(split[0]);
                entity.setApplyDepartmentOneName(this.baseDataUtil.comSelectValues(entity.getApplyDepartmentOne()));
                entity.setApplyDepartment(split[split.length - 1]);
                entity.setApplyDepartmentName(this.baseDataUtil.comSelectValues(entity.getApplyDepartment()));
            }
            entity.setInvoiceTaxName(this.baseDataUtil.getDictName(entity.getInvoiceTax(), ""));
            entity.setInvoiceTypeName(this.baseDataUtil.getDictName(entity.getInvoiceType(), Constants.PROCURE_INVOICE_CODE));
            entity.setBillNumber(entity.getBillNumber());
            entity.setCreatorUserId(userInfo.getUserId());
            entity.setCreatorTime(new Date());
            entity.setPrintDate(entity.getCreatorTime());
            entity.setCheckInvoice(entity.getInvoiceAmount());
            String procureId = rkProcureInvoiceManageCrForm.getProcureId();
            RkProcureInvoiceRelationEntity relationEntity = new RkProcureInvoiceRelationEntity();
            relationEntity.setInvoiceId(entity.getId());
            relationEntity.setProcureId(procureId);
            relationEntity.setId(RandomUtil.uuId());
            relationEntity.setCreatorTime(new Date());
            relationEntity.setCreatorUserId(userInfo.getUserId());
            this.rkProcureInvoiceRelationService.save(relationEntity);
            if (CollectionUtil.isNotEmpty(rkProcureInvoiceManageCrForm.getInvoiceDetailList())) {
                List<RkInvoiceDetailVO> invoiceDetailList = rkProcureInvoiceManageCrForm.getInvoiceDetailList();
                invoiceDetailList.stream().forEach(invoiceDetail -> {
                    invoiceDetail.setId(RandomUtil.uuId());
                    invoiceDetail.setInvoiceId(entity.getId());
                    invoiceDetail.setInvoiceTax(this.baseDataUtil.getDictName(invoiceDetail.getInvoiceTax(), ""));
                    invoiceDetail.setGoodsId(invoiceDetail.getGoodsId());
                });
                String objectToString = JsonUtil.getObjectToString(invoiceDetailList);
                entity.setInvoiceDetailJson(objectToString);
                List jsonToList = JsonUtil.getJsonToList(invoiceDetailList, RkProcureInvoiceDetailRelEntity.class);
                jsonToList.stream().forEach(t -> {
                    t.setCreatorTime(new Date());
                    t.setCreatorUserId(userInfo.getUserId());
                });
                this.rkProcureInvoiceDetailRelService.saveBatch(jsonToList);
            } else {
                RkProcureInvoiceRelationEntity invoiceRelationEntity = new RkProcureInvoiceRelationEntity();
                invoiceRelationEntity.setId(RandomUtil.uuId());
                invoiceRelationEntity.setInvoiceId(entity.getId());
                invoiceRelationEntity.setCreatorTime(new Date());
                invoiceRelationEntity.setCreatorUserId(userInfo.getUserId());
                this.rkProcureInvoiceRelationService.save(invoiceRelationEntity);
            }
            List<RkAttachmentCrForm> attachmentList = rkProcureInvoiceManageCrForm.getAttachmentList();
            attachmentList.stream().forEach(attach -> {
                attach.setContractId(mainId);
                attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
            this.rkAttachmentService.saveBatch(attachmentEntityList);
            this.rkProcureInvoiceManageService.save(entity);
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProcureInvoiceManageInfoVO> info(@PathVariable(value="id") String id) {
        RkProcureInvoiceManageEntity entity = this.rkProcureInvoiceManageService.getInfo(id);
        RkProcureInvoiceManageInfoVO vo = (RkProcureInvoiceManageInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProcureInvoiceManageInfoVO.class);
        if (StringUtils.isNotEmpty((String)entity.getApplyDepartmentTree())) {
            String[] split = entity.getApplyDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",");
            vo.setApplyDepartmentTree(Arrays.asList(split));
        }
        if (vo.getApplyDate() != null) {
            vo.setApplyDate(vo.getApplyDate());
        }
        vo.setInvoiceTypeName(this.baseDataUtil.getDictName(entity.getInvoiceType(), Constants.INVOICE_REGISTER_CODE));
        vo.setInvoicePatternName(this.baseDataUtil.getDictName(entity.getInvoicePattern(), ""));
        List<RkProcureInvoiceDetailRelEntity> listByInvoiceId = this.rkProcureInvoiceDetailRelService.listByInvoiceId(id);
        List jsonToList2 = JsonUtil.getJsonToList(listByInvoiceId, RkProcureInvoiceDetailRelListVO.class);
        vo.setInvoiceDetailList(jsonToList2);
        List<RkProcureInvoiceRelationEntity> listByProcureId = this.rkProcureInvoiceRelationService.listByProcureId(id);
        List collect = listByProcureId.stream().map(RkProcureInvoiceRelationEntity::getProcureId).collect(Collectors.toList());
        List procureList = this.rkProcureManageService.listByIds(collect);
        procureList.stream().forEach(procure -> {
            procure.setPaymentMethodTypeName(this.baseDataUtil.getDictName(procure.getPaymentMethodType(), Constants.PROCURE_PAYMENT_CODE));
            procure.setInvoiceTaxName(this.baseDataUtil.getDictName(procure.getInvoiceTax(), Constants.CONTRACT_TAX_RATE_DICT_ID));
            procure.setApplyName(this.baseDataUtil.userSelectValueNoAccount(procure.getApplyId()));
            procure.setInvoiceTypeName(this.baseDataUtil.getDictName(procure.getInvoiceType(), Constants.PROCURE_INVOICE_CODE));
            List<RkContractTaxEntity> taxEntities = this.rkContractTaxService.listByContractId(id);
            if (CollectionUtil.isNotEmpty(taxEntities)) {
                List taxInfoList = JsonUtil.getJsonToList(taxEntities, RkContractTaxInfoVO.class);
                procure.setTaxList(taxInfoList);
            } else {
                procure.setTaxList(new ArrayList<RkContractTaxInfoVO>());
            }
            List<RkAttachmentEntity> attachmentList = this.rkAttachmentService.getListByContractId(procure.getId());
            procure.setAttachmentList(attachmentList);
            List<RkContractPaymentEntity> listByContractId = this.rkContractPaymentService.getListByContractId(procure.getId());
            List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractPaymentListVO.class);
            procure.setPaymentMethodList(jsonToList);
            List<RkProcureInvoiceRelationEntity> listByInvoice = this.rkProcureInvoiceRelationService.listByInvoice(procure.getId());
            List collect2 = listByInvoice.stream().map(RkProcureInvoiceRelationEntity::getPayId).collect(Collectors.toList());
            List payList = this.rkProcurePaymentService.listByIds(collect2);
            procure.setPayList(payList);
            List<RkProcureInvoiceRelationEntity> listByInvoiceInfo = this.rkProcureInvoiceRelationService.listByInvoice(procure.getId());
            List collect3 = listByInvoiceInfo.stream().map(RkProcureInvoiceRelationEntity::getInvoiceId).collect(Collectors.toList());
            List invoiceList = this.rkProcureInvoiceService.listByIds(collect3);
            procure.setInvoiceList(invoiceList);
            if (ObjectUtil.isNotEmpty((Object)procure.getProjectId())) {
                RkContractProjectListVO projectInfo = this.rkContractProcureService.getProjectInfo(procure.getProjectId());
                procure.setProjectList(projectInfo);
            }
        });
        vo.setProcureList(procureList);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProcureInvoiceManageUpForm rkProcureInvoiceManageUpForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            RkProcureInvoiceManageEntity entity = this.rkProcureInvoiceManageService.getInfo(id);
            if (entity != null) {
                RkProcureInvoiceManageEntity subentity = (RkProcureInvoiceManageEntity)JsonUtil.getJsonToBean((Object)rkProcureInvoiceManageUpForm, RkProcureInvoiceManageEntity.class);
                subentity.setApplyDate(entity.getApplyDate());
                rkProcureInvoiceManageUpForm.setInvoiceTypeName(this.baseDataUtil.getDictName(rkProcureInvoiceManageUpForm.getInvoiceType(), ""));
                this.rkProcureInvoiceManageService.updateInvoice(id, rkProcureInvoiceManageUpForm);
                return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            RkProcureInvoiceManageEntity entity = this.rkProcureInvoiceManageService.getInfo(id);
            if (entity != null) {
                this.rkProcureInvoiceManageService.delete(entity);
                this.rkProcureInvoiceRelationService.removeByProcureId(entity.getId());
            }
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/invoiceCancel/{id}"})
    @DSTransactional
    public ActionResult invoiceCancel(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            RkProcureInvoiceManageEntity entity = this.rkProcureInvoiceManageService.getInfo(id);
            entity.setInvoiceStatus("0");
            entity.setEnableMark("cancel");
            RkProcureInvoiceRelationEntity invoiceRelation = this.rkProcureInvoiceRelationService.getInfoByPayId(id);
            String procureId = invoiceRelation.getProcureId();
            RkProcureManageEntity procureEntity = this.rkProcureManageService.getInfo(procureId);
            procureEntity.setAccumulateInvoiceAmount(MathUtils.substract(procureEntity.getAccumulateInvoiceAmount(), entity.getInvoiceAmount()));
            this.rkProcureManageService.updateById(procureEntity);
            RkProcureInvoiceEntity jsonToBean = (RkProcureInvoiceEntity)JsonUtil.getJsonToBean((Object)entity, RkProcureInvoiceEntity.class);
            this.rkProcureInvoiceService.updateById(jsonToBean);
            this.rkProcureInvoiceManageService.update(id, entity);
            return ActionResult.success((String)"\u4f5c\u5e9f\u6210\u529f");
        }
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult<Object> Uploader() {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().endsWith(".xlsx") || file.getOriginalFilename().endsWith(".xls")) {
            String filePath = XSSEscape.escape((String)this.configValueUtil.getTemporaryFilePath());
            String fileName = XSSEscape.escape((String)(RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file)));
            FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
            try {
                UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)(filePath + fileName), (String)"temporary", (String)fileName);
            }
            catch (IOException e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            DownloadVO vo = DownloadVO.builder().build();
            vo.setName(fileName);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u91c7\u8d2d\u53d1\u7968\u5bfc\u5165\u6a21\u677f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u91c7\u8d2d\u53d1\u7968\u5bfc\u5165\u6a21\u677f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List fileImportList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, RkInvoiceManageImportVO.class);
        if (CollectionUtil.isEmpty((Collection)fileImportList)) {
            return ActionResult.fail((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fileImportList.size() > 100) {
            return ActionResult.fail((String)"\u6700\u591a\u5bfc\u5165\u6570\u636e100\u6761");
        }
        Map<String, Object> map = this.rkProcureInvoiceManageService.importPreview(fileImportList, new RkInvoiceManageImportVO());
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<RkInvoiceManageImportReturnVO> ImportData(@RequestBody RkInvoiceManageImportVO data) throws DataException {
        List dataList = JsonUtil.getJsonToList(data.getList(), RkInvoiceManageImportVO.class);
        RkInvoiceManageImportReturnVO result = this.rkProcureInvoiceManageService.importData(dataList);
        return ActionResult.success((Object)result);
    }

    @ApiOperation(value="\u5bfc\u51fa\u9519\u8bef\u62a5\u544a")
    @PostMapping(value={"/ExportExceptionData"})
    public ActionResult<DownloadVO> exportExceptionData(@RequestBody ContractImportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), Object.class);
        DownloadVO vo = this.rkProcureInvoiceService.exportExceptionData(dataList, new ContractImportVO());
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkProcureInvoicePaginationExportModel rkProcureInvoicePaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkProcureInvoicePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkProcureInvoicePagination paymentPagination = (RkProcureInvoicePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkProcureInvoicePaginationExportModel), RkProcureInvoicePagination.class));
        String organizeId = this.userProvider.get().getOrganizeId();
        paymentPagination.setOrganizeId(organizeId);
        List<RkProcureInvoiceEntity> list = this.rkProcureInvoiceService.getTypeList(paymentPagination, rkProcureInvoicePaginationExportModel.getDataType());
        for (RkProcureInvoiceEntity rkProcureInvoiceEntity : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, RkProcureInvoiceExportVO.class);
        List relationList = this.rkProcureInvoiceRelationService.list((Wrapper)new QueryWrapper());
        List procureList = this.rkContractProcureService.list((Wrapper)new QueryWrapper());
        List contractRelationList = this.rkContractProcureRelationService.list((Wrapper)new QueryWrapper());
        List contractList = this.contractService.list((Wrapper)new QueryWrapper());
        for (RkProcureInvoiceExportVO rkProcureInvoiceListVO : listVO) {
            RkContractProcureEntity matchProcureEntity;
            List matchProcure;
            List matchRelation = relationList.stream().filter(a -> a.getInvoiceId().equals(rkProcureInvoiceListVO.getId())).collect(Collectors.toList());
            if (matchRelation.isEmpty() || (matchProcure = procureList.stream().filter(a -> a.getId().equals(((RkProcureInvoiceRelationEntity)matchRelation.get(0)).getProcureId())).collect(Collectors.toList())).isEmpty() || !ObjectUtil.isNotEmpty((Object)(matchProcureEntity = (RkContractProcureEntity)matchProcure.get(0)))) continue;
            rkProcureInvoiceListVO.setProcureCode(matchProcureEntity.getProcureCode());
            rkProcureInvoiceListVO.setProcureName(matchProcureEntity.getProcureName());
            rkProcureInvoiceListVO.setProcureAmount(matchProcureEntity.getProcureAmount().toString());
            rkProcureInvoiceListVO.setSupplierName(matchProcureEntity.getSupplierName());
            rkProcureInvoiceListVO.setContractCode("");
            rkProcureInvoiceListVO.setContractAmount("");
            rkProcureInvoiceListVO.setContractName("");
            rkProcureInvoiceListVO.setAgentName("");
            rkProcureInvoiceListVO.setInvoiceStatus("0".equals(rkProcureInvoiceListVO.getInvoiceStatus()) ? "\u5df2\u4f5c\u5e9f" : "\u5df2\u767b\u8bb0");
            rkProcureInvoiceListVO.setEnableMark(StringUtils.isEmpty((String)rkProcureInvoiceListVO.getEnableMark()) ? "\u672a\u63d0\u4ea4" : (rkProcureInvoiceListVO.getEnableMark().equals("history") ? "\u5386\u53f2\u6570\u636e" : (rkProcureInvoiceListVO.getEnableMark().equals("complete") ? "\u5ba1\u6838\u901a\u8fc7" : "\u672a\u63d0\u4ea4")));
            contractRelationList.stream().filter(a -> a.getProcureId().equals(matchProcureEntity.getId())).forEach(a -> {
                List temp = contractList.stream().filter(b -> b.getId().equals(a.getContractId())).collect(Collectors.toList());
                rkProcureInvoiceListVO.setContractCode(rkProcureInvoiceListVO.getContractCode() + temp.stream().map(RkContractEntity::getContractCode).collect(Collectors.joining()) + ";");
                rkProcureInvoiceListVO.setContractName(rkProcureInvoiceListVO.getContractName() + temp.stream().map(RkContractEntity::getContractName).collect(Collectors.joining()) + ";");
                rkProcureInvoiceListVO.setContractAmount(rkProcureInvoiceListVO.getContractAmount() + temp.stream().map(RkContractEntity::getContractAmount).map(BigDecimal::toString).collect(Collectors.joining()));
            });
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkProcureInvoicePaginationExportModel.getSelectKey()) ? rkProcureInvoicePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block50: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "applyName": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5458", (Object)"applyName"));
                        continue block50;
                    }
                    case "applyDate": {
                        entitys.add(new ExcelExportEntity("\u767b\u8bb0\u65e5\u671f", (Object)"applyDate"));
                        continue block50;
                    }
                    case "applyDepartmentName": {
                        entitys.add(new ExcelExportEntity("\u767b\u8bb0\u4eba\u90e8\u95e8", (Object)"applyDepartmentName"));
                        continue block50;
                    }
                    case "procureCode": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u53f7", (Object)"procureCode"));
                        continue block50;
                    }
                    case "procureName": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u540d\u79f0", (Object)"procureName"));
                        continue block50;
                    }
                    case "supplierName": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u540d\u79f0", (Object)"supplierName"));
                        continue block50;
                    }
                    case "procureAmount": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u91d1\u989d(\u5143)", (Object)"procureAmount"));
                        continue block50;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block50;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block50;
                    }
                    case "invoiceAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u6b21\u53d1\u7968\u5408\u8ba1(\u5143)", (Object)"invoiceAmount"));
                        continue block50;
                    }
                    case "billNumber": {
                        entitys.add(new ExcelExportEntity("\u7968\u636e\u53f7", (Object)"billNumber"));
                        continue block50;
                    }
                    case "invoiceStatus": {
                        entitys.add(new ExcelExportEntity("\u53d1\u7968\u72b6\u6001", (Object)"invoiceStatus"));
                        continue block50;
                    }
                    case "invoiceDate": {
                        entitys.add(new ExcelExportEntity("\u5f00\u7968\u65e5\u671f", (Object)"invoiceDate"));
                        continue block50;
                    }
                    case "invoiceTypeName": {
                        entitys.add(new ExcelExportEntity("\u53d1\u7968\u7c7b\u578b", (Object)"invoiceTypeName"));
                        continue block50;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u5bf9\u8c61 ", (Object)"agentName"));
                        continue block50;
                    }
                    case "contractAmount": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u91d1\u989d(\u5143)", (Object)"contractAmount"));
                        continue block50;
                    }
                    case "enableMark": {
                        entitys.add(new ExcelExportEntity("\u5ba1\u6279\u72b6\u6001 ", (Object)"enableMark"));
                        continue block50;
                    }
                    case "checkInvoice": {
                        entitys.add(new ExcelExportEntity("\u5f85\u6838\u9500\u91d1\u989d(\u5143)", (Object)"checkInvoice"));
                        continue block50;
                    }
                    case "invoiceCode": {
                        entitys.add(new ExcelExportEntity("\u53d1\u7968\u5355\u636e\u53f7 ", (Object)"invoiceCode"));
                        continue block50;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u91c7\u8d2d\u4ed8\u6b3e\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/getInvoiceListByProcureId/{id}"})
    public ActionResult getInvoiceListByProcureId(@PathVariable(value="id") String id) {
        List<RkProcureInvoiceRelationEntity> list = this.rkProcureInvoiceRelationService.listByInvoice(id);
        if (CollectionUtil.isNotEmpty(list)) {
            List invoiceIds = list.stream().map(RkProcureInvoiceRelationEntity::getInvoiceId).collect(Collectors.toList());
            List invoiceList = this.rkProcureInvoiceManageService.listByIds(invoiceIds);
            List listVO = JsonUtil.getJsonToList((Object)invoiceList, RkProcureInvoiceListVO.class);
            for (RkProcureInvoiceListVO rkContractPaymentVO : listVO) {
                rkContractPaymentVO.setInvoiceTax(this.baseDataUtil.getDictName(rkContractPaymentVO.getInvoiceTax(), ""));
                rkContractPaymentVO.setInvoiceTypeName(this.baseDataUtil.getDictName(rkContractPaymentVO.getInvoiceType(), Constants.INVOICE_REGISTER_CODE));
                rkContractPaymentVO.setInvoicePattern(this.baseDataUtil.getDictName(rkContractPaymentVO.getInvoicePattern(), ""));
                rkContractPaymentVO.setInvoiceStatus("0".equals(rkContractPaymentVO.getInvoiceStatus()) ? "\u5df2\u4f5c\u5e9f" : "\u5df2\u767b\u8bb0");
                FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)rkContractPaymentVO.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
                if (flowTaskEntity != null) {
                    rkContractPaymentVO.setFlowState(flowTaskEntity.getStatus());
                    continue;
                }
                rkContractPaymentVO.setFlowState(null);
            }
            return ActionResult.success((Object)listVO);
        }
        List listVO = CollectionUtil.list((boolean)false);
        return ActionResult.success((Object)listVO);
    }

    @PutMapping(value={"/updatePrintDate/{id}"})
    @RepeatSubmit
    @DSTransactional
    public ActionResult updatePrintDate(@PathVariable(value="id") String id, @RequestBody @Valid RkProcureInvoiceUpForm rkProcureInvoiceUpForm) {
        RkProcureInvoiceEntity entity = this.rkProcureInvoiceService.getInfo(id);
        if (entity != null) {
            RkProcureInvoiceEntity subentity = (RkProcureInvoiceEntity)JsonUtil.getJsonToBean((Object)((Object)rkProcureInvoiceUpForm), RkProcureInvoiceEntity.class);
            entity.setPrintDate(subentity.getPrintDate());
            this.rkProcureInvoiceService.updateById(entity);
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }
}

