/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractPaymentEntity;
import com.bringspring.contract.entity.RkContractProcureEntity;
import com.bringspring.contract.entity.RkContractProcureRelationEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractTaxEntity;
import com.bringspring.contract.entity.RkMaterialEntity;
import com.bringspring.contract.entity.RkProcureInvoiceEntity;
import com.bringspring.contract.entity.RkProcureInvoiceRelationEntity;
import com.bringspring.contract.entity.RkProcureManageEntity;
import com.bringspring.contract.entity.RkProcurePaymentPlanEntity;
import com.bringspring.contract.entity.RkPurchaseApplyEntity;
import com.bringspring.contract.entity.RkpurchaseapplydetaillistEntity;
import com.bringspring.contract.model.rkattachment.RkAttachmentCrForm;
import com.bringspring.contract.model.rkcontract.RkContractPaymentVO;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentListVO;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectListVO;
import com.bringspring.contract.model.rkcontracttax.RkContractTaxInfoVO;
import com.bringspring.contract.model.rkprocuremanage.ProcureImportReturnVo;
import com.bringspring.contract.model.rkprocuremanage.ProcureImportVo;
import com.bringspring.contract.model.rkprocuremanage.RkProcureCheckVO;
import com.bringspring.contract.model.rkprocuremanage.RkProcureManageCrForm;
import com.bringspring.contract.model.rkprocuremanage.RkProcureManageInfoVO;
import com.bringspring.contract.model.rkprocuremanage.RkProcureManageListVO;
import com.bringspring.contract.model.rkprocuremanage.RkProcureManagePagination;
import com.bringspring.contract.model.rkprocuremanage.RkProcureManagePaginationExportModel;
import com.bringspring.contract.model.rkprocuremanage.RkProcureManageUpForm;
import com.bringspring.contract.model.rkpurchaseapplydetaillist.RkProcureDetailExportModel;
import com.bringspring.contract.model.rkpurchaseapplydetaillist.RkpurchaseapplydetaillistListVO;
import com.bringspring.contract.service.CrmErpEnterService;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProcureRelationService;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkContractTaxService;
import com.bringspring.contract.service.RkMaterialService;
import com.bringspring.contract.service.RkProcureInvoiceRelationService;
import com.bringspring.contract.service.RkProcureInvoiceService;
import com.bringspring.contract.service.RkProcureManageService;
import com.bringspring.contract.service.RkProcurePaymentPlanService;
import com.bringspring.contract.service.RkPurchaseApplyService;
import com.bringspring.contract.service.RkpurchaseapplydetaillistService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.supplier.entity.SupplierEntity;
import com.bringspring.supplier.service.SupplierService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u91c7\u8d2d\u5408\u540c\u7ba1\u7406"}, value="contract")
@RequestMapping(value={"/api/contract/RkProcureManage"})
public class RkProcureManageController {
    private static final Logger log = LoggerFactory.getLogger(RkProcureManageController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProcureManageService rkProcureManageService;
    @Autowired
    private RkContractPaymentService contractPaymentService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private RkContractProcureRelationService rkContractProcureRelationService;
    @Autowired
    private RkAttachmentService attachmentService;
    @Autowired
    private RkProcureInvoiceRelationService rkProcureInvoiceRelationService;
    @Autowired
    private RkProcureInvoiceService rkProcureInvoiceService;
    @Autowired
    private RkpurchaseapplydetaillistService rkpurchaseapplydetaillistService;
    @Autowired
    private RkContractTaxService rkContractTaxService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkProcurePaymentPlanService rkProcurePaymentPlanService;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private RkPurchaseApplyService rkPurchaseApplyService;
    @Autowired
    private RkMaterialService rkMaterialService;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private CrmErpEnterService crmErpEnterService;
    @Autowired
    private SupplierService supplierService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProcureManagePagination rkProcureManagePagination) throws IOException {
        List<RkProcureManageEntity> list = this.rkProcureManageService.getList(rkProcureManagePagination);
        for (RkProcureManageEntity rkProcureManageEntity : list) {
            rkProcureManageEntity.setApplyId(this.baseDataUtil.userSelectValueNoAccount(rkProcureManageEntity.getApplyId()));
            rkProcureManageEntity.setSupplierId(this.baseDataUtil.userSelectValueNoAccount(rkProcureManageEntity.getSupplierId()));
        }
        List listVO = JsonUtil.getJsonToList(list, RkProcureManageListVO.class);
        for (RkProcureManageListVO rkProcureManageVO : listVO) {
            List<RkProcureInvoiceRelationEntity> listByInvoice = this.rkProcureInvoiceRelationService.listByInvoice(rkProcureManageVO.getId());
            List collect = listByInvoice.stream().map(RkProcureInvoiceRelationEntity::getInvoiceId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                List list1 = this.rkProcureInvoiceService.listByIds(collect);
                List<RkProcureInvoiceEntity> complete = list1.stream().filter(invoice -> invoice.getEnableMark().equals("complete") || "-1".equals(invoice.getEnableMark())).collect(Collectors.toList());
                complete.stream().forEach(invoice -> invoice.setInvoiceTypeName(this.baseDataUtil.getDictName(invoice.getInvoiceType(), "invoiceRegister")));
                rkProcureManageVO.setInvoiceList(complete);
            }
            rkProcureManageVO.setPaymentMethodTypeName(this.baseDataUtil.getDictName(rkProcureManageVO.getPaymentMethodType(), Constants.PROCURE_PAYMENT_CODE));
            rkProcureManageVO.setStampTypeName(this.baseDataUtil.getDictName(rkProcureManageVO.getStampType(), Constants.STAMP_TYPE_DICT_ID));
            RkContractProjectEntity projectInfo = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)rkProcureManageVO.getProjectId()));
            if (ObjectUtil.isNotEmpty((Object)projectInfo)) {
                RkContractProjectListVO projectListVO = (RkContractProjectListVO)JsonUtil.getJsonToBean((Object)projectInfo, RkContractProjectListVO.class);
                rkProcureManageVO.setProjectList(projectListVO);
            } else {
                rkProcureManageVO.setProjectList(null);
            }
            List<RkProcurePaymentPlanEntity> listByProcureId = this.rkProcurePaymentPlanService.getListByProcureId(rkProcureManageVO.getId());
            BigDecimal sum = BigDecimal.ZERO;
            sum = listByProcureId.stream().map(RkProcurePaymentPlanEntity::getPaymentAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            rkProcureManageVO.setPaymentPlanAmount(sum);
            if (StrUtil.isNotEmpty((CharSequence)rkProcureManageVO.getInvoiceTaxName()) && !StrUtil.contains((CharSequence)rkProcureManageVO.getInvoiceTaxName(), (CharSequence)"%")) {
                rkProcureManageVO.setInvoiceTaxName(this.baseDataUtil.getDictName(rkProcureManageVO.getInvoiceTax(), Constants.CONTRACT_TAX_RATE_DICT_ID));
            }
            if (!ObjectUtil.isNotEmpty((Object)rkProcureManageVO.getProcureAmount()) || !ObjectUtil.isNotEmpty((Object)rkProcureManageVO.getInvoiceTaxName())) continue;
            rkProcureManageVO.setNoTaxAmount(this.getNoTaxAmount(rkProcureManageVO.getInvoiceTaxName(), rkProcureManageVO.getProcureAmount().toString()));
            rkProcureManageVO.setTaxAmount(this.getTaxAmount(rkProcureManageVO.getNoTaxAmount(), rkProcureManageVO.getProcureAmount().toString()));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProcureManagePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    private String getNoTaxAmount(String taxRate, String amount) {
        if (StrUtil.isNotEmpty((CharSequence)taxRate) && StrUtil.isNotEmpty((CharSequence)amount)) {
            if (NumberUtil.isNumber((CharSequence)taxRate.replace("%", ""))) {
                BigDecimal taxRateDecimal = new BigDecimal(taxRate.replace("%", ""));
                BigDecimal amountDecimal = new BigDecimal(amount);
                BigDecimal noTaxAmount = amountDecimal.divide(BigDecimal.ONE.add(taxRateDecimal.divide(new BigDecimal("100"))), 2, 4);
                return noTaxAmount.toString();
            }
            return "0.00";
        }
        return "0.00";
    }

    private String getTaxAmount(String noTaxAmount, String amount) {
        if (StrUtil.isNotEmpty((CharSequence)noTaxAmount) && StrUtil.isNotEmpty((CharSequence)amount)) {
            if (NumberUtil.isNumber((CharSequence)noTaxAmount) && NumberUtil.isNumber((CharSequence)amount)) {
                BigDecimal noTaxAmountDecimal = new BigDecimal(noTaxAmount);
                BigDecimal amountDecimal = new BigDecimal(amount);
                BigDecimal taxAmount = amountDecimal.subtract(noTaxAmountDecimal);
                return taxAmount.toString();
            }
            return "0.00";
        }
        return "0.00";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid RkProcureManageCrForm rkProcureManageCrForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            RkContractProjectEntity project;
            String[] split;
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            String organizeId = userInfo.getOrganizeId();
            rkProcureManageCrForm.setCompanyId(organizeId);
            rkProcureManageCrForm.setProcureCode(this.baseDataUtil.getBillNumber(organizeId + "procureCode", Boolean.valueOf(false)));
            if (ObjectUtil.isEmpty((Object)rkProcureManageCrForm.getApplyDate())) {
                rkProcureManageCrForm.setApplyDate(DateUtil.date().getTime());
            }
            RkContractProjectListVO projectInfo = rkProcureManageCrForm.getProjectList();
            rkProcureManageCrForm.setProcureStatus("execute");
            rkProcureManageCrForm.setProcureType("0");
            RkProcureManageEntity entity = (RkProcureManageEntity)JsonUtil.getJsonToBean((Object)rkProcureManageCrForm, RkProcureManageEntity.class);
            entity.setId(mainId);
            entity.setProjectId(projectInfo.getId());
            if (ObjectUtil.isNotEmpty((Object)projectInfo.getProjectHeader())) {
                entity.setProjectManager(projectInfo.getProjectHeader());
                entity.setProjectManagerName(this.baseDataUtil.userSelectValue(entity.getProjectManager()));
            }
            entity.setApplyName(userInfo.getRealName());
            if (!ObjectUtil.isEmpty((Object)entity.getApplyDepartmentTree()) && (split = entity.getApplyDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",")).length > 0) {
                entity.setApplyDepartmentTreeName(this.baseDataUtil.comSelectValues(entity.getApplyDepartmentTree()));
                entity.setApplyDepartmentOne(split[0]);
                entity.setApplyDepartmentOneName(this.baseDataUtil.comSelectValues(entity.getApplyDepartmentOne()));
                entity.setApplyDepartment(split[split.length - 1]);
                entity.setApplyDepartmentName(this.baseDataUtil.comSelectValues(entity.getApplyDepartment()));
            }
            if (!ObjectUtil.isEmpty((Object)entity.getStampType())) {
                entity.setStampTypeName(this.baseDataUtil.getDictName(entity.getStampType(), Constants.STAMP_TYPE_DICT_ID));
            }
            entity.setInvoiceTaxName(this.baseDataUtil.getDictName(entity.getInvoiceTax(), Constants.CONTRACT_TAX_RATE_DICT_ID));
            entity.setInvoiceTypeName(this.baseDataUtil.getDictName(entity.getInvoiceType(), Constants.PROCURE_INVOICE_CODE));
            entity.setSalesPerson(entity.getSalesPerson());
            entity.setAccumulatePaymentAmount(BigDecimal.ZERO);
            entity.setAccumulateInvoiceAmount(BigDecimal.ZERO);
            entity.setNotPaymentAmount(BigDecimal.ZERO);
            this.rkProcureManageService.save(entity);
            rkProcureManageCrForm.setStampTypeName(entity.getStampTypeName());
            rkProcureManageCrForm.setSalesPerson(entity.getSalesPerson());
            if (CollectionUtil.isNotEmpty(rkProcureManageCrForm.getPaymentMethodList())) {
                List<RkContractPaymentVO> paymentMethodList = rkProcureManageCrForm.getPaymentMethodList();
                paymentMethodList.stream().forEach(payment -> {
                    if (!ObjectUtil.isEmpty((Object)payment.getPaymentName()) && ObjectUtil.isEmpty((Object)payment.getPaymentType())) {
                        payment.setPaymentType(PinyinUtil.getFirstLetter((String)payment.getPaymentName(), (String)"").toUpperCase());
                    }
                });
                String objectToString = JsonUtil.getObjectToString(paymentMethodList);
                entity.setPaymentJson(objectToString);
                List jsonToList = JsonUtil.getJsonToList(paymentMethodList, RkContractPaymentEntity.class);
                jsonToList.stream().forEach(payment -> {
                    payment.setContractId(entity.getId());
                    payment.setId(RandomUtil.uuId());
                });
                this.contractPaymentService.saveBatch(jsonToList);
            }
            List<RkAttachmentCrForm> attachmentList = rkProcureManageCrForm.getAttachmentList();
            attachmentList.stream().forEach(attach -> {
                attach.setContractId(mainId);
                attach.setFileType(AttachmentTypeEnum.CONTRACT_TYPE.getType());
            });
            List attachmentEntityList = JsonUtil.getJsonToList(attachmentList, RkAttachmentEntity.class);
            this.attachmentService.saveBatch(attachmentEntityList);
            List<RkpurchaseapplydetaillistEntity> purchaseApplyList = rkProcureManageCrForm.getPurchaseApplyList();
            if (CollectionUtil.isNotEmpty(purchaseApplyList)) {
                purchaseApplyList.stream().forEach(purchaseApply -> this.rkpurchaseapplydetaillistService.addHtId(mainId, rkProcureManageCrForm.getProcureCode(), purchaseApply.getId()));
                RkContractProcureEntity contractProcure = (RkContractProcureEntity)JsonUtil.getJsonToBean((Object)entity, RkContractProcureEntity.class);
                this.crmErpEnterService.save(contractProcure, purchaseApplyList);
            }
            if (ObjectUtil.isNotEmpty((Object)(project = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)entity.getProjectId()))))) {
                project.setIsPurchase(1);
                this.rkContractProjectService.updateById(project);
            }
            return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProcureManageInfoVO> info(@PathVariable(value="id") String id) {
        RkProcureManageEntity entity = this.rkProcureManageService.getInfo(id);
        RkProcureManageInfoVO vo = (RkProcureManageInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProcureManageInfoVO.class);
        if (ObjectUtil.isNotEmpty((Object)vo.getSupplierId())) {
            SupplierEntity supplier = this.supplierService.getInfo(vo.getSupplierId());
            vo.setBankFirmCode(supplier.getBankFirmCode());
        }
        String[] split = entity.getApplyDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",");
        vo.setApplyDepartmentTree(Arrays.asList(split));
        vo.setApplyDepartment(entity.getApplyDepartmentTreeName());
        vo.setInvoiceTaxName(this.baseDataUtil.getDictName(entity.getInvoiceTax(), Constants.CONTRACT_TAX_RATE_DICT_ID));
        vo.setInvoiceTypeName(this.baseDataUtil.getDictName(entity.getInvoiceType(), Constants.PROCURE_INVOICE_CODE));
        vo.setStampTypeName(this.baseDataUtil.getDictName(entity.getStampType(), Constants.STAMP_TYPE_DICT_ID));
        vo.setPaymentMethodTypeName(this.baseDataUtil.getDictName(entity.getPaymentMethodType(), Constants.PROCURE_PAYMENT_CODE));
        vo.setApplyName(this.baseDataUtil.userSelectValueNoAccount(entity.getApplyId()));
        vo.setCheckName(this.baseDataUtil.userSelectValueNoAccount(entity.getCheckId()));
        List<RkContractTaxEntity> taxEntities = this.rkContractTaxService.listByContractId(id);
        if (CollectionUtil.isNotEmpty(taxEntities)) {
            List taxInfoList = JsonUtil.getJsonToList(taxEntities, RkContractTaxInfoVO.class);
            vo.setTaxList(taxInfoList);
        } else {
            vo.setTaxList(new ArrayList<RkContractTaxInfoVO>());
        }
        List<RkContractPaymentEntity> listByContractId = this.contractPaymentService.getListByContractId(id);
        List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractPaymentListVO.class);
        vo.setPaymentMethodList(jsonToList);
        List<RkProcureInvoiceRelationEntity> listByInvoice = this.rkProcureInvoiceRelationService.listByInvoice(id);
        List collect1 = listByInvoice.stream().map(RkProcureInvoiceRelationEntity::getInvoiceId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(collect1)) {
            List invoiceInfo = this.rkProcureInvoiceService.listByIds(collect1);
            List<RkProcureInvoiceEntity> complete = invoiceInfo.stream().filter(invoice -> invoice.getEnableMark().equals("complete") || "-1".equals(invoice.getEnableMark())).filter(t -> t.getCheckInvoice().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
            complete.stream().forEach(invoice -> invoice.setInvoiceTypeName(this.baseDataUtil.getDictName(invoice.getInvoiceType(), "invoiceRegister")));
            vo.setInvoiceList(complete);
        } else {
            vo.setInvoiceList(new ArrayList<RkProcureInvoiceEntity>());
        }
        List<RkProcurePaymentPlanEntity> listByProcureId = this.rkProcurePaymentPlanService.getListByProcureId(id);
        vo.setPaymentPlanList(listByProcureId);
        List<RkpurchaseapplydetaillistEntity> listByPurchaseApply = this.rkpurchaseapplydetaillistService.listByProcureCode(entity.getProcureCode());
        if (CollectionUtil.isNotEmpty(listByPurchaseApply)) {
            listByPurchaseApply.stream().forEach(purchase -> {
                purchase.setPurchaseAmount(MathUtils.multiply(purchase.getApplyCount(), purchase.getApplyPrice()));
                RkPurchaseApplyEntity info = this.rkPurchaseApplyService.getInfo(purchase.getParentId());
                if (ObjectUtil.isNotEmpty((Object)info)) {
                    purchase.setProjectName(info.getProjectName());
                }
            });
            vo.setPurchaseApplyList(listByPurchaseApply);
        }
        if (ObjectUtil.isNotEmpty((Object)entity.getProjectId())) {
            RkContractProjectListVO projectInfo = this.rkContractProcureService.getProjectInfo(entity.getProjectId());
            vo.setProjectList(projectInfo);
        }
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid RkProcureManageUpForm rkProcureManageUpForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            RkProcureManageEntity entity = this.rkProcureManageService.getInfo(id);
            if (entity != null) {
                RkProcureManageEntity subentity = (RkProcureManageEntity)JsonUtil.getJsonToBean((Object)rkProcureManageUpForm, RkProcureManageEntity.class);
                subentity.setStampTypeName(this.baseDataUtil.getDictName(subentity.getStampType(), Constants.STAMP_TYPE_DICT_ID));
                subentity.setSalesPerson(subentity.getSalesPerson());
                subentity.setProcureType("0");
                subentity.setEnableMark(entity.getEnableMark());
                subentity.setProcureStatus(entity.getProcureStatus());
                this.rkProcureManageService.updateForm(id, rkProcureManageUpForm);
                rkProcureManageUpForm.setStampTypeName(subentity.getStampTypeName());
                rkProcureManageUpForm.setSalesPerson(subentity.getSalesPerson());
                this.rkpurchaseapplydetaillistService.removeHtCode(rkProcureManageUpForm.getId());
                List<RkpurchaseapplydetaillistEntity> purchaseApplyList = rkProcureManageUpForm.getPurchaseApplyList();
                if (CollectionUtil.isNotEmpty(purchaseApplyList)) {
                    purchaseApplyList.stream().forEach(purchaseApply -> this.rkpurchaseapplydetaillistService.addHtId(id, rkProcureManageUpForm.getProcureCode(), purchaseApply.getId()));
                }
                return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PostMapping(value={"check"})
    public ActionResult check(@RequestBody RkProcureCheckVO rkProcureCheckVO) {
        Object object = this.$lock;
        synchronized (object) {
            RkProcureManageEntity entity = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)rkProcureCheckVO.getId()));
            entity.setIsCheck(1);
            entity.setCheckId(rkProcureCheckVO.getCheckId());
            entity.setCheckRemark(rkProcureCheckVO.getCheckRemark());
            entity.setCheckTime(DateUtil.daFormatDate((Long)rkProcureCheckVO.getCheckTime()));
            entity.setCheckName(this.baseDataUtil.userSelectValue(rkProcureCheckVO.getCheckId()));
            List<RkAttachmentCrForm> checkAttachmentList = rkProcureCheckVO.getCheckAttachmentList();
            if (CollectionUtil.isNotEmpty(checkAttachmentList)) {
                checkAttachmentList.stream().forEach(attach -> {
                    attach.setId(RandomUtil.uuId());
                    attach.setContractId(entity.getId());
                    attach.setFileType("check");
                });
                List attachmentEntityList = JsonUtil.getJsonToList(checkAttachmentList, RkAttachmentEntity.class);
                this.attachmentService.saveBatch(attachmentEntityList);
            }
            this.rkProcureManageService.updateById(entity);
            return ActionResult.success((String)"\u9a8c\u6536\u786e\u8ba4\u6210\u529f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        Object object = this.$lock;
        synchronized (object) {
            RkProcureManageEntity entity = this.rkProcureManageService.getInfo(id);
            if (entity != null) {
                FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
                if (taskEntity != null) {
                    try {
                        FlowUtil.deleteByProcessId((String)id);
                    }
                    catch (WorkFlowException e) {
                        e.printStackTrace();
                    }
                }
                this.rkProcureManageService.delete(entity);
            }
            return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
        }
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult<Object> Uploader() {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().endsWith(".xlsx") || file.getOriginalFilename().endsWith(".xls")) {
            String filePath = XSSEscape.escape((String)this.configValueUtil.getTemporaryFilePath());
            String fileName = XSSEscape.escape((String)(RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file)));
            FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
            try {
                UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)(filePath + fileName), (String)"temporary", (String)fileName);
            }
            catch (IOException e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            DownloadVO vo = DownloadVO.builder().build();
            vo.setName(fileName);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u91c7\u8d2d\u5408\u540c\u6a21\u677f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u91c7\u8d2d\u5408\u540c\u6a21\u677f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List fileImportList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, ProcureImportVo.class);
        if (CollectionUtil.isEmpty((Collection)fileImportList)) {
            return ActionResult.fail((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fileImportList.size() > 200) {
            return ActionResult.fail((String)"\u6700\u591a\u5bfc\u5165\u6570\u636e200\u6761");
        }
        Map<String, Object> map = this.rkProcureManageService.importPreview(fileImportList, new ProcureImportVo());
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkProcureManagePaginationExportModel rkProcureManagePaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkProcureManagePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkProcureManagePagination procurePagination = (RkProcureManagePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkProcureManagePaginationExportModel), RkProcureManagePagination.class));
        String organizeId = this.userProvider.get().getOrganizeId();
        List<RkProcureManageEntity> list = this.rkProcureManageService.getTypeList(procurePagination, rkProcureManagePaginationExportModel.getDataType());
        for (RkProcureManageEntity rkProcureManageEntity : list) {
            rkProcureManageEntity.setApplyId(rkProcureManageEntity.getApplyName());
            rkProcureManageEntity.setInvoiceType(this.baseDataUtil.getDictName(rkProcureManageEntity.getInvoiceType(), Constants.PROCURE_INVOICE_CODE));
            rkProcureManageEntity.setInvoiceTax(this.baseDataUtil.getDictName(rkProcureManageEntity.getInvoiceTax(), Constants.CONTRACT_TAX_RATE_DICT_ID));
            rkProcureManageEntity.setPaymentMethodType(this.baseDataUtil.getDictName(rkProcureManageEntity.getPaymentMethodType(), Constants.PROCURE_PAYMENT_CODE));
        }
        List listVO = JsonUtil.getJsonToList(list, RkProcureManageListVO.class);
        for (RkProcureManageListVO rkProcureManageListVO : listVO) {
            List<RkContractProcureRelationEntity> listByContractId1 = this.rkContractProcureRelationService.listByContractId1(rkProcureManageListVO.getId());
            List collect1 = listByContractId1.stream().map(RkContractProcureRelationEntity::getContractId).collect(Collectors.toList());
            RkContractProjectEntity projectInfoEntity = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)rkProcureManageListVO.getProjectId()));
            if (ObjectUtil.isNotEmpty((Object)projectInfoEntity)) {
                RkContractEntity contractInfo = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)projectInfoEntity.getContractId()));
                if (ObjectUtil.isNotEmpty((Object)contractInfo)) {
                    rkProcureManageListVO.setContractCode(contractInfo.getContractCode());
                }
                rkProcureManageListVO.setProjectCode(projectInfoEntity.getProjectCode());
            } else if (CollectionUtil.isNotEmpty(collect1)) {
                List list1 = this.rkContractService.listByIds(collect1);
                rkProcureManageListVO.setContractCode(list1.stream().map(RkContractEntity::getContractCode).distinct().collect(Collectors.joining(",")));
            }
            if (ObjectUtil.isNotEmpty((Object)rkProcureManageListVO.getProcureStatus())) {
                if (rkProcureManageListVO.getProcureStatus().equals("execute")) {
                    rkProcureManageListVO.setProcureStatus("\u6267\u884c\u4e2d");
                } else if (rkProcureManageListVO.getProcureStatus().equals("cancel")) {
                    rkProcureManageListVO.setProcureStatus("\u5df2\u4f5c\u5e9f");
                } else if (rkProcureManageListVO.getProcureStatus().equals("canceling")) {
                    rkProcureManageListVO.setProcureStatus("\u6b63\u5728\u4f5c\u5e9f");
                } else if (rkProcureManageListVO.getProcureStatus().equals("termination")) {
                    rkProcureManageListVO.setProcureStatus("\u5df2\u7ec8\u6b62");
                } else if (rkProcureManageListVO.getProcureStatus().equals("terminating")) {
                    rkProcureManageListVO.setProcureStatus("\u6b63\u5728\u7ec8\u6b62");
                } else if (rkProcureManageListVO.getProcureStatus().equals("break")) {
                    rkProcureManageListVO.setProcureStatus("\u5df2\u4e2d\u6b62");
                } else if (rkProcureManageListVO.getProcureStatus().equals("breaking")) {
                    rkProcureManageListVO.setProcureStatus("\u6b63\u5728\u4e2d\u6b62");
                } else if (rkProcureManageListVO.getProcureStatus().equals("changing")) {
                    rkProcureManageListVO.setProcureStatus("\u6b63\u5728\u53d8\u66f4");
                } else if (rkProcureManageListVO.getProcureStatus().equals("change")) {
                    rkProcureManageListVO.setProcureStatus("\u5df2\u53d8\u66f4");
                }
            } else {
                rkProcureManageListVO.setProcureStatus("\u8349\u7a3f");
            }
            if (StrUtil.isNotEmpty((CharSequence)rkProcureManageListVO.getInvoiceTaxName()) && !StrUtil.contains((CharSequence)rkProcureManageListVO.getInvoiceTaxName(), (CharSequence)"%")) {
                rkProcureManageListVO.setInvoiceTaxName(this.baseDataUtil.getDictName(rkProcureManageListVO.getInvoiceTax(), Constants.CONTRACT_TAX_RATE_DICT_ID));
            }
            if (!ObjectUtil.isNotEmpty((Object)rkProcureManageListVO.getProcureAmount()) || !ObjectUtil.isNotEmpty((Object)rkProcureManageListVO.getInvoiceTaxName())) continue;
            rkProcureManageListVO.setNoTaxAmount(this.getNoTaxAmount(rkProcureManageListVO.getInvoiceTaxName(), rkProcureManageListVO.getProcureAmount().toString()));
            rkProcureManageListVO.setTaxAmount(this.getTaxAmount(rkProcureManageListVO.getNoTaxAmount(), rkProcureManageListVO.getProcureAmount().toString()));
        }
        List list2 = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkProcureManagePaginationExportModel.getSelectKey()) ? rkProcureManagePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), list2, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block48: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "procureName": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u540d\u79f0", (Object)"procureName"));
                        continue block48;
                    }
                    case "procureCode": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u7f16\u53f7", (Object)"procureCode"));
                        continue block48;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block48;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u53f7", (Object)"projectCode"));
                        continue block48;
                    }
                    case "supplierName": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u540d\u79f0", (Object)"supplierName"));
                        continue block48;
                    }
                    case "supplierBank": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u5361\u53f7", (Object)"supplierBank"));
                        continue block48;
                    }
                    case "supplierAccount": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u8d26\u6237", (Object)"supplierAccount"));
                        continue block48;
                    }
                    case "procureAmount": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u91d1\u989d", (Object)"procureAmount"));
                        continue block48;
                    }
                    case "applyId": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5458", (Object)"applyId"));
                        continue block48;
                    }
                    case "applyDate": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u65e5\u671f", (Object)"applyDate"));
                        continue block48;
                    }
                    case "warranty": {
                        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u671f", (Object)"warranty"));
                        continue block48;
                    }
                    case "deliveryTime": {
                        entitys.add(new ExcelExportEntity("\u8d27\u671f", (Object)"deliveryTime"));
                        continue block48;
                    }
                    case "procureStatus": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u72b6\u6001", (Object)"procureStatus"));
                        continue block48;
                    }
                    case "accumulatePaymentAmount": {
                        entitys.add(new ExcelExportEntity("\u7d2f\u8ba1\u4ed8\u6b3e", (Object)"accumulatePaymentAmount"));
                        continue block48;
                    }
                    case "accumulateInvoiceAmount": {
                        entitys.add(new ExcelExportEntity("\u7d2f\u8ba1\u53d1\u7968", (Object)"accumulateInvoiceAmount"));
                        continue block48;
                    }
                    case "invoiceTaxName": {
                        entitys.add(new ExcelExportEntity("\u7a0e\u7387", (Object)"invoiceTaxName"));
                        continue block48;
                    }
                    case "noTaxAmount": {
                        entitys.add(new ExcelExportEntity("\u65e0\u7a0e\u91d1\u989d(\u5143)", (Object)"noTaxAmount"));
                        continue block48;
                    }
                    case "taxAmount": {
                        entitys.add(new ExcelExportEntity("\u7a0e\u989d(\u5143)", (Object)"taxAmount"));
                        continue block48;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u91c7\u8d2d\u5408\u540c\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @PostMapping(value={"/Actions/detailExport"})
    public ActionResult detailExport(@RequestBody @Valid RkProcureDetailExportModel rkProcureDetailExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkProcureDetailExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkProcureManagePagination procurePagination = (RkProcureManagePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkProcureDetailExportModel), RkProcureManagePagination.class));
        String organizeId = this.userProvider.get().getOrganizeId();
        List<RkProcureManageEntity> list = this.rkProcureManageService.getTypeList(procurePagination, rkProcureDetailExportModel.getDataType());
        List procureIdList = list.stream().map(RkProcureManageEntity::getId).collect(Collectors.toList());
        List purchaseDetailList = CollectionUtil.list((boolean)false);
        for (Object id : procureIdList) {
            List<RkpurchaseapplydetaillistEntity> listByProcureId = this.rkpurchaseapplydetaillistService.listByProcureId((String)id);
            purchaseDetailList.addAll(listByProcureId);
        }
        List listVO = JsonUtil.getJsonToList((Object)purchaseDetailList, RkpurchaseapplydetaillistListVO.class);
        for (RkpurchaseapplydetaillistListVO rkpurchaseapplydetaillistVO : listVO) {
            RkContractEntity contractInfo;
            RkContractProjectEntity projectInfo;
            if (ObjectUtil.isEmpty((Object)rkpurchaseapplydetaillistVO.getMaterialBrand())) {
                RkMaterialEntity materialEntity;
                if (ObjectUtil.isNotEmpty((Object)rkpurchaseapplydetaillistVO.getMaterialId()) && ObjectUtil.isNotEmpty((Object)(materialEntity = this.rkMaterialService.getInfo(rkpurchaseapplydetaillistVO.getMaterialId())))) {
                    rkpurchaseapplydetaillistVO.setMaterialBrand(materialEntity.getMaterialBrand());
                    rkpurchaseapplydetaillistVO.setMaterialName(materialEntity.getMaterialName());
                    rkpurchaseapplydetaillistVO.setMaterialModel(materialEntity.getMaterialModel());
                    rkpurchaseapplydetaillistVO.setMaterialCategoryName(this.baseDataUtil.getDictName(materialEntity.getMaterialType(), "MaterialType"));
                    rkpurchaseapplydetaillistVO.setMaterialPropertyName(this.baseDataUtil.getDictName(materialEntity.getMaterialProperties(), "materialProperties"));
                    if (ObjectUtil.isNotEmpty((Object)rkpurchaseapplydetaillistVO.getApplyTaxRate())) {
                        rkpurchaseapplydetaillistVO.setApplyTaxRate("%" + rkpurchaseapplydetaillistVO.getApplyTaxRate());
                    }
                }
            } else {
                rkpurchaseapplydetaillistVO.setApplyTaxRate(this.baseDataUtil.getDictName(rkpurchaseapplydetaillistVO.getApplyTaxRate(), Constants.CONTRACT_TAX_RATE_DICT_ID));
            }
            rkpurchaseapplydetaillistVO.setApplyBuyer(ObjectUtil.isNotEmpty((Object)this.baseDataUtil.userSelectValue(rkpurchaseapplydetaillistVO.getApplyBuyer())) ? this.baseDataUtil.userSelectValue(rkpurchaseapplydetaillistVO.getApplyBuyer()) : rkpurchaseapplydetaillistVO.getApplyBuyer());
            RkProcureManageEntity procureInfo = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)rkpurchaseapplydetaillistVO.getHtId()));
            if (ObjectUtil.isNotEmpty((Object)procureInfo)) {
                rkpurchaseapplydetaillistVO.setProcureName(procureInfo.getProcureName());
                rkpurchaseapplydetaillistVO.setProcureAmount(procureInfo.getProcureAmount());
                rkpurchaseapplydetaillistVO.setDeliveryTime(procureInfo.getDeliveryTime());
                rkpurchaseapplydetaillistVO.setWarranty(procureInfo.getWarranty());
                rkpurchaseapplydetaillistVO.setProcureApplyDate(procureInfo.getApplyDate());
                rkpurchaseapplydetaillistVO.setProjectId(procureInfo.getProjectId());
                rkpurchaseapplydetaillistVO.setProcureSupplier(procureInfo.getSupplierName());
            }
            if (ObjectUtil.isNotEmpty((Object)(projectInfo = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)rkpurchaseapplydetaillistVO.getProjectId()))))) {
                rkpurchaseapplydetaillistVO.setProjectCode(projectInfo.getProjectCode());
                rkpurchaseapplydetaillistVO.setProjectName(projectInfo.getProjectName());
                rkpurchaseapplydetaillistVO.setProjectHeaderDesc(ObjectUtil.isNotEmpty((Object)projectInfo.getProjectHeader()) ? this.baseDataUtil.userSelectValue(projectInfo.getProjectHeader()) : "");
            }
            if (!ObjectUtil.isNotEmpty((Object)(contractInfo = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)rkpurchaseapplydetaillistVO.getXsId()))))) continue;
            rkpurchaseapplydetaillistVO.setSalePerson(this.baseDataUtil.userSelectValue(contractInfo.getSalerId()));
            rkpurchaseapplydetaillistVO.setXsName(contractInfo.getContractName());
            contractInfo.setCustomerName(((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)contractInfo.getCustomerId()))).getName());
            if (!ObjectUtil.isEmpty((Object)contractInfo.getIsAgent()) && contractInfo.getIsAgent() == 1) {
                rkpurchaseapplydetaillistVO.setAgentName(((RkAgentEntity)this.rkAgentService.getById((Serializable)((Object)contractInfo.getAgentId()))).getName());
                continue;
            }
            rkpurchaseapplydetaillistVO.setAgentName(contractInfo.getCustomerName());
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkProcureDetailExportModel.getSelectKey()) ? rkProcureDetailExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatDetailModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatDetailModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block86: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "procureApplyDate": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u7533\u8bf7\u65e5\u671f", (Object)"procureApplyDate"));
                        continue block86;
                    }
                    case "htCode": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u7f16\u53f7", (Object)"htCode"));
                        continue block86;
                    }
                    case "procureName": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u540d\u79f0", (Object)"procureName"));
                        continue block86;
                    }
                    case "procureAmount": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u91d1\u989d", (Object)"procureAmount"));
                        continue block86;
                    }
                    case "procureSupplier": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u540d\u79f0", (Object)"procureSupplier"));
                        continue block86;
                    }
                    case "procureApplyName": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5458", (Object)"applyBuyer"));
                        continue block86;
                    }
                    case "deliveryTime": {
                        entitys.add(new ExcelExportEntity("\u8d27\u671f", (Object)"deliveryTime"));
                        continue block86;
                    }
                    case "warranty": {
                        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u671f", (Object)"warranty"));
                        continue block86;
                    }
                    case "applyCode": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u660e\u7ec6\u5355\u636e\u53f7", (Object)"applyCode"));
                        continue block86;
                    }
                    case "materialCode": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u7f16\u53f7", (Object)"materialCode"));
                        continue block86;
                    }
                    case "materialPropertyName": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u5c5e\u6027", (Object)"materialPropertyName"));
                        continue block86;
                    }
                    case "materialCategoryName": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u5206\u7c7b", (Object)"materialCategoryName"));
                        continue block86;
                    }
                    case "materialBrand": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u54c1\u724c", (Object)"materialBrand"));
                        continue block86;
                    }
                    case "materialName": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u540d\u79f0", (Object)"materialName"));
                        continue block86;
                    }
                    case "materialModel": {
                        entitys.add(new ExcelExportEntity("\u7269\u6599\u578b\u53f7", (Object)"materialModel"));
                        continue block86;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u8be6\u7ec6\u914d\u7f6e", (Object)"description"));
                        continue block86;
                    }
                    case "materialUnit": {
                        entitys.add(new ExcelExportEntity("\u5355\u4f4d", (Object)"measureUnit"));
                        continue block86;
                    }
                    case "applyCount": {
                        entitys.add(new ExcelExportEntity("\u6570\u91cf", (Object)"applyCount"));
                        continue block86;
                    }
                    case "applyPrice": {
                        entitys.add(new ExcelExportEntity("\u5355\u4ef7", (Object)"applyPrice"));
                        continue block86;
                    }
                    case "applyBuyer": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5458", (Object)"applyBuyer"));
                        continue block86;
                    }
                    case "applyTaxRate": {
                        entitys.add(new ExcelExportEntity("\u7a0e\u7387", (Object)"applyTaxRate"));
                        continue block86;
                    }
                    case "supplierName": {
                        entitys.add(new ExcelExportEntity("\u6307\u5b9a\u4f9b\u5e94\u5546", (Object)"supplierName"));
                        continue block86;
                    }
                    case "supplierPerson": {
                        entitys.add(new ExcelExportEntity("\u6307\u5b9a\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba", (Object)"supplierPerson"));
                        continue block86;
                    }
                    case "supplierTel": {
                        entitys.add(new ExcelExportEntity("\u6307\u5b9a\u4f9b\u5e94\u5546\u8054\u7cfb\u7535\u8bdd", (Object)"supplierTel"));
                        continue block86;
                    }
                    case "arrivalLocation": {
                        entitys.add(new ExcelExportEntity("\u5230\u8d27\u5730\u5740", (Object)"arrivalLocation"));
                        continue block86;
                    }
                    case "arrivalDate": {
                        entitys.add(new ExcelExportEntity("\u5230\u8d27\u65e5\u671f", (Object)"arrivalDate"));
                        continue block86;
                    }
                    case "arrivalContactPerson": {
                        entitys.add(new ExcelExportEntity("\u5230\u8d27\u8054\u7cfb\u4eba", (Object)"arrivalContactPerson"));
                        continue block86;
                    }
                    case "arrivalContactTel": {
                        entitys.add(new ExcelExportEntity("\u5230\u8d27\u8054\u7cfb\u4eba\u7535\u8bdd", (Object)"arrivalContactTel"));
                        continue block86;
                    }
                    case "warrantyPeriod": {
                        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u671f", (Object)"warrantyPeriod"));
                        continue block86;
                    }
                    case "remarks": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"remarks"));
                        continue block86;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u540d\u79f0", (Object)"agentName"));
                        continue block86;
                    }
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName"));
                        continue block86;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u53f7", (Object)"projectCode"));
                        continue block86;
                    }
                    case "projectHeaderDesc": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7ecf\u7406", (Object)"projectHeaderDesc"));
                        continue block86;
                    }
                    case "xsName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u540d\u79f0", (Object)"xsName"));
                        continue block86;
                    }
                    case "xsCode": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u53f7", (Object)"xsCode"));
                        continue block86;
                    }
                    case "salePerson": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u7ecf\u7406", (Object)"salePerson"));
                        continue block86;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u91c7\u8d2d\u5408\u540c\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u91c7\u8d2d\u5408\u540c\u660e\u7ec6" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<ProcureImportReturnVo> ImportData(@RequestBody ProcureImportVo data) throws DataException {
        List dataList = JsonUtil.getJsonToList(data.getList(), ProcureImportVo.class);
        ProcureImportReturnVo result = this.rkProcureManageService.importData(dataList);
        return ActionResult.success((Object)result);
    }
}

