/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.contract.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractPaymentEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProcureInvoiceEntity;
import com.bringspring.contract.entity.RkProcureManageEntity;
import com.bringspring.contract.entity.RkProcurePaymentEntity;
import com.bringspring.contract.entity.RkProcurePaymentPlanEntity;
import com.bringspring.contract.entity.RkProcurePaymentRelationEntity;
import com.bringspring.contract.model.rkcontractpayment.RkContractPaymentListVO;
import com.bringspring.contract.model.rkcontractprocure.OaContractInternalTransactionInfo;
import com.bringspring.contract.model.rkcontractproject.RkContractProjectListVO;
import com.bringspring.contract.model.rkprocurepayment.RkInvoiceVo;
import com.bringspring.contract.model.rkprocurepayment.RkProcurePaymentCrForm;
import com.bringspring.contract.model.rkprocurepayment.RkProcurePaymentExportVO;
import com.bringspring.contract.model.rkprocurepayment.RkProcurePaymentImportReturnVO;
import com.bringspring.contract.model.rkprocurepayment.RkProcurePaymentImportVO;
import com.bringspring.contract.model.rkprocurepayment.RkProcurePaymentInfoVO;
import com.bringspring.contract.model.rkprocurepayment.RkProcurePaymentListVO;
import com.bringspring.contract.model.rkprocurepayment.RkProcurePaymentPagination;
import com.bringspring.contract.model.rkprocurepayment.RkProcurePaymentPaginationExportModel;
import com.bringspring.contract.model.rkprocurepayment.RkProcurePaymentUpForm;
import com.bringspring.contract.model.rkprocurepaymentplan.RkProcurePaymentPlanCrForm;
import com.bringspring.contract.service.OaContractInternalCrmService;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractPaymentService;
import com.bringspring.contract.service.RkContractProcureRelationService;
import com.bringspring.contract.service.RkContractProcureService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.RkProcureInvoiceService;
import com.bringspring.contract.service.RkProcureManageService;
import com.bringspring.contract.service.RkProcurePaymentPlanService;
import com.bringspring.contract.service.RkProcurePaymentRelationService;
import com.bringspring.contract.service.RkProcurePaymentService;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.MathUtils;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.util.CrmReminderEnum;
import com.bringspring.supplier.entity.SupplierEntity;
import com.bringspring.supplier.service.SupplierService;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u4ed8\u6b3e\u7533\u8bf7"}, value="contract")
@RequestMapping(value={"/api/contract/RkProcurePayment"})
public class RkProcurePaymentController {
    private static final Logger log = LoggerFactory.getLogger(RkProcurePaymentController.class);
    private final Object $lock = new Object[0];
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkProcurePaymentService rkProcurePaymentService;
    @Autowired
    private RkProcurePaymentRelationService rkProcurePaymentRelationService;
    @Autowired
    private RkContractProcureService rkContractProcureService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkContractPaymentService rkContractPaymentService;
    @Autowired
    private RkContractProcureRelationService contractProcureRelationService;
    @Autowired
    private RkProcureInvoiceService rkProcureInvoiceService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private RkProcureManageService rkProcureManageService;
    @Autowired
    private RkProcurePaymentPlanService rkProcurePaymentPlanService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private OaContractInternalCrmService oaContractInternalCrmService;
    @Autowired
    private SupplierService supplierService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody RkProcurePaymentPagination rkProcurePaymentPagination) throws IOException {
        List<RkProcurePaymentEntity> list = this.rkProcurePaymentService.getList(rkProcurePaymentPagination);
        for (RkProcurePaymentEntity rkProcurePaymentEntity : list) {
            rkProcurePaymentEntity.setPayId(this.baseDataUtil.userSelectValueNoAccount(rkProcurePaymentEntity.getPayId()));
        }
        List listVO = JsonUtil.getJsonToList(list, RkProcurePaymentListVO.class);
        for (RkProcurePaymentListVO rkProcurePaymentVO : listVO) {
            List<RkProcurePaymentRelationEntity> listByProcureId = this.rkProcurePaymentRelationService.listByProcureId(rkProcurePaymentVO.getId());
            List collect = listByProcureId.stream().map(RkProcurePaymentRelationEntity::getProcureId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)) {
                List procureInfo = this.rkProcureManageService.listByIds(collect);
                procureInfo.stream().forEach(procure -> {
                    if (ObjectUtil.isNotEmpty((Object)procure.getProjectId())) {
                        RkContractProjectListVO projectInfo = this.rkContractProcureService.getProjectInfo(procure.getProjectId());
                        procure.setProjectList(projectInfo);
                    }
                });
                rkProcurePaymentVO.setProcureInfoList(procureInfo);
                continue;
            }
            rkProcurePaymentVO.setProcureInfoList(new ArrayList<RkProcureManageEntity>());
        }
        for (RkProcurePaymentListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)rkProcurePaymentPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping
    @RepeatSubmit
    @DSTransactional
    public ActionResult create(@RequestBody RkProcurePaymentCrForm rkProcurePaymentCrForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            Map<String, Object> temp;
            OaContractInternalTransactionInfo oaContractInternalTransactionInfo;
            String[] split;
            String flowEngineId = "492250667344205317";
            String mainId = RandomUtil.uuId();
            UserInfo userInfo = this.userProvider.get();
            String organizeId = userInfo.getOrganizeId();
            rkProcurePaymentCrForm.setCompanyId(organizeId);
            rkProcurePaymentCrForm.setPaymentCode(this.baseDataUtil.getBillNumber("paymentCode", Boolean.valueOf(false)));
            RkProcurePaymentEntity entity = (RkProcurePaymentEntity)JsonUtil.getJsonToBean((Object)((Object)rkProcurePaymentCrForm), RkProcurePaymentEntity.class);
            entity.setId(mainId);
            entity.setPayName(this.baseDataUtil.userSelectValue(rkProcurePaymentCrForm.getPayId()));
            if (!ObjectUtil.isEmpty((Object)entity.getPayDepartmentTree()) && (split = entity.getPayDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",")).length > 0) {
                entity.setPayDepartmentTreeName(this.baseDataUtil.comSelectValues(entity.getPayDepartmentTree()));
                entity.setPayDepartmentOne(split[0]);
                entity.setPayDepartmentOneName(this.baseDataUtil.comSelectValues(entity.getPayDepartmentOne()));
                entity.setPayDepartment(split[split.length - 1]);
                entity.setPayDepartmentName(this.baseDataUtil.comSelectValues(entity.getPayDepartment()));
            }
            entity.setSalesPerson(entity.getSalesPerson());
            entity.setCheckAmount(entity.getPaymentAmount());
            List<RkInvoiceVo> invoiceList = rkProcurePaymentCrForm.getInvoiceList();
            String procureId = rkProcurePaymentCrForm.getProcureId();
            if (CollectionUtil.isNotEmpty(invoiceList)) {
                List jsonToList1 = JsonUtil.getJsonToList(invoiceList, RkProcureInvoiceEntity.class);
                jsonToList1.stream().forEach(invoice -> {
                    RkProcureInvoiceEntity invoiceInfo = this.rkProcureInvoiceService.getInfo(invoice.getId());
                    invoice.setCheckInvoice(MathUtils.substract(invoiceInfo.getInvoiceAmount(), invoice.getCheckInvoice()));
                });
                this.rkProcureInvoiceService.updateBatchById(jsonToList1);
                List jsonToList = JsonUtil.getJsonToList(invoiceList, RkProcurePaymentRelationEntity.class);
                jsonToList.stream().forEach(relation -> {
                    relation.setInvoiceId(relation.getId());
                    relation.setCheckInvoice(relation.getCheckInvoice());
                    relation.setPayId(entity.getId());
                    relation.setProcureId(procureId);
                    relation.setId(RandomUtil.uuId());
                    relation.setCreatorTime(new Date());
                    relation.setCreatorUserId(userInfo.getUserId());
                });
                this.rkProcurePaymentRelationService.saveBatch(jsonToList);
            } else {
                RkProcurePaymentRelationEntity relationEntity = new RkProcurePaymentRelationEntity();
                relationEntity.setProcureId(procureId);
                relationEntity.setPayId(entity.getId());
                relationEntity.setId(RandomUtil.uuId());
                relationEntity.setCreatorTime(new Date());
                relationEntity.setCreatorUserId(userInfo.getUserId());
                this.rkProcurePaymentRelationService.save(relationEntity);
            }
            RkProcureManageEntity procureInfo = this.rkProcureManageService.getInfo(procureId);
            entity.setManagerApplyUser(procureInfo.getManagerApplyUser());
            rkProcurePaymentCrForm.setManagerApplyUser(procureInfo.getManagerApplyUser());
            rkProcurePaymentCrForm.setPaymentCompanyId(procureInfo.getPaymentCompanyId());
            entity.setPaymentCompanyId(procureInfo.getPaymentCompanyId());
            if (rkProcurePaymentCrForm.getEnableMark().equals("submit")) {
                entity.setInvoiceAmount(entity.getInvoiceAmount());
                entity.setInvoiceAmountPro(MathUtils.divide(entity.getInvoiceAmount(), procureInfo.getProcureAmount(), 4).multiply(BigDecimal.valueOf(100L)));
                entity.setAccumulateInvoiceAmount(procureInfo.getAccumulateInvoiceAmount());
                entity.setAccumulateInvoicePro(MathUtils.divide(procureInfo.getAccumulateInvoiceAmount(), procureInfo.getProcureAmount(), 4).multiply(BigDecimal.valueOf(100L)));
                entity.setNotInvoiceAmount(MathUtils.substract(procureInfo.getProcureAmount(), entity.getAccumulateInvoiceAmount()));
                entity.setNotInvoicePro(MathUtils.substract(BigDecimal.valueOf(100L), entity.getAccumulateInvoicePro()));
                procureInfo.setAccumulatePaymentAmount(ObjectUtil.isEmpty((Object)procureInfo.getAccumulatePaymentAmount()) ? BigDecimal.valueOf(0L) : procureInfo.getAccumulatePaymentAmount());
                procureInfo.setNotPaymentAmount(MathUtils.add(entity.getPaymentAmount(), procureInfo.getNotPaymentAmount()));
                this.rkProcureManageService.updateById(procureInfo);
                this.rkProcurePaymentService.save(entity);
            } else {
                this.rkProcurePaymentService.save(entity);
            }
            if (rkProcurePaymentCrForm.getEnableMark().equals("submit") && procureInfo.getProcureAmount().compareTo(BigDecimal.ZERO) > 0) {
                List<RkProcurePaymentPlanCrForm> paymentPlanList = rkProcurePaymentCrForm.getPaymentPlanList();
                int count = 0;
                BigDecimal sum = rkProcurePaymentCrForm.getPaymentAmount();
                for (RkProcurePaymentPlanCrForm paymentPlanCrForm : paymentPlanList) {
                    paymentPlanCrForm.setOldPaidAmount(paymentPlanCrForm.getPaidAmount());
                    paymentPlanCrForm.setOldPaidRatio(paymentPlanCrForm.getPaidRatio());
                    if (paymentPlanList.size() > 1) {
                        if (sum.compareTo(paymentPlanCrForm.getPaymentAmount()) > 0) {
                            if (paymentPlanList.size() - 1 == count) {
                                paymentPlanCrForm.setPaidAmount(sum);
                                paymentPlanCrForm.setPaidRatio(MathUtils.divide(paymentPlanCrForm.getPaidAmount(), paymentPlanCrForm.getPaymentAmount(), 2).multiply(BigDecimal.valueOf(100L)));
                                break;
                            }
                            paymentPlanCrForm.setPaidAmount(MathUtils.substract(paymentPlanCrForm.getPaymentAmount(), paymentPlanCrForm.getPaidAmount()));
                            paymentPlanCrForm.setPaidRatio(MathUtils.divide(paymentPlanCrForm.getPaidAmount(), paymentPlanCrForm.getPaymentAmount(), 2).multiply(BigDecimal.valueOf(100L)));
                            sum = sum.subtract(paymentPlanCrForm.getPaidAmount());
                            ++count;
                            continue;
                        }
                        paymentPlanCrForm.setPaidAmount(paymentPlanCrForm.getPaidAmount().add(sum));
                        paymentPlanCrForm.setPaidRatio(MathUtils.divide(paymentPlanCrForm.getPaidAmount(), paymentPlanCrForm.getPaymentAmount(), 2).multiply(BigDecimal.valueOf(100L)));
                        continue;
                    }
                    paymentPlanCrForm.setPaidAmount(rkProcurePaymentCrForm.getPaymentAmount().add(paymentPlanCrForm.getPaidAmount()));
                    paymentPlanCrForm.setPaidRatio(MathUtils.divide(paymentPlanCrForm.getPaidAmount(), paymentPlanCrForm.getPaymentAmount(), 2).multiply(BigDecimal.valueOf(100L)));
                }
                List paymentPlanEntityList = JsonUtil.getJsonToList(paymentPlanList, RkProcurePaymentPlanEntity.class);
                this.rkProcurePaymentPlanService.updateBatchById(paymentPlanEntityList);
            }
            rkProcurePaymentCrForm.setSalesPerson(entity.getSalesPerson());
            rkProcurePaymentCrForm.setContractLevel(entity.getContractLevel());
            rkProcurePaymentCrForm.setProjectManager(entity.getProjectManager());
            rkProcurePaymentCrForm.setProjectManagerName(entity.getProjectManagerName());
            rkProcurePaymentCrForm.setIsInternalContract(procureInfo.getIsInternalContract());
            rkProcurePaymentCrForm.setIsTrustSettlement(procureInfo.getIsTrustSettlement());
            rkProcurePaymentCrForm.setInternalContractId(procureInfo.getInternalContractId());
            rkProcurePaymentCrForm.setInternalContractRemarks(procureInfo.getInternalContractRemarks());
            rkProcurePaymentCrForm.setPartyA(procureInfo.getPartyA());
            rkProcurePaymentCrForm.setManagerType(procureInfo.getManagerType() == null ? "delivery" : procureInfo.getManagerType());
            if (ObjectUtil.isNotEmpty((Object)procureInfo.getInternalContractId()) && ObjectUtil.isNotEmpty((Object)(oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean(temp = this.oaContractInternalCrmService.getInfoById(procureInfo.getInternalContractId()), OaContractInternalTransactionInfo.class)))) {
                rkProcurePaymentCrForm.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
                rkProcurePaymentCrForm.setInteralContractApplyUser(oaContractInternalTransactionInfo.getApplyUserId());
            }
            FlowUtil.saveOrSubmit((String)rkProcurePaymentCrForm.getTaskId(), (String)flowEngineId, (String)rkProcurePaymentCrForm.getTemplateId(), (String)mainId, (Object)((Object)rkProcurePaymentCrForm), (Integer)rkProcurePaymentCrForm.getStatus(), (String)(procureInfo.getProcureCode() + "-" + procureInfo.getProcureName()));
            if (rkProcurePaymentCrForm.getStatus() == 0) {
                return ActionResult.success((String)CrmReminderEnum.TS.getType());
            }
            return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
        }
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<RkProcurePaymentInfoVO> info(@PathVariable(value="id") String id) {
        Map<String, Object> temp;
        OaContractInternalTransactionInfo oaContractInternalTransactionInfo;
        RkProcurePaymentEntity entity = this.rkProcurePaymentService.getInfo(id);
        RkProcurePaymentInfoVO vo = (RkProcurePaymentInfoVO)JsonUtil.getJsonToBean((Object)entity, RkProcurePaymentInfoVO.class);
        String[] split = entity.getPayDepartmentTree().replace("\"", "").replace("[", "").replace("]", "").split(",");
        vo.setPayDepartmentTree(Arrays.asList(split));
        vo.setPayName(this.baseDataUtil.userSelectValueNoAccount(entity.getPayId()));
        List<RkProcurePaymentRelationEntity> listByProcureId = this.rkProcurePaymentRelationService.listByProcureId(id);
        List collect2 = listByProcureId.stream().map(RkProcurePaymentRelationEntity::getInvoiceId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(collect2)) {
            List invoiceInfo = this.rkProcureInvoiceService.listByIds(collect2);
            List<RkProcureInvoiceEntity> complete = invoiceInfo.stream().filter(invoice -> invoice.getEnableMark().equals("complete") || "-1".equals(invoice.getEnableMark())).collect(Collectors.toList());
            complete.stream().forEach(invoice -> invoice.setInvoiceTypeName(this.baseDataUtil.getDictName(invoice.getInvoiceType(), "invoiceRegister")));
            vo.setInvoiceList(complete);
        } else {
            vo.setInvoiceList(new ArrayList<RkProcureInvoiceEntity>());
        }
        RkProcureManageEntity procureInfo = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)entity.getProcureId()));
        procureInfo.setAccumulatePaymentAmount(procureInfo.getAccumulatePaymentAmount());
        procureInfo.setApplyName(this.baseDataUtil.userSelectValueNoAccount(procureInfo.getApplyId()));
        procureInfo.setNotPaymentAmount(procureInfo.getNotPaymentAmount());
        procureInfo.setPaymentMethodTypeName(this.baseDataUtil.getDictName(procureInfo.getPaymentMethodType(), Constants.PROCURE_PAYMENT_CODE));
        procureInfo.setInvoiceTypeName(this.baseDataUtil.getDictName(procureInfo.getInvoiceType(), Constants.PROCURE_INVOICE_CODE));
        procureInfo.setInvoiceTaxName(this.baseDataUtil.getDictName(procureInfo.getInvoiceTax(), Constants.CONTRACT_TAX_RATE_DICT_ID));
        List<RkContractPaymentEntity> listByContractId = this.rkContractPaymentService.getListByContractId(procureInfo.getId());
        List jsonToList = JsonUtil.getJsonToList(listByContractId, RkContractPaymentListVO.class);
        procureInfo.setPaymentMethodList(jsonToList);
        if (ObjectUtil.isNotEmpty((Object)procureInfo.getProjectId())) {
            RkContractProjectListVO projectInfo = this.rkContractProcureService.getProjectInfo(procureInfo.getProjectId());
            procureInfo.setProjectList(projectInfo);
        }
        if (ObjectUtil.isNotEmpty((Object)procureInfo.getSupplierId())) {
            SupplierEntity supplier = this.supplierService.getInfo(procureInfo.getSupplierId());
            procureInfo.setBankFirmCode(supplier.getBankFirmCode());
        }
        vo.setProcureInfo(procureInfo);
        vo.setIsInternalContract(procureInfo.getIsInternalContract());
        vo.setIsTrustSettlement(procureInfo.getIsTrustSettlement());
        vo.setInternalContractId(procureInfo.getInternalContractId());
        vo.setInternalContractRemarks(procureInfo.getInternalContractRemarks());
        vo.setPartyA(procureInfo.getPartyA());
        if (ObjectUtil.isNotEmpty((Object)procureInfo.getInternalContractId()) && ObjectUtil.isNotEmpty((Object)(oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean(temp = this.oaContractInternalCrmService.getInfoById(procureInfo.getInternalContractId()), OaContractInternalTransactionInfo.class)))) {
            vo.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
            vo.setInteralContractApplyUser(oaContractInternalTransactionInfo.getApplyUserId());
        }
        vo.setPartyAName(this.baseDataUtil.getDictName(procureInfo.getPartyA(), "ContractInternalTransactionSignSubject"));
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatSubmit
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody RkProcurePaymentUpForm rkProcurePaymentUpForm) throws DataException, WorkFlowException {
        Object object = this.$lock;
        synchronized (object) {
            String flowEngineId = "492250667344205317";
            RkProcurePaymentEntity entity = this.rkProcurePaymentService.getInfo(id);
            if (entity != null) {
                Map<String, Object> temp;
                OaContractInternalTransactionInfo oaContractInternalTransactionInfo;
                RkProcurePaymentEntity subentity = (RkProcurePaymentEntity)JsonUtil.getJsonToBean((Object)((Object)rkProcurePaymentUpForm), RkProcurePaymentEntity.class);
                RkProcureManageEntity procureInfo = this.rkProcureManageService.getInfo(rkProcurePaymentUpForm.getProcureId());
                subentity.setSalesPerson(subentity.getSalesPerson());
                rkProcurePaymentUpForm.setManagerType(procureInfo.getManagerType() == null ? "delivery" : procureInfo.getManagerType());
                rkProcurePaymentUpForm.setManagerApplyUser(procureInfo.getManagerApplyUser());
                this.rkProcurePaymentService.updatePayment(id, rkProcurePaymentUpForm);
                rkProcurePaymentUpForm.setContractLevel(entity.getContractLevel());
                rkProcurePaymentUpForm.setProjectManager(entity.getProjectManager());
                rkProcurePaymentUpForm.setProjectManagerName(entity.getProjectManagerName());
                rkProcurePaymentUpForm.setSalesPerson(subentity.getSalesPerson());
                rkProcurePaymentUpForm.setIsInternalContract(procureInfo.getIsInternalContract());
                rkProcurePaymentUpForm.setIsTrustSettlement(procureInfo.getIsTrustSettlement());
                rkProcurePaymentUpForm.setInternalContractId(procureInfo.getInternalContractId());
                rkProcurePaymentUpForm.setInternalContractRemarks(procureInfo.getInternalContractRemarks());
                rkProcurePaymentUpForm.setPartyA(procureInfo.getPartyA());
                rkProcurePaymentUpForm.setPaymentCompanyId(procureInfo.getPaymentCompanyId());
                subentity.setPaymentCompanyId(procureInfo.getPaymentCompanyId());
                if (ObjectUtil.isNotEmpty((Object)procureInfo.getInternalContractId()) && ObjectUtil.isNotEmpty((Object)(oaContractInternalTransactionInfo = (OaContractInternalTransactionInfo)JsonUtil.getJsonToBean(temp = this.oaContractInternalCrmService.getInfoById(procureInfo.getInternalContractId()), OaContractInternalTransactionInfo.class)))) {
                    rkProcurePaymentUpForm.setServiceDepartmentManager(oaContractInternalTransactionInfo.getServiceUser());
                    rkProcurePaymentUpForm.setInteralContractApplyUser(oaContractInternalTransactionInfo.getApplyUserId());
                }
                FlowUtil.saveOrSubmit((String)rkProcurePaymentUpForm.getTaskId(), (String)flowEngineId, (String)rkProcurePaymentUpForm.getTemplateId(), (String)id, (Object)((Object)rkProcurePaymentUpForm), (Integer)rkProcurePaymentUpForm.getStatus(), (String)(procureInfo.getProcureCode() + "-" + procureInfo.getProcureName()));
                if (rkProcurePaymentUpForm.getStatus() == 0) {
                    return ActionResult.success((String)CrmReminderEnum.TS.getType());
                }
                return ActionResult.success((String)CrmReminderEnum.SUCCEED.getType());
            }
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    @DeleteMapping(value={"/{id}"})
    @RepeatSubmit
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        RkProcurePaymentEntity entity = this.rkProcurePaymentService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.rkProcurePaymentService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult<Object> Uploader() {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().endsWith(".xlsx") || file.getOriginalFilename().endsWith(".xls")) {
            String filePath = XSSEscape.escape((String)this.configValueUtil.getTemporaryFilePath());
            String fileName = XSSEscape.escape((String)(RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file)));
            FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
            try {
                UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)(filePath + fileName), (String)"temporary", (String)fileName);
            }
            catch (IOException e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            DownloadVO vo = DownloadVO.builder().build();
            vo.setName(fileName);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u91c7\u8d2d\u4ed8\u6b3e\u5bfc\u5165\u6a21\u677f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u91c7\u8d2d\u4ed8\u6b3e\u5bfc\u5165\u6a21\u677f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List fileImportList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, RkProcurePaymentImportVO.class);
        if (CollectionUtil.isEmpty((Collection)fileImportList)) {
            return ActionResult.fail((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fileImportList.size() > 100) {
            return ActionResult.fail((String)"\u6700\u591a\u5bfc\u5165\u6570\u636e100\u6761");
        }
        Map<String, Object> map = this.rkProcurePaymentService.importPreview(fileImportList);
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<RkProcurePaymentImportReturnVO> ImportData(@RequestBody RkProcurePaymentImportVO data) throws DataException {
        List dataList = JsonUtil.getJsonToList(data.getList(), RkProcurePaymentImportVO.class);
        RkProcurePaymentImportReturnVO result = this.rkProcurePaymentService.importData(dataList);
        return ActionResult.success((Object)result);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(RkProcurePaymentPaginationExportModel rkProcurePaymentPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)rkProcurePaymentPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        RkProcurePaymentPagination paymentPagination = (RkProcurePaymentPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)rkProcurePaymentPaginationExportModel), RkProcurePaymentPagination.class));
        String organizeId = this.userProvider.get().getOrganizeId();
        List<RkProcurePaymentEntity> list = this.rkProcurePaymentService.getTypeList(paymentPagination, rkProcurePaymentPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, RkProcurePaymentExportVO.class);
        for (RkProcurePaymentExportVO rkProcurePaymentExportVO : listVO) {
            RkProcureManageEntity procureInfo = (RkProcureManageEntity)this.rkProcureManageService.getById((Serializable)((Object)rkProcurePaymentExportVO.getProcureId()));
            if (ObjectUtil.isNotEmpty((Object)procureInfo)) {
                rkProcurePaymentExportVO.setProcureCode(procureInfo.getProcureCode());
                rkProcurePaymentExportVO.setProcureName(procureInfo.getProcureName());
                rkProcurePaymentExportVO.setProcureAmount(procureInfo.getProcureAmount());
                rkProcurePaymentExportVO.setSupplierAccount(procureInfo.getSupplierAccount());
                rkProcurePaymentExportVO.setSupplierName(procureInfo.getSupplierName());
                rkProcurePaymentExportVO.setSupplierBank(procureInfo.getSupplierBank());
                rkProcurePaymentExportVO.setProjectManagerName(procureInfo.getProjectManagerName());
                rkProcurePaymentExportVO.setProcureDate(procureInfo.getApplyDate());
                rkProcurePaymentExportVO.setPaymentMethodType(this.baseDataUtil.getDictName(procureInfo.getPaymentMethodType(), "paymentMethod"));
                RkContractProjectEntity projectInfo = (RkContractProjectEntity)this.rkContractProjectService.getById((Serializable)((Object)procureInfo.getProjectId()));
                if (ObjectUtil.isNotEmpty((Object)projectInfo)) {
                    rkProcurePaymentExportVO.setProjectCode(projectInfo.getProjectCode());
                    rkProcurePaymentExportVO.setProjectName(projectInfo.getProjectName());
                    rkProcurePaymentExportVO.setProjectStatus(this.baseDataUtil.getDictName(projectInfo.getState(), "projectState"));
                    RkContractEntity contractInfo = (RkContractEntity)this.rkContractService.getById((Serializable)((Object)projectInfo.getContractId()));
                    if (ObjectUtil.isNotEmpty((Object)contractInfo)) {
                        rkProcurePaymentExportVO.setContractCode(contractInfo.getContractCode());
                        rkProcurePaymentExportVO.setContractName(contractInfo.getContractName());
                        rkProcurePaymentExportVO.setContractAmount(contractInfo.getContractAmount().toString());
                        rkProcurePaymentExportVO.setSalesPerson(this.baseDataUtil.userSelectValue(contractInfo.getSalerId()));
                        rkProcurePaymentExportVO.setSalesDepartmentName(contractInfo.getDepartmentName());
                        if (!ObjectUtil.isEmpty((Object)contractInfo.getIsAgent()) && contractInfo.getIsAgent() == 1) {
                            rkProcurePaymentExportVO.setAgentName(((RkAgentEntity)this.rkAgentService.getById((Serializable)((Object)contractInfo.getAgentId()))).getName());
                        } else {
                            rkProcurePaymentExportVO.setAgentName(((CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)contractInfo.getCustomerId()))).getName());
                        }
                    }
                }
            }
            rkProcurePaymentExportVO.setEnableMark(StringUtils.isEmpty((String)rkProcurePaymentExportVO.getEnableMark()) ? "\u672a\u63d0\u4ea4" : (rkProcurePaymentExportVO.getEnableMark().equals("1") ? "\u5ba1\u6838\u4e2d" : (rkProcurePaymentExportVO.getEnableMark().equals("3") ? "\u64a4\u56de\u4e2d" : (rkProcurePaymentExportVO.getEnableMark().equals("save") ? "\u672a\u63d0\u4ea4" : (rkProcurePaymentExportVO.getEnableMark().equals("complete") ? "\u5ba1\u6838\u7ed3\u675f" : (rkProcurePaymentExportVO.getEnableMark().equals("2") ? "\u5386\u53f2\u6570\u636e" : ""))))));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)rkProcurePaymentPaginationExportModel.getSelectKey()) ? rkProcurePaymentPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block76: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "paymentCode": {
                        entitys.add(new ExcelExportEntity("\u4ed8\u6b3e\u5355\u636e\u53f7 ", (Object)"paymentCode"));
                        continue block76;
                    }
                    case "payName": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u4eba", (Object)"payName"));
                        continue block76;
                    }
                    case "payDepartmentName": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u90e8\u95e8", (Object)"payDepartmentName"));
                        continue block76;
                    }
                    case "supplierName": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u540d\u79f0", (Object)"supplierName"));
                        continue block76;
                    }
                    case "paymentAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u6b21\u7533\u8bf7\u91d1\u989d", (Object)"paymentAmount"));
                        continue block76;
                    }
                    case "procureCode": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u53f7", (Object)"procureCode"));
                        continue block76;
                    }
                    case "procureName": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u540d\u79f0", (Object)"procureName"));
                        continue block76;
                    }
                    case "supplierBank": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u94f6\u884c", (Object)"supplierBank"));
                        continue block76;
                    }
                    case "supplierAccount": {
                        entitys.add(new ExcelExportEntity("\u4f9b\u5e94\u5546\u8d26\u53f7", (Object)"supplierAccount"));
                        continue block76;
                    }
                    case "procureAmount": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u91d1\u989d", (Object)"procureAmount"));
                        continue block76;
                    }
                    case "payDate": {
                        entitys.add(new ExcelExportEntity("\u7533\u8bf7\u65e5\u671f", (Object)"payDate"));
                        continue block76;
                    }
                    case "contractCode": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u7f16\u53f7", (Object)"contractCode"));
                        continue block76;
                    }
                    case "contractName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u540d\u79f0", (Object)"contractName"));
                        continue block76;
                    }
                    case "accumulatePaymentAmount": {
                        entitys.add(new ExcelExportEntity("\u5df2\u4ed8\u6b3e\u91d1\u989d", (Object)"accumulatePaymentAmount"));
                        continue block76;
                    }
                    case "accumulatePaymentPro": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u5408\u540c\u4ed8\u6b3e\u6bd4\u4f8b", (Object)"accumulatePaymentPro"));
                        continue block76;
                    }
                    case "accumulateInvoiceAmount": {
                        entitys.add(new ExcelExportEntity("\u7d2f\u8ba1\u56de\u53d1\u7968\u91d1\u989d", (Object)"accumulateInvoiceAmount"));
                        continue block76;
                    }
                    case "accumulateInvoicePro": {
                        entitys.add(new ExcelExportEntity("\u56de\u53d1\u7968\u6bd4\u4f8b", (Object)"accumulateInvoicePro"));
                        continue block76;
                    }
                    case "procureDate": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u7533\u8bf7\u65e5\u671f", (Object)"procureDate"));
                        continue block76;
                    }
                    case "paymentMethodType": {
                        entitys.add(new ExcelExportEntity("\u652f\u4ed8\u65b9\u5f0f", (Object)"paymentMethodType"));
                        continue block76;
                    }
                    case "notPaymentAmount": {
                        entitys.add(new ExcelExportEntity("\u5ba1\u6279\u4e2d\u4ed8\u6b3e\u91d1\u989d", (Object)"notPaymentAmount"));
                        continue block76;
                    }
                    case "residuePaymentAmount": {
                        entitys.add(new ExcelExportEntity("\u5269\u4f59\u4ed8\u6b3e\u91d1\u989d", (Object)"residuePaymentAmount"));
                        continue block76;
                    }
                    case "invoiceAmount": {
                        entitys.add(new ExcelExportEntity("\u672c\u6b21\u53d1\u7968\u91d1\u989d", (Object)"invoiceAmount"));
                        continue block76;
                    }
                    case "agentName": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u5bf9\u8c61 ", (Object)"agentName"));
                        continue block76;
                    }
                    case "contractAmount": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5408\u540c\u91d1\u989d ", (Object)"contractAmount"));
                        continue block76;
                    }
                    case "enableMark": {
                        entitys.add(new ExcelExportEntity("\u5ba1\u6279\u72b6\u6001 ", (Object)"enableMark"));
                        continue block76;
                    }
                    case "paymentIllustrate": {
                        entitys.add(new ExcelExportEntity("\u91c7\u8d2d\u4ed8\u6b3e\u8bf4\u660e ", (Object)"paymentIllustrate"));
                        continue block76;
                    }
                    case "projectCode": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7f16\u53f7 ", (Object)"projectCode"));
                        continue block76;
                    }
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0 ", (Object)"projectName"));
                        continue block76;
                    }
                    case "salesDepartmentName": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u90e8\u95e8 ", (Object)"salesDepartmentName"));
                        continue block76;
                    }
                    case "salesPerson": {
                        entitys.add(new ExcelExportEntity("\u9500\u552e\u5458 ", (Object)"salesPerson"));
                        continue block76;
                    }
                    case "projectManagerName": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u7ecf\u7406 ", (Object)"projectManagerName"));
                        continue block76;
                    }
                    case "projectStatus": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u72b6\u6001 ", (Object)"projectStatus"));
                        continue block76;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u91c7\u8d2d\u4ed8\u6b3e\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u91c7\u8d2d\u4ed8\u6b3e\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/getPaymentListByProcureId/{id}"})
    public ActionResult getPaymentListByProcureId(@PathVariable(value="id") String id) {
        List<RkProcurePaymentRelationEntity> list = this.rkProcurePaymentRelationService.listByPayId(id);
        if (CollectionUtil.isNotEmpty(list)) {
            List payIds = list.stream().map(RkProcurePaymentRelationEntity::getPayId).collect(Collectors.toList());
            List paymentList = this.rkProcurePaymentService.listByIds(payIds);
            List listVO = JsonUtil.getJsonToList((Object)paymentList, RkProcurePaymentListVO.class);
            for (RkProcurePaymentListVO rkContractPaymentVO : listVO) {
                FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)rkContractPaymentVO.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
                if (flowTaskEntity != null) {
                    rkContractPaymentVO.setFlowState(flowTaskEntity.getStatus());
                    continue;
                }
                rkContractPaymentVO.setFlowState(null);
            }
            return ActionResult.success((Object)listVO);
        }
        List listVO = CollectionUtil.list((boolean)false);
        return ActionResult.success((Object)listVO);
    }
}

